#ifndef BUTTON_H
# define BUTTON_H
# ifdef __cplusplus
 extern "C" {
# endif

# include <standard.h>
# include <win_raw.h>
# include <tdispatc.h>

        /* button arten */
# define TEXT 1
# define CHECK 2
# define BIT_MAP 3
# define EDIT_TEXT 4
# define MEMBILD 5

        /* button status */
# define INITIALISING 0
# define RELEASED 1
# define PRESSED 2
# define FORBIDDEN 3

        /* button schalt arten */
# define SWITCH_ON_RELEASED 0
# define SWITCH_ON_PRESSED  1
# define CALL_FUNCTION_ONLY 2

#define DELETE_BUTTON 1
#define REMOVE_BUTTON 2

BUTTON_LISTEN_ELEMENT *is_mouse_on_button(WINDOW_LISTEN_ELEMENT *test_window);
BUTTON *make_mem_bild_button(MEM_BILD *bild, T_INT background, T_INT shade1_col, T_INT shade2_col, T_INT light1_col, T_INT light2_col, T_INT line_width, T_INT taste, T_INT schalt_art);
BUTTON *make_bitmap_button(T_PCHAR name, T_INT background, T_INT shade1_col, T_INT shade2_col, T_INT light1_col, T_INT light2_col, T_INT line_width, T_INT taste, T_INT schalt_art);
BUTTON *make_edit_text_button_(T_PCHAR text, T_INT maxlen, T_INT col_text, T_INT col_back, T_INT shade1_col, T_INT shade2_col, T_INT light1_col, T_INT light2_col, T_INT line_width, T_INT taste, T_INT schalt_art, T_INT thickness_x, T_INT thickness_y);
BUTTON *make_text_button_(T_PCHAR text, T_INT col_text, T_INT col_back, T_INT shade1_col, T_INT shade2_col, T_INT light1_col, T_INT light2_col, T_INT line_width, T_INT taste, T_INT schalt_art, T_INT thickness_x, T_INT thickness_y);
BUTTON *make_check_button(T_INT col_text, T_INT col_back, T_INT shade1_col, T_INT shade2_col, T_INT light1_col, T_INT light2_col, T_INT line_width, T_INT taste, T_INT size_x, T_INT size_y);

#define make_edit_text_button(text,maxlen,col_text,col_back,shade1_col,shade2_col,light1_col,light2_col,line_width,taste,schalt_art) \
        make_edit_text_button_(text,maxlen,col_text,col_back,shade1_col,shade2_col,light1_col,light2_col,line_width,taste,schalt_art,8,2);

#define make_text_button(t,ct,cb,s1,s2,l1,l2,w,k,a) make_text_button_(t,ct,cb,s1,s2,l1,l2,w,k,a,8,2)
//#define  make_text_button(text,col_text,col_back,shade1_col,shade2_col,light1_col,light2_col,line_width,taste,schalt_art)
//        make_text_button_(text,col_text,col_back,shade1_col,shade2_col,light1_col,light2_col,line_width,taste,schalt_art,16,4)

#define make_small_text_button(text,col_text,col_back,shade1_col,shade2_col,light1_col,light2_col,line_width,taste,schalt_art) \
             make_text_button_(text,col_text,col_back,shade1_col,shade2_col,light1_col,light2_col,line_width,taste,schalt_art,0,0)

T_INT is_mouse_on_this_button(WINDOW_LISTEN_ELEMENT *this_window,BUTTON_LISTEN_ELEMENT *this_button);
T_VOID free_button(BUTTON *button);

T_INT move_button(WINDOW_LISTEN_ELEMENT *this_window, BUTTON *this_button, T_INT x_off, T_INT y_off);
T_INT add_button(WINDOW_LISTEN_ELEMENT *this_window, BUTTON *this_button, T_INT x_off, T_INT y_off, T_INT b_id);
T_VOID delete_all_buttons(WINDOW_LISTEN_ELEMENT *this_window);
T_INT delete_button(WINDOW_LISTEN_ELEMENT *this_window, BUTTON *button, T_INT flag);
T_INT delete_button_id(WINDOW_LISTEN_ELEMENT *this_window, T_INT id, T_INT flag);

#define add_bbutton(button,x,y,id) add_button(NULL,button,x,y,id)
#define add_wbutton(window,button,x,y,id) add_button(window,button,x,y,id)

#define delete_bbutton_id(id) delete_button_id(NULL,id,DELETE_BUTTON)
#define delete_wbutton_id(window,id) delete_button_id(window,id,DELETE_BUTTON)

#define remove_bbutton_id(id) delete_button_id(NULL,id,REMOVE_BUTTON)
#define remove_wbutton_id(window,id) delete_button_id(window,id,REMOVE_BUTTON)

#define delete_all_bbuttons() delete_all_buttons(NULL)
#define delete_all_wbuttons(window) delete_all_buttons(window)

#define delete_bbutton(button) delete_button(NULL,button,DELETE_BUTTON)
#define delete_wbutton(window,button) delete_button(window,button,DELETE_BUTTON)

#define remove_bbutton(button) delete_button(NULL,button,REMOVE_BUTTON)
#define remove_wbutton(window,button) delete_button(window,button,REMOVE_BUTTON)


/* globale Variable */
extern T_INT button_error;
extern T_LISTE *button_first;
extern T_LISTE *button_last;

extern T_INT button_color1;
extern T_INT button_color2;
extern T_INT button_color3;
extern T_INT button_color4;
extern T_INT button_color5;
extern T_INT button_color6;

# ifdef __cplusplus
        }
# endif

#endif
