#if !defined DOSMEM_H
    #define DOSMEM_H
#include "standard.h"

# ifdef __cplusplus
 extern "C" {
# endif


typedef struct DOS4GW_RMREGS
{
        T_ULONG           edi;
        T_ULONG           esi;
        T_ULONG           ebp;
        T_ULONG           reserved;
        T_ULONG           ebx;
        T_ULONG           edx;
        T_ULONG           ecx;
        T_ULONG           eax;
        T_UWORD           flags;
        T_UWORD           es,ds,fs,gs,ip,cs,sp,ss;
} DOS4GW_RMREGS;

typedef struct RealPointer
{
        T_UWORD                   Segment;
        T_UWORD                   Selector;
} REALPTR;

/* Function prototypes */

void far* fDOSmalloc(REALPTR * rp,T_ULONG bytes_to_allocate);
T_VOID fDOSfree(REALPTR * rp);

# ifdef __cplusplus
}
# endif

#endif

/* End of UTIL.H */


