#ifndef EDIT_H
#define EDIT_H

# ifdef __cplusplus
 extern "C" {
# endif


#include "standard.h"
#include "file.h"
#include "help.h"
#include "vesa.h" // font

/* MAX len of an edit line */
#define EDIT_LINE_LEN 256

/* what kind of cursor should be set? */
#define EDIT_CURSOR_NOT_INVERS 0
#define EDIT_CURSOR_INVERS     1

/* modes of editor */
#define EDIT_MODE_INSERT       0
#define EDIT_MODE_OVERWRITE    1

/* return codes of user defines key functions */
#define EDIT_DO_NOTHING        1
#define EDIT_CONTINUE          2
#define EDIT_REDRAW_LINE       4
#define EDIT_CURSOR_TO_END     8
#define EDIT_QUIT             16

/* when should a user defined key function be invoked */
#define BEFORE_EDIT 0
#define AFTER_EDIT 1

/* what kind of edit object should be created */
#define EDIT_WITH_SAVE          1
#define EDIT_WITH_LOAD          2
#define EDIT_LOG                4
#define EDIT_EDIT               8
#define EDIT_NO_LOG_FILE        16
#define EDIT_START              16384
#define EDIT_REDRAW             32768

typedef struct
{
 T_INT   len_of_mem;
 T_INT   len_pixel;
 T_INT   len_chars;
 T_INT   hight_pixel;
 T_INT   flag;
 T_INT   mark_start;
 T_INT   mark_end;
 T_PCHAR text;
} EDIT_ZEILE;

typedef struct
{
 T_INT (*key_funktion)(T_VOID *parameter);
 T_INT key;
 T_INT mode;
} KEY_FUNCTION;

typedef struct
{
 WINDOW_LISTEN_ELEMENT *window;
 T_PCHAR filename;
 T_FONT  *font;
 T_INT   flag;
 FILE    *handle_out;
 T_INT   x_scroll;// x scroll steps
 T_INT   y_scroll;// y scroll steps
 T_INT   x_max;// virtuelle x max groesse
 T_INT   y_max;// virtuelle y max groesse
 T_INT   len_x; // breite eines Buchstabens
 T_INT   len_y; // hoehe eines Buchstabens
 T_INT   virtual_b;
 T_INT   virtual_h;
//// nur fuer redraw!!!
//// keine Angabe, wo der Text mit welcher Zeile am Bildschirm anfaengt!
 T_INT   x_first_char; // erste Spalte des Character arrays auf dem window (links/oben)
 T_INT   y_first_char; // erste Zeile des Character arrays auf dem window (links/oben)
 T_INT   x_start; // ab welcher PIXEL im file wird auf dem fenster ausgegeben (links/oben im fenster)
 T_INT   y_start; // ab welcher PIXEL im file wird auf dem fenster ausgegeben
 T_INT   x_ausgabe_start; // auf dem Fenster auch in PIXEL (koordinaten im fenster)
 T_INT   y_ausgabe_start; // auf dem Fenster auch in PIXEL (koordinaten im fenster)
 T_INT   x_ausgabe_end;   // auf dem Fenster auch in PIXEL (koordinaten im fenster)
 T_INT   y_ausgabe_end;   // auf dem Fenster auch in PIXEL (koordinaten im fenster)
////
 T_INT   window_id;
 T_INT   zeilen_anzahl;
 T_LISTE *text_zeile_erste;
 T_LISTE *text_zeile_letzte;
 T_INT   (*old_destructor)(PARAMETER *parameter);
 T_INT   (*old_update_funktion)(T_INT, T_PVOID);
//////////////////////
// From here edit variables only
 T_SINT   cpos_x; // cursor position x (in string)
 T_SINT   cpos_y; // cursor position y (in line)
 T_INT    mode;
 T_INT    changed;
 T_INT    autosave;
 T_INT    lock;
 EDIT_ZEILE *cursor_line;
 T_LISTE *help_word_erste;
 T_LISTE *help_word_letzte;
 T_LISTE *key_functions_erste;
 T_LISTE *key_functions_letzte;
//////////////////////
// for cursor marking...
 T_INT   is_marking;
 T_SINT  m_startx;
 T_SINT  m_starty;
 T_SINT  m_endx;
 T_SINT  m_endy;
//////////////////////
} EDIT_ELEMENT;

T_INT edit(WINDOW_LISTEN_ELEMENT *window, T_PCHAR help_datei, T_INT flags);
T_INT edit_log_add(WINDOW_LISTEN_ELEMENT *window, T_PCHAR text);
KEY_FUNCTION *insert_edit_key_funktion( WINDOW_LISTEN_ELEMENT *window, T_INT key, T_INT mode, T_INT (*zeiger_auf_funktion)(T_VOID *) );
T_INT remove_edit_key_funktion(WINDOW_LISTEN_ELEMENT *window, T_INT (*zeiger_auf_funktion)(T_VOID *) );
T_INT edit_set_help_table(WINDOW_LISTEN_ELEMENT *window, T_PCHAR filename);

extern T_INT edit_mode;

# ifdef __cplusplus
}
# endif

#endif