#ifndef FILE_H
# define FILE_H

# ifdef __cplusplus
 extern "C" {
# endif

#include <direct.h>

#include "standard.h"



# define GERAETE_BEZEICHNUNG 0x19
# define AKTUELLES_VERZEICHNIS 0x47
# define UNTERVERZEICHNIS_SETZEN 0x3b
# define IOCTL 0x44
# define MEDIUM_WECHSELBAR 0x08
# define LAUFWERKTYP 0x15
# define LAUFWERK_WECHSELN 0x0e
# define DEVICE_REMOTE 0x09

# define F_FILE_BUFFER_GROESSE (8192*8)

# define FROM_FILE_END 2
# define FROM_FILE_HERE 1
# define FROM_FILE_START 0

#define T_PATH_MAX 257

 typedef struct
 {
  DIR     datei;
  T_PVOID naechste_datei;
  T_PVOID letzte_datei;
 } DATEI_LISTE;

 typedef struct
 {
  T_INT  anzahl_eintraege;
  DIR    file[];
 } DIR_ARRAY;

 /* typedef der neuen Filestructur */
 typedef struct
 {
  T_INT                handle;
  T_UCHAR              buffer[F_FILE_BUFFER_GROESSE];
  T_INT                modus;
  T_INT                position;
  T_INT                ende_erreicht;
  T_INT                anzahl_in_buffer;
 }F_FILE;

/* typedefs */
 typedef struct
 {
  T_UINT   size;
  T_UINT   position;
  T_PUCHAR mem;
 } M_FILE;
 #define M_PFILE M_FILE *

/* Exportierte Funktionen */

 DIR_ARRAY      *file_get_dir(T_PCHAR pfad);
 T_BYTE          change_drive(T_BYTE drive);
 T_PCHAR         get_current_path(T_VOID);
 T_VOID          check_drives(T_PCHAR drives);
 T_INT           change_directory(T_PCHAR path);
 T_INT           drive_check(T_BYTE drive);

/* globale funktionen */
 F_FILE *f_open(T_PCHAR filename, T_INT modus);
 T_INT   f_close(F_FILE *file);
 T_INT   f_read(F_FILE *file, T_PCHAR buffer, T_INT anzahl);
 T_INT   f_write(F_FILE *file, T_PCHAR buffer, T_INT anzahl);
 T_INT   f_write_buffer(F_FILE *file);
 T_INT   f_begin( F_FILE *file );
 T_INT   f_end( F_FILE *file );
 T_LONG  f_rewind( F_FILE *file, T_LONG offset );
 T_LONG  f_forward( F_FILE *file, T_LONG offset );
 T_INT   f_file_exist(T_PCHAR filename);
 T_INT   m_read(M_PFILE mfile, T_PCHAR dest, T_INT size);
 T_SINT  m_rewind(M_PFILE mfile, T_INT offset );

#define m_pread(mfile,m_text,len) \
 *((T_PCHAR *)m_text)=(mfile)->mem+(mfile)->position;\
 (mfile)->position+=(len);

/* globale variablen */
 extern T_INT file_error;

# ifdef __cplusplus
 }
# endif

#endif
