#ifndef HELP_H
#define HELP_H

# ifdef __cplusplus
 extern "C" {
# endif


#include "standard.h"
#include "file.h"

typedef struct
{
 T_PCHAR keyword;
 T_PCHAR help_name;
} HELP_WORD;

typedef struct
{
 T_PCHAR link;
 T_INT   line; // linenumber for jump (PIXEL based)
 WINDOW_LISTEN_ELEMENT *window;
 BUTTON_LISTEN_ELEMENT *button_element;
 BUTTON  *button;
 T_PCHAR filename;
 T_PCHAR complete_compiled_name;
 M_FILE  *m_file; // bei groesser als window helps steht hier das compilierte help file im speicher
 T_INT   x_scroll;// x scroll steps
 T_INT   y_scroll;// y scroll steps
 T_INT   x_max;// virtuelle x max groesse
 T_INT   y_max;// virtuelle y max groesse
 T_INT   virtual_b;
 T_INT   virtual_h;
 T_INT   button_art;
 T_INT   button_id;
 T_INT   window_id;
} HELP_BUTTON;

#define MAX_TEXT_LEN 2048

// button Arten im help file, ge ODER t (bis auf close/link)
#define HELP_BUTTON_LINK           1
#define HELP_BUTTON_CLOSE          2
#define HELP_BUTTON_TEXT           4
#define HELP_BUTTON_SMALL_TEXT     8
#define HELP_BUTTON_PICTURE       16
#define HELP_BUTTON_DOWN          32
#define HELP_BUTTON_UP            64
#define HELP_BUTTON_PAGE_DOWN     128
#define HELP_BUTTON_PAGE_UP       256
#define HELP_BUTTON_LEFT          512
#define HELP_BUTTON_RIGHT         1024
#define HELP_BUTTON_JUMP          2048 // to a location in a file
                                       // syntax "filename.ext#linenumber"
                                       // or     "#linenumber" for this file
#define HELP_BUTTON_USER_FUNCTION 4096
#define HELP_BUTTON_DONT_CLOSE 8192

# define H_INVALID_KEY          0
# define H_WIN_SIZE_X           1
# define H_WIN_SIZE_Y           2
# define H_WIN_POS_X            3
# define H_WIN_POS_Y            4
# define H_WIN_BACK_COLOR       5
# define H_DRAW_NOW             6
# define H_POS_X                7
# define H_POS_Y                8
# define H_BACK_COLOR           9
# define H_TEXT_COLOR          10
# define H_FONT                11
# define H_TEXT                13
# define H_BUTTON              14
# define H_CENTER_X            15
# define H_RIGHT               16
# define H_CENTER_Y            17
# define H_BOTTOM              18
# define H_BUTTON_COLOR_1      19
# define H_BUTTON_COLOR_2      20
# define H_BUTTON_COLOR_3      21
# define H_BUTTON_COLOR_4      22
# define H_BUTTON_COLOR_5      23
# define H_BUTTON_COLOR_6      24
# define H_PRINT_MODE          25
# define H_TEXT_MODE           26
# define H_WIN_SHADE_WIDTH     27
# define H_WIN_SHADE_COL1      28
# define H_WIN_SHADE_COL2      29
# define H_ADD_X               30
# define H_ADD_Y               31
# define H_RETURN              32
# define H_FORMAT_TEXT         33
# define H_WIN_CENTER_ON_MOUSE 34
# define H_WIN_POP_UP          35
# define H_PICTURE             36
# define H_SET_FONT            37
# define H_LEFT                38
# define H_LEFT_FORMAT         39
# define H_RIGHT_FORMAT        40
# define H_WIN_COLOR           41
# define H_WIN_NAME            42
# define H_WIN_WITH_NAME       43
# define H_ALLOW_COLOR_SETTING 44
# define H_SUB_X               45
# define H_SUB_Y               46
# define H_FORCE_NO_SCROLL     47
# define H_FORCE_SCROLL        48

# define H_PARSE_END           1000

#define H_SCROLL_X 1
#define H_SCROLL_Y 2


T_INT help_function(T_PCHAR help_datei, HELP_BUTTON *sb);
T_INT number_help(T_PCHAR word, T_INT radix);
T_INT word_help(T_PCHAR word, T_LISTE *help_word_erste);
extern T_INT fast_scroll;
extern T_INT (*help_user_function)(T_PCHAR text);

# ifdef __cplusplus
}
# endif

#endif