/*****************************************************************************/
/*                                                                           */
/*   KEYBBOARD Library                             Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/

#if !defined KEYBOARD_H
    #define KEYBOARD_H

# ifdef __cplusplus
 extern "C" {
# endif


#include <standard.h>

#define GERMAN_KEYMAP 0
#define USA_KEYMAP 1

#define NO_OF_SCANMAPS 0x80

typedef struct sKeyConv
{
   T_SWORD iExtended;
   T_SWORD iKeyCode;
}KEYCONV;


#include "keydef.h"
#include "scandef.h"



// Define function prototypes
//
// All of thes functions are based in KEY_x (keydef.h)
//   (Under no circumstances use the scan codes)
//

T_INT     fKBDinit(T_VOID);
T_INT     fKBDrestore(T_VOID);
T_VOID    fKBDbuffering(T_INT bState);
T_UWORD   fKBDgetch(T_VOID);
T_VOID    fKBDungetch(T_UWORD tKeypress);
T_INT     fKBDhit(T_VOID);
T_INT     fKBDishit(T_VOID);
T_INT     fKBDfuncreg(T_UWORD tKeyNum,T_VOID (*pfKeyFunc)(T_UWORD));
T_VOID    fKBDnotused(T_UWORD tKeyVal);
T_VOID    fKBDdokey(T_VOID);
T_VOID    fKBDbufferenable(T_INT bState);
T_INT fKBDisALT(T_VOID);
T_INT fKBDisCTRL(T_VOID);
T_INT fKBDisRSHIFT(T_VOID);
T_INT fKBDisLSHIFT(T_VOID);


//
// This function is based in SCAN_x (scandef.h)
//

T_INT     fKBDisdown(T_UWORD iScancode);

extern T_INT KBDKeyPressed;
extern T_INT keymap;
extern KEYCONV asScanToKeyConvert[(4*NO_OF_SCANMAPS)+1];
extern KEYCONV german_asScanToKeyConvert[(4*NO_OF_SCANMAPS)+1];
extern KEYCONV usa_asScanToKeyConvert[(4*NO_OF_SCANMAPS)+1];

# ifdef __cplusplus
}
# endif


#endif

