/*****************************************************************************/
/*                                                                           */
/*   LIBRARY Functions - Scan code definitions        Copyright K.W 1996     */
/*                                                                           */
/*****************************************************************************/

#ifndef KEYCONV_H
#define KEYCONV_H

# ifdef __cplusplus
 extern "C" {
# endif


#include "keyboard.h"


// The +1 is for a terminating -1,-1 record

#define KEY_xxxxxxxxxxx    KEY_SPACE

KEYCONV asScanToKeyConvert[(4*NO_OF_SCANMAPS)+1];
KEYCONV german_asScanToKeyConvert[(4*NO_OF_SCANMAPS)+1];
KEYCONV usa_asScanToKeyConvert[(4*NO_OF_SCANMAPS)+1]=
{
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_FALSE, KEY_ESCAPE      ,  /* SCAN_ESC         0x01 */
   T_FALSE, KEY_1           ,  /* SCAN_1           0x02 */
   T_FALSE, KEY_2           ,  /* SCAN_2           0x03 */
   T_FALSE, KEY_3           ,  /* SCAN_3           0x04 */
   T_FALSE, KEY_4           ,  /* SCAN_4           0x05 */
   T_FALSE, KEY_5           ,  /* SCAN_5           0x06 */
   T_FALSE, KEY_6           ,  /* SCAN_6           0x07 */
   T_FALSE, KEY_7           ,  /* SCAN_7           0x08 */
   T_FALSE, KEY_8           ,  /* SCAN_8           0x09 */
   T_FALSE, KEY_9           ,  /* SCAN_9           0x0a */
   T_FALSE, KEY_0           ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_MINUS       ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_EQUALS      ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_FALSE, KEY_TAB         ,  /* SCAN_TAB         0x0f */

   T_FALSE, KEY_q           ,  /* SCAN_Q           0x10 */
   T_FALSE, KEY_w           ,  /* SCAN_W           0x11 */
   T_FALSE, KEY_e           ,  /* SCAN_E           0x12 */
   T_FALSE, KEY_r           ,  /* SCAN_R           0x13 */
   T_FALSE, KEY_t           ,  /* SCAN_T           0x14 */
   T_FALSE, KEY_y           ,  /* SCAN_Y           0x15 */
   T_FALSE, KEY_u           ,  /* SCAN_U           0x16 */
   T_FALSE, KEY_i           ,  /* SCAN_I           0x17 */
   T_FALSE, KEY_o           ,  /* SCAN_O           0x18 */
   T_FALSE, KEY_p           ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_LSQRB       ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_RSQRB       ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_FALSE, KEY_a           ,  /* SCAN_A           0x1e */
   T_FALSE, KEY_s           ,  /* SCAN_S           0x1f */

   T_FALSE, KEY_d           ,  /* SCAN_D           0x20 */
   T_FALSE, KEY_f           ,  /* SCAN_F           0x21 */
   T_FALSE, KEY_g           ,  /* SCAN_G           0x22 */
   T_FALSE, KEY_h           ,  /* SCAN_H           0x23 */
   T_FALSE, KEY_j           ,  /* SCAN_J           0x24 */
   T_FALSE, KEY_k           ,  /* SCAN_K           0x25 */
   T_FALSE, KEY_l           ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_SCOLON      ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_APSTPY      ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_TILDE       ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_HASH        ,  /* SCAN_HASH        0x2b */
   T_FALSE, KEY_z           ,  /* SCAN_Z           0x2c */
   T_FALSE, KEY_x           ,  /* SCAN_X           0x2d */
   T_FALSE, KEY_c           ,  /* SCAN_C           0x2e */
   T_FALSE, KEY_v           ,  /* SCAN_V           0x2f */

   T_FALSE, KEY_b           ,  /* SCAN_B           0x30 */
   T_FALSE, KEY_n           ,  /* SCAN_N           0x31 */
   T_FALSE, KEY_m           ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_COMMA       ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_STOP        ,  /* SCAN_STOP        0x34 */
   T_FALSE, KEY_FSLASH      ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_F1          ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_F2          ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_F3          ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_F4          ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_F5          ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_F6          ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_F7          ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_F8          ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_F9          ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_F10         ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_HOME        ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_UP          ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_PGUP        ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_LEFT        ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_RIGHT       ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_END         ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_DOWN        ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_PGDN        ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_INS         ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_DEL         ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_BSLASH      ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_F11         ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_F12         ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */


//
// SHIFT Versions
//

   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_FALSE, KEY_ESCAPE      ,  /* SCAN_ESC         0x01 */
   T_FALSE, KEY_PLING       ,  /* SCAN_1           0x02 */
   T_FALSE, KEY_QUOTE       ,  /* SCAN_2           0x03 */
   T_FALSE, KEY_HASH        ,  /* SCAN_3           0x04 */
   T_FALSE, KEY_HASH        ,  /* SCAN_4           0x05 */
   T_FALSE, KEY_DOLLAR      ,  /* SCAN_5           0x06 */
   T_FALSE, KEY_HAT         ,  /* SCAN_6           0x07 */
   T_FALSE, KEY_AMPSND      ,  /* SCAN_7           0x08 */
   T_FALSE, KEY_STAR        ,  /* SCAN_8           0x09 */
   T_FALSE, KEY_OPNBKT      ,  /* SCAN_9           0x0a */
   T_FALSE, KEY_CLSBKT      ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_USCORE      ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_PLUS        ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_FALSE, KEY_SHIFT_TAB   ,  /* SCAN_TAB         0x0f */

   T_FALSE, KEY_Q           ,  /* SCAN_Q           0x10 */
   T_FALSE, KEY_W           ,  /* SCAN_W           0x11 */
   T_FALSE, KEY_E           ,  /* SCAN_E           0x12 */
   T_FALSE, KEY_R           ,  /* SCAN_R           0x13 */
   T_FALSE, KEY_T           ,  /* SCAN_T           0x14 */
   T_FALSE, KEY_Y           ,  /* SCAN_Y           0x15 */
   T_FALSE, KEY_U           ,  /* SCAN_U           0x16 */
   T_FALSE, KEY_I           ,  /* SCAN_I           0x17 */
   T_FALSE, KEY_O           ,  /* SCAN_O           0x18 */
   T_FALSE, KEY_P           ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_LCURLY      ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_RCURLY      ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_FALSE, KEY_A           ,  /* SCAN_A           0x1e */
   T_FALSE, KEY_S           ,  /* SCAN_S           0x1f */

   T_FALSE, KEY_D           ,  /* SCAN_D           0x20 */
   T_FALSE, KEY_F           ,  /* SCAN_F           0x21 */
   T_FALSE, KEY_G           ,  /* SCAN_G           0x22 */
   T_FALSE, KEY_H           ,  /* SCAN_H           0x23 */
   T_FALSE, KEY_J           ,  /* SCAN_J           0x24 */
   T_FALSE, KEY_K           ,  /* SCAN_K           0x25 */
   T_FALSE, KEY_L           ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_COLON       ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_AT          ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_HASH        ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_HASH        ,  /* SCAN_HASH        0x2b */
   T_FALSE, KEY_Z           ,  /* SCAN_Z           0x2c */
   T_FALSE, KEY_X           ,  /* SCAN_X           0x2d */
   T_FALSE, KEY_C           ,  /* SCAN_C           0x2e */
   T_FALSE, KEY_V           ,  /* SCAN_V           0x2f */

   T_FALSE, KEY_B           ,  /* SCAN_B           0x30 */
   T_FALSE, KEY_N           ,  /* SCAN_N           0x31 */
   T_FALSE, KEY_M           ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_LTHAN       ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_GTHAN       ,  /* SCAN_STOP        0x34 */
   T_FALSE, KEY_QMARK       ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_SHIFT_F1    ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_SHIFT_F2    ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_SHIFT_F3    ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_SHIFT_F4    ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_SHIFT_F5    ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_SHIFT_F6    ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_SHIFT_F7    ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_SHIFT_F8    ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_SHIFT_F9    ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_SHIFT_F10   ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_SHIFT_HOME  ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_SHIFT_UP    ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_SHIFT_PGUP  ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_SHIFT_LEFT  ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_SHIFT_RIGHT ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_SHIFT_END   ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_SHIFT_DOWN  ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_SHIFT_PGDN        ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_INS         ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_DEL         ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_BSLASH      ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_SHIFT_F11   ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_SHIFT_F12   ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */




//
// CTRL Versions
//

   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_FALSE, KEY_ESCAPE      ,  /* SCAN_ESC         0x01 */
   T_FALSE, KEY_1           ,  /* SCAN_1           0x02 */
   T_FALSE, KEY_2           ,  /* SCAN_2           0x03 */
   T_FALSE, KEY_3           ,  /* SCAN_3           0x04 */
   T_FALSE, KEY_4           ,  /* SCAN_4           0x05 */
   T_FALSE, KEY_5           ,  /* SCAN_5           0x06 */
   T_FALSE, KEY_6           ,  /* SCAN_6           0x07 */
   T_FALSE, KEY_7           ,  /* SCAN_7           0x08 */
   T_FALSE, KEY_8           ,  /* SCAN_8           0x09 */
   T_FALSE, KEY_9           ,  /* SCAN_9           0x0a */
   T_FALSE, KEY_0           ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_MINUS       ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_EQUALS      ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_TRUE , KEY_CTRL_TAB    ,  /* SCAN_TAB         0x0f */

   T_FALSE, KEY_CTRL_Q      ,  /* SCAN_Q           0x10 */
   T_FALSE, KEY_CTRL_W      ,  /* SCAN_W           0x11 */
   T_FALSE, KEY_CTRL_E      ,  /* SCAN_E           0x12 */
   T_FALSE, KEY_CTRL_R      ,  /* SCAN_R           0x13 */
   T_FALSE, KEY_CTRL_T      ,  /* SCAN_T           0x14 */
   T_FALSE, KEY_CTRL_Y      ,  /* SCAN_Y           0x15 */
   T_FALSE, KEY_CTRL_U      ,  /* SCAN_U           0x16 */
   T_FALSE, KEY_CTRL_I      ,  /* SCAN_I           0x17 */
   T_FALSE, KEY_CTRL_O      ,  /* SCAN_O           0x18 */
   T_FALSE, KEY_CTRL_P      ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_LSQRB       ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_RSQRB       ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_FALSE, KEY_CTRL_A      ,  /* SCAN_A           0x1e */
   T_FALSE, KEY_CTRL_S      ,  /* SCAN_S           0x1f */

   T_FALSE, KEY_CTRL_D      ,  /* SCAN_D           0x20 */
   T_FALSE, KEY_CTRL_F      ,  /* SCAN_F           0x21 */
   T_FALSE, KEY_CTRL_G      ,  /* SCAN_G           0x22 */
   T_FALSE, KEY_CTRL_H      ,  /* SCAN_H           0x23 */
   T_FALSE, KEY_CTRL_J      ,  /* SCAN_J           0x24 */
   T_FALSE, KEY_CTRL_K      ,  /* SCAN_K           0x25 */
   T_FALSE, KEY_CTRL_L      ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_SCOLON      ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_APSTPY      ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_TILDE       ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_HASH        ,  /* SCAN_HASH        0x2b */
   T_FALSE, KEY_CTRL_Z      ,  /* SCAN_Z           0x2c */
   T_FALSE, KEY_CTRL_X      ,  /* SCAN_X           0x2d */
   T_FALSE, KEY_CTRL_C      ,  /* SCAN_C           0x2e */
   T_FALSE, KEY_CTRL_V      ,  /* SCAN_V           0x2f */

   T_FALSE, KEY_CTRL_B      ,  /* SCAN_B           0x30 */
   T_FALSE, KEY_CTRL_N      ,  /* SCAN_N           0x31 */
   T_FALSE, KEY_CTRL_M      ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_COMMA       ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_STOP        ,  /* SCAN_STOP        0x34 */
   T_FALSE, KEY_FSLASH      ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_CTRL_F1     ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_CTRL_F2     ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_CTRL_F3     ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_CTRL_F4     ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_CTRL_F5     ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_CTRL_F6     ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_CTRL_F7     ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_CTRL_F8     ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_CTRL_F9     ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_CTRL_F10    ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_CTRL_HOME   ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_CTRL_UP     ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_CTRL_PGUP   ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_CTRL_LEFT   ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_CTRL_RIGHT  ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_CTRL_END    ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_CTRL_DOWN   ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_CTRL_PGDN   ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_CTRL_INS    ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_CTRL_DEL    ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_BSLASH      ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_CTRL_F11    ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_CTRL_F12    ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */




//
// ALT Versions
//

   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_TRUE , KEY_ALT_ESC     ,  /* SCAN_ESC         0x01 */
   T_TRUE , KEY_ALT_1       ,  /* SCAN_1           0x02 */
   T_TRUE , KEY_ALT_2       ,  /* SCAN_2           0x03 */
   T_TRUE , KEY_ALT_3       ,  /* SCAN_3           0x04 */
   T_TRUE , KEY_ALT_4       ,  /* SCAN_4           0x05 */
   T_TRUE , KEY_ALT_5       ,  /* SCAN_5           0x06 */
   T_TRUE , KEY_ALT_6       ,  /* SCAN_6           0x07 */
   T_TRUE , KEY_ALT_7       ,  /* SCAN_7           0x08 */
   T_TRUE , KEY_ALT_8       ,  /* SCAN_8           0x09 */
   T_TRUE , KEY_ALT_9       ,  /* SCAN_9           0x0a */
   T_TRUE , KEY_ALT_0       ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_MINUS       ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_EQUALS      ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_TRUE , KEY_ALT_TAB     ,  /* SCAN_TAB         0x0f */

   T_TRUE , KEY_ALT_Q       ,  /* SCAN_Q           0x10 */
   T_TRUE , KEY_ALT_W       ,  /* SCAN_W           0x11 */
   T_TRUE , KEY_ALT_E       ,  /* SCAN_E           0x12 */
   T_TRUE , KEY_ALT_R       ,  /* SCAN_R           0x13 */
   T_TRUE , KEY_ALT_T       ,  /* SCAN_T           0x14 */
   T_TRUE , KEY_ALT_Y       ,  /* SCAN_Y           0x15 */
   T_TRUE , KEY_ALT_U       ,  /* SCAN_U           0x16 */
   T_TRUE , KEY_ALT_I       ,  /* SCAN_I           0x17 */
   T_TRUE , KEY_ALT_O       ,  /* SCAN_O           0x18 */
   T_TRUE , KEY_ALT_P       ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_LSQRB       ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_RSQRB       ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_TRUE , KEY_ALT_A       ,  /* SCAN_A           0x1e */
   T_TRUE , KEY_ALT_S       ,  /* SCAN_S           0x1f */

   T_TRUE , KEY_ALT_D       ,  /* SCAN_D           0x20 */
   T_TRUE , KEY_ALT_F       ,  /* SCAN_F           0x21 */
   T_TRUE , KEY_ALT_G       ,  /* SCAN_G           0x22 */
   T_TRUE , KEY_ALT_H       ,  /* SCAN_H           0x23 */
   T_TRUE , KEY_ALT_J       ,  /* SCAN_J           0x24 */
   T_TRUE , KEY_ALT_K       ,  /* SCAN_K           0x25 */
   T_TRUE , KEY_ALT_L       ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_SCOLON      ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_APSTPY      ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_TILDE       ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_HASH        ,  /* SCAN_HASH        0x2b */
   T_TRUE , KEY_ALT_Z       ,  /* SCAN_Z           0x2c */
   T_TRUE , KEY_ALT_X       ,  /* SCAN_X           0x2d */
   T_TRUE , KEY_ALT_C       ,  /* SCAN_C           0x2e */
   T_TRUE , KEY_ALT_V       ,  /* SCAN_V           0x2f */

   T_TRUE , KEY_ALT_B       ,  /* SCAN_B           0x30 */
   T_TRUE , KEY_ALT_N       ,  /* SCAN_N           0x31 */
   T_TRUE , KEY_ALT_M       ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_COMMA       ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_STOP        ,  /* SCAN_STOP        0x34 */
   T_FALSE, KEY_FSLASH      ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_ALT_F1      ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_ALT_F2      ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_ALT_F3      ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_ALT_F4      ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_ALT_F5      ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_ALT_F6      ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_ALT_F7      ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_ALT_F8      ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_ALT_F9      ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_ALT_F10     ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_ALT_HOME    ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_ALT_UP      ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_ALT_PGUP    ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_ALT_LEFT    ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_ALT_RIGHT   ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_ALT_END     ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_ALT_DOWN    ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_ALT_PGDN    ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_ALT_INS     ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_ALT_DEL     ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_BSLASH      ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_ALT_F11     ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_ALT_F12     ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */

   -1,-1,
};

KEYCONV german_asScanToKeyConvert[(4*NO_OF_SCANMAPS)+1]=
{

   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_FALSE, KEY_ESCAPE      ,  /* SCAN_ESC         0x01 */
   T_FALSE, KEY_1           ,  /* SCAN_1           0x02 */
   T_FALSE, KEY_2           ,  /* SCAN_2           0x03 */
   T_FALSE, KEY_3           ,  /* SCAN_3           0x04 */
   T_FALSE, KEY_4           ,  /* SCAN_4           0x05 */
   T_FALSE, KEY_5           ,  /* SCAN_5           0x06 */
   T_FALSE, KEY_6           ,  /* SCAN_6           0x07 */
   T_FALSE, KEY_7           ,  /* SCAN_7           0x08 */
   T_FALSE, KEY_8           ,  /* SCAN_8           0x09 */
   T_FALSE, KEY_9           ,  /* SCAN_9           0x0a */
   T_FALSE, KEY_0           ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_sz          ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_APSTPY      ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_FALSE, KEY_TAB         ,  /* SCAN_TAB         0x0f */

   T_FALSE, KEY_q           ,  /* SCAN_Q           0x10 */
   T_FALSE, KEY_w           ,  /* SCAN_W           0x11 */
   T_FALSE, KEY_e           ,  /* SCAN_E           0x12 */
   T_FALSE, KEY_r           ,  /* SCAN_R           0x13 */
   T_FALSE, KEY_t           ,  /* SCAN_T           0x14 */
   T_FALSE, KEY_z           ,  /* SCAN_Y           0x15 */
   T_FALSE, KEY_u           ,  /* SCAN_U           0x16 */
   T_FALSE, KEY_i           ,  /* SCAN_I           0x17 */
   T_FALSE, KEY_o           ,  /* SCAN_O           0x18 */
   T_FALSE, KEY_p           ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_ue          ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_PLUS        ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_FALSE, KEY_a           ,  /* SCAN_A           0x1e */
   T_FALSE, KEY_s           ,  /* SCAN_S           0x1f */

   T_FALSE, KEY_d           ,  /* SCAN_D           0x20 */
   T_FALSE, KEY_f           ,  /* SCAN_F           0x21 */
   T_FALSE, KEY_g           ,  /* SCAN_G           0x22 */
   T_FALSE, KEY_h           ,  /* SCAN_H           0x23 */
   T_FALSE, KEY_j           ,  /* SCAN_J           0x24 */
   T_FALSE, KEY_k           ,  /* SCAN_K           0x25 */
   T_FALSE, KEY_l           ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_oe          ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_ae          ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_HAT         ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_HASH        ,  /* SCAN_HASH        0x2b */
   T_FALSE, KEY_y           ,  /* SCAN_Z           0x2c */
   T_FALSE, KEY_x           ,  /* SCAN_X           0x2d */
   T_FALSE, KEY_c           ,  /* SCAN_C           0x2e */
   T_FALSE, KEY_v           ,  /* SCAN_V           0x2f */

   T_FALSE, KEY_b           ,  /* SCAN_B           0x30 */
   T_FALSE, KEY_n           ,  /* SCAN_N           0x31 */
   T_FALSE, KEY_m           ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_COMMA       ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_STOP        ,  /* SCAN_STOP        0x34 */
T_FALSE, KEY_MINUS      ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_F1          ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_F2          ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_F3          ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_F4          ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_F5          ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_F6          ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_F7          ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_F8          ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_F9          ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_F10         ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_HOME        ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_UP          ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_PGUP        ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_LEFT        ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_RIGHT       ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_END         ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_DOWN        ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_PGDN        ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_INS         ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_DEL         ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_LTHAN       ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_F11         ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_F12         ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */


//
// SHIFT Versions
//

   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_FALSE, KEY_ESCAPE      ,  /* SCAN_ESC         0x01 */
   T_FALSE, KEY_PLING       ,  /* SCAN_1           0x02 */
   T_FALSE, KEY_QUOTE       ,  /* SCAN_2           0x03 */
   T_FALSE, KEY_CTRL_U      ,  /* SCAN_3           0x04 */
   T_FALSE, KEY_DOLLAR      ,  /* SCAN_4           0x05 */
   T_FALSE, KEY_PERCENT     ,  /* SCAN_5           0x06 */
   T_FALSE, KEY_AMPSND      ,  /* SCAN_6           0x07 */
   T_FALSE, KEY_FSLASH      ,  /* SCAN_7           0x08 */
   T_FALSE, KEY_OPNBKT      ,  /* SCAN_8           0x09 */
   T_FALSE, KEY_CLSBKT      ,  /* SCAN_9           0x0a */
   T_FALSE, KEY_EQUALS      ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_QMARK       ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_LSGLQUOTE   ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_FALSE, KEY_SHIFT_TAB   ,  /* SCAN_TAB         0x0f */

   T_FALSE, KEY_Q           ,  /* SCAN_Q           0x10 */
   T_FALSE, KEY_W           ,  /* SCAN_W           0x11 */
   T_FALSE, KEY_E           ,  /* SCAN_E           0x12 */
   T_FALSE, KEY_R           ,  /* SCAN_R           0x13 */
   T_FALSE, KEY_T           ,  /* SCAN_T           0x14 */
   T_FALSE, KEY_Z           ,  /* SCAN_Y           0x15 */
   T_FALSE, KEY_U           ,  /* SCAN_U           0x16 */
   T_FALSE, KEY_I           ,  /* SCAN_I           0x17 */
   T_FALSE, KEY_O           ,  /* SCAN_O           0x18 */
   T_FALSE, KEY_P           ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_UE          ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_STAR      ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_FALSE, KEY_A           ,  /* SCAN_A           0x1e */
   T_FALSE, KEY_S           ,  /* SCAN_S           0x1f */

   T_FALSE, KEY_D           ,  /* SCAN_D           0x20 */
   T_FALSE, KEY_F           ,  /* SCAN_F           0x21 */
   T_FALSE, KEY_G           ,  /* SCAN_G           0x22 */
   T_FALSE, KEY_H           ,  /* SCAN_H           0x23 */
   T_FALSE, KEY_J           ,  /* SCAN_J           0x24 */
   T_FALSE, KEY_K           ,  /* SCAN_K           0x25 */
   T_FALSE, KEY_L           ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_OE          ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_AE          ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_LSGLQUOTE   ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_APSTPY      ,  /* SCAN_HASH        0x2b */
   T_FALSE, KEY_Y           ,  /* SCAN_Z           0x2c */
   T_FALSE, KEY_X           ,  /* SCAN_X           0x2d */
   T_FALSE, KEY_C           ,  /* SCAN_C           0x2e */
   T_FALSE, KEY_V           ,  /* SCAN_V           0x2f */

   T_FALSE, KEY_B           ,  /* SCAN_B           0x30 */
   T_FALSE, KEY_N           ,  /* SCAN_N           0x31 */
   T_FALSE, KEY_M           ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_SCOLON      ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_COLON       ,  /* SCAN_STOP        0x34 */
   T_FALSE, KEY_USCORE      ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_SHIFT_F1    ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_SHIFT_F2    ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_SHIFT_F3    ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_SHIFT_F4    ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_SHIFT_F5    ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_SHIFT_F6    ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_SHIFT_F7    ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_SHIFT_F8    ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_SHIFT_F9    ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_SHIFT_F10   ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_SHIFT_HOME  ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_SHIFT_UP    ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_SHIFT_PGUP  ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_SHIFT_LEFT  ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_SHIFT_RIGHT ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_SHIFT_END   ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_SHIFT_DOWN  ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_SHIFT_PGDN  ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_INS         ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_DEL         ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_GTHAN       ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_SHIFT_F11   ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_SHIFT_F12   ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */




//
// CTRL Versions
//

   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_FALSE, KEY_ESCAPE      ,  /* SCAN_ESC         0x01 */
   T_FALSE, KEY_1           ,  /* SCAN_1           0x02 */
   T_FALSE, KEY_2           ,  /* SCAN_2           0x03 */
   T_FALSE, KEY_3           ,  /* SCAN_3           0x04 */
   T_FALSE, KEY_4           ,  /* SCAN_4           0x05 */
   T_FALSE, KEY_5           ,  /* SCAN_5           0x06 */
   T_FALSE, KEY_6           ,  /* SCAN_6           0x07 */
   T_FALSE, KEY_7           ,  /* SCAN_7           0x08 */
   T_FALSE, KEY_8           ,  /* SCAN_8           0x09 */
   T_FALSE, KEY_9           ,  /* SCAN_9           0x0a */
   T_FALSE, KEY_0           ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_MINUS       ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_EQUALS      ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_TRUE , KEY_CTRL_TAB    ,  /* SCAN_TAB         0x0f */

   T_FALSE, KEY_CTRL_Q      ,  /* SCAN_Q           0x10 */
   T_FALSE, KEY_CTRL_W      ,  /* SCAN_W           0x11 */
   T_FALSE, KEY_CTRL_E      ,  /* SCAN_E           0x12 */
   T_FALSE, KEY_CTRL_R      ,  /* SCAN_R           0x13 */
   T_FALSE, KEY_CTRL_T      ,  /* SCAN_T           0x14 */
   T_FALSE, KEY_CTRL_Y      ,  /* SCAN_Y           0x15 */
   T_FALSE, KEY_CTRL_U      ,  /* SCAN_U           0x16 */
   T_FALSE, KEY_CTRL_I      ,  /* SCAN_I           0x17 */
   T_FALSE, KEY_CTRL_O      ,  /* SCAN_O           0x18 */
   T_FALSE, KEY_CTRL_P      ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_LSQRB       ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_RSQRB       ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_FALSE, KEY_CTRL_A      ,  /* SCAN_A           0x1e */
   T_FALSE, KEY_CTRL_S      ,  /* SCAN_S           0x1f */

   T_FALSE, KEY_CTRL_D      ,  /* SCAN_D           0x20 */
   T_FALSE, KEY_CTRL_F      ,  /* SCAN_F           0x21 */
   T_FALSE, KEY_CTRL_G      ,  /* SCAN_G           0x22 */
   T_FALSE, KEY_CTRL_H      ,  /* SCAN_H           0x23 */
   T_FALSE, KEY_CTRL_J      ,  /* SCAN_J           0x24 */
   T_FALSE, KEY_CTRL_K      ,  /* SCAN_K           0x25 */
   T_FALSE, KEY_CTRL_L      ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_SCOLON      ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_APSTPY      ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_TILDE       ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_HASH        ,  /* SCAN_HASH        0x2b */
   T_FALSE, KEY_CTRL_Z      ,  /* SCAN_Z           0x2c */
   T_FALSE, KEY_CTRL_X      ,  /* SCAN_X           0x2d */
   T_FALSE, KEY_CTRL_C      ,  /* SCAN_C           0x2e */
   T_FALSE, KEY_CTRL_V      ,  /* SCAN_V           0x2f */

   T_FALSE, KEY_CTRL_B      ,  /* SCAN_B           0x30 */
   T_FALSE, KEY_CTRL_N      ,  /* SCAN_N           0x31 */
   T_FALSE, KEY_CTRL_M      ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_COMMA       ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_STOP        ,  /* SCAN_STOP        0x34 */
   T_FALSE, KEY_FSLASH      ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_CTRL_F1     ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_CTRL_F2     ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_CTRL_F3     ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_CTRL_F4     ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_CTRL_F5     ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_CTRL_F6     ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_CTRL_F7     ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_CTRL_F8     ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_CTRL_F9     ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_CTRL_F10    ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_CTRL_HOME   ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_CTRL_UP     ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_CTRL_PGUP   ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_CTRL_LEFT   ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_CTRL_RIGHT  ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_CTRL_END    ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_CTRL_DOWN   ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_CTRL_PGDN   ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_CTRL_INS    ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_CTRL_DEL    ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_BSLASH      ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_CTRL_F11    ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_CTRL_F12    ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */




//
// ALT Versions
//

   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_BASE        0x00 */
   T_TRUE , KEY_ALT_ESC     ,  /* SCAN_ESC         0x01 */
   T_TRUE , KEY_ALT_1       ,  /* SCAN_1           0x02 */
   T_TRUE , KEY_ALT_2       ,  /* SCAN_2           0x03 */
   T_TRUE , KEY_ALT_3       ,  /* SCAN_3           0x04 */
   T_TRUE , KEY_ALT_4       ,  /* SCAN_4           0x05 */
   T_TRUE , KEY_ALT_5       ,  /* SCAN_5           0x06 */
   T_TRUE , KEY_ALT_6       ,  /* SCAN_6           0x07 */
   T_TRUE , KEY_LCURLY      ,  /* SCAN_7           0x08 */
   T_TRUE , KEY_LSQRB       ,  /* SCAN_8           0x09 */
   T_TRUE , KEY_RSQRB       ,  /* SCAN_9           0x0a */
   T_TRUE , KEY_RCURLY      ,  /* SCAN_0           0x0b */
   T_FALSE, KEY_BSLASH      ,  /* SCAN_MINUS       0x0c */
   T_FALSE, KEY_EQUALS      ,  /* SCAN_EQUALS      0x0d */
   T_FALSE, KEY_BSPACE      ,  /* SCAN_BSPACE      0x0e */
   T_TRUE , KEY_ALT_TAB     ,  /* SCAN_TAB         0x0f */

   T_TRUE , KEY_AT          ,  /* SCAN_Q           0x10 */
   T_TRUE , KEY_ALT_W       ,  /* SCAN_W           0x11 */
   T_TRUE , KEY_ALT_E       ,  /* SCAN_E           0x12 */
   T_TRUE , KEY_ALT_R       ,  /* SCAN_R           0x13 */
   T_TRUE , KEY_ALT_T       ,  /* SCAN_T           0x14 */
   T_TRUE , KEY_ALT_Y       ,  /* SCAN_Y           0x15 */
   T_TRUE , KEY_ALT_U       ,  /* SCAN_U           0x16 */
   T_TRUE , KEY_ALT_I       ,  /* SCAN_I           0x17 */
   T_TRUE , KEY_ALT_O       ,  /* SCAN_O           0x18 */
   T_TRUE , KEY_ALT_P       ,  /* SCAN_P           0x19 */
   T_FALSE, KEY_LSQRB       ,  /* SCAN_LSQRB       0x1a */
   T_FALSE, KEY_TILDE       ,  /* SCAN_RSQRB       0x1b */
   T_FALSE, KEY_ENTER       ,  /* SCAN_ENTER       0x1c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CTRL        0x1d */
   T_TRUE , KEY_ALT_A       ,  /* SCAN_A           0x1e */
   T_TRUE , KEY_ALT_S       ,  /* SCAN_S           0x1f */

   T_TRUE , KEY_ALT_D       ,  /* SCAN_D           0x20 */
   T_TRUE , KEY_ALT_F       ,  /* SCAN_F           0x21 */
   T_TRUE , KEY_ALT_G       ,  /* SCAN_G           0x22 */
   T_TRUE , KEY_ALT_H       ,  /* SCAN_H           0x23 */
   T_TRUE , KEY_ALT_J       ,  /* SCAN_J           0x24 */
   T_TRUE , KEY_ALT_K       ,  /* SCAN_K           0x25 */
   T_TRUE , KEY_ALT_L       ,  /* SCAN_L           0x26 */
   T_FALSE, KEY_SCOLON      ,  /* SCAN_SCOLON      0x27 */
   T_FALSE, KEY_APSTPY      ,  /* SCAN_APSTPY      0x28 Apostrophy ''''' */
   T_FALSE, KEY_TILDE       ,  /* SCAN_TILDE       0x29 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_LSHIFT      0x2a */
   T_FALSE, KEY_PIPE        ,  /* SCAN_HASH        0x2b */
   T_TRUE , KEY_ALT_Z       ,  /* SCAN_Z           0x2c */
   T_TRUE , KEY_ALT_X       ,  /* SCAN_X           0x2d */
   T_TRUE , KEY_ALT_C       ,  /* SCAN_C           0x2e */
   T_TRUE , KEY_ALT_V       ,  /* SCAN_V           0x2f */

   T_TRUE , KEY_ALT_B       ,  /* SCAN_B           0x30 */
   T_TRUE , KEY_ALT_N       ,  /* SCAN_N           0x31 */
   T_TRUE , KEY_ALT_M       ,  /* SCAN_M           0x32 */
   T_FALSE, KEY_COMMA       ,  /* SCAN_COMMA       0x33 */
   T_FALSE, KEY_STOP        ,  /* SCAN_STOP        0x34 */
   T_FALSE, KEY_FSLASH      ,  /* SCAN_FSLASH      0x35 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_RSHIFT      0x36 */
   T_FALSE, KEY_STAR        ,  /* SCAN_STAR        0x37 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_ALT         0x38 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x39 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_CAPS        0x3a */
   T_TRUE , KEY_ALT_F1      ,  /* SCAN_F1          0x3b */
   T_TRUE , KEY_ALT_F2      ,  /* SCAN_F2          0x3c */
   T_TRUE , KEY_ALT_F3      ,  /* SCAN_F3          0x3d */
   T_TRUE , KEY_ALT_F4      ,  /* SCAN_F4          0x3e */
   T_TRUE , KEY_ALT_F5      ,  /* SCAN_F5          0x3f */

   T_TRUE , KEY_ALT_F6      ,  /* SCAN_F6          0x40 */
   T_TRUE , KEY_ALT_F7      ,  /* SCAN_F7          0x41 */
   T_TRUE , KEY_ALT_F8      ,  /* SCAN_F8          0x42 */
   T_TRUE , KEY_ALT_F9      ,  /* SCAN_F9          0x43 */
   T_TRUE , KEY_ALT_F10     ,  /* SCAN_F10         0x44 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_NUMLCK      0x45 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /* SCAN_SCRLCK      0x46 */
   T_TRUE , KEY_ALT_HOME    ,  /* SCAN_HOME        0x47 */
   T_TRUE , KEY_ALT_UP      ,  /* SCAN_UP          0x48 */
   T_TRUE , KEY_ALT_PGUP    ,  /* SCAN_PGUP        0x49 */
   T_FALSE, KEY_MINUS       ,  /* SCAN_DASH        0x4a Number pad minus */
   T_TRUE , KEY_ALT_LEFT    ,  /* SCAN_LEFT        0x4b */
   T_FALSE, KEY_5           ,  /* SCAN_CENTRE      0x4c Number pad centre */
   T_TRUE , KEY_ALT_RIGHT   ,  /* SCAN_RIGHT       0x4d */
   T_FALSE, KEY_PLUS        ,  /* SCAN_PLUS        0x4e Number pad plus */
   T_TRUE , KEY_ALT_END     ,  /* SCAN_END         0x4f */

   T_TRUE , KEY_ALT_DOWN    ,  /* SCAN_DOWN        0x50 */
   T_TRUE , KEY_ALT_PGDN    ,  /* SCAN_PGDN        0x51 */
   T_TRUE , KEY_ALT_INS     ,  /* SCAN_INS         0x52 */
   T_TRUE , KEY_ALT_DEL     ,  /* SCAN_DEL         0x53 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x54 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x55 */
   T_FALSE, KEY_PIPE        ,  /* SCAN_BSLASH      0x56 */
   T_TRUE , KEY_ALT_F11     ,  /* SCAN_F11         0x57 */
   T_TRUE , KEY_ALT_F12     ,  /* SCAN_F12         0x58 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x59 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x5f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x60 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x61 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x62 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x63 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x64 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x65 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x66 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x67 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x68 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x69 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x6f */

   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x70 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x71 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x72 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x73 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x74 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x75 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x76 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x77 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x78 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x79 */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7a */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7b */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7c */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7d */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7e */
   T_FALSE, KEY_xxxxxxxxxxx ,  /*                  0x7f */

   -1,-1,
};

# ifdef __cplusplus
}
# endif


#endif
