/*****************************************************************************/
/*                                                                           */
/*   Vectrex emulator                                 Copyright KW  1996     */
/*                                                                           */
/*****************************************************************************/

#ifndef KEYDEF_H
    #define KEYDEF_H

# ifdef __cplusplus
 extern "C" {
# endif

/* ASCII Character Codes 0-7f */

#define KEY_CTRL_A  0x0001
#define KEY_CTRL_B  0x0002
#define KEY_CTRL_C  0x0003
#define KEY_CTRL_D  0x0004
#define KEY_CTRL_E  0x0045
#define KEY_CTRL_F  0x0006
#define KEY_CTRL_G  0x0007
#define KEY_CTRL_H  0x0008
#define KEY_BSPACE  0x0008
#define KEY_CTRL_I  0x0009
#define KEY_TAB     0x0009
#define KEY_CTRL_J  0x000a
#define KEY_CTRL_K  0x000b
#define KEY_CTRL_L  0x000c
#define KEY_CTRL_M  0x000d
#define KEY_ENTER   0x000d
#define KEY_CTRL_N  0x000e
#define KEY_CTRL_O  0x000f
#define KEY_CTRL_P      0x0010
#define KEY_CTRL_Q      0x0011
#define KEY_CTRL_R      0x0012
#define KEY_CTRL_S      0x0013
#define KEY_CTRL_T      0x0014
#define KEY_CTRL_U      0x0015
#define KEY_CTRL_V      0x0016
#define KEY_CTRL_W      0x0017
#define KEY_CTRL_X      0x0018
#define KEY_CTRL_Y      0x0019
#define KEY_CTRL_Z      0x001a
#define KEY_ESCAPE      0x001b

#define KEY_SPACE  0x0020
#define KEY_PLING  0x0021
#define KEY_QUOTE  0x0022
#define KEY_HASH   0x0023
#define KEY_DOLLAR 0x0024
#define KEY_PERCENT 0x0025
#define KEY_AMPSND 0x0026
#define KEY_APSTPY 0x0027
#define KEY_OPNBKT 0x0028
#define KEY_CLSBKT 0x0029
#define KEY_STAR   0x002A
#define KEY_PLUS   0x002B
#define KEY_COMMA  0x002C
#define KEY_MINUS  0x002D
#define KEY_STOP   0x002E
#define KEY_FSLASH 0x002F

#define KEY_0           0x0030
#define KEY_1           0x0031
#define KEY_2           0x0032
#define KEY_3           0x0033
#define KEY_4           0x0034
#define KEY_5           0x0035
#define KEY_6           0x0036
#define KEY_7           0x0037
#define KEY_8           0x0038
#define KEY_9           0x0039
#define KEY_COLON       0x003a
#define KEY_SCOLON      0x003b
#define KEY_LTHAN       0x003c
#define KEY_EQUALS      0x003d
#define KEY_GTHAN       0x003e
#define KEY_QMARK       0x003f
#define KEY_AT          0x0040

#define KEY_A           0x0041
#define KEY_B           0x0042
#define KEY_C           0x0043
#define KEY_D           0x0044
#define KEY_E           0x0045
#define KEY_F           0x0046
#define KEY_G           0x0047
#define KEY_H           0x0048
#define KEY_I           0x0049
#define KEY_J           0x004a
#define KEY_K           0x004b
#define KEY_L           0x004c
#define KEY_M           0x004d
#define KEY_N           0x004e
#define KEY_O           0x004f
#define KEY_P           0x0050
#define KEY_Q           0x0051
#define KEY_R           0x0052
#define KEY_S           0x0053
#define KEY_T           0x0054
#define KEY_U           0x0055
#define KEY_V           0x0056
#define KEY_W           0x0057
#define KEY_X           0x0058
#define KEY_Y           0x0059
#define KEY_Z           0x005a

#define KEY_LSQRB       0x005b
#define KEY_BSLASH      0x005c
#define KEY_RSQRB       0x005d
#define KEY_HAT         0x005e
#define KEY_USCORE      0x005f
#define KEY_LSGLQUOTE   0x0060

#define KEY_a           0x0061
#define KEY_b           0x0062
#define KEY_c           0x0063
#define KEY_d           0x0064
#define KEY_e           0x0065
#define KEY_f           0x0066
#define KEY_g           0x0067
#define KEY_h           0x0068
#define KEY_i           0x0069
#define KEY_j           0x006a
#define KEY_k           0x006b
#define KEY_l           0x006c
#define KEY_m           0x006d
#define KEY_n           0x006e
#define KEY_o           0x006f
#define KEY_p           0x0070
#define KEY_q           0x0071
#define KEY_r           0x0072
#define KEY_s           0x0073
#define KEY_t           0x0074
#define KEY_u           0x0075
#define KEY_v           0x0076
#define KEY_w           0x0077
#define KEY_x           0x0078
#define KEY_y           0x0079
#define KEY_z           0x007a

#define KEY_LCURLY      0x007b
#define KEY_PIPE        0x007c
#define KEY_RCURLY      0x007d
#define KEY_TILDE       0x007e

#define KEY_ue 0x81
#define KEY_UE 0x9a
#define KEY_ae 0x84
#define KEY_AE 0x8e
#define KEY_oe 0x94
#define KEY_OE 0x99
#define KEY_sz 0xe1

/* Extended Character Codes index 0x80 upwards for 0xff */


#define KEY_ALT_ESC     (0x0001+0x0080)

#define KEY_ALT_BS      (0x000e+0x0080)
#define KEY_SHIFT_TAB   (0x000f+0x0080)

#define KEY_ALT_Q       (0x0010+0x0080)
#define KEY_ALT_W       (0x0011+0x0080)
#define KEY_ALT_E       (0x0012+0x0080)
#define KEY_ALT_R       (0x0013+0x0080)
#define KEY_ALT_T       (0x0014+0x0080)
#define KEY_ALT_Y       (0x0015+0x0080)
#define KEY_ALT_U       (0x0016+0x0080)
#define KEY_ALT_I       (0x0017+0x0080)
#define KEY_ALT_O       (0x0018+0x0080)
#define KEY_ALT_P       (0x0019+0x0080)

#define KEY_ALT_A       (0x001e+0x0080)
#define KEY_ALT_S       (0x001f+0x0080)
#define KEY_ALT_D       (0x0020+0x0080)
#define KEY_ALT_F       (0x0021+0x0080)
#define KEY_ALT_G       (0x0022+0x0080)
#define KEY_ALT_H       (0x0023+0x0080)
#define KEY_ALT_J       (0x0024+0x0080)
#define KEY_ALT_K       (0x0025+0x0080)
#define KEY_ALT_L       (0x0026+0x0080)

#define KEY_ALT_Z       (0x002c+0x0080)
#define KEY_ALT_X       (0x002d+0x0080)
#define KEY_ALT_C       (0x002e+0x0080)
#define KEY_ALT_V       (0x002f+0x0080)
#define KEY_ALT_B       (0x0030+0x0080)
#define KEY_ALT_N       (0x0031+0x0080)
#define KEY_ALT_M       (0x0032+0x0080)

#define KEY_F1          (0x003b+0x0080)
#define KEY_F2          (0x003c+0x0080)
#define KEY_F3          (0x003d+0x0080)
#define KEY_F4          (0x003e+0x0080)
#define KEY_F5          (0x003f+0x0080)
#define KEY_F6          (0x0040+0x0080)
#define KEY_F7          (0x0041+0x0080)
#define KEY_F8          (0x0042+0x0080)
#define KEY_F9          (0x0043+0x0080)
#define KEY_F10         (0x0044+0x0080)

#define KEY_HOME        (0x0047+0x0080)
#define KEY_UP          (0x0048+0x0080)
#define KEY_PGUP        (0x0049+0x0080)
#define KEY_LEFT        (0x004b+0x0080)
#define KEY_RIGHT       (0x004d+0x0080)
#define KEY_END         (0x004f+0x0080)
#define KEY_DOWN        (0x0050+0x0080)
#define KEY_PGDN        (0x0051+0x0080)
#define KEY_INS         (0x0052+0x0080)
#define KEY_DEL         (0x0053+0x0080)

#define KEY_SHIFT_F1    (0x0054+0x0080)
#define KEY_SHIFT_F2    (0x0055+0x0080)
#define KEY_SHIFT_F3    (0x0056+0x0080)
#define KEY_SHIFT_F4    (0x0057+0x0080)
#define KEY_SHIFT_F5    (0x0058+0x0080)
#define KEY_SHIFT_F6    (0x0059+0x0080)
#define KEY_SHIFT_F7    (0x005a+0x0080)
#define KEY_SHIFT_F8    (0x005b+0x0080)
#define KEY_SHIFT_F9    (0x005c+0x0080)
#define KEY_SHIFT_F10   (0x005d+0x0080)

#define KEY_CTRL_F1     (0x005e+0x0080)
#define KEY_CTRL_F2     (0x005f+0x0080)
#define KEY_CTRL_F3     (0x0060+0x0080)
#define KEY_CTRL_F4     (0x0061+0x0080)
#define KEY_CTRL_F5     (0x0062+0x0080)
#define KEY_CTRL_F6     (0x0063+0x0080)
#define KEY_CTRL_F7     (0x0064+0x0080)
#define KEY_CTRL_F8     (0x0065+0x0080)
#define KEY_CTRL_F9     (0x0066+0x0080)
#define KEY_CTRL_F10    (0x0067+0x0080)

#define KEY_ALT_F1      (0x0068+0x0080)
#define KEY_ALT_F2      (0x0069+0x0080)
#define KEY_ALT_F3      (0x006a+0x0080)
#define KEY_ALT_F4      (0x006b+0x0080)
#define KEY_ALT_F5      (0x006c+0x0080)
#define KEY_ALT_F6      (0x006d+0x0080)
#define KEY_ALT_F7      (0x006e+0x0080)
#define KEY_ALT_F8      (0x006f+0x0080)
#define KEY_ALT_F9      (0x0070+0x0080)
#define KEY_ALT_F10     (0x0071+0x0080)

#define KEY_CTRL_PRTSC  (0x0072+0x0080)
#define KEY_CTRL_LEFT   (0x0073+0x0080)
#define KEY_CTRL_RIGHT  (0x0074+0x0080)
#define KEY_CTRL_END    (0x0075+0x0080)
#define KEY_CTRL_PGDN   (0x0076+0x0080)
#define KEY_CTRL_HOME   (0x0077+0x0080)

#define KEY_ALT_1       (0x0078+0x0080)
#define KEY_ALT_2       (0x0079+0x0080)
#define KEY_ALT_3       (0x007a+0x0080)
#define KEY_ALT_4       (0x007b+0x0080)
#define KEY_ALT_5       (0x007c+0x0080)
#define KEY_ALT_6       (0x007d+0x0080)
#define KEY_ALT_7       (0x007e+0x0080)
#define KEY_ALT_8       (0x007f+0x0080)
#define KEY_ALT_9       (0x0080+0x0080)
#define KEY_ALT_0       (0x0081+0x0080)

#define KEY_ALT_MINUS   (0x0082+0x0080)
#define KEY_ALT_EQUALS  (0x0083+0x0080)
#define KEY_CTRL_PGUP   (0x0084+0x0080)

#define KEY_F11         (0x0085+0x0080)
#define KEY_F12         (0x0086+0x0080)

#define KEY_SHIFT_F11   (0x0087+0x0080)
#define KEY_SHIFT_F12   (0x0088+0x0080)

#define KEY_CTRL_F11    (0x0089+0x0080)
#define KEY_CTRL_F12    (0x008a+0x0080)

#define KEY_ALT_F11     (0x008b+0x0080)
#define KEY_ALT_F12     (0x008c+0x0080)

#define KEY_CTRL_UP     (0x008d+0x0080)
#define KEY_CTRL_DOWN   (0x0091+0x0080)
#define KEY_CTRL_INS    (0x0092+0x0080)
#define KEY_CTRL_DEL    (0x0093+0x0080)
#define KEY_CTRL_TAB    (0x0094+0x0080)

#define KEY_ALT_HOME    (0x0097+0x0080)
#define KEY_ALT_UP      (0x0098+0x0080)
#define KEY_ALT_PGUP    (0x0099+0x0080)
#define KEY_ALT_LEFT    (0x009b+0x0080)
#define KEY_ALT_RIGHT   (0x009d+0x0080)
#define KEY_ALT_END     (0x009f+0x0080)
#define KEY_ALT_DOWN    (0x00a0+0x0080)
#define KEY_ALT_PGDN    (0x00a1+0x0080)
#define KEY_ALT_INS     (0x00a2+0x0080)
#define KEY_ALT_DEL     (0x00a3+0x0080)
#define KEY_ALT_TAB     (0x00a5+0x0080)

#define KEY_SHIFT_HOME    (0x00a6+0x0080)
#define KEY_SHIFT_UP      (0x00a7+0x0080)
#define KEY_SHIFT_PGUP    (0x00a8+0x0080)
#define KEY_SHIFT_LEFT    (0x00a9+0x0080)
#define KEY_SHIFT_RIGHT   (0x00aa+0x0080)
#define KEY_SHIFT_END     (0x00ab+0x0080)
#define KEY_SHIFT_DOWN    (0x00ac+0x0080)
#define KEY_SHIFT_PGDN    (0x00ad+0x0080)




/* From here on up we use as spare keymaps for the pulldown menus */

#define KEY_SPARE_START (0x00c0+0x0080)

# ifdef __cplusplus
}
# endif


#endif
