#ifndef PARSER_H
# define PARSER_H

# ifdef __cplusplus
 extern "C" {
# endif


# include "standard.h"
# include "d_list.h"
# include "file.h"

/* DATEN, die der PARSER verstehen kann */
# define PARSER_TYPE_VOID     1  /* nothing read, variable can be NULL, only as a switch... */
# define PARSER_TYPE_BIT      2  /* NOT IMPLEMENTED */
# define PARSER_TYPE_UCHAR    3
# define PARSER_TYPE_SCHAR    4
# define PARSER_TYPE_CHAR     PARSER_TYPE_SCHAR
# define PARSER_TYPE_UINT     5
# define PARSER_TYPE_SINT     6
# define PARSER_TYPE_INT      PARSER_TYPE_SINT
# define PARSER_TYPE_ULONG    7  /* NOT IMPLEMENTED */
# define PARSER_TYPE_SLONG    8  /* NOT IMPLEMENTED */
# define PARSER_TYPE_LONG     PARSER_TYPE_SLONG
# define PARSER_TYPE_FLOAT    9  /* NOT IMPLEMENTED */
# define PARSER_TYPE_DOUBLE   10 /* NOT IMPLEMENTED */
# define PARSER_TYPE_LDOUBLE  11 /* NOT IMPLEMENTED */
# define PARSER_TYPE_STRING   12
# define PARSER_TYPE_UWORD    13
# define PARSER_TYPE_SWORD    14
# define PARSER_TYPE_WORD     PARSER_TYPE_SWORD
# define PARSER_TYPE_LINE_ARRAY_INT 32764 /* NICHT vorbestimmte Anzahl von INT, bis ans ende der Zeile */
                                          /* no strukt, no list yet */
# define PARSER_TYPE_LIST     32765 /* NICHT vorbestimmte anzahl von daten */
                                    /* EINES Types, NICHT aufeinanderfolgend, */
                                    /* immer wieder mit diesem schluesselwort aufgerufen */
                                    /* kann auch array enthalten */
# define PARSER_TYPE_STRUKT   32766 /* vorbestimmte anzahl von daten von verschiedenen Typen */
# define PARSER_TYPE_END      32767

/* sonstige defines */
# define PARSER_STRUKT_END    32767 /* einfach ein wert */

 typedef struct
 {
  T_INT                      type;       /* Typinformationen */
  T_PCHAR                    text;       /* wonach suchen */
  T_PVOID                    value;      /* wohin, das gesuchte */
  T_INT                      key;
 }PARSER_WORD;

 typedef struct
 {
  T_INT                      type;       /* Typinformationen */
  T_INT                      how_many;   /* wieviel dieses Types */
  T_PVOID                    value;      /* wohin, das gesuchte */
 }PARSER_STRUKT;

 typedef struct
 {
  T_INT                      type;       /* Typinformationen */
  T_PVOID                    strukt_info;/* naehere Beschreibung fuer eine Liste von einer Struktur */
  T_LISTE *                  list_head;  /* wohin, das gesuchte */
  T_LISTE *                  list_tail;  /* wohin, das gesuchte */
 }PARSER_LIST;

/* globale Funktionen */
 T_INT p_parse_init( T_VOID );
 T_INT p_parse( T_PCHAR filename, PARSER_WORD *word );
 T_INT p_open_parse( T_PCHAR filename, M_FILE **handle, PARSER_WORD *parse_hilfe );
 T_INT p_parse_next( M_FILE *help_file, T_PCHAR last_key, T_PINT key );
 T_INT p_close_parse( M_FILE **handle);


/* globale Variablen */
 extern T_INT parse_error;      /* Zuletzt aufgetretener Fehler im Parser Modul */
 extern T_INT p_capitalise;     /* Soll auf Gross/Klein-Schreibung geachtet werden */
 extern T_INT p_alloc_pointer;  /* sollen Pointer Typen (z.B. Strings) alloziert werden? */
 extern T_INT p_include_brackets;
 extern T_INT p_switch_to_c_end_char;
 extern T_INT p_verbosity;
 extern T_INT p_delete_temp;

#define MAX_LINE_INT 101
#define P_OK_REMARK_FOUND 12123
#define P_REMARK_FOUND 12124
#define P_OK_POSSIBLE_FILE_END 12125
#define P_POSSIBLE_FILE_END 12126
#define P_OK_RETURN_FOUND 12127
#define P_RETURN_FOUND 12128

# ifdef __cplusplus
}
# endif

#endif
