#ifndef PCX_H
# define PCX_H

# ifdef __cplusplus
 extern "C" {
# endif

# include "standard.h"

# define NO_PCX_HEADER_READ 100
# define DECRUNCH_ERROR 101
# define BILD_UNBEKANNT 102
# define BILD_IST_256_FARBE_BILD 1
# define BILD_IST_16_FARBE_BILD 2

typedef struct
{
 T_BYTE red;
 T_BYTE green;
 T_BYTE blue;
} RGB;

typedef struct
{
 RGB    rgb_farben[16];
 T_LONG punkte[16];
} FARB_TABELLE_16;

typedef struct
{
 RGB    rgb_farben[256];
 T_LONG punkte[256];
} FARB_TABELLE_256;

typedef struct
{
 T_WORD   anzahl;
 RGB *    rgb_farben;
 T_PLONG  punkte;
} FARB_TABELLE;

typedef struct
{
 T_BYTE hersteller;
 T_BYTE version;
 T_BYTE kodierungsart;
 T_BYTE bits_pro_pixel;
 T_WORD  xmin;
 T_WORD  ymin;
 T_WORD  xmax;
 T_WORD  ymax;
 T_WORD  aufloesung_x;
 T_WORD  aufloesung_y;
 RGB rgb_farben[16];
 T_BYTE reserviert;
 T_BYTE anzahl_farbebenen;
 T_WORD  bytes_pro_zeile;
 T_WORD  farb_art;
 T_BYTE fuell_werte[58];
} PCX_HEADER;

typedef struct
{
 T_WORD  zeilen_laenge;
 T_BYTE *zeile;
 T_WORD   id;
} ZEILE_EINES_BILDES;

/* globale Funktionen */
T_INT pcx_read_header(T_PCHAR filename);
T_INT pcx_prT_INT_header_daten(T_VOID);
T_INT pcx_open_file(T_PCHAR filename);
T_INT pcx_close_file(T_VOID);
T_INT pcx_get_zeile256(T_VOID);
T_INT pcx_get_zeile16(T_INT farb_offset);
T_VOID pcx_get_color256(T_VOID);
T_VOID pcx_get_color16(T_VOID);
T_VOID pcx_set_color256(T_VOID);
T_VOID pcx_set_color16(T_INT dac_farb_offset);
T_INT pcx_write_256pic(T_INT x,T_INT y, T_INT len_x, T_INT len_y, T_PCHAR filname);
T_INT pcx_set_file_color(T_PCHAR filename);
T_INT pcx_get_256palette(FARB_TABELLE_256 *neue_farb_tabelle,T_PCHAR filename);
T_PLONG get_distances_of_colors(T_BYTE r1,T_BYTE g1,T_BYTE b1, FARB_TABELLE farb_tabelle,T_INT start_farbe,T_INT end_farbe,T_INT equal);
T_BYTE get_nearest_color(T_BYTE r1,T_BYTE g1,T_BYTE b1, FARB_TABELLE_256 farb_tabelle,T_INT start_farbe,T_INT end_farbe,T_INT equal);

/* globale Variablen */
extern PCX_HEADER pcx_header;
extern ZEILE_EINES_BILDES pcx_zeile_eines_bildes256;
extern FARB_TABELLE_256 pcx_256_farb_tabelle;
extern FARB_TABELLE_16 pcx_16_farb_tabelle;
extern T_INT pcx_bild_art;
extern T_INT pcx_color16_default;
extern T_WORD pcx_error;

extern T_INT pcx_set_file_color_flag;
# ifdef __cplusplus
}
# endif

#endif
