#ifndef STANDARD_H
# define STANDARD_H

# ifdef __cplusplus
 extern "C" {
# endif


# define T_DEBUG 1
# define T_RELEASE 2

# define MAX_PATH_LEN 256
# define STRING_MAX 81
# define PMAX 16384
# define MAX_LOW_MEMBILD_BUFFER (1600*1200)
# define MAX_TEXT_AUSGABE_LAENGE 2000

/* art des dispatchers tastatur eingaben zu bearbeiten */
//# define ACTIVE_WINDOW 1
//# define FOCUS_WINDOW 2
//# define HIDE_LOWER_WINDOWS 4
//# define SHOW_LOWER_WINDOWS 8

/* art des dispatchers tastatur eingaben zu bearbeiten */
# define ACTIVATE_ON_FOCUS  1  /* Fenster auf Focus aktivieren (sun-Maus) */
# define ACTIVE_ON_FOCUS    2  /* dort bearbeiten wo Maus steht (tastatur area...) */
# define ACTIVE_WINDOW      4  /* Eingabe immer vom aktiven Fenster entgegennehmen, egal wo Maus */
# define HIDE_LOWER_WINDOWS 8  /* Verstecke Fenster, die im Moment nichts zurueckgeben duerfen */
# define SHOW_LOWER_WINDOWS 16


#define DISPATCHER
//#define SCHEDULER

/* Wenn definiert, dann kann kein Mouse-Report mit ALT_M erreicht werden */
/*
# define NO_MOUSE_REPORT
*/

/* Wenn definiert, dann kann keine Informationen ueber ALT_F6 - ALT_F10 */
/*
# define NO_HIDDEN_INFOS
*/

/* Wenn definiert, dann wird ein Dispatcher Missmatch angezeigt! */
/*
#ifdef SHOW_MISSMATCH
*/

# define T_SBYTE signed char
# define T_PSBYTE T_SBYTE *

# define T_UBYTE unsigned char
# define T_PUBYTE T_UBYTE *

# define T_BYTE unsigned char
# define T_PBYTE T_BYTE *

# define T_CHAR unsigned char
# define T_PCHAR T_CHAR *

# define T_UCHAR unsigned char
# define T_PUCHAR T_UCHAR *

# define T_SCHAR signed char
# define T_PSCHAR T_SCHAR *

# define T_WORD unsigned short int
# define T_SHORT T_WORD
# define T_PWORD T_WORD *

# define T_SWORD signed short int
# define T_PSWORD T_SWORD *

# define T_UWORD unsigned short int
# define T_PUWORD T_UWORD *

# define T_LONG signed long
# define T_PLONG T_LONG *

# define T_SLONG signed long
# define T_PSLONG T_SLONG *

# define T_ULONG unsigned long
# define T_PULONG T_ULONG *

# define T_DWORD unsigned long
# define T_PDWORD T_DWORD *

# define T_INT int
# define T_PINT T_INT *

# define T_SINT signed int
# define T_PSINT T_SINT *

# define T_UINT unsigned int
# define T_PUINT T_UINT *

# define T_VOID void
# define T_PVOID T_VOID *

# define T_FLOAT float
# define T_DOUBLE double
# define T_LDOUBLE long double

#define _MIN_(a,b) (((a)>(b)) ? (b) : (a))


# define T_FALSE 0
# define T_TRUE 1
# define T_BOOL int
# define T_STRING char *
# define T_JA 0
# define T_NEIN 1
# define T_OK 0
# define T_NOT_OK 1

#define T_LOW_BYTE(s)       ((T_CHAR)(s))
#define T_HIGH_BYTE(s)       ((T_CHAR)((T_WORD)(s)>>8))

# ifndef NOT_INITIALIZED
#  define NOT_INITIALIZED -1
# endif

        /* allgemeine Makro-'Funktionen' */
# define T_MAX( A, B ) ( ( (A) > (B) ) ? (A) : (B) )

# define T_ABS(a)  ((a) >= 0 ? (a) : -(a))

# define H1(x) ((T_LONG)x)
# define H2(x) ((T_LONG)(((T_LONG)x)*((T_LONG)x)))
# define H3(x) ((T_LONG)(((T_LONG)x)*((T_LONG)((T_LONG)x)*((T_LONG)x))))
# define H4(x) ((T_LONG)(H2(x)*H2(x)))
# define M1(x) ((T_LONG)x)
# define M2(x) ((T_LONG)(((T_LONG)x)*2))
# define M3(x) ((T_LONG)((T_LONG)((T_LONG)x)*3))
# define T1(x) ((T_LONG)x)
# define T2(x) ((T_LONG)(((T_LONG)x)/2))
# define T3(x) ((T_LONG)(((T_LONG)x)/3))
# define T4(x) ((T_LONG)(((T_LONG)x)/4))
# define M23(x) ((T_LONG)(((T_LONG)x)*2/3))
# define M32(x) ((T_LONG)(((T_LONG)x)*3/2))
# define MAX_OFF(x) ((T_LONG)H3((T_LONG)x)*(T_LONG)2)
# define MED_OFF(x) ((T_LONG)((T_LONG)x)*3)
# define MIN_OFF(x) ((T_LONG)((T_LONG)x)*2)
# define WERT_DIF_MAX_MED(x) ((T_LONG)M3((T_LONG)T_ABS((T_LONG)((T_LONG)x)-2)))
# define WERT_DIF_MAX_MIN(x) ((T_LONG)M3((T_LONG)x))
# define WERT_DIF_MED_MIN(x) ((T_LONG)M3((T_LONG)T_ABS(((T_LONG)x)-2)))
# define HELLIGKEIT_DIF(x) (((T_LONG)(x)))
# define MAX_GRENZE ((T_LONG)H3((T_LONG)T_ABS((T_LONG)T_ABS(RGB1[color_max1]-RGB1[color_med1])+1)))
# define MED_GRENZE ((T_LONG)H2((T_LONG)T_ABS((T_LONG)T_ABS(RGB1[color_min1]-RGB1[color_med1])-0)))
# define MIN_GRENZE ((T_LONG)H2((T_LONG)T_ABS((T_LONG)T_ABS(RGB1[color_min1]-RGB1[color_med1])-0)))

/* farben ... */
# define T_RED 1
# define T_GREEN 0
# define T_BLUE 2

typedef struct
{
 T_PVOID objekt;
 T_PVOID naechstes;
 T_PVOID letztes;
 T_INT   position;
} T_LISTE;

typedef struct
{
 T_INT          x_size;
 T_INT          y_size;
 T_INT          speicher_art;
 T_PVOID        mem_zeiger;
} MEM_BILD;

typedef struct
{
 T_SINT         ebene;
 volatile T_INT status;
 volatile T_INT flag;
 T_PVOID        pointer;
 T_PVOID        variablen;
} VARIABLEN;

typedef struct
{
 T_PVOID        window_element;
 T_PVOID        button_element;
 T_WORD         taste;
 T_WORD         maus_x;
 T_WORD         maus_y;
 T_WORD         maus_button;
 T_UWORD        tastatur_status;
 T_SINT         ebene;
 T_WORD         executed;
} PARAMETER;

typedef struct
{
 T_INT          x_org;
 T_INT          y_org;
 T_INT          x;
 T_INT          y;
 T_INT          x_0;
 T_INT          y_0;
 T_INT          b;
 T_INT          h;
 T_INT          b_open;
 T_INT          h_open;
 T_INT          border_o;
 T_INT          border_u;
 T_INT          border_l;
 T_INT          border_r;
 T_SINT         hide;
 T_INT          dhide; // for dispatcher hiding only!!!
 T_INT          art;
 T_INT          id;
 T_INT          color;
 T_INT          bcolor;
 T_PCHAR        name;
 VARIABLEN     *variablen;
 T_PVOID       *user_data;
 MEM_BILD      *window_pic;
 T_LISTE       *button_first;
 T_LISTE       *button_last;
 PARAMETER     *parameter;
 T_INT          (*destructor)(PARAMETER *parameter);
 T_INT          (*area_funktion)(PARAMETER *parameter);
 T_INT          (*tasten_funktion)(PARAMETER *parameter);
 T_INT          (*update_funktion)(T_INT, T_PVOID);
#ifdef VECTREX
 T_INT          last_x;
 T_INT          last_y;
#endif
} WINDOW_LISTEN_ELEMENT;

typedef struct
{
 T_INT         x_pos;
 T_INT         y_pos;
 T_INT         border;
 T_INT         breite;
 T_INT         hoehe;
 T_INT         color;
 T_INT         bcolor;
 T_INT         art;
 T_INT         id;
 VARIABLEN    *variablen;
 MEM_BILD     *mem_bild;
 T_PCHAR       name;
 T_PCHAR       pcx_bild;
 T_PVOID       destructor;
 T_INT         (*area_funktion)(PARAMETER *parameter);
 T_INT         (*tasten_funktion)(PARAMETER *parameter);
} OPEN_WIN;

typedef struct
{
 T_PCHAR        name;
 MEM_BILD       *bitmap;
 T_INT          breite;
 T_INT          hoehe;
 T_INT          hintergrund;
 T_INT          text_col;
 T_INT          back_col;
 T_INT          shade1_col;
 T_INT          shade2_col;
 T_INT          light1_col;
 T_INT          light2_col;
 T_INT          line_width;
 T_INT          thickness_x;
 T_INT          thickness_y;
 T_UINT         taste;
 T_INT          art;
 T_INT          schalt_art;
 T_PINT         value;               // for check and combo
 T_LISTE       *other_buttons_first; // for combo boxes (buttons)
 T_INT          (*button_funktion)(PARAMETER *parameter);
 T_INT          (*notify_funktion)(PARAMETER *parameter);
} BUTTON;

typedef struct
{
 T_INT          x_offset;
 T_INT          y_offset;
 T_INT          id;
 T_INT          status;
 BUTTON        *button;
} BUTTON_LISTEN_ELEMENT;

typedef struct wininfo
{
 T_SWORD iWinXpos;
 T_SWORD iWinYpos;
 T_SWORD iWinXsize;
 T_SWORD iWinYsize;
}WININFO;

typedef struct
{
 T_INT (*update_funktion)(PARAMETER *parameter);
 T_INT frequency;
} UPDATE_FUNCTION;

# ifdef __cplusplus
}
# endif


#endif
