#ifndef TDISPATC_H
# define TDISPATC_H

# ifdef __cplusplus
        extern "C" {
# endif

# include "standard.h"

# ifdef DISPATCHER

#define PROGRAMM_INIT                                                    \
{                                                                        \
 dispatcher_status=DISPATCHER_STARTING;                                  \
 dispatcher_ebene=0;                                                     \
 dispatcher();                                                           \
}

#define PROGRAMM_ENDE end_dispatcher();
#define WAIT_FOR_REPLY                                                   \
{                                                                        \
 variablen.status = PARAMETER_NOT_RETURNING;                             \
 dispatcher();                                                           \
 if ((dispatcher_status == DISPATCHER_END)   ||                          \
  (variablen.status != PARAMETER_RETURNING)  ||                          \
  (variablen.flag   == T_FALSE ))                                        \
  variablen.pointer=NULL;                                                \
}
# define EXIT_PROC variablen->flag=T_FALSE;
# define ENTRY_PROC variablen->flag=T_TRUE;

/* interner status des dispatchers (in einer globalen variablen) */
#  define DISPATCHER_STARTING 0
#  define DISPATCHER_END 1
#  define DISPATCHER_WORKING 2

#  define CLEAN_RETURN                       \
 variablen->status = PARAMETER_RETURNING;    \
 return parameter->ebene;

#  define DIRTY_RETURN                          \
 variablen->status = PARAMETER_NOT_RETURNING;   \
 return dispatcher_ebene;// 1998 siehe close_win ... //parameter->ebene;

 T_VOID dispatcher(T_VOID);
 T_VOID end_dispatcher(T_VOID);
 T_VOID dispatcher_missmatch(T_VOID);
 T_VOID hide_lower_return_windows(T_INT this_dispatcher_ebene);
 T_VOID show_lower_return_windows(T_INT this_dispatcher_ebene);

 extern T_INT dispatcher_status;
 extern T_INT dispatcher_ebene;
 extern T_INT dispatcher_type;

# endif

# ifdef __cplusplus
}
# endif

#endif
