#ifndef TOOL_H
# define TOOL_H

# ifdef __cplusplus
 extern "C" {
# endif

# include <standard.h>
# include <win_raw.h>
# include <tdispatc.h>
# include <pcx.h>

/* Groessenangeben fuer Message Window */
#define REC_BREITE 100
#define REC_TEXT_OFFSET 3

/* status einer vom dispatcher bearbeiteten funktion */
/* jede vom dispatcher aufegrufene funktion sollte eine der drei letzteren werte zurueckliefern */
# define PARAMETER_NOT_EXECUTED 0
# define PARAMETER_EXECUTED 1
# define PARAMETER_RETURNING 2
# define PARAMETER_NOT_RETURNING 4

/* verschiedene interne button werte */
# define CLOSE_BUTTON 0
# define JA_BUTTON 0
# define NEIN_BUTTON 0

/* fuer texteinfabe */
# define TEXT_INIT 0
# define TEXT_RETURN 1
# define TEXT_ESC 2
# define TEXT_TAB 3
# define TEXT_SHIFT_TAB 4
# define TEXT_CURSOR_UP 5
# define TEXT_CURSOR_DOWN 6
# define TEXT_PAGE_UP 7
# define TEXT_PAGE_DOWN 8

T_VOID init_tools(T_VOID);
T_VOID de_init_tools(T_VOID);
T_VOID print_status_informationen(T_VOID);
T_VOID warte_auf_taste(T_VOID);
T_VOID init_colors(T_VOID);
T_INT zahl_eingabe(T_LONG min_zahl,T_LONG max_zahl,T_INT x,T_INT y,T_BYTE text_col,T_BYTE back_col,T_PLONG vorgabe, WINDOW_LISTEN_ELEMENT *window);
T_INT text_eingabe(T_PCHAR text,T_PINT start_zeichen, T_INT x,T_INT y,T_INT max_chars, T_INT string_length,T_BYTE text_col,T_BYTE back_col, WINDOW_LISTEN_ELEMENT *window);
T_INT zeige_pcx_bild(T_PCHAR dateiname,T_INT x, T_INT y);
WINDOW_LISTEN_ELEMENT *show_message(T_PCHAR text, ...);

typedef T_INT (*ZEIGER_AUF_FUNKTION) (PARAMETER *);
UPDATE_FUNCTION *insert_update_funktion( ZEIGER_AUF_FUNKTION zeiger_auf_funktion, T_INT frequency );
T_INT remove_update_funktion( ZEIGER_AUF_FUNKTION zeiger_auf_funktion );
//UPDATE_FUNCTION *insert_update_funktion( T_INT (*zeiger_auf_funktion)(PARAMETER *), T_INT frequency );
//T_INT remove_update_funktion( T_INT (*zeiger_auf_funktion)(PARAMETER *) );

T_INT execute_drag_button(PARAMETER *parameter);
T_INT execute_hide_button(PARAMETER *parameter);
T_INT execute_close_button(PARAMETER *parameter);
T_INT execute_exit_button(PARAMETER *parameter);
T_INT execute_win_move(PARAMETER *parameter);
T_INT execute_activate(PARAMETER *parameter);
T_INT default_area_funktion_tool(PARAMETER *parameter);

T_VOID remove_current_char(T_PCHAR string);
T_INT is_hex(T_PCHAR word);
T_INT is_dec(T_PCHAR word);
T_INT is_bin(T_PCHAR word);
T_ULONG convert(T_PCHAR start_string, T_UINT radix);
T_PCHAR itob(T_ULONG number,T_PCHAR string);


# ifndef NO_HIDDEN_INFOS
 T_INT interne_tasten_funktion(PARAMETER *parameter);
 T_INT interne_area_funktion(PARAMETER *parameter);
# endif

 /* globale Variablen */
extern T_BYTE weiss,schwarz;
extern T_BYTE hhell_grau, mhell_grau, dhell_grau, hdark_grau, mdark_grau, ddark_grau;
extern T_BYTE f_red,f_green,f_blue,f_yellow,f_pink;

extern T_PCHAR swap_path;
extern T_PCHAR t_hilfe_pfad;
extern T_PCHAR tool_pfad;

extern T_INT (*default_tasten_funktion)(PARAMETER *parameter);
extern T_INT (*default_area_funktion)(PARAMETER *parameter);

extern MEM_BILD *ja;
extern MEM_BILD *nein;
extern MEM_BILD *right;
extern MEM_BILD *left;
extern MEM_BILD *hoch;
extern MEM_BILD *runter;
extern MEM_BILD *dhoch;
extern MEM_BILD *drunter;
extern MEM_BILD *close_pic;
extern MEM_BILD *hide_pic;
extern MEM_BILD *move_pic;
extern MEM_BILD *exit_pic;
extern MEM_BILD *help_pic;
extern MEM_BILD *game_pic;
extern MEM_BILD *config_pic;
extern MEM_BILD *read_pic;
extern MEM_BILD *write_pic;
extern MEM_BILD *screen_pic;
extern MEM_BILD *reboot_pic;

extern T_LISTE *update_funktion_first;
extern T_LISTE *update_funktion_last;

extern T_INT line_scroll_width;
extern T_INT default_back_pixel;
extern T_INT default_button_size;
extern T_PCHAR exit_pic_name;
extern T_PCHAR close_pic_name;
extern T_PCHAR hide_pic_name;
extern T_PCHAR move_pic_name;
extern T_PCHAR ok_pic_name;
extern T_PCHAR not_ok_pic_name;
extern T_PCHAR up_pic_name;
extern T_PCHAR down_pic_name;
extern T_PCHAR left_pic_name;
extern T_PCHAR right_pic_name;
extern T_PCHAR game_pic_name;
extern T_PCHAR help_pic_name;
extern T_PCHAR config_pic_name;
extern T_PCHAR read_pic_name;
extern T_PCHAR write_pic_name;
extern T_PCHAR default_font_name;
extern T_PCHAR default_pic_name;
extern T_PCHAR tool_dat_dir;
extern T_PCHAR help_dat_dir;
extern T_PCHAR screen_pic_name;
extern T_PCHAR reboot_pic_name;

# ifdef __cplusplus
 }
# endif

#endif

