#ifndef TPRINT_H
# define TPRINT_H

# ifdef __cplusplus
 extern "C" {
# endif

#include "standard.h"
#include "win_raw.h"

/* alles clipping bisher nur auf endkoordinaten */
/* fuer save_back() */
# define FORCED_SAVE 1 /* dieses fenster neu ganz neu zeichnen */
# define NOT_FORCED_SAVE 0 /* dieses fenster neu ganz neu zeichnen */

#define t_hide_win_mouse(window)    \
vesa_mouse_verstecke_cursor(        \
window->x,                          \
window->y,                          \
window->x+window->b,                \
window->y+window->h                 \
);
#define t_show_win_mouse(window)    \
vesa_mouse_zeige_cursor(            \
window->x,                          \
window->y,                          \
window->x+window->b,                \
window->y+window->h                 \
);

T_INT back_show(T_VOID);
T_INT back_save(T_INT flag);
extern MEM_BILD *back_pic;
#ifdef VECTREX
extern MEM_BILD *mback_pic;
#endif

extern T_PCHAR text_ausgabe;
extern T_PCHAR mem_bild_buffer;
extern T_INT is_upper;

/* neue prints */

# define PRINT_RAW 1
# define PRINT_CLIPPED 2
# define PRINT_WIN_RAW 3
# define PRINT_WIN_RAW_CLIPPED 4
# define PRINT_RAW_OC 5
# define PRINT_CLIPPED_OC 6

/* allgemeine funktionen */
T_VOID print_with_all_features(WINDOW_LISTEN_ELEMENT *window, T_INT flag ,T_INT x, T_INT y, T_INT max_pix, T_PCHAR string,...);
T_VOID print_membild_with_all_features(MEM_BILD *source, WINDOW_LISTEN_ELEMENT *window, T_INT flag ,T_INT x, T_INT y,T_INT x_offset,T_INT y_offset, T_INT len_x,T_INT len_y);
T_VOID print_rectfill_with_all_features(WINDOW_LISTEN_ELEMENT *window, T_INT flag ,T_INT x, T_INT y, T_INT len_x,T_INT len_y,T_BYTE color);
T_VOID print_srect(WINDOW_LISTEN_ELEMENT *this_window,T_INT flag,T_INT x, T_INT y, T_INT b, T_INT h,T_BYTE col1, T_BYTE col2, T_INT thick);
T_VOID print_button(WINDOW_LISTEN_ELEMENT *window ,BUTTON *button,T_INT flag, T_INT x, T_INT y, T_INT art, T_PINT status);

/* hilfsfunktionen wenn MAKRO nicht verwendbar */
T_VOID _pc__(WINDOW_LISTEN_ELEMENT *window, T_INT flag ,T_INT x, T_INT y, T_INT len_x, T_CHAR zeichen);

/* shortcuts und allgemeines */
#define _p__  print_with_all_features
#define _pm__ print_membild_with_all_features
#define _pf__ print_rectfill_with_all_features
#define print_linev(window,flag,x,y,len_y,color) _pf__(window,flag,x,y,1,len_y,color)
#define print_lineh(window,flag,x,y,len_x,color) _pf__(window,flag,x,y,len_x,1,color)

/* background funktionen */
#define bprint(x,y,string)                                  _p__(NULL,PRINT_CLIPPED,x,y,PMAX,string)
#define bprinta0 bprint
#define bprinta1(x,y,string,a)                              _p__(NULL,PRINT_CLIPPED,x,y,PMAX,string,a)
#define bprinta2(x,y,string,a,b)                            _p__(NULL,PRINT_CLIPPED,x,y,PMAX,string,a,b)
#define bprinta3(x,y,string,a,b,c)                          _p__(NULL,PRINT_CLIPPED,x,y,PMAX,string,a,b,c)
#define bprint_char(x,y,z)                                  _pc_(NULL,PRINT_CLIPPED,x,y,font_now->zeichen[(T_BYTE)z].breite,z)
#define bprint_max(x,y,len,string)                          _p__(NULL,PRINT_CLIPPED,x,y,len,string)

#define bprint_maxa0 bprint_max
#define bprint_maxa1(x,y,len,string,a)                      _p__(NULL,PRINT_CLIPPED,x,y,len,string,a)
#define bprint_maxa2(x,y,len,string,a,b)                    _p__(NULL,PRINT_CLIPPED,x,y,len,string,a,b)
#define bprint_maxa3(x,y,len,string,a,b,c)                  _p__(NULL,PRINT_CLIPPED,x,y,len,string,a,b,c)

#define bprint_bild(bild,x,y)                               _pm__(bild,NULL,PRINT_CLIPPED,x,y,0,0,PMAX,PMAX)
#define bprint_tbild(bild,x,y,xo,yo)                        _pm__(bild,NULL,PRINT_CLIPPED,x,y,xo,yo,PMAX,PMAX)
#define bprint_frect(x,y,len_x,len_y,color)                 _pf__(NULL,PRINT_CLIPPED,x,y,len_x,len_y,color)
#define bprint_srect(x,y,breite,hoehe,col1,col2,width)      print_srect(NULL,PRINT_CLIPPED,x,y,breite,hoehe,col1,col2,width)
#define bprint_wrect(x,y,breite,hoehe,col,width)            bprint_srect(x,y,breite,hoehe,col,col,width)
#define bprint_rect(x,y,breite,hoehe,col)                   bprint_srect(x,y,breite,hoehe,col,col,1)
#define bprint_linev(x,y,len_y,color)                       _pf__(NULL,PRINT_CLIPPED,x,y,1,len_y,color)
#define bprint_lineh(x,y,len_x,color)                       _pf__(NULL,PRINT_CLIPPED,x,y,len_x,1,color)
#define bprint_button(but,state)                              print_button(NULL,((BUTTON_LISTEN_ELEMENT *)(but))->button,PRINT_CLIPPED,(((BUTTON_LISTEN_ELEMENT *)(but)))->x_offset, \
                                                              (((BUTTON_LISTEN_ELEMENT *)(but)))->y_offset, state,(T_PINT) (&((((BUTTON_LISTEN_ELEMENT *)(but)))->status)))

/* window funktionen */
#define wprint(window,x,y,string)                             _p__(window, PRINT_CLIPPED,x,y,PMAX,string)
#define wprinta0 wprint
#define wprinta1(window,x,y,string,a)                         _p__(window, PRINT_CLIPPED,x,y,PMAX,string,a)
#define wprinta2(window,x,y,string,a,b)                       _p__(window, PRINT_CLIPPED,x,y,PMAX,string,a,b)
#define wprinta3(window,x,y,string,a,b,c)                     _p__(window, PRINT_CLIPPED,x,y,PMAX,string,a,b,c)
#define wprint_char(window,x,y,z)                             _pc__(window,PRINT_CLIPPED,x,y,font_now->zeichen[(T_BYTE)z].breite,z)
#define wprint_max(window,x,y,len,string)                     _p__(window, PRINT_CLIPPED,x,y,len,string)
#define wprint_maxa0 wprint_max
#define wprint_maxa1(window,x,y,len,string,a)                 _p__(window, PRINT_CLIPPED,x,y,len,string,a)
#define wprint_maxa2(window,x,y,len,string,a,b)               _p__(window, PRINT_CLIPPED,x,y,len,string,a,b)
#define wprint_maxa3(window,x,y,len,string,a,b,c)             _p__(window, PRINT_CLIPPED,x,y,len,string,a,b,c)
#define wprint_bild(window,bild,x,y)                          _pm__(bild,window,PRINT_CLIPPED,x,y,0,0,PMAX,PMAX)
#define wprint_tbild(window,bild,x,y,xo,yo)                   _pm__(bild,window,PRINT_CLIPPED,x,y,xo,yo,PMAX,PMAX)
#define wprint_frect(window,x,y,len_x,len_y,color)            _pf__(window,PRINT_CLIPPED,x,y,len_x,len_y,color)
#define wprint_srect(window,x,y,breite,hoehe,col1,col2,width) print_srect(window,PRINT_CLIPPED,x,y,breite,hoehe,col1,col2,width)
#define wprint_wrect(window,x,y,breite,hoehe,col,width)       wprint_srect(window,x,y,breite,hoehe,col,col,width)
#define wprint_rect(window,x,y,breite,hoehe,col)              wprint_srect(window,x,y,breite,hoehe,col,col,1)
#define wprint_linev(window,x,y,len_y,color)                  _pf__(window,PRINT_CLIPPED,x,y,1,len_y,color)
#define wprint_lineh(window,x,y,len_x,color)                  _pf__(window,PRINT_CLIPPED,x,y,len_x,1,color)
#define wprint_button(window,but,state)                       print_button(window,((BUTTON_LISTEN_ELEMENT *)(but))->button,PRINT_CLIPPED,(((BUTTON_LISTEN_ELEMENT *)(but)))->x_offset, \
                                                              (((BUTTON_LISTEN_ELEMENT *)(but)))->y_offset, state,(T_PINT) (&((((BUTTON_LISTEN_ELEMENT *)(but)))->status)))
/* raw funktionen */
#define rprinta0(x,y,string) _p__(NULL,PRINT_RAW,x,y,PMAX,string)
#define rprinta1(x,y,string,a) _p__(NULL,PRINT_RAW,x,y,PMAX,string,a)
#define rprinta2(x,y,string,a,b) _p__(NULL,PRINT_RAW,x,y,PMAX,string,a,b)
#define rprinta3(x,y,string,a,b,c) _p__(NULL,PRINT_RAW,x,y,PMAX,string,a,b,c)

 # ifdef __cplusplus
 }
# endif

#endif
