#ifndef WIN_RAW_H
# define WIN_RAW_H

# ifdef __cplusplus
        extern "C" {
# endif

#include "standard.h"
#include "d_list.h"
#include "tdispatc.h"
#include "bild.h"

#define UPDATE_AFTER_MOVE 1
#define UPDATE_AFTER_HIDE 2
#define UPDATE_AFTER_SHOW 3


/* arten fenster neu zu zeichnen/aktivieren */
#define REPAIR 0                      /* zeichne alles unter diesem fenster auf den bildschirm (dieses fenster wird also geloescht ), auch den Hintergrund neu zeichnen */
#define UPDATE_VISIBLE_BACK_RECT 1    /* Zeichne den Hintergrund neu, ueber dem kein Fenster liegt (in dem angegebenen Rechteck) */
#define UPDATE_VISIBLE_WINDOW_RECT 2  /* Zeichne dieses Fenster dort neu, wo es nicht ueberlagert wird (in dem angegebenen Rechteck)*/
#define ACTIVATE 3                    /* Alles was 'ueber' diesem Fenster ist neu zeichnen, zum aktivieren halt */
#define FORCED 4                      /* dieses fenster neu ganz neu zeichnen von oben bis unten links und rechts */
#define NOT_FORCED 5                  /* keine ahnung mehr */
#define REPAIR_BORDER 6               /* nur einen verschobenen Rand eines fensters reparieren, zwei positionsangaben notwendig, alles zwischen den positionen wird repariert (neu auf den Bildschirm gebracht) */
#define REDRAW_WINDOW 7               /* Fenster neu auf dieser Position zeichnen, das heisst nur da, wo es nicht von anderen Fenstern ueberlagert wird (fuer hidden windows) */
#define HIDE_WINDOW 8                 /* alles unter diesem fenster neu zeichnen */
#define LOWER_WINDOW 9                /* Wie REPAIR, nur den Hintergrund nicht zeichnen */
#define LOWER_TILL_BACKDROP 10        /* alles in dem rechteck neu zeichnen, bis auf die Tiefe des angegebenen WINDOW */

#define POSITION_HIGHER 11
#define POSITION_LOWER 12

#define CLOSE_FORCED 1
#define CLOSE_DEFAULT 2
#define CLOSE_NO_REDRAW 4
#define CLOSE_SHUTDOWN (CLOSE_FORCED | CLOSE_NO_REDRAW)

#define WIN_OPEN_CHOOSES_ID 0

/* arten fenster zu bewegen */
# define GANZ 1
# define NICHT_GANZ 0

/* verschiedene fenster stati */
# define RAW_WINDOW 1                      /* OK */
# define MEM_PIC_WINDOW 2                  /* NOT OK */  /* backdrop und front eigenschaften fehlen noch */
# define PCX_WINDOW 4                      /* NOT OK */  /* backdrop und front eigenschaften fehlen noch */
# define VIRTUAL_FRONT_WINDOW 8            /* OK */
# define WITH_CLOSE_BUTTON 16              /* OK */
# define WITH_DRAG_BUTTON 32               /* OK */
# define WITH_RESIZE_BUTTON 64
# define WITH_STAY_UP_BUTTON 128
# define WITH_STAY_DOWN_BUTTON 256
# define WITH_SCALING_BUTTON 512
# define WITH_HIDE_BUTTON 1024             /* OK */
# define FRONT_WINDOW 2048                 /* OK */
# define BACK_WINDOW 4096                  /* OK */
# define AREA_WINDOW 8192                  /* OK */
# define UNBEWEGBAR 16384                  /* OK */
# define RETURNING  32768                  /* OK */
# define REMEMBER (2*RETURNING)            /* OK */
# define EDIT_TRUE (2*REMEMBER)            /* OK aligned to 8/16 pixel */

WINDOW_LISTEN_ELEMENT *open_window(OPEN_WIN *window_parameter);
WINDOW_LISTEN_ELEMENT *is_mouse_on_window(T_VOID);
WINDOW_LISTEN_ELEMENT *get_window(T_INT window_id);
T_INT close_window(WINDOW_LISTEN_ELEMENT *this_window,T_INT flag);
T_INT repair_screen(WINDOW_LISTEN_ELEMENT *this_window, T_INT flag,T_INT border_x,T_INT border_y, T_INT len_x, T_INT len_y);
T_INT add_window_button(WINDOW_LISTEN_ELEMENT *this_window, BUTTON *this_button,T_INT x_off,T_INT y_off, T_INT id);
T_INT is_mouse_on_this_window(WINDOW_LISTEN_ELEMENT *this_window);
T_INT window_exist(T_INT window_id);
T_INT aktivate_window_id(T_INT window_id);
T_VOID aktivate_window(WINDOW_LISTEN_ELEMENT *this_window);
T_INT update_whole_window(WINDOW_LISTEN_ELEMENT *this_window);
T_INT move_raw_window(T_WORD x,T_WORD y,WINDOW_LISTEN_ELEMENT *window);
T_INT hide_raw_window(WINDOW_LISTEN_ELEMENT *window);
T_INT show_raw_window(WINDOW_LISTEN_ELEMENT *window);
T_INT move_window(WINDOW_LISTEN_ELEMENT *this_window);
// T_VOID draw_window_shaded_rectangle(WINDOW_LISTEN_ELEMENT *this_window,T_INT x, T_INT y, T_INT b, T_INT h,T_BYTE col1, T_BYTE col2,T_INT thick);
T_VOID hide_all_windows(T_VOID);
T_VOID show_all_windows(T_VOID);
T_VOID redraw_all_windows(T_VOID);
T_VOID lower_window(WINDOW_LISTEN_ELEMENT *this_window);
T_VOID close_all_windows(T_VOID);
T_INT get_hidden_anzahl(T_VOID);
T_INT touching_windows(T_INT x,T_INT y,T_INT b,T_INT h, WINDOW_LISTEN_ELEMENT *window);
T_INT touching_upper_windows(T_INT x,T_INT y,T_INT b,T_INT h, WINDOW_LISTEN_ELEMENT *window);
T_INT touching_lower_windows(T_INT x,T_INT y,T_INT b,T_INT h, WINDOW_LISTEN_ELEMENT *window);

/* globale Variablen */
extern T_INT win_raw_error;
extern T_LISTE *window_first;
extern T_LISTE *window_last;
extern MEM_BILD *back_pic;
extern T_INT windows_open;
extern T_INT windows_shown;
extern T_INT win_bewegungsart;
extern T_INT (*back_tasten_funktion)(PARAMETER *parameter);
extern T_INT (*back_area_funktion)(PARAMETER *parameter);
extern T_INT button_raw;

# ifdef __cplusplus
        }
# endif


#endif
