#include <stdio.h>  /* fuer FILE */
#include <stdlib.h> /* fuer malloc() */
#include <mem.h>
#include <string.h>
#include <io.h>

#include "vesa.h" /* zeile und zeile_hilf */
#include "pcx.h"
#include "error.h"
#include "file.h"
#include "tool.h"
#include "bild.h"

/* initialisierung globaler Variablen */
T_INT bild_error=T_OK;

/* Module globale Funktionen */
MEM_BILD *lade_pcx_nach_m(T_PCHAR dateiname);
MEM_BILD *lade_pcx_nach_hd (T_PCHAR dateiname);

MEM_BILD *lade_vga_nach_m(T_INT x, T_INT y, T_INT len_x, T_INT len_y);
MEM_BILD *lade_vga_nach_hd(T_INT x, T_INT y, T_INT len_x, T_INT len_y);
MEM_BILD *lade_vga_nach_m_oc(T_INT x, T_INT y, T_INT len_x, T_INT len_y);
MEM_BILD *lade_vga_nach_hd_oc(T_INT x, T_INT y, T_INT len_x, T_INT len_y);

MEM_BILD *clone_membild(MEM_BILD *m_bild);

T_INT print_m_bild(MEM_BILD *m_bild,T_INT x,T_INT y);
T_INT print_hd_bild(MEM_BILD *hd_bild ,T_INT x,T_INT y);
T_INT print_m_bild_oc(MEM_BILD *m_bild,T_INT x,T_INT y);
T_INT print_hd_bild_oc(MEM_BILD *hd_bild ,T_INT x,T_INT y);

T_INT print_m_teilbild(MEM_BILD *m_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h);
T_INT print_hd_teilbild(MEM_BILD *hd_bild ,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h);
T_INT print_m_teilbild_oc(MEM_BILD *m_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h);
T_INT print_hd_teilbild_oc(MEM_BILD *hd_bild ,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h);

T_INT lade_vga_nach_m_teil(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT x_off, T_INT y_off, MEM_BILD *mem_bild);
T_INT lade_vga_nach_hd_teil(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT x_off, T_INT y_off, MEM_BILD *mem_bild);
T_INT lade_vga_nach_m_teil_oc(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT x_off, T_INT y_off, MEM_BILD *mem_bild);
T_INT lade_vga_nach_hd_teil_oc(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT x_off, T_INT y_off, MEM_BILD *mem_bild);

T_INT lade_mem_nach_m_teil(MEM_BILD *bild_source, T_INT s_x, T_INT s_y, MEM_BILD *bild_dest, T_INT d_x, T_INT d_y, T_INT x_len, T_INT y_len, T_INT flag);
T_INT lade_mem_nach_hd_teil(MEM_BILD *bild_source, T_INT s_x, T_INT s_y, MEM_BILD *bild_dest, T_INT d_x, T_INT d_y, T_INT x_len, T_INT y_len, T_INT flag);

T_INT get_mem_zeile(MEM_BILD *mem_bild, T_INT off_x, T_INT off_y, T_INT len, T_INT flag);

/* laed ein pcx bild in den 'hohen' speicher oder wanders hin, */
/* falls dort kein platz mehr ist */
MEM_BILD *lade_pcx_nach_mem(T_PCHAR dateiname,T_INT mem_flag)
{
 MEM_BILD *neues_bild=NULL;
 T_DEBUG_ENTRY("lade_pcx_nach_mem",40)
 if ((neues_bild==NULL)&&(!(mem_flag&NO_MEM)))
  neues_bild=lade_pcx_nach_m(dateiname);
 if ((neues_bild==NULL)&&(!(mem_flag&NO_HD)))
  neues_bild=lade_pcx_nach_hd(dateiname);
 T_DEBUG_LEAVE
 return neues_bild;
}

/***************************************************************/

MEM_BILD *lade_pcx_nach_m(T_PCHAR dateiname)
{
 T_ULONG p;
 T_PBYTE zeiger;
 T_PBYTE zeiger_pointer;
 T_PBYTE zeilen_pointer;
 MEM_BILD *rueckgabe;
 T_DEBUG_ENTRY("lade_pcx_nach_m",35)
 if ((rueckgabe=(MEM_BILD *)malloc(sizeof(MEM_BILD)))==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 if (pcx_open_file(dateiname)!=T_OK)
 {
  free(rueckgabe);
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return NULL;
 }
 p=(pcx_header.xmax+1-pcx_header.xmin)*(pcx_header.ymax-pcx_header.ymin+1);
 zeiger=(T_PBYTE )malloc((T_INT)p);
 if (zeiger==NULL)
 {
  free(rueckgabe);
  pcx_close_file();
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
 zeiger_pointer=zeiger;
 if (pcx_bild_art==BILD_IST_256_FARBE_BILD)
 {
  if (pcx_set_file_color_flag==T_TRUE)
   pcx_set_color256();
  for (p=0; p<(pcx_header.ymax+1-pcx_header.ymin); p++)
  {
   pcx_get_zeile256();
   memcpy(zeiger_pointer,zeilen_pointer,pcx_header.xmax-pcx_header.xmin+1);
   zeiger_pointer+=pcx_header.xmax-pcx_header.xmin+1;
  }
 }
 if (pcx_bild_art==BILD_IST_16_FARBE_BILD)
 {
  if (pcx_set_file_color_flag==T_TRUE)
   pcx_set_color16(pcx_color16_default);
  for (p=0; p<(pcx_header.ymax+1-pcx_header.ymin); p++)
  {
   pcx_get_zeile16(pcx_color16_default);
   memcpy(zeiger_pointer,zeilen_pointer,pcx_header.xmax-pcx_header.xmin+1);
   zeiger_pointer+=pcx_header.xmax-pcx_header.xmin+1;
  }
 }
 pcx_close_file();
 rueckgabe->mem_zeiger=zeiger;
 rueckgabe->x_size=pcx_header.xmax-pcx_header.xmin+1;
 rueckgabe->y_size=pcx_header.ymax-pcx_header.ymin+1;
 rueckgabe->speicher_art=SPEICHER;
 T_DEBUG_LEAVE
 return rueckgabe;
}

/***************************************************************/

MEM_BILD *lade_pcx_nach_hd(T_PCHAR dateiname)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 T_PCHAR filename="\\tmp00000.swp";
 T_PCHAR fname;
 FILE *this_file=NULL;
 MEM_BILD *rueckgabe;
 T_DEBUG_ENTRY("lade_pcx_nach_hd",35)
 fname=(T_PCHAR ) malloc(strlen(swap_path)+14);
 if (fname==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 strcpy(fname,swap_path);
 strcpy(fname+strlen(swap_path),filename);
 if ((rueckgabe=(MEM_BILD *)malloc(sizeof(MEM_BILD)))==NULL)
 {
  free(fname);
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 if (pcx_open_file(dateiname)!=T_OK)
 {
  free(rueckgabe);
  free(fname);
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return NULL;
 }
 while ((this_file = fopen(fname, "rb"))!= NULL)
 {
  fclose(this_file);
  fname[strlen(swap_path)+8]++;
  if (fname[strlen(swap_path)+8]=='9'+1)
  {
   fname[strlen(swap_path)+8]='0';
   fname[strlen(swap_path)+7]++;
   if (fname[strlen(swap_path)+7]=='9'+1)
   {
    fname[strlen(swap_path)+7]='0';
    fname[strlen(swap_path)+6]++;
    if (fname[strlen(swap_path)+6]=='9'+1)
    {
     fname[strlen(swap_path)+6]='0';
     fname[strlen(swap_path)+5]++;
     if (fname[strlen(swap_path)+5]=='9'+1)
     {
      fname[strlen(swap_path)+5]='0';
      fname[strlen(swap_path)+4]++;
     }
    }
   }
  }
 }
 this_file = fopen(fname, "w+b");
 if (this_file==NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  pcx_close_file();
  free(fname);
  free(rueckgabe);
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return NULL;
 }
 zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
 if (pcx_bild_art==BILD_IST_256_FARBE_BILD)
 {
  if (pcx_set_file_color_flag==T_TRUE)
   pcx_set_color256();
  for (p=0; p<(pcx_header.ymax+1-pcx_header.ymin); p++)
  {
   pcx_get_zeile256();
   fwrite(zeilen_pointer,pcx_header.xmax-pcx_header.xmin+1,1,this_file);
  }
 }
 if (pcx_bild_art==BILD_IST_16_FARBE_BILD)
 {
  if (pcx_set_file_color_flag==T_TRUE)
   pcx_set_color16(pcx_color16_default);
  for (p=0; p<(pcx_header.ymax+1-pcx_header.ymin); p++)
  {
   pcx_get_zeile16(pcx_color16_default);
   fwrite(zeilen_pointer,pcx_header.xmax-pcx_header.xmin+1,1,this_file);
  }
 }
 pcx_close_file();
 fclose(this_file);
 rueckgabe->mem_zeiger=fname;
 rueckgabe->x_size=pcx_header.xmax-pcx_header.xmin+1;
 rueckgabe->y_size=pcx_header.ymax-pcx_header.ymin+1;
 rueckgabe->speicher_art=HD_SPEICHER;
 T_DEBUG_LEAVE
 return rueckgabe;
}

/***************************************************************/

MEM_BILD *lade_vga_nach_mem(T_INT x1, T_INT y1, T_INT len_x, T_INT len_y,T_INT mem_flag)
{
 MEM_BILD *neues_bild=NULL;
 T_DEBUG_ENTRY("lade_vga_nach_mem",35)
 if ((neues_bild==NULL)&&(!(mem_flag&NO_MEM)))
  neues_bild=lade_vga_nach_m(x1,y1,len_x,len_y);
 if ((neues_bild==NULL)&&(!(mem_flag&NO_HD)))
  neues_bild=lade_vga_nach_hd(x1,y1,len_x,len_y);
 if (neues_bild==NULL)
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
 T_DEBUG_LEAVE
 return neues_bild;
}
MEM_BILD *lade_vga_nach_mem_oc(T_INT x1, T_INT y1, T_INT len_x, T_INT len_y,T_INT mem_flag)
{
 MEM_BILD *neues_bild=NULL;
 T_DEBUG_ENTRY("lade_vga_nach_mem_oc",35)
 if ((neues_bild==NULL)&&(!(mem_flag&NO_MEM)))
  neues_bild=lade_vga_nach_m_oc(x1,y1,len_x,len_y);
 if ((neues_bild==NULL)&&(!(mem_flag&NO_HD)))
  neues_bild=lade_vga_nach_hd_oc(x1,y1,len_x,len_y);
 if (neues_bild==NULL)
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
 T_DEBUG_LEAVE
 return neues_bild;
}

/***************************************************************/

MEM_BILD *lade_vga_nach_m(T_INT x1, T_INT y1, T_INT len_x, T_INT len_y)
{
 T_INT p;
 T_PBYTE zeiger;
 T_PBYTE zeiger_pointer;
 T_PBYTE zeilen_pointer;
 MEM_BILD *rueckgabe;
 T_DEBUG_ENTRY("lade_vga_nach_m",35)
 if ((rueckgabe=(MEM_BILD *)malloc(sizeof(MEM_BILD)))==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 zeiger=(T_PBYTE)malloc(len_x*len_y);
 zeiger_pointer=zeiger;
 if (zeiger==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  free(rueckgabe);
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 pcx_zeile_eines_bildes256.zeilen_laenge=len_x;
 zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
 vesa_mouse_verstecke_cursor(x1,y1,x1+len_x,y1+len_y);
 for (p=0;p<len_y;p++)
 {
  vesa_get_zeile_oc(x1,y1+p,len_x,zeilen_pointer);
  memcpy(zeiger_pointer,zeilen_pointer,len_x);
  zeiger_pointer+=len_x;
 }
 vesa_mouse_zeige_cursor(x1,y1,x1+len_x,y1+len_y);
 rueckgabe->x_size=len_x;
 rueckgabe->y_size=len_y;
 rueckgabe->speicher_art=SPEICHER;
 rueckgabe->mem_zeiger=zeiger;
 T_DEBUG_LEAVE
 return rueckgabe;
}
MEM_BILD *lade_vga_nach_m_oc(T_INT x1, T_INT y1, T_INT len_x, T_INT len_y)
{
 T_INT p;
 T_PBYTE zeiger;
 T_PBYTE zeiger_pointer;
 T_PBYTE zeilen_pointer;
 MEM_BILD *rueckgabe;
 T_DEBUG_ENTRY("lade_vga_nach_m_oc",35)
 if ((rueckgabe=(MEM_BILD *)malloc(sizeof(MEM_BILD)))==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 zeiger=(T_PBYTE)malloc(len_x*len_y);
 zeiger_pointer=zeiger;
 if (zeiger==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  free(rueckgabe);
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 pcx_zeile_eines_bildes256.zeilen_laenge=len_x;
 zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
 for (p=0;p<len_y;p++)
 {
  vesa_get_zeile_oc(x1,y1+p,len_x,zeilen_pointer);
  memcpy(zeiger_pointer,zeilen_pointer,len_x);
  zeiger_pointer+=len_x;
 }
 rueckgabe->x_size=len_x;
 rueckgabe->y_size=len_y;
 rueckgabe->speicher_art=SPEICHER;
 rueckgabe->mem_zeiger=zeiger;
 T_DEBUG_LEAVE
 return rueckgabe;
}

/***************************************************************/

MEM_BILD *lade_vga_nach_hd(T_INT x1, T_INT y1, T_INT len_x, T_INT len_y)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 T_PCHAR filename="\\tmp00000.swp";
 T_PCHAR fname=NULL;
 FILE *this_file=NULL;
 MEM_BILD *rueckgabe;
 T_DEBUG_ENTRY("lade_vga_nach_hd",35)
 fname=(T_PCHAR ) malloc(strlen(swap_path)+14);
 if (fname==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 strcpy(fname,swap_path);
 strcpy(fname+strlen(swap_path),filename);
 if ((rueckgabe=(MEM_BILD *)malloc(sizeof(MEM_BILD)))==NULL)
 {
  free(fname);
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 while ((this_file = fopen(fname, "rb"))!= NULL)
 {
  fclose(this_file);
  fname[strlen(swap_path)+8]++;
  if (fname[strlen(swap_path)+8]=='9'+1)
  {
   fname[strlen(swap_path)+8]='0';
   fname[strlen(swap_path)+7]++;
   if (fname[strlen(swap_path)+7]=='9'+1)
   {
    fname[strlen(swap_path)+7]='0';
    fname[strlen(swap_path)+6]++;
    if (fname[strlen(swap_path)+6]=='9'+1)
    {
     fname[strlen(swap_path)+6]='0';
     fname[strlen(swap_path)+5]++;
     if (fname[strlen(swap_path)+5]=='9'+1)
     {
      fname[strlen(swap_path)+5]='0';
      fname[strlen(swap_path)+4]++;
     }
    }
   }
  }
 }
 this_file = fopen(fname, "w+b");
 if (this_file==NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  free(fname);
  free(rueckgabe);
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return NULL;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 pcx_zeile_eines_bildes256.zeilen_laenge=len_x;
 zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
 vesa_mouse_verstecke_cursor(x1,y1,x1+len_x,y1+len_y);
 for (p=0; p<len_y; p++)
 {
  vesa_get_zeile_oc(x1,y1+p,len_x,zeilen_pointer);
  fwrite(zeilen_pointer,len_x,1,this_file);
 }
 vesa_mouse_zeige_cursor(x1,y1,x1+len_x,y1+len_y);
 fclose(this_file);
 rueckgabe->mem_zeiger=fname;
 rueckgabe->x_size=len_x;
 rueckgabe->y_size=len_y;
 rueckgabe->speicher_art=HD_SPEICHER;
 T_DEBUG_LEAVE
 return rueckgabe;
}

MEM_BILD *lade_vga_nach_hd_oc(T_INT x1, T_INT y1, T_INT len_x, T_INT len_y)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 T_PCHAR filename="\\tmp00000.swp";
 T_PCHAR fname=NULL;
 FILE *this_file=NULL;
 MEM_BILD *rueckgabe;
 T_DEBUG_ENTRY("lade_vga_nach_hd_oc",35)
 fname=(T_PCHAR ) malloc(strlen(swap_path)+14);
 if (fname==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 strcpy(fname,swap_path);
 strcpy(fname+strlen(swap_path),filename);
 if ((rueckgabe=(MEM_BILD *)malloc(sizeof(MEM_BILD)))==NULL)
 {
  free(fname);
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 while ((this_file = fopen(fname, "rb"))!= NULL)
 {
  fclose(this_file);
  fname[strlen(swap_path)+8]++;
  if (fname[strlen(swap_path)+8]=='9'+1)
  {
   fname[strlen(swap_path)+8]='0';
   fname[strlen(swap_path)+7]++;
   if (fname[strlen(swap_path)+7]=='9'+1)
   {
    fname[strlen(swap_path)+7]='0';
    fname[strlen(swap_path)+6]++;
    if (fname[strlen(swap_path)+6]=='9'+1)
    {
     fname[strlen(swap_path)+6]='0';
     fname[strlen(swap_path)+5]++;
     if (fname[strlen(swap_path)+5]=='9'+1)
     {
      fname[strlen(swap_path)+5]='0';
      fname[strlen(swap_path)+4]++;
     }
    }
   }
  }
 }
 this_file = fopen(fname, "w+b");
 if (this_file==NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  free(fname);
  free(rueckgabe);
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return NULL;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 pcx_zeile_eines_bildes256.zeilen_laenge=len_x;
 zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
 for (p=0; p<len_y; p++)
 {
  vesa_get_zeile_oc(x1,y1+p,len_x,zeilen_pointer);
  fwrite(zeilen_pointer,len_x,1,this_file);
 }
 fclose(this_file);
 rueckgabe->mem_zeiger=fname;
 rueckgabe->x_size=len_x;
 rueckgabe->y_size=len_y;
 rueckgabe->speicher_art=HD_SPEICHER;
 T_DEBUG_LEAVE
 return rueckgabe;
}

/***************************************************************/

T_INT print_mem_bild(MEM_BILD *mem_bild,T_INT x,T_INT y)
{
 T_DEBUG_ENTRY("print_mem_bild",35)
 if (mem_bild->speicher_art==SPEICHER)
  print_m_bild(mem_bild,x,y);
 if (mem_bild->speicher_art==HD_SPEICHER)
  print_hd_bild(mem_bild,x,y);
 T_DEBUG_LEAVE
 return 0;
}
T_INT print_mem_bild_oc(MEM_BILD *mem_bild,T_INT x,T_INT y)
{
 T_DEBUG_ENTRY("print_mem_bild_oc",35)
 if (mem_bild->speicher_art==SPEICHER)
  print_m_bild_oc(mem_bild,x,y);
 if (mem_bild->speicher_art==HD_SPEICHER)
  print_hd_bild_oc(mem_bild,x,y);
 T_DEBUG_LEAVE
 return 0;
}

/***************************************************************/

T_INT print_m_bild(MEM_BILD *m_bild,T_INT x,T_INT y) /* nur fuer kleine bilder < 64K gedacht */
{
 T_INT p;
 T_PUCHAR zeiger=(T_PUCHAR )m_bild->mem_zeiger;;
 T_DEBUG_ENTRY("print_m_bild",35)
 vesa_mouse_verstecke_cursor(x,y,x+m_bild->x_size,y+m_bild->y_size);
 for (p=0;p<(m_bild->y_size); p++)
 {
  vesa_print_zeile256_oc(x,y+p,zeiger,m_bild->x_size);
  zeiger+=m_bild->x_size;
 }
 vesa_mouse_zeige_cursor(x,y,x+m_bild->x_size,y+m_bild->y_size);
 T_DEBUG_LEAVE
 return T_OK;
}
T_INT print_m_bild_oc(MEM_BILD *m_bild,T_INT x,T_INT y) /* nur fuer kleine bilder < 64K gedacht */
{
 T_INT p;
 T_PUCHAR zeiger=(T_PUCHAR )m_bild->mem_zeiger;;
 T_DEBUG_ENTRY("print_m_bild_oc",35)
 for (p=0;p<(m_bild->y_size); p++)
 {
  vesa_print_zeile256_oc(x,y+p,zeiger,m_bild->x_size);
  zeiger+=m_bild->x_size;
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT print_hd_bild(MEM_BILD *hd_bild,T_INT x,T_INT y)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 FILE *this_file=NULL;
 T_DEBUG_ENTRY("print_hd_bild",35)
 if ((this_file =fopen((const T_PCHAR )hd_bild->mem_zeiger,(const T_PCHAR ) "rb"))== NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 fseek(this_file,0,FROM_FILE_START);
 zeilen_pointer=(T_PBYTE )pcx_zeile_eines_bildes256.zeile;
 vesa_mouse_verstecke_cursor(x,y,x+hd_bild->x_size,y+hd_bild->y_size);
 for (p=0; p<hd_bild->y_size; p++)
 {
  fread(zeilen_pointer, 1, hd_bild->x_size,this_file);
  vesa_print_zeile256_oc(x,y+p,zeilen_pointer,hd_bild->x_size);
 }
 vesa_mouse_zeige_cursor(x,y,x+hd_bild->x_size,y+hd_bild->y_size);
 pcx_zeile_eines_bildes256.zeile=NULL;
 fclose(this_file);
 T_DEBUG_LEAVE
 return T_OK;
}
T_INT print_hd_bild_oc(MEM_BILD *hd_bild,T_INT x,T_INT y)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 FILE *this_file=NULL;
 T_DEBUG_ENTRY("print_hd_bild_oc",35)
 if ((this_file =fopen((const T_PCHAR )hd_bild->mem_zeiger,(const T_PCHAR ) "rb"))== NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 fseek(this_file,0,FROM_FILE_START);
 zeilen_pointer=(T_PBYTE )pcx_zeile_eines_bildes256.zeile;
 for (p=0; p<hd_bild->y_size; p++)
 {
  fread(zeilen_pointer, 1, hd_bild->x_size,this_file);
  vesa_print_zeile256_oc(x,y+p,zeilen_pointer,hd_bild->x_size);
 }
 pcx_zeile_eines_bildes256.zeile=NULL;
 fclose(this_file);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT print_mem_teilbild(MEM_BILD *mem_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h)
{
 T_DEBUG_ENTRY("print_mem_teilbild",35)
 if (mem_bild->speicher_art==SPEICHER)
  print_m_teilbild(mem_bild,x,y,off_x,off_y,b,h);
 if (mem_bild->speicher_art==HD_SPEICHER)
  print_hd_teilbild(mem_bild,x,y,off_x,off_y,b,h);
 T_DEBUG_LEAVE
 return T_OK;
}
T_INT print_mem_teilbild_oc(MEM_BILD *mem_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h)
{
 T_DEBUG_ENTRY("print_mem_teilbild_oc",35)
 if (mem_bild->speicher_art==SPEICHER)
  print_m_teilbild_oc(mem_bild,x,y,off_x,off_y,b,h);
 if (mem_bild->speicher_art==HD_SPEICHER)
  print_hd_teilbild_oc(mem_bild,x,y,off_x,off_y,b,h);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT print_m_teilbild(MEM_BILD *m_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h)
{
 T_INT p;
 T_PBYTE zeiger;
 T_DEBUG_ENTRY("print_m_teilbild",35)
 if ((off_y>m_bild->y_size)||(off_x>m_bild->x_size))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_OK;
 }
 if (off_x+b>m_bild->x_size)
 {
  b=m_bild->x_size-off_x;
 }
 if (off_y+h>m_bild->y_size)
 {
  h=m_bild->y_size-off_y;
 }
 zeiger=(T_PBYTE )m_bild->mem_zeiger+(off_y*m_bild->x_size)+off_x;
 vesa_mouse_verstecke_cursor(x,y,x+b,y+h);
 for (p=0;p<h;p++)
 {
  vesa_print_zeile256_oc(x,y+p,zeiger,b);
  zeiger+=m_bild->x_size;
 }
 vesa_mouse_zeige_cursor(x,y,x+b,y+h);
 T_DEBUG_LEAVE
 return T_OK;
}
T_INT print_m_teilbild_oc(MEM_BILD *m_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h)
{
 T_INT p;
 T_PBYTE zeiger;
 T_DEBUG_ENTRY("print_m_teilbild_oc",35)
 if ((off_y>m_bild->y_size)||(off_x>m_bild->x_size))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_OK;
 }
 if (off_x+b>m_bild->x_size)
 {
  b=m_bild->x_size-off_x;
 }
 if (off_y+h>m_bild->y_size)
 {
  h=m_bild->y_size-off_y;
 }
 zeiger=(T_PBYTE )m_bild->mem_zeiger+(off_y*m_bild->x_size)+off_x;
 for (p=0;p<h;p++)
 {
  vesa_print_zeile256_oc(x,y+p,zeiger,b);
  zeiger+=m_bild->x_size;
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT print_hd_teilbild(MEM_BILD *hd_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 FILE *this_file=NULL;
 T_INT offset_line;
 T_DEBUG_ENTRY("print_hd_teilbild",35)
 if ((off_y>hd_bild->y_size)||(off_x>hd_bild->x_size))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_OK;
 }
 if (off_x+b>hd_bild->x_size)
 {
  b=hd_bild->x_size-off_x;
 }
 if (off_y+h>hd_bild->y_size)
 {
  h=hd_bild->y_size-off_y;
 }
 offset_line=hd_bild->x_size-b;
 if ((this_file = fopen((const T_PCHAR )hd_bild->mem_zeiger,(const T_PCHAR )"rb"))== NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 fseek(this_file,(long)(((long)off_x)+(long)(((long)hd_bild->x_size)*((long)off_y))),FROM_FILE_START);
 zeilen_pointer=(T_PBYTE )pcx_zeile_eines_bildes256.zeile;
 vesa_mouse_verstecke_cursor(x,y,x+b,y+h);
 for (p=0;p<h;p++)
 {
  fread(zeilen_pointer, 1,b,this_file);
  vesa_print_zeile256_oc(x,y+p,zeilen_pointer,b);
  fseek(this_file,offset_line,FROM_FILE_HERE);
 }
 vesa_mouse_zeige_cursor(x,y,x+b,y+h);
 pcx_zeile_eines_bildes256.zeile=NULL;
 fclose(this_file);
 T_DEBUG_LEAVE
 return T_OK;
}
T_INT print_hd_teilbild_oc(MEM_BILD *hd_bild,T_INT x,T_INT y,T_INT off_x,T_INT off_y,T_INT b,T_INT h)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 FILE *this_file=NULL;
 T_INT offset_line;
 T_DEBUG_ENTRY("print_hd_teilbild_oc",35)
 if ((off_y>hd_bild->y_size)||(off_x>hd_bild->x_size))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_OK;
 }
 if (off_x+b>hd_bild->x_size)
 {
  b=hd_bild->x_size-off_x;
 }
 if (off_y+h>hd_bild->y_size)
 {
  h=hd_bild->y_size-off_y;
 }
 offset_line=hd_bild->x_size-b;
 if ((this_file = fopen((const T_PCHAR )hd_bild->mem_zeiger,(const T_PCHAR )"rb"))== NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 fseek(this_file,(long)(((long)off_x)+(long)(((long)hd_bild->x_size)*((long)off_y))),FROM_FILE_START);
 zeilen_pointer=(T_PBYTE )pcx_zeile_eines_bildes256.zeile;
 for (p=0;p<h;p++)
 {
  fread(zeilen_pointer, 1,b,this_file);
  vesa_print_zeile256_oc(x,y+p,zeilen_pointer,b);
  fseek(this_file,offset_line,FROM_FILE_HERE);
 }
 pcx_zeile_eines_bildes256.zeile=NULL;
 fclose(this_file);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT lade_vga_nach_mem_teil(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT x_off, T_INT y_off, MEM_BILD *mem_bild)
{
 T_DEBUG_ENTRY("lade_vga_nach_mem_teil",35)
 if (mem_bild->speicher_art==SPEICHER)
  lade_vga_nach_m_teil(x,y,len_x,len_y,x_off,y_off,mem_bild);
 if (mem_bild->speicher_art==HD_SPEICHER)
  lade_vga_nach_hd_teil(x,y,len_x,len_y,x_off,y_off,mem_bild);
 T_DEBUG_LEAVE
 return T_OK;
}

T_INT lade_vga_nach_mem_teil_oc(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT x_off, T_INT y_off, MEM_BILD *mem_bild)
{
 T_DEBUG_ENTRY("lade_vga_nach_mem_teil_oc",35)
 if (mem_bild->speicher_art==SPEICHER)
  lade_vga_nach_m_teil_oc(x,y,len_x,len_y,x_off,y_off,mem_bild);
 if (mem_bild->speicher_art==HD_SPEICHER)
  lade_vga_nach_hd_teil_oc(x,y,len_x,len_y,x_off,y_off,mem_bild);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT lade_vga_nach_m_teil(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT off_x, T_INT off_y, MEM_BILD *m_bild)
{
 T_INT p;
 T_PBYTE zeiger=(T_PBYTE )m_bild->mem_zeiger+(off_y*m_bild->x_size)+off_x;
 T_DEBUG_ENTRY("lade_vga_nach_m_teil",35)
 vesa_mouse_verstecke_cursor(x,y,x+len_x,y+len_y);
 for (p=0;p<len_y;p++)
 {
  vesa_get_zeile_oc(x,y+p,len_x,zeiger);
  zeiger+=m_bild->x_size;
 }
 vesa_mouse_zeige_cursor(x,y,x+len_x,y+len_y);
 T_DEBUG_LEAVE
 return T_OK;
}
T_INT lade_vga_nach_m_teil_oc(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT off_x, T_INT off_y, MEM_BILD *m_bild)
{
 T_INT p;
 T_PBYTE zeiger=(T_PBYTE )m_bild->mem_zeiger+(off_y*m_bild->x_size)+off_x;
 T_DEBUG_ENTRY("lade_vga_nach_m_teil_oc",35)
 for (p=0;p<len_y;p++)
 {
  vesa_get_zeile_oc(x,y+p,len_x,zeiger);
  zeiger+=m_bild->x_size;
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT lade_vga_nach_hd_teil (T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT off_x, T_INT off_y, MEM_BILD *hd_bild)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 FILE *this_file=NULL;
 T_INT offset_line=hd_bild->x_size-len_x;
 T_DEBUG_ENTRY("lade_vga_nach_hd_teil",35)
 if ((this_file = fopen((const T_PCHAR )hd_bild->mem_zeiger,(const T_PCHAR )"r+b"))== NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 fseek(this_file,(long)(((long)off_x)+(long)(((long)hd_bild->x_size)*((long)off_y))),FROM_FILE_START);
 zeilen_pointer=(T_PBYTE )pcx_zeile_eines_bildes256.zeile;
 vesa_mouse_verstecke_cursor(x,y,x+len_x,y+len_y);
 for (p=0;p<len_y;p++)
 {
  vesa_get_zeile_oc(x,y+p,len_x,zeilen_pointer);
  fwrite(zeilen_pointer, 1,len_x,this_file);
  fseek(this_file,offset_line,FROM_FILE_HERE);
 }
 vesa_mouse_zeige_cursor(x,y,x+len_x,y+len_y);
 pcx_zeile_eines_bildes256.zeile=NULL;
 fclose(this_file);
 T_DEBUG_LEAVE
 return T_OK;
}
T_INT lade_vga_nach_hd_teil_oc (T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT off_x, T_INT off_y, MEM_BILD *hd_bild)
{
 T_INT p;
 T_PBYTE zeilen_pointer;
 FILE *this_file=NULL;
 T_INT offset_line=hd_bild->x_size-len_x;
 T_DEBUG_ENTRY("lade_vga_nach_hd_teil_oc",35)
 if ((this_file = fopen((const T_PCHAR )hd_bild->mem_zeiger,(const T_PCHAR )"r+b"))== NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 pcx_zeile_eines_bildes256.zeile=zeile;
 fseek(this_file,(long)(((long)off_x)+(long)(((long)hd_bild->x_size)*((long)off_y))),FROM_FILE_START);
 zeilen_pointer=(T_PBYTE )pcx_zeile_eines_bildes256.zeile;
 for (p=0;p<len_y;p++)
 {
  vesa_get_zeile_oc(x,y+p,len_x,zeilen_pointer);
  fwrite(zeilen_pointer, 1,len_x,this_file);
  fseek(this_file,offset_line,FROM_FILE_HERE);
 }
 pcx_zeile_eines_bildes256.zeile=NULL;
 fclose(this_file);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT free_mem_bild(MEM_BILD *mem_bild)
{
 T_DEBUG_ENTRY("free_mem_bild",35)
 if (mem_bild)
 {
  if (mem_bild->speicher_art==SPEICHER)
  {
   free(mem_bild->mem_zeiger);
   free(mem_bild);
  }
  if (mem_bild->speicher_art==HD_SPEICHER)
  {
   unlink((const T_PCHAR )mem_bild->mem_zeiger);
   free(mem_bild->mem_zeiger);
   free(mem_bild);
  }
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_TRUE;
 }
 T_DEBUG_LEAVE
 return T_TRUE;
}

/***************************************************************/

/* muss genaue anzahl in zeile kopieren (xms) */
T_INT get_mem_zeile(MEM_BILD *mem_bild, T_INT off_x, T_INT off_y, T_INT len, T_INT flag)
{
 T_DEBUG_ENTRY("get_mem_zeile",35)
 switch (mem_bild->speicher_art)
 {
  case SPEICHER:
  {
   if ((flag&COPY_MEM_RAW)||(vesa_print_modus==PIC_FILLED))
   {
    if (flag&ZEILE_PLUS_EINS)
    {
     memcpy(zeile+1,(T_PBYTE )(((T_PBYTE )mem_bild->mem_zeiger)+(off_y*mem_bild->x_size)+off_x),len);
    }
    else
    {
     memcpy(zeile,(T_PBYTE )(((T_PBYTE )mem_bild->mem_zeiger)+(off_y*mem_bild->x_size)+off_x),len);
    }
   }
   if (flag&COPY_MEM_WITH_VESA_OPTIONS)
   {
    T_INT i;
    T_PBYTE mem_pointer=(T_PBYTE )(((T_PBYTE )mem_bild->mem_zeiger)+(off_y*mem_bild->x_size)+off_x);
    if (flag&ZEILE_PLUS_EINS)
    {
     for (i=0;i<len;i++)
     {
      if (vesa_back_color != *(mem_pointer+i))
      {
       *(zeile+i+1) = *(mem_pointer+i);
      }
     }
    }
    else
    {
     for (i=0;i<len;i++)
     {
      if (vesa_back_color != *(mem_pointer+i))
      {
       *(zeile+i) = *(mem_pointer+i);
      }
     }
    }
   }
   break;
  }
  case HD_SPEICHER:
  {
   FILE *this_file=NULL;
   if ((this_file = fopen((const T_PCHAR )mem_bild->mem_zeiger,(const T_PCHAR )"rb"))== NULL)
   {
    bild_error=FILE_OPEN_ERROR;
    T_DEBUG_FUNCTION_POSITION(1)
    T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
    T_DEBUG_LEAVE
    return FILE_OPEN_ERROR;
   }
   fseek(this_file,(long)(((long)off_x)+(long)(((long)mem_bild->x_size)*((long)off_y))),FROM_FILE_START);
   if ((flag&COPY_MEM_RAW)||(vesa_print_modus==PIC_FILLED))
   {
    if (flag&ZEILE_PLUS_EINS)
    {
     fread(zeile+1, 1,len,this_file);
    }
    else
    {
     fread(zeile, 1,len,this_file);
    }
   }
   if (flag&COPY_MEM_WITH_VESA_OPTIONS)
   {
    T_INT i;
    if (flag&ZEILE_PLUS_EINS)
    {
     fread(zeile_hilf, 1,len,this_file);
     for (i=0;i<len;i++)
     {
      if (vesa_back_color != *(zeile_hilf+i))
      {
       *(zeile+i+1) = *(zeile_hilf+i);
      }
     }
    }
    else
    {
     fread(zeile_hilf, 1,len,this_file);
     for (i=0;i<len;i++)
     {
      if (vesa_back_color != *(zeile_hilf+i))
      {
       *(zeile+i) = *(zeile_hilf+i);
      }
     }
    }
   }
   fclose(this_file);
   break;
  }
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT lade_mem_nach_mem_teil(MEM_BILD *bild_source, T_INT s_x, T_INT s_y, MEM_BILD *bild_dest, T_INT d_x, T_INT d_y, T_INT x_len, T_INT y_len, T_INT flag)
{
 T_DEBUG_ENTRY("lade_mem_nach_mem_teil",35)
 if (x_len>=MAX_ZEILEN_LEN)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 switch (bild_dest->speicher_art)
 {
  case SPEICHER:
  {
   lade_mem_nach_m_teil(bild_source,s_x,s_y,bild_dest,d_x,d_y,x_len,y_len,flag);
   break;
  }
  case HD_SPEICHER:
  {
   lade_mem_nach_hd_teil(bild_source,s_x,s_y,bild_dest,d_x,d_y,x_len,y_len,flag);
   break;
  }
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT lade_mem_nach_m_teil(MEM_BILD *bild_source, T_INT s_x, T_INT s_y, MEM_BILD *m_bild, T_INT off_x, T_INT off_y, T_INT b, T_INT h,T_INT flag)
{
 T_INT p;
 T_PBYTE zeiger=(T_PBYTE )m_bild->mem_zeiger+(off_y*m_bild->x_size)+off_x;
 T_DEBUG_ENTRY("lade_mem_nach_m_teil",35)
 if (flag&COPY_MEM_RAW)
 {
  for (p=0;p<h;p++)
  {
   get_mem_zeile(bild_source, s_x, s_y+p, b,COPY_MEM_RAW);
   memcpy(zeiger,zeile,b);
   zeiger+=m_bild->x_size;
  }
 }
 if (flag&COPY_MEM_WITH_VESA_OPTIONS)
 {
  for (p=0;p<h;p++)
  {
   memcpy(zeile,zeiger,b);
   get_mem_zeile(bild_source, s_x, s_y+p, b, COPY_MEM_WITH_VESA_OPTIONS);
   memcpy(zeiger,zeile,b);
   zeiger+=m_bild->x_size;
  }
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT lade_mem_nach_hd_teil(MEM_BILD *bild_source, T_INT s_x, T_INT s_y, MEM_BILD *hd_bild, T_INT off_x, T_INT off_y, T_INT b, T_INT h,T_INT flag)
{
 T_INT p;
 FILE *this_file=NULL;
 T_DEBUG_ENTRY("lade_mem_nach_hd_teil",35)
 if ((this_file = fopen((const T_PCHAR )hd_bild->mem_zeiger,(const T_PCHAR )"r+b"))== NULL)
 {
  bild_error=FILE_OPEN_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 if (flag&COPY_MEM_RAW)
 {
  long offset_line=hd_bild->x_size-b;
  fseek(this_file,(long)(((long)off_x)+(long)(((long)hd_bild->x_size)*((long)off_y))),FROM_FILE_START);
  for (p=0;p<h;p++)
  {
   get_mem_zeile(bild_source, s_x, s_y+p, b,COPY_MEM_RAW);
   fwrite(zeile, 1,b,this_file);
   fseek(this_file,offset_line,FROM_FILE_HERE);
  }
 }
 if (flag&COPY_MEM_WITH_VESA_OPTIONS)
 {
  long line_len=hd_bild->x_size;
  long pos=(long)(((long)off_x)+(long)(((long)hd_bild->x_size)*((long)off_y)));
  for (p=0;p<h;p++)
  {
   fseek(this_file,pos+p*line_len,SEEK_SET);
   fread(zeile,1,b,this_file);
   get_mem_zeile(bild_source, s_x, s_y+p, b,flag);
   fseek(this_file,pos+p*line_len,SEEK_SET);
   fwrite(zeile, 1,b,this_file);
  }
 }
 fclose(this_file);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

/* vorsicht falsche X ueberlappung noch nicht beruecksichtigt!!! */

T_INT lade_vga_nach_vga_teil(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT off_x, T_INT off_y)
{
 T_INT p;
 T_DEBUG_ENTRY("lade_vga_nach_vga_teil",35)
 vesa_mouse_verstecke_cursor(x,y,x+len_x,y+len_y);
 if (y>off_y)
  for (p=0;p<len_y;p++)
  {
   vesa_get_zeile_oc(x,y+p,len_x,zeile);
   vesa_print_zeile256_oc_raw(off_x,off_y+p,zeile,len_x);
  }
 else
  for (p=len_y-1;p>=0;p--)
  {
   vesa_get_zeile_oc(x,y+p,len_x,zeile);
   vesa_print_zeile256_oc_raw(off_x,off_y+p,zeile,len_x);
  }
 vesa_mouse_zeige_cursor(x,y,x+len_x,y+len_y);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT lade_vga_nach_vga_teil_oc(T_INT x, T_INT y, T_INT len_x, T_INT len_y, T_INT off_x, T_INT off_y)
{
 T_INT p;
 T_DEBUG_ENTRY("lade_vga_nach_vga_teil",35)
 if (y>off_y)
  for (p=0;p<len_y;p++)
  {
   vesa_get_zeile_oc(x,y+p,len_x,zeile);
   vesa_print_zeile256_oc_raw(off_x,off_y+p,zeile,len_x);
  }
 else
  for (p=len_y-1;p>=0;p--)
  {
   vesa_get_zeile_oc(x,y+p,len_x,zeile);
   vesa_print_zeile256_oc_raw(off_x,off_y+p,zeile,len_x);
  }
 T_DEBUG_LEAVE
 return T_OK;
}


MEM_BILD *clone_membild(MEM_BILD *m_bild)
{
 MEM_BILD *newbild=NULL;
 T_DEBUG_ENTRY("clone_membild",35)
 if ((m_bild==NULL)||(m_bild->mem_zeiger==NULL))
 {
  bild_error=T_NOT_OK;
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return NULL;
 }
 if ((newbild=(MEM_BILD *)malloc(sizeof(MEM_BILD)))==NULL)
 {
  bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 newbild->x_size=m_bild->x_size;
 newbild->y_size=m_bild->y_size;
 newbild->speicher_art=m_bild->speicher_art;
 if (m_bild->speicher_art==SPEICHER)
 {
  T_PBYTE zeiger;
  T_INT p=(m_bild->x_size)*(m_bild->y_size);
  if (p==0)
  {
   bild_error=T_NOT_OK;
   free(newbild);
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return NULL;
  }
  zeiger=(T_PBYTE)malloc(p);
  memcpy(zeiger,newbild->mem_zeiger,p);
  newbild->mem_zeiger=zeiger;
 }
 else if (m_bild->speicher_art==HD_SPEICHER)
 {
  T_INT p;
  T_PCHAR filename="\\tmp00000.swp";
  T_PCHAR fname=NULL;
  T_PBYTE zeilen_pointer;
  FILE *read_file=NULL;
  FILE *write_file=NULL;
  fname=(T_PCHAR ) malloc(strlen(swap_path)+14);
  if (fname==NULL)
  {
   free(newbild);
   bild_error=GENERIC_MEMORY_NOT_AVAILABLE;
   T_DEBUG_FUNCTION_POSITION(4)
   T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
   T_DEBUG_LEAVE
   return NULL;
  }
  strcpy(fname,swap_path);
  strcpy(fname+strlen(swap_path),filename);
  while ((write_file = fopen(fname, "rb"))!= NULL)
  {
   fclose(write_file);
   fname[strlen(swap_path)+8]++;
   if (fname[strlen(swap_path)+8]=='9'+1)
   {
    fname[strlen(swap_path)+8]='0';
    fname[strlen(swap_path)+7]++;
    if (fname[strlen(swap_path)+7]=='9'+1)
    {
     fname[strlen(swap_path)+7]='0';
     fname[strlen(swap_path)+6]++;
     if (fname[strlen(swap_path)+6]=='9'+1)
     {
      fname[strlen(swap_path)+6]='0';
      fname[strlen(swap_path)+5]++;
      if (fname[strlen(swap_path)+5]=='9'+1)
      {
       fname[strlen(swap_path)+5]='0';
       fname[strlen(swap_path)+4]++;
      }
     }
    }
   }
  }
  write_file = fopen(fname, "w+b");
  if (write_file==NULL)
  {
   bild_error=FILE_OPEN_ERROR;
   free(fname);
   free(newbild);
   T_DEBUG_FUNCTION_POSITION(5)
   T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
   T_DEBUG_LEAVE
   return NULL;
  }
  read_file = fopen(m_bild->mem_zeiger, "rb");
  if (read_file==NULL)
  {
   fclose(write_file);
   free(fname);
   free(newbild);
   T_DEBUG_FUNCTION_POSITION(6)
   T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
   T_DEBUG_LEAVE
  }
  zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
  for (p=0; p<m_bild->x_size; p++)
  {
   fread(zeilen_pointer, 1, m_bild->x_size,read_file);
   fwrite(zeilen_pointer, 1, m_bild->x_size,write_file);
  }
  fclose(read_file);
  fclose(write_file);
  newbild->mem_zeiger=fname;
 }
 else
 {
  free(newbild);
  bild_error=T_NOT_OK;
  T_DEBUG_LEAVE
  return NULL;
 }
 T_DEBUG_LEAVE
 return newbild;
}
