#include <i86.h>
#include <mem.h>

#include "dosmem.h"

#include "error.h"
/************************************************************/
/* Allocate a region of DOS memory.                         */
/************************************************************/

T_VOID far* fDOSmalloc(REALPTR * rp,T_ULONG bytes_to_allocate)
{
 T_VOID far *ptr=NULL;
 union REGS regs;
 T_DEBUG_ENTRY("fDOSmalloc",10)

 bytes_to_allocate = ((bytes_to_allocate + 15) & 0xfffffff0);
 memset(&regs,0,sizeof(regs));
 regs.w.ax = 0x100;
 regs.w.bx = (T_UWORD)(bytes_to_allocate >> 4);            //Allocate dos
 int386(0x31,&regs,&regs);
 if(regs.x.cflag == 0)
 {       //Everything OK.
  rp->Segment = regs.w.ax;
  rp->Selector = regs.w.dx;
  ptr = MK_FP(regs.w.dx,0);
 }
 T_DEBUG_LEAVE
 return(ptr);
}

/********************************************/
/* Free an area of DOS memory.              */
/********************************************/

T_VOID fDOSfree(REALPTR * rp)
{
 union REGS regs;
 T_DEBUG_ENTRY("fDOSfree",10)
 regs.w.ax = 0x101;
 regs.w.dx = rp->Selector;
 int386(0x31,&regs,&regs);
 T_DEBUG_LEAVE
}
