/* STILL todo

ed->y_ausgabe_start=window->h_open-ed->len_y
so machen, dass die letzte Zeile gschrieben wird, nicht
vom fenster ende aus, sondern die letzte Zeile, die auf das fenster passt

Noch keine y offsets in strings supported (like in help)

*/

/* standard C includes */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* my own includes */
#include <standard.h>
#include <file.h>
#include <tools.h>
#include <parser.h>
#include <button.h>
#include <help.h>
#include <edit.h>

/* module only defines */
#define WX(k_x) ((k_x)+window->x+window->x_0)
#define WY(k_y) ((k_y)+window->y+window->y_0)

/* init 'global' and module variables */
T_LISTE *edit_erste=NULL;
T_LISTE *edit_letzte=NULL;
T_INT edit_mode=EDIT_MODE_INSERT;
T_INT autosave_default=T_FALSE;

/* declare module only functions */
T_INT edit_update_function(T_INT status, T_PVOID ewindow);
T_VOID edit_key_function(PARAMETER *parameter);
T_VOID edit_area_function(PARAMETER *parameter);

/***********************************************************/
/* private function                                        */
/* This function fetches the ed object corresponding to an */
/* input window id, returns pointer to ed or NULL          */
/***********************************************************/
EDIT_ELEMENT *fetch_edit_element(T_INT window_id)
{
 EDIT_ELEMENT *ed;
 T_LISTE *liste=edit_erste;
 T_DEBUG_ENTRY("fetch_edit_element",85)
 while (liste!=NULL)
 {
  ed=(EDIT_ELEMENT *)liste->objekt;
  if (ed->window_id==window_id)
  {
   T_DEBUG_PROTOCOLL(("fetch_edit_element(), ed found for window name:%s",get_window(window_id)->name))
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return ed;
  }
  liste=liste->naechstes;
 }
 T_DEBUG_PROTOCOLL(("fetch_edit_element(), ed not found"))
 T_DEBUG_LEAVE
 return NULL;
}

/***********************************************************/
/* private function                                        */
/* Destructor to an edit object, this one must only be     */
/* called by close_window()!                               */
/***********************************************************/
T_INT edit_destructor(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window;
 T_LISTE *help=NULL;
 EDIT_ELEMENT *ed=NULL;
 T_INT save=T_FALSE;
 T_INT my_id;
 T_PCHAR filename=NULL;
 T_DEBUG_ENTRY("edit_destructor",85)
 if (parameter==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_destructor(), parameter==NULL"))
  t_printf(E_VERBOSE_STANDARD,"\nparameter==NULL in EDIT DESTRUCTOR()");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return -1;
 }
 window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 if (window==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_destructor(), window==NULL"))
  t_printf(E_VERBOSE_STANDARD,"\nedit_destructor(), window==NULL");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return -1;
 }
 my_id=window->id;
 ed=fetch_edit_element(my_id);
 if (ed==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_destructor(), ed==NULL"))
  t_printf(E_VERBOSE_STANDARD,"\nDestruction with EDIT destructor without edit object!");
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return -1;
 }
 if (ed->flag&EDIT_WITH_SAVE)
 {
  T_DEBUG_PROTOCOLL(("edit_destructor(), edit with save"))
  if ((ed->autosave==T_TRUE)&&(ed->changed==T_TRUE))
  {
   save=T_TRUE;
  }
  else
  {
   if (ed->changed==T_TRUE)
   {
    T_INT dispatcher_type_old= dispatcher_type;
    dispatcher_type= ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
    if (request_ja_nein("Do you want to save the file?")==T_JA)
     save=T_TRUE;
    dispatcher_type=dispatcher_type_old;
    if (fetch_edit_element(my_id)!=ed)
    {
     T_DEBUG_PROTOCOLL(("edit_destructor(), window stolen after yes/no check!"))
     if (e_verbose>E_VERBOSE_NONE)
      show_message("Somebody stole my editor window!!!");
     T_DEBUG_FUNCTION_POSITION(4)
     T_DEBUG_LEAVE
     return -1;
    }
   }
  } // else if ((ed->autosave==T_TRUE)&&(ed->changed==T_TRUE))
  if (save==T_TRUE)
  {
   T_DEBUG_PROTOCOLL(("edit_destructor(), edit with save, trying to save"))
   if (ed->handle_out!=NULL)
   {
    T_DEBUG_PROTOCOLL(("edit_destructor(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
    fclose(ed->handle_out);
    ed->handle_out=NULL;
   }
   ed->handle_out=fopen(ed->filename,"wt");
   if (ed->handle_out==NULL)
   {
    T_INT dispatcher_type_old= dispatcher_type;
    T_DEBUG_PROTOCOLL(("edit_destructor(), default file not found (\"%s\").",ed->filename))
    dispatcher_type= ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
    if (ed->filename!=NULL)
    {
     free(ed->filename);
     ed->filename=NULL;
    }
    filename=get_file_name("*.*", RETURN_PATH_NAME);
    dispatcher_type= dispatcher_type_old;
    if (fetch_edit_element(my_id)!=ed)
    {
     T_DEBUG_PROTOCOLL(("edit_destructor(), window stolen after get_filename!"))
     if (filename!=NULL)
      free(filename);
     if (e_verbose>E_VERBOSE_NONE)
      show_message("Somebody stole my editor window!!!");
     T_DEBUG_FUNCTION_POSITION(5)
     T_DEBUG_LEAVE
     return -1;
    }
    ed->filename=filename;
    if (ed->filename!=NULL)
     ed->handle_out=fopen(ed->filename,"wt");
    if (ed->handle_out==NULL)
    {
     T_DEBUG_PROTOCOLL(("edit_destructor(), get_filename() file not found(\"%s\").",ed->filename))
     show_message("Error saving file...");
    }
   }
   if (ed->handle_out!=NULL)
   {
    T_DEBUG_PROTOCOLL(("edit_destructor(), edit with save, saving to:%s (opened)",ed->filename))
    help=ed->text_zeile_erste;
    while (help!=NULL)
    {
     T_PCHAR ret="\n";
     EDIT_ZEILE *zeile=(EDIT_ZEILE *)help->objekt;
     fwrite(zeile->text,strlen(zeile->text),sizeof(T_CHAR),ed->handle_out);
     fwrite(ret,strlen(ret),sizeof(T_CHAR),ed->handle_out);
     help=help->naechstes;
    }
   }
  } // if (save==T_TRUE)
  else
  {
   T_DEBUG_PROTOCOLL(("edit_destructor(), edit with save, not saving"))
  }
 } // if (ed->flag&EDIT_WITH_SAVE)
 if (ed->handle_out!=NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_destructor(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
  fclose(ed->handle_out);
  ed->handle_out=NULL;
 }
 if (ed->filename!=NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_destructor(), free filename"))
  free(ed->filename);
  ed->filename=NULL;
 }
 help=ed->text_zeile_erste;
 T_DEBUG_PROTOCOLL(("edit_destructor(), free text space"))
 while (help)
 {
  EDIT_ZEILE *zeile=(EDIT_ZEILE *)help->objekt;
  d_entferne_aus_liste( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte),DL_DONT_CLEAN_UP);
  free(zeile->text);
  free(zeile);
  help=ed->text_zeile_erste;
 }
 T_DEBUG_PROTOCOLL(("edit_destructor(), removing key function (if any)"))
 while (ed->key_functions_erste)
 {
  KEY_FUNCTION *funktion=(KEY_FUNCTION *)(ed->key_functions_erste->objekt);
  remove_edit_key_funktion(window, funktion->key_funktion);
 }

 help=ed->help_word_erste;
 T_DEBUG_PROTOCOLL(("edit_destructor(), free help keys"))
 while (help)
 {
  HELP_WORD *help_word=(HELP_WORD *)help->objekt;
  if (help_word==NULL)
  {
   T_DEBUG_FUNCTION_POSITION(6)
   T_DEBUG_LEAVE
   tool_exit(0);
  }
  d_entferne_aus_liste( help_word, &(ed->help_word_erste), &(ed->help_word_letzte),DL_DONT_CLEAN_UP);
  if (help_word->keyword==NULL)
  {
   T_DEBUG_FUNCTION_POSITION(7)
   T_DEBUG_LEAVE
   tool_exit(0);
  }
  free(help_word->keyword);
  if (help_word->help_name==NULL)
  {
   T_DEBUG_FUNCTION_POSITION(8)
   T_DEBUG_LEAVE
   tool_exit(0);
  }
  free(help_word->help_name);
  free(help_word);
  help=ed->help_word_erste;
 }

 if (ed->old_destructor!=NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_destructor(), invoking old destructor"))
  ed->old_destructor(parameter);
  ed->old_destructor=NULL;
 }
 T_DEBUG_PROTOCOLL(("edit_destructor(), free edit object"))
 d_entferne_aus_liste( ed, &edit_erste, &edit_letzte,DL_DONT_CLEAN_UP);
 free(ed);
/*
 window->destructor=NULL;
 window->parameter=NULL;
 window->area_funktion=NULL;
 window->tasten_funktion=NULL;
 window->update_funktion=NULL;
*/
 T_DEBUG_LEAVE
 return -1; // keine variablen da, dann ebene = -1
}

/***********************************************************/
/* private function                                        */
/* Update function to edit object, only after show is      */
/* needed, old update function is still invoked.           */
/* This function must only be called by the appropriate    */
/* window function in win_raw.c. It is set upon creation   */
/* of an edit object                                       */
/***********************************************************/
T_INT edit_update_function(T_INT status, T_PVOID ewindow)
{
 EDIT_ELEMENT *ed=NULL;
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)ewindow;
 T_DEBUG_ENTRY("edit_update_function",100)
 if (window==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_update_function(), Edit update without window!"))
  t_printf(E_VERBOSE_STANDARD,"\nEdit update without window!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 ed=fetch_edit_element(window->id);
 if (ed==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_update_function(), Edit update without edit object! (window name:\"%s\")", window->name))
  t_printf(E_VERBOSE_STANDARD,"\nEdit update without edit object!");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 switch (status) // we do not want a dispatcher response
 {
  case UPDATE_AFTER_SHOW:
  {
   if ((window->hide==0)&&(window->dhide==0))
   {
    /* might some day do a change check for this, for now */
    /* update is ALLWAYS done... */
    T_DEBUG_PROTOCOLL(("edit_update_function(), invoked! (window name:\"%s\")", window->name))
    ed->x_ausgabe_start=0;
    ed->x_ausgabe_end=window->b_open;   // auf dem Fenster
    ed->y_ausgabe_start=0;
    ed->y_ausgabe_end=window->h_open;
    if ((ed->flag&EDIT_LOG)==EDIT_LOG)
    {
     T_DEBUG_PROTOCOLL(("edit_update_function(), this is a LOG object! (window name:\"%s\")", window->name))
     /* for LOG edit objects, allways start at the bottom! */
     ed->x_start=ed->len_x*ed->x_first_char; // ab welchem Pixel im file
     if (ed->zeilen_anzahl*ed->len_y<window->h_open)
      ed->y_start=0;
     else
      ed->y_start=(ed->zeilen_anzahl)*ed->len_y-window->h_open;
     ed->y_first_char=ed->y_start/ed->len_y;
    }
    MOUSE_VERSTECKE
    vesa_rect_fill_oc(
     window->x+window->x_0,
     window->y+window->y_0,
     window->b_open,
     window->h_open,
     window->bcolor);

    edit(window,NULL,EDIT_REDRAW);
    ed->y_ausgabe_start+=ed->len_y;

    if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
    {
     T_DEBUG_PROTOCOLL(("edit_update_function(), this is a EDIT object! (window name:\"%s\")", window->name))
     set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
    }
    MOUSE_ZEIGE
   }
   break;
  }
  default:
  {
   break;
  }
 }
 T_DEBUG_LEAVE
 if (ed->old_update_funktion!=NULL)
  return ed->old_update_funktion(status,ewindow);
 return T_OK;
}

/***********************************************************/
/* public function                                         */
/* This adds one line to an EDIT_LOG edit object.          */
/* Allways drawn on the bottom of the 'file'               */
/* window is the window which was converted to an edit     */
/* object.                                                 */
/***********************************************************/
T_INT edit_log_add(WINDOW_LISTEN_ELEMENT *window, T_PCHAR text)
{
 EDIT_ELEMENT *ed=NULL;
 EDIT_ZEILE *zeile;
 T_INT old_print_modus;
 T_INT old_text;
 T_INT old_back_color;
 T_INT old_text_color;
 T_INT redraw=T_FALSE;
 T_DEBUG_ENTRY("edit_log_add",85)
 if (strstr(text,"\n"))
 {
  T_PCHAR first=text;
  T_CHAR save=*strstr(text,"\n");
  T_PCHAR second=strdup(strstr(text,"\n")+strlen("\n"));
  *strstr(text,"\n")=0;
  edit_log_add(window, first);
  *strstr(text,"\n")=save;
  if (second)
  {
   edit_log_add(window, second);
   free(second);
  }
  T_DEBUG_FUNCTION_POSITION(102)
  T_DEBUG_LEAVE
  return T_OK;
 }
 if (window==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_log_add(), Edit update without window!"))
  t_printf(E_VERBOSE_STANDARD,"\nEdit update without window!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if (text==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_log_add(), text==NULL!(window name:\"%s\")", window->name))
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 ed=fetch_edit_element(window->id);
 if (ed==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_log_add(), ed==NULL!(window name:\"%s\")", window->name))
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((ed->flag&EDIT_LOG)!=EDIT_LOG)
 {
  T_DEBUG_PROTOCOLL(("edit_log_add(), ed is no LOG!(window name:\"%s\")", window->name))
  T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_NO_LOG_WINDOW)
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((window->hide==0)&&(window->dhide==0))
 {
  // erst mal x werte resetten, wenn gescrollt wurde!
  T_DEBUG_PROTOCOLL(("edit_log_add(), window is not hidden, aktivated! (window name:\"%s\")", window->name))
  aktivate_window(window);
  if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
  {
   T_DEBUG_PROTOCOLL(("edit_log_add(), window is also an EDIT! (window name:\"%s\")", window->name))
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
  }
  if (ed->x_start!=0) /* allways reset X position to zero */
  {                   /* perhaps bad for EDIT object, but what the heck */
   ed->x_start=0;
   ed->cpos_x=0;      /* for EDIT objects only */
   ed->x_first_char=0;/* for EDIT objects only */
   redraw=T_TRUE;
  }
  if (ed->x_ausgabe_start!=0)
  {
   ed->x_ausgabe_start=0;
   redraw=T_TRUE;
  }
  ed->x_ausgabe_end=window->b_open;   // auf dem Fenster
  // dann nachsehen, ob die naechste Zeile ausserhalb des Windows geschrieben wuerde
  if ((redraw==T_TRUE)||((ed->zeilen_anzahl+2-ed->y_first_char)*ed->len_y-1>window->h_open))
  {
   // wenn ja, dann korrigieren
   ed->y_ausgabe_start=0;
   ed->y_start=(ed->zeilen_anzahl+1)*ed->len_y-window->h_open;
   ed->y_first_char=ed->y_start/ed->len_y;
   redraw=T_TRUE;
  }
  // ausgabe max ist hier immer Fensterende
  ed->y_ausgabe_end=window->h_open;   // auf dem Fenster
  ed->x_ausgabe_end=window->b_open;   // auf dem Fenster
  if (redraw==T_TRUE)
  {
   T_DEBUG_PROTOCOLL(("edit_log_add(), window is redrawn! (window name:\"%s\")", window->name))
   // Fenster immer komplett neu zeichnen...
   MOUSE_VERSTECKE
   vesa_rect_fill_oc(
   window->x+window->x_0,
   window->y+window->y_0,
   window->b_open,
   window->h_open,
    window->bcolor);
   edit(window,NULL,0);
   MOUSE_ZEIGE
   ed->y_ausgabe_start=window->h_open-ed->len_y;
  }
  else
  {
   // wenn nicht neugezeichnet wird, muss die
   // akutelle ausgabe start position im fenster noch berrechnet werden
   T_DEBUG_PROTOCOLL(("edit_log_add(), window is not redrawn! (window name:\"%s\")", window->name))
   ed->y_ausgabe_start=(ed->zeilen_anzahl-ed->y_first_char)*ed->len_y;
  }
 } //if (window->hide==0)
 else
 {
  T_DEBUG_PROTOCOLL(("edit_log_add(), window is hidden! (window name:\"%s\")", window->name))
 }
 zeile=(EDIT_ZEILE *)malloc(sizeof(EDIT_ZEILE));
 if (zeile==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(5)
  T_DEBUG_LEAVE
  tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
 }
 zeile->text=(T_PCHAR)malloc(EDIT_LINE_LEN+1); // plus one for safty and SPACE
 zeile->len_of_mem=EDIT_LINE_LEN;
 zeile->mark_start=0;
 zeile->mark_end=0;

 if (zeile->text==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(6)
  T_DEBUG_LEAVE
  tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
 }
 if (ed->handle_out!=NULL)
 {
  T_CHAR ret[2]="\n";
  T_DEBUG_PROTOCOLL(("edit_log_add(), text written to log file! (window name:\"%s\")(file name:\"%s\")", window->name, ed->filename))
  fwrite(text,strlen(text),sizeof(T_CHAR),ed->handle_out);
  fwrite(ret,strlen(ret),sizeof(T_CHAR),ed->handle_out);
 }
 memset(zeile->text,0,zeile->len_of_mem);
 if ((zeile->len_chars=strlen(text))>0)
 {
  strncpy(zeile->text,text,EDIT_LINE_LEN-1);
  vesa_get_text_len(zeile->text,&zeile->len_pixel,&zeile->hight_pixel);
 }
 else
 {
  zeile->len_pixel=0;
 }
 zeile->hight_pixel=ed->len_y;
 d_fuege_in_liste_ein( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte), DL_HINTEN );
 ed->changed=T_TRUE;
 ed->zeilen_anzahl++;
 if ((window->hide==0)&&(window->dhide==0))
 {
  old_print_modus=vesa_print_modus;
  old_text=vesa_text;
  old_back_color=vesa_back_color;
  old_text_color=vesa_text_color;
  vesa_print_modus=PIC_FILLED;
  vesa_text=SINGLE_COLOR;
  vesa_back_color=dhell_grau;
  vesa_text_color=ddark_grau;
  MOUSE_VERSTECKE
  T_DEBUG_PROTOCOLL(("edit_log_add(), text printed on screen! (window name:\"%s\")", window->name))
  vesa_print_string_max_oc(0,0,
             WX(ed->x_ausgabe_start),
             WY(ed->y_ausgabe_start),
             window->b_open,
             ed->len_y,
             text);
  ed->y_ausgabe_start+=ed->len_y;
  vesa_print_modus=old_print_modus;
  vesa_text=old_text;
  vesa_back_color=old_back_color;
  vesa_text_color=old_text_color;
  if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
  {
   ed->cpos_x=0;
   ed->x_first_char=0;
   ed->cpos_y=ed->zeilen_anzahl-1;
   ed->cursor_line=zeile;
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0); // automatically set to start :-)
  }
  MOUSE_ZEIGE
 } // if (window->hide==0)
 T_DEBUG_LEAVE
 return T_OK;
}

/***********************************************************/
/* private function                                        */
/* This function should only be called by the dispatcher   */
/* it handles all edit object buttons.                     */
/***********************************************************/
T_INT execute_edit_button(PARAMETER *parameter)
{
 EDIT_ELEMENT *ed=NULL;
 WINDOW_LISTEN_ELEMENT *window=NULL;
 BUTTON_LISTEN_ELEMENT *button_element=NULL;
 BUTTON *button=NULL;
 T_INT my_id;
 T_DEBUG_ENTRY("execute_edit_button",85)
 if (parameter!=NULL)
  window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 if (window!=NULL)
  button_element=((BUTTON_LISTEN_ELEMENT *)(parameter->button_element));
 if (button_element!=NULL)
  button=button_element->button;
 if ((parameter==NULL)||(window==NULL)||(button_element==NULL)||(button==NULL))
 {
  T_DEBUG_PROTOCOLL(("execute_edit_button(), something is NULL"))
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene; // whatever is there...
 }
 if ((window->hide>0)||((window->dhide>0)))
 {
  T_DEBUG_PROTOCOLL(("execute_edit_button(), window is hidden! (window name:\"%s\")", window->name))
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 my_id=window->id;
 ed=fetch_edit_element(my_id);
 if (ed==NULL)
 {
  T_DEBUG_PROTOCOLL(("execute_edit_button(), ed==NULL! (window name:\"%s\")", window->name))
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 if ((ed->lock==T_FALSE)&&((button->taste==KEY_CTRL_S)&&((parameter->maus_button==1)||(parameter->taste==KEY_CTRL_S))))
 {
  T_DEBUG_PROTOCOLL(("execute_edit_button(), save aktivated! (window name:\"%s\")", window->name))
  parameter->executed=PARAMETER_EXECUTED;
  if (fKBDisALT()==T_TRUE)
  {
   help_function("save.hlf",NULL);
  }
  else
  {
   T_PCHAR filename=NULL;
   T_LISTE *help=NULL;
   T_INT reopen=T_FALSE;
   ed->lock=T_TRUE;
   MOUSE_VERSTECKE
   aktivate_window(window);
   is_upper=T_TRUE;
   if (parameter->taste!=KEY_CTRL_S)
    wprint_button(window,button_element,PRESSED);
   if (ed->handle_out!=NULL)
   {
    T_DEBUG_PROTOCOLL(("execute_edit_button(), file must be reopened later! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
    T_DEBUG_PROTOCOLL(("execute_edit_button(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
    reopen=T_TRUE;
    fclose(ed->handle_out);
    ed->handle_out=NULL;
   }
   if ((fKBDisRSHIFT()==T_TRUE)||(fKBDisLSHIFT()==T_TRUE))
   {
    T_INT dispatcher_type_old= dispatcher_type;
    T_DEBUG_PROTOCOLL(("execute_edit_button(), get_filename(forced)! (window name:\"%s\")", window->name))
    dispatcher_type= ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
    if (parameter->taste!=KEY_CTRL_S)
     wprint_button(window,button_element,RELEASED);
    is_upper=T_FALSE;
    MOUSE_ZEIGE
    if (ed->filename!=NULL)
    {
     free(ed->filename);
     ed->filename=NULL;
    }
    filename=get_file_name("*.*", RETURN_PATH_NAME);
    dispatcher_type= dispatcher_type_old;
    if (fetch_edit_element(my_id)!=ed)
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), window stolen after get_filename!"))
     if (filename!=NULL)
      free(filename);
     if (e_verbose>E_VERBOSE_NONE)
      show_message("Somebody stole my editor window!!!");
     T_DEBUG_FUNCTION_POSITION(4)
     T_DEBUG_LEAVE
     return parameter->ebene;
    }
    ed->filename=filename;
    MOUSE_VERSTECKE
    aktivate_window(window);
    is_upper=T_TRUE;
   }
   if (ed->filename!=NULL)
    ed->handle_out=fopen(ed->filename,"wt");
   if (ed->handle_out==NULL)
   {
    T_DEBUG_PROTOCOLL(("execute_edit_button(), savefile not opened(window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
    ed->lock=T_FALSE;
    if (parameter->taste!=KEY_CTRL_S)
     wprint_button(window,button_element,RELEASED);
    MOUSE_ZEIGE
    is_upper=T_FALSE;
    show_message("Error opening save file!!! (not saved)");
    T_DEBUG_FUNCTION_POSITION(5)
    T_DEBUG_LEAVE
    return parameter->ebene;
   }
   help=ed->text_zeile_erste;
   T_DEBUG_PROTOCOLL(("execute_edit_button(), saving...(window name:\"%s\")(filename:\"%s\")(opened)", window->name,ed->filename))
   while (help)
   {
    T_PCHAR ret="\n";
    EDIT_ZEILE *zeile=(EDIT_ZEILE *)help->objekt;
    fwrite(zeile->text,strlen(zeile->text),sizeof(T_CHAR),ed->handle_out);
    fwrite(ret,strlen(ret),sizeof(T_CHAR),ed->handle_out);
    help=help->naechstes;
   }
   if (parameter->taste!=KEY_CTRL_S)
    wprint_button(window,button_element,RELEASED);
   MOUSE_ZEIGE
   is_upper=T_FALSE;
   fclose(ed->handle_out);
   ed->handle_out=NULL;
   T_DEBUG_PROTOCOLL(("execute_edit_button(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
   if (reopen==T_TRUE)
   {
    reopen=T_FALSE;
    if (ed->filename!=NULL)
     ed->handle_out=fopen(ed->filename,"at");
    if (ed->handle_out==NULL)
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), append file not opened!(window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
     ed->lock=T_FALSE;
     show_message("Error opening append file after save!!!");
     T_DEBUG_FUNCTION_POSITION(6)
     T_DEBUG_LEAVE
     return parameter->ebene;
    }
    T_DEBUG_PROTOCOLL(("execute_edit_button(), append file opened!(window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
   }
   ed->changed=T_FALSE;
   ed->lock=T_FALSE;
  }
 }
 if ((ed->lock==T_FALSE)&&((button->taste==KEY_CTRL_R)&&((parameter->maus_button==1)||(parameter->taste==KEY_CTRL_R))))
 {
  T_LISTE *help=NULL;
  T_INT save=T_FALSE;
  T_INT reopen=T_FALSE;
  T_INT dispatcher_type_old;
  T_INT bytes_read=0;
  T_PCHAR new_filename=NULL;
  T_PCHAR filename=NULL;
  EDIT_ZEILE *zeile;
  T_DEBUG_PROTOCOLL(("execute_edit_button(), load aktivated! (window name:\"%s\")", window->name))
  parameter->executed=PARAMETER_EXECUTED;
  if (fKBDisALT()==T_TRUE)
  {
   help_function("load.hlf",NULL);
  }
  else
  {
   ed->lock=T_TRUE;
   MOUSE_VERSTECKE
   aktivate_window(window);
   is_upper=T_TRUE;
   if (parameter->taste!=KEY_CTRL_R)
    wprint_button(window,button_element,PRESSED);
   if (ed->flag&EDIT_WITH_SAVE)
   {
    if ((ed->autosave==T_TRUE)&&(ed->changed==T_TRUE))
    {
     save=T_TRUE;
    }
    else
    {
     if (ed->changed==T_TRUE)
     {
      T_DEBUG_PROTOCOLL(("execute_edit_button(), ask to save before load! (window name:\"%s\")", window->name))
      if (parameter->taste!=KEY_CTRL_R)
       wprint_button(window,button_element,RELEASED);
      dispatcher_type_old= dispatcher_type;
      is_upper=T_FALSE;
      MOUSE_ZEIGE
      dispatcher_type= ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
      if (request_ja_nein("Do you want to save the file?")==T_JA)
       save=T_TRUE;
      dispatcher_type= dispatcher_type_old;
      if (fetch_edit_element(my_id)!=ed)
      {
       T_DEBUG_PROTOCOLL(("execute_edit_button(), window stolen after check yes/no!"))
       if (e_verbose>E_VERBOSE_NONE)
        show_message("Somebody stole my editor window!!!");
       T_DEBUG_FUNCTION_POSITION(65)
       T_DEBUG_LEAVE
       return parameter->ebene;
      }
      MOUSE_VERSTECKE
      aktivate_window(window);
      is_upper=T_TRUE;
     }
    } // else if ((ed->autosave==T_TRUE)&&(ed->changed==T_TRUE))
    if (save==T_TRUE)
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), save before load! (window name:\"%s\")", window->name))
     if (ed->handle_out!=NULL)
     {
      T_DEBUG_PROTOCOLL(("execute_edit_button(), file must be reopened later! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
      T_DEBUG_PROTOCOLL(("execute_edit_button(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
      reopen=T_TRUE;
      fclose(ed->handle_out);
      ed->handle_out=NULL;
     }
     if (ed->filename!=NULL)
      ed->handle_out=fopen(ed->filename,"wt");
     if (ed->handle_out==NULL)
     {
      T_DEBUG_PROTOCOLL(("execute_edit_button(), couldn't open savefile! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
      if (parameter->taste!=KEY_CTRL_R)
       wprint_button(window,button_element,RELEASED);
      is_upper=T_FALSE;
      MOUSE_ZEIGE
      dispatcher_type_old= dispatcher_type;
      dispatcher_type= ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
      if (ed->filename!=NULL)
      {
       free(ed->filename);
       ed->filename=NULL;
      }
      filename=get_file_name("*.*", RETURN_PATH_NAME);
      dispatcher_type= dispatcher_type_old;
      if (fetch_edit_element(my_id)!=ed)
      {
       T_DEBUG_PROTOCOLL(("execute_edit_button(), window stolen after get_filename!"))
       if (filename!=NULL)
        free(filename);
       if (e_verbose>E_VERBOSE_NONE)
        show_message("Somebody stole my editor window!!!");
       T_DEBUG_FUNCTION_POSITION(7)
       T_DEBUG_LEAVE
       return parameter->ebene;
      }
      ed->filename=filename;
      if (ed->filename!=NULL)
       ed->handle_out=fopen(ed->filename,"wt");
      if (ed->handle_out==NULL)
      {
       T_DEBUG_PROTOCOLL(("execute_edit_button(), couldn't open savefile! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
       show_message("Error saving file...");
      }
      MOUSE_VERSTECKE
      aktivate_window(window);
      is_upper=T_TRUE;
     }
     if (ed->handle_out!=NULL)
     {
      T_DEBUG_PROTOCOLL(("execute_edit_button(), saving...(window name:\"%s\")(filename:\"%s\")(opened)", window->name,ed->filename))
      help=ed->text_zeile_erste;
      while (help)
      {
       T_PCHAR ret="\n";
       EDIT_ZEILE *zeile=(EDIT_ZEILE *)help->objekt;
       fwrite(zeile->text,strlen(zeile->text),sizeof(T_CHAR),ed->handle_out);
       fwrite(ret,strlen(ret),sizeof(T_CHAR),ed->handle_out);
       help=help->naechstes;
      }
      T_DEBUG_PROTOCOLL(("execute_edit_button(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
      fclose(ed->handle_out);
      ed->handle_out=NULL;
     }
    } // if (save==T_TRUE)
    else
    {
     if (ed->handle_out!=NULL)
     {
      T_DEBUG_PROTOCOLL(("execute_edit_button(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
      fclose(ed->handle_out);
      ed->handle_out=NULL;
      reopen=T_TRUE;
     }
    }
   } //if (ed->flag&EDIT_WITH_SAVE)
   else
   {
    if (ed->handle_out!=NULL)
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
     fclose(ed->handle_out);
     ed->handle_out=NULL;
     reopen=T_TRUE;
    }
   }
// filename holen
   T_DEBUG_PROTOCOLL(("execute_edit_button(), load, get new filename!(window name:\"%s\")", window->name))
   if (parameter->taste!=KEY_CTRL_R)
    wprint_button(window,button_element,RELEASED);
   dispatcher_type_old= dispatcher_type;
   is_upper=T_FALSE;
   MOUSE_ZEIGE
   dispatcher_type= ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
   filename=get_file_name("*.*", RETURN_PATH_NAME);
   dispatcher_type= dispatcher_type_old;
   if (fetch_edit_element(my_id)!=ed)
   {
    T_DEBUG_PROTOCOLL(("execute_edit_button(), window stolen after get_filename!"))
    if (filename!=NULL)
     free(filename);
    if (e_verbose>E_VERBOSE_NONE)
     show_message("Somebody stole my editor window!!!");
    T_DEBUG_FUNCTION_POSITION(8)
    T_DEBUG_LEAVE
    return parameter->ebene;
   }
   new_filename=filename;
   filename=NULL;
   MOUSE_VERSTECKE
   aktivate_window(window);
   is_upper=T_TRUE;
// checken
   if ((new_filename==NULL)||(f_file_exist(new_filename)==T_FALSE))
   {
    is_upper=T_FALSE;
    ed->lock=T_FALSE;
    MOUSE_ZEIGE
    if (new_filename!=NULL)
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), new filename, cannot open!(window name:\"%s\")(filename:\"%s\")", window->name,new_filename))
     show_message("File cannot be opened!\n\"%s\"",new_filename);
     free(new_filename);
     new_filename=NULL;
    }
    else
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), new filename==NULL!(window name:\"%s\")", window->name))
     t_printf(E_VERBOSE_STANDARD,"\nFile cannot be opened (NULL)!");
     show_message("File cannot be opened (NULL)!");
    }
    T_DEBUG_FUNCTION_POSITION(9)
    T_DEBUG_LEAVE
    return parameter->ebene;
   }
   if (ed->filename!=NULL)
    free(ed->filename);
   ed->filename=new_filename;
   new_filename=NULL;

// loeschen
   T_DEBUG_PROTOCOLL(("execute_edit_button(), load, remove old from memory!(window name:\"%s\")", window->name))
   help=ed->text_zeile_erste;
   while (help)
   {
    EDIT_ZEILE *zeile=(EDIT_ZEILE *)help->objekt;
    d_entferne_aus_liste( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte),DL_DONT_CLEAN_UP);
    free(zeile->text);
    free(zeile);
    help=ed->text_zeile_erste;
   }

// laden
   ed->font=font_now;
   ed->handle_out=NULL;
   ed->zeilen_anzahl=0;
   ed->x_first_char=0; // erste Spalte des Character arrays auf dem window (links/oben)
   ed->y_first_char=0; // erste Zeile des Character arrays auf dem window (links/oben)
   ed->x_start=0; // ab welchem Pixel im file
   ed->y_start=0; // ab welcher
   ed->x_ausgabe_start=0; // auf dem Fenster PIXEL
   ed->y_ausgabe_start=0; // auf dem Fenster
   ed->x_ausgabe_end=window->b_open;   // auf dem Fenster
   ed->y_ausgabe_end=window->h_open;   // auf dem Fenster
   ed->y_scroll=font_now->zeichen[' '].hoehe;
   ed->x_scroll=font_now->zeichen[' '].breite;
   ed->text_zeile_erste=NULL;
   ed->text_zeile_letzte=NULL;
   if (ed->filename!=NULL)
    ed->handle_out = fopen(ed->filename , "rt" );
   if (ed->handle_out!=NULL)
   {
    T_DEBUG_PROTOCOLL(("execute_edit_button(), reading load file! (window name:\"%s\")(filename:\"%s\")(opened)", window->name,ed->filename))
    do
    {
     T_INT len=0;
     ed->zeilen_anzahl++;
     zeile=(EDIT_ZEILE *)malloc(sizeof(EDIT_ZEILE));
     if (zeile==NULL)
     {
      ed->lock=T_FALSE;
      is_upper=T_FALSE;
      MOUSE_ZEIGE
      T_DEBUG_FUNCTION_POSITION(10)
      T_DEBUG_LEAVE
      tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
     }
     zeile->text=(T_PCHAR)malloc(EDIT_LINE_LEN+1);// plus one for safty and SPACE
     zeile->len_of_mem=EDIT_LINE_LEN;
     zeile->mark_start=0;
     zeile->mark_end=0;
     if (zeile->text==NULL)
     {
      ed->lock=T_FALSE;
      is_upper=T_FALSE;
      MOUSE_ZEIGE
      T_DEBUG_FUNCTION_POSITION(11)
      T_DEBUG_LEAVE
      tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
     }
     memset(zeile->text,0,zeile->len_of_mem);
     do
     {
      bytes_read=fread(zeile->text+len++,sizeof(T_UCHAR),1,ed->handle_out);
      if (*(zeile->text+len-1)==(T_CHAR)0x0d) *(zeile->text+len-1)=(T_CHAR)0;
      if (*(zeile->text+len-1)==(T_CHAR)0x0a) *(zeile->text+len-1)=(T_CHAR)0;
     } while ((bytes_read>0) &&(len<EDIT_LINE_LEN-1)&&(*(zeile->text+len-1)!=(T_CHAR)0));
     zeile->text[len]=(T_CHAR)0;
     if ((zeile->len_chars=strlen(zeile->text))>0)
      vesa_get_text_len(zeile->text,&zeile->len_pixel,&zeile->hight_pixel);
     else
     {
      zeile->len_pixel=0;
      zeile->hight_pixel=ed->len_y;
     }
     d_fuege_in_liste_ein( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte), DL_HINTEN );
    } while (bytes_read>0);
    if (ed->text_zeile_erste!=ed->text_zeile_letzte)
    {
     // mindestens eine Zeile, sonst eine Zeile zuviel, letzte (leere) Zeile loeschen
     T_DEBUG_PROTOCOLL(("execute_edit_button(), deleting empty last line! (window name:\"%s\")", window->name))
     ed->zeilen_anzahl--;
     d_entferne_aus_liste( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte),DL_DONT_CLEAN_UP);
     free(zeile->text);
     free(zeile);
    }
    T_DEBUG_PROTOCOLL(("execute_edit_button(), closing file! (window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
    fclose(ed->handle_out);
    ed->handle_out=NULL;
   } // if (ed->handle_out!=NULL)
   else
   {
    T_DEBUG_PROTOCOLL(("execute_edit_button(), somehow file could not be opened for reading!(window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
   }
   if (ed->zeilen_anzahl==0)
   {
    // empty editor object... creating one empty line...
    T_DEBUG_PROTOCOLL(("execute_edit_button(), empty objekt! (window name:\"%s\")", window->name))
    if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), creating single first line for EDIT! (window name:\"%s\")", window->name))
     ed->zeilen_anzahl++;
     zeile=(EDIT_ZEILE *)malloc(sizeof(EDIT_ZEILE));
     if (zeile==NULL)
     {
      ed->lock=T_FALSE;
      is_upper=T_FALSE;
      MOUSE_ZEIGE
      T_DEBUG_FUNCTION_POSITION(12)
      T_DEBUG_LEAVE
      tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
     }
     zeile->mark_start=0;
     zeile->mark_end=0;
     zeile->text=(T_PCHAR)malloc(EDIT_LINE_LEN+1);// plus one for safty and SPACE
     zeile->len_of_mem=EDIT_LINE_LEN;
     if (zeile->text==NULL)
     {
      ed->lock=T_FALSE;
      is_upper=T_FALSE;
      MOUSE_ZEIGE
      T_DEBUG_FUNCTION_POSITION(13)
      T_DEBUG_LEAVE
      tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
     }
     memset(zeile->text,0,zeile->len_of_mem);
     zeile->len_chars=0;
     zeile->len_pixel=0;
     zeile->hight_pixel=ed->len_y;
     d_fuege_in_liste_ein( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte), DL_HINTEN );
    }// if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
   }// if (ed->zeilen_anzahl==0)

// ausgeben
   if ((window->hide==0)&&(window->dhide==0))
   {
    T_DEBUG_PROTOCOLL(("execute_edit_button(), putting new load on screen! (window name:\"%s\")", window->name))
    vesa_rect_fill_oc(
     window->x+window->x_0,
     window->y+window->y_0,
     window->b_open,
     window->h_open,
     window->bcolor);
   }
   edit(window, NULL,EDIT_START);
   ed->changed=T_FALSE;
   if (reopen==T_TRUE)
   {
    reopen=T_FALSE;
    if (ed->filename!=NULL)
     ed->handle_out=fopen(ed->filename,"at");
    if (ed->handle_out==NULL)
    {
     T_DEBUG_PROTOCOLL(("execute_edit_button(), append file not opened!(window name:\"%s\")(filename:\"%s\")", window->name,ed->filename))
     ed->lock=T_FALSE;
     MOUSE_ZEIGE
     is_upper=T_FALSE;
     show_message("Error opening append file after load!!!");
     T_DEBUG_FUNCTION_POSITION(14)
     T_DEBUG_LEAVE
     return parameter->ebene;
    }
    T_DEBUG_PROTOCOLL(("execute_edit_button(), opening append file!(window name:\"%s\")(filename:\"%s\")(opened)", window->name,ed->filename))
   }
   if (parameter->taste!=KEY_CTRL_R)
    wprint_button(window,button_element,RELEASED);
   MOUSE_ZEIGE
   is_upper=T_FALSE;
   ed->lock=T_FALSE;
  }
 }
 if ((button->taste==KEY_UP)&&((parameter->maus_button==1)||(parameter->taste==KEY_UP)))
 {
  parameter->executed=PARAMETER_EXECUTED;
  T_DEBUG_PROTOCOLL(("execute_edit_button(), scroll up!(window name:\"%s\")", window->name))
  if (fKBDisALT()==T_TRUE)
  {
   help_function("scrollu.hlf",NULL);
   while (vesa_mouse_button)
    vesa_mouse_update();
  }
  else
  {
   T_INT lines_to_scroll=ed->y_scroll*line_scroll_width;
   if (ed->y_start>=lines_to_scroll)
   {
    MOUSE_VERSTECKE
    aktivate_window(window);
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_UP)
     wprint_button(window,button_element,PRESSED);
    do
    {
     ed->y_first_char-=lines_to_scroll/ed->len_y;
     lade_vga_nach_vga_teil_oc(
     window->x+window->x_0,
     window->y+window->y_0,
     window->b_open,
     window->h_open-lines_to_scroll,
     window->x+window->x_0,
     window->y+window->y_0+lines_to_scroll);

     vesa_rect_fill_oc(
     window->x+window->x_0,
     window->y+window->y_0,
     window->b_open,
     lines_to_scroll,
     window->bcolor);

     ed->y_start-=lines_to_scroll;
     ed->x_ausgabe_start=0;
     ed->y_ausgabe_start=0;
     ed->x_ausgabe_end=window->b_open;
     ed->y_ausgabe_end=lines_to_scroll;
     edit(window,NULL,0);
    } while ((fKBDisdown(SCAN_UP)==T_TRUE)&&(fast_scroll==T_TRUE)&&(ed->y_start>=lines_to_scroll));
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_UP)
     wprint_button(window,button_element,RELEASED);
    MOUSE_ZEIGE
    is_upper=T_FALSE;
   }
  }
 }
 if ((button->taste==KEY_PGUP)&&((parameter->maus_button==1)||(parameter->taste==KEY_PGUP)))
 {
  parameter->executed=PARAMETER_EXECUTED;
  T_DEBUG_PROTOCOLL(("execute_edit_button(), scroll page up!(window name:\"%s\")", window->name))
  if (fKBDisALT()==T_TRUE)
  {
   help_function("scrolpu.hlf",NULL);
  }
  else
  {
   T_INT lines_to_scroll=((window->h_open/font_now->zeichen[(T_BYTE)' '].hoehe)-1)*font_now->zeichen[(T_BYTE)' '].hoehe;
   MOUSE_VERSTECKE
   aktivate_window(window);
   is_upper=T_TRUE;
   if (ed->y_start<lines_to_scroll)
   {
    lines_to_scroll=ed->y_start;
   }
   ed->y_first_char-=lines_to_scroll/ed->len_y;
   lade_vga_nach_vga_teil_oc(
    window->x+window->x_0,
    window->y+window->y_0,
    window->b_open,
    window->h_open-lines_to_scroll,
    window->x+window->x_0,
    window->y+window->y_0+lines_to_scroll);

   vesa_rect_fill_oc(
    window->x+window->x_0,
    window->y+window->y_0,
    window->b_open,
    lines_to_scroll,
    window->bcolor);

   ed->y_start-=lines_to_scroll;
   ed->x_ausgabe_start=0;
   ed->y_ausgabe_start=0;
   ed->x_ausgabe_end=window->b_open;
   ed->y_ausgabe_end=lines_to_scroll;
   edit(window,NULL,0);
   MOUSE_ZEIGE
   is_upper=T_FALSE;
  }
 }
 if ((button->taste==KEY_PGDN)&&((parameter->maus_button==1)||(parameter->taste==KEY_PGDN)))
 {
  parameter->executed=PARAMETER_EXECUTED;
  T_DEBUG_PROTOCOLL(("execute_edit_button(), scroll page down!(window name:\"%s\")", window->name))
  if (fKBDisALT()==T_TRUE)
  {
   help_function("scrolpd.hlf",NULL);
  }
  else
  {
   T_INT lines_to_scroll=((window->h_open/font_now->zeichen[(T_BYTE)' '].hoehe)-1)*font_now->zeichen[(T_BYTE)' '].hoehe;
   MOUSE_VERSTECKE
   aktivate_window(window);
   is_upper=T_TRUE;
   if (ed->y_start+lines_to_scroll>ed->zeilen_anzahl*font_now->zeichen[(T_BYTE)' '].hoehe)
   {
    lines_to_scroll=ed->zeilen_anzahl*font_now->zeichen[(T_BYTE)' '].hoehe-ed->y_start;
   }
   ed->y_first_char+=lines_to_scroll/ed->len_y;
   lade_vga_nach_vga_teil_oc(
    window->x+window->x_0,
    window->y+window->y_0+lines_to_scroll,
    window->b_open,
    window->h_open-lines_to_scroll,
    window->x+window->x_0,
    window->y+window->y_0);

   vesa_rect_fill_oc(
    window->x+window->x_0,
    window->y+window->y_0+window->h_open-lines_to_scroll,
    window->b_open,
    lines_to_scroll,
    window->bcolor);

   ed->y_start+=lines_to_scroll;
   ed->x_ausgabe_start=0;
   ed->y_ausgabe_start=window->h_open-lines_to_scroll;
   ed->x_ausgabe_end=window->b_open;
   ed->y_ausgabe_end=window->h_open;
   edit(window,NULL,0);
   MOUSE_ZEIGE
   is_upper=T_FALSE;
  }
 }
 if ((button->taste==KEY_DOWN)&&((parameter->maus_button==1)||(parameter->taste==KEY_DOWN)))
 {
  parameter->executed=PARAMETER_EXECUTED;
  T_DEBUG_PROTOCOLL(("execute_edit_button(), scroll down!(window name:\"%s\")", window->name))
  if (fKBDisALT()==T_TRUE)
  {
   help_function("scrolld.hlf",NULL);
   while (vesa_mouse_button)
    vesa_mouse_update();
  }
  else
  {
   T_INT lines_to_scroll=ed->y_scroll*line_scroll_width;
   if (ed->y_start+lines_to_scroll<=ed->zeilen_anzahl*font_now->zeichen[(T_BYTE)' '].hoehe)
   {
    MOUSE_VERSTECKE
    aktivate_window(window);
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_DOWN)
     wprint_button(window,button_element,PRESSED);
    do
    {
     ed->y_first_char+=lines_to_scroll/ed->len_y;

     lade_vga_nach_vga_teil_oc(
      window->x+window->x_0,
      window->y+window->y_0+lines_to_scroll,
      window->b_open,
      window->h_open-lines_to_scroll,
      window->x+window->x_0,
      window->y+window->y_0);

     vesa_rect_fill_oc(
      window->x+window->x_0,
      window->y+window->y_0+window->h_open-lines_to_scroll,
      window->b_open,
      lines_to_scroll,
      window->bcolor);

     ed->y_start+=lines_to_scroll;
     ed->x_ausgabe_start=0;
     ed->y_ausgabe_start=window->h_open-lines_to_scroll;
     ed->x_ausgabe_end=window->b_open;
     ed->y_ausgabe_end=window->h_open;
     edit(window,NULL,0);
    } while ((fKBDisdown(SCAN_DOWN)==T_TRUE)&&(fast_scroll==T_TRUE)&&(ed->y_start+lines_to_scroll<=ed->zeilen_anzahl*font_now->zeichen[(T_BYTE)' '].hoehe));
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_DOWN)
     wprint_button(window,button_element,RELEASED);
    MOUSE_ZEIGE
    is_upper=T_FALSE;
   }
  }
 }
 if ((button->taste==KEY_RIGHT)&&((parameter->maus_button==1)||(parameter->taste==KEY_RIGHT)))
 {
  parameter->executed=PARAMETER_EXECUTED;
  T_DEBUG_PROTOCOLL(("execute_edit_button(), scroll right!(window name:\"%s\")", window->name))
  if (fKBDisALT()==T_TRUE)
  {
   help_function("scrolll.hlf",NULL);
   while (vesa_mouse_button)
    vesa_mouse_update();
  }
  else
  {
   T_INT lines_to_scroll=ed->x_scroll*line_scroll_width;
   if (ed->x_start+window->b_open+lines_to_scroll<EDIT_LINE_LEN*font_now->zeichen[(T_BYTE)' '].breite)
   {
    MOUSE_VERSTECKE
    aktivate_window(window);
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_RIGHT)
     wprint_button(window,button_element,PRESSED);

    lade_vga_nach_vga_teil_oc(
     window->x+window->x_0+lines_to_scroll,
     window->y+window->y_0,
     window->b_open-lines_to_scroll,
     window->h_open,
     window->x+window->x_0,
     window->y+window->y_0);

    vesa_rect_fill_oc(
     window->x+window->x_0+window->b_open-lines_to_scroll,
     window->y+window->y_0,
     lines_to_scroll,
     window->h_open,
     window->bcolor);
/* CHRIS */
    ed->x_first_char+=lines_to_scroll/(ed->len_x);
    ed->x_start+=lines_to_scroll;
    ed->y_ausgabe_start=0;
    ed->x_ausgabe_start=window->b_open-lines_to_scroll;
    ed->y_ausgabe_end=window->h_open;
    ed->x_ausgabe_end=window->b_open;
    edit(window,NULL,0);
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_RIGHT)
     wprint_button(window,button_element,RELEASED);
    MOUSE_ZEIGE
    is_upper=T_FALSE;
   }
  }
 }
 if ((button->taste==KEY_LEFT)&&((parameter->maus_button==1)||(parameter->taste==KEY_LEFT)))
 {
  parameter->executed=PARAMETER_EXECUTED;
  if (fKBDisALT()==T_TRUE)
  {
   help_function("scrolr.hlf",NULL);
  }
  else
  {
   T_INT lines_to_scroll=ed->x_scroll*line_scroll_width;
   if (ed->x_start>=lines_to_scroll)
   {
    MOUSE_VERSTECKE
    aktivate_window(window);
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_LEFT)
     wprint_button(window,button_element,PRESSED);
    lade_vga_nach_vga_teil_oc(
    window->x+window->x_0,
    window->y+window->y_0,
    window->b_open-lines_to_scroll,
    window->h_open,
    window->x+window->x_0+lines_to_scroll,
    window->y+window->y_0);

    vesa_rect_fill_oc(
    window->x+window->x_0,
    window->y+window->y_0,
    lines_to_scroll,
    window->h_open,
    window->bcolor);

    ed->x_first_char-=lines_to_scroll/(ed->len_x);
    ed->x_start-=lines_to_scroll;

    ed->x_ausgabe_start=0;
    ed->y_ausgabe_start=0;

    ed->x_ausgabe_end=lines_to_scroll;
    ed->y_ausgabe_end=window->h_open;
    edit(window,NULL,0);
    is_upper=T_TRUE;
    if (parameter->taste!=KEY_LEFT)
     wprint_button(window,button_element,RELEASED);
    MOUSE_ZEIGE
    is_upper=T_FALSE;
   }
  }
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

// nur schoen mit NICHT Proportionalschrift
T_INT edit(WINDOW_LISTEN_ELEMENT *window, T_PCHAR datei, T_INT flags)
{
 T_INT bytes_read=0;
 T_INT i;
 EDIT_ELEMENT *ed=NULL;
 EDIT_ZEILE *zeile;
 T_LISTE *zeilen_liste=ed->text_zeile_erste;
 T_INT old_print_modus;
 T_INT old_text;
 T_INT old_back_color;
 T_INT old_text_color;
// not done yet T_INT pixel_pos_in_text_x;
 T_INT pixel_pos_in_text_y;
// not done yet T_INT pixel_pos_on_screen_x;
 T_INT pixel_pos_on_screen_y;
 T_DEBUG_ENTRY("edit",85)
 if ((window->hide!=0)||(window->dhide!=0))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_OK;
 }
 ed=fetch_edit_element(window->id);
 MOUSE_VERSTECKE
 if (ed==NULL)
 {
  T_LISTE *button_liste=window->button_first;
  BUTTON_LISTEN_ELEMENT *button_element=NULL;
  BUTTON *pbutton;
  BUTTON *button=NULL;
  T_INT remember_x=window->b-window->border_r;
  T_INT remember_y=window->y_0;
  FILE *handle_in=NULL;
  EDIT_ZEILE *zeile;
  if (window->y_0<default_button_size)
  {
   MOUSE_ZEIGE
   T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_WINDOW_NO_BUTTON_SPACE)
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_NOT_OK;
  }
  ed=(EDIT_ELEMENT *)malloc(sizeof(EDIT_ELEMENT));
  if (ed==NULL)
  {
   MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
  }
  vesa_get_text_len("m",&ed->len_x,&ed->len_y);
  ed->window=window;
  if (datei!=NULL)
   ed->filename=strdup(datei);
  else
   ed->filename=NULL;
  ed->flag=flags;
  if ((ed->flag&EDIT_START)==EDIT_START)
   ed->flag-=EDIT_START;
  if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
  {
   window->area_funktion=edit_area_function;
   window->tasten_funktion=edit_key_function;
  }
  ed->old_update_funktion=window->update_funktion;
  window->update_funktion=edit_update_function;
  ed->old_destructor=window->destructor;
  window->destructor=edit_destructor;
  ed->autosave=autosave_default;
  ed->changed=T_FALSE;
  ed->font=font_now;
  ed->handle_out=NULL;
  ed->window_id=window->id;
  ed->zeilen_anzahl=0;
  ed->x_first_char=0; // erste Spalte des Character arrays auf dem window (links/oben)
  ed->y_first_char=0; // erste Zeile des Character arrays auf dem window (links/oben)
  ed->x_start=0; // ab welchem Pixel im file
  ed->y_start=0; // ab welcher
  ed->x_ausgabe_start=0; // auf dem Fenster PIXEL
  ed->y_ausgabe_start=0; // auf dem Fenster
  ed->x_ausgabe_end=window->b_open;   // auf dem Fenster
  ed->y_ausgabe_end=window->h_open;   // auf dem Fenster
  ed->y_scroll=font_now->zeichen[' '].hoehe;
  ed->x_scroll=font_now->zeichen[' '].breite;
  ed->lock=T_FALSE;
  ed->text_zeile_erste=NULL;
  ed->text_zeile_letzte=NULL;
  ed->key_functions_erste=NULL;
  ed->key_functions_letzte=NULL;
  ed->help_word_erste=NULL;
  ed->help_word_letzte=NULL;
  ed->is_marking=T_FALSE;

  d_fuege_in_liste_ein( ed, &edit_erste, &edit_letzte, DL_HINTEN );
  if (datei!=NULL)
  {
   handle_in = fopen(datei , "rt" );
   if (handle_in!=NULL)
   {
    T_DEBUG_PROTOCOLL(("edit(), reading file! (window name:\"%s\")(filename:\"%s\")(opened)", window->name,ed->filename))
    do
    {
     T_INT len=0;
     ed->zeilen_anzahl++;
     zeile=(EDIT_ZEILE *)malloc(sizeof(EDIT_ZEILE));
     if (zeile==NULL)
     {
      MOUSE_ZEIGE
      T_DEBUG_FUNCTION_POSITION(4)
      T_DEBUG_LEAVE
      tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
     }
     zeile->mark_start=0;
     zeile->mark_end=0;
     zeile->text=(T_PCHAR)malloc(EDIT_LINE_LEN+1);// plus one for safty and SPACE
     zeile->len_of_mem=EDIT_LINE_LEN;
     if (zeile->text==NULL)
     {
      MOUSE_ZEIGE
      T_DEBUG_FUNCTION_POSITION(5)
      T_DEBUG_LEAVE
      tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
     }
     memset(zeile->text,0,zeile->len_of_mem);
     do
     {
      bytes_read=fread(zeile->text+len++,sizeof(T_UCHAR),1,handle_in);
      if (*(zeile->text+len-1)==(T_CHAR)0x0d) *(zeile->text+len-1)=(T_CHAR)0;
      if (*(zeile->text+len-1)==(T_CHAR)0x0a) *(zeile->text+len-1)=(T_CHAR)0;
     } while ((bytes_read>0) &&(len<EDIT_LINE_LEN-1)&&(*(zeile->text+len-1)!=(T_CHAR)0));
     zeile->text[len]=(T_CHAR)0;
     if ((zeile->len_chars=strlen(zeile->text))>0)
      vesa_get_text_len(zeile->text,&zeile->len_pixel,&zeile->hight_pixel);
     else
     {
      zeile->len_pixel=0;
      zeile->hight_pixel=ed->len_y;
     }
     d_fuege_in_liste_ein( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte), DL_HINTEN );
    } while (bytes_read>0);
    if (ed->text_zeile_erste!=ed->text_zeile_letzte)
    {
     /* mindestens eine Zeile, sonst eine Zeile zuviel, letzte (leere) Zeile loeschen */
     ed->zeilen_anzahl--;
     d_entferne_aus_liste( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte),DL_DONT_CLEAN_UP);
    }
    fclose(handle_in);
   } // if (handle_in!=NULL)
  } //if (datei!=NULL)
  if (ed->zeilen_anzahl==0)
  {
   // empty editor object... creating one empty line...
   if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
   {
    ed->zeilen_anzahl++;
    zeile=(EDIT_ZEILE *)malloc(sizeof(EDIT_ZEILE));
    if (zeile==NULL)
    {
     MOUSE_ZEIGE
     T_DEBUG_FUNCTION_POSITION(6)
     T_DEBUG_LEAVE
     tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
    }
    zeile->mark_start=0;
    zeile->mark_end=0;
    zeile->text=(T_PCHAR)malloc(EDIT_LINE_LEN+1);// plus one for safty and SPACE
    zeile->len_of_mem=EDIT_LINE_LEN;
    if (zeile->text==NULL)
    {
     MOUSE_ZEIGE
     T_DEBUG_FUNCTION_POSITION(7)
     T_DEBUG_LEAVE
     tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
    }
    memset(zeile->text,0,zeile->len_of_mem);
    zeile->len_chars=0;
    zeile->len_pixel=0;
    zeile->hight_pixel=ed->len_y;
    d_fuege_in_liste_ein( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte), DL_HINTEN );
   }// if ((ed->flag&EDIT_EDIT)==EDIT_EDIT)
  }
  if ((ed->flag&EDIT_EDIT)!=EDIT_EDIT)
  {
   button = make_mem_bild_button(runter,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_DOWN,SWITCH_ON_PRESSED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(8)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;

   button_liste=window->button_first;
   while (button_liste!=NULL)
   {
    if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
    {
     button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    }
    button_liste=button_liste->naechstes;
   }
   if (button_element==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(9)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   button_liste=window->button_first;
   button = make_mem_bild_button(hoch,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_UP,SWITCH_ON_PRESSED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(10)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;

   button_liste=window->button_first;
   while (button_liste!=NULL)
   {
    if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
    {
     button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    }
    button_liste=button_liste->naechstes;
   }
   if (button_element==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(11)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   else
   button_liste=window->button_first;
   button = make_mem_bild_button(drunter,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_PGDN,SWITCH_ON_RELEASED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(12)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;

   button_liste=window->button_first;
   while (button_liste!=NULL)
   {
    if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
    {
     button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    }
    button_liste=button_liste->naechstes;
   }
   if (button_element==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(13)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   button_liste=window->button_first;
   button = make_mem_bild_button(dhoch,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_PGUP,SWITCH_ON_RELEASED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(14)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;

   button_liste=window->button_first;
   while (button_liste!=NULL)
   {
    if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
    {
     button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    }
    button_liste=button_liste->naechstes;
   }
   if (button_element==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(15)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   button_liste=window->button_first;
   button = make_mem_bild_button(right,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_RIGHT,SWITCH_ON_PRESSED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(16)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;

   button_liste=window->button_first;
   while (button_liste!=NULL)
   {
    if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
    {
     button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    }
    button_liste=button_liste->naechstes;
   }
   if (button_element==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(17)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   button_liste=window->button_first;
   button = make_mem_bild_button(left,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_LEFT,SWITCH_ON_PRESSED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(18)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;
  } // if ((ed->flag&EDIT_EDIT)!=EDIT_EDIT)
  if ((ed->flag&EDIT_WITH_SAVE)==EDIT_WITH_SAVE)
  {
   button_liste=window->button_first;
   button = make_mem_bild_button(write_pic,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_CTRL_S,SWITCH_ON_RELEASED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create save button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(19)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;

   button_liste=window->button_first;
   while (button_liste!=NULL)
   {
    if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
    {
     button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    }
    button_liste=button_liste->naechstes;
   }
   if (button_element==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(20)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
  }
  if ((ed->flag&EDIT_WITH_LOAD)==EDIT_WITH_LOAD)
  {
   button_liste=window->button_first;
   button = make_mem_bild_button(read_pic,default_back_pixel,button_color3, button_color4,button_color5,button_color6,2,KEY_CTRL_R,SWITCH_ON_RELEASED);
   if (button==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create load button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(21)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   while(button_liste)
   {
    BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    pbutton=be->button;
    if (be->y_offset<window->y_0)
    {
     if (remember_x>be->x_offset)
     {
      remember_x=be->x_offset;
      remember_y=be->y_offset;
     }
    }
    button_liste=button_liste->naechstes;
   } //while(button_liste)
   button_raw=T_TRUE;
   add_wbutton(window,button,remember_x-(2*2+default_button_size+2),remember_y,0);
   button_raw=T_FALSE;
   button->button_funktion=execute_edit_button;

   button_liste=window->button_first;
   while (button_liste!=NULL)
   {
    if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
    {
     button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
    }
    button_liste=button_liste->naechstes;
   }
   if (button_element==NULL)
   {
    MOUSE_ZEIGE
    t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new button!");
    T_DEBUG_SET_THIS_FUNCTION_ERROR(EDIT_BUTTON_CREATION_FAILED)
    T_DEBUG_FUNCTION_POSITION(22)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
  }
  if (((ed->flag&EDIT_LOG)==EDIT_LOG)&&((ed->flag&EDIT_NO_LOG_FILE)!=EDIT_NO_LOG_FILE))
  {
   ed->handle_out=fopen(datei,"at");
   if (ed->handle_out!=NULL)
   {
    T_DEBUG_PROTOCOLL(("edit(), opening append file! (window name:\"%s\")(filename:\"%s\")(opened)", window->name,ed->filename))
   }
  }
 } // if (ed==NULL)
 // now there should be a correct ed structure available
 old_print_modus=vesa_print_modus;
 old_text=vesa_text;
 old_back_color=vesa_back_color;
 old_text_color=vesa_text_color;
 vesa_print_modus=PIC_FILLED;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=dhell_grau;
 vesa_text_color=ddark_grau;
 zeilen_liste=ed->text_zeile_erste;
 pixel_pos_in_text_y=0;
 pixel_pos_on_screen_y=ed->y_ausgabe_start;
 if (((ed->flag&EDIT_LOG)==EDIT_LOG)&&((ed->flag&EDIT_EDIT)!=EDIT_EDIT))
 {
  // remove empty lines
  if (zeilen_liste!=NULL)
  {
   do
   {
    zeile=(EDIT_ZEILE *)zeilen_liste->objekt;
    zeilen_liste=zeilen_liste->naechstes;
    if (strlen(zeile->text)==0)
    {
     d_entferne_aus_liste( zeile, &(ed->text_zeile_erste), &(ed->text_zeile_letzte),DL_DONT_CLEAN_UP);
     free(zeile->text);
     free(zeile);
     ed->zeilen_anzahl--;
    }
   } while (zeilen_liste);
  }
  zeilen_liste=ed->text_zeile_erste;
 }
 for (i=0;i<ed->zeilen_anzahl;i++)
 {
  zeile=(EDIT_ZEILE *)zeilen_liste->objekt;
  zeilen_liste=zeilen_liste->naechstes;
  if (  (pixel_pos_in_text_y<ed->y_start+ed->y_ausgabe_end)
      &&(pixel_pos_in_text_y+ed->len_y>ed->y_start+ed->y_ausgabe_start))
  {
   // hier auch aendern fuer proportionalschrift...
   strcat(zeile->text," ");
   vesa_print_string_max_oc(0,0,
            WX(ed->x_ausgabe_start),
            WY(pixel_pos_on_screen_y),
            ed->x_ausgabe_end - ed->x_ausgabe_start,
            ed->y_ausgabe_end - pixel_pos_on_screen_y,
            (zeile->text+(ed->x_start + ed->len_x -1) / (ed->len_x)+
             (( ed->x_ausgabe_start +  (ed->len_x -1) ) / (ed->len_x))
            ));
   zeile->text[zeile->len_chars]=0;
   pixel_pos_on_screen_y+=zeile->hight_pixel;
  }
  pixel_pos_in_text_y+=zeile->hight_pixel;
 }
 vesa_print_modus=old_print_modus;
 vesa_text=old_text;
 vesa_back_color=old_back_color;
 vesa_text_color=old_text_color;
 if (((ed->flag&EDIT_EDIT)==EDIT_EDIT)&&((flags&EDIT_START)==EDIT_START))
 {
  /* set first time cursor position */
  ed->cpos_x=0;
  ed->cpos_y=0;
  ed->mode=edit_mode;
  set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
 }
 MOUSE_ZEIGE
 T_DEBUG_LEAVE
 return T_OK;
}

// does all scrolling and corrects impossible cursor positions...
void set_edit_cursor(EDIT_ELEMENT *ed, T_INT flag, T_SINT inc_x, T_SINT inc_y)
{
 WINDOW_LISTEN_ELEMENT *window=ed->window;
 EDIT_ZEILE *zeile;
 T_INT lc=0;
 T_LISTE *zeilen_liste=ed->text_zeile_erste;
 T_CHAR sign;
 T_INT x_pos,y_pos;
 T_INT old_print_modus;
 T_INT old_text;
 T_INT old_back_color;
 T_INT old_text_color;
 T_DEBUG_ENTRY("set_edit_cursor",85)
 if (ed->cpos_y+inc_y>ed->zeilen_anzahl-1)
 {
  zeilen_liste=ed->text_zeile_letzte;
  inc_y=(ed->zeilen_anzahl-1)-ed->cpos_y;
  ed->cpos_y=ed->zeilen_anzahl-1;
 }
 else if (ed->cpos_y+inc_y<0)
 {
  // zeilen_liste is allready at first element!
  inc_y=-ed->cpos_y; // result is zero
  ed->cpos_y=0;
 }
 else
 {
  ed->cpos_y+=inc_y;
  while ((lc!=ed->cpos_y)&&(zeilen_liste!=NULL))
  {
   zeilen_liste=zeilen_liste->naechstes;
   lc++;
  }
  if (zeilen_liste==NULL)
  {
   t_printf(E_VERBOSE_STANDARD,"\nEdit jump to unknown line...");
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return;
  }
 }
 zeile=(EDIT_ZEILE *)(zeilen_liste->objekt);
 ed->cursor_line=zeile;
 if ((ed->cpos_x+inc_x>zeile->len_chars)&&(zeile->len_chars<EDIT_LINE_LEN))
 {
  inc_x=(zeile->len_chars)-ed->cpos_x;
  ed->cpos_x=zeile->len_chars;
 }
 else if (ed->cpos_x+inc_x>EDIT_LINE_LEN-1)
 {
  inc_x=(EDIT_LINE_LEN-1)-ed->cpos_x;
  ed->cpos_x=EDIT_LINE_LEN-1;
 }
 else if (ed->cpos_x+inc_x<0)
 {
  inc_x=-ed->cpos_x;
  ed->cpos_x=0;
 }
 else
  ed->cpos_x+=inc_x;
 sign=(T_CHAR)zeile->text[ed->cpos_x];
 if (sign==(T_CHAR)0)
  sign=' '; /* default 'NO SIGN' is space */

// !!! inc should be correct NOW !!!
// hier inc_? fuer cursor richtig, jetzt fuer scrolling richten...
// assuming correct window len...
 if (inc_y>0)
 {
  if (1+ed->cpos_y>((ed->window->h_open+ed->y_start)/ed->font->zeichen[(T_BYTE)' '].hoehe))
  {
   inc_y=1+ed->cpos_y-((ed->window->h_open+ed->y_start)/ed->font->zeichen[(T_BYTE)' '].hoehe);
  }
  else
   inc_y=0;
 }
 else
 {
  if (ed->cpos_y<ed->y_start/ed->font->zeichen[(T_BYTE)' '].hoehe)
  {
   inc_y=-((ed->y_start/ed->font->zeichen[(T_BYTE)' '].hoehe)-ed->cpos_y);
  }
  else
   inc_y=0;
 }
 if (inc_x>0)
 {
  if (1+ed->cpos_x>((ed->window->b_open+ed->x_start)/ed->font->zeichen[(T_BYTE)' '].breite))
  {
   inc_x=1+ed->cpos_x-((ed->window->b_open+ed->x_start)/ed->font->zeichen[(T_BYTE)' '].breite);
  }
  else
   inc_x=0;
 }
 else
 {
  if (ed->cpos_x<ed->x_start/ed->font->zeichen[(T_BYTE)' '].breite)
  {
   inc_x=-((ed->x_start/ed->font->zeichen[(T_BYTE)' '].breite)-ed->cpos_x);
  }
  else
   inc_x=0;
 }

 if ((inc_x!=0)||(inc_y!=0))
  correct_edit_window(ed,inc_x,inc_y); // scrolling...

/* NON PROPORTIONAL FONT !!! */
 x_pos=window->x+window->x_0+ed->cpos_x*ed->font->zeichen[(T_INT)' '].breite-ed->x_start;
 y_pos=window->y+window->y_0+ed->cpos_y*ed->font->zeichen[(T_INT)' '].hoehe-ed->y_start;

 old_print_modus=vesa_print_modus;
 old_text=vesa_text;
 old_back_color=vesa_back_color;
 old_text_color=vesa_text_color;
 vesa_print_modus=PIC_FILLED;
 vesa_text=SINGLE_COLOR;
 if (flag==EDIT_CURSOR_INVERS)
 {
  if (ed->mode==EDIT_MODE_OVERWRITE)
   vesa_back_color=schwarz;
  else
   vesa_back_color=weiss;
  vesa_text_color=dhell_grau;
 }
 else
 {
  vesa_back_color=dhell_grau;
  vesa_text_color=ddark_grau;
 }
 vesa_print_char(x_pos,y_pos,sign);
 vesa_print_modus=old_print_modus;
 vesa_text=old_text;
 vesa_back_color=old_back_color;
 vesa_text_color=old_text_color;
 T_DEBUG_LEAVE
 return;
}

// assuming inc_? are correct!!!
// on 0 0 the window is still completly redrawn... (a refresh)
T_VOID correct_edit_window(EDIT_ELEMENT *ed, T_SINT inc_x, T_SINT inc_y)
{
 T_INT line_max=ed->window->h_open/ed->font->zeichen[(T_BYTE)' '].hoehe;
 T_INT sign_max=ed->window->b_open/ed->font->zeichen[(T_BYTE)' '].breite;
 T_DEBUG_ENTRY("correct_edit_window",85)

 if ((((inc_x==1)||(inc_x==-1))&&(inc_y==0))||(((inc_y==1)||(inc_y==-1))&&(inc_x==0)))
 { // one step in only one direction
  if (inc_x<0)
  {
   if (ed->cpos_x<ed->x_start/ed->font->zeichen[(T_BYTE)' '].breite)
   {
    if (inc_x==-1)
    {
     T_INT lines_to_scroll=ed->font->zeichen[(T_BYTE)' '].breite;
     lade_vga_nach_vga_teil_oc(
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0,
     ed->window->b_open-lines_to_scroll,
     ed->window->h_open,
     ed->window->x+ed->window->x_0+lines_to_scroll,
     ed->window->y+ed->window->y_0);

     vesa_rect_fill_oc(
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0,
     lines_to_scroll,
     ed->window->h_open,
     ed->window->bcolor);

     ed->x_first_char--;
     ed->x_start-=lines_to_scroll;
     ed->x_ausgabe_start=0;
     ed->y_ausgabe_start=0;

     ed->x_ausgabe_end=lines_to_scroll;
     ed->y_ausgabe_end=ed->window->h_open;
     edit(ed->window,NULL,0);
    } //if (inc_x==-1)
   } //if (ed->cpos_x<ed->x_start/ed->font->zeichen[(T_BYTE)' '].breite)
  } //if (inc_x<0)
  else if (inc_x>0)
  {
   if (ed->cpos_x-(ed->x_start/ed->font->zeichen[(T_BYTE)' '].breite)>=sign_max)
   {
    if (inc_x==1)
    {
     T_INT lines_to_scroll=ed->font->zeichen[(T_BYTE)' '].breite;
     lade_vga_nach_vga_teil_oc(
     ed->window->x+ed->window->x_0+lines_to_scroll,
     ed->window->y+ed->window->y_0,
     ed->window->b_open-lines_to_scroll,
     ed->window->h_open,
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0);

     vesa_rect_fill_oc(
     ed->window->x+ed->window->x_0+ed->window->b_open-lines_to_scroll,
     ed->window->y+ed->window->y_0,
     lines_to_scroll,
     ed->window->h_open,
     ed->window->bcolor);

     ed->x_first_char++;
     ed->x_start+=lines_to_scroll;
     ed->y_ausgabe_start=0;
     ed->x_ausgabe_start=ed->window->b_open-lines_to_scroll;
     ed->y_ausgabe_end=ed->window->h_open;
     ed->x_ausgabe_end=ed->window->b_open;
     edit(ed->window,NULL,0);
    } //if (inc_x==1)
   } //if (ed->cpos_x-(ed->x_start/ed->font->zeichen[(T_BYTE)' '].breite)>=sign_max)
  } //else if (inc_x>0)
  else if (inc_y<0)
  {
   if (ed->cpos_y<ed->y_start/ed->font->zeichen[(T_BYTE)' '].hoehe)
   {
    if (inc_y==-1)
    {
     T_INT lines_to_scroll=ed->font->zeichen[(T_BYTE)' '].hoehe;
     ed->y_first_char--;
     lade_vga_nach_vga_teil_oc(
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0,
     ed->window->b_open,
     ed->window->h_open-lines_to_scroll,
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0+lines_to_scroll);

     vesa_rect_fill_oc(
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0,
     ed->window->b_open,
     lines_to_scroll,
     ed->window->bcolor);

     ed->y_start-=lines_to_scroll;
     ed->x_ausgabe_start=0;
     ed->y_ausgabe_start=0;
     ed->x_ausgabe_end=ed->window->b_open;
     ed->y_ausgabe_end=lines_to_scroll;
     edit(ed->window,NULL,0);
    } //if (inc_y==-1)
   }//(ed->cpos_y<ed->y_start/ed->font->zeichen[(T_BYTE)' '].hoehe)
  } //else if (inc_y<0)
  else if (inc_y>0)
  {
   if (ed->cpos_y-(ed->y_start/ed->font->zeichen[(T_BYTE)' '].hoehe)>=line_max)
   {
    if (inc_y==1)
    {
     T_INT lines_to_scroll=ed->font->zeichen[(T_BYTE)' '].hoehe;
     ed->y_first_char++;
     lade_vga_nach_vga_teil_oc(
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0+lines_to_scroll,
     ed->window->b_open,
     ed->window->h_open-lines_to_scroll,
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0);

     vesa_rect_fill_oc(
     ed->window->x+ed->window->x_0,
     ed->window->y+ed->window->y_0+ed->window->h_open-lines_to_scroll,
     ed->window->b_open,
     lines_to_scroll,
     ed->window->bcolor);

     ed->y_start+=lines_to_scroll;
     ed->x_ausgabe_start=0;
     ed->y_ausgabe_start=ed->window->h_open-lines_to_scroll;
     ed->x_ausgabe_end=ed->window->b_open;
     ed->y_ausgabe_end=ed->window->h_open;
     edit(ed->window,NULL,0);
    } //if (inc_y==1)
   }//if (ed->cpos_y-ed->y_start>line_max)
  } //else if (inc_y>0)
 }// if ((((inc_x==1)||(inc_x==-1))&&(inc_y==0))||(((inc_y==1)||(inc_y==-1))&&(inc_x==0)))
 else
 { // more than one step or diagonal, refresh whole window in that case...
  vesa_rect_fill_oc(
  ed->window->x+ed->window->x_0,
  ed->window->y+ed->window->y_0,
  ed->window->b_open,
  ed->window->h_open,
  ed->window->bcolor);

  ed->x_start+=ed->len_x*inc_x;
  ed->y_start+=ed->len_y*inc_y;

  ed->x_first_char+=inc_x;
  ed->y_first_char+=inc_y;
  ed->x_ausgabe_start=0;
  ed->y_ausgabe_start=0;
  ed->x_ausgabe_end=ed->window->b_open;
  ed->y_ausgabe_end=ed->window->h_open;
  edit(ed->window,NULL,0);
 }
 T_DEBUG_LEAVE
}
// no check for x/y fitting, since cursor position must be correct!
T_VOID redraw_line(EDIT_ELEMENT *ed)
{
// ed->y_start; // bleiben gleich bei einem redraw...
// ed->x_start;
 T_DEBUG_ENTRY("redraw_line_cursor",85)

 ed->x_ausgabe_start=0;
 ed->y_ausgabe_start=(ed->cpos_y-ed->y_first_char)*ed->len_y;
 ed->x_ausgabe_end=ed->window->b_open; // doesn't matter if to long
 ed->y_ausgabe_end=ed->y_ausgabe_start+ed->len_y;

 vesa_rect_fill_oc(
 ed->window->x+ed->window->x_0,
 ed->window->y+ed->window->y_0+ed->y_ausgabe_start,
 ed->window->b_open,
 ed->len_y,
 ed->window->bcolor);

 edit(ed->window,NULL,0);
 T_DEBUG_LEAVE
}

// no check for x/y fitting, since cursor position must be correct!
T_VOID redraw_line_from_cursor(EDIT_ELEMENT *ed)
{
// ed->y_start; // bleiben gleich bei einem redraw...
// ed->x_start;
 T_DEBUG_ENTRY("redraw_line_from_cursor",85)
 ed->x_ausgabe_start=(ed->cpos_x-ed->x_first_char)*ed->len_x;
 ed->y_ausgabe_start=(ed->cpos_y-ed->y_first_char)*ed->len_y;
 ed->x_ausgabe_end=ed->window->b_open; // doesn't matter if to long
 ed->y_ausgabe_end=ed->y_ausgabe_start+ed->len_y;
 edit(ed->window,NULL,0);
 T_DEBUG_LEAVE
}

T_VOID redraw_window_from_cursor(EDIT_ELEMENT *ed)
{ // similar to scroll down
 // correct_edit_window(ed,0,0); // lazy... redraw everything... (works ok)
 // two step approach, first redraw bottom stuff
 // than the current line using the above function...
 T_DEBUG_ENTRY("redraw_window_from_cursor",85)
 if ((ed->cpos_y-ed->y_first_char+2)*ed->len_y<ed->window->h_open)
 {
  lade_vga_nach_vga_teil_oc(
  ed->window->x+ed->window->x_0,
  ed->window->y+ed->window->y_0+(ed->cpos_y-ed->y_first_char+2)*ed->len_y,
  ed->window->b_open,
  ed->window->h_open-(ed->cpos_y-ed->y_first_char+2)*ed->len_y,
  ed->window->x+ed->window->x_0,
  ed->window->y+ed->window->y_0+(ed->cpos_y-ed->y_first_char+1)*ed->len_y);
 }
 // zur Zeit wird letzte Zeile IMMER geloescht, selbst nach einem EOF,
 // na und!
 vesa_rect_fill_oc(
 ed->window->x+ed->window->x_0,
 ed->window->y+ed->window->y_0+((ed->window->h_open/ed->len_y)-1)*ed->len_y,
 ed->window->b_open,
 ed->len_y,
 ed->window->bcolor);

// ed->y_start; // bleiben gleich bei einem redraw...
// ed->x_start;
 ed->x_ausgabe_start=0;
 ed->y_ausgabe_start=ed->window->h_open-ed->len_y;
 ed->x_ausgabe_end=ed->window->b_open;
 ed->y_ausgabe_end=ed->window->h_open;
 edit(ed->window,NULL,0);
 redraw_line_from_cursor(ed); // second step :-)
 T_DEBUG_LEAVE
}

T_VOID redraw_window_past_cursor(EDIT_ELEMENT *ed)
{ // similar to scroll up
 T_DEBUG_ENTRY("redraw_window_past_cursor",85)
 if ((ed->cpos_y-ed->y_first_char+2)*ed->len_y<ed->window->h_open)
 {
  lade_vga_nach_vga_teil_oc(
  ed->window->x+ed->window->x_0,
  ed->window->y+ed->window->y_0+(ed->cpos_y-ed->y_first_char+1)*ed->len_y,
  ed->window->b_open,
  ed->window->h_open-(ed->cpos_y-ed->y_first_char+2)*ed->len_y,
  ed->window->x+ed->window->x_0,
  ed->window->y+ed->window->y_0+(ed->cpos_y-ed->y_first_char+2)*ed->len_y);
 }
 if ((ed->cpos_y-ed->y_first_char+1)*ed->len_y<ed->window->h_open)
 {
  vesa_rect_fill_oc(
  ed->window->x+ed->window->x_0,
  ed->window->y+ed->window->y_0+(ed->cpos_y-ed->y_first_char+1)*ed->len_y,
  ed->window->b_open,
  ed->len_y,
  ed->window->bcolor);
 }
// ed->y_start; // bleiben gleich bei einem redraw...
// ed->x_start;
 if ((ed->cpos_y-ed->y_first_char+1)*ed->len_y<ed->window->h_open)
 {
  ed->x_ausgabe_start=0;
  ed->y_ausgabe_start=(ed->cpos_y-ed->y_first_char+1)*ed->len_y;
  ed->x_ausgabe_end=ed->window->b_open;
  ed->y_ausgabe_end=ed->y_ausgabe_start+ed->len_y;
  edit(ed->window,NULL,0);
 }
 T_DEBUG_LEAVE
}

KEY_FUNCTION *insert_edit_key_funktion( WINDOW_LISTEN_ELEMENT *window, T_INT key, T_INT mode, T_INT (*zeiger_auf_funktion)(T_VOID *) )
{
 KEY_FUNCTION *new_key;
 EDIT_ELEMENT *ed;
 T_DEBUG_ENTRY("insert_edit_key_funktion",85)
 ed=fetch_edit_element(window->id);
 if (ed==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nInsert edit function without edit object!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return NULL;
 }
 new_key=( KEY_FUNCTION *)malloc(sizeof(KEY_FUNCTION));
 if (new_key==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
 }
 new_key->key_funktion=zeiger_auf_funktion;
 new_key->key=key;
 new_key->mode=mode;
 d_fuege_in_liste_ein((T_PVOID )new_key,&(ed->key_functions_erste),&(ed->key_functions_letzte),DL_HINTEN);
 T_DEBUG_LEAVE
 return new_key;
}

/***************************************************************/

T_INT remove_edit_key_funktion(WINDOW_LISTEN_ELEMENT *window, T_INT (*zeiger_auf_funktion)(T_VOID *) )
{
 // siehe auch destructor
 KEY_FUNCTION *funktion;
 EDIT_ELEMENT *ed;
 T_LISTE *hilfe;
 T_DEBUG_ENTRY("remove_edit_key_funktion",85)
 ed=fetch_edit_element(window->id);
 if (ed==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nRemove edit function without edit object!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 hilfe=ed->key_functions_erste;
 while (hilfe!=NULL)
 {
  funktion=(KEY_FUNCTION *)hilfe->objekt;
  if (funktion->key_funktion==zeiger_auf_funktion)
  {
   d_entferne_aus_liste((T_PVOID )funktion,&(ed->key_functions_erste),&(ed->key_functions_letzte),DL_DONT_CLEAN_UP);
   free(funktion);
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_OK;
  }
  hilfe=hilfe->naechstes;
 }
 T_DEBUG_LEAVE
 return T_NOT_OK;
}

/***************************************************************/
T_INT edit_clean_mark(EDIT_ELEMENT *ed)
{
 T_DEBUG_ENTRY("edit_clean_mark",85)

 ed->x_ausgabe_start=0;
 ed->y_ausgabe_start=0;
 ed->x_ausgabe_end=ed->window->b_open;
 ed->y_ausgabe_end=ed->window->h_open;
 edit(ed->window,NULL,0);
 T_DEBUG_LEAVE
 return T_OK;

}
/***************************************************************/

T_VOID edit_key_function(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 EDIT_ELEMENT *ed=NULL;
 T_LISTE *liste;
 T_INT my_id;
 T_DEBUG_ENTRY("edit_key_function",85)
 if (parameter==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nUngueltiger Parameter in edit_key_function()!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 if (window==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nIch kann mich nicht finden edit_key_function()!");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return;
 }
 my_id=window->id;
 ed=fetch_edit_element(my_id);
 if (ed==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nKey function with EDIT without edit object!");
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return;
 }
 // OK, there is an active edit window available...
 liste=ed->key_functions_erste;
 while (liste)
 {
  KEY_FUNCTION *key_funktion=(KEY_FUNCTION *)liste->objekt;
  if ((key_funktion->key==parameter->taste)&&(key_funktion->mode==BEFORE_EDIT))
  {
   T_INT status=((T_INT (*)(T_VOID *))(key_funktion->key_funktion))((T_VOID *)ed);
   if ((get_window(my_id)!=window)||(fetch_edit_element(my_id)!=ed))
   {
    if ((status&EDIT_QUIT)!=EDIT_QUIT)
    {
     T_DEBUG_PROTOCOLL(("edit_key_function(), somehow I lost myself..."))
     if (e_verbose>E_VERBOSE_NONE)
      show_message("Something unexpected happened to edit window...");
    }
    T_DEBUG_PROTOCOLL(("edit_key_function(), caught an EDIT quit..."))
    parameter->executed=PARAMETER_EXECUTED;
    T_DEBUG_FUNCTION_POSITION(4)
    T_DEBUG_LEAVE
    return;
   }
   ed->changed=T_TRUE;
   if ((status&EDIT_CURSOR_TO_END)==EDIT_CURSOR_TO_END)
   {
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,EDIT_LINE_LEN+1,(ed->zeilen_anzahl-1)-ed->cpos_y); // to end of file
   }
   if ((status&EDIT_REDRAW_LINE)==EDIT_REDRAW_LINE)
   {
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
    redraw_line(ed);
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
   }
   if ((status&EDIT_DO_NOTHING)==EDIT_DO_NOTHING)
   {
    aktivate_window(window);
    parameter->executed=PARAMETER_EXECUTED;
    T_DEBUG_FUNCTION_POSITION(5)
    T_DEBUG_LEAVE
    return;
   }
   if ((status&EDIT_QUIT)==EDIT_QUIT)
   {
    parameter->executed=PARAMETER_EXECUTED;
    T_DEBUG_FUNCTION_POSITION(6)
    T_DEBUG_LEAVE
    return;
   }
   aktivate_window(window);
   break;
  }
  liste=liste->naechstes;
 }
 MOUSE_VERSTECKE
 switch (parameter->taste)
 {
  case KEY_DOWN:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,1);
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_UP:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,-1);
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_LEFT:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,-1,0);
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_SHIFT_LEFT:
  {
   if (ed->is_marking==T_FALSE)
   {
    ed->is_marking=T_TRUE;
    ed->m_startx=ed->cpos_x;
    ed->m_starty=ed->cpos_y;
    ed->m_endx=ed->cpos_x;
    ed->m_endy=ed->cpos_y;
   }
   if ((ed->cpos_x==ed->m_startx)&&(ed->cpos_y==ed->m_starty))
   {
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,-1,0);
    ed->m_startx=ed->cpos_x;
    ed->m_starty=ed->cpos_y;
   }
   else
   {
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,-1,0);
    ed->m_endx=ed->cpos_x;
    ed->m_endy=ed->cpos_y;
   }
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_RIGHT:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,1,0);
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_SHIFT_RIGHT:
  {
   if (ed->is_marking==T_FALSE)
   {
    ed->is_marking=T_TRUE;
    ed->m_startx=ed->cpos_x;
    ed->m_starty=ed->cpos_y;
    ed->m_endx=ed->cpos_x;
    ed->m_endy=ed->cpos_y;
   }
   if ((ed->cpos_x==ed->m_endx)&&(ed->cpos_y==ed->m_endy))
   {
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,1,0);
    ed->m_endx=ed->cpos_x;
    ed->m_endy=ed->cpos_y;
   }
   else
   {
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,1,0);
    ed->m_startx=ed->cpos_x;
    ed->m_starty=ed->cpos_y;
   }
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_END:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,EDIT_LINE_LEN+1,0); // automatically cut to max len... :-)
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_HOME:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,-ed->cpos_x,0); // down to zero...
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_CTRL_RIGHT:
  {
   T_SINT c=0;
   T_CHAR ls=ed->cursor_line->text[ed->cpos_x+c];
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   if (ed->cpos_x<EDIT_LINE_LEN) c++; // start with next sign
   while (((ed->cpos_x+c<EDIT_LINE_LEN)
          &&(ed->cursor_line->text[ed->cpos_x+c]!=' ')
          &&(ed->cursor_line->text[ed->cpos_x+c]!=',')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='.')
          &&(ed->cursor_line->text[ed->cpos_x+c]!=':')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='\'')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='\"')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='#')
          &&(ed->cursor_line->text[ed->cpos_x+c]!=(T_CHAR)0)
          )||(ls==ed->cursor_line->text[ed->cpos_x+c]))
   {
    ls=ed->cursor_line->text[ed->cpos_x+c];
    c+=1;
   }
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,c,0);
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_CTRL_LEFT:
  {
   T_SINT c=0;
   T_CHAR ls=ed->cursor_line->text[ed->cpos_x+c];
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   if (ed->cpos_x>0) c--; // start with next sign
   while (((ed->cpos_x+c>=1)
          &&(ed->cursor_line->text[ed->cpos_x+c]!=' ')
          &&(ed->cursor_line->text[ed->cpos_x+c]!=',')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='.')
          &&(ed->cursor_line->text[ed->cpos_x+c]!=':')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='\'')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='\"')
          &&(ed->cursor_line->text[ed->cpos_x+c]!='#')
          )||(ls==ed->cursor_line->text[ed->cpos_x+c]))
   {
    ls=ed->cursor_line->text[ed->cpos_x+c];
    c-=1;
   }
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,c,0);
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_CTRL_HOME:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,-ed->cpos_x,-ed->cpos_y); // down to zero...
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_CTRL_END:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,EDIT_LINE_LEN+1,(ed->zeilen_anzahl-1)-ed->cpos_y); // to end of file
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_PGUP:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,-(ed->window->h_open/ed->font->zeichen[(T_BYTE)' '].hoehe)); // down one (window) page
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_PGDN:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,ed->window->h_open/ed->font->zeichen[(T_BYTE)' '].hoehe); // down one (window) page
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_INS:
  {
   if (ed->mode==EDIT_MODE_INSERT)
   {
    ed->mode=EDIT_MODE_OVERWRITE;
   }
   else
   {
    ed->mode=EDIT_MODE_INSERT;
   }
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_DEL:
  {
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   parameter->executed=PARAMETER_EXECUTED;
   if (ed->cursor_line->text[ed->cpos_x]!=(T_CHAR)0)
   { // delete one character
    T_INT lc=ed->cpos_x;
    do
    {
     lc++;
     ed->cursor_line->text[lc-1]=ed->cursor_line->text[lc];
    }
    while ((ed->cursor_line->text[lc]!=(T_CHAR)0)&&(lc<EDIT_LINE_LEN));
    // delete last character of string on screen :-) (only NON PROPORTIONAL!!!)
    strcat(ed->cursor_line->text," ");
    redraw_line_from_cursor(ed);
    // correct string...
    ed->cursor_line->text[ed->cursor_line->len_chars-1]=(T_CHAR)0;
    ed->cursor_line->len_pixel-=ed->len_x;
    ed->cursor_line->len_chars--;
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
   } // if (ed->cursor_line->text[ed->cpos_x]!=(T_CHAR)0)
   else
   { // possibly concatinate two lines
    if (ed->cpos_y+1!=ed->zeilen_anzahl)
    {
     // not last line -> concatinate
     T_LISTE *zeilen_liste;
     EDIT_ZEILE *next_line;
     zeilen_liste=d_get_list_pos(ed->cursor_line, ed->text_zeile_erste);
     zeilen_liste=zeilen_liste->naechstes;
     next_line=(EDIT_ZEILE *)zeilen_liste->objekt;
     strncat(ed->cursor_line->text,next_line->text,EDIT_LINE_LEN-1-ed->cursor_line->len_chars);
     ed->cursor_line->len_pixel+=next_line->len_pixel;
     ed->cursor_line->len_chars+=next_line->len_chars;
     d_entferne_aus_liste(next_line,&(ed->text_zeile_erste), &(ed->text_zeile_letzte),DL_DONT_CLEAN_UP);
     free(next_line->text);
     free(next_line);
     ed->zeilen_anzahl--;
     redraw_window_from_cursor(ed);
     set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
    }
    else
    {
     // last line, do nothing
    }
   } // else if (ed->cursor_line->text[ed->cpos_x]!=(T_CHAR)0)
   ed->changed=T_TRUE;
   break;
  }
  case KEY_BSPACE:
  {
   // actually the same as DEL, only some cursor positioning :-)
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   parameter->executed=PARAMETER_EXECUTED;
   if (ed->cpos_x!=0)
   { // delete one character
    T_INT lc;
    if (ed->cursor_line->text[ed->cpos_x]==(T_CHAR)0)
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0); // neccessary if on last position in line
                                                    // since DEL doesn't delete nothing :-)
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,-1,0);
    lc=ed->cpos_x;
    do
    {
     lc++;
     ed->cursor_line->text[lc-1]=ed->cursor_line->text[lc];
    }
    while ((ed->cursor_line->text[lc]!=(T_CHAR)0)&&(lc<EDIT_LINE_LEN));
    // delete last character of string on screen :-) (only NON PROPORTIONAL!!!)
    strcat(ed->cursor_line->text," ");
    redraw_line_from_cursor(ed);
    // correct string...
    ed->cursor_line->text[ed->cursor_line->len_chars-1]=(T_CHAR)0;
    ed->cursor_line->len_pixel-=ed->len_x;
    ed->cursor_line->len_chars--;
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
   } // if (ed->cursor_line->text[ed->cpos_x]!=(T_CHAR)0)
   else
   { // possibly concatinate two lines
    if (ed->cpos_y>0)
    {
     // not first line -> concatinate
     T_LISTE *zeilen_liste;
     EDIT_ZEILE *next_line;
     set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,-1);
     set_edit_cursor(ed,EDIT_CURSOR_INVERS,EDIT_LINE_LEN+1,0); // automatically cut to max len... :-)
     zeilen_liste=d_get_list_pos(ed->cursor_line, ed->text_zeile_erste);
     zeilen_liste=zeilen_liste->naechstes;
     next_line=(EDIT_ZEILE *)zeilen_liste->objekt;
     strncat(ed->cursor_line->text,next_line->text,EDIT_LINE_LEN-1-ed->cursor_line->len_chars);
     ed->cursor_line->len_pixel+=next_line->len_pixel;
     ed->cursor_line->len_chars+=next_line->len_chars;
     d_entferne_aus_liste(next_line,&(ed->text_zeile_erste), &(ed->text_zeile_letzte),DL_DONT_CLEAN_UP);
     free(next_line->text);
     free(next_line);
     ed->zeilen_anzahl--;
     redraw_window_from_cursor(ed);
     set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
    }
    else
    {
     // first line, do nothing
    }
   } // else if (ed->cursor_line->text[ed->cpos_x]!=(T_CHAR)0)
   ed->changed=T_TRUE;
   break;
  }
  case KEY_ENTER:
  {
   EDIT_ZEILE *zeile;
   T_INT ec=ed->cpos_x;
   if (ed->is_marking==T_TRUE)
   {
    edit_clean_mark(ed);
    ed->is_marking=T_FALSE;
   }
   set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
   zeile=(EDIT_ZEILE *)malloc(sizeof(EDIT_ZEILE));
   if (zeile==NULL)
   {
    MOUSE_ZEIGE
    T_DEBUG_FUNCTION_POSITION(7)
    T_DEBUG_LEAVE
    tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
   }
   zeile->mark_start=0;
   zeile->mark_end=0;
   zeile->text=(T_PCHAR)malloc(EDIT_LINE_LEN+1);// plus one for safty and SPACE
   zeile->len_of_mem=EDIT_LINE_LEN;
   if (zeile->text==NULL)
   {
    MOUSE_ZEIGE
    T_DEBUG_FUNCTION_POSITION(8)
    T_DEBUG_LEAVE
    tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
   }
   memset(zeile->text,0,zeile->len_of_mem);
   if (ed->cursor_line->text[ed->cpos_x]!=(T_CHAR)0)
    strcat(zeile->text,ed->cursor_line->text+ed->cpos_x);
   if ((zeile->len_chars=strlen(zeile->text))>0)
    vesa_get_text_len(zeile->text,&zeile->len_pixel,&zeile->hight_pixel);
   else
   {
    zeile->len_pixel=0;
    zeile->hight_pixel=ed->len_y;
   }
   while (ed->cursor_line->text[ec]!=(T_CHAR)0)
   {
    ed->cursor_line->text[ec]=(T_CHAR)' ';
    ec++;
   }
   redraw_line(ed); // line correctly redrawn,... now cut it down...
   memset(ed->cursor_line->text+ed->cpos_x,0,ed->cursor_line->len_chars-ed->cpos_x);
   ed->cursor_line->len_chars=strlen(ed->cursor_line->text);
   if (ed->cursor_line->len_chars!=0)
    vesa_get_text_len(ed->cursor_line->text,&ed->cursor_line->len_pixel,&ed->cursor_line->hight_pixel);

   d_fuege_in_liste_ein_past_position( zeile,ed->cursor_line, &(ed->text_zeile_erste), &(ed->text_zeile_letzte));
   ed->zeilen_anzahl++;
   redraw_window_past_cursor(ed);
   set_edit_cursor(ed,EDIT_CURSOR_INVERS,-ed->cpos_x,1); // down to zero...
   parameter->executed=PARAMETER_EXECUTED;
   ed->changed=T_TRUE;
   break;
  }
  default:
  {
   T_INT taste=parameter->taste;
   if (((taste>=32)&&(taste<=126))||
   (taste=='')||
   (taste=='')||
   (taste=='')||
   (taste=='')||
   (taste=='')||
   (taste=='')||
   (taste=='')
   )
   {
    if (ed->is_marking==T_TRUE)
    {
      edit_clean_mark(ed);
     ed->is_marking=T_FALSE;
    }
    // characters...
    parameter->executed=PARAMETER_EXECUTED;
    if ((ed->mode==EDIT_MODE_INSERT)||(ed->cursor_line->text[ed->cpos_x]==(T_CHAR)0))
    { // insert mode or end of line
     if (ed->cursor_line->len_chars+1<EDIT_LINE_LEN)
     { // new character fits in line
      T_INT lc=ed->cursor_line->len_chars+1;
      while (lc!=ed->cpos_x)
      {
       ed->cursor_line->text[lc]=ed->cursor_line->text[lc-1];
       lc--;
      }
      ed->cursor_line->text[lc]=taste;
      ed->cursor_line->len_pixel+=ed->len_x;
      ed->cursor_line->len_chars++;
      redraw_line_from_cursor(ed);
      set_edit_cursor(ed,EDIT_CURSOR_INVERS,1,0);
     }
    } // if (ed->mode==EDIT_MODE_INSERT)
    else
    {
     ed->cursor_line->text[ed->cpos_x]=taste;
     set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0); // neccassary if on last position in line
     set_edit_cursor(ed,EDIT_CURSOR_INVERS,1,0); // neccassary if on last position in line
    } // else if (ed->mode==EDIT_MODE_INSERT)
    ed->changed=T_TRUE;
   }
   break;
  }
 }
 MOUSE_ZEIGE
 liste=ed->key_functions_erste;
 while (liste)
 {
  KEY_FUNCTION *key_funktion=(KEY_FUNCTION *)liste->objekt;
  if ((key_funktion->key==parameter->taste)&&(key_funktion->mode==AFTER_EDIT))
  {
   T_INT status=((T_INT (*)(T_VOID *))(key_funktion->key_funktion))((T_VOID *)ed);
   if ((get_window(my_id)!=window)||(fetch_edit_element(my_id)!=ed))
   {
    if ((status&EDIT_QUIT)!=EDIT_QUIT)
    {
     T_DEBUG_PROTOCOLL(("edit_key_function(), somehow I lost myself..."))
     if (e_verbose>E_VERBOSE_NONE)
      show_message("Something unexpected happened to edit window...");
    }
    T_DEBUG_PROTOCOLL(("edit_key_function(), caught an EDIT quit..."))
    parameter->executed=PARAMETER_EXECUTED;
    T_DEBUG_FUNCTION_POSITION(9)
    T_DEBUG_LEAVE
    return;
   }
   ed->changed=T_TRUE;
   if ((status&EDIT_CURSOR_TO_END)==EDIT_CURSOR_TO_END)
   {
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,EDIT_LINE_LEN+1,(ed->zeilen_anzahl-1)-ed->cpos_y); // to end of file
   }
   if ((status&EDIT_REDRAW_LINE)==EDIT_REDRAW_LINE)
   {
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
    redraw_line(ed);
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,0,0);
   }
   if ((status&EDIT_DO_NOTHING)==EDIT_DO_NOTHING)
   {
    aktivate_window(window);
    parameter->executed=PARAMETER_EXECUTED;
    T_DEBUG_FUNCTION_POSITION(10)
    T_DEBUG_LEAVE
    return;
   }
   if ((status&EDIT_QUIT)==EDIT_QUIT)
   {
    parameter->executed=PARAMETER_EXECUTED;
    T_DEBUG_FUNCTION_POSITION(11)
    T_DEBUG_LEAVE
    return;
   }
   aktivate_window(window);
   break;
  }
  liste=liste->naechstes;
 }
 T_DEBUG_LEAVE
}

EDIT_ZEILE *get_zeile(T_LISTE *liste, T_INT line_no)
{
 T_INT i=0;
 T_DEBUG_ENTRY("get_zeile",85)
 while (liste)
 {
  if (i==line_no)
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return (EDIT_ZEILE *)(liste->objekt);
  }
  i++;
  liste=liste->naechstes;
 }
 T_DEBUG_LEAVE
 return NULL;
}
T_VOID edit_area_function(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 EDIT_ELEMENT *ed=NULL;
 T_DEBUG_ENTRY("edit_area_function",85)
 if (parameter==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nUngueltiger Parameter in edit_area_function()!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 if (window==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nIch kann mich nicht finden edit_area_function()!");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return;
 }
 ed=fetch_edit_element(window->id);
 if (ed==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nArea function with EDIT without edit object!");
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return;
 }
 if (parameter->maus_button==1)
 {
  /* set cursor to this position */
  T_INT maus_x=parameter->maus_x-(window->x+window->x_0);
  T_INT maus_y=parameter->maus_y-(window->y+window->y_0);
  T_INT line_no, spalte_no;
  EDIT_ZEILE *zeile=NULL;
  aktivate_window(window);
  if ((maus_x>=0)&&(maus_y>=0))
  {
   line_no=(maus_y+(ed->len_y-1))/ed->len_y+ed->y_first_char-1;
   spalte_no=(maus_x+(ed->len_x-1))/ed->len_x+ed->x_first_char-1;
   if (line_no>=ed->zeilen_anzahl)
    line_no=ed->zeilen_anzahl-1;
   zeile=get_zeile(ed->text_zeile_erste, line_no);
   if (zeile==NULL)
   {
    T_DEBUG_FUNCTION_POSITION(4)
    T_DEBUG_LEAVE
    return;
   }
   if (zeile->len_chars<=spalte_no)
    spalte_no=zeile->len_chars;
   if ((spalte_no-ed->cpos_x!=0)||(line_no-ed->cpos_y!=0))
   {
    MOUSE_VERSTECKE
    set_edit_cursor(ed,EDIT_CURSOR_NOT_INVERS,0,0);
    set_edit_cursor(ed,EDIT_CURSOR_INVERS,spalte_no-ed->cpos_x,line_no-ed->cpos_y);
    MOUSE_ZEIGE
   }
  }
 }
 if (parameter->maus_button==2)
 {
  /* set cursor to this position */
  T_INT maus_x=parameter->maus_x-(window->x+window->x_0);
  T_INT maus_y=parameter->maus_y-(window->y+window->y_0);
  T_INT line_no, spalte_no;
  T_CHAR word[EDIT_LINE_LEN+1];
  T_INT len=0;
  EDIT_ZEILE *zeile=NULL;
  word[0]=(T_CHAR)0;
  if ((maus_x>=0)&&(maus_y>=0))
  {
   line_no=(maus_y+(ed->len_y-1))/ed->len_y+ed->y_first_char-1;
   spalte_no=(maus_x+(ed->len_x-1))/ed->len_x+ed->x_first_char-1;
   if (line_no>=ed->zeilen_anzahl)
    line_no=ed->zeilen_anzahl-1;
   zeile=get_zeile(ed->text_zeile_erste, line_no);
   if (zeile==NULL)
   {
    T_DEBUG_FUNCTION_POSITION(4)
    T_DEBUG_LEAVE
    return;
   }
   if (zeile->len_chars<=spalte_no)
    spalte_no=zeile->len_chars;
   if ( (((zeile->text[spalte_no]>='A')&&(zeile->text[spalte_no]<='Z'))||
         ((zeile->text[spalte_no]>='a')&&(zeile->text[spalte_no]<='z'))||
         ((zeile->text[spalte_no]>='0')&&(zeile->text[spalte_no]<='9'))||(zeile->text[spalte_no]=='$')||(zeile->text[spalte_no]=='_'))
      )
   {
    while ( (spalte_no>0)&&
            ((((zeile->text[spalte_no]>='A')&&(zeile->text[spalte_no]<='Z'))||
              ((zeile->text[spalte_no]>='a')&&(zeile->text[spalte_no]<='z'))||
              ((zeile->text[spalte_no]>='0')&&(zeile->text[spalte_no]<='9'))||(zeile->text[spalte_no]=='$')||
               (zeile->text[spalte_no]=='_'))))
    {
     spalte_no--;
    }
    if (spalte_no>0)
     spalte_no++;
    while ( (((zeile->text[spalte_no]>='A')&&(zeile->text[spalte_no]<='Z'))||
             ((zeile->text[spalte_no]>='a')&&(zeile->text[spalte_no]<='z'))||
             ((zeile->text[spalte_no]>='0')&&(zeile->text[spalte_no]<='9'))||(zeile->text[spalte_no]=='$')||
              (zeile->text[spalte_no]=='_')))
    {
     len++;
     spalte_no++;
    }
    if (len>0)
    {
     T_INT radix=0;
     T_INT status;
     strncpy(word,zeile->text+spalte_no-len,len);
     word[len]=(T_CHAR)0;
     if (word[0]=='$')
      status=word_help(word+1,ed->help_word_erste);
     else
      status=word_help(word,ed->help_word_erste);
     if (status!=T_OK)
     {
      if (is_bin(word)==T_TRUE)
      {
       radix=2;
      }
      else if (is_dec(word)==T_TRUE)
      {
       radix=10;
      }
      else if (is_hex(word)==T_TRUE)
      {
       radix=16;
      }
     }
     if (radix)
     {
      number_help(word,radix);
     }
    }
   }
  }
 }
 T_DEBUG_LEAVE
}

static PARSER_STRUKT help_key_struct[]={
  {PARSER_TYPE_STRING, 2,NULL},
  {PARSER_STRUKT_END, 0,NULL}
};
static PARSER_LIST phelp_list_struct = {
  PARSER_TYPE_STRUKT, help_key_struct, NULL, NULL,
};
static PARSER_WORD parse_hilfe[]=
{
 {PARSER_TYPE_LIST  ,"HELP_KEY"        ,&phelp_list_struct, 0},
 {PARSER_TYPE_END,NULL,NULL,0}
};

T_INT edit_set_help_table(WINDOW_LISTEN_ELEMENT *window, T_PCHAR filename)
{
 EDIT_ELEMENT *ed=NULL;
 T_PCHAR current_path=NULL;
 T_INT error;
 T_DEBUG_ENTRY("edit_set_help_table",85)
 if (window==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_set_help_table(), window==NULL"))
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if (filename==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_set_help_table(), filename==NULL"))
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 ed=fetch_edit_element(window->id);
 if (ed==NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_set_help_table(), ed==NULL"))
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if (ed->help_word_erste!=NULL)
 {
  T_DEBUG_PROTOCOLL(("edit_set_help_table(), help allready set!"))
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 current_path=get_current_path();
 if (t_hilfe_pfad!=NULL)
  change_directory(t_hilfe_pfad);
 p_parse_init();
 error=p_parse(filename,parse_hilfe);
 if (current_path!=NULL)
 {
  change_directory(current_path);
  free(current_path);
 }
 if (error!=T_OK)
 {
  t_printf(E_VERBOSE_STANDARD,"\nedit_set_help_table(), parse error (filename:%s)",filename);
  T_DEBUG_PROTOCOLL(("edit_set_help_table(), parse error (filename:%s)",filename))
  T_DEBUG_FUNCTION_POSITION(5)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 else
 {
  PARSER_LIST *field = (PARSER_LIST *)parse_hilfe[0].value;
//  PARSER_STRUKT *sfield = ( PARSER_STRUKT * ) field->strukt_info;
  T_PVOID help_strukt;
  HELP_WORD *help;
  while (field->list_head!=NULL)
  {
   help_strukt=field->list_head->objekt;
   if (help_strukt==NULL)
   {
    t_printf(E_VERBOSE_STANDARD,"\nedit_set_help_table(), help_struct==NULL???");
    T_DEBUG_PROTOCOLL(("edit_set_help_table(), help_struct==NULL??? (filename:%s)",filename))
    T_DEBUG_FUNCTION_POSITION(6)
    T_DEBUG_LEAVE
    tool_exit(0);
    return T_NOT_OK;
   }
   help=(HELP_WORD*) malloc(sizeof(HELP_WORD));
   if (help==NULL)
   {
    t_printf(E_VERBOSE_STANDARD,"\nedit_set_help_table(), help==NULL (not allocated)");
    T_DEBUG_PROTOCOLL(("edit_set_help_table(), help==NULL (filename:%s)",filename))
    T_DEBUG_FUNCTION_POSITION(7)
    T_DEBUG_LEAVE
    tool_exit(0);
    return T_NOT_OK;
   }
   help->keyword=(T_PCHAR) *( (T_PCHAR *) (T_PVOID) ( ( ( T_PCHAR ) help_strukt ) + 0 )    );
   help->help_name=(T_PCHAR) *( (T_PCHAR *) (T_PVOID) ( ( ( T_PCHAR ) help_strukt ) + sizeof(T_PCHAR) )    );
   d_entferne_aus_liste( help_strukt, &(field->list_head), &(field->list_tail),DL_DONT_CLEAN_UP);
   d_fuege_in_liste_ein( help, &(ed->help_word_erste), &(ed->help_word_letzte), DL_HINTEN );
  } //while (help!=NULL)
 } // else if (p_parse(filename,parse_hilfe)!=T_OK)

 T_DEBUG_LEAVE
 return T_OK;
}
