// x,y center auf x,y max umschreiben
// x,y center auf x,y max umschreiben
// MOUSE_VERSTECKE

// links gehen mit pixel genauer zeilennummer, siehe help.h for some info


#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <standard.h>
#include <file.h>
#include <tools.h>
#include <parser.h>
#include <button.h>
#include <help.h>

#ifdef VECTREX
#include "..\vectrex\source\dis6809.h"
extern tsMNEMONIC as6809Dis[];
#endif


T_INT fast_scroll=T_FALSE;

#define WX(ppos_x) (ppos_x-x_start+text_window->x+text_window->x_0)
#define WY(ppos_y) (ppos_y-y_start+text_window->y+text_window->y_0)

T_LISTE *help_button_liste_first=NULL;
T_LISTE *help_button_liste_last=NULL;
T_FONT help_font;
T_INT (*help_user_function)(T_PCHAR text)=NULL;
T_VOID help_key_function(PARAMETER *parameter);


static T_INT help_offset=0;
static T_INT no_process_window=T_FALSE;
static T_INT pforce_no_scroll=0;
static T_INT pforce_scroll=0;
static T_INT pw1_color__[4]; // to prevent allocation using m_file
static T_INT pw2_color__[4];
static T_INT pb1_color__[4];
static T_INT pb2_color__[4];
static T_INT pb3_color__[4];
static T_INT pb4_color__[4];
static T_INT pb5_color__[4];
static T_INT pb6_color__[4];
static T_INT pwb_color__[4];
static T_INT pw_color__[4];
static T_INT pb_color__[4];
static T_INT pt_color__[4];
static T_INT pindex_nummer=0;
static T_INT pwin_size_x=400;
static T_INT pwin_size_y=400;
static T_INT pwin_pos_x=0;
static T_INT pwin_pos_y=0;
static T_INT pwin_with_name=T_TRUE;
static T_INT ppos_x=0;
static T_INT ppos_y=0;
static T_PCHAR ptext=NULL;
static T_PCHAR ppic=NULL;
static T_PCHAR pfont=NULL;
static T_INT pcenter_x=T_FALSE;
static T_INT pcenter_y=T_FALSE;
static T_INT pleft_format=0;
static T_INT pright_format=0;
static T_INT pleft=T_FALSE;
static T_INT pright=T_FALSE;
static T_INT pbottom=T_FALSE;

static T_INT pbutton_id=0;
static T_INT pbutton_art=0;
static T_PCHAR pbutton_intern_text;
static T_PCHAR pbutton_extern_text;
static T_PCHAR pwin_name=NULL;

static T_PINT pw1_color=NULL;
static T_PINT pw2_color=NULL;
static T_PINT pb1_color=NULL;
static T_PINT pb2_color=NULL;
static T_PINT pb3_color=NULL;
static T_PINT pb4_color=NULL;
static T_PINT pb5_color=NULL;
static T_PINT pb6_color=NULL;
static T_PINT pwb_color=NULL;
static T_PINT pw_color=NULL;
static T_PINT pb_color=NULL;
static T_PINT pt_color=NULL;
static T_INT pwin_shade_col1;
static T_INT pwin_shade_col2;
static T_INT pwin_shade_width;

static T_INT ptext_color;
static T_INT pback_color;
static T_INT pwin_back_color;
static T_INT pwin_color;

static T_INT pbutton_color1;
static T_INT pbutton_color2;
static T_INT pbutton_color3;
static T_INT pbutton_color4;
static T_INT pbutton_color5;
static T_INT pbutton_color6;
static T_INT pprint_mode;
static T_INT ptext_mode;
static T_INT padd_x;
static T_INT padd_y;
static T_INT psub_x;
static T_INT psub_y;
static T_INT pwin_center;
static T_INT ppop_up;
static T_INT pallow_color_setting;
static PARSER_STRUKT pbutton[]=
{
 {PARSER_TYPE_SINT, 1,&pbutton_id},   // id
 {PARSER_TYPE_SINT, 1,&pbutton_art},   // other information
 {PARSER_TYPE_STRING, 1,&pbutton_extern_text}, // string to display
 {PARSER_TYPE_STRING, 1,&pbutton_intern_text}, // string to intern
 {PARSER_STRUKT_END, 0, NULL}
};

static PARSER_WORD parse_hilfe[]=
{
 {PARSER_TYPE_SINT,   "WIN_SIZE_X",&pwin_size_x,H_WIN_SIZE_X},
 {PARSER_TYPE_SINT,   "WIN_SIZE_Y",&pwin_size_y,H_WIN_SIZE_Y},
 {PARSER_TYPE_SINT,   "WIN_POS_X",&pwin_pos_x,H_WIN_POS_X},
 {PARSER_TYPE_SINT,   "WIN_POS_Y",&pwin_pos_y,H_WIN_POS_Y},
 {PARSER_TYPE_LINE_ARRAY_INT, "WIN_BACK_COLOR",&pwb_color,H_WIN_BACK_COLOR},
 {PARSER_TYPE_LINE_ARRAY_INT, "WIN_COLOR",&pw_color,H_WIN_COLOR},
 {PARSER_TYPE_SINT,   "CENTER_X",&pcenter_x,H_CENTER_X},
 {PARSER_TYPE_SINT,   "CENTER_Y",&pcenter_y,H_CENTER_Y},
 {PARSER_TYPE_SINT,   "RIGHT",&pright,H_RIGHT},
 {PARSER_TYPE_SINT,   "LEFT",&pleft,H_LEFT},
 {PARSER_TYPE_SINT,   "BOTTOM",&pbottom,H_BOTTOM},
 {PARSER_TYPE_SINT,   "POS_X",&ppos_x,H_POS_X},
 {PARSER_TYPE_SINT,   "POS_Y",&ppos_y,H_POS_Y},
 {PARSER_TYPE_LINE_ARRAY_INT, "BACK_COLOR",&pb_color,H_BACK_COLOR},
 {PARSER_TYPE_LINE_ARRAY_INT, "TEXT_COLOR",&pt_color,H_TEXT_COLOR},
 {PARSER_TYPE_VOID,   "DRAW_NOW",NULL,H_DRAW_NOW},
 {PARSER_TYPE_STRING, "TEXT",&ptext,H_TEXT},
 {PARSER_TYPE_STRING, "FORMAT_TEXT",&ptext,H_FORMAT_TEXT},
 {PARSER_TYPE_STRUKT, "BUTTON",&pbutton,H_BUTTON},
 {PARSER_TYPE_LINE_ARRAY_INT, "BUTTON_COLOR_1",&pb1_color,H_BUTTON_COLOR_1},
 {PARSER_TYPE_LINE_ARRAY_INT, "BUTTON_COLOR_2",&pb2_color,H_BUTTON_COLOR_2},
 {PARSER_TYPE_LINE_ARRAY_INT, "BUTTON_COLOR_3",&pb3_color,H_BUTTON_COLOR_3},
 {PARSER_TYPE_LINE_ARRAY_INT, "BUTTON_COLOR_4",&pb4_color,H_BUTTON_COLOR_4},
 {PARSER_TYPE_LINE_ARRAY_INT, "BUTTON_COLOR_5",&pb5_color,H_BUTTON_COLOR_5},
 {PARSER_TYPE_LINE_ARRAY_INT, "BUTTON_COLOR_6",&pb6_color,H_BUTTON_COLOR_6},
 {PARSER_TYPE_SINT,   "PRINT_MODE",&pprint_mode,H_PRINT_MODE},
 {PARSER_TYPE_SINT,   "TEXT_MODE",&ptext_mode,H_TEXT_MODE},
 {PARSER_TYPE_SINT,   "WIN_SHADE_WIDTH",&pwin_shade_width,H_WIN_SHADE_WIDTH},
 {PARSER_TYPE_LINE_ARRAY_INT, "WIN_SHADE_COL1",&pw1_color,H_WIN_SHADE_COL1},
 {PARSER_TYPE_LINE_ARRAY_INT, "WIN_SHADE_COL2",&pw2_color,H_WIN_SHADE_COL2},
 {PARSER_TYPE_SINT,   "ADD_X",&padd_x,H_ADD_X},
 {PARSER_TYPE_SINT,   "ADD_Y",&padd_y,H_ADD_Y},
 {PARSER_TYPE_SINT,   "SUB_X",&psub_x,H_SUB_X},
 {PARSER_TYPE_SINT,   "SUB_Y",&psub_y,H_SUB_Y},
 {PARSER_TYPE_VOID,   "RETURN",NULL,H_RETURN},
 {PARSER_TYPE_SINT,   "WIN_CENTER_ON_MOUSE",&pwin_center,H_WIN_CENTER_ON_MOUSE},
 {PARSER_TYPE_SINT,   "WIN_POP_UP",&ppop_up,H_WIN_POP_UP},
 {PARSER_TYPE_STRING, "PICTURE",&ppic,H_PICTURE},
 {PARSER_TYPE_STRING, "SET_FONT",&pfont,H_SET_FONT},
 {PARSER_TYPE_SINT,   "LEFT_FORMAT",&pleft_format,H_LEFT_FORMAT},
 {PARSER_TYPE_SINT,   "RIGHT_FORMAT",&pright_format,H_RIGHT_FORMAT},
 {PARSER_TYPE_STRING, "WIN_NAME",&pwin_name,H_WIN_NAME},
 {PARSER_TYPE_STRING, "WIN_WITH_NAME",&pwin_with_name,H_WIN_WITH_NAME},
 {PARSER_TYPE_SINT,   "ALLOW_COLOR_SETTING",&pallow_color_setting,H_ALLOW_COLOR_SETTING},
 {PARSER_TYPE_SINT,   "FORCE_NO_SCROLL",&pforce_no_scroll,H_FORCE_NO_SCROLL},
 {PARSER_TYPE_SINT,   "FORCE_SCROLL",&pforce_scroll,H_FORCE_SCROLL},
 {PARSER_TYPE_END,NULL,NULL}
};

T_INT execute_close_help_button(PARAMETER *parameter)
{
 T_LISTE *help=NULL;
 T_INT id=-1;
 T_INT mfile_found=T_FALSE;
 T_DEBUG_ENTRY("execute_close_help_button",75)
 if (fKBDisALT()==T_TRUE)
 {
  help_function("close_w.hlf",NULL);
 }
 else
 {
  if (parameter->window_element!=NULL)
  {
   id=((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->id;
   ((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->parameter=parameter;
   ((WINDOW_LISTEN_ELEMENT *)parameter->window_element)->destructor=NULL;
   close_window((WINDOW_LISTEN_ELEMENT *)parameter->window_element,CLOSE_DEFAULT);
   help=help_button_liste_first;
   while (help)
   {
    HELP_BUTTON *help_button=(HELP_BUTTON *)help->objekt;
    if (help_button->window_id==id)
    {
     help=help->naechstes;
     d_entferne_aus_liste( help_button, &help_button_liste_first, &help_button_liste_last,DL_CLEAN_UP );
     if (help_button->m_file!=NULL)
     {
      if (mfile_found==T_FALSE)
      {
       mfile_found=T_TRUE;
       free(help_button->m_file->mem);
       free(help_button->m_file);
      }
      free(help_button->filename);
     }
     free(help_button);
    }
    else
    {
     help=help->naechstes;
    }
   }
  }
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

T_INT execute_help_button(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("execute_help_button",75)
 if (parameter->window_element!=NULL)
 {
  HELP_BUTTON *help_button=NULL;
  BUTTON *this_button=((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button;
  T_LISTE *help=help_button_liste_first;
  if ((((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->hide>0)||(((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->dhide>0))
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
/// CHRIS  ((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->parameter=parameter;
  while (help)
  {
   help_button=(HELP_BUTTON *)help->objekt;
   if (help_button->button==this_button)
   {
    break;
   }
   else
    help_button=NULL;
   help=help->naechstes;
  }
  if (help_button==NULL)
  {
   T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CANT_FIND_MYSELF)
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  /* OK, from here on execute the button, now we know what to do! */
  if ((help_button->button_art&HELP_BUTTON_CLOSE)==HELP_BUTTON_CLOSE)
  {
   parameter->executed=PARAMETER_EXECUTED;
   execute_close_help_button(parameter);
  }
  if (((help_button->button_art&HELP_BUTTON_DOWN)==HELP_BUTTON_DOWN)&&((parameter->maus_button==1)||(parameter->taste!=0)))
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("scrolld.hlf",NULL);
    while (vesa_mouse_button)
     vesa_mouse_update();
   }
   else
   {
    T_INT lines_to_scroll=help_button->y_scroll*line_scroll_width;
    aktivate_window(help_button->window);
    if ( *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)) < help_button->y_max/*-help_button->window->h_open*/)
    {
     is_upper=T_TRUE;
     MOUSE_VERSTECKE
     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,PRESSED);
     do
     {
      lade_vga_nach_vga_teil_oc(
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0+lines_to_scroll,
      help_button->window->b_open,
      help_button->window->h_open-lines_to_scroll,
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0);

      vesa_rect_fill_oc(
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0+help_button->window->h_open-lines_to_scroll,
      help_button->window->b_open,
      lines_to_scroll,
      help_button->window->bcolor);
//     *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))=0;
      *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))+=lines_to_scroll;
      *(T_INT *)(help_button->m_file->mem+2*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)));
      *(T_INT *)(help_button->m_file->mem+3*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)))+help_button->window->h_open-lines_to_scroll/*-help_button->y_scroll*/;
      *(T_INT *)(help_button->m_file->mem+4*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)))+help_button->window->b_open;
      *(T_INT *)(help_button->m_file->mem+5*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)))+help_button->window->h_open;
      help_button->m_file->position=0;
      help_function(NULL,help_button);
     } while ((fKBDisdown(SCAN_DOWN)==T_TRUE)&&(fast_scroll==T_TRUE)&&( *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)) < help_button->y_max/*-help_button->window->h_open*/));
     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,RELEASED);
     MOUSE_ZEIGE
     is_upper=T_FALSE;
    }
   }
  }
  if (((help_button->button_art&HELP_BUTTON_PAGE_DOWN)==HELP_BUTTON_PAGE_DOWN)&&((parameter->maus_button==1)||(parameter->taste!=0)))
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("scrolpd.hlf",NULL);
   }
   else
   {
    T_INT lines_to_scroll=((help_button->window->h_open/font_now->zeichen[(T_BYTE)' '].hoehe)-1)*font_now->zeichen[(T_BYTE)' '].hoehe;
    aktivate_window(help_button->window);
    if ( *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)) < help_button->y_max/*-help_button->window->h_open*/)
    {
     is_upper=T_TRUE;
     MOUSE_VERSTECKE
     lade_vga_nach_vga_teil_oc(
     help_button->window->x+help_button->window->x_0,
     help_button->window->y+help_button->window->y_0+lines_to_scroll,
     help_button->window->b_open,
     help_button->window->h_open-lines_to_scroll,
     help_button->window->x+help_button->window->x_0,
     help_button->window->y+help_button->window->y_0);

     vesa_rect_fill_oc(
     help_button->window->x+help_button->window->x_0,
     help_button->window->y+help_button->window->y_0+help_button->window->h_open-lines_to_scroll,
     help_button->window->b_open,
     lines_to_scroll,
     help_button->window->bcolor);
//     *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))=0;
     *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))+=lines_to_scroll;
     *(T_INT *)(help_button->m_file->mem+2*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)));
     *(T_INT *)(help_button->m_file->mem+3*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)))+help_button->window->h_open-lines_to_scroll/*-help_button->y_scroll*/;
     *(T_INT *)(help_button->m_file->mem+4*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)))+help_button->window->b_open;
     *(T_INT *)(help_button->m_file->mem+5*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)))+help_button->window->h_open;
     help_button->m_file->position=0;
     help_function(NULL,help_button);
     MOUSE_ZEIGE
     is_upper=T_FALSE;
    }
   }
  }
  if (((help_button->button_art&HELP_BUTTON_UP)==HELP_BUTTON_UP)&&((parameter->maus_button==1)||(parameter->taste!=0)))
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("scrollu.hlf",NULL);
    while (vesa_mouse_button)
     vesa_mouse_update();
   }
   else
   {
    T_INT lines_to_scroll=help_button->y_scroll*line_scroll_width;
    aktivate_window(help_button->window);
    if (*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))-lines_to_scroll<0)
    {
     lines_to_scroll = *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT));
    }
    if (*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))>0)
    {
     is_upper=T_TRUE;
     MOUSE_VERSTECKE
     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,PRESSED);
     do
     {
      lade_vga_nach_vga_teil_oc(
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0,
      help_button->window->b_open,
      help_button->window->h_open-lines_to_scroll,
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0+lines_to_scroll);

      vesa_rect_fill_oc(
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0,
      help_button->window->b_open,
      lines_to_scroll,
      help_button->window->bcolor);

//     *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))=0;                // x_start
      *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))-=lines_to_scroll; // y_start
      *(T_INT *)(help_button->m_file->mem+2*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)));                // x_ausgabe_start
      *(T_INT *)(help_button->m_file->mem+3*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)));
      *(T_INT *)(help_button->m_file->mem+4*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)))+help_button->window->b_open;                // x_ausgabe_end
      *(T_INT *)(help_button->m_file->mem+5*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)))+lines_to_scroll/*+help_button->y_scroll*/;
      help_button->m_file->position=0;
      help_function(NULL,help_button);
     } while ((fKBDisdown(SCAN_UP)==T_TRUE)&&(fast_scroll==T_TRUE)&&(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))>0));
     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,RELEASED);
     MOUSE_ZEIGE
     is_upper=T_FALSE;
    }
   }
  }
  if (((help_button->button_art&HELP_BUTTON_PAGE_UP)==HELP_BUTTON_PAGE_UP)&&((parameter->maus_button==1)||(parameter->taste!=0)))
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("scrolpu.hlf",NULL);
   }
   else
   {
    T_INT lines_to_scroll=((help_button->window->h_open/font_now->zeichen[(T_BYTE)' '].hoehe)-1)*font_now->zeichen[(T_BYTE)' '].hoehe;
    MOUSE_VERSTECKE
    aktivate_window(help_button->window);

    if (*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))-lines_to_scroll<0)
    {
     lines_to_scroll=*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT));
    }

    is_upper=T_TRUE;
    lade_vga_nach_vga_teil_oc(
    help_button->window->x+help_button->window->x_0,
    help_button->window->y+help_button->window->y_0,
    help_button->window->b_open,
    help_button->window->h_open-lines_to_scroll,
    help_button->window->x+help_button->window->x_0,
    help_button->window->y+help_button->window->y_0+lines_to_scroll);

    vesa_rect_fill_oc(
    help_button->window->x+help_button->window->x_0,
    help_button->window->y+help_button->window->y_0,
    help_button->window->b_open,
    lines_to_scroll,
    help_button->window->bcolor);

//    *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))=0;                // x_start
    *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))-=lines_to_scroll; // y_start
    *(T_INT *)(help_button->m_file->mem+2*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)));                // x_ausgabe_start
    *(T_INT *)(help_button->m_file->mem+3*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)));
    *(T_INT *)(help_button->m_file->mem+4*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)))+help_button->window->b_open;                // x_ausgabe_end
    *(T_INT *)(help_button->m_file->mem+5*sizeof(T_INT))=(*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)))+lines_to_scroll/*+help_button->y_scroll*/;
    help_button->m_file->position=0;
    help_function(NULL,help_button);
    MOUSE_ZEIGE
    is_upper=T_FALSE;
   }
  }

  if ((help_button->button_art&HELP_BUTTON_RIGHT)==HELP_BUTTON_RIGHT)
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("scroll_r.hlf",NULL);
    while (vesa_mouse_button)
     vesa_mouse_update();
   }
   else
   {
    T_INT lines_to_scroll=help_button->x_scroll*line_scroll_width;
    aktivate_window(help_button->window);
    if ( *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)) < help_button->x_max)
    {
     is_upper=T_TRUE;
     MOUSE_VERSTECKE
     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,PRESSED);

     do
     {
      lade_vga_nach_vga_teil_oc(
      help_button->window->x+help_button->window->x_0+lines_to_scroll,
      help_button->window->y+help_button->window->y_0,
      help_button->window->b_open-lines_to_scroll,
      help_button->window->h_open,
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0);

      vesa_rect_fill_oc(
      help_button->window->x+help_button->window->x_0+help_button->window->b_open-lines_to_scroll,
      help_button->window->y+help_button->window->y_0,
      lines_to_scroll,
      help_button->window->h_open,
      help_button->window->bcolor);

      *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))+=lines_to_scroll;                            // x_start
/// y_start
      *(T_INT *)(help_button->m_file->mem+2*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))+help_button->window->b_open-lines_to_scroll; // x_ausgabe_start
      *(T_INT *)(help_button->m_file->mem+3*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT));
      *(T_INT *)(help_button->m_file->mem+4*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))+help_button->window->b_open;                 // x_ausgabe_end
      *(T_INT *)(help_button->m_file->mem+5*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))+help_button->window->h_open;
      help_button->m_file->position=0;
      help_function(NULL,help_button);
     } while ((fKBDisdown(SCAN_RIGHT)==T_TRUE)&&(fast_scroll==T_TRUE)&& ( *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT)) < help_button->x_max) );
     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,RELEASED);
     MOUSE_ZEIGE
     is_upper=T_FALSE;
    }
   }
  }

  if ((help_button->button_art&HELP_BUTTON_LEFT)==HELP_BUTTON_LEFT)
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("scroll_l.hlf",NULL);
   }
   else
   {
    T_INT lines_to_scroll=help_button->x_scroll*line_scroll_width;
    aktivate_window(help_button->window);
    if (*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))>=lines_to_scroll)
    {
     is_upper=T_TRUE;
     MOUSE_VERSTECKE
     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,PRESSED);
     do
     {
      lade_vga_nach_vga_teil_oc(
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0,
      help_button->window->b_open-lines_to_scroll,
      help_button->window->h_open,
      help_button->window->x+help_button->window->x_0+lines_to_scroll,
      help_button->window->y+help_button->window->y_0);

      vesa_rect_fill_oc(
      help_button->window->x+help_button->window->x_0,
      help_button->window->y+help_button->window->y_0,
      lines_to_scroll,
      help_button->window->h_open,
      help_button->window->bcolor);

      *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))-=lines_to_scroll; // x_start
/// y_start
      *(T_INT *)(help_button->m_file->mem+2*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT));                // x_ausgabe_start
      *(T_INT *)(help_button->m_file->mem+3*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT));
      *(T_INT *)(help_button->m_file->mem+4*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))+lines_to_scroll;  // x_ausgabe_end
      *(T_INT *)(help_button->m_file->mem+5*sizeof(T_INT))=*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))+help_button->window->h_open;
      help_button->m_file->position=0;
      help_function(NULL,help_button);
     } while ((fKBDisdown(SCAN_LEFT)==T_TRUE)&&(fast_scroll==T_TRUE)&& (*(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))>=lines_to_scroll) );

     if (parameter->taste==0)
      wprint_button(help_button->window,help_button->button_element,RELEASED);
     MOUSE_ZEIGE
     is_upper=T_FALSE;
    }
   }
  }
  if ((help_button->button_art&HELP_BUTTON_LINK)==HELP_BUTTON_LINK)
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("linkb.hlf",NULL);
   }
   else
   {
    help_function(help_button->link,NULL);
    if ((fKBDisCTRL()==T_FALSE)&&((help_button->button_art&HELP_BUTTON_DONT_CLOSE)!=HELP_BUTTON_DONT_CLOSE))
    {
     execute_close_help_button(parameter);
    }
   }
  }
  if ((help_button->button_art&HELP_BUTTON_JUMP)==HELP_BUTTON_JUMP)
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (fKBDisALT()==T_TRUE)
   {
    help_function("linkb.hlf",NULL);
   }
   else
   {
    T_INT jump_line=help_button->line;
    if (*(help_button->link)!='#')
    {
     T_INT sc=0;
     while ((*(help_button->link+sc)!=(T_CHAR)0)&&(*(help_button->link+sc)!='#')) sc++;
     *(help_button->link+sc)=(T_CHAR)0;
     help_offset=jump_line;
     help_function(help_button->link,NULL);
     help_offset=0;
     if ((fKBDisCTRL()==T_FALSE)&&((help_button->button_art&HELP_BUTTON_DONT_CLOSE)!=HELP_BUTTON_DONT_CLOSE))
     {
      execute_close_help_button(parameter);
     }
    }
    else
    {
     aktivate_window(help_button->window);
     is_upper=T_TRUE;
     MOUSE_VERSTECKE
     vesa_rect_fill_oc(
     help_button->window->x+help_button->window->x_0,
     help_button->window->y+help_button->window->y_0,
     help_button->window->b_open,
     help_button->window->h_open,
     help_button->window->bcolor);


     *(T_INT *)(help_button->m_file->mem+0*sizeof(T_INT))=0;
     *(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT))=jump_line;
     *(T_INT *)(help_button->m_file->mem+2*sizeof(T_INT))=0;
     *(T_INT *)(help_button->m_file->mem+3*sizeof(T_INT))=jump_line;
     *(T_INT *)(help_button->m_file->mem+4*sizeof(T_INT))=help_button->window->b_open;
     *(T_INT *)(help_button->m_file->mem+5*sizeof(T_INT))=help_button->window->h_open+jump_line;
     help_button->m_file->position=0;
     help_function(NULL,help_button);

     MOUSE_ZEIGE
     is_upper=T_FALSE;

    }
   }
  }
  if ((help_button->button_art&HELP_BUTTON_USER_FUNCTION)==HELP_BUTTON_USER_FUNCTION)
  {
   if (help_user_function==NULL)
   {
    T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_NO_USER_FUNCTION)
    T_DEBUG_FUNCTION_POSITION(2)
    T_DEBUG_LEAVE
    return parameter->ebene;
   }
   help_user_function(help_button->link);
  }
 }
 else
 {
  T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CANT_FIND_MYSELF)
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

T_INT help_destructor(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 T_INT mfile_found=T_FALSE;
 T_DEBUG_ENTRY("help_destructor",75) //75
 if (parameter==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nUngueltiger Parameter in DESTRUCTOR()");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return -1;
 }
 if (window==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nIch kann mich nicht finden!!! (Window nicht geschlossen)");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return -1;
 }
 else
 {
  T_LISTE *help=NULL;
  T_INT id=-1;
  if (parameter->window_element!=NULL)
  {
   id=((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->id;
   help=help_button_liste_first;
   while (help)
   {
    HELP_BUTTON *help_button=(HELP_BUTTON *)help->objekt;
    if (help_button->window_id==id)
    {
     help=help->naechstes;
     d_entferne_aus_liste( help_button, &help_button_liste_first, &help_button_liste_last ,DL_CLEAN_UP);
     if (help_button->m_file!=NULL)
     {
      if (mfile_found==T_FALSE)
      {
       mfile_found=T_TRUE;
       free(help_button->m_file->mem);
       free(help_button->m_file);
      }
      free(help_button->filename);
     }
     free(help_button);
    }
    else
    {
     help=help->naechstes;
    }
   }
  }
 }
 window->destructor=NULL;
 window->parameter=NULL;
// close_window(window,CLOSE_DEFAULT);
 T_DEBUG_LEAVE
 return -1; // keine variablen da, dann ebene = -1
}

T_PCHAR cut(T_PCHAR _source, T_INT maxlen, T_PINT words)
{
 static T_PCHAR source=NULL;
 static T_INT pos=0;
 T_PCHAR new_string=NULL;
 T_PCHAR source_copy;
 T_PCHAR source_copy_save;
 T_PCHAR token;
 T_INT len_x1,len_y1,len_x2,len_y2;
 T_DEBUG_ENTRY("cut",75)
 if (_source!=NULL)
 {
  source=_source;
  pos=0;
 }
 source_copy=strdup(source);
 source_copy_save=source_copy;
 if (pos>=strlen(source_copy))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return NULL;
 }
 source_copy+=pos;
 new_string=(T_PCHAR)malloc(sizeof(T_CHAR)*MAX_TEXT_LEN);
 new_string[0]=(T_CHAR)0;
 token=strtok(source_copy," ");
 *words=0;
 while(token)
 {
  (*words)++;
  vesa_get_text_len(new_string,&len_x1,&len_y1);
  vesa_get_text_len(token,&len_x2,&len_y2);
  if (len_x1+len_x2>maxlen)
  {
   break;
  }
  strcat(new_string,token);
  strcat(new_string," ");
  token=strtok(NULL," ");
 }
 if (strlen(new_string))
 {
  pos+=strlen(new_string);
  /* trailing spaces get eliminated */
  new_string[strlen(new_string)-1]=(T_CHAR)0;
  if (token==NULL)
   *words=-1;
 }
 else
 {
  if (token)
  {
   strcat(new_string,token);
   pos+=strlen(new_string);
   /* trailing spaces get eliminated */
   pos++;
  }
  else
  {
   free(source_copy_save);
   free(new_string);
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return NULL;
  }
 }
 free(source_copy_save);
 T_DEBUG_LEAVE
 return new_string;
}

T_INT delete_double_spaces(T_PCHAR s)
{
 T_INT i=0;
 T_INT c=0;
 T_DEBUG_ENTRY("delete_double_spaces",75)
 if (s==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 while (s[i]!=(T_CHAR)0)
 {
  if (isspace(s[i]))
  {
   if (isspace(s[i+1]))
   {
    memmove(s+i,s+i+1,strlen(s+i+1)+1);
    c++;
   }
   else
    i++;
  }
  else
   i++;
 }
 T_DEBUG_LEAVE
 return c;
}

T_INT help_function(T_PCHAR filename, HELP_BUTTON *sb)
{
 FILE *handle_out=NULL;
 FILE *handle_in=NULL;
 M_FILE *mfile=NULL;
 M_FILE *help_file=NULL;
 WINDOW_LISTEN_ELEMENT *text_window=NULL;
 WINDOW_LISTEN_ELEMENT *message=NULL;
 T_PCHAR current_path=NULL;
 T_INT help_font_loaded=T_FALSE;
 T_INT recompile=T_FALSE;
 T_INT y_max=0;
 T_INT x_max=0;
 T_CHAR cmp_name[MAX_TEXT_LEN];
 T_INT old_print_modus;
 T_INT old_text;
 T_INT old_back_color;
 T_INT old_text_color;
 T_INT read_status=T_OK;
 T_INT i=0;
 T_INT len_x=8,len_y=8;
 T_FONT *font_save=font_now;
 T_FONT help_font;

 T_INT pcx_set_file_color_flag_old=pcx_set_file_color_flag;
 T_INT x_start=0, y_start=0;                 // position im file in pixel
 T_INT x_ausgabe_start=0, y_ausgabe_start=0; // ausgabe start auf bildschirm in pixel auf virtuellem bildschirm (ganzes file)
 T_INT x_ausgabe_end=0, y_ausgabe_end=0;     // ausgabe end auf bildschirm in pixel auf virtuellem bildschirm (ganzes file)
 T_DEBUG_ENTRY("help_function",75)

 pallow_color_setting=T_FALSE;
 pwin_shade_col1=ddark_grau;
 pwin_shade_col2=weiss;
 pindex_nummer=0;
 pwin_size_x=400;
 pwin_size_y=200;
 pwin_pos_x=0;
 pwin_pos_y=0;
 ppos_x=0;
 ppos_y=0;
 pwin_with_name=T_TRUE;
 pforce_no_scroll=0;
 pforce_scroll=0;
 ppop_up=T_FALSE;
 pcenter_x=T_FALSE;
 pcenter_y=T_FALSE;
 pright=T_FALSE;
 pleft=T_FALSE;
 pbottom=T_FALSE;
 pprint_mode=PIC_FILLED;
 ptext_mode=SINGLE_COLOR;
 pwin_shade_width=1;
 pwin_name=NULL;
 p_alloc_pointer=T_TRUE;
 pleft_format=0;
 pright_format=pwin_size_x-pwin_shade_width;
 MOUSE_VERSTECKE
 if (sb!=NULL)
 {
  mfile=sb->m_file;
  filename=sb->filename;
  text_window=sb->window;
 }
 else
 {
  pwin_back_color=dhell_grau;
  pwin_color=ddark_grau;
  pback_color=dhell_grau;
  ptext_color=ddark_grau;
  pbutton_color1=hhell_grau;
  pbutton_color2=hdark_grau;
  pbutton_color3=ddark_grau;
  pbutton_color4=mdark_grau;
  pbutton_color5=dhell_grau;
  pbutton_color6=mhell_grau;
 } // else if (sb==NULL)
 if (mfile==NULL)
 {
  T_PCHAR pos;
  current_path=get_current_path();
  if (t_hilfe_pfad!=NULL)
   change_directory(t_hilfe_pfad);
  strcpy(cmp_name,filename);
  pos=strstr(cmp_name,".hlf");
  if (pos==NULL)
   pos=strstr(cmp_name,".HLF");
  if (pos==NULL)
  {
   T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_FILE_NOT_FOUND)
   T_DEBUG_FUNCTION_POSITION(1111)
   T_DEBUG_LEAVE
   return T_NOT_OK;
  }
  *pos=(T_CHAR)0;
  strcat(cmp_name,".cmp");
  if (f_file_exist(cmp_name)==T_TRUE)
  {
   DIR_ARRAY *file_info;
   DIR_ARRAY *file_info_org;
   file_info_org=file_get_dir(filename);
   file_info=file_get_dir(cmp_name);
   if (file_info_org->file[0].d_date>file_info->file[0].d_date)
   {
    recompile=T_TRUE;
   }
   if (file_info_org->file[0].d_date==file_info->file[0].d_date)
   {
    if (file_info_org->file[0].d_time>file_info->file[0].d_time)
     recompile=T_TRUE;
   }
   if (recompile==T_FALSE)
   {
    mfile=(M_PFILE)malloc(sizeof(M_FILE));
    if (mfile!=NULL)
    {
     T_INT size;
     mfile->size=file_info->file[0].d_size;
     mfile->position=0;
     mfile->mem=(T_PUCHAR ) malloc (file_info->file[0].d_size*sizeof(T_UCHAR));
     if (mfile->mem!=NULL)
     {
      handle_in = fopen( cmp_name, "rb" );
      if (handle_in==NULL)
      {
       t_printf(E_VERBOSE_STANDARD,"\nTrouble opening compiled help file, recompiling...");
       free(mfile->mem);
       free(mfile);
       mfile=NULL;
       recompile=T_TRUE;
      }
      else
      if ((size=fread(mfile->mem,sizeof(T_UCHAR),file_info->file[0].d_size*sizeof(T_UCHAR),handle_in))!=file_info->file[0].d_size*sizeof(T_UCHAR)*sizeof(T_UCHAR))
      {
       recompile=T_TRUE;
       free(mfile->mem);
       free(mfile);
       mfile=NULL;
       show_message("Trouble reading compiled help file %s,(%i of %i read), recompiling...",cmp_name,size,file_info->file[0].d_size*sizeof(T_UCHAR)*sizeof(T_UCHAR));
      }
      if (handle_in!=NULL)
       fclose(handle_in);
     } //if (mfile->mem!=NULL) //
     else
     {
      t_printf(E_VERBOSE_STANDARD,"\nLow Memory!!! Can't allocate memory for compiled help.");
      free(mfile);
      mfile=NULL;
      recompile=T_TRUE;
     }
    } //if (mfile!=NULL)
    else
    {
     t_printf(E_VERBOSE_STANDARD,"\nLow Memory!!! Can't allocate memory for compiled help.");
     recompile=T_TRUE; // can't allocate file space, just do a recompile!
    }
    free(file_info);
    free(file_info_org);
   }
  } // if (f_file_exist(cmp_name)==T_TRUE)
  else
   recompile=T_TRUE;
  if (recompile==T_TRUE)
  {
   p_parse_init();
   p_open_parse( filename, &help_file, parse_hilfe  );
   if ((help_file==NULL)||(parse_error!=T_OK))
   {
    MOUSE_ZEIGE
    show_message("Hilfe nicht verfuegbar! (Name: %s, Parse Error:%i)",filename,parse_error);
    if (ppop_up==T_TRUE)
    {
     while (vesa_mouse_button)
      vesa_mouse_update();
    }
    if (current_path!=NULL)
    {
     change_directory(current_path);
     free(current_path);
    }
    T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_FILE_NOT_FOUND)
    T_DEBUG_FUNCTION_POSITION(2)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   handle_out = fopen( cmp_name, "wb" );
   // it should be ok for handle_out to be zero, nothing should be outputed than...
   if (handle_out!=NULL)
   {
    fwrite(&x_start,sizeof(x_start),1,handle_out);
    fwrite(&y_start,sizeof(y_start),1,handle_out);
    fwrite(&x_ausgabe_start,sizeof(x_ausgabe_start),1,handle_out);
    fwrite(&y_ausgabe_start,sizeof(y_ausgabe_start),1,handle_out);
    fwrite(&x_ausgabe_end,sizeof(x_ausgabe_end),1,handle_out);
    fwrite(&y_ausgabe_end,sizeof(y_ausgabe_end),1,handle_out);
   }
   if (handle_out==NULL)
   {
    MOUSE_ZEIGE
    message=show_message("Can't write compiled helpfile...\"%s\"",cmp_name);
    if (ppop_up==T_TRUE)
    {
     while (vesa_mouse_button)
      vesa_mouse_update();
    }
    if (current_path!=NULL)
    {
     change_directory(current_path);
     free(current_path);
    }
    T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_FILE_NOT_FOUND)
    T_DEBUG_FUNCTION_POSITION(3)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   else
   {
    if (no_process_window==T_FALSE)
     message=show_message("Compiling helpfile...");
   }
  }
 }
 if (mfile!=NULL)
 {
  pw1_color=pw1_color__;
  pw2_color=pw2_color__;
  pb1_color=pb1_color__;
  pb2_color=pb2_color__;
  pb3_color=pb3_color__;
  pb4_color=pb4_color__;
  pb5_color=pb5_color__;
  pb6_color=pb6_color__;
  pwb_color=pwb_color__;
  pw_color=pw_color__;
  pb_color=pb_color__;
  pt_color=pt_color__;
  m_read(mfile,(T_PCHAR)&x_start,sizeof(x_start));
  m_read(mfile,(T_PCHAR)&y_start,sizeof(y_start));
  m_read(mfile,(T_PCHAR)&x_ausgabe_start,sizeof(x_ausgabe_start));
  m_read(mfile,(T_PCHAR)&y_ausgabe_start,sizeof(y_ausgabe_start));
  m_read(mfile,(T_PCHAR)&x_ausgabe_end,sizeof(x_ausgabe_end));
  m_read(mfile,(T_PCHAR)&y_ausgabe_end,sizeof(y_ausgabe_end));

  y_start+=help_offset;
  y_ausgabe_start+=help_offset;
  y_ausgabe_end+=help_offset;

  *(T_INT *)(mfile->mem+1*sizeof(T_INT))=y_start;
  *(T_INT *)(mfile->mem+3*sizeof(T_INT))=y_ausgabe_start;
  *(T_INT *)(mfile->mem+5*sizeof(T_INT))=y_ausgabe_end;

 }
 while (read_status!=PARSE_FILE_END)
 {
  T_CHAR last_key[80];
  T_INT key=0;
  T_INT size=0;
  i++;
  if (mfile==NULL)
  {
   read_status =p_parse_next( help_file, last_key, &key );
   if (handle_out!=NULL)
   {
    fwrite(&key,sizeof(key),1,handle_out);
   }
  }
  else
  {
   if ((size=m_read(mfile,(T_PCHAR)&key,sizeof(key)))==0)
   {
    read_status=PARSE_FILE_END;
   }
  }
  switch (key)
  {
   case H_PARSE_END:
   {
    read_status=PARSE_FILE_END;
    break;
   }
   case H_WIN_SIZE_X:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pwin_size_x,sizeof(pwin_size_x));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pwin_size_x,sizeof(pwin_size_x),1,handle_out);
    }
    break;
   }
   case H_WIN_SIZE_Y:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pwin_size_y,sizeof(pwin_size_y));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pwin_size_y,sizeof(pwin_size_y),1,handle_out);
    }
    break;
   }
   case H_WIN_POS_X:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pwin_pos_x,sizeof(pwin_pos_x));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pwin_pos_x,sizeof(pwin_pos_x),1,handle_out);
    }
    break;
   }
   case H_WIN_POS_Y:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pwin_pos_y,sizeof(pwin_pos_y));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pwin_pos_y,sizeof(pwin_pos_y),1,handle_out);
    }
    break;
   }
   case H_WIN_BACK_COLOR:
   {
    if (mfile!=NULL)
    {
     m_pread(mfile,&pwb_color,sizeof(T_INT)*4);
//     m_read(mfile,(T_PCHAR)pwb_color,sizeof(pwb_color[0])*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pwb_color,sizeof(pwb_color[0]),4,handle_out);
    }
    if (pwb_color[0]==1) // use color
    {
     pwin_back_color=pwb_color[1];
     if (mfile==NULL)
      free(pwb_color);
     break;
    }
    if (pwb_color[0]==3) // find rgb color
    {
     pwin_back_color=vesa_get_nearest_used_color(pwb_color[1],pwb_color[2],pwb_color[3]);
     if (mfile==NULL)
      free(pwb_color);
     break;
    }
    if (pwb_color[0]==4) // color set rgb to color and use color
    {
     pwin_back_color=pwb_color[1];
     vesa_set_dac_register(pwb_color[1],pwb_color[2],pwb_color[3],pwb_color[4]);
     if (mfile==NULL)
      free(pwb_color);
     break;
    }
   }
   case H_WIN_COLOR:
   {
    if (mfile!=NULL)
    {
     m_pread(mfile,&pw_color,sizeof(T_INT)*4);
//     m_read(mfile,(T_PCHAR)pw_color,sizeof(pw_color[0])*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pw_color,sizeof(pw_color[0]),4,handle_out);
    }
    if (pw_color[0]==1) // use color
    {
     pwin_color=pw_color[1];
     if (mfile==NULL)
      free(pw_color);
     break;
    }
    if (pw_color[0]==3) // find rgb color
    {
     pwin_color=vesa_get_nearest_used_color(pw_color[1],pw_color[2],pw_color[3]);
     if (mfile==NULL)
      free(pw_color);
     break;
    }
    if (pw_color[0]==4) // color set rgb to color and use color
    {
     pwin_color=pw_color[1];
     vesa_set_dac_register(pw_color[1],pw_color[2],pw_color[3],pw_color[4]);
     if (mfile==NULL)
      free(pw_color);
     break;
    }
   }
   case H_CENTER_X:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pcenter_x,sizeof(pcenter_x));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pcenter_x,sizeof(pcenter_x),1,handle_out);
    }
    break;
   }
   case H_CENTER_Y:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pcenter_y,sizeof(pcenter_y));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pcenter_y,sizeof(pcenter_y),1,handle_out);
    }
    break;
   }
   case H_RIGHT:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pright,sizeof(pright));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pright,sizeof(pright),1,handle_out);
    }
    break;
   }
   case H_LEFT:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pleft,sizeof(pleft));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pleft,sizeof(pleft),1,handle_out);
    }
    break;
   }
   case H_BOTTOM:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pbottom,sizeof(pbottom));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pbottom,sizeof(pbottom),1,handle_out);
    }
    break;
   }
   case H_POS_X:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&ppos_x,sizeof(ppos_x));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&ppos_x,sizeof(ppos_x),1,handle_out);
     if (ppos_x>x_max)
     {
      x_max=ppos_x;
     }
    }
    break;
   }
   case H_POS_Y:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&ppos_y,sizeof(ppos_y));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&ppos_y,sizeof(ppos_y),1,handle_out);
     if (ppos_y>y_max)
     {
      y_max=ppos_y;
     }
    }
    break;
   }
   case H_BACK_COLOR:
   {
    if (mfile!=NULL)
    {
     m_pread(mfile,&pb_color,sizeof(T_INT)*4);
//     m_read(mfile,(T_PCHAR)pb_color,sizeof(pb_color[0])*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pb_color,sizeof(pb_color[0]),4,handle_out);
    }
    if (pb_color[0]==1) // use color
    {
     pback_color=pb_color[1];
     if (mfile==NULL)
      free(pb_color);
     break;
    }
    if (pb_color[0]==3) // find rgb color
    {
     pback_color=vesa_get_nearest_used_color(pb_color[1],pb_color[2],pb_color[3]);
     if (mfile==NULL)
      free(pb_color);
     break;
    }
    if (pb_color[0]==4) // color set rgb to color and use color
    {
     pback_color=pb_color[1];
     vesa_set_dac_register(pb_color[1],pb_color[2],pb_color[3],pb_color[4]);
     if (mfile==NULL)
      free(pb_color);
     break;
    }
   }
   case H_TEXT_COLOR:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pt_color,sizeof(pt_color[0])*4);
     m_pread(mfile,&pt_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pt_color,sizeof(pt_color[0]),4,handle_out);
    }
    if (pt_color[0]==1) // use color
    {
     ptext_color=pt_color[1];
     if (mfile==NULL)
      free(pt_color);
     break;
    }
    if (pt_color[0]==3) // find rgb color
    {
     ptext_color=vesa_get_nearest_used_color(pt_color[1],pt_color[2],pt_color[3]);
     if (mfile==NULL)
      free(pt_color);
     break;
    }
    if (pt_color[0]==4) // color set rgb to color and use color
    {
     ptext_color=pt_color[1];
     vesa_set_dac_register(pt_color[1],pt_color[2],pt_color[3],pt_color[4]);
     if (mfile==NULL)
      free(pt_color);
     break;
    }
   }
   case H_DRAW_NOW:
   {
    OPEN_WIN w;
    if ((text_window!=NULL)||(sb!=NULL)||(handle_out!=NULL))
    {
     pleft_format=0+1;
     pright_format=(pwin_size_x)-(pwin_shade_width+1);
     break;
    }
    if (pwin_center==T_TRUE)
    {
     w.x_pos=vesa_mouse_x-pwin_size_x/2;
     w.y_pos=vesa_mouse_y-pwin_size_y/2;
    }
    else
    {
     w.x_pos=pwin_pos_x;
     w.y_pos=pwin_pos_y;
    }
    if (w.x_pos+pwin_size_x+2*pwin_shade_width>vesa_x)
     w.x_pos =vesa_x-(pwin_size_x+2*pwin_shade_width);
    if (w.y_pos+pwin_size_y+2*pwin_shade_width>vesa_y)
     w.y_pos =vesa_y-(pwin_size_y+2*pwin_shade_width);
    if (w.x_pos<0)
     w.x_pos =0;
    if (w.y_pos<0)
     w.y_pos =0;
    w.breite=pwin_size_x;
    w.hoehe=pwin_size_y;
    w.border=pwin_shade_width;
    w.color=pwin_color;
    w.bcolor=pwin_back_color;
    w.color=pwin_color;
    w.art=RAW_WINDOW|WITH_CLOSE_BUTTON|WITH_HIDE_BUTTON|WITH_DRAG_BUTTON|VIRTUAL_FRONT_WINDOW|REMEMBER;
    if (ppop_up==T_TRUE)
     w.art=RAW_WINDOW;
    w.id=WIN_OPEN_CHOOSES_ID;
    w.variablen=NULL;
    w.mem_bild=NULL;
    w.pcx_bild=NULL;
    if (pwin_with_name==T_TRUE)
    {
     if (pwin_name==NULL)
      w.name=filename;
     else
      w.name=pwin_name;
    }
    else
     w.name=NULL;
    w.destructor=help_destructor;
    w.area_funktion=execute_activate;
//    execute_win_move;
    w.tasten_funktion=help_key_function;
    text_window=open_window(&w);
    if (text_window==NULL)
    {
     font_now=font_save;
     if (ppop_up==T_TRUE)
     {
      while (vesa_mouse_button)
       vesa_mouse_update();
     }
     if (current_path!=NULL)
     {
      change_directory(current_path);
      free(current_path);
     }
     pcx_set_file_color_flag=pcx_set_file_color_flag_old;
     if (help_file!=NULL)
      p_close_parse( &help_file );
     if (handle_out!=NULL)
     {
      fclose(handle_out);
     }
     if (mfile!=NULL)
     {
      free(mfile->mem);
      free(mfile);
      mfile=NULL;
     }
     if ((pwin_name!=NULL)&&(mfile==NULL))
     {
      free(pwin_name);
      pwin_name=NULL;
     }
     if (message!=NULL)
      close_window(message,CLOSE_DEFAULT);
     MOUSE_ZEIGE
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_WINDOW_NOT_OPENED)
     T_DEBUG_FUNCTION_POSITION(3)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    if ((pwin_name!=NULL)&&(mfile==NULL))
    {
     free(pwin_name);
     pwin_name=NULL;
    }
    pleft_format=0+1;
    pright_format=(text_window->b-text_window->x_0)-(pwin_shade_width+1);
    print_srect(text_window,PRINT_WIN_RAW,0,0,text_window->b,text_window->h,pwin_shade_col1,pwin_shade_col2,pwin_shade_width);
    break;
   }
   case H_TEXT:
   {
    T_INT len;
    T_INT hight;
    if ((text_window==NULL)&&(handle_out==NULL))
    {
     show_message("Draw the help window before printing Text!");
     break;
    }
    else
    {
     old_print_modus=vesa_print_modus;
     old_text=vesa_text;
     old_back_color=vesa_back_color;
     old_text_color=vesa_text_color;
     vesa_print_modus=pprint_mode;
     vesa_text=ptext_mode;
     vesa_back_color=pback_color;
     vesa_text_color=ptext_color;
     if (mfile!=NULL)
     {
      m_read(mfile,(T_PCHAR)&len,sizeof(len));
      m_pread(mfile,&ptext,sizeof(T_CHAR)*len);
      m_read(mfile,(T_PCHAR)&len_x,sizeof(len_x));
      m_read(mfile,(T_PCHAR)&hight,sizeof(hight));
      m_read(mfile,(T_PCHAR)&ppos_x,sizeof(ppos_x));
      m_read(mfile,(T_PCHAR)&ppos_y,sizeof(ppos_y));
      if (sb==NULL)
      {
       if ((ppos_y-y_start>=0)&&(ppos_y-y_start<text_window->h_open))
       {
        vesa_print_string_max_oc(0,0,WX(ppos_x),WY(ppos_y),text_window->b_open-ppos_x,_MIN_(text_window->h_open-ppos_y,hight),ptext);
       }
      }
      else
      {
       if ((ppos_y<y_ausgabe_end)&&(ppos_y+hight>y_ausgabe_start) &&
           (ppos_x<x_ausgabe_end)&&(ppos_x+len_x>x_ausgabe_start))
       {
        static T_INT x_o;
        static T_INT y_o;
        static T_INT x;
        static T_INT y;
        x_o = ppos_x<x_ausgabe_start ? x_ausgabe_start-ppos_x:0;
        y_o = ppos_y<y_ausgabe_start ? y_ausgabe_start-ppos_y:0;
        x= ppos_x+x_o;
        y= ppos_y+y_o;
        vesa_print_string_max_oc(x_o,y_o,WX(x),WY(y),x_ausgabe_end-x,y_ausgabe_end-y,ptext);
       }
      }
      ptext=NULL;
      ppos_x+=len_x;
     }
     else if (handle_out!=NULL)
     {
      T_INT len=strlen(ptext)+1;
      fwrite(&len,sizeof(T_INT),1,handle_out);
      fwrite(ptext,sizeof(T_CHAR),len,handle_out);
      vesa_get_text_len(ptext,&len_x,&len_y);
      fwrite(&len_x,sizeof(len_x),1,handle_out);
      fwrite(&len_y,sizeof(len_y),1,handle_out);
      if (pcenter_x==T_TRUE)
      {
       ppos_x=pwin_size_x/2-len_x/2;
      }
      if (pcenter_y==T_TRUE)
      {
       ppos_y=pwin_size_y/2-len_y/2;
      }
      if (pright==T_TRUE)
      {
       ppos_x=pwin_size_x-(len_x+pwin_shade_width+2);
      }
      if (pleft==T_TRUE)
      {
       ppos_x=2;
      }
      if (pbottom==T_TRUE)
      {
       ppos_y=(pwin_size_y)-(len_y+pwin_shade_width+2);
      }
      if (ppos_y>y_max)
      {
       y_max=ppos_y;
      }
      if (ppos_x+len_x>x_max)
      {
       x_max=ppos_x+len_x;
      }
      fwrite(&ppos_x,sizeof(ppos_x),1,handle_out);
      fwrite(&ppos_y,sizeof(ppos_y),1,handle_out);
      ppos_x+=len_x;
      if (ptext!=NULL)
       free(ptext);
      ptext=NULL;
     }
     vesa_print_modus=old_print_modus;
     vesa_text=old_text;
     vesa_back_color=old_back_color;
     vesa_text_color=old_text_color;
    }
    break;
   }
   case H_FORMAT_TEXT:
   {
    if ((text_window==NULL)&&(handle_out==NULL))
    {
     show_message("Draw the help window before printing Text!");
     break;
    }
    else
    {
     T_PCHAR cut_text=NULL;
     T_INT words;
     T_INT len;
     T_INT t;
     T_INT if_state;
     T_INT offset;
     T_INT hight;
     old_print_modus=vesa_print_modus;
     old_text=vesa_text;
     old_back_color=vesa_back_color;
     old_text_color=vesa_text_color;
     if (handle_out!=NULL)
     {
      vesa_print_modus=pprint_mode;
      vesa_text=ptext_mode;
      vesa_back_color=pback_color;
      vesa_text_color=ptext_color;
      delete_double_spaces(ptext);
/*
      if ((pcenter_x==T_TRUE)||(pright==T_TRUE)||(pleft==T_TRUE))
       cut_text=cut(ptext,(pwin_size_x)-(2*pwin_shade_width+3),&words);
      else
*/
      cut_text=cut(ptext,pright_format-pleft_format,&words);
      vesa_get_text_len(cut_text,&len_x,&hight);
      fwrite(&hight,sizeof(hight),1,handle_out);
      if_state=(cut_text!=NULL);
      fwrite(&if_state,sizeof(if_state),1,handle_out);
      while (cut_text!=NULL)
      {
       vesa_get_text_len(cut_text,&len_x,&hight);
       if (ppos_x+len_x>x_max)
       {
        x_max=ppos_x+len_x;
       }
       vesa_print_modus=pprint_mode;
       vesa_text=ptext_mode;
       vesa_back_color=pback_color;
       vesa_text_color=ptext_color;
       if (pcenter_x==T_TRUE)
       {
        ppos_x=pwin_size_x/2-len_x/2;
       }
       if (pcenter_y==T_TRUE)
       {
        ppos_y=pwin_size_y/2-len_y/2;
       }
       if (pright==T_TRUE)
       {
        ppos_x=pwin_size_x-(len_x+pwin_shade_width+2);
       }
       if (pleft==T_TRUE)
       {
        ppos_x=2;
       }
       if (pbottom==T_TRUE)
       {
        ppos_y=(pwin_size_y)-(len_y+pwin_shade_width+2);
       }
       if (((pcenter_x==T_TRUE)||(pright==T_TRUE)||(pleft==T_TRUE))||(words==-1))
       {
        if ((pcenter_x==T_FALSE)&&(pright==T_FALSE)&&(pleft==T_FALSE))
         ppos_x=pleft_format;
       }
       fwrite(&words,sizeof(words),1,handle_out);
       if_state=(((pcenter_x==T_TRUE)||(pright==T_TRUE)||(pleft==T_TRUE))||(words==-1));
       fwrite(&if_state,sizeof(if_state),1,handle_out);
       if (if_state)
       {
        len=strlen(cut_text)+1;
        fwrite(&ppos_x,sizeof(ppos_x),1,handle_out);
        fwrite(&ppos_y,sizeof(ppos_y),1,handle_out);
        if (ppos_y>y_max)
        {
         y_max=ppos_y;
        }
        fwrite(&len,sizeof(len),1,handle_out);
        fwrite(cut_text,sizeof(T_CHAR),len,handle_out);
        fwrite(&len_x,sizeof(len_x),1,handle_out);
       }
       else
       {
        T_PCHAR word=strtok(cut_text," ");
        T_INT space_x;
        ppos_x=pleft_format;
        space_x= font_now->zeichen[(T_BYTE)' '].breite;
        offset=(pright_format-pleft_format)-len_x;
        words-=2; // per se eins zuviel, und eins wird per hand ausgegeben
        vesa_get_text_len(word,&len_x,&len_y);
        fwrite(&ppos_x,sizeof(ppos_x),1,handle_out);
        fwrite(&ppos_y,sizeof(ppos_y),1,handle_out);
        if (ppos_y+len_y>y_max)
        {
         y_max=ppos_y+len_y;
        }
        if (ppos_x+len_x>x_max)
        {
         x_max=ppos_x+len_x;
        }
        len=strlen(word)+1;
        fwrite(&len,sizeof(len),1,handle_out);
        fwrite(word,sizeof(T_CHAR),len,handle_out);
        fwrite(&len_x,sizeof(len_x),1,handle_out);
        for(t=0;t<words;t++)
        {
         ppos_x+=len_x+space_x;
         ppos_x+=offset/(words-t);
         offset-=offset/(words-t);
         word=strtok(NULL," ");
         vesa_get_text_len(word,&len_x,&len_y);
         if (ppos_x+len_x>x_max)
         {
          x_max=ppos_x+len_x;
         }
         if (ppos_y>y_max)
         {
          y_max=ppos_y;
         }
         fwrite(&ppos_x,sizeof(ppos_x),1,handle_out);
         fwrite(&ppos_y,sizeof(ppos_y),1,handle_out);
         len=strlen(word)+1;
         fwrite(&len,sizeof(len),1,handle_out);
         fwrite(word,sizeof(T_CHAR),len,handle_out);
         fwrite(&len_x,sizeof(len_x),1,handle_out);
        }
       }
       free(cut_text);
       if ((pcenter_x==T_TRUE)||(pright==T_TRUE)||(pleft==T_TRUE))
        cut_text=cut(NULL,pwin_size_x-(2*pwin_shade_width+3),&words);
       else
        cut_text=cut(NULL,pright_format-pleft_format,&words);
       if (cut_text!=NULL)
       {
        ppos_x=2;
        ppos_y+=hight;
       }
       if_state=(cut_text!=NULL);
       fwrite(&if_state,sizeof(if_state),1,handle_out);
      }
      ppos_x+=len_x;
      if (ppos_x>x_max)
      {
       x_max=ppos_x;
      }
      fwrite(&ppos_x,sizeof(ppos_x),1,handle_out);
      vesa_print_modus=old_print_modus;
      vesa_text=old_text;
      vesa_back_color=old_back_color;
      vesa_text_color=old_text_color;
      free(ptext);
      ptext=NULL;
     } // if (handle_out!=NULL)
     else
     {
      T_PCHAR m_text;
      vesa_print_modus=pprint_mode;
      vesa_text=ptext_mode;
      vesa_back_color=pback_color;
      vesa_text_color=ptext_color;
      m_read(mfile,(T_PCHAR)&hight,sizeof(hight));
      m_read(mfile,(T_PCHAR)&if_state,sizeof(if_state));
      while (if_state)
      {
       m_read(mfile,(T_PCHAR)&words,sizeof(words));
       m_read(mfile,(T_PCHAR)&if_state,sizeof(if_state));
       if (if_state)
       {
        m_read(mfile,(T_PCHAR)&ppos_x,sizeof(ppos_x));
        m_read(mfile,(T_PCHAR)&ppos_y,sizeof(ppos_y));
        m_read(mfile,(T_PCHAR)&len,sizeof(len));
        m_pread(mfile,&m_text,sizeof(T_CHAR)*len);
        m_read(mfile,(T_PCHAR)&len_x,sizeof(len_x));
        if (sb==NULL)
        {
         if ((ppos_y-y_start>=0)&&(ppos_y-y_start<text_window->h_open))
         {
          vesa_print_string_max_oc(0,0,WX(ppos_x),WY(ppos_y),text_window->b_open-ppos_x,_MIN_(text_window->h_open-ppos_y,hight),m_text);
         }
        }
        else
        {
         if ((ppos_y<y_ausgabe_end)&&(ppos_y+hight>y_ausgabe_start) &&
             (ppos_x<x_ausgabe_end)&&(ppos_x+len_x>x_ausgabe_start))
         {
          static T_INT x_o;
          static T_INT y_o;
          static T_INT x;
          static T_INT y;
          x_o = ppos_x<x_ausgabe_start ? x_ausgabe_start-ppos_x:0;
          y_o = ppos_y<y_ausgabe_start ? y_ausgabe_start-ppos_y:0;
          x= ppos_x+x_o;
          y= ppos_y+y_o;
          vesa_print_string_max_oc(x_o,y_o,WX(x),WY(y),x_ausgabe_end-x,y_ausgabe_end-y,m_text);
         }
        }
       }
       else
       {
        words-=2; // per se eins zuviel, und eins wird per hand ausgegeben
        m_read(mfile,(T_PCHAR)&ppos_x,sizeof(ppos_x));
        m_read(mfile,(T_PCHAR)&ppos_y,sizeof(ppos_y));
        m_read(mfile,(T_PCHAR)&len,sizeof(len));
        m_pread(mfile,&m_text,sizeof(T_CHAR)*len);
        m_read(mfile,(T_PCHAR)&len_x,sizeof(len_x));
        for(t=0;t<words;t++)
        {
         if (sb==NULL)
         {
          if ((ppos_y-y_start>=0)&&(ppos_y-y_start<text_window->h_open))
          {
           vesa_print_string_max_oc(0,0,WX(ppos_x),WY(ppos_y),text_window->b_open-ppos_x,_MIN_(text_window->h_open-ppos_y,hight),m_text);
          }
         }
         else
         {
          if ((ppos_y<y_ausgabe_end)&&(ppos_y+hight>y_ausgabe_start) &&
              (ppos_x<x_ausgabe_end)&&(ppos_x+len_x>x_ausgabe_start))
          {
           static T_INT x_o;
           static T_INT y_o;
           static T_INT x;
           static T_INT y;
           x_o = ppos_x<x_ausgabe_start ? x_ausgabe_start-ppos_x:0;
           y_o = ppos_y<y_ausgabe_start ? y_ausgabe_start-ppos_y:0;
           x= ppos_x+x_o;
           y= ppos_y+y_o;
           vesa_print_string_max_oc(x_o,y_o,WX(x),WY(y),x_ausgabe_end-x,y_ausgabe_end-y,m_text);
          }
         }
         m_read(mfile,(T_PCHAR)&ppos_x,sizeof(ppos_x));
         m_read(mfile,(T_PCHAR)&ppos_y,sizeof(ppos_y));
         m_read(mfile,(T_PCHAR)&len,sizeof(len));
         m_pread(mfile,&m_text,sizeof(T_CHAR)*len);
         m_read(mfile,(T_PCHAR)&len_x,sizeof(len_x));
        }
        if (sb==NULL)
        {
         if ((ppos_y-y_start>=0)&&(ppos_y-y_start<text_window->h_open))
         {
          vesa_print_string_max_oc(0,0,WX(ppos_x),WY(ppos_y),text_window->b_open-ppos_x,_MIN_(text_window->h_open-ppos_y,hight),m_text);
         }
        }
        else
        {
         if ((ppos_y<y_ausgabe_end)&&(ppos_y+hight>y_ausgabe_start) &&
             (ppos_x<x_ausgabe_end)&&(ppos_x+len_x>x_ausgabe_start))
         {
          static T_INT x_o;
          static T_INT y_o;
          static T_INT x;
          static T_INT y;
          x_o = ppos_x<x_ausgabe_start ? x_ausgabe_start-ppos_x:0;
          y_o = ppos_y<y_ausgabe_start ? y_ausgabe_start-ppos_y:0;
          x= ppos_x+x_o;
          y= ppos_y+y_o;
          vesa_print_string_max_oc(x_o,y_o,WX(x),WY(y),x_ausgabe_end-x,y_ausgabe_end-y,m_text);
         }
        }
       }
       m_read(mfile,(T_PCHAR)&if_state,sizeof(if_state));
      }
      m_read(mfile,(T_PCHAR)&ppos_x,sizeof(ppos_x));
      vesa_print_modus=old_print_modus;
      vesa_text=old_text;
      vesa_back_color=old_back_color;
      vesa_text_color=old_text_color;
     } // else if (handle_out!=NULL)
     if (ppos_y+hight>y_max)
     {
      y_max=ppos_y+hight;
     }
    }
    break;
   }
   case H_BUTTON:
   {
    if (ppop_up==T_TRUE)
    {
     if (handle_out!=NULL)
     {
      free(pbutton_extern_text);
      free(pbutton_intern_text);
     }
     show_message("No Buttons allowed with popup helps!");
     break;
    }
    if (mfile!=NULL)
    {
     T_INT len;
     T_INT adder=0;
     BUTTON *button=NULL;
     HELP_BUTTON *new_help_button;
     T_INT button_pos=mfile->position;
     T_INT adder_pos=mfile->position+sizeof(T_INT);
     if (text_window==NULL)
     {
      show_message("Window not drawn yet (trying to make a button)!");
      break;
     }
     m_read(mfile,(T_PCHAR)&button,sizeof(T_PVOID));
     m_read(mfile,(T_PCHAR)&adder,sizeof(T_INT));
     if (button!=NULL)
     {
      if (pcenter_x==T_TRUE)
      {
       ppos_x=text_window->b/2-button->breite/2;
      }
      if (pcenter_y==T_TRUE)
      {
       ppos_y=text_window->h/2-button->hoehe/2;
      }
      if (pright==T_TRUE)
      {
       ppos_x=text_window->b-text_window->x_0-(button->breite+pwin_shade_width+2);
      }
      if (pleft==T_TRUE)
      {
       ppos_x=2;
      }
      if (pbottom==T_TRUE)
      {
       ppos_y=(text_window->h-text_window->y_0)-(button->hoehe+pwin_shade_width+2);
      }
      if (pcenter_x==T_TRUE)
      {
       ppos_x=text_window->b/2-button->breite/2;
      }
      if (pcenter_y==T_TRUE)
      {
       ppos_y=text_window->h/2-button->hoehe/2;
      }
      if (pright==T_TRUE)
      {
       ppos_x=text_window->b-text_window->x_0-(button->breite+pwin_shade_width+2);
      }
      if (pleft==T_TRUE)
      {
       ppos_x=2;
      }
      if (pbottom==T_TRUE)
      {
       ppos_y=(text_window->h-text_window->y_0)-(button->hoehe+pwin_shade_width+2);
      }
      move_button(text_window, button,ppos_x-x_start,ppos_y-y_start);
      mfile->position+=adder;
      ppos_x+=button->breite;
      // move button
      // and other stuff
      // ppos_y+=...
      break;
     }
     new_help_button=(HELP_BUTTON *) malloc (sizeof(HELP_BUTTON));
     if (new_help_button==NULL)
     {
      MOUSE_ZEIGE
      t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new <help> button!");
      font_now=font_save;
      if (current_path!=NULL)
      {
       change_directory(current_path);
       free(current_path);
      }
      pcx_set_file_color_flag=pcx_set_file_color_flag_old;
      if (mfile!=NULL)
      {
       free(mfile->mem);
       free(mfile);
       mfile=NULL;
      }
      if ((pwin_name!=NULL)&&(mfile==NULL))
      {
       free(pwin_name);
       pwin_name=NULL;
      }
      if (text_window)
      {
       if (message!=NULL)
        close_window(message,CLOSE_DEFAULT);
      }
      T_DEBUG_FUNCTION_POSITION(5)
      T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
      T_DEBUG_LEAVE
      return GENERIC_MEMORY_NOT_AVAILABLE;
     }
     adder=mfile->position;
     m_read(mfile,(T_PCHAR)&pbutton_art,sizeof(pbutton_art));
     if ((pbutton_art&HELP_BUTTON_TEXT)==HELP_BUTTON_TEXT)
     {
      m_read(mfile,(T_PCHAR)&len,sizeof(len));
      m_pread(mfile,&pbutton_extern_text,sizeof(T_CHAR)*len);
      button = make_text_button(pbutton_extern_text, pbutton_color1,pbutton_color2,pbutton_color3, pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_ENTER,SWITCH_ON_RELEASED);
     }
     if ((pbutton_art&HELP_BUTTON_SMALL_TEXT)==HELP_BUTTON_SMALL_TEXT)
     {
      m_read(mfile,(T_PCHAR)&len,sizeof(len));
      m_pread(mfile,&pbutton_extern_text,sizeof(T_CHAR)*len);
      button = make_small_text_button(pbutton_extern_text, pbutton_color1,pbutton_color2,pbutton_color3, pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_ENTER,SWITCH_ON_RELEASED);
     }
     if ((pbutton_art&HELP_BUTTON_PICTURE)==HELP_BUTTON_PICTURE)
     {
      MEM_BILD *pic;
      pic=(MEM_BILD*)(mfile->mem+mfile->position);
      mfile->position+=sizeof(MEM_BILD);
      pic->mem_zeiger=(T_PVOID)(mfile->mem+mfile->position);
      mfile->position+=(pic->x_size*pic->y_size);
      button = make_mem_bild_button(pic,default_back_pixel,pbutton_color3,      pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_ENTER,SWITCH_ON_RELEASED);
     }
     if (button==NULL)
     {
      MOUSE_ZEIGE
      t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new button!");
      font_now=font_save;
      free(new_help_button);
      if (current_path!=NULL)
      {
       change_directory(current_path);
       free(current_path);
      }
      pcx_set_file_color_flag=pcx_set_file_color_flag_old;
      if (mfile!=NULL)
      {
       free(mfile->mem);
       free(mfile);
       mfile=NULL;
      }
      if ((pwin_name!=NULL)&&(mfile==NULL))
      {
       free(pwin_name);
       pwin_name=NULL;
      }
      if (text_window)
       close_window(text_window,CLOSE_DEFAULT);
      T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
      T_DEBUG_FUNCTION_POSITION(6)
      T_DEBUG_LEAVE
      return T_NOT_OK;
     }
     if (pcenter_x==T_TRUE)
     {
      ppos_x=text_window->b/2-button->breite/2;
     }
     if (pcenter_y==T_TRUE)
     {
      ppos_y=text_window->h/2-button->hoehe/2;
     }
     if (pright==T_TRUE)
     {
      ppos_x=text_window->b-text_window->x_0-(button->breite+pwin_shade_width+2);
     }
     if (pleft==T_TRUE)
     {
      ppos_x=2;
     }
     if (pbottom==T_TRUE)
     {
      ppos_y=(text_window->h-text_window->y_0)-(button->hoehe+pwin_shade_width+2);
     }
     add_wbutton(text_window,button,ppos_x-x_start,ppos_y-y_start,pbutton_id);
     button->button_funktion=execute_help_button;
     ppos_x+=button->breite;
     new_help_button->button=button;
     *(BUTTON **)(mfile->mem+button_pos)=button;
     m_read(mfile,(T_PCHAR)&len,sizeof(len));
     m_pread(mfile,&pbutton_intern_text,sizeof(T_CHAR)*len);
     adder=mfile->position-adder;
     *(T_INT *)(mfile->mem+adder_pos)=adder;

     if ((pbutton_art&HELP_BUTTON_JUMP)==HELP_BUTTON_JUMP)
     {
      new_help_button->link=pbutton_intern_text;
      if (*pbutton_intern_text=='#')
      {
       new_help_button->line=atol(pbutton_intern_text+1);
      }
      else
      {
       T_INT sc=strlen(pbutton_intern_text);
       while ((sc>0)&&(*(pbutton_intern_text+sc)!='#')) sc--;
       if (sc==0)
       {
        // ERROR!!!
        new_help_button->line=0;
       }
       else
       {
        new_help_button->line=atol(pbutton_intern_text+sc+1);
       }
      }
     } // if ((pbutton_art&HELP_BUTTON_JUMP)==HELP_BUTTON_JUMP)
     else
      new_help_button->link=pbutton_intern_text;
     new_help_button->button_art=pbutton_art;
     new_help_button->button_id=((BUTTON_LISTEN_ELEMENT *)(text_window->button_last->objekt))->id;
     new_help_button->window_id=text_window->id;
     new_help_button->window=text_window;
     new_help_button->m_file=mfile;
     new_help_button->filename=strdup(filename);
     new_help_button->x_max=x_max;
     new_help_button->y_max=y_max;
     new_help_button->y_scroll=font_now->zeichen[' '].hoehe;
     new_help_button->x_scroll=font_now->zeichen[' '].breite;
     new_help_button->button=button;


     d_fuege_in_liste_ein( new_help_button, &help_button_liste_first, &help_button_liste_last, DL_HINTEN );
     if (ppos_y+button->hoehe>y_max)
     {
      y_max=ppos_y+button->hoehe;
     }
     pbutton_extern_text=NULL;
     pbutton_intern_text=NULL;
    } // if (mfile!=NULL)
    else if (handle_out!=NULL)
    {
     T_INT len,adder=0;
     BUTTON *button=NULL;
     fwrite(&button,sizeof(T_PVOID),1,handle_out);
     fwrite(&adder,sizeof(T_INT),1,handle_out);
     fwrite(&pbutton_art,sizeof(pbutton_art),1,handle_out);
     if ((pbutton_art&HELP_BUTTON_TEXT)==HELP_BUTTON_TEXT)
     {
      len=strlen(pbutton_extern_text)+1;
      fwrite(&len,sizeof(len),1,handle_out);
      fwrite(pbutton_extern_text,sizeof(T_CHAR),len,handle_out);
      button = make_text_button(pbutton_extern_text, pbutton_color1,pbutton_color2,pbutton_color3, pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_ENTER,SWITCH_ON_RELEASED);
     }
     if ((pbutton_art&HELP_BUTTON_SMALL_TEXT)==HELP_BUTTON_SMALL_TEXT)
     {
      len=strlen(pbutton_extern_text)+1;
      fwrite(&len,sizeof(len),1,handle_out);
      fwrite(pbutton_extern_text,sizeof(T_CHAR),len,handle_out);
      button = make_small_text_button(pbutton_extern_text, pbutton_color1,pbutton_color2,pbutton_color3, pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_ENTER,SWITCH_ON_RELEASED);
     }
     if ((pbutton_art&HELP_BUTTON_PICTURE)==HELP_BUTTON_PICTURE)
     {
      T_PCHAR current_path=NULL;
      if (pbutton_extern_text[1]!=':')
      {
       current_path=get_current_path();
       if (t_hilfe_pfad!=NULL)
        change_directory(t_hilfe_pfad);
      }
      button = make_bitmap_button(pbutton_extern_text,default_back_pixel,
      pbutton_color3,
      pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_ENTER,SWITCH_ON_RELEASED);
      fwrite(button->bitmap,sizeof(MEM_BILD),1,handle_out);
      fwrite(button->bitmap->mem_zeiger,button->bitmap->y_size*button->bitmap->x_size,1,handle_out);
      if (current_path!=NULL)
      {
       change_directory(current_path);
       free(current_path);
      }
     }
     ppos_x+=button->breite;
     if (ppos_x>x_max)
     {
      x_max=ppos_x;
     }
     if (button!=NULL)
     {
      free_button(button);
     }
     len=strlen(pbutton_intern_text)+1;
     fwrite(&len,sizeof(len),1,handle_out);
     fwrite(pbutton_intern_text,sizeof(T_CHAR),len,handle_out);
     free(pbutton_extern_text);
     free(pbutton_intern_text);
     pbutton_extern_text=NULL;
     pbutton_intern_text=NULL;
    } // if (handle_out!=NULL)
    break;
   }
   case H_BUTTON_COLOR_1:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pb1_color,sizeof(pb1_color[0])*4);
     m_pread(mfile,&pb1_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pb1_color,sizeof(pb1_color[0]),4,handle_out);
    }
    if (pb1_color[0]==1) // use color
    {
     pbutton_color1=pb1_color[1];
     if (mfile==NULL)
      free(pb1_color);
     break;
    }
    if (pb1_color[0]==3) // find rgb color
    {
     pbutton_color1=vesa_get_nearest_used_color(pb1_color[1],pb1_color[2],pb1_color[3]);
     if (mfile==NULL)
      free(pb1_color);
     break;
    }
    if (pb1_color[0]==4) // color set rgb to color and use color
    {
     pbutton_color1=pb1_color[1];
     vesa_set_dac_register(pb1_color[1],pb1_color[2],pb1_color[3],pb1_color[4]);
     if (mfile==NULL)
      free(pb1_color);
     break;
    }
   }
   case H_BUTTON_COLOR_2:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pb2_color,sizeof(pb2_color[0])*4);
     m_pread(mfile,&pb2_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pb2_color,sizeof(pb2_color[0]),4,handle_out);
    }
    if (pb2_color[0]==1) // use color
    {
     pbutton_color2=pb2_color[1];
     if (mfile==NULL)
      free(pb2_color);
     break;
    }
    if (pb2_color[0]==3) // find rgb color
    {
     pbutton_color2=vesa_get_nearest_used_color(pb2_color[1],pb2_color[2],pb2_color[3]);
     if (mfile==NULL)
      free(pb2_color);
     break;
    }
    if (pb2_color[0]==4) // color set rgb to color and use color
    {
     pbutton_color2=pb2_color[1];
     vesa_set_dac_register(pb2_color[1],pb2_color[2],pb2_color[3],pb2_color[4]);
     if (mfile==NULL)
      free(pb2_color);
     break;
    }
   }
   case H_BUTTON_COLOR_3:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pb3_color,sizeof(pb3_color[0])*4);
     m_pread(mfile,&pb3_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pb3_color,sizeof(pb3_color[0]),4,handle_out);
    }
    if (pb3_color[0]==1) // use color
    {
     pbutton_color3=pb3_color[1];
     if (mfile==NULL)
      free(pb3_color);
     break;
    }
    if (pb3_color[0]==3) // find rgb color
    {
     pbutton_color3=vesa_get_nearest_used_color(pb3_color[1],pb3_color[2],pb3_color[3]);
     if (mfile==NULL)
      free(pb3_color);
     break;
    }
    if (pb3_color[0]==4) // color set rgb to color and use color
    {
     pbutton_color3=pb3_color[1];
     vesa_set_dac_register(pb3_color[1],pb3_color[2],pb3_color[3],pb3_color[4]);
     if (mfile==NULL)
      free(pb3_color);
     break;
    }
   }
   case H_BUTTON_COLOR_4:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pb4_color,sizeof(pb4_color[0])*4);
     m_pread(mfile,&pb4_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pb4_color,sizeof(pb4_color[0]),4,handle_out);
    }
    if (pb4_color[0]==1) // use color
    {
     pbutton_color4=pb4_color[1];
     if (mfile==NULL)
      free(pb4_color);
     break;
    }
    if (pb4_color[0]==3) // find rgb color
    {
     pbutton_color4=vesa_get_nearest_used_color(pb4_color[1],pb4_color[2],pb4_color[3]);
     if (mfile==NULL)
      free(pb4_color);
     break;
    }
    if (pb4_color[0]==4) // color set rgb to color and use color
    {
     pbutton_color4=pb4_color[1];
     vesa_set_dac_register(pb4_color[1],pb4_color[2],pb4_color[3],pb4_color[4]);
     if (mfile==NULL)
      free(pb4_color);
     break;
    }
   }
   case H_BUTTON_COLOR_5:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pb5_color,sizeof(pb5_color[0])*4);
     m_pread(mfile,&pb5_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pb5_color,sizeof(pb5_color[0]),4,handle_out);
    }
    if (pb5_color[0]==1) // use color
    {
     pbutton_color5=pb5_color[1];
     if (mfile==NULL)
      free(pb5_color);
     break;
    }
    if (pb5_color[0]==3) // find rgb color
    {
     pbutton_color5=vesa_get_nearest_used_color(pb5_color[1],pb5_color[2],pb5_color[3]);
     if (mfile==NULL)
      free(pb5_color);
     break;
    }
    if (pb5_color[0]==4) // color set rgb to color and use color
    {
     pbutton_color5=pb5_color[1];
     vesa_set_dac_register(pb5_color[1],pb5_color[2],pb5_color[3],pb5_color[4]);
     if (mfile==NULL)
      free(pb5_color);
     break;
    }
   }
   case H_BUTTON_COLOR_6:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pb6_color,sizeof(pb6_color[0])*4);
     m_pread(mfile,&pb6_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pb6_color,sizeof(pb6_color[0]),4,handle_out);
    }
    if (pb6_color[0]==1) // use color
    {
     pbutton_color6=pb6_color[1];
     if (mfile==NULL)
      free(pb6_color);
     break;
    }
    if (pb6_color[0]==3) // find rgb color
    {
     pbutton_color6=vesa_get_nearest_used_color(pb6_color[1],pb6_color[2],pb6_color[3]);
     if (mfile==NULL)
      free(pb6_color);
     break;
    }
    if (pb6_color[0]==4) // color set rgb to color and use color
    {
     pbutton_color6=pb6_color[1];
     vesa_set_dac_register(pb6_color[1],pb6_color[2],pb6_color[3],pb6_color[4]);
     if (mfile==NULL)
      free(pb6_color);
     break;
    }
   }
   case H_PRINT_MODE:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pprint_mode,sizeof(pprint_mode));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pprint_mode,sizeof(pprint_mode),1,handle_out);
    }
    break;
   }
   case H_TEXT_MODE:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&ptext_mode,sizeof(ptext_mode));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&ptext_mode,sizeof(ptext_mode),1,handle_out);
    }
    break;
   }
   case H_WIN_SHADE_WIDTH:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pwin_shade_width,sizeof(pwin_shade_width));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pwin_shade_width,sizeof(pwin_shade_width),1,handle_out);
    }
    break;
   }
   case H_WIN_SHADE_COL1:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pw1_color,sizeof(pw1_color[0])*4);
     m_pread(mfile,&pw1_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pw1_color,sizeof(pw1_color[0]),4,handle_out);
    }
    if (pw1_color[0]==1) // use color
    {
     pwin_shade_col1=pw1_color[1];
     if (mfile==NULL)
      free(pw1_color);
     break;
    }
    if (pw1_color[0]==3) // find rgb color
    {
     pwin_shade_col1=vesa_get_nearest_used_color(pw1_color[1],pw1_color[2],pw1_color[3]);
     if (mfile==NULL)
      free(pw1_color);
     break;
    }
    if (pw1_color[0]==4) // color set rgb to color and use color
    {
     pwin_shade_col1=pw1_color[1];
     vesa_set_dac_register(pw1_color[1],pw1_color[2],pw1_color[3],pw1_color[4]);
     if (mfile==NULL)
      free(pw1_color);
     break;
    }
   }
   case H_WIN_SHADE_COL2:
   {
    if (mfile!=NULL)
    {
//     m_read(mfile,(T_PCHAR)pw2_color,sizeof(pw2_color[0])*4);
     m_pread(mfile,&pw2_color,sizeof(T_INT)*4);
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(pw2_color,sizeof(pw2_color[0]),4,handle_out);
    }
    if (pw2_color[0]==1) // use color
    {
     pwin_shade_col2=pw2_color[1];
     if (mfile==NULL)
      free(pw2_color);
     break;
    }
    if (pw2_color[0]==3) // find rgb color
    {
     pwin_shade_col2=vesa_get_nearest_used_color(pw2_color[1],pw2_color[2],pw2_color[3]);
     if (mfile==NULL)
      free(pw2_color);
     break;
    }
    if (pw2_color[0]==4) // color set rgb to color and use color
    {
     pwin_shade_col2=pw2_color[1];
     vesa_set_dac_register(pw2_color[1],pw2_color[2],pw2_color[3],pw2_color[4]);
     if (mfile==NULL)
      free(pw2_color);
     break;
    }
   }
   case H_ADD_X:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&padd_x,sizeof(padd_x));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&padd_x,sizeof(padd_x),1,handle_out);
    }
    ppos_x+=padd_x;
    if (ppos_x>x_max)
    {
     x_max=ppos_x;
    }
    break;
   }
   case H_ADD_Y:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&padd_y,sizeof(padd_y));
     ppos_y+=padd_y;
     break;
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&padd_y,sizeof(padd_y),1,handle_out);
     ppos_y+=padd_y;
    }
    break;
   }
   case H_SUB_X:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&psub_x,sizeof(psub_x));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&psub_x,sizeof(psub_x),1,handle_out);
    }
    ppos_x-=psub_x;
    if (ppos_x<0) ppos_x=0;
    break;
   }
   case H_SUB_Y:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&psub_y,sizeof(psub_y));
     ppos_y-=psub_y;
     if (ppos_y<0) ppos_y=0;
     break;
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&psub_y,sizeof(psub_y),1,handle_out);
     ppos_y-=psub_y;
     if (ppos_x<0) ppos_x=0;
    }
    break;
   }
   case H_RETURN:
   {
    ppos_x=2;
    ppos_y+=(font_now->zeichen[(T_BYTE)' '].hoehe);//len_y;
    if (ppos_y>y_max)
    {
     y_max=ppos_y;
    }
    break;
   }
   case H_WIN_CENTER_ON_MOUSE:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pwin_center,sizeof(pwin_center));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pwin_center,sizeof(pwin_center),1,handle_out);
    }
    break;
   }
   case H_FORCE_NO_SCROLL:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pforce_no_scroll,sizeof(pforce_no_scroll));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pforce_no_scroll,sizeof(pforce_no_scroll),1,handle_out);
    }
    break;
   }
   case H_FORCE_SCROLL:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pforce_scroll,sizeof(pforce_scroll));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pforce_scroll,sizeof(pforce_scroll),1,handle_out);
    }
    break;
   }
   case H_WIN_POP_UP:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&ppop_up,sizeof(ppop_up));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&ppop_up,sizeof(ppop_up),1,handle_out);
    }
    if (text_window)
    {
     show_message("Popup only recognized before window is drawn!");
     ppop_up=T_FALSE;
     break;
    }
    break;
   }
   case H_PICTURE:
   {
    T_INT h=0;
    if ((text_window==NULL)&&(handle_out==NULL))
    {
     show_message("Window not activated yet (trying to show a bitmap)!");
     break;
    }
    else
    {
     MEM_BILD *pic;
     T_PCHAR current_path=NULL;
     old_print_modus=vesa_print_modus;
     old_text=vesa_text;
     old_back_color=vesa_back_color;
     old_text_color=vesa_text_color;
     vesa_print_modus=pprint_mode;
     vesa_text=ptext_mode;
     vesa_back_color=pback_color;
     vesa_text_color=ptext_color;
     if (mfile!=NULL)
     {
      pic=(MEM_BILD*)(mfile->mem+mfile->position);
      mfile->position+=sizeof(MEM_BILD);
      pic->mem_zeiger=(T_PVOID)(mfile->mem+mfile->position);
      mfile->position+=(pic->x_size*pic->y_size);
      h=pic->y_size;
      if (pcenter_x==T_TRUE)
      {
       ppos_x=text_window->b/2-pic->x_size/2;
       if (ppos_x<=0) ppos_x=0;
      }
      if (pcenter_y==T_TRUE)
      {
       ppos_y=text_window->h/2-pic->y_size/2;
       if (ppos_y<=0) ppos_y=0;
      }
      if (pright==T_TRUE)
      {
       ppos_x=text_window->b-text_window->x_0-(pic->x_size+pwin_shade_width+2);
       if (ppos_x<=0) ppos_x=0;
      }
      if (pleft==T_TRUE)
      {
       ppos_x=2;
      }
      if (pbottom==T_TRUE)
      {
       ppos_y=(text_window->h-text_window->y_0)-(pic->y_size+pwin_shade_width+2);
       if (ppos_y<=0) ppos_y=0;
      }
      if (sb==NULL)
      {
       if (ppos_y+h>y_max)
       {
        y_max=ppos_y+h;
       }
       if (ppos_y-y_start<0)
       {
        // picture starts above window
        if (ppos_y-y_start+pic->y_size<0)
        {
         // do nothing, whole pic is above window
        }
        else
        {
         // draw bottom part (or middle part) of pic
         if (ppos_y-y_start+pic->y_size>text_window->h_open)
         {
          // draw middle part
          print_mem_teilbild(pic,
          text_window->x+text_window->x_0+ppos_x,
          text_window->y+text_window->y_0,
          0,-(ppos_y-y_start+pic->y_size),
          text_window->b_open-(ppos_x-x_start),
          text_window->h_open-(ppos_y-y_start));
         }
         else
         {
          // draw bottom part
          print_mem_teilbild(pic,text_window->x+text_window->x_0+ppos_x,
          text_window->y+text_window->y_0,
          0,-(ppos_y-y_start+pic->y_size),
          text_window->b_open-(ppos_x-x_start),
          text_window->h_open-(ppos_y-y_start));
         }
        }
       }
       else
       {
        // picture starts below start of window
        if (ppos_y-y_start>text_window->h_open)
        {
         // whole picture below window
        }
        else
        if (ppos_y-y_start+pic->y_size>text_window->h_open)
        {
         // only upper part of pic
         print_mem_teilbild(
         pic,
         text_window->x+text_window->x_0+ppos_x,
         text_window->y+text_window->y_0+ppos_y-y_start,
         0,
         0,
         text_window->b_open-(ppos_x-x_start),
         text_window->h_open-(ppos_y-y_start));
        }
        else
        {
         // whole y length of pic
         print_mem_teilbild(pic,text_window->x+text_window->x_0+ppos_x,text_window->y+text_window->y_0+ppos_y-y_start,
         0,0,
         text_window->b_open-(ppos_x-x_start),
         text_window->h_open-(ppos_y-y_start));
        }
       }
      } //if (sb==NULL)
      else
      {
       static T_INT x_o;
       static T_INT y_o;
       static T_INT x;
       static T_INT y;
       static T_INT x_len;
       static T_INT y_len;

       x_o = ppos_x<x_ausgabe_start ? x_ausgabe_start-ppos_x:0;
       y_o = ppos_y<y_ausgabe_start ? y_ausgabe_start-ppos_y:0;
       x= ppos_x+x_o;
       y= ppos_y+y_o;
       x_len=x_ausgabe_end-x;
       y_len=y_ausgabe_end-y;

       if ((x_len>0)&&(y_len>0))
        print_mem_teilbild(pic,WX(x),WY(y),x_o,y_o,x_len,y_len);
      } // else if (sb==NULL)
     }
     else if (handle_out!=NULL)
     {
      if (ppic[1]!=':')
      {
       current_path=get_current_path();
       if (t_hilfe_pfad!=NULL)
        change_directory(t_hilfe_pfad);
      }
      pic=lade_pcx_nach_mem(ppic,NO_HD);
      if (current_path!=NULL)
      {
       change_directory(current_path);
       free(current_path);
      }
      if (pic==NULL)
      {
       show_message("Couldn't locate picture file:\"%s\"!",ppic);
       free(ppic);
       ppic=NULL;
       vesa_print_modus=old_print_modus;
       vesa_text=old_text;
       vesa_back_color=old_back_color;
       vesa_text_color=old_text_color;
       break;
      }
      h=pic->y_size;
      if (sb==NULL)
      {
       if (ppos_x+pic->x_size>x_max)
       {
        x_max=ppos_x+pic->x_size;
       }
       if (ppos_y+h>y_max)
       {
        y_max=ppos_y+h;
       }
      }
      fwrite(pic,sizeof(MEM_BILD),1,handle_out);
      fwrite(pic->mem_zeiger,pic->y_size*pic->x_size,1,handle_out);
      free_mem_bild(pic);
     }
     free(ppic);
     ppic=NULL;
    }
    vesa_print_modus=old_print_modus;
    vesa_text=old_text;
    vesa_back_color=old_back_color;
    vesa_text_color=old_text_color;
//    ppos_y+=h; // wegen kleinen Bildern, diese sollen in der entsprechenden Zeile
                 // zwischen dem Text angezeigt werden koennen
    break;
   }
   case H_SET_FONT:
   {
    T_PCHAR current_path=NULL;
    if (mfile!=NULL)
    {
     T_INT len;
     T_INT i;
     m_read(mfile,(T_PCHAR)&help_font,sizeof(help_font));
     len=0;
     for (i=0;i<256;i++)
     {
      if (help_font.zeichen[i].breite!=0)
      {
       help_font.zeichen[i].zeiger=mfile->mem+mfile->position+len;
       len+=(help_font.zeichen[i].breite*help_font.zeichen[i].hoehe);
      }
      else
      {
       help_font.zeichen[i].zeiger=NULL;
      }
     }
     mfile->position+=len;
     font_now=&help_font;
    }
    else
    {
     if (pfont[1]!=':')
     {
      current_path=get_current_path();
      if (tool_pfad!=NULL)
       change_directory(tool_pfad);
     }
     if (help_font_loaded==T_TRUE)
     {
      vesa_free_font(&help_font);
      help_font_loaded=T_FALSE;
     }
     if (vesa_load_font(pfont,&help_font)!=T_OK)
     {
      show_message("Couldn't find Font:\"%s\"!",pfont);
      free(pfont);
      if (current_path!=NULL)
      {
       change_directory(current_path);
       free(current_path);
      }
      break;
     }
     font_now=&help_font;
     help_font_loaded=T_TRUE;
     if (current_path!=NULL)
     {
      change_directory(current_path);
      free(current_path);
     }
     free(pfont);
     if (handle_out!=NULL)
     {
      T_INT i;
      fwrite(&help_font,sizeof(help_font),1,handle_out);
      for (i=0;i<256;i++)
      {
       if (help_font.zeichen[i].breite!=0)
       {
        fwrite(help_font.zeichen[i].zeiger,help_font.zeichen[i].breite*help_font.zeichen[i].hoehe,1,handle_out);
       }
      }
     }
    }
    break;
   }
   case H_LEFT_FORMAT:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pleft_format,sizeof(pleft_format));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pleft_format,sizeof(pleft_format),1,handle_out);
    }
    break;
   }
   case H_RIGHT_FORMAT:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pright_format,sizeof(pright_format));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pright_format,sizeof(pright_format),1,handle_out);
    }
    if (pright_format>x_max)
    {
     x_max=pright_format;
    }
    break;
   }
   case H_WIN_NAME:
   {
    if (mfile!=NULL)
    {
     T_INT len;
     m_read(mfile,(T_PCHAR)&len,sizeof(len));
     m_pread(mfile,&pwin_name,sizeof(T_CHAR)*len);
    }
    else
    if (handle_out!=NULL)
    {
     T_INT len=strlen(pwin_name)+1;
     fwrite(&len,sizeof(T_INT),1,handle_out);
     fwrite(pwin_name,sizeof(T_CHAR),len,handle_out);
    }
    break;
   }
   case H_WIN_WITH_NAME:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pwin_with_name,sizeof(pwin_with_name));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pwin_with_name,sizeof(pwin_with_name),1,handle_out);
    }
    break;
   }
   case H_ALLOW_COLOR_SETTING:
   {
    if (mfile!=NULL)
    {
     m_read(mfile,(T_PCHAR)&pallow_color_setting,sizeof(pallow_color_setting));
    }
    else
    if (handle_out!=NULL)
    {
     fwrite(&pallow_color_setting,sizeof(pallow_color_setting),1,handle_out);
    }
    pcx_set_file_color_flag=pallow_color_setting;
    break;
   }
   default:
   {
    break;
   }
  }
 }
 font_now=font_save;
 if (current_path!=NULL)
 {
  change_directory(current_path);
  free(current_path);
 }
 if (handle_out!=NULL)
 {
  pcx_set_file_color_flag=pcx_set_file_color_flag_old;
  if ((pwin_name!=NULL)&&(mfile==NULL))
  {
   free(pwin_name);
   pwin_name=NULL;
  }
  if (help_font_loaded==T_TRUE)
  {
   vesa_free_font(&help_font);
   help_font_loaded=T_FALSE;
  }
  if (help_file!=NULL)
   p_close_parse( &help_file );
  if (message!=NULL)
   close_window(message,CLOSE_DEFAULT);

  read_status=H_PARSE_END;
  fwrite(&read_status,sizeof(read_status),1,handle_out);

  fwrite(&x_max,sizeof(x_max),1,handle_out);
  fwrite(&y_max,sizeof(y_max),1,handle_out);
  fclose(handle_out);
  help_function(filename, NULL);
 } // if (handle_out!=NULL)
 else
 {
  if (sb==NULL)
  {
   T_LISTE *button_liste=text_window->button_first;
   BUTTON_LISTEN_ELEMENT *button_element=NULL;
   HELP_BUTTON *new_help_button;
   BUTTON *pbutton;
   BUTTON *button=NULL;
   T_INT remember_x=text_window->b-text_window->border_r;
   T_INT remember_y=text_window->y_0;
   m_read(mfile,(T_PCHAR)&x_max,sizeof(x_max));
   m_read(mfile,(T_PCHAR)&y_max,sizeof(y_max));
   if (ppop_up==T_TRUE)
   {
    pforce_no_scroll=H_SCROLL_Y+H_SCROLL_X;
    pforce_scroll=0;
   }
   if (((y_max>text_window->h_open)&&(!(pforce_no_scroll&H_SCROLL_Y)))||(pforce_scroll&H_SCROLL_Y))
   {
    new_help_button=(HELP_BUTTON *) malloc (sizeof(HELP_BUTTON));
    if (new_help_button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(9)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    button = make_mem_bild_button(runter,default_back_pixel,pbutton_color3,pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_DOWN,SWITCH_ON_PRESSED);
    if (button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(10)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    while(button_liste)
    {
     BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     pbutton=be->button;
     if (be->y_offset<text_window->y_0)
     {
      if (remember_x>be->x_offset)
      {
       remember_x=be->x_offset;
       remember_y=be->y_offset;
      }
     }
     button_liste=button_liste->naechstes;
    } //while(button_liste)
    button_raw=T_TRUE;
    add_wbutton(text_window,button,remember_x-(2*2+default_button_size+2),remember_y,pbutton_id);
    button_raw=T_FALSE;
    button->button_funktion=execute_help_button;
    new_help_button->window=text_window;
    new_help_button->button=button;
    new_help_button->link=NULL;
    new_help_button->line=0;
    new_help_button->button_art=HELP_BUTTON_DOWN;
    new_help_button->button_id=((BUTTON_LISTEN_ELEMENT *)(text_window->button_last->objekt))->id;
    new_help_button->window_id=text_window->id;
    new_help_button->m_file=mfile;
    new_help_button->filename=strdup(filename);
    new_help_button->x_max=x_max;
    new_help_button->y_max=y_max;
    new_help_button->y_scroll=font_now->zeichen[' '].hoehe;
    new_help_button->x_scroll=font_now->zeichen[' '].breite;
    d_fuege_in_liste_ein( new_help_button, &help_button_liste_first, &help_button_liste_last, DL_HINTEN );

    button_liste=text_window->button_first;
    while (button_liste!=NULL)
    {
     if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
     {
      button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     }
     button_liste=button_liste->naechstes;
    }
    if (button_element==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(11)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    else
     new_help_button->button_element=button_element;
    button_liste=text_window->button_first;
    new_help_button=(HELP_BUTTON *) malloc (sizeof(HELP_BUTTON));
    if (new_help_button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(12)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    button = make_mem_bild_button(hoch,default_back_pixel,pbutton_color3,pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_UP,SWITCH_ON_PRESSED);
    if (button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(13)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    while(button_liste)
    {
     BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     pbutton=be->button;
     if (be->y_offset<text_window->y_0)
     {
      if (remember_x>be->x_offset)
      {
       remember_x=be->x_offset;
       remember_y=be->y_offset;
      }
     }
     button_liste=button_liste->naechstes;
    } //while(button_liste)
    button_raw=T_TRUE;
    add_wbutton(text_window,button,remember_x-(2*2+default_button_size+2),remember_y,pbutton_id);
    button_raw=T_FALSE;
    button->button_funktion=execute_help_button;
    new_help_button->window=text_window;
    new_help_button->button=button;
    new_help_button->link=NULL;
    new_help_button->line=0;
    new_help_button->button_art=HELP_BUTTON_UP;
    new_help_button->button_id=((BUTTON_LISTEN_ELEMENT *)(text_window->button_last->objekt))->id;
    new_help_button->window_id=text_window->id;
    new_help_button->m_file=mfile;
    new_help_button->filename=strdup(filename);
    new_help_button->x_max=x_max;
    new_help_button->y_max=y_max;
    new_help_button->y_scroll=font_now->zeichen[' '].hoehe;
    new_help_button->x_scroll=font_now->zeichen[' '].breite;
    d_fuege_in_liste_ein( new_help_button, &help_button_liste_first, &help_button_liste_last, DL_HINTEN );
    button_liste=text_window->button_first;
    while (button_liste!=NULL)
    {
     if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
     {
      button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     }
     button_liste=button_liste->naechstes;
    }
    if (button_element==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(14)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    else
     new_help_button->button_element=button_element;
    button_liste=text_window->button_first;
    new_help_button=(HELP_BUTTON *) malloc (sizeof(HELP_BUTTON));
    if (new_help_button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(12)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    button = make_mem_bild_button(drunter,default_back_pixel,pbutton_color3,pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_PGDN,SWITCH_ON_RELEASED);
    if (button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(13)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    while(button_liste)
    {
     BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     pbutton=be->button;
     if (be->y_offset<text_window->y_0)
     {
      if (remember_x>be->x_offset)
      {
       remember_x=be->x_offset;
       remember_y=be->y_offset;
      }
     }
     button_liste=button_liste->naechstes;
    } //while(button_liste)
    button_raw=T_TRUE;
    add_wbutton(text_window,button,remember_x-(2*2+default_button_size+2),remember_y,pbutton_id);
    button_raw=T_FALSE;
    button->button_funktion=execute_help_button;
    new_help_button->window=text_window;
    new_help_button->button=button;
    new_help_button->line=0;
    new_help_button->link=NULL;
    new_help_button->button_art=HELP_BUTTON_PAGE_DOWN;
    new_help_button->button_id=((BUTTON_LISTEN_ELEMENT *)(text_window->button_last->objekt))->id;
    new_help_button->window_id=text_window->id;
    new_help_button->m_file=mfile;
    new_help_button->filename=strdup(filename);
    new_help_button->x_max=x_max;
    new_help_button->y_max=y_max;
    new_help_button->y_scroll=font_now->zeichen[' '].hoehe;
    new_help_button->x_scroll=font_now->zeichen[' '].breite;
    d_fuege_in_liste_ein( new_help_button, &help_button_liste_first, &help_button_liste_last, DL_HINTEN );
    button_liste=text_window->button_first;
    while (button_liste!=NULL)
    {
     if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
     {
      button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     }
     button_liste=button_liste->naechstes;
    }
    if (button_element==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(14)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    else
     new_help_button->button_element=button_element;

    button_liste=text_window->button_first;
    new_help_button=(HELP_BUTTON *) malloc (sizeof(HELP_BUTTON));
    if (new_help_button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(15)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    button = make_mem_bild_button(dhoch,default_back_pixel,pbutton_color3,pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_PGUP,SWITCH_ON_RELEASED);
    if (button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(16)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    while(button_liste)
    {
     BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     pbutton=be->button;
     if (be->y_offset<text_window->y_0)
     {
      if (remember_x>be->x_offset)
      {
       remember_x=be->x_offset;
       remember_y=be->y_offset;
      }
     }
     button_liste=button_liste->naechstes;
    } //while(button_liste)
    button_raw=T_TRUE;
    add_wbutton(text_window,button,remember_x-(2*2+default_button_size+2),remember_y,pbutton_id);
    button_raw=T_FALSE;
    button->button_funktion=execute_help_button;
    new_help_button->window=text_window;
    new_help_button->button=button;
    new_help_button->line=0;
    new_help_button->link=NULL;
    new_help_button->button_art=HELP_BUTTON_PAGE_UP;
    new_help_button->button_id=((BUTTON_LISTEN_ELEMENT *)(text_window->button_last->objekt))->id;
    new_help_button->window_id=text_window->id;
    new_help_button->m_file=mfile;
    new_help_button->filename=strdup(filename);
    new_help_button->x_max=x_max;
    new_help_button->y_max=y_max;
    new_help_button->y_scroll=font_now->zeichen[' '].hoehe;
    new_help_button->x_scroll=font_now->zeichen[' '].breite;
    d_fuege_in_liste_ein( new_help_button, &help_button_liste_first, &help_button_liste_last, DL_HINTEN );
    button_liste=text_window->button_first;
    while (button_liste!=NULL)
    {
     if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
     {
      button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     }
     button_liste=button_liste->naechstes;
    }
    if (button_element==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(17)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    else
     new_help_button->button_element=button_element;
   } // if (y_max>text_window->h_open)
   if (((x_max>text_window->b_open)&&(!(pforce_no_scroll&H_SCROLL_X)))||(pforce_scroll&H_SCROLL_X))
//   if (x_max>text_window->b_open)
   {
    button_liste=text_window->button_first;
    new_help_button=(HELP_BUTTON *) malloc (sizeof(HELP_BUTTON));
    if (new_help_button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(21)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    button = make_mem_bild_button(right,default_back_pixel,pbutton_color3,pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_RIGHT,SWITCH_ON_PRESSED);
    if (button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(22)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    while(button_liste)
    {
     BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     pbutton=be->button;
     if (be->y_offset<text_window->y_0)
     {
      if (remember_x>be->x_offset)
      {
       remember_x=be->x_offset;
       remember_y=be->y_offset;
      }
     }
     button_liste=button_liste->naechstes;
    } //while(button_liste)
    button_raw=T_TRUE;
    add_wbutton(text_window,button,remember_x-(2*2+default_button_size+2),remember_y,pbutton_id);
    button_raw=T_FALSE;
    button->button_funktion=execute_help_button;
    new_help_button->window=text_window;
    new_help_button->button=button;
    new_help_button->line=0;
    new_help_button->link=NULL;
    new_help_button->button_art=HELP_BUTTON_RIGHT;
    new_help_button->button_id=((BUTTON_LISTEN_ELEMENT *)(text_window->button_last->objekt))->id;
    new_help_button->window_id=text_window->id;
    new_help_button->m_file=mfile;
    new_help_button->filename=strdup(filename);
    new_help_button->x_max=x_max;
    new_help_button->y_max=y_max;
    new_help_button->y_scroll=font_now->zeichen[' '].hoehe;
    new_help_button->x_scroll=font_now->zeichen[' '].breite;
    d_fuege_in_liste_ein( new_help_button, &help_button_liste_first, &help_button_liste_last, DL_HINTEN );
    button_liste=text_window->button_first;
    while (button_liste!=NULL)
    {
     if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
     {
      button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     }
     button_liste=button_liste->naechstes;
    }
    if (button_element==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(23)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    else
     new_help_button->button_element=button_element;

    button_liste=text_window->button_first;
    new_help_button=(HELP_BUTTON *) malloc (sizeof(HELP_BUTTON));
    if (new_help_button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(18)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    button = make_mem_bild_button(left,default_back_pixel,pbutton_color3,pbutton_color4,pbutton_color5,pbutton_color6,2,KEY_LEFT,SWITCH_ON_PRESSED);
    if (button==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(19)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    while(button_liste)
    {
     BUTTON_LISTEN_ELEMENT *be=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     pbutton=be->button;
     if (be->y_offset<text_window->y_0)
     {
      if (remember_x>be->x_offset)
      {
       remember_x=be->x_offset;
       remember_y=be->y_offset;
      }
     }
     button_liste=button_liste->naechstes;
    } //while(button_liste)
    button_raw=T_TRUE;
    add_wbutton(text_window,button,remember_x-(2*2+default_button_size+2),remember_y,pbutton_id);
    button_raw=T_FALSE;
    button->button_funktion=execute_help_button;
    new_help_button->window=text_window;
    new_help_button->button=button;
    new_help_button->line=0;
    new_help_button->link=NULL;
    new_help_button->button_art=HELP_BUTTON_LEFT;
    new_help_button->button_id=((BUTTON_LISTEN_ELEMENT *)(text_window->button_last->objekt))->id;
    new_help_button->window_id=text_window->id;
    new_help_button->m_file=mfile;
    new_help_button->filename=strdup(filename);
    new_help_button->x_max=x_max;
    new_help_button->y_max=y_max;
    new_help_button->y_scroll=font_now->zeichen[' '].hoehe;
    new_help_button->x_scroll=font_now->zeichen[' '].breite;
    d_fuege_in_liste_ein( new_help_button, &help_button_liste_first, &help_button_liste_last, DL_HINTEN );
    button_liste=text_window->button_first;
    while (button_liste!=NULL)
    {
     if (((BUTTON_LISTEN_ELEMENT *)button_liste->objekt)->button==button)
     {
      button_element=(BUTTON_LISTEN_ELEMENT *)button_liste->objekt;
     }
     button_liste=button_liste->naechstes;
    }
    if (button_element==NULL)
    {
     MOUSE_ZEIGE
     t_printf(E_VERBOSE_STANDARD,"\nCouldn't create new scroll button!");
     T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CREATION_FAILED)
     T_DEBUG_FUNCTION_POSITION(20)
     T_DEBUG_LEAVE
     return T_NOT_OK;
    }
    else
     new_help_button->button_element=button_element;
   } // if (x_max>text_window->b_open)
  }// sb==NULL
  if (ppop_up==T_TRUE)
  {
   while (vesa_mouse_button)
    vesa_mouse_update();
   close_window(text_window,CLOSE_DEFAULT);
  }
 }
 MOUSE_ZEIGE
 T_DEBUG_LEAVE
 return T_OK;
}

T_INT number_help(T_PCHAR word, T_INT radix)
{
 T_ULONG number;
 T_CHAR bin[129];
 T_PCHAR current_path=NULL;
 FILE *handle;
 T_DEBUG_ENTRY("number_help",75)
 number=convert(word,radix);
 if (number==0)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_OK;
 }
 current_path=get_current_path();
 if (t_hilfe_pfad!=NULL)
  change_directory(t_hilfe_pfad);
 handle=fopen("tmp.hlf","wt");
 if (handle==NULL)
 {
  if (current_path!=NULL)
  {
   change_directory(current_path);
   free(current_path);
  }
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_OK;
 }
 fprintf(handle,"WIN_SIZE_X 260\n");
 if (number<256)
  fprintf(handle,"WIN_SIZE_Y 84\n");
 else
  fprintf(handle,"WIN_SIZE_Y 52\n");
 fprintf(handle,"WIN_WITH_NAME 0\n");
 fprintf(handle,"WIN_CENTER_ON_MOUSE 1\n");
 fprintf(handle,"WIN_POP_UP 1\n");
 fprintf(handle,"WIN_SHADE_WIDTH 2\n");
 fprintf(handle,"DRAW_NOW\n");
 fprintf(handle,"POS_Y 2\n");
 fprintf(handle,"POS_X 2\n");
 fprintf(handle,"TEXT \"DEC: %i\" RETURN\n",number);
 fprintf(handle,"TEXT \"HEX: %Xh\" RETURN\n",number);
 fprintf(handle,"TEXT \"BIN: %sb\" RETURN\n",itob(number,bin));
#ifdef VECTREX
 if (number<256)
 {
  fprintf(handle,"TEXT \"ASC : '%c'\" RETURN\n",(T_CHAR)number);
  fprintf(handle,"TEXT \"6809: '%s'\" RETURN\n",as6809Dis[number].acInstruction);
 }
#endif
 fclose(handle);
 if (current_path!=NULL)
 {
  change_directory(current_path);
  free(current_path);
 }
 no_process_window=T_TRUE;
 help_function("tmp.hlf",NULL);
 no_process_window=T_FALSE;
 unlink((const T_PCHAR )"tmp.hlf");
 unlink((const T_PCHAR )"tmp.cmp");
 T_DEBUG_LEAVE
 return T_OK;
}

T_INT word_help(T_PCHAR word,T_LISTE *help_word_erste)
{
 T_INT i;
 T_LISTE *liste=help_word_erste;
 T_DEBUG_ENTRY("word_help",75)

 if ((word==NULL)||(help_word_erste==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 i=0;
 while (*(word+i)!=(T_CHAR)0)
 {
  *(word+i)=toupper(*(word+i));
  i++;
 }
 i=0;
 while (liste!=NULL)
 {
  HELP_WORD *help_word=(HELP_WORD *)liste->objekt;
  if (strcmp(word,help_word->keyword)==0)
  {
   help_function(help_word->help_name,NULL);
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_OK;
  }
  i++;
  liste=liste->naechstes;
 }
 T_DEBUG_LEAVE
 return T_NOT_OK;
}

T_VOID help_key_function(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window;
 HELP_BUTTON *help_button=NULL;
 T_LISTE *help=help_button_liste_first;
 T_DEBUG_ENTRY("help_key_function",75)
 if (parameter==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nUngueltiger Parameter in help_key_function()!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 if (window==NULL)
 {
  t_printf(E_VERBOSE_STANDARD,"\nIch kann mich nicht finden help_key_function()!");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return;
 }
 if ((window->hide>0)||(window->dhide>0))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 while (help)
 {
  help_button=(HELP_BUTTON *)help->objekt;
  if (help_button->window==window)
  {
   break;
  }
  else
   help_button=NULL;
  help=help->naechstes;
 }
 if (help_button==NULL)
 {
  T_DEBUG_SET_THIS_FUNCTION_ERROR(HELP_BUTTON_CANT_FIND_MYSELF)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 /* OK, from here on execute the button, now we know what to do! */

 switch (parameter->taste)
 {
  case KEY_p:
  {
   parameter->executed=PARAMETER_EXECUTED;
   t_printf(0,"\ny_start=%i",*(T_INT *)(help_button->m_file->mem+1*sizeof(T_INT)));
   break;
  }
 }

 T_DEBUG_LEAVE
}
