#define MAX_LINE_LEN 1024
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>

#include "error.h"
#include "standard.h"
#include "parser.h"
#include "file.h"
#include "tool.h"


/*********************************************/
/* TO DO
   - line closes input TRUE/FALSE
   - abschnittsweise andere parser zulassen
     bzw datei abschnittsweise parsen, mit
     parse-end symbol
   - #defines und #includes
*/
/*******************************************/
# define TYPE_STRUKT          T_PVOID

/* moegliche eigenschaften von zeichen innerhalb eines 8 BIT Codes */
/* diese eigenschaften werden ge'oder't, es kann also ein zeichen  */
/* verschiedene eigenschaften haben */
# define P_INVALID            ( ( T_INT )     1 ) /* ungueltiges zeichen, wird nicht beachtet */
# define P_ALPHA              ( ( T_INT )     2 ) /* alpha zeichen (normal 'A'-'Z', 'a'-'z' */
# define P_NUMERIC            ( ( T_INT )     4 ) /* numerische zeichen '-', '0'-'9' */
# define P_REMARK             ( ( T_INT )     8 ) /* bemerkung, REST der Zeile wird nicht beachtet (keine Klammerung) */
# define P_SEPERATOR          ( ( T_INT )    16 ) /* Trennsymbol, zwischen zwei feldern (eigentlich gleich zu p_invalid */
# define P_LINE_SEPERATOR     ( ( T_INT )    32 ) /* normaler weise \n ,bzw 13, Carriage Return */
# define P_CHAR_BRACKET       ( ( T_INT )    64 ) /* Zeichen Klammer, (') */
# define P_STRING_BRACKET     ( ( T_INT )   128 ) /* Zeichenkettenklammer (") */
# define P_INVOKE_RAW         ( ( T_INT )   256 ) /* Um Zeichen 'geschickter eingeben zu koennen, wenn gerade kein Hex-editor vorhanden ist */
# define P_STRING_END         ( ( T_INT )   512 ) /* Abschlusszeichen eines Strings, in 'C' 0 */
# define P_CONTINUE_NEXT_LINE ( ( T_INT )  1024 ) /* weiterfuehrung, der aktuellen daten in der naechsten zeile */
# define P_NOT_DEFINED_YET2   ( ( T_INT )  2048 )
# define P_NOT_DEFINED_YET3   ( ( T_INT )  4096 )
# define P_NOT_DEFINED_YET4   ( ( T_INT )  4096 )
# define P_NOT_DEFINED_YET5   ( ( T_INT )  8192 )
# define P_NOT_DEFINED_YET6   ( ( T_INT ) 16384 )
# define P_NOT_DEFINED_YET7   ( ( T_INT ) 32768 )
# define P_ALPHA_NUMERIC      ( P_ALPHA | P_NUMERIC )

/* sonstige defines */
# define P_NO_EVENT 0         /* interne defines, ob beim scannen etwas passiert ist */
# define P_NEW_LINE 1         /* wie z.B. neue Zeile angefangen */
# define P_START_UNIT_LEN (1024) /* default laenge eines gelesenen wortes (wird nach einlesen gestutzt), erhoert sich automatisch, sollte ein datenfeld laenger werden */
                              /* vorsicht, bei MS-DOS, es wird nicht auf 64K Grenze geprueft */
# define P_C_END_CHAR 0       /* endzeichen von strings der sprache 'C' */


/**************************************************/
/* Locale Funktionen                              */
/**************************************************/
T_VOID p_warning( T_PCHAR message, T_INT verbosity );
T_INT p_test_number( T_PCHAR string );
T_SINT p_atois( T_PCHAR string );
T_UINT p_atoiu( T_PCHAR string );
T_INT p_make_big( T_PCHAR string );
T_INT p_strlen( T_PCHAR var_name );
T_INT p_sizeof(T_INT type);

T_INT p_read_next_byte( M_PFILE handle, T_PUCHAR byte, T_PINT status );
T_INT p_read_next_char( M_PFILE handle, T_PUCHAR byte, T_PINT status,  T_INT raw_mode  );
T_INT p_read_next_numeric( M_PFILE handle, T_PCHAR *string, T_PINT status );
T_INT p_read_next_numeric_line( M_PFILE handle, T_PCHAR *string, T_PINT status );
T_INT p_read_next_sign( M_PFILE handle, T_PCHAR word_read, T_PINT status );
T_INT p_read_next_string( M_PFILE handle, T_PCHAR *string, T_PINT status , T_PINT len);
T_INT p_discard_rest_of_line( M_PFILE handle );

T_INT p_get_type_word( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_uword( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_sword( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_long( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_ulong( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_slong( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_int( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_uint( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_sint( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_char( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_uchar( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_schar( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_string( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_strukt( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_list( T_PVOID return_value, M_PFILE handle );
T_INT p_get_type_la_int( T_PVOID return_value, M_PFILE handle );

T_INT p_get_value( T_INT type, T_PVOID return_value, M_PFILE handle );
T_INT p_pre_pro_parse(T_PCHAR filename, M_PFILE *handle);
T_VOID replace(T_PCHAR line, T_PCHAR define, T_PCHAR value);
T_INT no_spaces(T_PCHAR line);
T_INT m_read(M_PFILE mfile, T_PCHAR dest, T_INT size);

signed long int get_zahl(char *string);
signed int pruef(char *string);

/**************************************************/
/* Globale Variablen                              */
/**************************************************/
T_INT parse_error                 = T_OK;    /* wird beim aufruf JEDER funktion gesetzt */
T_INT p_capitalise                = T_TRUE;  /* alle vergleiche NUR in grossen ASCII */
T_INT p_alloc_pointer             = T_FALSE; /* sollen pointer alloziiert werden, oder ist der benoetigte platz schon vorhanden */
                                             /* bei listen wird immer alloziiert */
T_INT p_include_brackets          = T_FALSE; /* sollen bei z.B. Strings die anfuehrungszeichen mit uebergeben werden */
T_INT p_smart_strings             = T_FALSE; /* dann keine string brackets bei uebergabe */
T_INT p_switch_to_c_end_char      = T_TRUE;  /* string abschluss immer mit '0', statt mit end_of_string_T_PCHAR */
T_INT p_allways_ignore_end_of_line= T_FALSE; /* not implemented yet */
T_INT p_verbosity                 = 0;       /* globale einstellung */
T_INT p_delete_temp               = T_TRUE;


/**************************************************/
/* Modul-globale Variablen                        */
/**************************************************/
PARSER_WORD *word                 = NULL;
T_INT p_string_end_char           = 0;       /* wird bei init neu belegt, mit dem wert, der als erstes in der char_tabelle gefunden wird */
T_INT p_line_counter              = 0;       /* globaler zaehler */
T_INT p_pos_counter               = 0;       /* globaler zaehler */
T_INT p_is_parsing                = T_FALSE; /* well... */

#include "valid_st.i"                        /* hier stehen die Definitionen fuer die Zeichenbedeutungen */

/*
*********************************************************************
*/
/*
  initialisiert den parser, sollte vor p_parse() aufgerufen werden
*/
T_INT p_parse_init( T_VOID )
{
 T_INT counter;
 p_line_counter = 0;
 p_pos_counter = 0;
 p_is_parsing = T_FALSE;
 T_DEBUG_ENTRY("p_parse_init",45)
 for ( counter = 0; counter < 256;counter++ )
 {
  if ( ( p_char_type[ counter ] & P_STRING_END ) == P_STRING_END )
  {
   p_string_end_char = counter;
   break;
  }
 }
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
*********************************************************************
*/
/*
  globale funktion, diese wird aufgerufen, wenn eine datei geparst werden soll
*/
T_INT p_parse( T_PCHAR filename, PARSER_WORD *word )
{
 M_PFILE handle;
 T_PCHAR var_name;
 T_INT status = T_OK;
 T_INT i;
 T_INT len;
 T_DEBUG_ENTRY("p_parse",45)
 p_is_parsing = T_TRUE;
 if (f_file_exist(filename)==T_FALSE)
 {
  p_is_parsing = T_FALSE;
  parse_error = FILE_OPEN_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if (p_pre_pro_parse(filename,&handle)!=T_OK)
 {
  p_is_parsing = T_FALSE;
  parse_error = PARSE_PRE_PROCESS_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PRE_PROCESS_ERROR)
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_capitalise == T_TRUE )
 {
  for ( i = 0; word[i].type != PARSER_TYPE_END; i++ )
  {
   p_make_big( word[ i ].text );
  }
 }
 while ( p_read_next_string( handle, &var_name, &status, &len ) != PARSE_FILE_END )
 {
  if ( p_capitalise == T_TRUE )
  {
   p_make_big( var_name );
  }
  for ( i = 0; word[i].type != PARSER_TYPE_END; i++ )
  {
   if ( strncmp(var_name, word[ i ].text, T_MAX( len, strlen( word[ i ].text ) ) ) == 0 )
   {
    /* ein schluesselwort gefunden, jetzt die Daten aus dem File holen */
    p_warning( word[ i ].text, 3 );
    p_get_value( word[ i ].type, word[ i ].value, handle );
    break;
   }
  }
  if ( word[i].type == PARSER_TYPE_END )
  {
   p_warning( "Garbage found (ignored it)!", 2 );
  }
  free( var_name );
 }
 free( handle->mem );
 free( handle );
 if (p_delete_temp==T_TRUE)
 {
  if (f_file_exist("parse.tm1")==T_TRUE)
   unlink((const T_PCHAR )"parse.tm1");
  if (f_file_exist("parse.tmp")==T_TRUE)
   unlink((const T_PCHAR )"parse.tmp");
 }
 p_is_parsing = T_FALSE;
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
******************************************************************
*/
/*
  Funktion holt aus der geoeffneten Datei ein Wert des angegeben Types und
  uebergibt diesen an 'return_value.
  Durch diese Funktion wird das parsen quasi polymorph (OO-Ansatz in 'C')
*/
T_INT p_get_value( T_INT type, T_PVOID return_value, M_PFILE handle )
{
 T_DEBUG_ENTRY("p_get_value",45)
 switch ( type )
 {
  case PARSER_TYPE_ULONG:
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return p_get_type_ulong( return_value, handle);
  }
  case PARSER_TYPE_SLONG:
  {
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return p_get_type_slong( return_value, handle);
  }
  case PARSER_TYPE_UWORD:
  {
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return p_get_type_uword( return_value, handle);
  }
  case PARSER_TYPE_SWORD:
  {
   T_DEBUG_FUNCTION_POSITION(4)
   T_DEBUG_LEAVE
   return p_get_type_sword( return_value, handle);
  }
  case PARSER_TYPE_UINT:
  {
   T_DEBUG_FUNCTION_POSITION(5)
   T_DEBUG_LEAVE
   return p_get_type_uint( return_value, handle);
  }
  case PARSER_TYPE_SINT:
  {
   T_DEBUG_FUNCTION_POSITION(6)
   T_DEBUG_LEAVE
   return p_get_type_sint( return_value, handle);
  }
  case PARSER_TYPE_STRING:
  {
   T_DEBUG_FUNCTION_POSITION(7)
   T_DEBUG_LEAVE
   return p_get_type_string( return_value, handle);
  }
  case PARSER_TYPE_UCHAR:
  {
   T_DEBUG_FUNCTION_POSITION(8)
   T_DEBUG_LEAVE
   return p_get_type_uchar( return_value, handle);
  }
  case PARSER_TYPE_SCHAR:
  {
   T_DEBUG_FUNCTION_POSITION(9)
   T_DEBUG_LEAVE
   return p_get_type_schar( return_value, handle);
  }
  case PARSER_TYPE_STRUKT:
  {
   T_DEBUG_FUNCTION_POSITION(10)
   T_DEBUG_LEAVE
   return p_get_type_strukt( return_value, handle);
  }
  case PARSER_TYPE_LIST:
  {
   T_DEBUG_FUNCTION_POSITION(11)
   T_DEBUG_LEAVE
   return p_get_type_list( return_value, handle);
  }
  case PARSER_TYPE_VOID:
  {
   T_DEBUG_FUNCTION_POSITION(12)
   T_DEBUG_LEAVE
   return T_OK;
  }
  case PARSER_TYPE_LINE_ARRAY_INT:
  {
   T_DEBUG_FUNCTION_POSITION(13)
   T_DEBUG_LEAVE
   return p_get_type_la_int( return_value, handle);
  }
 }
 parse_error = PARSE_NO_TYPE_FOUND;
 T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_TYPE_FOUND)
 T_DEBUG_LEAVE
 return parse_error;
}
/*
************************************************************************
*/
T_INT p_get_type_la_int( T_PVOID return_value, M_PFILE handle )
{
 /* for now no dynamically located arrays, per default     */
 /* INT_ARRAY[MAX_LINE_INTS] are allocated, the first is allways the */
 /* number of INTs found, than in the order of occurence   */
 T_PCHAR value;
 T_INT status = T_OK;
 T_INT counter=1;
 T_PSINT la_int;
 T_DEBUG_ENTRY("p_get_type_la_int",45)
 la_int=(T_PSINT)malloc(MAX_LINE_INT*sizeof(T_SINT));
 if (la_int==NULL)
 {
  parse_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 la_int[0] = 0;
 while (status==T_OK)
 {
  p_read_next_numeric_line( handle, &value, &status );
  if ((status==P_OK_REMARK_FOUND)||
      (status==P_OK_POSSIBLE_FILE_END)||
      (status==P_OK_RETURN_FOUND)||
      (status==T_OK))
  {
   if ( p_test_number(value) == T_TRUE )
   {
    la_int[counter] = ( T_SINT ) p_atois( value );
    counter++;
   }
   else
   {
    p_warning( "Parse Error: Expecting INTEGER (SIGNED), got:", 0 );
    p_warning( value, 0);
    free( value );
    parse_error = PARSE_PARSE_ERROR;
    return parse_error;
   }
   free( value );
   if ((status==P_OK_REMARK_FOUND)||
       (status==P_OK_POSSIBLE_FILE_END)||
       (status==P_OK_RETURN_FOUND))
   {
    break;
   }
  }
  else
  {
   free( value );
   break;
  }
  if (counter==MAX_LINE_INT)
   break;
 }
 la_int[0] = counter-1;
 * ( ( T_PSINT * ) return_value ) = ( T_PSINT ) la_int;
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}

/*
************************************************************************
*/
/*
  diese funktion liest ein neues element in eine liste ein.
  Eine Besonderheit ist, dass hier strings (logischer Weise) IMMER
  alloziiert werden, 'p_alloc_pointer' hat hier also KEINE Bedeutung
  Besonders toll finde ich es, dass auch strukts eine liste bilden koennen.
  Listen koennen leider nicht in schon bestehende strukturen eingefuegt
  werden, sie werden immer ganz frisch beim parserausfruf erzeugt,
  sie muessen also, noch nachbearbeitet werden, wenn die eingelesenen daten
  in eigenen strukturen verwendet werden sollen (aber wie soll man das
  schon anders machen?) noch kann keine liste in einer
  liste verwendet werden!
*/
T_INT p_get_type_list( T_PVOID return_value, M_PFILE handle )
{
 PARSER_LIST *field = ( PARSER_LIST * )return_value;
 T_INT old_p_alloc_pointer = p_alloc_pointer;
 T_DEBUG_ENTRY("p_get_type_list",45)
 p_alloc_pointer = T_TRUE;
 parse_error = T_OK;
 switch ( field->type )
 {
  case PARSER_TYPE_SLONG:
  {
   T_SLONG *slong;
   slong = (T_SLONG *) malloc( sizeof( T_SLONG ) );
   if ( slong == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_slong( slong, handle);
   d_fuege_in_liste_ein( slong, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_ULONG:
  {
   T_ULONG *ulong;
   ulong = (T_ULONG *) malloc( sizeof( T_ULONG ) );
   if ( ulong == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_ulong( ulong, handle);
   d_fuege_in_liste_ein( ulong, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_SINT:
  {
   T_SINT *sint;
   sint = (T_SINT *) malloc( sizeof( T_SINT ) );
   if ( sint == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_sint( sint, handle);
   d_fuege_in_liste_ein( sint, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_UINT:
  {
   T_UINT *uint;
   uint = (T_UINT *) malloc( sizeof( T_UINT ) );
   if ( uint == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_uint( uint, handle);
   d_fuege_in_liste_ein( uint, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_SWORD:
  {
   T_SWORD *sword;
   sword = (T_SWORD *) malloc( sizeof( T_SWORD ) );
   if ( sword == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_sword( sword, handle);
   d_fuege_in_liste_ein( sword, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_UWORD:
  {
   T_UWORD *uword;
   uword = (T_UWORD *) malloc( sizeof( T_UWORD ) );
   if ( uword == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_uword( uword, handle);
   d_fuege_in_liste_ein( uword, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_STRING:
  {
   T_PCHAR *string;
   string = (T_PCHAR *) malloc( sizeof( T_PCHAR ) );
   if ( string == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_string( string, handle);
   d_fuege_in_liste_ein( string, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail, DL_HINTEN );
   break;
  }
  case PARSER_TYPE_SCHAR:
  {
   T_SCHAR *schar;
   schar = (T_SCHAR *) malloc( sizeof( T_SCHAR ) );
   if ( schar == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_schar( schar, handle);
   d_fuege_in_liste_ein( schar, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_UCHAR:
  {
   T_UCHAR *uchar;
   uchar = (T_UCHAR *) malloc( sizeof( T_UCHAR ) );
   if ( uchar == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   parse_error = p_get_type_uchar( uchar, handle);
   d_fuege_in_liste_ein( uchar, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_STRUKT:
  {
   TYPE_STRUKT *strukt;
   T_INT size_of_strukt = 0;
   T_INT i, ii;
   T_UINT position;
   PARSER_STRUKT *sfield = ( PARSER_STRUKT * ) field->strukt_info;
   i = 0;
   while ( sfield[ i ].type != PARSER_STRUKT_END )
   {
    if ( ( sfield[ i ].type == PARSER_TYPE_STRUKT ) || ( sfield[ i ].type == PARSER_TYPE_LIST ) )
    {
     p_warning( "LIST or STRUKT not allowed (yet) in LIST-STRUKT. (ignoring...)", 0 );
    }
    else
    {
     size_of_strukt += p_sizeof( sfield[ i ].type ) * sfield[ i ].how_many;
    }
    i++;
   }
   strukt = ( TYPE_STRUKT * ) malloc( size_of_strukt );
   if ( strukt == NULL )
   {
    parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
    break;
   }
   i = 0;
   position = 0;
   parse_error = T_OK;
   while ( ( sfield[ i ].type != PARSER_STRUKT_END ) && ( parse_error == T_OK ) )
   {
    if ( ( sfield[ i ].type == PARSER_TYPE_STRUKT ) || ( sfield[ i ].type == PARSER_TYPE_LIST ) )
    {
     /* ignoring */
    }
    else
    {
     for ( ii = 0; ( ( ii < sfield[ i ].how_many ) && ( parse_error == T_OK ) ); ii++ )
     {
      parse_error = p_get_value( sfield[ i ].type, ( T_PVOID  ) ( ( ( T_PCHAR  ) strukt ) + position ), handle );
      position += p_sizeof( sfield[ i ].type );
     }
    }
    i++;
   }
   d_fuege_in_liste_ein( strukt, &( T_LISTE * ) field->list_head, &( T_LISTE * ) field->list_tail,DL_HINTEN );
   break;
  }
  case PARSER_TYPE_LIST:
  {
   p_warning( "LIST not allowed (yet) in LIST. (ignoring...)", 0 );
   parse_error = PARSE_PARSE_ERROR;
   break;
  }
  default:
  {
   parse_error = PARSE_NO_TYPE_FOUND;
   break;
  }
 }
 p_alloc_pointer = old_p_alloc_pointer;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
*********************************************************************
*/
/*
  liest daten in ein strukt ein
  struktur wird entsprechend der Definition abgefragt, die gefundenen
  Datentypen in die Struktur abgelegt.
*/
T_INT p_get_type_strukt( T_PVOID return_value, M_PFILE handle )
{
 T_INT t, i = 0;
 PARSER_STRUKT field = ( ( PARSER_STRUKT * ) return_value )[ i ];
 T_DEBUG_ENTRY("p_get_type_strukt",45)
 while ( ( field.type != PARSER_STRUKT_END ) && ( parse_error == T_OK ) )
 {
  for ( t = 0; ( ( t < field.how_many ) && ( parse_error == T_OK ) ); t++ )
  {
   if ( field.type != PARSER_TYPE_LIST )
   {
    if (field.type!=PARSER_TYPE_STRING)
    {
     parse_error = p_get_value( field.type, ( T_PVOID ) ( ( ( T_PCHAR  ) field.value ) + ( t * p_sizeof( field.type ) ) ), handle );
    }
    else
    {
//   parse_error = p_get_value( field.type, ( T_PVOID ) (* ( T_PVOID* ) ( ( ( ( T_PCHAR  ) field.value ) + ( t * p_sizeof( field.type ) ) ) ) ), handle );
     parse_error = p_get_value( field.type,  ( T_PCHAR  )field.value  + ( t * p_sizeof( field.type ) ), handle );
    }
   }
   else
   {
    p_warning( "LIST not allowed (yet) in STRUKT. (ignoring LIST)", 0 );
   }
  }
  i++;
  field = ( ( PARSER_STRUKT * ) return_value )[ i ];
 }
 if ( parse_error != T_OK )
 {
  p_warning( "Parse Warning! Expecting STRUKTFIELD, got: ERROR, might just be end of file.", 2 );
 }
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
****************************************************************
*/
/*
  liest einen string ein, was ein string ist, wird durch die
  werte der einzelnen zeichen-codes bestimmt.
  Die Rueckgabe wird in verschiedener Weise behandelt.
  Beeinflusst durch:
   - p_include_brackets
   - p_switch_to_c_end_char
   - p_alloc_pointer
*/
T_INT p_get_type_string( T_PVOID return_value, M_PFILE handle )
{
 T_PCHAR value;
 T_INT status = T_OK;
 T_INT len;
 T_DEBUG_ENTRY("p_get_type_string",45)
 p_read_next_string( handle, &value, &status ,&len);
 if ( value == NULL )
 {
  p_warning( "Parse Error: Expecting STRING, got: ERROR", 0 );
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( ( p_include_brackets == T_FALSE ) && ( ( p_smart_strings != T_TRUE ) ) )
 {
  if ( ( p_char_type[ value[ 0 ] ] & P_STRING_BRACKET ) == P_STRING_BRACKET )
  {
   memmove(value,value+1,len);
   len--;
  }
  if ( ( p_char_type[ value[ len-1 ] ] & P_STRING_BRACKET ) == P_STRING_BRACKET )
  {
   value[ len-1 ] = value[ len ] ;
   len--;
  }
 }
 if ( p_switch_to_c_end_char == T_TRUE )
 {
  value[ len ] = P_C_END_CHAR;
 }
 if ( p_alloc_pointer == T_FALSE )
 {
  if ( p_switch_to_c_end_char == T_TRUE )
  {
   memcpy( return_value, value, len+1 );
  }
  else
  {
   memcpy( return_value, value, len+1 );
  }
  free( value );
 }
 else
 {
  * ( ( T_PCHAR * ) return_value ) = ( T_PCHAR ) value;
 }
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_sword( T_PVOID return_value, M_PFILE handle )
{
 T_PCHAR value;
 T_INT status = T_OK;
 T_DEBUG_ENTRY("p_get_type_sword",45)
 p_read_next_numeric( handle, &value, &status );
 parse_error = T_OK;
 if ( value == NULL )
 {
  p_warning( "Parse Error: Expecting WORD (SIGNED), got: ERROR", 0 );
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_test_number(value) == T_TRUE )
 {
  *( ( T_SWORD * ) return_value ) = ( T_SWORD ) p_atois( value );
  free( value );
 }
 else
 {
  p_warning( "Parse Error: Expecting WORD (SIGNED), got:", 0 );
  p_warning( value, 0);
  free( value );
  parse_error = PARSE_PARSE_ERROR;
  return parse_error;
 }
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_uword( T_PVOID return_value, M_PFILE handle )
{
 T_PCHAR value;
 T_INT status = T_OK;
 T_DEBUG_ENTRY("p_get_type_uword",45)
 p_read_next_numeric( handle, &value, &status );
 parse_error = T_OK;
 if ( value == NULL )
 {
  p_warning( "Parse Error: Expecting WORD (UNSIGNED), got: ERROR", 0 );
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_test_number(value) == T_TRUE )
 {
  *( ( T_UWORD * ) return_value ) = ( T_UWORD ) p_atoiu( value );
  free( value );
 }
 else
 {
  p_warning( "Parse Error: Expecting WORD (UNSIGNED), got:", 0 );
  p_warning( value, 0);
  free( value );
  parse_error = PARSE_PARSE_ERROR;
  return parse_error;
 }
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_slong( T_PVOID return_value, M_PFILE handle )
{
 T_PCHAR value;
 T_INT status = T_OK;
 T_DEBUG_ENTRY("p_get_type_slong",45)
 p_read_next_numeric( handle, &value, &status );
 parse_error = T_OK;
 if ( value == NULL )
 {
  p_warning( "Parse Error: Expecting WORD (SIGNED), got: ERROR", 0 );
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_test_number(value) == T_TRUE )
 {
  *( ( T_SLONG * ) return_value ) = ( T_SLONG ) p_atois( value );
  free( value );
 }
 else
 {
  p_warning( "Parse Error: Expecting LONG (SIGNED), got:", 0 );
  p_warning( value, 0);
  free( value );
  parse_error = PARSE_PARSE_ERROR;
  return parse_error;
 }
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_ulong( T_PVOID return_value, M_PFILE handle )
{
 T_PCHAR value;
 T_INT status = T_OK;
 T_DEBUG_ENTRY("p_get_type_ulong",45)
 p_read_next_numeric( handle, &value, &status );
 parse_error = T_OK;
 if ( value == NULL )
 {
  p_warning( "Parse Error: Expecting LONG (UNSIGNED), got: ERROR", 0 );
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_test_number(value) == T_TRUE )
 {
  *( ( T_ULONG * ) return_value ) = ( T_ULONG ) p_atoiu( value );
  free( value );
 }
 else
 {
  p_warning( "Parse Error: Expecting LONG (UNSIGNED), got:", 0 );
  p_warning( value, 0);
  free( value );
  parse_error = PARSE_PARSE_ERROR;
  return parse_error;
 }
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_word( T_PVOID return_value, M_PFILE handle )
{
 T_DEBUG_ENTRY("p_get_type_word",45)
 T_DEBUG_LEAVE
 return p_get_type_sword(return_value,handle);
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_sint( T_PVOID return_value, M_PFILE handle )
{
 T_PCHAR value;
 T_INT status = T_OK;
 T_DEBUG_ENTRY("p_get_type_sint",45)
 p_read_next_numeric( handle, &value, &status );
 parse_error = T_OK;
 if ( value == NULL )
 {
  p_warning( "Parse Error: Expecting INTEGER (SIGNED), got: ERROR", 0 );
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_test_number(value) == T_TRUE )
 {
  *( ( T_SINT * ) return_value ) = ( T_SINT ) p_atois( value );
  free( value );
 }
 else
 {
  p_warning( "Parse Error: Expecting INTEGER (SIGNED), got:", 0 );
  p_warning( value, 0);
  free( value );
  parse_error = PARSE_PARSE_ERROR;
  return parse_error;
 }
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_uint( T_PVOID return_value, M_PFILE handle )
{
 T_PCHAR value;
 T_INT status = T_OK;
 T_DEBUG_ENTRY("p_get_type_uint",45)
 p_read_next_numeric( handle, &value, &status );
 parse_error = T_OK;
 if ( value == NULL )
 {
  p_warning( "Parse Error: Expecting INTEGER (UNSIGNED), got: ERROR", 0 );
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_test_number(value) == T_TRUE )
 {
  *( ( T_UINT * ) return_value ) = ( T_UINT ) p_atoiu( value );
  free( value );
 }
 else
 {
  p_warning( "Parse Error: Expecting INTEGER (UNSIGNED), got:", 0 );
  p_warning( value, 0);
  free( value );
  parse_error = PARSE_PARSE_ERROR;
  return parse_error;
 }
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
********************************************************************
*/
/* liest einfach ein Integer aus einem file */
T_INT p_get_type_int( T_PVOID return_value, M_PFILE handle )
{
 T_DEBUG_ENTRY("p_get_type_int",45)
 T_DEBUG_LEAVE
 return p_get_type_sint(return_value,handle);
}
/*
******************************************************************
*/
/* liest einfach ein charakter aus einem file */
T_INT p_get_type_schar( T_PVOID return_value, M_PFILE handle )
{
 T_INT status = T_OK;
 T_SINT t;
 T_DEBUG_ENTRY("p_get_type_schar",45)
 parse_error = p_get_type_sint( &t, handle);
 * ( ( T_SCHAR * ) return_value ) = ( T_SCHAR ) (t);
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/* liest einfach ein charakter aus einem file */
T_INT p_get_type_uchar( T_PVOID return_value, M_PFILE handle )
{
 T_INT status = T_OK;
 T_UINT t;
 T_DEBUG_ENTRY("p_get_type_uchar",45)
 parse_error = p_get_type_uint( &t, handle);
 * ( ( T_SCHAR * ) return_value ) = ( T_UCHAR ) (t);
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/* liest einfach ein charakter aus einem file */
T_INT p_get_type_char( T_PVOID return_value, M_PFILE handle )
{
 T_INT status = T_OK;
 T_UCHAR value;
 T_DEBUG_ENTRY("p_get_type_char",45)
 do
 {
  parse_error = p_read_next_sign( handle, &value, &status );
 }
 while ( parse_error == PARSE_NO_ASCII );
 if ( parse_error == PARSE_FILE_END )
 {
  p_warning( "Parse Error: Expecting CHAR (UNSIGNED), got: FILE_END", 0 );
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 * ( ( T_UCHAR * ) return_value ) = ( T_UCHAR ) (value);
 parse_error = status;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
**********************************************************************
*/
/* eigene strlen funktion, ueberfluessig im normalfall, aber da als
   zeichencode ein 'p_string_end_char' angegeben werden kann, ist sie notwendig */
T_INT p_strlen( T_PCHAR var_name )
{
 T_INT len=0;
 T_DEBUG_ENTRY("p_strlen",45)
 while ( var_name[ len ] != p_string_end_char )
 {
  len++;
 }
 T_DEBUG_LEAVE
 return len;
}
/*
**********************************************************************
*/
/* den rest einer Zeile in einem File ignorieren */
T_INT p_discard_rest_of_line(M_PFILE handle)
{
 T_CHAR char_read;
 T_DEBUG_ENTRY("p_discard_rest_of_line",45)
 while ( 1 )
 {
  if (m_read(handle, &char_read, sizeof(T_CHAR)) == 0)
  {
   parse_error=T_OK;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return PARSE_FILE_END;
  }
  if ( (p_char_type[ (T_UCHAR) char_read ] & P_LINE_SEPERATOR) == P_LINE_SEPERATOR)
  {
   break;
  }
 }
 parse_error=T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
************************************************************************
*/
/* liefert size in sizeof( T_CHAR ) von den eigenen Parse Typen */
T_INT p_sizeof( T_INT type )
{
 T_DEBUG_ENTRY("p_sizeof",45)
 parse_error = T_OK;
 switch ( type )
 {
  case PARSER_TYPE_SINT:
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return ( sizeof( T_INT ) / sizeof(T_CHAR) );
  }
  case PARSER_TYPE_SCHAR:
  {
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return ( sizeof( T_CHAR ) / sizeof(T_CHAR) );
  }
  case PARSER_TYPE_STRING:
  case PARSER_TYPE_LIST:
  case PARSER_TYPE_STRUKT:
  {
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return ( sizeof( T_PVOID ) / sizeof(T_CHAR) );
  }
 }
 parse_error = PARSE_NO_TYPE_FOUND;
 T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_TYPE_FOUND)
 T_DEBUG_LEAVE
 return 0;
}
/*
***********************************************************************
*/
/* wandelt klein in grossbuchstaben */
T_INT p_make_big( T_PCHAR string )
{
 T_INT counter = 0;
 T_DEBUG_ENTRY("p_make_big",45)
 if ( string == NULL )
 {
  parse_error = PARSE_PARSE_ERROR;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PARSE_ERROR)
  T_DEBUG_LEAVE
  return parse_error;
 }
 while ( ( p_char_type[ string[ counter ] ] & P_STRING_END ) != P_STRING_END )
 {
  if ( ( string[ counter ] >= 'a')&&(string[ counter ] <= 'z' ) )
  {
   string[ counter ] = string[ counter ] - 32;
  }
  else
  {
   switch ( string[ counter ] )
   {
    case '':
    {
     string[ counter ] = '';
     break;
    }
    case '':
    {
     string[ counter ] = '';
     break;
    }
    case '':
    {
     string[ counter ] = '';
     break;
    }
   }
  }
  counter++;
 }
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
*************************************************************************
*/
/* einfache atoi funktion fuer signed integer only */
T_SINT p_atois( T_PCHAR string )
{
 T_INT counter = 0;
 T_INT number = 0;
 T_CHAR help[MAX_LINE_LEN];
 T_DEBUG_ENTRY("p_atois",45)
 if ( string == NULL )
 {
  parse_error = PARSE_NO_STRING;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_STRING)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 strcpy(help,string);
 while ( ( p_char_type[ string[ counter ] ] & P_STRING_END ) != P_STRING_END )
  counter++;
 help[counter]=(T_CHAR)0;
 number=get_zahl(help);
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return number;
}
/*
*************************************************************************
*/
/* einfache atoi funktion fuer integer only (if sign found, it is ignored) */
T_UINT p_atoiu( T_PCHAR string )
{
 T_INT old_number;
 T_INT counter = 0;
 T_INT number = 0;
 T_INT sign = T_FALSE;
 T_INT started = T_FALSE;
 T_DEBUG_ENTRY("p_atoiu",45)
 if ( string == NULL )
 {
  parse_error = PARSE_NO_STRING;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_STRING)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 while ( ( p_char_type[ string[ counter ] ] & P_STRING_END ) != P_STRING_END )
 {
  if ( ( string[ counter ] == '-' ) && ( started == T_FALSE ) )
   sign = T_TRUE;
  if ( ( string[ counter ] >= '0' ) && ( string[ counter ] <= '9' ) )
  {
   started = T_TRUE;
   old_number = number;
   number *= 10;
   number += string[ counter ] - '0';
   counter++;
   if ( number < old_number )
   {
    parse_error = PARSE_INTEGER_OVERFLOW;
    if (sign == T_TRUE)
    {
     old_number *= -1;
    }
    T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_INTEGER_OVERFLOW)
    T_DEBUG_FUNCTION_POSITION(2)
    T_DEBUG_LEAVE
    return old_number;
   }
  }
 }
 if ( sign == T_TRUE )
 {
;//  number *= -1;
 }
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return number;
}
/*
************************************************************************
*/
/* ist der uebergeben string eine 'ascii-zahl' (nach zeichencode) */
T_INT p_test_number( T_PCHAR string )
{
 T_INT counter=0;
 T_DEBUG_ENTRY("p_test_number",45)
 if ( string == NULL )
 {
  parse_error = PARSE_NO_NUMBER;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_NUMBER)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 while ( ( p_char_type[ string[ counter ] ] & P_STRING_END ) != P_STRING_END )
 {
  if ( ( p_char_type[ string[ counter ] ] & P_NUMERIC ) == 0 )
  {
   parse_error = T_OK;
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_FALSE;
  }
  counter++;
 }
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return T_TRUE;
}
/*
************************************************************************
*/
/* unterste Stufe des einlesens von einem file. Absolut RAW */
T_INT p_read_next_byte( M_PFILE handle, T_PUCHAR byte, T_PINT status )
{
 T_INT how_many;
 T_DEBUG_ENTRY("p_read_next_byte",45)
 *status = T_OK ;
 p_pos_counter++;
 parse_error = T_OK;
 how_many = m_read( handle, ( T_PCHAR  ) byte, sizeof( T_CHAR ) );
 if ( how_many == 0 )
 {
  *status = PARSE_FILE_END;
  parse_error = *status;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
  T_DEBUG_FUNCTION_POSITION(1)
 }
 if ( ( p_char_type[ *byte ] & P_LINE_SEPERATOR ) == P_LINE_SEPERATOR)
 {
  p_pos_counter = 0;
  p_line_counter++;
 }
 T_DEBUG_LEAVE
 return how_many;
}
/*
***********************************************************************
*/
/* in raw_mode == T_TRUE, werden char_brackets normal behandelt
   ansonsten werden nur char_brackets und p_invoke behandelt
   es koennen also fast alle daten gelesen werden!              */
T_INT p_read_next_char( M_PFILE handle, T_PUCHAR byte, T_PINT status, T_INT string_bracket_mode )
{
 T_INT how_many;
 T_INT char_bracket_open = T_FALSE;
 T_UCHAR own_byte;
 T_DEBUG_ENTRY("p_read_next_char",45)
 *byte = ( T_UCHAR ) 0;
 how_many = p_read_next_byte( handle, &own_byte, status );
 if ( how_many == 0 )
 {
  parse_error = T_OK;
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return how_many;
 }
 if ( string_bracket_mode == T_FALSE )
 {
  while ( ( p_char_type[ own_byte ] & P_CHAR_BRACKET) == P_CHAR_BRACKET )
  {
   char_bracket_open = T_TRUE;
   how_many = p_read_next_byte( handle, &own_byte, status );
   if ( how_many == 0 )
   {
    p_warning("Type of last Byte is CHAR_BRACKET", 1);
    *status = PARSE_FILE_END;
    parse_error = *status;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
    T_DEBUG_FUNCTION_POSITION(2)
    T_DEBUG_LEAVE
    return how_many;
   }
   if ( ( p_char_type[ own_byte ] & P_CHAR_BRACKET) == P_CHAR_BRACKET )
   {
    char_bracket_open = T_FALSE;
    p_warning("Empty CHAR_BRACKET", 1);
    how_many = p_read_next_byte( handle, &own_byte, status );
    if ( how_many == 0 )
    {
     *status = PARSE_FILE_END;
     parse_error = *status;
     T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
     T_DEBUG_FUNCTION_POSITION(3)
     T_DEBUG_LEAVE
     return how_many;
    }
   }
  } /* while */
 } /* string_bracket_mode */
 if ( ( p_char_type[ own_byte ] & P_INVOKE_RAW ) == P_INVOKE_RAW )
 {
  how_many = p_read_next_byte( handle, &own_byte, status );
  if ( how_many == 0 )
  {
   p_warning("Type of last Byte is INVOKE_RAW", 1);
   *status = PARSE_FILE_END;
   parse_error = *status;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
   T_DEBUG_FUNCTION_POSITION(4)
   T_DEBUG_LEAVE
   return how_many;
  }
  *status = P_INVOKE_RAW;
 }
 *byte = own_byte;
 /* abfragen ob leere char _bracket */
 if ( char_bracket_open == T_TRUE )
 {
  T_INT this_status;
  T_INT this_how_many = p_read_next_byte( handle, &own_byte, &this_status );
  if ( this_how_many == 0 )
  {
   p_warning("End of File! CHAR_BRACKET type not closed!",1 );
   *status = PARSE_FILE_END;
   parse_error = *status;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
   T_DEBUG_FUNCTION_POSITION(5)
   T_DEBUG_LEAVE
   return how_many;
  }
  if ( ( p_char_type[ own_byte ] & P_CHAR_BRACKET) != P_CHAR_BRACKET )
  {
   p_warning("CHAR_BRACKET not closed!",1 );
   m_rewind( handle, ( T_LONG ) sizeof( T_CHAR ) );
  }
 }
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return how_many;
}
/*
***********************************************************************
*/
/* liest ein einzelnes Zeichen aus einem File,
   Stringbrackets werden beachtet, es wird das erste 'gueltige zeichen
   zurueckgegeben,
   raw_mode und kommentare werden beachtet, ebenso
   p_invalid, line_seperator ... */
T_INT p_read_next_sign( M_PFILE handle, T_PCHAR word_read, T_PINT status )
{
 T_INT string_bracket_open = T_FALSE;
 T_INT is_ascii;
 T_INT is_in_bracket;
 T_INT is_raw;
 T_INT is_allowed;
 T_INT word_len = 0;
 T_DEBUG_ENTRY("p_read_next_sign",45)
 *status = T_OK;
 *word_read = 0;
 while ( word_len == 0 )
 {
  T_INT continue_allowed = T_TRUE;
  if ( p_read_next_char( handle, (T_PUCHAR ) word_read, status, string_bracket_open ) == 0 )
  {
   parse_error = *status;
   if ( ( *status != T_OK ) && ( *status != P_INVOKE_RAW ) )
   {
    *word_read = 0;
   }
   T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parse_error;
  }
  if ( *status != P_INVOKE_RAW )
  {
   if ( ( ( p_char_type[ *word_read ] & P_REMARK ) == P_REMARK ) && ( string_bracket_open == T_FALSE ) )
   {
    parse_error = p_discard_rest_of_line( handle );
    p_pos_counter = 0;
    p_line_counter++;
    continue_allowed = T_FALSE;
    if ( parse_error != T_OK )
    {
     *word_read = 0;
     T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
     T_DEBUG_FUNCTION_POSITION(2)
     T_DEBUG_LEAVE
     return parse_error;
    }
   }
   else
   {
    if ( ( p_char_type[ *word_read ] & P_LINE_SEPERATOR ) == P_LINE_SEPERATOR)
    {
     if ( string_bracket_open == T_TRUE )
     {
      p_warning( "STRING_BRACKET and LINE_SEPERATOR encountered -> bracket closed.", 1 );
      string_bracket_open = T_FALSE;
     }
    }
   }
  }
  if (( ( p_char_type[ *word_read ] & P_CONTINUE_NEXT_LINE ) == P_CONTINUE_NEXT_LINE ) && ( *status == P_INVOKE_RAW ) && ( string_bracket_open == T_TRUE ) )
  {
   parse_error = p_discard_rest_of_line( handle );
   p_pos_counter = 0;
   p_line_counter++;
   continue_allowed = T_FALSE;
   if ( parse_error != T_OK )
   {
    *word_read = 0;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
    T_DEBUG_FUNCTION_POSITION(3)
    T_DEBUG_LEAVE
    return parse_error;
   }
  }
  is_ascii =  !(( p_char_type[ *word_read ] & P_INVALID ) |
                ( p_char_type[ *word_read ] & P_SEPERATOR ) |
                ( p_char_type[ *word_read ] & P_LINE_SEPERATOR ) );
  is_in_bracket = ( string_bracket_open == T_TRUE );
  is_raw = ( *status == P_INVOKE_RAW );
  is_allowed = ( continue_allowed == T_TRUE );
  if ( ( ( is_ascii ) || ( is_in_bracket ) || ( is_raw ) ) )
  {
   if ( is_allowed )
   {
    word_len++;
   }
  }
  else
  {
   *word_read = 0;
   parse_error = PARSE_NO_ASCII;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_ASCII)
   T_DEBUG_FUNCTION_POSITION(4)
   T_DEBUG_LEAVE
   return parse_error;
  }
 } /* end while ( 1 ) */
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
*************************************************************************
*/
/* einlesen von NUMERICS, Kommentare werden beachtet
   es wird solange versucht einzulesen, bis numerisches zeichen gefunden
   wurde, oder file zuende. Abgeschlossen wird die 'Zahl' mit
   jedem Nicht numerischen zeichen */
T_INT p_read_next_numeric( M_PFILE handle, T_PCHAR *string, T_PINT status )
{
 T_PUCHAR word_read;
 T_INT word_len = 0;
 T_INT current_unit_max_len = P_START_UNIT_LEN;
 T_INT increase_unit_len = 2 * current_unit_max_len;
 T_DEBUG_ENTRY("p_read_next_numeric",45)
 *status=T_OK;
 word_read = (T_PUCHAR  ) malloc( current_unit_max_len * sizeof( T_CHAR ) );
 if ( word_read == NULL )
 {
  *string = NULL;
  parse_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 while ( 1 )
 {
  if ( p_read_next_byte( handle, &word_read[ word_len ], status ) == 0 )
  {
   parse_error = *status;
   if ( word_len == 0 )
   {
    free( word_read );
    *string = NULL;
   }
   T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return parse_error;
  }
  if ( ( p_char_type[ word_read[ word_len ] ] & P_REMARK ) == P_REMARK )
  {
   parse_error = p_discard_rest_of_line( handle );
   p_pos_counter = 0;
   p_line_counter++;
   if ( ( word_len == 0 ) && ( parse_error != T_OK ) )
   {
    free( word_read );
    *string = NULL;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
    T_DEBUG_FUNCTION_POSITION(3)
    T_DEBUG_LEAVE
    return parse_error;
   }
   if ( word_len != 0 )
   {
    break;
   }
  }
  else
  {
   if ( ( p_char_type[ word_read[ word_len ] ] & P_NUMERIC ) == 0 )
   {
    if ( word_len != 0)
    {
     /* korrekte Unit gefunden, abgeschlossen mit NICHT P_NUMERIC */
     break;
    }
    else
    {
      /* ignore everything but P_NUMERIC */
    }
   }
   else
   {
    word_len++;
    if ( word_len == current_unit_max_len )
    {
     T_PUCHAR word_read_help;
     current_unit_max_len += increase_unit_len;
     increase_unit_len = 2 * current_unit_max_len;
     word_read_help = ( T_PUCHAR  ) malloc(current_unit_max_len * sizeof( T_UCHAR ) );
     if ( word_read_help == NULL )
     {
      free( word_read );
      *string = NULL;
      parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
      T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
      T_DEBUG_FUNCTION_POSITION(4)
      T_DEBUG_LEAVE
      return parse_error;
     }
     memcpy( word_read_help, word_read, word_len - 1 );
     free( word_read );
     word_read = word_read_help;
    }
   }
  } /* else word_read[] != REMARK ende */
 } /* end while (1) */
 word_read[ word_len ] = p_string_end_char;
 *string = ( T_PCHAR  ) word_read;
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
*************************************************************************
*/
/* Nur bis ans ende der Zeile lesen!
   einlesen von NUMERICS, Kommentare werden beachtet
   es wird solange versucht einzulesen, bis numerisches zeichen gefunden
   wurde, oder file zuende. Abgeschlossen wird die 'Zahl' mit
   jedem Nicht numerischen zeichen

   MUST ALLWAYS FREE string!!!
*/

T_INT p_read_next_numeric_line( M_PFILE handle, T_PCHAR *string, T_PINT status )
{
 T_PUCHAR word_read;
 T_INT word_len = 0;
 T_INT current_unit_max_len = P_START_UNIT_LEN;
 T_INT increase_unit_len = 2 * current_unit_max_len;
 T_DEBUG_ENTRY("p_read_next_numeric_line",45)
 *status=T_OK;
 word_read = (T_PUCHAR  ) malloc( current_unit_max_len * sizeof( T_CHAR ) );
 if ( word_read == NULL )
 {
  *status = GENERIC_MEMORY_NOT_AVAILABLE;
  parse_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 while ( 1 )
 {
  if ( p_read_next_byte( handle, &word_read[ word_len ], status ) == 0 )
  {
   if ( word_len != 0)
   {
    /* korrekte Unit gefunden, abgeschlossen mit ??? */
    *status = P_OK_POSSIBLE_FILE_END;
    break;
   }
   parse_error = *status;
   *status=P_POSSIBLE_FILE_END;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return parse_error;
  }
  if ( ( p_char_type[ word_read[ word_len ] ] & P_REMARK ) == P_REMARK )
  {
   parse_error = p_discard_rest_of_line( handle );
   p_pos_counter = 0;
   p_line_counter++;
   if ( word_len != 0)
   {
    /* korrekte Unit gefunden, abgeschlossen mit P_REMARK */
    *status = P_OK_REMARK_FOUND;
    break;
   }
   *status=P_REMARK_FOUND;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return parse_error;
  }
  else
  {
   if ( ( p_char_type[ word_read[ word_len ] ] & P_NUMERIC ) == 0 )
   {
    if ( ( p_char_type[ word_read[ word_len ] ] & P_LINE_SEPERATOR ) == P_LINE_SEPERATOR)
    {
     if ( word_len != 0)
     {
      /* korrekte Unit gefunden, abgeschlossen mit NICHT P_LINE_SEPERATOR */
      *status = P_OK_RETURN_FOUND;
      break;
     }
     *status = P_RETURN_FOUND;
     T_DEBUG_FUNCTION_POSITION(3)
     T_DEBUG_LEAVE
     return parse_error=T_OK;
    }
    if ( word_len != 0)
    {
     /* korrekte Unit gefunden, abgeschlossen mit NICHT P_NUMERIC */
     *status = T_OK;
     break;
    }
    else
    {
      /* ignore everything but P_NUMERIC */
    }
   }
   else
   {
    word_len++;
    if ( word_len == current_unit_max_len )
    {
     T_PUCHAR word_read_help;
     current_unit_max_len += increase_unit_len;
     increase_unit_len = 2 * current_unit_max_len;
     word_read_help = ( T_PUCHAR  ) malloc(current_unit_max_len * sizeof( T_UCHAR ) );
     if ( word_read_help == NULL )
     {
      *status = GENERIC_MEMORY_NOT_AVAILABLE;
      parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
      T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
      T_DEBUG_FUNCTION_POSITION(4)
      T_DEBUG_LEAVE
      return parse_error;
     }
     memcpy( word_read_help, word_read, word_len - 1 );
     free( word_read );
     word_read = word_read_help;
    }
   }
  } /* else word_read[] != REMARK ende */
 } /* end while (1) */
 word_read[ word_len ] = p_string_end_char;
 *string = ( T_PCHAR  ) word_read;
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
************************************************************************
*/
/* remarks, char und string brackets raw-daten mit p_invoke */
/* in string brackets zaehlen char brackets nicht als solche */
/* es koennen in string brackets raw daten eingefuegt werden */
/* Ansonsten kommt ALLES in den bracket string, auch invalids */
/* line seperator, seperator invalid trennen eingaben */
T_INT p_read_next_string( M_PFILE handle, T_PCHAR *string, T_PINT status, T_PINT len )
{
 T_PUCHAR word_read;
 T_INT word_len = 0;
 T_INT current_unit_max_len = P_START_UNIT_LEN;
 T_INT increase_unit_len = 2 * current_unit_max_len;
 T_INT string_bracket_open = T_FALSE;
 T_INT continue_allowed;
 T_INT is_ascii;
 T_INT is_in_bracket;
 T_INT is_raw;
 T_INT is_allowed;
 T_DEBUG_ENTRY("p_read_next_string",45)
 *status=T_OK;
 word_read = ( T_PUCHAR  ) malloc( current_unit_max_len * sizeof( T_CHAR ) );
 if ( word_read == NULL )
 {
  *string = NULL;
  *len=0;
  parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 while ( 1 )
 {
  continue_allowed = T_TRUE;
  if ( p_read_next_char( handle, &word_read[ word_len ], status, string_bracket_open ) == 0 )
  {
   if (( ( *status != T_OK ) && ( *status != P_INVOKE_RAW ) ) && (*status !=PARSE_FILE_END))
   {
    *len=0;
    parse_error = *status;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
    T_DEBUG_FUNCTION_POSITION(2)
    T_DEBUG_LEAVE
    return parse_error;
   }
   word_read[ word_len ] = p_string_end_char;
   *string = ( T_PCHAR  ) word_read;
   if ( word_len == 0)
   {
    free( word_read );
    *string = NULL;
   }
   *len=word_len;
   parse_error = PARSE_FILE_END;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return parse_error;
  }
  if ( *status != P_INVOKE_RAW )
  {
   if ( ( ( p_char_type[ word_read[ word_len ] ] & P_REMARK ) == P_REMARK ) && ( string_bracket_open == T_FALSE ) )
   {
    T_INT return_code = p_discard_rest_of_line( handle );
    p_pos_counter = 0;
    p_line_counter++;
    continue_allowed = T_FALSE;
    if ( ( word_len == 0 ) && ( return_code != T_OK ) )
    {
     *len=0;
     free( word_read );
     *string = NULL;
     parse_error = PARSE_FILE_END;
     T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_FILE_END)
     T_DEBUG_FUNCTION_POSITION(4)
     T_DEBUG_LEAVE
     return parse_error;
    }
    if ( word_len != 0 )
    {
     break;
    }
   }
   else
   {
    /* NO INVOKE RAW */
    if ( ( p_char_type[ word_read[ word_len ] ] & P_INVALID ) == P_INVALID )
    {
     if ( ( word_len != 0) && ( string_bracket_open == T_FALSE ) )
     {
      /* korrekte Unit gefunden, abgeschlossen mit p_invalid und keine Klammerung offen */
      break;
     }
    }
    if ( ( p_char_type[ word_read[ word_len ] ] & P_SEPERATOR ) == P_SEPERATOR )
    {
     if ( ( word_len != 0) && ( string_bracket_open == T_FALSE ) )
     {
      /* korrekte Unit gefunden, abgeschlossen mit p_seperator und keine Klammerung offen */
      break;
     }
    }
    if ( ( p_char_type[ word_read[ word_len ] ] & P_LINE_SEPERATOR ) == P_LINE_SEPERATOR)
    {
     if ( string_bracket_open == T_TRUE )
     {
      p_warning( "STRING_BRACKET and LINE_SEPERATOR encountered -> closed.", 1 );
     }
     if ( word_len != 0 )
     {
      /* korrekte Unit gefunden, abgeschlossen mit p_line_seperator */
      break;
     }
     else
     {
      if ( string_bracket_open == T_TRUE )
      {
       string_bracket_open = T_FALSE;
       p_warning( "Opened STRING_BRACKET ignored, starting in new line.", 1 );
      }
      /* noch keine unit gefunden, aber neue Zeile angefangen */
     }
    }
   } /* word_read[] == REMARK ende */
  } /* invoke raw - ende */
  if (( ( p_char_type[ word_read[ word_len ] ] & P_CONTINUE_NEXT_LINE ) == P_CONTINUE_NEXT_LINE ) && ( *status == P_INVOKE_RAW ) && ( string_bracket_open == T_TRUE ) )
  {
   parse_error = p_discard_rest_of_line( handle );
   p_pos_counter = 0;
   p_line_counter++;
   continue_allowed = T_FALSE;
   if ( parse_error != T_OK )
   {
    *len=word_len;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(parse_error)
    T_DEBUG_FUNCTION_POSITION(5)
    T_DEBUG_LEAVE
    return parse_error;
   }
  }
  is_ascii =  !(( p_char_type[ word_read[ word_len ] ] & P_INVALID ) |
                ( p_char_type[ word_read[ word_len ] ] & P_SEPERATOR ) |
                ( p_char_type[ word_read[ word_len ] ] & P_LINE_SEPERATOR ));
  is_in_bracket = ( string_bracket_open == T_TRUE );
  is_raw = ( *status == P_INVOKE_RAW );
  is_allowed = ( continue_allowed == T_TRUE );
  if ( ( is_allowed ) && ( ( is_ascii ) || ( is_in_bracket ) || ( is_raw ) ) )
  {
   word_len++;
   if ( word_len == current_unit_max_len )
   {
    T_PUCHAR word_read_help;
    current_unit_max_len += increase_unit_len;
    increase_unit_len = 2 * current_unit_max_len;
    word_read_help = ( T_PUCHAR  ) malloc(current_unit_max_len * sizeof( T_UCHAR ) );
    if ( word_read_help == NULL )
    {
     free( word_read );
     *string = NULL;
     *len=0;
     parse_error = GENERIC_MEMORY_NOT_AVAILABLE;
     T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
     T_DEBUG_FUNCTION_POSITION(6)
     T_DEBUG_LEAVE
     return parse_error;
    }
    memcpy( word_read_help, word_read, word_len  );
    free( word_read );
    word_read = word_read_help;
   }
   if (( ( p_char_type[ word_read[ word_len - 1 ] ] & P_STRING_BRACKET ) == P_STRING_BRACKET ) && (!is_raw))
   {
    if ( p_smart_strings != T_TRUE )
    {
     if ( string_bracket_open == T_FALSE )
     {
      if ( word_len != 1 )
      {
       p_warning( "STRING_BRACKET in string -> String closed, BRACKET ignored.", 1 );
       break;
      }
     }
     else
     {
      if ( word_len == 2 )
      {
       p_warning( "Two STRING_BRACKET's in a row -> empty string stored!", 1 );
      }
      break;
     }
    }
    else
    {
     word_len--;
    }
    string_bracket_open = (string_bracket_open == T_FALSE) ? T_TRUE : T_FALSE;
   }
  }
  else
  {
   /* wenn wort_len == 0, dann p_invalid, p_seperator und p_line_seperator uebergehen */
  }
 } /* end while (1) */
 *len=word_len;
 word_read[ word_len ] = p_string_end_char;
 *string = ( T_PCHAR  ) word_read;
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}
/*
***********************************************************************
*/
T_VOID p_warning( T_PCHAR message, T_INT verbosity)
{
 T_DEBUG_ENTRY("p_warning",45)
 if ( verbosity <= p_verbosity )
 {
  t_printf(E_VERBOSE_NONE, "\nWARNING(zeile:%i,spalte:%i): \"%s\"", p_line_counter , p_pos_counter + 1, message );
 }
 T_DEBUG_LEAVE
}
/*
************************************************************************
*/
T_INT p_open_parse( T_PCHAR filename, M_PFILE *handle, PARSER_WORD *_word )
{
 T_INT i;
 T_DEBUG_ENTRY("p_open_parse",45)
 p_is_parsing = T_TRUE;
 word=_word;
 *handle=NULL;
 if ( f_file_exist( filename ) != T_TRUE )
 {
  parse_error = FILE_OPEN_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if (p_pre_pro_parse(filename,handle)!=T_OK)
 {
  parse_error = PARSE_PRE_PROCESS_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PRE_PROCESS_ERROR)
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if ( p_capitalise == T_TRUE )
 {
  for ( i = 0; word[i].type != PARSER_TYPE_END; i++ )
  {
   p_make_big( word[ i ].text );
  }
 }
 T_DEBUG_LEAVE
 parse_error = T_OK;
 return parse_error;
}
// last_key muss vorhanden und lang genug sein
T_INT p_parse_next( M_PFILE handle, T_PCHAR last_key, T_PINT key)
{
 T_PCHAR var_name;
 T_INT status = T_OK;
 T_INT i;
 T_INT len;
 T_DEBUG_ENTRY("p_parse_next",46)
 if ( handle==NULL )
 {
  parse_error = PARSE_NO_FILE_OPEN;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_FILE_OPEN)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 last_key[0]=(T_CHAR)0;
 status=p_read_next_string( handle, &var_name, &status, &len);
 if (status!=PARSE_FILE_END)
 {
  if ( p_capitalise == T_TRUE )
  {
   p_make_big( var_name );
  }
  for ( i = 0; word[i].type != PARSER_TYPE_END; i++ )
  {
   if ( strncmp(var_name, word[ i ].text, T_MAX( len, strlen( word[ i ].text ) ) ) == 0 )
   {
    /* ein schluesselwort gefunden, jetzt die Daten aus dem File holen */
    strcpy(last_key, word[ i ].text);
    *key=word[ i ].key;
    p_warning( word[ i ].text, 3 );
    if ( p_get_value( word[ i ].type, word[ i ].value, handle ) != T_OK)
    {
     /* Double message */
     /*
     p_warning( "Garbage after Keyword found (don't know what I've done)!", 0 );
     */
    }
    break;
   }
  }
  if ( word[i].type == PARSER_TYPE_END )
  {
   p_warning( "Garbage found (ignored it)!", 2 );
  }
  free( var_name );
 }
 T_DEBUG_LEAVE
 parse_error = status;
 return parse_error;
}


// handle muss freigegeben werden
T_INT p_close_parse( M_PFILE *handle)
{
 T_DEBUG_ENTRY("p_close_parse",45)
 if ( *handle==NULL )
 {
  parse_error = PARSE_NO_FILE_OPEN;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_NO_FILE_OPEN)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  p_is_parsing = T_FALSE;
  return parse_error;
 }
 word = NULL;
 if (p_delete_temp==T_TRUE)
 {
  if (f_file_exist("parse.tm1")==T_TRUE)
   unlink((const T_PCHAR )"parse.tm1");
  if (f_file_exist("parse.tmp")==T_TRUE)
   unlink((const T_PCHAR )"parse.tmp");
 }
 free((*handle)->mem);
 free((*handle));
 *handle=NULL;

 p_is_parsing = T_FALSE;
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}

/* NOT parser specific yet, uses fgets and fputs instead of PARSE_END_OF_LINE */
/* replace every occurence of define with value */
T_VOID replace(T_PCHAR line, T_PCHAR define, T_PCHAR value)
{
 static T_CHAR _line[MAX_LINE_LEN];
 T_PCHAR pos;
 T_INT posi=0;
 pos=line;
 while (pos=strstr(pos,define))
 {
  posi=pos-line;
  strcpy(_line,line);
  *strstr(_line+posi,define)=(T_CHAR)0;
  strcat(_line,value);
  strcat(_line,pos+strlen(define));
  strcpy(line,_line);
  pos=line+posi+strlen(value);
 }
}

// for now stupid
T_VOID replace_invalids(T_PCHAR line)
{
 replace(line,"\\","\\\\");
 replace(line,"/","\\/");
 replace(line,"\"","\\\"");
}

T_INT no_spaces(T_PCHAR line)
{
 int space_counter=0;
 int char_counter=0;
 char line_copy[MAX_LINE_LEN];
 while (line[char_counter]!=(T_CHAR)0)
 {
  if (isspace(line[char_counter]))
  {
   if (char_counter)
    strncpy(line_copy,line,char_counter);
   line_copy[char_counter]=(T_CHAR)0;
   strcat(line_copy,line+char_counter+1);
   strcpy(line,line_copy);
   space_counter++;
  }
  else
  {
   char_counter++;
  }
 }
 return space_counter;
}

T_INT p_pre_pro_parse(T_PCHAR filename, M_PFILE *handle)
{
 FILE *handle_out;
 FILE *handle_in;
 M_PFILE this=NULL;
 T_INT fhandle;
 T_INT size=0;

 T_CHAR line[MAX_LINE_LEN];
 T_PCHAR line_copy;
 T_PCHAR token;
 T_PCHAR pos;
 T_LISTE *def_head=NULL;
 T_LISTE *def_tail=NULL;
 T_LISTE *test=NULL;
 T_INT sdone=T_FALSE;
 T_DEBUG_ENTRY("p_pre_pro_parse",45)
 handle_out = fopen( "parse.tm1", "w" );
 if (handle_out==NULL)
 {
  parse_error = FILE_OPEN_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parse_error;
 }
 handle_in = fopen( filename, "r" ); //
 if (handle_in==NULL)
 {
  parse_error = FILE_OPEN_ERROR;
  fclose(handle_out);
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parse_error;
 }
 while (fgets(line,MAX_LINE_LEN-1,handle_in))
  fputs(line,handle_out);
 fclose(handle_in);
 fclose(handle_out);
 do
 {
  if (sdone==T_TRUE)
  {
   handle_out = fopen( "parse.tm1", "w" );
   if (handle_out==NULL)
   {
    while (def_head!=NULL)
    {
     free(def_head->objekt);
     d_entferne_aus_liste(def_head->objekt, &def_head, &def_tail,DL_CLEAN_UP );
    }
    p_line_counter=0;
    p_pos_counter= 0;
    parse_error = FILE_OPEN_ERROR;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
    T_DEBUG_FUNCTION_POSITION(3)
    T_DEBUG_LEAVE
    return parse_error;
   }
   handle_in = fopen( "parse.tmp", "r" ); //
   if (handle_in==NULL)
   {
    while (def_head!=NULL)
    {
     free(def_head->objekt);
     d_entferne_aus_liste(def_head->objekt, &def_head, &def_tail,DL_CLEAN_UP );
    }
    p_line_counter=0;
    p_pos_counter= 0;
    parse_error = FILE_OPEN_ERROR;
    fclose(handle_out);
    T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
    T_DEBUG_FUNCTION_POSITION(4)
    T_DEBUG_LEAVE
    return parse_error;
   }
   while (fgets(line,MAX_LINE_LEN-1,handle_in))
    fputs(line,handle_out);
   fclose(handle_in);
   fclose(handle_out);
  }
  handle_in = fopen( "parse.tm1", "r" ); //
  if (handle_in==NULL)
  {
   while (def_head!=NULL)
   {
    free(def_head->objekt);
    d_entferne_aus_liste(def_head->objekt, &def_head, &def_tail,DL_CLEAN_UP );
   }
   p_line_counter=0;
   p_pos_counter= 0;
   parse_error = FILE_OPEN_ERROR;
   fclose(handle_out);
   T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
   T_DEBUG_FUNCTION_POSITION(5)
   T_DEBUG_LEAVE
   return parse_error;
  }
  handle_out = fopen( "parse.tmp", "w" );
  if (handle_out==NULL)
  {
   while (def_head!=NULL)
   {
    free(def_head->objekt);
    d_entferne_aus_liste(def_head->objekt, &def_head, &def_tail,DL_CLEAN_UP );
   }
   p_line_counter=0;
   p_pos_counter= 0;
   parse_error = FILE_OPEN_ERROR;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
   T_DEBUG_FUNCTION_POSITION(6)
   T_DEBUG_LEAVE
   return parse_error;
  }
  p_pos_counter= 0;
  p_line_counter=0;
  sdone=T_FALSE;
  while (fgets(line,MAX_LINE_LEN-1,handle_in))
  {
   p_line_counter++;
   test=def_head;
   while (test!=NULL)
   {
    if ((pos=strstr(line,(T_PCHAR)test->objekt)))
    {
     sdone=T_TRUE;
     p_pos_counter=pos-line;
     p_warning( "define placed!", 3 );
     p_warning( (T_PCHAR)test->objekt, 3 );
     p_warning( (T_PCHAR)(((T_LISTE *)test->naechstes)->objekt), 3 );
     replace(line,(T_PCHAR)test->objekt,(T_PCHAR)(((T_LISTE *)test->naechstes)->objekt));
    }
    test=test->naechstes;
    test=test->naechstes;
   }
   if (strstr(line,"!define"))
   {
    sdone=T_TRUE;
    line_copy=strdup(line);
    token=strtok(line_copy," \n\0");
    while (strcmp(token,"!define"))
     token=strtok(NULL," \n\0");
    token=strtok(NULL," \n\0");
    if (token==NULL)
    {
     while (def_head!=NULL)
     {
      free(def_head->objekt);
      d_entferne_aus_liste(def_head->objekt, &def_head, &def_tail ,DL_CLEAN_UP);
     }
     free(line_copy);
     p_pos_counter=token-line_copy;
     p_warning( "Parse Error: Expecting define variable!", 0 );
     p_warning( line, 0 );
     parse_error = PARSE_DEFINE_ERROR;
     fclose(handle_in);
     fclose(handle_out);
     p_line_counter=0;
     p_pos_counter= 0;
     T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_DEFINE_ERROR)
     T_DEBUG_FUNCTION_POSITION(7)
     T_DEBUG_LEAVE
     return parse_error;
    }
    test=def_head;
    while (test!=NULL)
    {
     if (!(strcmp(token,(T_PCHAR)test->objekt)))
     {
      p_pos_counter=token-line_copy;
      p_warning( "Double define! This is tricky!!!", 0 );
      p_warning( line, 0 );
     }
     test=test->naechstes;
     test=test->naechstes;
    }
    d_fuege_in_liste_ein((pos=strdup(token)), &def_head, &def_tail, DL_HINTEN );
    free(line_copy);
    line_copy=strdup(line);
    pos=strstr(line_copy,pos)+strlen(pos);
    while (isspace(*(pos++)));
    pos--;
    token=strtok(pos,"\n\0");
    if (token==NULL)
    {
     while (def_head!=NULL)
     {
      free(def_head->objekt);
      d_entferne_aus_liste(def_head->objekt, &def_head, &def_tail,DL_CLEAN_UP );
     }
     free(line_copy);
     p_pos_counter=pos-line_copy;
     p_warning( "Parse Error: Expecting define value!", 0 );
     p_warning( line, 0 );
     parse_error = PARSE_DEFINE_ERROR;
     fclose(handle_in);
     fclose(handle_out);
     p_line_counter=0;
     p_pos_counter= 0;
     T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_DEFINE_ERROR)
     T_DEBUG_FUNCTION_POSITION(8)
     T_DEBUG_LEAVE
     return parse_error;
    }
    d_fuege_in_liste_ein(strdup(token), &def_head, &def_tail, DL_HINTEN );
    free(line_copy);
    continue; // !define lines not parsed
   }
   pos=strstr(line,"!include");
   if (pos==NULL)
    pos=strstr(line,"!INCLUDE");
   if (pos!=NULL)
   {
    T_PCHAR help;
    FILE *handle_in2;
    sdone=T_TRUE;
    pos+=strlen("!include");
    help=pos;
    replace(pos,"\""," ");
    replace(pos,"'"," ");
    replace(pos,"\\\\","\\");
    no_spaces(pos);
    if (f_file_exist(pos)==T_FALSE)
    {
     p_pos_counter=pos-line;
     p_warning( "Include file not found!", 0 );
     p_warning( pos, 0 );
     continue;
    }
    handle_in2 = fopen( pos, "r" ); //
    if (handle_in2==NULL)
    {
     p_pos_counter=pos-line;
     p_warning( "Include file not found!", 0 );
     p_warning( pos, 0 );
     continue;
    }
    while (fgets(line,MAX_LINE_LEN-1,handle_in2))
     fputs(line,handle_out);
    fclose(handle_in2);
    continue; // !include lines not parsed
   }
   pos=strstr(line,"!text_include");
   if (pos==NULL)
    pos=strstr(line,"!TEXT_INCLUDE");
   if (pos!=NULL)
   {
    T_PCHAR help;
    FILE *handle_in2;
    sdone=T_TRUE;
    pos+=strlen("!text_include");
    help=pos;
    replace(pos,"\""," ");
    replace(pos,"'"," ");
    replace(pos,"\\\\","\\");
    no_spaces(pos);
    if (f_file_exist(pos)==T_FALSE)
    {
     p_pos_counter=pos-line;
     p_warning( "Include file not found!", 0 );
     p_warning( pos, 0 );
     continue;
    }
    handle_in2 = fopen( pos, "r" ); //
    if (handle_in2==NULL)
    {
     p_pos_counter=pos-line;
     p_warning( "Include file not found!", 0 );
     p_warning( pos, 0 );
     continue;
    }
    fputs("\"\\^\n",handle_out);
    while (fgets(line,MAX_LINE_LEN-1,handle_in2))
    {
     replace_invalids(line);
     if (line[strlen(line)-1]=='\n')
     {
      line[strlen(line)-1]=(T_CHAR)0;
      strcat(line," \\^\n");
     }
     else
      strcat(line,"\\^\n");
     fputs(line,handle_out);
    }
    fputs("\"\n",handle_out);
    fclose(handle_in2);
    continue; // !include lines not parsed
   }

   pos=strstr(line,"!pure_text_include");
   if (pos==NULL)
    pos=strstr(line,"!PURE_TEXT_INCLUDE");
   if (pos!=NULL)
   {
    T_PCHAR help;
    FILE *handle_in2;
    sdone=T_TRUE;
    pos+=strlen("!pure_text_include");
    help=pos;
    replace(pos,"\""," ");
    replace(pos,"'"," ");
    replace(pos,"\\\\","\\");
    no_spaces(pos);
    if (f_file_exist(pos)==T_FALSE)
    {
     p_pos_counter=pos-line;
     p_warning( "Include file not found!", 0 );
     p_warning( pos, 0 );
     continue;
    }
    handle_in2 = fopen( pos, "r" ); //
    if (handle_in2==NULL)
    {
     p_pos_counter=pos-line;
     p_warning( "Include file not found!", 0 );
     p_warning( pos, 0 );
     continue;
    }
//    fputs("\"\\^\n",handle_out);
    while (fgets(line,MAX_LINE_LEN-1,handle_in2))
    {
     replace_invalids(line);
     if (line[strlen(line)-1]=='\n')
     {
      line[strlen(line)-1]=(T_CHAR)0;
     }
     strcat(line,"\" RETURN\n");
     fputs("TEXT \"",handle_out);
     fputs(line,handle_out);
    }
    fclose(handle_in2);
    continue; // !include lines not parsed
   }
   fputs(line,handle_out);
  }
  fclose(handle_in);
  fclose(handle_out);
 }
 while(sdone==T_TRUE);
 while (def_head!=NULL)
 {
  free(def_head->objekt);
  d_entferne_aus_liste(def_head->objekt, &def_head, &def_tail,DL_CLEAN_UP );
 }
 p_line_counter=0;
 p_pos_counter= 0;
 *handle=NULL;
 /* open a file for input              */
 fhandle = open( "parse.tmp", O_RDONLY | O_TEXT );
 if( fhandle != -1 )
 {
  size=filelength( fhandle );
  close( fhandle );
 }
 if (size==0)
 {
  parse_error = PARSE_PRE_PROCESS_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(PARSE_PRE_PROCESS_ERROR)
  T_DEBUG_FUNCTION_POSITION(9)
  T_DEBUG_LEAVE
  return parse_error;
 }
 this=(M_PFILE)malloc(sizeof(M_FILE));
 if (this==NULL)
 {
  parse_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(10)
  T_DEBUG_LEAVE
  return parse_error;
 }
 this->size=size;
 this->position=0;
 this->mem=(T_PUCHAR)malloc(sizeof(T_UCHAR)*size);
 if (this->mem==NULL)
 {
  free(this);
  parse_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(10)
  T_DEBUG_LEAVE
  return parse_error;
 }
 handle_in = fopen( "parse.tmp", "rb" ); //
 if (handle_in==NULL)
 {
  free(this->mem);
  free(this);
  parse_error = FILE_OPEN_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_FUNCTION_POSITION(11)
  T_DEBUG_LEAVE
  return parse_error;
 }
 if (fread(this->mem,sizeof(T_UCHAR),size,handle_in)!=size)
 {
  fclose(handle_in);
  free(this->mem);
  free(this);
  parse_error = FILE_READ_ERROR;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_READ_ERROR)
  T_DEBUG_FUNCTION_POSITION(11)
  T_DEBUG_LEAVE
  return parse_error;
 }
 *handle=this;
 fclose(handle_in);
 parse_error = T_OK;
 T_DEBUG_LEAVE
 return parse_error;
}


#define my_true (1==1)
#define my_false (!my_true)
#define MAXBUFF MAX_LINE_LEN


/* correct the string and return a signed radix */
signed int pruef(char *string)
{
 char *pointer=string;
 signed int minus=1;
 while (*pointer!=(char)0)
 {
  if (*pointer=='-')
   minus=-1;
  if (*pointer<'0')
  {
   remove_current_char(pointer);
   continue;
  }
  if (*pointer>'z')
  {
   remove_current_char(pointer);
   continue;
  }
  if ((*pointer>'9')&&(*pointer<'A'))
  {
   remove_current_char(pointer);
   continue;
  }
  if (((*pointer>'Z')&&(*pointer<'a'))&&(*pointer!='_'))
  {
   remove_current_char(pointer);
   continue;
  }
  pointer++;
 }
 /* goto end */
 pointer=string;
 while ((*(pointer)!=(char)0)&&(*(pointer)!='_'))
  pointer++;

 if (*(pointer)==(char)0)
 {
  pointer--;
/*
  if ((*(pointer)=='b')||(*(pointer)=='B'))
  {
   *(pointer)=0;
   return 2*minus;
  }
*/
  if ((*(pointer)=='h')||(*(pointer)=='H'))
  {
   *(pointer)=0;
   return 16*minus;
  }
  if ((*(pointer)=='o')||(*(pointer)=='O'))
  {
   *(pointer)=0;
   return 8*minus;
  }
  pointer++;
 }

 if (*(pointer)==(char)0) /* no end == 10 */
  return 10*minus;
 *pointer=(char)0; /* string correct before radix terminating */
 pointer++;
 if ((*(pointer)=='b')||(*(pointer)=='B'))
  return 2*minus;
 if ((*(pointer)=='h')||(*(pointer)=='H'))
  return 16*minus;
 if ((*(pointer)=='o')||(*(pointer)=='O'))
  return 8*minus;
 return convert(pointer,10)*minus;
}

// erstes char auf zahlenanfang
signed long int get_zahl(char *string)
{
 static char _line[MAXBUFF];
 int i=0;
 int radix;
 signed int minus;
 unsigned long int zahl;
 strcpy(_line,string);
 // remove space
 while (((_line[i])&&(isspace(_line[i])))||(_line[i]=='#'))
 {
  remove_current_char(_line+i);
 }
 // no leading space
 while ((_line[i]) &&
        ( (isdigit(_line[i])) ||
          (toupper(_line[i])=='A')||
          (toupper(_line[i])=='B')||
          (toupper(_line[i])=='C')||
          (toupper(_line[i])=='D')||
          (toupper(_line[i])=='E')||
          (toupper(_line[i])=='F')||
          (_line[i]=='$')||
          (_line[i]=='+')||
          (_line[i]=='-')||

          (toupper(_line[i])=='O')||
          (toupper(_line[i])=='X')||
          (toupper(_line[i])=='H')
        )
       )
 {
  i++;
 }
 _line[i]=0;

 // spaceless string
 replace(_line,"0x","$");
 replace(_line,"0X","$");
 if (_line[0]=='$')
 {
  remove_current_char(_line);
  minus=pruef(_line);
  radix=16;
 }
 else
 {
  minus=radix=pruef(_line);
  if (radix<0) radix*=-1;
 }
 if (!(((_line[0]>'9')&&(radix!=16))||((!_line[0]))))
  zahl=convert(_line,radix);
 else
  zahl=1000000;
 if (minus<0)
  return -zahl;
 return zahl;
}
