#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//#include <dos.h>   /* fuer allocmem */
#include <malloc.h>  /* fuer coreleft() */

#include "standard.h"
#include "keyboard.h"
#include "tools.h"
#include "request.h"
#include "error.h"

/* /////////////////////////////////////////////////////////////////////////////////////// */
/* ///////////////////// FILE REQUESTER START //////////////////////////////////////////// */
/* /////////////////////////////////////////////////////////////////////////////////////// */

typedef struct
{
  T_INT old_print_modus;
  T_INT old_text;
  T_INT old_back_color;
  T_INT old_text_color;

  T_INT shown_drives;
  T_INT zaehler;
  T_INT drives_da;
  T_INT raus;
  T_INT selected_file;
  T_INT start_file;
  T_INT selected_drive;
  T_INT start_drive;
  T_INT end_drive;
  T_INT redraw;
  T_INT return_ok;
  T_INT key;
  T_INT flag;
  DIR_ARRAY *dir;

  T_PCHAR start_path;
  T_PCHAR current_path;
  T_PCHAR drives;
  T_CHAR drive_string[3];
  T_PCHAR current_file_name;
  T_PCHAR maske;
}FILE_REQUEST_VARIABLEN;

/* Modul globale Funktionen */
T_INT file_requester_abort( WINDOW_LISTEN_ELEMENT *window);
T_INT file_requester_destructor(PARAMETER *parameter);
T_INT file_requester_area_funktion(PARAMETER *parameter);
T_INT file_requester_tasten_funktion(PARAMETER *parameter);

T_INT execute_file_cancel_button(PARAMETER *parameter);
T_INT execute_file_accept_button(PARAMETER *parameter);
T_INT execute_file_up_button(PARAMETER *parameter);
T_INT execute_file_down_button(PARAMETER *parameter);
T_INT execute_volume_up_button(PARAMETER *parameter);
T_INT execute_volume_down_button(PARAMETER *parameter);
T_VOID do_file_redraw(PARAMETER *parameter);

/* out of the general stack fram ... */

static FILE_REQUEST_VARIABLEN *v=NULL;
static WINDOW_LISTEN_ELEMENT *file_window=NULL;
static BUTTON *file_cancel=NULL;
static BUTTON *file_accept=NULL;
static BUTTON *file_up=NULL;
static BUTTON *file_down=NULL;
static BUTTON *volume_up=NULL;
static BUTTON *volume_down=NULL;
static T_INT id=FILE_REQUEST;
static OPEN_WIN w;
//  if ((maske==NULL)||(maske[1]!='.')||(strlen(maske)>5)||(strlen(maske)<2))
// diese Bedingung MUSS erfuellt sein!
T_PCHAR get_file_name(T_PCHAR maske, T_INT flag)
{
 VARIABLEN variablen;
 T_DEBUG_ENTRY("get_file_name",70)
 if (vesa_y<300)
 {
  show_message("Ooops, try a higher\n resolution.\nDidn't bother\n to support\nlow resolutions...");
  T_DEBUG_FUNCTION_POSITION(121)
  T_DEBUG_LEAVE
  return NULL;
 }
 variablen.ebene=dispatcher_ebene+1;
 variablen.pointer=NULL;
 variablen.variablen=NULL;
 v=NULL;
 file_window=NULL;
 file_cancel=NULL;
 file_accept=NULL;
 file_up=NULL;
 file_down=NULL;
 volume_up=NULL;
 volume_down=NULL;
 id=FILE_REQUEST;
 while ((window_exist(id)==T_TRUE)&&(id<FILE_REQUEST+100))
  id++;
 if (id==FILE_REQUEST+100)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return NULL;
 }
 v=(FILE_REQUEST_VARIABLEN *)malloc(sizeof(FILE_REQUEST_VARIABLEN));
 if (v==NULL)
 {
  show_message("Kein Speicherplatz fuer FILE Requester");
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return NULL;
 }
 w.x_pos=0;
 w.y_pos=0;
 w.breite=246;
 w.hoehe=300;
 w.bcolor=dhell_grau;
 w.color=ddark_grau;
 w.border=0;
 w.art=RAW_WINDOW | AREA_WINDOW | RETURNING;
 w.id=id;
 w.variablen=&variablen;
 w.mem_bild=NULL;
 w.name=NULL;
// w.name="Filerequester";
 w.pcx_bild=NULL;
 w.destructor=file_requester_destructor;
 w.area_funktion=file_requester_area_funktion;
 w.tasten_funktion=file_requester_tasten_funktion;
 file_window=open_window(&w);
 if (file_window==NULL)
 {
  free(v);
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return NULL;
 }
 variablen.variablen=v;
 v->flag=flag;
 v->old_print_modus=vesa_print_modus;
 v->old_text=vesa_text;
 v->old_back_color=vesa_back_color;
 v->old_text_color=vesa_text_color;
 v->shown_drives=0;
 v->zaehler=0;
 v->drives_da=0;
 v->raus=0;
 v->selected_file=-1;
 v->start_file=0;
 v->selected_drive=-1;
 v->start_drive=0;
 v->end_drive=0;
 v->redraw=0;
 v->return_ok=0;
 v->key=0;
 v->dir=NULL;
 v->start_path=NULL;
 v->current_path=NULL;
 v->drives=NULL;
 strcpy(v->drive_string,"A:");
 v->current_file_name=NULL;
 v->maske=NULL;
 if ((maske==NULL)||(maske[1]!='.')||(strlen(maske)>5)||(strlen(maske)<2))
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(5)
  T_DEBUG_LEAVE
  return NULL;
 }
 v->maske=strdup(maske);
 if (v->maske==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(6)
  T_DEBUG_LEAVE
  return NULL;
 }
 v->current_file_name=(T_PCHAR )malloc(260*sizeof(T_CHAR)); /* filename+pfad */
 if (v->current_file_name==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(7)
  T_DEBUG_LEAVE
  return NULL;
 }
 v->current_file_name[0]=0;
 v->drives=(T_PCHAR )malloc(('Z'-'A'+1)*sizeof(T_CHAR));
 if (v->drives==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(8)
  T_DEBUG_LEAVE
  return NULL;
 }
 check_drives(v->drives);
 if (v->drives==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(9)
  T_DEBUG_LEAVE
  return NULL;
 }
 v->dir=file_get_dir(v->maske);
 if (v->dir==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(10)
  T_DEBUG_LEAVE
  return NULL;
 }
 v->current_path=get_current_path();
 if (v->current_path==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(11)
  T_DEBUG_LEAVE
  return NULL;
 }
 v->start_path=strdup(v->current_path);
 if (v->start_path==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(12)
  T_DEBUG_LEAVE
  return NULL;
 }
 v->selected_drive=v->current_path[0]-'A';
 is_upper=T_TRUE;
 MOUSE_VERSTECKE
 print_srect(file_window,PRINT_WIN_RAW,0,0,file_window->b,file_window->h,ddark_grau,weiss,1);
 wprint_srect(file_window,216,29,24,193,weiss,ddark_grau,1);
 wprint_srect(file_window,10,10,200,231,weiss,ddark_grau,1);
 wprint_srect(file_window,46,245,194,21,weiss,ddark_grau,1);
 wprint_srect(file_window,55,271,121,21,weiss,ddark_grau,1);
 wprint_srect(file_window,182,271,59,21,weiss,ddark_grau,1);
 MOUSE_ZEIGE
 is_upper=T_FALSE;
 file_cancel = make_mem_bild_button(nein,default_back_pixel,ddark_grau,
 mdark_grau,dhell_grau,mhell_grau,2,KEY_ESCAPE,SWITCH_ON_RELEASED);
 if (file_cancel==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(13)
  T_DEBUG_LEAVE
  return NULL;
 }
 add_wbutton(file_window,file_cancel,5,274,CANCEL_BUTTON);
 file_cancel->button_funktion=execute_file_cancel_button;
 file_accept = make_mem_bild_button(ja,default_back_pixel,ddark_grau,
 mdark_grau,dhell_grau,mhell_grau,2,KEY_ENTER,SWITCH_ON_RELEASED);
 if (file_accept==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(14)
  T_DEBUG_LEAVE
  return NULL;
 }
 add_wbutton(file_window,file_accept,30,274,ACCEPT_BUTTON);
 file_accept->button_funktion=execute_file_accept_button;
 file_up=make_mem_bild_button(hoch,default_back_pixel,ddark_grau,mdark_grau,
 dhell_grau,mhell_grau,2,KEY_UP,SWITCH_ON_PRESSED);
 if (file_up==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(15)
  T_DEBUG_LEAVE
  return NULL;
 }
 add_wbutton(file_window,file_up,5,247,UP_FILE_BUTTON);
 file_up->button_funktion=execute_file_up_button;
 file_down=make_mem_bild_button(runter,default_back_pixel,ddark_grau,
 mdark_grau,dhell_grau,mhell_grau,2,KEY_DOWN,SWITCH_ON_PRESSED);
 if (file_down==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(16)
  T_DEBUG_LEAVE
  return NULL;
 }
 add_wbutton(file_window,file_down,25,247,DOWN_FILE_BUTTON);
 file_down->button_funktion=execute_file_down_button;
 volume_up=make_mem_bild_button(hoch,default_back_pixel,ddark_grau,
 mdark_grau,dhell_grau,mhell_grau,2,KEY_PGUP,SWITCH_ON_PRESSED);
 if (volume_up==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(17)
  T_DEBUG_LEAVE
  return NULL;
 }
 add_wbutton(file_window,volume_up,220,10,UP_VOLUME_BUTTON);
 volume_up->button_funktion=execute_volume_up_button;
 volume_down=make_mem_bild_button(runter,default_back_pixel,ddark_grau,
 mdark_grau,dhell_grau,mhell_grau,2,KEY_PGDN,SWITCH_ON_PRESSED);
 if (volume_down==NULL)
 {
  file_requester_abort(file_window);
  T_DEBUG_FUNCTION_POSITION(18)
  T_DEBUG_LEAVE
  return NULL;
 }
 add_wbutton(file_window,volume_down,220,225,DOWN_VOLUME_BUTTON);
 volume_down->button_funktion=execute_volume_down_button;
 vesa_print_modus=PIC_ON_BACK;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=hhell_grau;
 vesa_text_color=ddark_grau;
 is_upper=T_TRUE;
 wprint_max(file_window,48,247,8*23,v->current_path);
 v->zaehler=0;
 v->start_file=0;
 while (( v->zaehler <14)&&( v->zaehler + v->start_file < v->dir->anzahl_eintraege))
 {
  if ((v->dir->file[v->zaehler].d_attr&16)||(v->dir->file[v->zaehler].d_attr&8))
   vesa_text_color=weiss;
  wprint(file_window,19,15+v->zaehler*16,v->dir->file[v->zaehler].d_name);
  if ((v->dir->file[v->zaehler].d_attr&16)||(v->dir->file[v->zaehler].d_attr&8))
  {
   if (v->dir->file[v->zaehler].d_attr&8)
    wprint(file_window,15+23*8-3*8,15+v->zaehler*16,"VOL");
   else
    wprint(file_window,15+23*8-3*8,15+v->zaehler*16,"DIR");
   vesa_text_color=ddark_grau;
  }
  else
   wprinta1(file_window,15+23*8-8*8,15+v->zaehler*16,"%8u",v->dir->file[v->zaehler].d_size);
  v->zaehler++;
 }
 v->zaehler=0;
 v->shown_drives=0;
 v->start_drive=0;
 while ((v->zaehler<(T_BYTE)('Z'-'A'+1))&&(v->shown_drives<12))
 {
  if (v->drives[v->zaehler]==1)
  {
   v->drive_string[0]=v->zaehler+'A';
   if (v->selected_drive==v->zaehler)
   {
    vesa_text_color=schwarz;
    wprint(file_window,220,30+v->shown_drives*16,v->drive_string);
    vesa_text_color=ddark_grau;
   }
   else
    wprint(file_window,220,30+v->shown_drives*16,v->drive_string);
   v->shown_drives++;
   v->end_drive=v->zaehler;
  }
  v->zaehler++;
 }
 v->zaehler=0;
 while (v->zaehler<(T_BYTE)('Z'-'A'+1))
 {
  if (v->drives[v->zaehler]==1)
  {
   v->drives_da++;
  }
  v->zaehler++;
 }
 wprint(file_window,190,273,v->maske+2);
 is_upper=T_FALSE;
 vesa_print_modus=v->old_print_modus;
 vesa_text=v->old_text;
 vesa_back_color=v->old_back_color;
 vesa_text_color=v->old_text_color;
 #pragma warn -eff
 while (vesa_mouse_button)
  vesa_mouse_update();
 #pragma warn .eff
 WAIT_FOR_REPLY
 T_DEBUG_LEAVE
 return (T_PCHAR)variablen.pointer;
}

/***************************************************************/

T_INT file_requester_abort(WINDOW_LISTEN_ELEMENT *window)
{
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("file_requester_abort",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if (window!=NULL)
 {
  window->destructor=NULL;
  if (v!=NULL)
  {
   /* Window spezifische Freigaben Anfang */
   if (v->maske!=NULL)
   {
    free(v->maske);
    v->maske=NULL;
   }
   if (v->current_file_name!=NULL)
   {
    free(v->current_file_name);
    v->current_file_name=NULL;
   }
   if (v->drives!=NULL)
   {
    free(v->drives);
    v->drives=NULL;
   }
   if (v->dir!=NULL)
   {
    free(v->dir);
    v->dir=NULL;
   }
   if (v->current_path!=NULL)
   {
    free(v->current_path);
    v->current_path=NULL;
   }
   if (v->start_path!=NULL)
   {
    free(v->start_path);
    v->start_path=NULL;
   }
   /* Window spezifische Freigaben Ende */
   free(v);         /* must be != NULL, otherwise abort would not be called */
   window->variablen->variablen=NULL;
  }
  close_window(window,CLOSE_DEFAULT);
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT file_requester_destructor(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_PCHAR dup_name=NULL;
 T_DEBUG_ENTRY("file_requester_destructor",70)
 if (parameter==NULL)
 {
  show_message("Ungueltiger Parameter in DESTRUCTOR()");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return -1; // what else?
 }
 parameter->executed=PARAMETER_EXECUTED;
 if (window==NULL)
 {
  show_message("Ich kann mich nicht finden!!! (Window nicht geschlossen)");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 variablen=window->variablen;
 v=variablen->variablen;
 if (variablen->ebene!=dispatcher_ebene)
 {
  T_DEBUG_PROTOCOLL(("file_requester_destructor(): dispatcher_missmatch()"))
  dispatcher_missmatch();
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  DIRTY_RETURN
 }
 window->destructor=NULL;
 close_window(window,CLOSE_DEFAULT);
 parameter->executed=PARAMETER_RETURNING;
 if ((v->current_path[0]!=0)&&(v->current_path!=NULL))
  dup_name=strdup(v->current_path);
 variablen->pointer=dup_name;
 if (v!=NULL)
 {
  /* Window spezifische Freigaben Anfang */
  if (v->maske!=NULL)
  {
   free(v->maske);
   v->maske=NULL;
  }
  if (v->current_file_name!=NULL)
  {
   free(v->current_file_name);
   v->current_file_name=NULL;
  }
  if (v->drives!=NULL)
  {
   free(v->drives);
   v->drives=NULL;
  }
  if (v->dir!=NULL)
  {
   free(v->dir);
   v->dir=NULL;
  }
  if (v->current_path!=NULL)
  {
   free(v->current_path);
   v->current_path=NULL;
  }
  if (v->start_path!=NULL)
  {
   change_directory(v->start_path);
   free(v->start_path);
   v->start_path=NULL;
  }
  /* Window spezifische Freigaben Ende */
  free(v);         /* must be != NULL, otherwise abort would not be called */
  variablen->variablen=NULL;
 }
 T_DEBUG_LEAVE
 CLEAN_RETURN
}

/***************************************************************/

T_INT execute_file_cancel_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("execute_file_cancel_button",70)
 if (fKBDisALT()==T_TRUE)
 {
  help_function("req_can.hlf",NULL);
 }
 else
 {
  variablen=window->variablen;
  v=variablen->variablen;
  if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  ENTRY_PROC
  v->current_path[0]=0; // should never be a NULL pointer */
  file_requester_destructor(parameter);
  EXIT_PROC
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_file_accept_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen=window->variablen;
 FILE_REQUEST_VARIABLEN *v=variablen->variablen;
 T_PCHAR dup_name=NULL;
 T_DEBUG_ENTRY("execute_file_accept_button",70)
 if (fKBDisALT()==T_TRUE)
 {
  help_function("req_acc.hlf",NULL);
 }
 else
 {
  if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  ENTRY_PROC
  if ((v->current_file_name[0]==0)||(v->current_file_name==NULL))
  {
   if (v->flag!=RETURN_PATH_NAME)
   {
    show_message("Kein Dateiname angegeben !!!");
   }
  }
  if ((v->flag==RETURN_FILE_NAME)&&(v->current_file_name[0]!=(T_CHAR)0) )
  {
   dup_name=strdup(v->current_file_name);
  }
  if (v->flag==RETURN_PATH_NAME)
  {
   if (v->current_path!=NULL)
   {
    if (strlen(v->current_path)+strlen(v->current_file_name)+1>=128)
    {
     show_message("strlen(Dateiname+Pfadname) >= 128 !!!");
    }
    if (v->current_path[strlen(v->current_path)-1]!='\\')
    {
     v->current_path[strlen(v->current_path)+1]=0;
     v->current_path[strlen(v->current_path)]='\\';
    }
    if (strlen(v->current_file_name))
     strcpy(v->current_path+strlen(v->current_path),v->current_file_name);
    dup_name=strdup(v->current_path);
   }
  }
  if (v->current_path!=NULL)
  {
   free(v->current_path);
  }
  v->current_path=dup_name;
  file_requester_destructor(parameter);
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_file_up_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("execute_file_up_button",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if (fKBDisALT()==T_TRUE)
 {
  help_function("req_up.hlf",NULL);
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 if (parameter->button_element==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return parameter->ebene; // CURSOR noch nicht implementiert
 }
 ENTRY_PROC
 wprint_button(window,parameter->button_element,PRESSED);
 do
 {
  if (v->start_file>0)
  {
   v->start_file--;
   do_file_redraw(parameter);
  }
  else
  {
   // normale cursor bewegungen
  }
  vesa_mouse_update();
 }
 while ((vesa_mouse_button==1)&&(is_mouse_on_this_button(window,parameter->button_element)));
 wprint_button(window,parameter->button_element,RELEASED);
 parameter->executed=PARAMETER_EXECUTED;
 EXIT_PROC
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_file_down_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("execute_file_down_button",70)
 if (fKBDisALT()==T_TRUE)
 {
  help_function("req_dwn.hlf",NULL);
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 variablen=window->variablen;
 v=variablen->variablen;
 if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 if (parameter->button_element==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return parameter->ebene; // CURSOR noch nicht implementiert
 }
 ENTRY_PROC
 wprint_button(window,parameter->button_element,PRESSED);
 do
 {
  if (v->start_file+14<v->dir->anzahl_eintraege)
  {
   v->start_file++;
   do_file_redraw(parameter);
  }
  else
  {
   // normale cursor bewegungen
  }
  vesa_mouse_update();
 }
 while ((vesa_mouse_button==1)&&(is_mouse_on_this_button(window,parameter->button_element)));
 wprint_button(window,parameter->button_element,RELEASED);
 parameter->executed=PARAMETER_EXECUTED;
 EXIT_PROC
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_volume_up_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("execute_volume_up_button",70)
 if (fKBDisALT()==T_TRUE)
 {
  help_function("req_vup.hlf",NULL);
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 variablen=window->variablen;
 v=variablen->variablen;
 if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 if (parameter->button_element==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return parameter->ebene;// CURSOR noch nicht implementiert
 }
 ENTRY_PROC
 wprint_button(window,parameter->button_element,PRESSED);
 v->old_print_modus=vesa_print_modus;
 v->old_text=vesa_text;
 v->old_back_color=vesa_back_color;
 v->old_text_color=vesa_text_color;
 do
 {
  v->zaehler=v->start_drive-1;
  while ((v->drives[v->zaehler]==0)&&(v->zaehler>=0))
   v->zaehler--;
  if (v->zaehler!=-1)
  {
   v->zaehler=v->start_drive-1;
   while ((v->drives[v->zaehler]==0)&&(v->zaehler>0))
    v->zaehler--;
   v->start_drive=v->zaehler;
   v->shown_drives=0;
   vesa_print_modus=PIC_ON_BACK;
   vesa_text=SINGLE_COLOR;
   vesa_back_color=dhell_grau;
   vesa_text_color=ddark_grau;
   while ((v->zaehler<(T_BYTE)('Z'-'A'+1))&&(v->shown_drives<12))
   {
    if (v->drives[v->zaehler]==1)
    {
     v->drive_string[0]=v->zaehler+'A';
     wprint_frect(window,220,30+v->shown_drives*16,2*8,16-1,dhell_grau);
     if (v->selected_drive==v->zaehler)
     {
      vesa_text_color=schwarz;
      wprint(window,220,30+v->shown_drives*16,v->drive_string);
      vesa_text_color=ddark_grau;
     }
     else
      wprint(window,220,30+v->shown_drives*16,v->drive_string);
     v->shown_drives++;
     v->end_drive=v->zaehler;
    }
    v->zaehler++;
   }
  }
  vesa_mouse_update();
 }
 while ((vesa_mouse_button==1)&&(is_mouse_on_this_button(window,parameter->button_element)));
 wprint_button(window,parameter->button_element,RELEASED);
 vesa_print_modus=v->old_print_modus;
 vesa_text=v->old_text;
 vesa_back_color=v->old_back_color;
 vesa_text_color=v->old_text_color;
 parameter->executed=PARAMETER_EXECUTED;
 EXIT_PROC
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_volume_down_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("execute_volume_down_button",70)
 if (fKBDisALT()==T_TRUE)
 {
  help_function("req_vdn.hlf",NULL);
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 variablen=window->variablen;
 v=variablen->variablen;
 if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 if (parameter->button_element==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return parameter->ebene; // CURSOR noch nicht implementiert
 }
 ENTRY_PROC
 wprint_button(window,parameter->button_element,PRESSED);
 v->old_print_modus=vesa_print_modus;
 v->old_text=vesa_text;
 v->old_back_color=vesa_back_color;
 v->old_text_color=vesa_text_color;
 do
 {
  v->zaehler=v->end_drive+1;
  while ((v->drives[v->zaehler]==0)&&(v->zaehler<(T_BYTE)('Z'-'A'+1)))
   v->zaehler++;
  if (v->zaehler!=(T_BYTE)('Z'-'A'+1))
  {
   v->zaehler=v->start_drive+1;
   while ((v->drives[v->zaehler]==0)&&(v->zaehler<(T_BYTE)('Z'-'A'+1)))
    v->zaehler++;
   v->start_drive=v->zaehler;
   v->shown_drives=0;
   vesa_print_modus=PIC_ON_BACK;
   vesa_text=SINGLE_COLOR;
   vesa_back_color=dhell_grau;
   vesa_text_color=ddark_grau;
   while ((v->zaehler<(T_BYTE)('Z'-'A'+1))&&(v->shown_drives<12))
   {
    if (v->drives[v->zaehler]==1)
    {
     v->drive_string[0]=v->zaehler+'A';
      wprint_frect(window,220,30+v->shown_drives*16,2*8,16-1,dhell_grau);
     if (v->selected_drive==v->zaehler)
     {
      vesa_text_color=schwarz;
      wprint(window,220,30+v->shown_drives*16,v->drive_string);
      vesa_text_color=ddark_grau;
     }
     else
      wprint(window,220,30+v->shown_drives*16,v->drive_string);
     v->shown_drives++;
     v->end_drive=v->zaehler;
    }
    v->zaehler++;
   }
  }
  vesa_mouse_update();
 }
 while ((vesa_mouse_button==1)&&(is_mouse_on_this_button(window,parameter->button_element)));
 wprint_button(window,parameter->button_element,RELEASED);
 vesa_print_modus=v->old_print_modus;
 vesa_text=v->old_text;
 vesa_back_color=v->old_back_color;
 vesa_text_color=v->old_text_color;
 parameter->executed=PARAMETER_EXECUTED;
 EXIT_PROC
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT file_requester_area_funktion(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_INT maus_x=parameter->maus_x-(window->x+window->x_0);
 T_INT maus_y=parameter->maus_y-(window->y+window->y_0);
 T_DEBUG_ENTRY("file_requester_area_funktion",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 ENTRY_PROC
 parameter->executed=PARAMETER_EXECUTED;
 aktivate_window(window);
 if (parameter->maus_button==1)
 {
  v->old_print_modus=vesa_print_modus;
  v->old_text=vesa_text;
  v->old_back_color=vesa_back_color;
  v->old_text_color=vesa_text_color;
 /*************************************/
  if ((maus_x>55)&&(maus_x<174)&&(maus_y>271)&&(maus_y<291))
  {
   /* file_namen */
   T_INT start_zeichen=0;
   text_eingabe(v->current_file_name,&start_zeichen,60,273,12,12,ddark_grau,dhell_grau, window);
   if (v->selected_file!=-1)
   {
    vesa_print_modus=PIC_ON_BACK;
    vesa_text=SINGLE_COLOR;
    vesa_back_color=hhell_grau;
    vesa_text_color=ddark_grau;
    wprint(window,19,15+(v->selected_file-v->start_file)*16,v->dir->file[v->selected_file].d_name);
    v->selected_file=-1;
   }
  }
 /*************************************/
  if ((maus_x>216)&&(maus_x<240)&&(maus_y>29)&&(maus_y<216))
  {
   /* laufwerke */
   T_INT position=(maus_y-30)/16;
   T_INT new_drive=0;
   T_INT hits=0;
   v->zaehler=v->start_drive;
   while ((hits!=position)&&(v->zaehler<=v->drives_da))
   {
    if (v->drives[v->zaehler]==1)
     hits++;
    v->zaehler++;
   }
   if (v->zaehler<=v->drives_da)
   {
    new_drive=v->zaehler;
    if (new_drive!=v->selected_drive)
    {
     if (drive_check(new_drive)==T_OK)
     {
      change_drive(new_drive);
      free(v->current_path);
      v->current_path=get_current_path();
      if (v->current_path==NULL)
      {
       show_message("Etwas unerwartetes passierte mit Pfad:...");
       EXIT_PROC
       file_requester_destructor(parameter);
       T_DEBUG_FUNCTION_POSITION(2)
       T_DEBUG_LEAVE
       return parameter->ebene;
      }
      vesa_print_modus=PIC_ON_BACK;
      vesa_text=SINGLE_COLOR;
      vesa_back_color=hhell_grau;
      vesa_text_color=ddark_grau;
      wprint_frect(window,48,247,239-48,265-247,dhell_grau);
      wprint_max(window,48,247,8*23,v->current_path);
      free(v->dir);
      v->dir=file_get_dir(v->maske);
      if (v->dir==NULL)
      {
       show_message("Etwas unerwartetes passierte mit Directory:...");
       EXIT_PROC
       file_requester_destructor(parameter);
       T_DEBUG_FUNCTION_POSITION(3)
       T_DEBUG_LEAVE
       return parameter->ebene;
      }
      v->current_file_name[0]=0;
      v->selected_drive=v->current_path[0]-'A';
      v->zaehler=0;
      v->shown_drives=0;
      while ((v->zaehler+v->start_drive<(T_BYTE)('Z'-'A'+1))&&(v->shown_drives<12))
      {
       if (v->drives[v->zaehler+v->start_drive]==1)
       {
        v->drive_string[0]=v->zaehler+v->start_drive+'A';
        if (v->selected_drive==v->zaehler+v->start_drive)
        {
         vesa_text_color=schwarz;
         wprint(window,220,30+v->shown_drives*16,v->drive_string);
         vesa_text_color=ddark_grau;
        }
        else
         wprint(window,220,30+v->shown_drives*16,v->drive_string);
        v->shown_drives++;
        v->end_drive=v->zaehler+v->start_drive;
       }
       v->zaehler++;
      }
      v->start_file=0;
      v->redraw=1;
     }
    }
   }
  }
 /*************************************/
  if ((maus_x>182)&&(maus_x<240)&&(maus_y>271)&&(maus_y<291))
  {
   /* maske */
   T_INT start_zeichen=0;
   T_PCHAR save_maske=strdup(v->maske);
   text_eingabe(v->maske+2,&start_zeichen,190,273,3,3,ddark_grau,dhell_grau,window);
   free(v->dir);
   change_drive(v->selected_drive);
   change_directory(v->current_path);
   v->dir=file_get_dir(v->maske);
   if (v->dir==NULL)
   {
    strcpy(v->maske,save_maske);
    change_drive(v->selected_drive);
    change_directory(v->current_path);
    v->dir=file_get_dir(v->maske);
    if (v->dir==NULL)
    {
     show_message("Something unexpected happened to DIR:...");
     EXIT_PROC
     file_requester_destructor(parameter);
     T_DEBUG_FUNCTION_POSITION(4)
     T_DEBUG_LEAVE
     return parameter->ebene;
    }
   }
   free(save_maske);
   v->current_file_name[0]=0;
   v->start_file=0;
   v->redraw=1;
  }
 /*************************************/
  if ((maus_x>46)&&(maus_x<240)&&(maus_y>245)&&(maus_y<265))
  {
   /* pfad */
   T_INT fehler=T_OK;
   T_INT start_path=0;
   change_drive(v->selected_drive);
   change_directory(v->current_path);
   text_eingabe(v->current_path,&start_path,48,247,23,127,ddark_grau,dhell_grau,window);
   if (v->current_path[1]==':')
   {
    if (v->current_path[0]>'Z')
     v->current_path[0]-=32;
    if (v->selected_drive!=v->current_path[0]-'A')
    {
     fehler=drive_check(v->current_path[0]-'A');
    }
   }
   if (fehler==T_OK)
   {
    fehler=change_directory(v->current_path);
   }
   if (fehler!=T_OK)
   {
    free(v->current_path);
    v->current_path=get_current_path();
    if (v->current_path==NULL)
    {
     show_message("Etwas unerwartetes passierte mit Pfad:...");
     EXIT_PROC
     file_requester_destructor(parameter);
     T_DEBUG_FUNCTION_POSITION(5)
     T_DEBUG_LEAVE
     return parameter->ebene;
    }
    vesa_print_modus=PIC_ON_BACK;
    vesa_text=SINGLE_COLOR;
    vesa_back_color=hhell_grau;
    vesa_text_color=ddark_grau;
    wprint_frect(window,48,247,239-48,265-247,dhell_grau);
    wprint_max(window,48,247,8*23,v->current_path);
   }
   else
   {
    if (v->selected_drive!=v->current_path[0]-'A')
    {
     change_drive(v->current_path[0]-'A');
    }
    free(v->dir);
    v->dir=file_get_dir(v->maske);
    if (v->dir==NULL)
    {
     show_message("Etwas unerwartetes passierte mit Directory:...");
     EXIT_PROC
     file_requester_destructor(parameter);
     T_DEBUG_FUNCTION_POSITION(6)
     T_DEBUG_LEAVE
     return parameter->ebene;
    }
    v->current_file_name[0]=0;
    vesa_print_modus=PIC_ON_BACK;
    vesa_text=SINGLE_COLOR;
    vesa_back_color=hhell_grau;
    vesa_text_color=ddark_grau;
    v->selected_drive=v->current_path[0]-'A';
    v->zaehler=0;
    v->shown_drives=0;
    while ((v->zaehler+v->start_drive<(T_BYTE)('Z'-'A'+1))&&(v->shown_drives<12))
    {
     if (v->drives[v->zaehler+v->start_drive]==1)
     {
      v->drive_string[0]=v->zaehler+v->start_drive+'A';
      if (v->selected_drive==v->zaehler+v->start_drive)
      {
       vesa_text_color=schwarz;
       wprint(window,220,30+v->shown_drives*16,v->drive_string);
       vesa_text_color=ddark_grau;
      }
      else
       wprint(window,220,30+v->shown_drives*16,v->drive_string);
      v->shown_drives++;
      v->end_drive=v->zaehler+v->start_drive;
     }
     v->zaehler++;
    }
    v->start_file=0;
    v->redraw=1;
   }
  }
 /*************************************/
  if ((maus_x>10)&&(maus_x<210)&&(maus_y>10)&&(maus_y<235))
  {
   /* file_namen_maus */
   T_INT position=(maus_y-15)/16;
   if (v->start_file+position<v->dir->anzahl_eintraege)
   {
    if ((!(v->dir->file[position+v->start_file].d_attr&16))
    &&(!(v->dir->file[position+v->start_file].d_attr&8)))
    {
     vesa_print_modus=PIC_ON_BACK;
     vesa_text=SINGLE_COLOR;
     vesa_back_color=hhell_grau;
     vesa_text_color=ddark_grau;
     if ((v->selected_file!=-1)&&(position+v->start_file!=v->selected_file)
     &&(v->selected_file-v->start_file>=0)&&(v->selected_file-v->start_file<14))
     {
      wprint(window,19,15+(v->selected_file-v->start_file)*16,v->dir->file[v->selected_file].d_name);
     }
     if (position+v->start_file!=v->selected_file)
     {
      strcpy(v->current_file_name,v->dir->file[position+v->start_file].d_name);
      wprint_frect(window,60,273,12*8,291-273,dhell_grau);
      wprint(window,60,273,v->current_file_name);
      vesa_text_color=schwarz;
      wprint(window,19,15+position*16,v->dir->file[position+v->start_file].d_name);
      v->selected_file=position+v->start_file;
     }
    }
    if (v->dir->file[position+v->start_file].d_attr&16)
    {
     if (!((v->dir->file[position+v->start_file].d_name[0]=='.')
     &&(v->dir->file[position+v->start_file].d_name[1]==0)))
     {
      /* in ein directory hineingehen */
      change_drive(v->selected_drive);
      change_directory(v->current_path);
      change_directory(v->dir->file[position+v->start_file].d_name);
      free(v->current_path);
      v->current_path=get_current_path();
      if (v->current_path==NULL)
      {
       show_message("Etwas unerwartetes passierte mit Pfad:...");
       EXIT_PROC
       file_requester_destructor(parameter);
       T_DEBUG_FUNCTION_POSITION(7)
       T_DEBUG_LEAVE
       return parameter->ebene;
      }
      free(v->dir);
      v->dir=file_get_dir(v->maske);
      if (v->dir==NULL)
      {
       show_message("Etwas unerwartetes passierte mit Directory:...");
       EXIT_PROC
       file_requester_destructor(parameter);
       T_DEBUG_FUNCTION_POSITION(8)
       T_DEBUG_LEAVE
       return parameter->ebene;
      }
      v->current_file_name[0]=0;
      vesa_print_modus=PIC_ON_BACK;
      vesa_text=SINGLE_COLOR;
      vesa_back_color=hhell_grau;
      vesa_text_color=ddark_grau;
      v->zaehler=0;
      v->shown_drives=0;
      while ((v->zaehler+v->start_drive<(T_BYTE)('Z'-'A'+1))&&(v->shown_drives<12))
      {
       if (v->drives[v->zaehler+v->start_drive]==1)
       {
        v->drive_string[0]=v->zaehler+v->start_drive+'A';
        if (v->selected_drive==v->zaehler+v->start_drive)
        {
         vesa_text_color=schwarz;
         wprint(window,220,30+v->shown_drives*16,v->drive_string);
         vesa_text_color=ddark_grau;
        }
        else
         wprint(window,220,30+v->shown_drives*16,v->drive_string);
        v->shown_drives++;
        v->end_drive=v->zaehler+v->start_drive;
       }
       v->zaehler++;
      }
      wprint_frect(window,48,247,239-48,265-247,dhell_grau);
      wprint_max(window,48,247,8*23,v->current_path);
      v->start_file=0;
      v->redraw=1;
     }
    }
    #pragma warn -eff
    while (vesa_mouse_button==1)
     vesa_mouse_update();
    #pragma warn .eff
   }
  }
 /*************************************/
  vesa_print_modus=v->old_print_modus;
  vesa_text=v->old_text;
  vesa_back_color=v->old_back_color;
  vesa_text_color=v->old_text_color;
  if (v->redraw==1)
  {
   do_file_redraw(parameter);
  }
 }
 else
 {
  if (parameter->maus_button==2)
  {
   move_window(window);
  }
 }
 EXIT_PROC
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_VOID do_file_redraw(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_INT x=(window->x+window->x_0);
 T_INT y=(window->y+window->y_0);
 T_DEBUG_ENTRY("do_file_redraw",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 ENTRY_PROC
 v->redraw=0;
 v->selected_file=-1;
 v->zaehler=0;
 v->old_print_modus=vesa_print_modus;
 v->old_text=vesa_text;
 v->old_back_color=vesa_back_color;
 v->old_text_color=vesa_text_color;
 vesa_print_modus=PIC_ON_BACK;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=dhell_grau;
 vesa_text_color=ddark_grau;
 vesa_rect_fill(x+60,y+273,12*8,291-273,dhell_grau);
 v->zaehler=0;
 while ((v->zaehler<14)&&(v->zaehler+v->start_file<v->dir->anzahl_eintraege))
 {
  vesa_rect_fill(x+19,y+15+v->zaehler*16,(13+10)*8,16,dhell_grau);
  if ((v->dir->file[v->zaehler+v->start_file].d_attr&16)||(v->dir->file[v->zaehler+v->start_file].d_attr&8))
  {
   vesa_text_color=weiss;
   vesa_print_str(x+19,y+15+v->zaehler*16,v->dir->file[v->zaehler+v->start_file].d_name);
   if (v->dir->file[v->zaehler+v->start_file].d_attr&8)
    vesa_print_str(x+15+23*8-3*8,y+15+v->zaehler*16,"VOL");
   else
    vesa_print_str(x+15+23*8-3*8,y+15+v->zaehler*16,"DIR");
   vesa_text_color=ddark_grau;
  }
  else
  {
   T_CHAR help_string[11];
   if (v->zaehler+v->start_file==v->selected_file)
   {
    vesa_text_color=schwarz;
    vesa_print_str(x+19,y+15+v->zaehler*16,v->dir->file[v->zaehler+v->start_file].d_name);
    vesa_text_color=ddark_grau;
   }
   else
    vesa_print_str(x+19,y+15+v->zaehler*16,v->dir->file[v->zaehler+v->start_file].d_name);
   ltoa(v->dir->file[v->zaehler+v->start_file].d_size,help_string,10);
   vesa_print_str(x+15+23*8-strlen(help_string)*8,y+15+v->zaehler*16,help_string);
  }
  v->zaehler++;
 }
 while (v->zaehler<14)
 {
  vesa_rect_fill(x+19,y+15+v->zaehler*16,(13+10)*8,16,dhell_grau);
  v->zaehler++;
 }
 update_whole_window(window);
 vesa_print_modus=v->old_print_modus;
 vesa_text=v->old_text;
 vesa_back_color=v->old_back_color;
 vesa_text_color=v->old_text_color;
 T_DEBUG_LEAVE
 EXIT_PROC
}

/***************************************************************/

T_INT file_requester_tasten_funktion(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 FILE_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("file_requester_tasten_funktion",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if ((parameter==NULL)||(window==NULL)||(variablen==NULL)||(v==NULL))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 ENTRY_PROC
 if (((parameter->taste>='a')&&(parameter->taste<='z'))||((parameter->taste>='A')&&(parameter->taste<='Z')))
 {
  /* file_namen */
  T_INT start_zeichen=strlen(v->current_file_name);
  parameter->executed=PARAMETER_EXECUTED;
#pragma warn -pia
  if (start_zeichen<12)
#pragma warn .pia
  {
   v->current_file_name[start_zeichen]=parameter->taste;
   v->current_file_name[start_zeichen+1]=0;
  }
  else
   v->current_file_name[start_zeichen-1]=parameter->taste;
  v->old_print_modus=vesa_print_modus;
  v->old_text=vesa_text;
  v->old_back_color=vesa_back_color;
  v->old_text_color=vesa_text_color;
  vesa_print_modus=PIC_ON_BACK;
  vesa_text=SINGLE_COLOR;
  vesa_back_color=hhell_grau;
  vesa_text_color=ddark_grau;
  start_zeichen=0;
  wprint(window,60,273,v->current_file_name);
  text_eingabe(v->current_file_name,&start_zeichen,60,273,12,12,ddark_grau,dhell_grau, window);
  if (v->selected_file!=-1)
  {
   wprint(window,19,15+(v->selected_file-v->start_file)*16,v->dir->file[v->selected_file].d_name);
   v->selected_file=-1;
  }
  vesa_print_modus=v->old_print_modus;
  vesa_text=v->old_text;
  vesa_back_color=v->old_back_color;
  vesa_text_color=v->old_text_color;
 }
 EXIT_PROC
 T_DEBUG_LEAVE
 return parameter->ebene;
}
/* //////////////////////////////////////////////////////////////////////////////////////// */
/* ////////////////////// FILE REQUESTER ENDE ///////////////////////////////////////////// */
/* //////////////////////////////////////////////////////////////////////////////////////// */



/* //////////////////////////////////////////////////////////////////////////////////////// */
/* ////////////////////// ZAHL REQUESTER START //////////////////////////////////////////// */
/* //////////////////////////////////////////////////////////////////////////////////////// */

 typedef struct
 {
  T_LONG min;
  T_LONG max;
  T_LONG vorgabe;
  T_LONG rueckgabe;
  T_INT breite;
 }ZAHL_REQUEST_VARIABLEN;

/* Modul globale Funktionen */
T_INT zahl_request_area_funktion(PARAMETER *parameter);
T_INT request_zahl_destructor(PARAMETER *parameter);

/***************************************************************/

T_LONG request_zahl(T_LONG min,T_LONG max,T_LONG vorgabe,T_PCHAR string,...)
{
 OPEN_WIN w;
 WINDOW_LISTEN_ELEMENT *text_window=NULL;
 ZAHL_REQUEST_VARIABLEN *v;
 VARIABLEN variablen;
 T_INT old_print_modus=vesa_print_modus;
 T_INT old_text=vesa_text;
 T_INT old_back_color=vesa_back_color;
 T_INT old_text_color=vesa_text_color;
 T_INT breite,hoehe;
 T_INT x,y;
 T_INT id=WIN_OPEN_CHOOSES_ID;
 T_INT count_newline=1;
 T_INT max_breite=0;
 T_INT akt_breite=0;
 va_list parameter;                              /* Parameter-Liste fr VA_... Macros */
 T_PCHAR text;                                     /* Puffer fr formatierten String */
 T_PCHAR ausgabe;
 T_DEBUG_ENTRY("request_zahl",70)
 variablen.ebene=dispatcher_ebene+1;
 variablen.pointer=NULL;
 variablen.variablen=NULL;
 text=(T_PCHAR )malloc(sizeof(T_CHAR)*(strlen(string)+1000));
 if (text==NULL)
 {
  show_message("Kein Speicherplatz fuer Zahlen Requester");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 ausgabe=text;
 va_start( parameter, string );                  /* Parameter umwandeln */
 vsprintf( text, string, parameter );            /* formatieren */
 x=0;
 while (text[x])
 {
  if (text[x]=='\n')
  {
   if (akt_breite>max_breite)
    max_breite=akt_breite;
   akt_breite=0;
   count_newline++;
   text[x]=0;
  }
  akt_breite+=font_now->zeichen[text[x]].breite;;
  x++;
 }
 if (akt_breite>max_breite)
  max_breite=akt_breite;
 breite=REC_BREITE+max_breite+2*REC_TEXT_OFFSET;
 hoehe=100+count_newline*20;
 x=vesa_x/2-(breite/2);
 y=vesa_y/2-(hoehe/2);
 if (breite>vesa_x)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_TEXT_TO_LONG)
  T_DEBUG_LEAVE
  return GENERIC_TEXT_TO_LONG;
 }
 v=(ZAHL_REQUEST_VARIABLEN *)malloc(sizeof(ZAHL_REQUEST_VARIABLEN));
 if (v==NULL)
 {
  show_message("Kein Speicherplatz fuer Zahlen Requester");
  T_DEBUG_FUNCTION_POSITION(4)
  return 0;
 }
 v->min=min;
 v->max=max;
 v->vorgabe=vorgabe;
 v->rueckgabe=vorgabe;
 v->breite=breite;
 variablen.variablen=v;
 w.x_pos=x;
 w.y_pos=y;
 w.border=0;
 w.breite=breite;
 w.hoehe=hoehe;
 w.bcolor=dhell_grau;
 w.color=ddark_grau;
 w.art=RAW_WINDOW | RETURNING;
 w.id=id;
 w.variablen=&variablen;
 w.name=NULL;
 w.mem_bild=NULL;
 w.pcx_bild=NULL;
 w.destructor=request_zahl_destructor;
 w.area_funktion=execute_win_move;
 w.tasten_funktion=NULL;
 text_window=open_window(&w);
 if (text_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(5)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(WINDOW_OPEN_ERROR)
  T_DEBUG_LEAVE
  return WINDOW_OPEN_ERROR;
 }
 print_srect(text_window,PRINT_WIN_RAW,0,0,text_window->b,text_window->h,ddark_grau,weiss,1);
// wprint_srect(text_window,0,0,breite,hoehe,ddark_grau,weiss,1);
 wprint_srect(text_window,REC_BREITE/2,20,breite-REC_BREITE,21*count_newline,weiss,ddark_grau,1);
 vesa_print_modus=PIC_FILLED;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=dhell_grau;
 vesa_text_color=ddark_grau;
 for (y=0;y<count_newline;y++)
 {
  T_INT len_x,len_y;
  vesa_get_text_len(ausgabe,&len_x,&len_y);
  wprint(text_window,REC_BREITE/2+REC_TEXT_OFFSET+((breite-2*REC_TEXT_OFFSET-REC_BREITE-len_x)/2),y*20+2+20,ausgabe);
  ausgabe=ausgabe+strlen(ausgabe)+1;
 }
 vesa_print_modus=old_print_modus;
 vesa_text=old_text;
 vesa_back_color=old_back_color;
 vesa_text_color=old_text_color;
 text_window->area_funktion=zahl_request_area_funktion;
 variablen.pointer=&vorgabe;
 WAIT_FOR_REPLY
 T_DEBUG_LEAVE
 return (T_LONG) *((T_PLONG )variablen.pointer);
}

/***************************************************************/

T_INT request_zahl_destructor(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 ZAHL_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("request_zahl_destructor",70)
 if (parameter==NULL)
 {
  show_message("Ungueltiger Parameter in DESTRUCTOR()");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return -1;
 }
 parameter->executed=PARAMETER_EXECUTED;
 if (window==NULL)
 {
  show_message("Ich kann mich nicht finden!!! (Window nicht geschlossen)");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 variablen=window->variablen;
 v=variablen->variablen;
 if (variablen->ebene!=dispatcher_ebene)
 {
  dispatcher_missmatch();
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  DIRTY_RETURN
 }
 if (v!=NULL)
 {
  *((T_PLONG )variablen->pointer)=v->vorgabe;
  free(v);
  variablen->variablen=NULL;
 }
 window->destructor=NULL;
 close_window(window,CLOSE_DEFAULT);
 parameter->executed=PARAMETER_RETURNING;
 T_DEBUG_LEAVE
 CLEAN_RETURN
}

/***************************************************************/
T_INT zahl_request_area_funktion(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 ZAHL_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("zahl_request_area_funktion",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if (parameter->window_element==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 ENTRY_PROC
 v->rueckgabe=TEXT_INIT;
 parameter->executed=PARAMETER_EXECUTED;
 if (parameter->maus_button==1)
 {
  v->rueckgabe=zahl_eingabe(v->min,v->max,v->breite/2-16,75,ddark_grau,dhell_grau,&(v->vorgabe),window);
  request_zahl_destructor(parameter);
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 if (parameter->maus_button==2)
 {
  move_window(window);
 }
 EXIT_PROC
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

/* //////////////////////////////////////////////////////////////////////////////////////// */
/* /////////////////////// ZAHL REQUESTER ENDE //////////////////////////////////////////// */
/* //////////////////////////////////////////////////////////////////////////////////////// */


/* //////////////////////////////////////////////////////////////////////////////////////// */
/* ////////////////////// JA/NEIN REQUESTER START ///////////////////////////////////////// */
/* //////////////////////////////////////////////////////////////////////////////////////// */

 typedef struct
 {
  T_INT antwort;
 }JA_NEIN_REQUEST_VARIABLEN;
/* Modul globale Funktionen */
T_INT execute_request_ja_button(PARAMETER *parameter);
T_INT execute_request_nein_button(PARAMETER *parameter);
T_INT request_ja_nein_destructor(PARAMETER *parameter);

/***************************************************************/
/* zwei button JA NEIN */
T_INT request_ja_nein(T_PCHAR string, ...)
{
 OPEN_WIN w;
 JA_NEIN_REQUEST_VARIABLEN *v;
 VARIABLEN variablen;
 WINDOW_LISTEN_ELEMENT *text_window=NULL;
 BUTTON *ja_button=NULL;
 BUTTON *nein_button=NULL;
 T_INT antwort;
 T_INT old_print_modus=vesa_print_modus;
 T_INT old_text=vesa_text;
 T_INT old_back_color=vesa_back_color;
 T_INT old_text_color=vesa_text_color;
 T_INT breite,hoehe;
 T_INT x,y;
 T_INT id=WIN_OPEN_CHOOSES_ID;
 T_INT count_newline=1;
 T_INT max_breite=0;
 T_INT akt_breite=0;
 va_list parameter;                              /* Parameter-Liste fr VA_... Macros */
 T_PCHAR text;                                     /* Puffer fr formatierten String */
 T_PCHAR ausgabe;
 T_DEBUG_ENTRY("request_ja_nein",70)
 variablen.ebene=dispatcher_ebene+1;
 variablen.pointer=NULL;
 variablen.variablen=NULL;
 text=(T_PCHAR )malloc(sizeof(T_CHAR)*(strlen(string)+1000));
 if (text==NULL)
 {
  show_message("Kein Speicherplatz fuer JA NEIN Requester");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 ausgabe=text;
 va_start( parameter, string );                  /* Parameter umwandeln */
 vsprintf( text, string, parameter );            /* formatieren */
 x=0;
 while (text[x])
 {
  if (text[x]=='\n')
  {
   if (akt_breite>max_breite)
    max_breite=akt_breite;
   akt_breite=0;
   count_newline++;
   text[x]=0;
  }
  akt_breite+=font_now->zeichen[text[x]].breite;;
  x++;
 }
 if (akt_breite>max_breite)
  max_breite=akt_breite;
 breite=REC_BREITE+max_breite+2*REC_TEXT_OFFSET;
 hoehe=100+count_newline*20;
 x=vesa_x/2-(breite/2);
 y=vesa_y/2-(hoehe/2);
 if (breite>vesa_x)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_TEXT_TO_LONG)
  T_DEBUG_LEAVE
  return GENERIC_TEXT_TO_LONG;
 }
 v=(JA_NEIN_REQUEST_VARIABLEN *)malloc(sizeof(JA_NEIN_REQUEST_VARIABLEN));
 if (v==NULL)
 {
  show_message("Kein Speicherplatz fuer Ja Nein Requester");
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return 0;
 }
 w.x_pos=x;
 w.y_pos=y;
 w.breite=breite;
 w.border=0;
 w.hoehe=hoehe;
 w.bcolor=dhell_grau;
 w.color=ddark_grau;
 w.art=RAW_WINDOW | RETURNING;
 w.id=id;
 w.variablen=&variablen;
 w.name=NULL;
 w.mem_bild=NULL;
 w.pcx_bild=NULL;
 w.destructor=request_ja_nein_destructor;
 w.area_funktion=execute_win_move;
 w.tasten_funktion=NULL;
 text_window=open_window(&w);
 if (text_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(5)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(WINDOW_OPEN_ERROR)
  T_DEBUG_LEAVE
  return WINDOW_OPEN_ERROR;
 }
 v->antwort=T_NEIN;
 variablen.variablen=v;
// wprint_srect(text_window,0,0,breite,hoehe,ddark_grau,weiss,1);
 print_srect(text_window,PRINT_WIN_RAW,0,0,text_window->b,text_window->h,ddark_grau,weiss,1);
 wprint_srect(text_window,REC_BREITE/2,20,breite-REC_BREITE,21*count_newline,weiss,ddark_grau,1);
 vesa_print_modus=PIC_FILLED;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=dhell_grau;
 vesa_text_color=ddark_grau;
 for (y=0;y<count_newline;y++)
 {
  T_INT len_x,len_y;
  vesa_get_text_len(ausgabe,&len_x,&len_y);
  wprint(text_window,REC_BREITE/2+REC_TEXT_OFFSET+((breite-2*REC_TEXT_OFFSET-REC_BREITE-len_x)/2),y*20+2+20,ausgabe);
  ausgabe=ausgabe+strlen(ausgabe)+1;
 }
 vesa_print_modus=old_print_modus;
 vesa_text=old_text;
 vesa_back_color=old_back_color;
 vesa_text_color=old_text_color;
 ja_button = make_text_button("Yes",hhell_grau,hdark_grau,ddark_grau,mdark_grau,dhell_grau,
                              mhell_grau,2,KEY_Y,SWITCH_ON_RELEASED);
 if (ja_button==NULL)
 {
  close_window(text_window,CLOSE_DEFAULT);
  T_DEBUG_FUNCTION_POSITION(6)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return GENERIC_MEMORY_NOT_AVAILABLE;
 }
 add_wbutton(text_window,ja_button,10,0+40+20*count_newline,JA_BUTTON);
 ja_button->button_funktion=execute_request_ja_button;
 nein_button = make_text_button("No",hhell_grau,hdark_grau,ddark_grau,mdark_grau,
                                dhell_grau,mhell_grau,2,KEY_N,SWITCH_ON_RELEASED);
 if (nein_button==NULL)
 {
  close_window(text_window,CLOSE_DEFAULT);
  T_DEBUG_FUNCTION_POSITION(7)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return GENERIC_MEMORY_NOT_AVAILABLE;
 }
 add_wbutton(text_window,nein_button,breite-10-nein_button->breite,0+40+20*count_newline,NEIN_BUTTON);
 nein_button->button_funktion=execute_request_nein_button;
 variablen.pointer=&antwort;
 WAIT_FOR_REPLY
 T_DEBUG_LEAVE
 return (T_INT) *((T_PINT )variablen.pointer);
}

/***************************************************************/

T_INT request_ja_nein_destructor(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 JA_NEIN_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("request_ja_nein_destructor",70)
 if (parameter==NULL)
 {
  show_message("Ungueltiger Parameter in DESTRUCTOR()");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return -1;
 }
 parameter->executed=PARAMETER_EXECUTED;
 if (window==NULL)
 {
  show_message("Ich kann mich nicht finden!!! (Window nicht geschlossen)");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 variablen=window->variablen;
 v=variablen->variablen;
 if (variablen->ebene!=dispatcher_ebene)
 {
  dispatcher_missmatch();
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  DIRTY_RETURN
 }
 if (v!=NULL)
 {
  *((T_PINT )variablen->pointer)=v->antwort;
  free(v);
  variablen->variablen=NULL;
 }
 window->destructor=NULL;
 close_window(window,CLOSE_DEFAULT);
 parameter->executed=PARAMETER_RETURNING;
 T_DEBUG_LEAVE
 CLEAN_RETURN
}

/***************************************************************/

T_INT execute_request_ja_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 JA_NEIN_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("execute_request_ja_button",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if (parameter->window_element==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 ENTRY_PROC
 v->antwort=T_JA;
 request_ja_nein_destructor(parameter);
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_request_nein_button(PARAMETER *parameter)
{
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 VARIABLEN *variablen;
 JA_NEIN_REQUEST_VARIABLEN *v;
 T_DEBUG_ENTRY("execute_request_nein_button",70)
 variablen=window->variablen;
 v=variablen->variablen;
 if (parameter->window_element==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 ENTRY_PROC
 v->antwort=T_NEIN;
 request_ja_nein_destructor(parameter);
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/


/* //////////////////////////////////////////////////////////////////////////////////////// */
/* ////////////////////// JA/NEIN REQUESTER ENDE ////////////////////////////////////////// */
/* //////////////////////////////////////////////////////////////////////////////////////// */



