//# define NO_HIDDEN_INFOS

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>  /* fuer coreleft() */
#include <ctype.h>   /* fuer toupper() */

#include "standard.h"
#include "win_raw.h"
#include "button.h"
#include "error.h"
#include "vesa.h"
#include "file.h"
#include "bild.h"
#include "pcx.h"
#include "tprint.h"
#include "tdispatc.h"
#include "keyboard.h"
#include "l_level.h"
#include "request.h"
#include "help.h"
#include "edit.h"
#include "parser.h"

#include "updatef.h"
#include "tool.h"

/* Modul Defines */
#define MAX_HIDDEN_SHOWN  5
#define HIDDEN_WIN_WIDTH  150

/* Modul globale Variablen */
//unsigned long timer_counter=0;

/* Initialisieren globaler Variablen */
MEM_BILD *ja=NULL;
MEM_BILD *nein=NULL;
MEM_BILD *hoch=NULL;
MEM_BILD *runter=NULL;
MEM_BILD *left=NULL;
MEM_BILD *right=NULL;
MEM_BILD *dhoch=NULL;
MEM_BILD *drunter=NULL;
MEM_BILD *close_pic=NULL;
MEM_BILD *hide_pic=NULL;
MEM_BILD *move_pic=NULL;
MEM_BILD *exit_pic=NULL;
MEM_BILD *game_pic=NULL;
MEM_BILD *help_pic=NULL;
MEM_BILD *config_pic=NULL;
MEM_BILD *read_pic=NULL;
MEM_BILD *write_pic=NULL;
MEM_BILD *screen_pic=NULL;
MEM_BILD *reboot_pic=NULL;
T_BYTE weiss;
T_BYTE schwarz;
T_BYTE hhell_grau;
T_BYTE mhell_grau;
T_BYTE dhell_grau;
T_BYTE hdark_grau;
T_BYTE mdark_grau;
T_BYTE ddark_grau;
T_BYTE f_red;
T_BYTE f_green;
T_BYTE f_blue;
T_BYTE f_yellow;
T_BYTE f_pink;
T_PCHAR t_hilfe_pfad=NULL;
T_PCHAR swap_path=NULL;
T_PCHAR tool_pfad=NULL;
T_INT (*default_tasten_funktion)(PARAMETER *parameter)=NULL;
T_INT (*default_area_funktion)(PARAMETER *parameter)=NULL;
T_LISTE *update_funktion_first=NULL;
T_LISTE *update_funktion_last=NULL;
/* Modul globale Funktionen */
# ifndef NO_HIDDEN_INFOS
 T_INT show_parameter_info(PARAMETER *parameter);
 T_INT show_win_info(PARAMETER *parameter);
 T_INT show_button_iinfo(BUTTON_LISTEN_ELEMENT *button);
 T_INT show_button_info(PARAMETER *parameter);
 T_INT show_back_info(PARAMETER *parameter);
 T_INT show_sys_info_window(T_VOID);
# endif

T_INT line_scroll_width=2;
T_INT default_back_pixel=255;
T_INT default_button_size=13;
T_INT default_dispatcher_type=ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
T_INT default_win_bewegungsart=GANZ;
T_INT default_fast_scroll=T_FALSE;
T_INT default_delete_temp=T_TRUE;
T_INT default_edit_mode=EDIT_MODE_INSERT;
T_INT default_keymap=GERMAN_KEYMAP;
T_INT default_verbosity=E_VERBOSE_HIGH;
T_PCHAR game_pic_name=NULL;
T_PCHAR help_pic_name=NULL;
T_PCHAR close_pic_name=NULL;
T_PCHAR hide_pic_name=NULL;
T_PCHAR move_pic_name=NULL;
T_PCHAR ok_pic_name=NULL;
T_PCHAR not_ok_pic_name=NULL;
T_PCHAR left_pic_name=NULL;
T_PCHAR right_pic_name=NULL;
T_PCHAR up_pic_name=NULL;
T_PCHAR down_pic_name=NULL;
T_PCHAR exit_pic_name=NULL;
T_PCHAR page_up_pic_name=NULL;
T_PCHAR page_down_pic_name=NULL;
T_PCHAR config_pic_name=NULL;
T_PCHAR read_pic_name=NULL;
T_PCHAR write_pic_name=NULL;
T_PCHAR default_font_name=NULL;
T_PCHAR default_pic_name=NULL;
T_PCHAR tool_dat_dir=NULL;
T_PCHAR help_dat_dir=NULL;
T_PCHAR screen_pic_name=NULL;
T_PCHAR reboot_pic_name=NULL;

static PARSER_WORD parse_hilfe[]=
{
 {PARSER_TYPE_SINT,   "LINE_SCROLL_WIDTH",&line_scroll_width,0},
 {PARSER_TYPE_SINT,   "DEFAULT_BACK_PIXEL",&default_back_pixel,0},
 {PARSER_TYPE_SINT,   "DEFAULT_BUTTON_SIZE",&default_button_size,0},
 {PARSER_TYPE_SINT,   "DISPATCHER_TYPE",&default_dispatcher_type,0},
 {PARSER_TYPE_SINT,   "WINDOW_MOVEMENT",&default_win_bewegungsart,0},
 {PARSER_TYPE_SINT,   "FAST_SCROLL",&default_fast_scroll,0},
 {PARSER_TYPE_SINT,   "DELETE_TEMPORARY_FILES",&default_delete_temp,0},
 {PARSER_TYPE_SINT,   "EDIT_MODE",&default_edit_mode,0},
 {PARSER_TYPE_SINT,   "KEYMAP",&default_keymap,0},
 {PARSER_TYPE_SINT,   "VERBOSITY",&default_verbosity,0},
 {PARSER_TYPE_STRING, "SCREEN_PIC_NAME",&screen_pic_name,0},
 {PARSER_TYPE_STRING, "REBOOT_PIC_NAME",&reboot_pic_name,0},
 {PARSER_TYPE_STRING, "CLOSE_PIC_NAME",&close_pic_name,0},
 {PARSER_TYPE_STRING, "HIDE_PIC_NAME",&hide_pic_name,0},
 {PARSER_TYPE_STRING, "MOVE_PIC_NAME",&move_pic_name,0},
 {PARSER_TYPE_STRING, "OK_PIC_NAME",&ok_pic_name,0},
 {PARSER_TYPE_STRING, "NOT_OK_PIC_NAME",&not_ok_pic_name,0},
 {PARSER_TYPE_STRING, "UP_PIC_NAME",&up_pic_name,0},
 {PARSER_TYPE_STRING, "DOWN_PIC_NAME",&down_pic_name,0},
 {PARSER_TYPE_STRING, "LEFT_PIC_NAME",&left_pic_name,0},
 {PARSER_TYPE_STRING, "RIGHT_PIC_NAME",&right_pic_name,0},
 {PARSER_TYPE_STRING, "PAGE_UP_PIC_NAME",&page_up_pic_name,0},
 {PARSER_TYPE_STRING, "PAGE_DOWN_PIC_NAME",&page_down_pic_name,0},
 {PARSER_TYPE_STRING, "EXIT_PIC_NAME",&exit_pic_name,0},
 {PARSER_TYPE_STRING, "DEFAULT_PIC_NAME",&default_pic_name,0},
 {PARSER_TYPE_STRING, "HELP_PIC_NAME",&help_pic_name,0},
 {PARSER_TYPE_STRING, "GAME_PIC_NAME",&game_pic_name,0},
 {PARSER_TYPE_STRING, "CONFIG_PIC_NAME",&config_pic_name,0},
 {PARSER_TYPE_STRING, "READ_PIC_NAME",&read_pic_name,0},
 {PARSER_TYPE_STRING, "WRITE_PIC_NAME",&write_pic_name,0},
 {PARSER_TYPE_STRING, "DEFAULT_FONT_NAME",&default_font_name,0},
 {PARSER_TYPE_STRING, "TOOL_DAT_DIR",&tool_dat_dir,0},
 {PARSER_TYPE_STRING, "HELP_DAT_DIR",&help_dat_dir,0},
 {PARSER_TYPE_END,NULL,NULL}
};

/***************************************************************/

/* initialisierung einiger sachen */
T_VOID init_tools(T_VOID)
{
 T_INT pcx_set_file_color_flag_old=pcx_set_file_color_flag;
 pcx_set_file_color_flag=T_FALSE;
 T_DEBUG_ENTRY("init_tools",100)
// atexit(deinit_mouse_error);
// onexit(deinit_mouse_error);
/*
/////// TOOL START
 default_tasten_funktion=NULL;
 default_area_funktion=NULL;
 update_funktion_first=NULL;
 update_funktion_last=NULL;
 line_scroll_width=2;
 default_back_pixel=255;
 default_button_size=13;
 default_dispatcher_type=ACTIVE_WINDOW | HIDE_LOWER_WINDOWS;
 default_win_bewegungsart=GANZ;
 default_fast_scroll=T_FALSE;
 default_delete_temp=T_TRUE;
 default_edit_mode=EDIT_MODE_INSERT;
 default_keymap=GERMAN_KEYMAP;
 default_verbosity=E_VERBOSE_HIGH;
/////// TOOL END

/////// VESA START
 use_vectrex_mouse=T_FALSE;
 clip_memory=NULL;
 use_clip=T_FALSE;
 vesa_bytes_per_scanline=0;
 vesa_mouse_verstecke=0;
 vesa_mouse_zeiger=&vesa_mouse_zeiger_default;
 vesa_mouse_initialisiert=T_FALSE;
 vesa_mouse_interrupt=0;
 vesa_mouse_x=0;
 vesa_mouse_y=0;
 vesa_mouse_button=0;
 vesa_modus_active=0;
/////// VESA END

/////// WINRAW START
 win_raw_error=T_OK;
 window_first=NULL;
 window_last=NULL;
 back_pic=NULL;
 windows_open=0;
 windows_shown=0;
 win_bewegungsart=GANZ;
 button_raw=T_FALSE;
/////// WINRAW END

/////// UPDATEF START
mouse_window=NULL;
mw_id=-1;
window_window=NULL;
ww_id=-1;
/////// UPDATEF END

/////// DISPATCHER START
 dispatcher_status=DISPATCHER_STARTING;
 dispatcher_ebene=0;
 dispatcher_type= ACTIVE_WINDOW | HIDE_LOWER_WINDOWS; //ACTIVE_WINDOW //FOCUS_WINDOW ACTIVE_ON_FOCUS
/////// DISPATCHER END
*/
 text_ausgabe=(T_PCHAR )malloc(sizeof(T_CHAR)*MAX_TEXT_AUSGABE_LAENGE);
 if (text_ausgabe==NULL)
 {
  t_printf(E_VERBOSE_NONE,"Speicherprobleme... Bye!");
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
 }
 mem_bild_buffer=(T_PCHAR )malloc(sizeof(T_CHAR)*MAX_LOW_MEMBILD_BUFFER);
 if (mem_bild_buffer==NULL)
 {
  t_printf(E_VERBOSE_NONE,"Speicherprobleme... Bye!");
  free(text_ausgabe);
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
 }
 swap_path=get_current_path();
 if (swap_path==NULL)
 {
  free(text_ausgabe);
  free(mem_bild_buffer);
  t_printf(E_VERBOSE_NONE,"Unknown (SPWAP_PATH) ERROR!");
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
 }
 p_alloc_pointer=T_TRUE;
 p_parse_init();
 if (p_parse("tool.ini",parse_hilfe )!=T_OK)
 {
  t_printf(E_VERBOSE_NONE,"%i\n",parse_error);
  t_printf(E_VERBOSE_NONE,"Something wrong in TOOL.INI -> Using internal defaults now!\n");
 }
 p_verbosity = e_verbose = default_verbosity;
 dispatcher_type=default_dispatcher_type;
 win_bewegungsart=default_win_bewegungsart;
 fast_scroll=default_fast_scroll;
 p_delete_temp=default_delete_temp;
 edit_mode=default_edit_mode;
 keymap=default_keymap;
 if (keymap==GERMAN_KEYMAP)
 {
  T_INT c;
  for (c=0;c<(4*NO_OF_SCANMAPS)+1;c++)
  {
   asScanToKeyConvert[c].iExtended=german_asScanToKeyConvert[c].iExtended;
   asScanToKeyConvert[c].iKeyCode=german_asScanToKeyConvert[c].iKeyCode;
  }
 }
 if (keymap==USA_KEYMAP)
 {
  T_INT c;
  for (c=0;c<(4*NO_OF_SCANMAPS)+1;c++)
  {
   asScanToKeyConvert[c].iExtended=usa_asScanToKeyConvert[c].iExtended;
   asScanToKeyConvert[c].iKeyCode=usa_asScanToKeyConvert[c].iKeyCode;
  }
 }
 if (screen_pic_name==NULL)
  screen_pic_name=strdup("screen.pcx");
 if (reboot_pic_name==NULL)
  reboot_pic_name=strdup("reboot.pcx");
 if (config_pic_name==NULL)
  config_pic_name=strdup("config.pcx");
 if (read_pic_name==NULL)
  read_pic_name=strdup("read.pcx");
 if (write_pic_name==NULL)
  write_pic_name=strdup("write.pcx");
 if (exit_pic_name==NULL)
  exit_pic_name=strdup("exit.pcx");
 if (close_pic_name==NULL)
  close_pic_name=strdup("close.pcx");
 if (hide_pic_name==NULL)
  hide_pic_name=strdup("hide.pcx");
 if (move_pic_name==NULL)
  move_pic_name=strdup("move.pcx");
 if (ok_pic_name==NULL)
  ok_pic_name=strdup("ok.pcx");
 if (not_ok_pic_name==NULL)
  not_ok_pic_name=strdup("not_ok.pcx");
 if (up_pic_name==NULL)
  up_pic_name=strdup("up.pcx");
 if (down_pic_name==NULL)
  down_pic_name=strdup("down.pcx");
 if (left_pic_name==NULL)
  left_pic_name=strdup("left.pcx");
 if (right_pic_name==NULL)
  right_pic_name=strdup("right.pcx");
 if (page_up_pic_name==NULL)
  page_up_pic_name=strdup("dup.pcx");
 if (page_down_pic_name==NULL)
  page_down_pic_name=strdup("ddown.pcx");
 if (default_pic_name==NULL)
  default_pic_name=strdup("default.pcx");
 if (game_pic_name==NULL)
  game_pic_name=strdup("game.pcx");
 if (help_pic_name==NULL)
  help_pic_name=strdup("help.pcx");
 if (default_font_name==NULL)
  default_font_name=strdup("default.fnt");
 if (tool_dat_dir==NULL)
  tool_dat_dir=strdup("tool.dat");
 if (help_dat_dir==NULL)
  help_dat_dir=strdup("help.dat");
 if (t_hilfe_pfad==NULL)
 {
  change_directory(help_dat_dir);
  t_hilfe_pfad=get_current_path();
  change_directory(swap_path);
 }
 if (tool_pfad==NULL)
 {
  change_directory(tool_dat_dir);
  tool_pfad=get_current_path();
  change_directory(swap_path);
 }
 if (tool_pfad!=NULL)
 {
  change_directory(tool_pfad);
 }
 screen_pic=lade_pcx_nach_mem(screen_pic_name,ALL_MEM_OK);
 reboot_pic=lade_pcx_nach_mem(reboot_pic_name,ALL_MEM_OK);
 config_pic=lade_pcx_nach_mem(config_pic_name,ALL_MEM_OK);
 read_pic=lade_pcx_nach_mem(read_pic_name,ALL_MEM_OK);
 write_pic=lade_pcx_nach_mem(write_pic_name,ALL_MEM_OK);
 ja=lade_pcx_nach_mem(ok_pic_name,ALL_MEM_OK);
 nein=lade_pcx_nach_mem(not_ok_pic_name,ALL_MEM_OK);
 hoch=lade_pcx_nach_mem(up_pic_name,ALL_MEM_OK);
 runter=lade_pcx_nach_mem(down_pic_name,ALL_MEM_OK);
 left=lade_pcx_nach_mem(left_pic_name,ALL_MEM_OK);
 right=lade_pcx_nach_mem(right_pic_name,ALL_MEM_OK);
 dhoch=lade_pcx_nach_mem(page_up_pic_name,ALL_MEM_OK);
 drunter=lade_pcx_nach_mem(page_down_pic_name,ALL_MEM_OK);
 close_pic=lade_pcx_nach_mem(close_pic_name,ALL_MEM_OK);
 hide_pic=lade_pcx_nach_mem(hide_pic_name,ALL_MEM_OK);
 move_pic=lade_pcx_nach_mem(move_pic_name,ALL_MEM_OK);
 exit_pic=lade_pcx_nach_mem(exit_pic_name,ALL_MEM_OK);
 help_pic=lade_pcx_nach_mem(help_pic_name,ALL_MEM_OK);
 game_pic=lade_pcx_nach_mem(game_pic_name,ALL_MEM_OK);
 if (vesa_load_font(default_font_name,&default_font)!=T_OK)
 {
  pcx_set_file_color_flag=pcx_set_file_color_flag_old;
  t_printf(E_VERBOSE_NONE,"\nError loading default font!");
  tool_error=TOOL_INIT_ERROR;
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(TOOL_INIT_ERROR)
  T_DEBUG_LEAVE
  return;
 }
 if (tool_pfad!=NULL)
 {
  change_directory(swap_path);
 }
 insert_update_funktion( update_window_report,1 );
 insert_update_funktion( update_input_report,1 );
 default_area_funktion=default_area_funktion_tool;
 fKBDinit();
 pcx_set_file_color_flag=pcx_set_file_color_flag_old;
 tool_error=T_OK;
 T_DEBUG_LEAVE
}

/***************************************************************/

/* deinitialisierung */
T_VOID de_init_tools(T_VOID)
{
 T_DEBUG_ENTRY("de_init_tools",100)
 fKBDrestore();
 while (update_funktion_first!=NULL)
  d_entferne_aus_liste(update_funktion_first->objekt,&update_funktion_first,&update_funktion_last,DL_CLEAN_UP);
 close_all_windows();
 vesa_free_font(&default_font);
 if (ja!=NULL)
  free_mem_bild(ja);
 ja=NULL;
 if (nein!=NULL)
  free_mem_bild(nein);
 nein=NULL;
 if (hoch!=NULL)
  free_mem_bild(hoch);
 hoch=NULL;
 if (runter!=NULL)
  free_mem_bild(runter);
 runter=NULL;
 if (left!=NULL)
  free_mem_bild(left);
 left=NULL;
 if (right!=NULL)
  free_mem_bild(right);
 right=NULL;
 if (dhoch!=NULL)
  free_mem_bild(dhoch);
 dhoch=NULL;
 if (drunter!=NULL)
  free_mem_bild(drunter);
 drunter=NULL;
 if (close_pic!=NULL)
  free_mem_bild(close_pic);
 close_pic=NULL;
 if (hide_pic!=NULL)
  free_mem_bild(hide_pic);
 hide_pic=NULL;
 if (help_pic!=NULL)
  free_mem_bild(help_pic);
 help_pic=NULL;
 if (game_pic!=NULL)
  free_mem_bild(game_pic);
 game_pic=NULL;
 if (move_pic!=NULL)
  free_mem_bild(move_pic);
 move_pic=NULL;
 if (exit_pic!=NULL)
  free_mem_bild(exit_pic);
 exit_pic=NULL;
 if (config_pic!=NULL)
  free_mem_bild(config_pic);
 config_pic=NULL;
 if (read_pic!=NULL)
  free_mem_bild(read_pic);
 read_pic=NULL;
 if (write_pic!=NULL)
  free_mem_bild(write_pic);
 write_pic=NULL;
 if (screen_pic!=NULL)
  free_mem_bild(screen_pic);
 screen_pic=NULL;
 if (reboot_pic!=NULL)
  free_mem_bild(reboot_pic);
 reboot_pic=NULL;
 delete_all_bbuttons();
 if (back_pic!=NULL)
  free_mem_bild(back_pic);
 back_pic=NULL;
 if (swap_path!=NULL)
  free(swap_path);
 swap_path=NULL;
 if (t_hilfe_pfad!=NULL)
  free(t_hilfe_pfad);
 t_hilfe_pfad=NULL;
 if (tool_pfad!=NULL)
  free(tool_pfad);
 tool_pfad=NULL;
 if (mem_bild_buffer!=NULL)
  free(mem_bild_buffer);
 mem_bild_buffer=NULL;
 if (text_ausgabe!=NULL)
  free(text_ausgabe);
 text_ausgabe=NULL;
 if (write_pic_name!=NULL)
  free(write_pic_name);
 write_pic_name=NULL;
 if (read_pic_name!=NULL)
  free(read_pic_name);
 read_pic_name=NULL;
 if (config_pic_name!=NULL)
  free(config_pic_name);
 config_pic_name=NULL;
 if (screen_pic_name!=NULL)
  free(screen_pic_name);
 screen_pic_name=NULL;
 if (reboot_pic_name!=NULL)
  free(reboot_pic_name);
 reboot_pic_name=NULL;
 if (game_pic_name!=NULL)
  free(game_pic_name);
 game_pic_name=NULL;
 if (close_pic_name!=NULL)
  free(close_pic_name);
 close_pic_name=NULL;
 if (hide_pic_name!=NULL)
  free(hide_pic_name);
 hide_pic_name=NULL;
 if (move_pic_name!=NULL)
  free(move_pic_name);
 move_pic_name=NULL;
 if (ok_pic_name!=NULL)
  free(ok_pic_name);
 ok_pic_name=NULL;
 if (not_ok_pic_name!=NULL)
  free(not_ok_pic_name);
 not_ok_pic_name=NULL;
 if (up_pic_name!=NULL)
  free(up_pic_name);
 up_pic_name=NULL;
 if (down_pic_name!=NULL)
  free(down_pic_name);
 down_pic_name=NULL;
 if (left_pic_name!=NULL)
  free(left_pic_name);
 left_pic_name=NULL;
 if (right_pic_name!=NULL)
  free(right_pic_name);
 right_pic_name=NULL;
 if (page_up_pic_name!=NULL)
  free(page_up_pic_name);
 page_up_pic_name=NULL;
 if (page_down_pic_name!=NULL)
  free(page_down_pic_name);
 page_down_pic_name=NULL;
 if (exit_pic_name!=NULL)
  free(exit_pic_name);
 exit_pic_name=NULL;
 if (default_font_name!=NULL)
  free(default_font_name);
 default_font_name=NULL;
 if (default_pic_name!=NULL)
  free(default_pic_name);
 default_pic_name=NULL;
 if (tool_dat_dir!=NULL)
  free(tool_dat_dir);
 tool_dat_dir=NULL;
 if (help_dat_dir!=NULL)
  free(help_dat_dir);
 help_dat_dir=NULL;
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID init_colors(T_VOID)
{
 T_DEBUG_ENTRY("init_colors",100)
 vesa_get_mehrere_dac(0,256, (T_BYTE *)(&pcx_256_farb_tabelle.rgb_farben[0].red));
 weiss  =get_nearest_color(63,63,63,pcx_256_farb_tabelle,0,255,2);
 schwarz=get_nearest_color(0,0,0,pcx_256_farb_tabelle,0,255,2);
 hhell_grau=get_nearest_color(50,50,50,pcx_256_farb_tabelle,0,255,2);
 mhell_grau=get_nearest_color(45,45,45,pcx_256_farb_tabelle,0,255,2);
 dhell_grau=get_nearest_color(40,40,40,pcx_256_farb_tabelle,0,255,2);
 hdark_grau=get_nearest_color(30,30,30,pcx_256_farb_tabelle,0,255,2);
 mdark_grau=get_nearest_color(25,25,25,pcx_256_farb_tabelle,0,255,2);
 ddark_grau=get_nearest_color(20,20,20,pcx_256_farb_tabelle,0,255,2);

 f_red   =get_nearest_color(63,0,0,pcx_256_farb_tabelle,0,255,2);
 f_green =get_nearest_color(0,63,0,pcx_256_farb_tabelle,0,255,2);
 f_blue  =get_nearest_color(0,0,63,pcx_256_farb_tabelle,0,255,2);
 f_yellow=get_nearest_color(63,63,0,pcx_256_farb_tabelle,0,255,2);
 f_pink  =get_nearest_color(63,0,63,pcx_256_farb_tabelle,0,255,2);

 button_color1=hhell_grau;
 button_color2=hdark_grau;
 button_color3=ddark_grau;
 button_color4=mdark_grau;
 button_color5=dhell_grau;
 button_color6=mhell_grau;

 vesa_set_default_mouse_color(schwarz,weiss);
 T_DEBUG_LEAVE
}

/***************************************************************/

/* einfach nur warten, auf taste (koennte auch als makro gemacht werden) */
T_VOID warte_auf_taste(T_VOID)
{
 T_DEBUG_ENTRY("warte_auf_taste",100)
 while (!fKBDishit());
 T_DEBUG_LEAVE
}

/***************************************************************/

/* zeigt ein pcx bild an den angegebenen koordinaten an */
T_INT zeige_pcx_bild(T_PCHAR dateiname,T_INT x, T_INT y)
{
 T_INT fehler,p;
 T_BYTE *zeilen_pointer;
 T_DEBUG_ENTRY("zeige_pcx_bild",100)
 if (vesa_modus_active!=(fehler=TOOL_NO_VESA_MODE_ACTIVE))
 {
  if ((fehler=pcx_open_file(dateiname))==T_OK)
  {
   if (pcx_bild_art==BILD_IST_256_FARBE_BILD)
   {
    for (p=0; p<(pcx_header.ymax+1-pcx_header.ymin); p++)
    {
     pcx_get_zeile256();
     zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
     vesa_print_zeile256(x,y+p,zeilen_pointer,pcx_zeile_eines_bildes256.zeilen_laenge);
    }
    pcx_close_file();
   }
   if (pcx_bild_art==BILD_IST_16_FARBE_BILD)
   {
    for (p=0; p<(pcx_header.ymax+1-pcx_header.ymin); p++)
    {
     pcx_get_zeile16(pcx_color16_default);
     zeilen_pointer=pcx_zeile_eines_bildes256.zeile;
     vesa_print_zeile256(x,p+y,zeilen_pointer,pcx_zeile_eines_bildes256.zeilen_laenge);
    }
    pcx_close_file();
   }
  }
 }
 T_DEBUG_LEAVE
 return fehler;
}

/***************************************************************/

/* test funktion, die den aktuellen status ausgibt */
T_VOID print_status_informationen(T_VOID)
{
 T_DEBUG_ENTRY("print_status_informationen",100)
 if (vesa_karte_da()==T_OK)
 {
  t_printf(E_VERBOSE_NONE,"\nVESA Treiber gefunden, Karte mit folgenden Daten:");
  vesa_anzeige_daten();
  if (vesa_modus_active!=TOOL_NO_VESA_MODE_ACTIVE)
   t_printf(E_VERBOSE_NONE,"\nFolgender Modus is aktiv: %i",vesa_modus_active);
  else
   t_printf(E_VERBOSE_NONE,"\nEs ist kein VESA Modus aktiv.");
  if (vesa_mouse_initialisiert==T_TRUE)
   t_printf(E_VERBOSE_NONE,"\nInterner Maustreiber ist aktiviert.");
  else
   t_printf(E_VERBOSE_NONE,"\nInterner Maustreiber ist nicht aktiviert.");
 }
 else
  t_printf(E_VERBOSE_NONE,"\nKeine VESA Karte gefunden.");
 t_printf(E_VERBOSE_NONE,"\nFreie Bytes im Hauptspeicher: %lu",(T_ULONG)_memavl());
 T_DEBUG_LEAVE
}

/***************************************************************/

# ifndef NO_HIDDEN_INFOS
T_INT show_button_iinfo(BUTTON_LISTEN_ELEMENT *button)
{
 T_PCHAR ausgabe;
 BUTTON *but=button->button;
 T_DEBUG_ENTRY("show_button_iinfo",100)
 if (button!=NULL)
 {
  ausgabe=(T_PCHAR )malloc(sizeof(T_CHAR)*2000);
  if (ausgabe==NULL)
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return T_NOT_OK;
  }
  strcpy(ausgabe,"BUTTON INFORMATIONEN\n\n");
  sprintf(ausgabe+strlen(ausgabe),"Button ID: %u\n",button->id);
  sprintf(ausgabe+strlen(ausgabe),"Button Art:");
  if (but->art==TEXT)
   sprintf(ausgabe+strlen(ausgabe)," TEXT");
//  if (but->art==STEXT)
//   sprintf(ausgabe+strlen(ausgabe)," STEXT");
  if (but->art==BIT_MAP)
   sprintf(ausgabe+strlen(ausgabe)," BIT_MAP");
  if (but->art==MEMBILD)
   sprintf(ausgabe+strlen(ausgabe)," MEMBILD");
  if (but->art==EDIT_TEXT)
   sprintf(ausgabe+strlen(ausgabe)," EDIT_TEXT");
  sprintf(ausgabe+strlen(ausgabe),"\nButton Status:");
  if (button->status==INITIALISING)
   sprintf(ausgabe+strlen(ausgabe)," INITIALISING");
  if (button->status==RELEASED)
   sprintf(ausgabe+strlen(ausgabe)," RELEASED");
  if (button->status==PRESSED)
   sprintf(ausgabe+strlen(ausgabe)," PRESSED");
  if (button->status==FORBIDDEN)
   sprintf(ausgabe+strlen(ausgabe)," FORBIDDEN");
  sprintf(ausgabe+strlen(ausgabe),"\nButton Schaltart:");
  if (but->schalt_art==SWITCH_ON_RELEASED)
   sprintf(ausgabe+strlen(ausgabe)," SWITCH_ON_RELEASED");
  if (but->schalt_art==SWITCH_ON_PRESSED)
   sprintf(ausgabe+strlen(ausgabe)," SWITCH_ON_PRESSED");
  sprintf(ausgabe+strlen(ausgabe),"\nPosition (x,y): (%i,%i)\n",button->x_offset,button->y_offset);
  sprintf(ausgabe+strlen(ausgabe),"Ausmasse (breite,hohe): (%i,%i)\n",but->breite,but->hoehe);
  sprintf(ausgabe+strlen(ausgabe),"Button Funktion:");
  if (but->button_funktion!=NULL)
   sprintf(ausgabe+strlen(ausgabe)," JA\n");
  else
   sprintf(ausgabe+strlen(ausgabe)," NEIN\n");
  if (but->taste==0)
   sprintf(ausgabe+strlen(ausgabe),"Taste: KEINE\n");
  else
   if ((T_UINT)but->taste<256)
    sprintf(ausgabe+strlen(ausgabe),"Taste: '%c'=%u\n",(T_CHAR)but->taste,but->taste);
   else
    sprintf(ausgabe+strlen(ausgabe),"Taste (SONDERTASTE): 256*%u+%u=%u\n",((T_UINT)but->taste)/256,
    ((T_UINT)but->taste)-256*(but->taste/256),(T_UINT)but->taste);
  sprintf(ausgabe+strlen(ausgabe),"Linendicke: %i\n",but->line_width);
  if (but->name!=NULL)
   sprintf(ausgabe+strlen(ausgabe),"Name: \"%s\"\n",but->name);
  show_message(ausgabe);
  free(ausgabe);
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT show_button_info(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("show_button_info",100)
 if (parameter->button_element!=NULL)
  show_button_iinfo(parameter->button_element);
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT show_win_info(PARAMETER *parameter)
{
 T_PCHAR ausgabe;
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)parameter->window_element;
 T_DEBUG_ENTRY("show_win_info",100)
 if (window!=NULL)
 {
  ausgabe=(T_PCHAR )malloc(sizeof(T_CHAR)*2000);
  if (ausgabe==NULL)
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  strcpy(ausgabe,"WINDOW INFORMATIONEN\n\n");

  sprintf(ausgabe+strlen(ausgabe),"Benutzter Swap-Speichertyp:");
  if (window->window_pic->speicher_art == SPEICHER)
   sprintf(ausgabe+strlen(ausgabe)," SPEICHER");
  if (window->window_pic->speicher_art == HD_SPEICHER)
   sprintf(ausgabe+strlen(ausgabe)," HD_SPEICHER");

#ifdef DISPATCHER
  sprintf(ausgabe+strlen(ausgabe),"\nDerzeitige Dispatcher Ebene: %i\n",dispatcher_ebene);
  sprintf(ausgabe+strlen(ausgabe),"Dispatcher Typ:");
  if (dispatcher_type&ACTIVATE_ON_FOCUS)
   sprintf(ausgabe+strlen(ausgabe)," ACTIVATE_ON_FOCUS");
  if (dispatcher_type&ACTIVE_ON_FOCUS)
   sprintf(ausgabe+strlen(ausgabe)," ACTIVE_ON_FOCUS");
  if (dispatcher_type&ACTIVE_WINDOW)
   sprintf(ausgabe+strlen(ausgabe)," ACTIVE_WINDOW");
  if (dispatcher_type&HIDE_LOWER_WINDOWS)
   sprintf(ausgabe+strlen(ausgabe)," HIDE_LOWER_WINDOWS");
  if (dispatcher_type&SHOW_LOWER_WINDOWS)
   sprintf(ausgabe+strlen(ausgabe)," SHOW_LOWER_WINDOWS");
#endif
  sprintf(ausgabe+strlen(ausgabe),"\nWindow Art:");
  if (window->art&RAW_WINDOW)
   sprintf(ausgabe+strlen(ausgabe)," RAW_WINDOW");
  if (window->art&MEM_PIC_WINDOW)
   sprintf(ausgabe+strlen(ausgabe)," MEM_PIC_WINDOW");
  if (window->art&PCX_WINDOW)
   sprintf(ausgabe+strlen(ausgabe)," PCX_WINDOW");
  if (window->art&AREA_WINDOW)
   sprintf(ausgabe+strlen(ausgabe)," AREA_WINDOW");
  if (window->art&UNBEWEGBAR)
   sprintf(ausgabe+strlen(ausgabe)," UNBEWEGBAR");
  if (window->art&WITH_HIDE_BUTTON)
   sprintf(ausgabe+strlen(ausgabe)," WITH_HIDE_BUTTON");
  if (window->art&WITH_CLOSE_BUTTON)
   sprintf(ausgabe+strlen(ausgabe)," WITH_CLOSE_BUTTON");
  if (window->art&WITH_DRAG_BUTTON)
   sprintf(ausgabe+strlen(ausgabe)," WITH_DRAG_BUTTON");
  if (window->art&WITH_RESIZE_BUTTON)
   sprintf(ausgabe+strlen(ausgabe)," WITH_RESIZE_BUTTON");
  if (window->art&FRONT_WINDOW)
   sprintf(ausgabe+strlen(ausgabe)," FRONT_WINDOW");
  if (window->art&BACK_WINDOW)
   sprintf(ausgabe+strlen(ausgabe)," BACK_WINDOW");

  if (window->art&RETURNING)
  {
   sprintf(ausgabe+strlen(ausgabe)," RETURNING");
#ifdef DISPATCHER
   sprintf(ausgabe+strlen(ausgabe)," (Created in Ebene %i)",window->variablen->ebene);
#endif
  }
  sprintf(ausgabe+strlen(ausgabe),"\nWindow ID: %u\n",window->id);
  sprintf(ausgabe+strlen(ausgabe),"Position (x,y): (%i,%i)\n",window->x,window->y);
  sprintf(ausgabe+strlen(ausgabe),"Ausmasse (breite,hohe): (%i,%i)\n",window->b,window->h);
  sprintf(ausgabe+strlen(ausgabe),"Anzahl der Buttons: %i\n",d_anzahl_liste(window->button_first));
  sprintf(ausgabe+strlen(ausgabe),"Destructor:");
  if (window->destructor!=NULL)
   sprintf(ausgabe+strlen(ausgabe)," JA\n");
  else
   sprintf(ausgabe+strlen(ausgabe)," NEIN\n");
  sprintf(ausgabe+strlen(ausgabe),"Areafunktion:");
  if (window->area_funktion!=NULL)
   sprintf(ausgabe+strlen(ausgabe)," JA\n");
  else
   sprintf(ausgabe+strlen(ausgabe)," NEIN\n");
  sprintf(ausgabe+strlen(ausgabe),"Tastenfunktion:");
  if (window->tasten_funktion!=NULL)
   sprintf(ausgabe+strlen(ausgabe)," JA\n");
  else
   sprintf(ausgabe+strlen(ausgabe)," NEIN\n");
  sprintf(ausgabe+strlen(ausgabe),"Parameter:");
  if (window->parameter!=NULL)
   sprintf(ausgabe+strlen(ausgabe)," JA\n");
  else
   sprintf(ausgabe+strlen(ausgabe)," NEIN\n");
  show_message(ausgabe);
  free(ausgabe);
 }
 else
  show_back_info(parameter);
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

#pragma argsused
T_INT show_parameter_info(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("show_parameter_info",100)
 show_message("Parameter Infos noch nicht verfuegbar!");
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

#pragma argsused
T_INT show_back_info(PARAMETER *parameter)
{
 T_PCHAR ausgabe;
 T_DEBUG_ENTRY("show_back_info",100)
 ausgabe=(T_PCHAR )malloc(sizeof(T_CHAR)*2000);
 if (ausgabe==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return parameter->ebene;
 }
 strcpy(ausgabe,"BACKGROUND INFORMATIONEN\n\n");
 sprintf(ausgabe+strlen(ausgabe),"Benutzter Swap-Speichertyp:");
 if (back_pic->speicher_art == SPEICHER)
  sprintf(ausgabe+strlen(ausgabe)," SPEICHER");
 if (back_pic->speicher_art == HD_SPEICHER)
  sprintf(ausgabe+strlen(ausgabe)," HD_SPEICHER");
#ifdef DISPATCHER
 sprintf(ausgabe+strlen(ausgabe),"\nDerzeitige Dispatcher Ebene: %i\n",dispatcher_ebene);
 sprintf(ausgabe+strlen(ausgabe),"Dispatcher Typ:");
 if (dispatcher_type&ACTIVATE_ON_FOCUS)
  sprintf(ausgabe+strlen(ausgabe)," ACTIVATE_ON_FOCUS");
 if (dispatcher_type&ACTIVE_ON_FOCUS)
  sprintf(ausgabe+strlen(ausgabe)," ACTIVE_ON_FOCUS");
 if (dispatcher_type&ACTIVE_WINDOW)
  sprintf(ausgabe+strlen(ausgabe)," ACTIVE_WINDOW");
 if (dispatcher_type&HIDE_LOWER_WINDOWS)
  sprintf(ausgabe+strlen(ausgabe)," HIDE_LOWER_WINDOWS");
 if (dispatcher_type&SHOW_LOWER_WINDOWS)
  sprintf(ausgabe+strlen(ausgabe)," SHOW_LOWER_WINDOWS");
#endif
 sprintf(ausgabe+strlen(ausgabe),"\nAnzahl der Buttons: %i\n",d_anzahl_liste(button_first));
 sprintf(ausgabe+strlen(ausgabe),"Areafunktion:");
 if (back_area_funktion!=NULL)
  sprintf(ausgabe+strlen(ausgabe)," JA\n");
 else
  sprintf(ausgabe+strlen(ausgabe)," NEIN\n");
 sprintf(ausgabe+strlen(ausgabe),"Tastenfunktion:");
 if (default_tasten_funktion!=NULL)
  sprintf(ausgabe+strlen(ausgabe)," JA\n");
 else
  sprintf(ausgabe+strlen(ausgabe)," NEIN\n");
 show_message(ausgabe);
 free(ausgabe);
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT show_sys_info_window(T_VOID)
{
 T_PCHAR ausgabe;
 T_DEBUG_ENTRY("show_sys_info_window",100)
 ausgabe=(T_PCHAR )malloc(sizeof(T_CHAR)*2000);
 if (ausgabe==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 strcpy(ausgabe,"SYSTEM INFORMATIONEN\n\n");
 sprintf(ausgabe+strlen(ausgabe),"VESA-MODUS: %Xh\n",vesa_modus_active);

 sprintf(ausgabe+strlen(ausgabe),"VESA-FENSTER[lese]: %Xh\n",vesa_read_seg);
 sprintf(ausgabe+strlen(ausgabe),"VESA-FENSTER[screibe]: %Xh\n",vesa_write_seg);
 if (vesa_mouse_initialisiert==T_TRUE)
  sprintf(ausgabe+strlen(ausgabe),"Maus: aktiv\n");
 else
  sprintf(ausgabe+strlen(ausgabe),"Maus: n/a\n");
 sprintf(ausgabe+strlen(ausgabe),"Hauptspeicher frei: %lu\n",((T_ULONG)_memavl()));
 sprintf(ausgabe+strlen(ausgabe),"Fenster offen: %i\n", windows_open);
 show_message(ausgabe);
 free(ausgabe);
 T_DEBUG_LEAVE
 return T_OK;
}
# endif

/***************************************************************/

WINDOW_LISTEN_ELEMENT *show_message(T_PCHAR string, ...)
{
 WINDOW_LISTEN_ELEMENT *text_window=NULL;
 BUTTON *aha_button=NULL;
 OPEN_WIN w;
 T_INT old_print_modus=vesa_print_modus;
 T_INT old_text=vesa_text;
 T_INT old_back_color=vesa_back_color;
 T_INT old_text_color=vesa_text_color;
 T_INT breite,hoehe;
 T_INT x,y;
 T_INT id=WIN_OPEN_CHOOSES_ID;
 T_INT count_newline=1;
 T_INT max_breite=0;
 T_INT akt_breite=0;
 va_list parameter;                              /* Parameter-Liste fr VA_... Macros */
 char text[1024];                                 /* Puffer fr formatierten String */
 T_PCHAR ausgabe=text;
 T_DEBUG_ENTRY("show_message",100)
 va_start( parameter, string );                  /* Parameter umwandeln */
 vsprintf( text, string, parameter );            /* formatieren */
 x=0;
 while (text[x])
 {
  if (text[x]=='\n')
  {
   if (akt_breite>max_breite)
    max_breite=akt_breite;
   akt_breite=0;
   count_newline++;
   text[x]=0;
  }
  akt_breite+=font_now->zeichen[(T_BYTE)text[x]].breite;;
  x++;
 }
 if (akt_breite>max_breite)
  max_breite=akt_breite;
 breite=REC_BREITE+max_breite+2*REC_TEXT_OFFSET;
 hoehe=100+count_newline*20;
 x=vesa_x/2-(breite/2);
 y=vesa_y/2-(hoehe/2);
 if (breite>vesa_x)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return NULL;
 }
 w.x_pos=x;
 w.y_pos=y;
 w.breite=breite;
 w.hoehe=hoehe;
 w.border=0;
 w.bcolor=dhell_grau;
 w.art=RAW_WINDOW/*|FRONT_WINDOW*/; // confronts with virtual
 w.id=id;
 w.name=NULL;
 w.variablen=NULL;
 w.mem_bild=NULL;
 w.pcx_bild=NULL;
 w.destructor=NULL;
 w.area_funktion=execute_win_move;
 w.tasten_funktion=NULL;
 MOUSE_VERSTECKE
 text_window=open_window(&w);
 if (text_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return NULL;
 }
 is_upper=T_TRUE;
 print_srect(text_window,PRINT_CLIPPED,0,0,breite,hoehe,ddark_grau,weiss,1);
 print_srect(text_window,PRINT_CLIPPED,REC_BREITE/2,20,breite-REC_BREITE,21*count_newline,weiss,ddark_grau,1);
 vesa_print_modus=PIC_FILLED;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=dhell_grau;
 vesa_text_color=ddark_grau;
 for (y=0;y<count_newline;y++)
 {
  T_INT len_x,len_y;
  vesa_get_text_len(ausgabe,&len_x,&len_y);
  wprint(text_window,REC_BREITE/2+REC_TEXT_OFFSET+((breite-2*REC_TEXT_OFFSET-REC_BREITE-len_x)/2),y*20+2+20,ausgabe);
  ausgabe=ausgabe+strlen(ausgabe)+1;
 }
 is_upper=T_FALSE;
 MOUSE_ZEIGE
 vesa_print_modus=old_print_modus;
 vesa_text=old_text;
 vesa_back_color=old_back_color;
 vesa_text_color=old_text_color;
 aha_button = make_text_button("Aha",hhell_grau,hdark_grau,ddark_grau,mdark_grau,dhell_grau,mhell_grau,2,KEY_ENTER,SWITCH_ON_RELEASED);
 if (aha_button==NULL)
 {
  close_window(text_window,CLOSE_DEFAULT);
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return NULL;
 }
 add_wbutton(text_window,aha_button,breite/2-aha_button->breite/2,0+40+20*count_newline,CLOSE_BUTTON);
 aha_button->button_funktion=execute_close_button;
 T_DEBUG_LEAVE
 return text_window;
}

/***************************************************************/

/* unter verwendung der default breite 8 pixel */
/* einfach zu erweitern auf andere fonts */
/* speicher fuer den text musss vorhanden sein */
/* maxchars die laenge der maximal auszugebenden Zeichen, der rest wird gescrolled */
T_INT text_eingabe(T_PCHAR org_text,T_PINT start_zeichen,T_INT x,T_INT y,T_INT max_chars, T_INT string_length,T_BYTE text_col,T_BYTE back_col,
WINDOW_LISTEN_ELEMENT *window)
{
 T_INT key=0;
 T_INT old_key=1;
 T_INT cursor_position;
 T_INT old_cursor_position;
 T_INT old_print_modus=vesa_print_modus;
 T_INT old_text=vesa_text;
 T_INT old_back_color=vesa_back_color;
 T_INT old_text_color=vesa_text_color;
 T_INT old_start_zeichen=*start_zeichen;
 T_INT jetzt_ausgeben;
 T_INT rueckgabe;
 T_PCHAR text=(T_PCHAR )malloc((string_length+1)*(sizeof(T_CHAR)));
 T_DEBUG_ENTRY("text_eingabe",100)
 if (text==NULL)
 {
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return GENERIC_MEMORY_NOT_AVAILABLE;
 }
 strcpy(text,org_text);
 if (strlen(text)<max_chars)
 {
  if (strlen(text)<string_length)
   cursor_position=strlen(text)+1;
  else
   cursor_position=strlen(text);
  if (cursor_position)
   cursor_position--;
  if (cursor_position==string_length)
   cursor_position--;
 }
 else
 {
  if (strlen(text)-*start_zeichen<max_chars)
   cursor_position=strlen(text);
  else
   cursor_position=*start_zeichen+max_chars-1;
 }
 vesa_print_modus=PIC_FILLED;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=back_col;
 vesa_text_color=text_col;
 old_cursor_position=cursor_position;
 #pragma warn -eff
 while (vesa_mouse_button)
  vesa_mouse_update();
 #pragma warn .eff
 while (1)
 {
  while (((key=fKBDishit())==old_key)&&(!vesa_mouse_button))
   vesa_mouse_update();
  if (vesa_mouse_button==2)
  {
   rueckgabe=TEXT_ESC;
   #pragma warn -eff
   while (vesa_mouse_button)
    vesa_mouse_update();
   #pragma warn .eff
   break;
  }
  if (vesa_mouse_button==1)
  {
   rueckgabe=TEXT_RETURN;
   #pragma warn -eff
   while (vesa_mouse_button)
    vesa_mouse_update();
   #pragma warn .eff
   break;
  }
  old_key=key;
/* CURSOR LEFT START */
  if (((key==KEY_LEFT)||(key==KEY_BSPACE))&&(cursor_position))
  {
   if (cursor_position==*start_zeichen)
    (*start_zeichen)--;
   cursor_position--;
  }
/* CURSOR RIGHT START */
  if ((key==KEY_RIGHT)&&(text[cursor_position]!=0)&&(cursor_position+1!=string_length))
  {
   if (cursor_position==(*start_zeichen+max_chars-1))
    (*start_zeichen)++;
   cursor_position++;
  }
/* DELETE START */
  if (((key==KEY_DEL)&&(text[cursor_position]!=0))||((key==KEY_BSPACE)&&(cursor_position+1)))
  {
   if (!((key==KEY_BSPACE)&&(cursor_position==old_cursor_position)))
   {
    T_INT zaehler=cursor_position;
    do
    {
     text[zaehler]=text[zaehler+1];
     if (zaehler<*start_zeichen+max_chars)
     {
      if (text[zaehler])
       wprint_char(window,x+(zaehler - *start_zeichen)*8, y, text[zaehler]);
     }
     zaehler++;
    }
    while (text[zaehler]!=0);
    if (zaehler-1<*start_zeichen+max_chars)
     wprint_char(window,x+(zaehler -1- *start_zeichen)*8, y, ' ');
   }
  }
/* HOME START */
  if (key==KEY_HOME)
  {
    (*start_zeichen)=0;
   cursor_position=0;
  }
/* END START */
  if (key==KEY_END)
  {
   T_INT zaehler=0;
   cursor_position=strlen(text);
   if (cursor_position < max_chars)
    (*start_zeichen)=0;
   else
   {
    if (cursor_position>=string_length)
     cursor_position--;
    *start_zeichen=cursor_position-max_chars+1;
   }
   while (text[zaehler + (*start_zeichen)]!=0)
   {
    wprint_char(window,x+zaehler*8, y, text[zaehler+(*start_zeichen)]);
    zaehler++;
   }
  }
/* NORMALES ZEICHEN START */
  if ((key>=KEY_SPACE)&&(key<=KEY_z))
  {
   T_INT zaehler=strlen(text);
   if (zaehler++<string_length)
   {
    do
    {
     zaehler--;
     text[zaehler+1]=text[zaehler];
     if (zaehler+1<*start_zeichen+max_chars)
     {
      if (text[zaehler+1])
       wprint_char(window,x+(zaehler-*start_zeichen+1)*8, y,text[zaehler+1]);
     }
    }
    while (zaehler!=cursor_position);
    text[cursor_position]=(T_CHAR)key;
    if (cursor_position+1!=string_length)
    {
     cursor_position++;
     if (cursor_position>*start_zeichen+max_chars-1)
      (*start_zeichen)++;
    }
   }
  }
/* AUSGABE START */
  jetzt_ausgeben=(key!=KEY_ENTER);
  if ((*start_zeichen==0)&&(*start_zeichen==old_start_zeichen))
  {
   if (text[old_cursor_position]==0)
   {
    wprint_char(window,x+old_cursor_position*8, y,' ');
   }
   else
   {
    wprint_char(window,x+old_cursor_position*8, y,text[old_cursor_position]);
   }
   if (jetzt_ausgeben)
   {
    if (text[cursor_position]==0)
    {
     wprint_char(window,x+cursor_position*8, y,'_');
    }
    else
    {
     vesa_back_color=text_col;
     vesa_text_color=back_col;
     wprint_char(window,x+cursor_position*8,y,text[cursor_position]);
     vesa_back_color=back_col;
     vesa_text_color=text_col;
    }
   }
  }
  else
  {
   if (text[old_cursor_position]==0)
   {
    wprint_char(window,x+(old_cursor_position-old_start_zeichen)*8,y,' ');
   }
   else
   {
    wprint_char(window,x+(old_cursor_position-old_start_zeichen)*8,y,text[old_cursor_position]);
   }
   if (jetzt_ausgeben)
   {
    T_INT zaehler;
    for (zaehler=*start_zeichen;((zaehler<*start_zeichen+max_chars)&&(zaehler<*start_zeichen<strlen(text)));zaehler++)
    {
     if (zaehler==cursor_position)
     {
      if (text[cursor_position]==0)
      {
       wprint_char(window,x+(zaehler-*start_zeichen)*8,y,'_');
      }
      else
      {
       vesa_back_color=text_col;
       vesa_text_color=back_col;
       wprint_char(window,x+(zaehler-*start_zeichen)*8,y,text[zaehler]);
       vesa_back_color=back_col;
       vesa_text_color=text_col;
      }
     }
     else
     {
      wprint_char(window,x+(zaehler-*start_zeichen)*8,y,text[zaehler]);
     }
    }
   }
  }
/* checken ob aus der schleife raus */
/*
TEXT_RETURN
TEXT_ESC
TEXT_TAB
TEXT_SHIFT_TAB
*/
  if (key==KEY_ENTER)
  {
   rueckgabe=TEXT_RETURN;
   break;
  }
  if (key==KEY_TAB)
  {
   rueckgabe=TEXT_TAB;
   break;
  }
  if (key==KEY_SHIFT_TAB)
  {
   rueckgabe=TEXT_SHIFT_TAB;
   break;
  }
  if (key==KEY_ESCAPE)
  {
   rueckgabe=TEXT_ESC;
   break;
  }
  if (key==KEY_PGUP)
  {
   rueckgabe=TEXT_PAGE_UP;
   break;
  }
  if (key==KEY_PGDN)
  {
   rueckgabe=TEXT_PAGE_DOWN;
   break;
  }
/* NEUE RUNDE INITIALISIEREN START */
  old_start_zeichen=*start_zeichen;
  old_cursor_position=cursor_position;
/* UND NEUE ZEICHEN EINGABE STARTEN */
 }
 if (rueckgabe!=TEXT_ESC)
 {
  strcpy(org_text,text);
 }
 wprint_frect(window,x,y,max_chars*8,font_now->zeichen[(T_BYTE)'I'].hoehe,back_col);
 wprint_max(window,x,y,max_chars*8,org_text);
 vesa_print_modus=old_print_modus;
 vesa_text=old_text;
 vesa_back_color=old_back_color;
 vesa_text_color=old_text_color;
 T_DEBUG_LEAVE
 return rueckgabe;
}

/***************************************************************/

/* unter verwendung der default breite 8 pixel */
T_INT zahl_eingabe(T_LONG min_zahl,T_LONG max_zahl,T_INT x,T_INT y,T_BYTE text_col,T_BYTE back_col,T_PLONG vorgabe, WINDOW_LISTEN_ELEMENT *window)
{
 T_INT key=0;
 T_INT old_key=1;
 T_INT cursor_position;
 T_INT old_cursor_position;
 T_INT old_print_modus=vesa_print_modus;
 T_INT old_text=vesa_text;
 T_INT old_back_color=vesa_back_color;
 T_INT old_text_color=vesa_text_color;
 T_INT string_length;
 T_INT rueckgabe=TEXT_INIT;
 char text[80];
 T_LONG zahl = *vorgabe;
 T_DEBUG_ENTRY("zahl_eingabe",100)
 sprintf(text,"%lu",max_zahl);
 string_length=strlen(text);
 sprintf(text,"%lu",zahl);
 cursor_position=strlen(text);
 if (cursor_position==string_length)
  cursor_position--;
 vesa_print_modus=PIC_FILLED;
 vesa_text=SINGLE_COLOR;
 vesa_back_color=back_col;
 vesa_text_color=text_col;
 if (window!=NULL)
  wprint(window,x,y,text);
 else
  vesa_print_str(x,y,text);
 old_cursor_position=cursor_position;
 #pragma warn -eff
 while (vesa_mouse_button);
 #pragma warn .eff
 key=0;
 while (1)
 {
  while (((key=fKBDishit())==old_key)&&(!vesa_mouse_button));
  if (vesa_mouse_button==2)
  {
   rueckgabe=TEXT_ESC;
   #pragma warn -eff
   while (vesa_mouse_button);
   #pragma warn .eff
   break;
  }
  if (vesa_mouse_button==1)
  {
   rueckgabe=TEXT_RETURN;
   #pragma warn -eff
   while (vesa_mouse_button);
   #pragma warn .eff
   break;
  }
  old_key=key;
/* CURSOR LEFT START */
  if (((key==KEY_LEFT)||(key==KEY_BSPACE))&&(cursor_position))
  {
   cursor_position--;
  }
/* CURSOR RIGHT START */
  if ((key==KEY_RIGHT)&&(text[cursor_position]!=0)&&(cursor_position+1!=string_length))
  {
   cursor_position++;
  }
/* DELETE START */
  if (((key==KEY_DEL)&&(text[cursor_position]!=0))||((key==KEY_BSPACE)&&(cursor_position+1)))
  {
   if (!((key==KEY_BSPACE)&&(cursor_position==old_cursor_position)))
   {
    T_INT zaehler=cursor_position;
    do
    {
     text[zaehler]=text[zaehler+1];
     if (text[zaehler])
     {
      wprint_char(window,x+(zaehler)*8, y, text[zaehler]);
     }
     zaehler++;
    }
    while (text[zaehler]!=0);
    wprint_char(window,x+(zaehler -1)*8, y, ' ');
   }
  }
/* HOME START */
  if (key==KEY_HOME)
  {
   cursor_position=0;
  }
/* END START */
  if (key==KEY_END)
  {
   cursor_position=strlen(text);
  }
  /* NORMALES ZEICHEN START */
  if ((key>=KEY_0)&&(key<=KEY_9))
  {
   T_INT zaehler=strlen(text);
   if (zaehler++<string_length)
   {
    do
    {
     zaehler--;
     text[zaehler+1]=text[zaehler];
     if (text[zaehler+1])
      wprint_char(window,x+(zaehler+1)*8,y,text[zaehler+1]);
    }
    while (zaehler!=cursor_position);
    text[cursor_position]=(T_CHAR)key;
    if (cursor_position+1!=string_length)
     cursor_position++;
   }
  }
/* AUSGABE START */
  if (text[old_cursor_position]==0)
  {
   wprint_char(window,x+old_cursor_position*8,y,' ');
  }
  else
  {
   wprint_char(window,x+old_cursor_position*8,y,text[old_cursor_position]);
  }
  if (key!=KEY_ENTER)
  {
   if (text[cursor_position]==0)
   {
    wprint_char(window,x+cursor_position*8,y,'_');
   }
   else
   {
    vesa_back_color=text_col;
    vesa_text_color=back_col;
    wprint_char(window,x+cursor_position*8,y,text[cursor_position]);
    vesa_back_color=back_col;
    vesa_text_color=text_col;
   }
  }
  zahl=atol(text);
  if (key==KEY_ENTER)
  {
   if ((zahl>=min_zahl)&&(zahl<=max_zahl))
   {
    rueckgabe=TEXT_RETURN;
    break;
   }
   zahl=*vorgabe;
   wprint_frect(window,x,y,string_length*8,font_now->zeichen[(T_BYTE)'I'].hoehe,back_col);
   wprint(window,x,y,text);
  }
  if (key==KEY_TAB)
  {
   if ((zahl>=min_zahl)&&(zahl<=max_zahl))
   {
    rueckgabe=TEXT_TAB;
    break;
   }
   zahl=*vorgabe;
   wprint_frect(window,x,y,string_length*8,font_now->zeichen[(T_BYTE)'I'].hoehe,back_col);
   wprint(window,x,y,text);
  }
  if (key==KEY_SHIFT_TAB)
  {
   if ((zahl>=min_zahl)&&(zahl<=max_zahl))
   {
    rueckgabe=TEXT_SHIFT_TAB;
    break;
   }
   zahl=*vorgabe;
   wprint_frect(window,x,y,string_length*8,font_now->zeichen[(T_BYTE)'I'].hoehe,back_col);
   wprint(window,x,y,text);
  }
  if (key==KEY_ESCAPE)
  {
   zahl=*vorgabe;
   rueckgabe=TEXT_ESC;
   break;
  }
  if (key==KEY_PGUP)
  {
   if ((zahl>=min_zahl)&&(zahl<=max_zahl))
   {
    rueckgabe=TEXT_PAGE_UP;
    break;
   }
   zahl=*vorgabe;
   wprint_frect(window,x,y,string_length*8,font_now->zeichen[(T_BYTE)'I'].hoehe,back_col);
   wprint(window,x,y,text);
  }
  if (key==KEY_PGDN)
  {
   if ((zahl>=min_zahl)&&(zahl<=max_zahl))
   {
    rueckgabe=TEXT_PAGE_DOWN;
    break;
   }
   zahl=*vorgabe;
   wprint_frect(window,x,y,string_length*8,font_now->zeichen[(T_BYTE)'I'].hoehe,back_col);
   wprint(window,x,y,text);
  }
  old_cursor_position=cursor_position;
 }
 *vorgabe=zahl;
 wprint_frect(window,x,y,string_length*8,font_now->zeichen[(T_BYTE)'I'].hoehe,back_col);
 wprint(window,x,y,text);
 vesa_print_modus=old_print_modus;
 vesa_text=old_text;
 vesa_back_color=old_back_color;
 vesa_text_color=old_text_color;
 T_DEBUG_LEAVE
 return rueckgabe;
}

/***************************************************************/

# ifndef NO_HIDDEN_INFOS
T_INT interne_tasten_funktion(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("interne_tasten_funktion",100)
 switch (parameter->taste)
 {
  case KEY_CTRL_F1:
  {
   parameter->executed=PARAMETER_EXECUTED;
   help_function("index.hlf",NULL);
   break;
  }
  case KEY_CTRL_F6:
  {
   parameter->executed=PARAMETER_EXECUTED;
   show_parameter_info(parameter);
   break;
  }
  case KEY_CTRL_F7:
  {
   parameter->executed=PARAMETER_EXECUTED;
   show_button_info(parameter);
   break;
  }
  case KEY_CTRL_F8:
  {
   parameter->executed=PARAMETER_EXECUTED;
   show_back_info(parameter);
   break;
  }
  case KEY_CTRL_F9:
  {
   parameter->executed=PARAMETER_EXECUTED;
   show_win_info(parameter);
   break;
  }
  case KEY_CTRL_F10:
  {
   parameter->executed=PARAMETER_EXECUTED;
   show_sys_info_window();
   break;
  }
  case KEY_ALT_X:
  {
   close_all_windows();
   PROGRAMM_ENDE
   parameter->executed=PARAMETER_EXECUTED;
   break;
  }
  case KEY_ALT_Q:
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (parameter->window_element!=NULL)
    ((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->parameter=parameter;
   close_window(parameter->window_element,CLOSE_DEFAULT);
   break;
  }
  case KEY_CTRL_F4:
  {
   parameter->executed=PARAMETER_EXECUTED;
   if (parameter->window_element!=NULL)
    ((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->parameter=parameter;
   close_window(parameter->window_element,CLOSE_SHUTDOWN);
   break;
  }
  case KEY_ALT_I:
  {
   parameter->executed=PARAMETER_EXECUTED;
   show_message("Geschrieben 1995/96 von Christopher Salomon");
   break;
  }
  case KEY_ALT_F:
  {
   parameter->executed=PARAMETER_EXECUTED;
   clear_screen();
   break;
  }
  case KEY_ALT_A:
  {
   parameter->executed=PARAMETER_EXECUTED;
   aktivate_window(parameter->window_element);
   break;
  }
  case KEY_ALT_L:
  {
   parameter->executed=PARAMETER_EXECUTED;
   lower_window(parameter->window_element);
   break;
  }
  default:
  {
   break;
  }
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}
#endif
/***************************************************************/

T_INT interne_area_funktion(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("interne_area_funktion",100)
 T_DEBUG_LEAVE
 return parameter->ebene;
}
/***************************************************************/

T_INT execute_close_button(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("execute_close_button",100)
 parameter->executed=PARAMETER_EXECUTED;
 if (fKBDisALT()==T_TRUE)
 {
  help_function("close_w.hlf",NULL);
 }
 else
 {
  if (parameter->window_element!=NULL)
   ((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->parameter=parameter;
  if (parameter->button_element!=NULL)
   if (((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion!=NULL)
    ((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion(parameter);
  close_window((WINDOW_LISTEN_ELEMENT *)parameter->window_element,CLOSE_DEFAULT);
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_exit_button(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("execute_exit_button",100)
 parameter->executed=PARAMETER_EXECUTED;
 if (parameter->window_element!=NULL)
  ((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->parameter=parameter;
 if (parameter->button_element!=NULL)
  if (((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion!=NULL)
   ((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion(parameter);
 close_all_windows();
 PROGRAMM_ENDE
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_win_move(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("execute_win_move",100)
 if (parameter->maus_button==2)
 {
  parameter->executed=PARAMETER_EXECUTED;
  if (parameter->window_element!=NULL)
   move_window((WINDOW_LISTEN_ELEMENT *)parameter->window_element);
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_activate(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("execute_activate",100)
 if (parameter->maus_button==1)
 {
  parameter->executed=PARAMETER_EXECUTED;
  if (parameter->window_element!=NULL)
   aktivate_window((WINDOW_LISTEN_ELEMENT *)parameter->window_element);
 }
 if (parameter->maus_button==2)
 {
  parameter->executed=PARAMETER_EXECUTED;
  if (parameter->window_element!=NULL)
   lower_window((WINDOW_LISTEN_ELEMENT *)parameter->window_element);
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

UPDATE_FUNCTION *insert_update_funktion( T_INT (*zeiger_auf_funktion)(PARAMETER *), T_INT frequency )
{
 UPDATE_FUNCTION *new_update;
 T_DEBUG_ENTRY("insert_update_funktion",100)
 new_update=( UPDATE_FUNCTION *)malloc(sizeof(UPDATE_FUNCTION));
 if (new_update==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
 }
 new_update->update_funktion=zeiger_auf_funktion;
 new_update->frequency=frequency;
 d_fuege_in_liste_ein((T_PVOID )new_update,&update_funktion_first,&update_funktion_last,DL_HINTEN);
 T_DEBUG_LEAVE
 return new_update;
}

/***************************************************************/

T_INT remove_update_funktion( T_INT (*zeiger_auf_funktion)(PARAMETER *) )
{
 UPDATE_FUNCTION *update;
 T_LISTE *hilfe=update_funktion_first;
 T_DEBUG_ENTRY("remove_update_funktion",100)
 while (hilfe!=NULL)
 {
  update=(UPDATE_FUNCTION *)hilfe->objekt;
  if (update->update_funktion==zeiger_auf_funktion)
  {
   d_entferne_aus_liste((T_PVOID )update,&update_funktion_first,&update_funktion_last,DL_CLEAN_UP);
   free(update);
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return T_OK;
  }
  hilfe=hilfe->naechstes;
 }
 T_DEBUG_LEAVE
 return T_NOT_OK;
}

/***************************************************************/

T_INT execute_hide_button(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("execute_hide_button",100)
 parameter->executed=PARAMETER_EXECUTED;
 if (fKBDisALT()==T_TRUE)
 {
  help_function("hide_w.hlf",NULL);
 }
 else
 {
//  if (parameter->window_element!=NULL)
//   ((WINDOW_LISTEN_ELEMENT*)parameter->window_element)->parameter=parameter;
  if (parameter->button_element!=NULL)
   if (((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion!=NULL)
    ((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion(parameter);
  if (parameter->window_element!=NULL)
   hide_raw_window((WINDOW_LISTEN_ELEMENT *)parameter->window_element);
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}
/***************************************************************/

T_INT default_area_funktion_tool(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("default_area_funktion_tool",100)
 if (parameter->maus_button==2)
 {
  /* show hidden windows */
  OPEN_WIN w;
  WINDOW_LISTEN_ELEMENT *window=NULL;
  T_INT old_print_modus;
  T_INT old_text;
  T_INT old_back_color;
  T_INT old_text_color;
  T_INT hidden=get_hidden_anzahl();
  T_INT space_y;
  T_PCHAR *text=NULL;
  T_INT pos_in_hidden=0;
  T_INT redraw;
  T_LISTE *window_liste;
  T_INT c;
  T_INT sel_now=-2;
  T_INT last_sel=-1;
  if (hidden==0)
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  if (  (parameter->maus_x<1)
      ||(parameter->maus_y<1)
      ||(parameter->maus_y>vesa_y-1)
      ||(parameter->maus_x>vesa_x-1)
     )
  {
   // is pretty bad, bad was easier than to do some fancy checking in the
   // code below
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  text=(T_PCHAR *) malloc(sizeof(T_PCHAR)*hidden);
  if (text==NULL)
  {
   t_printf(E_VERBOSE_NONE,"Speicherprobleme... Bye!");
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
  }
  space_y= font_now->zeichen[(T_BYTE)' '].hoehe;
  w.x_pos=parameter->maus_x-HIDDEN_WIN_WIDTH/2;
  w.y_pos=parameter->maus_y-(space_y/2);
  if (w.x_pos<0) w.x_pos =0;
  if (w.y_pos<0) w.y_pos =0;
  if (w.x_pos+HIDDEN_WIN_WIDTH+2>vesa_x) w.x_pos =vesa_x-HIDDEN_WIN_WIDTH-2;
  if (hidden<=MAX_HIDDEN_SHOWN)
  {
   if (w.y_pos+((space_y+2)*hidden)+2>vesa_y)
    w.y_pos =vesa_y-((space_y+2)*hidden)-2;
  }
  else
  {
   if (w.y_pos+((space_y+2)*MAX_HIDDEN_SHOWN)+2>vesa_y)
    w.y_pos =vesa_y-((space_y+2)*MAX_HIDDEN_SHOWN)-2;
  }
  w.breite=HIDDEN_WIN_WIDTH;
  if (hidden<=MAX_HIDDEN_SHOWN)
   w.hoehe=((space_y+2)*hidden)+1;
  if (hidden>MAX_HIDDEN_SHOWN)
   w.hoehe=((space_y+2)*MAX_HIDDEN_SHOWN)+1;
  w.border=1;
  w.bcolor=dhell_grau;
  w.color=ddark_grau;
  w.art=RAW_WINDOW;
  w.id=WIN_OPEN_CHOOSES_ID;
  w.variablen=NULL;
  w.mem_bild=NULL;
  w.pcx_bild=NULL;
  w.name=NULL;
//  w.name="Hidden Windows";
  w.destructor=NULL;
  w.area_funktion=NULL;
  w.tasten_funktion=NULL;
  old_print_modus=vesa_print_modus;
  old_text=vesa_text;
  old_back_color=vesa_back_color;
  old_text_color=vesa_text_color;
  window=open_window(&w);
  if (window==NULL)
  {
   free(text);
   T_DEBUG_FUNCTION_POSITION(4)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  redraw=T_TRUE;
  is_upper=T_TRUE;
  print_srect(window,PRINT_WIN_RAW,0,0,window->b,window->h,ddark_grau,weiss,1);
  c=0;
  window_liste=window_last;
  while (window_liste!=NULL)
  {
   if (((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide>0)
   {
    text[c]=((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->name;
    c++;
   }
   window_liste=window_liste->letztes;
  }
  vesa_print_modus=PIC_FILLED;
  vesa_text=SINGLE_COLOR;
  vesa_back_color=dhell_grau;
  vesa_text_color=ddark_grau;
  do
  {
   T_INT taste=fKBDishit();
   T_INT old_pos=pos_in_hidden;
   if ((taste==KEY_LEFT)||(taste==KEY_RIGHT))
   {
    if (hidden>MAX_HIDDEN_SHOWN)
    {
     if (taste==KEY_RIGHT) // more
     {
      if (pos_in_hidden+MAX_HIDDEN_SHOWN<hidden)
       pos_in_hidden+=MAX_HIDDEN_SHOWN;
     }
     if (taste==KEY_LEFT) // less
     {
      if (pos_in_hidden>0)
       pos_in_hidden-=MAX_HIDDEN_SHOWN;
      if (pos_in_hidden<0)
       pos_in_hidden=0;
     }
     while ((taste==KEY_LEFT)||(taste==KEY_RIGHT))
     {
      taste=fKBDishit();
      vesa_mouse_update();
     }
     if (old_pos!=pos_in_hidden)
      redraw=T_TRUE;
    }
   }
   if (redraw==T_TRUE)
   {
    redraw=T_FALSE;
    last_sel=-1;
    c=pos_in_hidden;
    wprint_frect(window,0,0,w.breite,w.hoehe,dhell_grau);
    while ((c<pos_in_hidden+MAX_HIDDEN_SHOWN)&&(c<hidden))
    {
     if (text[c]!=NULL)
      wprint_max(window,3,1+(space_y+2)*(c-pos_in_hidden),w.breite-5,text[c]);
     else
      wprinta1(window,3,1+(space_y+2)*(c-pos_in_hidden),"%i",c);
     c++;
    }
   }
   if (is_mouse_on_this_window(window))
   {
    sel_now=(vesa_mouse_y-(window->y+window->y_0))/(space_y+2);
    if (sel_now<0) sel_now=0;
    if (sel_now>=MAX_HIDDEN_SHOWN) sel_now=MAX_HIDDEN_SHOWN-1;
    if (hidden<MAX_HIDDEN_SHOWN)
     if (sel_now>=hidden) sel_now=hidden-1;
    if (pos_in_hidden+sel_now>=hidden)
    {
     sel_now=hidden-pos_in_hidden-1;
    }
   }
   if (sel_now!=last_sel)
   {
    if (last_sel>=0)
     print_srect(window,PRINT_CLIPPED,1,1+(space_y+2)*(last_sel),window->b-window->x_0-window->border_r-2,(space_y+2)-1,dhell_grau,dhell_grau,1);
    print_srect(window,PRINT_CLIPPED,1,1+(space_y+2)*(sel_now),window->b-window->x_0-window->border_r-2,(space_y+2)-1,ddark_grau,weiss,1);
    last_sel=sel_now;
   }
   vesa_mouse_update();
  }
  while (vesa_mouse_button==2);
  is_upper=T_FALSE;
  if (is_mouse_on_this_window(window))
  {
   c=0;
   window_liste=window_last;
   while (window_liste!=NULL)
   {
    if (((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide>0)
    {
     if (c==sel_now+pos_in_hidden)
     {
      show_raw_window(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt));
      break;
     }
     c++;
    }
    window_liste=window_liste->letztes;
   }
  }
  vesa_print_modus=old_print_modus;
  vesa_text=old_text;
  vesa_back_color=old_back_color;
  vesa_text_color=old_text_color;
  close_window(window,CLOSE_DEFAULT);
  free(text);
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/

T_INT execute_drag_button(PARAMETER *parameter)
{
 T_DEBUG_ENTRY("execute_drag_button",100)
 parameter->executed=PARAMETER_EXECUTED;
 if (fKBDisALT()==T_TRUE)
 {
  help_function("drag_w.hlf",NULL);
  while (vesa_mouse_button) vesa_mouse_update();
 }
 else
 {
  if ((parameter->button_element==NULL)||(parameter->window_element==NULL))
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return parameter->ebene;
  }
  if (parameter->maus_button==1)
   help_function("drag1_w.hlf",NULL);
  if (parameter->maus_button==2)
  {
   wprint_button((WINDOW_LISTEN_ELEMENT *)parameter->window_element,parameter->button_element,PRESSED);
   parameter->executed=PARAMETER_EXECUTED;
   if (((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion!=NULL)
    ((BUTTON_LISTEN_ELEMENT*)parameter->button_element)->button->notify_funktion(parameter);
   move_window((WINDOW_LISTEN_ELEMENT *)parameter->window_element);
   wprint_button((WINDOW_LISTEN_ELEMENT *)parameter->window_element,parameter->button_element,RELEASED);
  }
 }
 T_DEBUG_LEAVE
 return parameter->ebene;
}

/***************************************************************/
T_VOID remove_current_char(T_PCHAR string)
{
 while (*string!=(T_CHAR)0)
 {
  *string=(*(string+1));
  string++;
 }
}

T_INT is_hex(T_PCHAR word)
{
 T_INT len,i=0;
 T_DEBUG_ENTRY("is_hex",100)
 if ((word==NULL)||(word[0]==(T_CHAR)0))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 len=strlen(word);
 while (*(word+i)=='0') i++;
 if ((*(word+i)=='x')||(*(word+i)=='X'))
 {
  i++;
  if (i==1)
  {
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_FALSE; // only 0...0x... accepted, not x...
  }
 }
 if (*(word+i)=='$')
 {
  i++;
  if (i!=1)
  {
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return T_FALSE; // only $... accepted
  }
 }
 while (*(word+i)!=(T_CHAR)0)
 {
  if ((*(word+i)<'0')||(toupper(*(word+i))>'F'))
  {
   if ((toupper(*(word+i))=='H')&&(*(word+i+1)==(T_CHAR)0))
   {
    if (len>1)
    {
     break;
    }
   }
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return T_FALSE;
  }
  i++;
 }
 i=0;
 while (*(word+i)!=(T_CHAR)0)
 {
  if ((*(word+i)<'0')||(toupper(*(word+i))>'F'))
  {
   remove_current_char(word+i);
   continue;
  }
  i++;
 }
 return T_TRUE;
}
T_INT is_dec(T_PCHAR word)
{
 T_INT i=0;
 T_DEBUG_ENTRY("is_dec",100)
 if ((word==NULL)||(word[0]==(T_CHAR)0))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 while (*(word+i)!=(T_CHAR)0)
 {
  if ((*(word+i)<'0')||(*(word+i)>'9'))
  {
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_FALSE;
  }
  i++;
 }
 return T_TRUE;
}
T_INT is_bin(T_PCHAR word)
{
 T_INT len,i=0;
 T_DEBUG_ENTRY("is_bin",100)
 if ((word==NULL)||(word[0]==(T_CHAR)0))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 len=strlen(word);
 while (*(word+i)!=(T_CHAR)0)
 {
  if ((*(word+i)<'0')||(*(word+i)>'1'))
  {
   if ((toupper(*(word+i))=='B')&&(*(word+i+1)==(T_CHAR)0))
   {
    if (len>1)
    {
     break;
    }
   }
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_FALSE;
  }
  i++;
 }
 i=0;
 while (*(word+i)!=(T_CHAR)0)
 {
  if ((*(word+i)<'0')||(*(word+i)>'1'))
  {
   remove_current_char(word+i);
   continue;
  }
  i++;
 }
 return T_TRUE;
}

T_ULONG convert(T_PCHAR start_string, T_UINT radix)
{
 T_PCHAR string;
 T_PCHAR pointer;
 T_ULONG value=0;
 T_ULONG tmp=0;
 T_ULONG multiplier;
 T_UINT loop;
 T_UINT exponent=0;
 T_DEBUG_ENTRY("convert",100)
 if ((start_string==NULL)||(radix==0))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 pointer=string=strdup(start_string); /* don't destroy start string */

 /* make the string entirely uppercase */

 while (*pointer!=(char)0)
 {
  if ((*pointer>='a')&&(*pointer<='z'))
   *pointer+=('A'-'a');
  pointer++;
 }
 /* decode the string backwards */
 pointer=string;
 while (*(pointer+1)!=0)
  pointer++;
 do
 {
  tmp=*pointer;
  if (tmp>'9')
   tmp-=('A'-10);
  else
   tmp-='0';
  /* Test for validity */
  if (tmp>=radix)
  {
   free(string);
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return 0;
  }
  /* Calculate the Multiplier */
  multiplier=1;
  for (loop=0;loop<exponent;loop++)
   multiplier*=radix;
  value+=tmp*multiplier;
  /* Increment the exponent */
  exponent++;
 }
 while(pointer--!=string);
 free(string);
 T_DEBUG_LEAVE
 return value;
}
/* string must be availabel!!! */
T_PCHAR itob(T_ULONG number,T_PCHAR string)
{
 T_CHAR hex[129];
 T_INT i=0;
 T_DEBUG_ENTRY("itob",100)
 string[0]=(T_CHAR)0;
 sprintf(hex,"%X",number);
 while (*(hex+i)!=(T_CHAR)0)
 {
  switch (*(hex+i))
  {
   case '0':
   {
    strcat(string,"0000");
    break;
   }
   case '1':
   {
    strcat(string,"0001");
    break;
   }
   case '2':
   {
    strcat(string,"0010");
    break;
   }
   case '3':
   {
    strcat(string,"0011");
    break;
   }
   case '4':
   {
    strcat(string,"0100");
    break;
   }
   case '5':
   {
    strcat(string,"0101");
    break;
   }
   case '6':
   {
    strcat(string,"0110");
    break;
   }
   case '7':
   {
    strcat(string,"0111");
    break;
   }
   case '8':
   {
    strcat(string,"1000");
    break;
   }
   case '9':
   {
    strcat(string,"1001");
    break;
   }
   case 'A':
   {
    strcat(string,"1010");
    break;
   }
   case 'B':
   {
    strcat(string,"1011");
    break;
   }
   case 'C':
   {
    strcat(string,"1100");
    break;
   }
   case 'D':
   {
    strcat(string,"1101");
    break;
   }
   case 'E':
   {
    strcat(string,"1110");
    break;
   }
   case 'F':
   {
    strcat(string,"1111");
    break;
   }
  }
  i++;
 }
 T_DEBUG_LEAVE
 return string;
}
