#include <stdlib.h>

#include "standard.h"
#include "tools.h"

#include "updatef.h"

WINDOW_LISTEN_ELEMENT *mouse_window=NULL;
T_INT mw_id=-1;
WINDOW_LISTEN_ELEMENT *window_window=NULL;
T_INT ww_id=-1;

/******************************************************/

T_INT update_input_report(PARAMETER *parameter)
{
 static T_INT report_allowed=T_FALSE;
 static report_active=T_FALSE;
 T_INT mouse_id=-5;
 T_DEBUG_ENTRY("update_input_report",65)
 if ((parameter->taste==INVOKE_INPUT_REPORT)&&(report_active==T_FALSE))
 {
  OPEN_WIN w;
  report_active=T_TRUE;
  if (mouse_window==NULL)
  {
   while (window_exist(mouse_id)==T_TRUE)
    mouse_id--;
   w.x_pos=-1;
   w.border=4;
   w.y_pos=-1;
   w.breite=18*8;
   w.hoehe=70;
   w.bcolor=hhell_grau;
   w.art=RAW_WINDOW | UNBEWEGBAR | FRONT_WINDOW;
   w.id=mouse_id;
   w.name=NULL;
   w.variablen=NULL;
   w.mem_bild=NULL;
   w.pcx_bild=NULL;
   w.destructor=NULL;
   w.area_funktion=NULL;
   w.tasten_funktion=NULL;
   mouse_window=open_window(&w);
   if (mouse_window==NULL)
   {
    report_allowed=T_FALSE;
    T_DEBUG_FUNCTION_POSITION(1)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   mw_id=mouse_window->id;
   print_srect(mouse_window,PRINT_WIN_RAW,0,0,mouse_window->b,mouse_window->h,ddark_grau,weiss,4);
  }
  report_allowed=T_TRUE;
 }
 else if ((parameter->taste==REMOVE_INPUT_REPORT)&&(report_active==T_TRUE))
 {
  report_active=T_FALSE;
  if (mouse_window!=NULL)
  {
   close_window(mouse_window,CLOSE_DEFAULT);
   mouse_window=NULL;
  }
  report_allowed=T_FALSE;
 }
 if (report_allowed==T_TRUE)
 {
  static T_INT x=0;
  static T_INT y=-1;
  static T_INT tastatur=0;
  static T_INT taste=0;
  static T_INT button=0;

  if (get_window(mw_id)==NULL)
  {
   mouse_window=NULL;
   report_allowed=T_FALSE;
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_NOT_OK;
  }

  if (!((x==parameter->maus_x)
       &&(y==parameter->maus_y)
       &&(button==parameter->maus_button)
       &&(tastatur==parameter->tastatur_status)
       &&((taste==parameter->taste)
       ||(parameter->taste==0))))
  {
   T_INT old_print_modus=vesa_print_modus;
   T_INT old_text=vesa_text;
   T_INT old_back_color=vesa_back_color;
   T_INT old_text_color=vesa_text_color;
   vesa_print_modus=PIC_FILLED;
   vesa_text=SINGLE_COLOR;
   vesa_back_color=hhell_grau;
   vesa_text_color=ddark_grau;
   x=parameter->maus_x;
   y=parameter->maus_y;
   button=parameter->maus_button;
   tastatur=parameter->tastatur_status;
   if (parameter->taste)
    taste=parameter->taste;
   // mann koennte einmal testen, ob window beruehrt wird, und wenn nicht, dann is_upper_setzen
   is_upper=T_TRUE;
   print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6,6,7*8,"ax%4u",(T_UINT)parameter->maus_x);
   print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6,22,7*8,"ay%4u",(T_UINT)parameter->maus_y);
   print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6,39,7*8,"b%1u",(T_UINT)button);
   print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6+7*8+2,39,7*8,"t%5u",(T_UINT)(tastatur));
   print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6,57,PMAX,"256*%3u+%3u=%5u",
   ((T_UINT)taste)/256,((T_UINT)taste)-256*(taste/256),
   (T_UINT)taste);
   if (parameter->window_element!=NULL)
   {
    T_UINT winx,winy;
    winx=(T_UINT)parameter->maus_x-(T_UINT)(((WINDOW_LISTEN_ELEMENT *)parameter->window_element)->x);
    winy=(T_UINT)parameter->maus_y-(T_UINT)(((WINDOW_LISTEN_ELEMENT *)parameter->window_element)->y);
    if ((winx<=x)&&(winy<=y))
    {
     print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6+7*8+2,6,7*8-4,"wx%4u",winx);
     print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6+7*8+2,22,7*8-4,"wy%4u",winy);
    }
   }
   else
   {
    print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6+7*8+2,6,7*8-4,"        ");
    print_with_all_features(mouse_window, PRINT_WIN_RAW_CLIPPED,6+7*8+2,22,7*8-4,"        ");
   }
   if (old_text==SINGLE_COLOR)
    wprint(mouse_window,135,22,"S");
   else
    wprint(mouse_window,135,22,"M");
   if (old_print_modus==PIC_ON_BACK)
    wprint(mouse_window,135,6,"B");
   else
    wprint(mouse_window,135,6,"F");
   vesa_print_modus=old_print_modus;
   vesa_text=old_text;
   vesa_back_color=old_back_color;
   vesa_text_color=old_text_color;
   is_upper=T_FALSE;
//   vesa_mouse_zeige_cursor();
  }
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/******************************************************/

T_INT update_window_report(PARAMETER *parameter)
{
 static T_INT report_allowed=T_FALSE;
 static report_active=T_FALSE;
 static T_INT checksum=0;
 T_DEBUG_ENTRY("update_window_report",65)
 if ((parameter->taste==INVOKE_WINDOW_REPORT)&&(report_active==T_FALSE))
 {
  OPEN_WIN w;
  report_active=T_TRUE;
  if (window_window==NULL)
  {
   T_INT window_id=-6;
   while (window_exist(window_id)==T_TRUE)
    window_id--;
   w.border=4;
   w.y_pos=0;
   w.breite=14*8+4;
   w.x_pos=vesa_x-w.breite;
   w.hoehe=vesa_y-(2*w.border)-w.y_pos;
   w.bcolor=hhell_grau;
   w.art=RAW_WINDOW | UNBEWEGBAR;
   w.id=window_id;
   w.name=NULL;
   w.variablen=NULL;
   w.mem_bild=NULL;
   w.pcx_bild=NULL;
   w.destructor=NULL;
   w.area_funktion=NULL;
   w.tasten_funktion=NULL;
   window_window=open_window(&w);
   if (window_window==NULL)
   {
    report_allowed=T_FALSE;
    T_DEBUG_FUNCTION_POSITION(1)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   checksum=0;
   ww_id=window_window->id;
   print_srect(window_window,PRINT_WIN_RAW,0,0,window_window->b,window_window->h,ddark_grau,weiss,4);
  }
  report_allowed=T_TRUE;
 } else if ((parameter->taste==REMOVE_WINDOW_REPORT)&&(report_active==T_TRUE))
 {
  report_active=T_FALSE;
  if (window_window!=NULL)
  {
   close_window(window_window,CLOSE_DEFAULT);
   window_window=NULL;
  }
  report_allowed=T_FALSE;
 }
 if (report_allowed==T_TRUE)
 {
  static T_INT anzahl=-1;
  static WINDOW_LISTEN_ELEMENT *akt_last=NULL;
  static WINDOW_LISTEN_ELEMENT *akt_first=NULL;
  T_LISTE *window_liste=window_first;
  T_INT checksum_neu=0;
  T_INT zaehler=0;
  if (get_window(ww_id)==NULL)
  {
   window_window=NULL;
   report_allowed=T_FALSE;
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_NOT_OK;
  }
  while (window_liste!=NULL)
  {
   checksum_neu+=zaehler+
   T_ABS(((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->id)+
   T_ABS(((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->hide)+
   T_ABS(window_liste->position);
   zaehler++;
   window_liste=window_liste->naechstes;
  }
  checksum_neu*=checksum_neu;
  window_liste=window_first;
  if ((checksum_neu!=checksum)||(anzahl!=d_anzahl_liste(window_first))
  ||(akt_first!=(WINDOW_LISTEN_ELEMENT *)window_first->objekt)
  ||(akt_last!=(WINDOW_LISTEN_ELEMENT *)window_last->objekt))
  {
   T_INT old_print_modus=vesa_print_modus;
   T_INT old_text=vesa_text;
   T_INT old_back_color=vesa_back_color;
   T_INT old_text_color=vesa_text_color;
   T_INT zaehler=0;
   checksum=checksum_neu;
   vesa_print_modus=PIC_FILLED;
   vesa_text=SINGLE_COLOR;
   vesa_back_color=hhell_grau;
   vesa_text_color=ddark_grau;
   akt_last=(WINDOW_LISTEN_ELEMENT *)window_last->objekt;
   akt_first=(WINDOW_LISTEN_ELEMENT *)window_first->objekt;
   anzahl=d_anzahl_liste(window_first);
   // mann koennte einmal testen, ob window beruehrt wird, und wenn nicht, dann is_upper_setzen
   while ((window_liste!=NULL)&&(zaehler<39))
   {
    if ( ((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->art & RAW_WINDOW)
     wprint(window_window,6,6+zaehler*18,"R");
    else
     if ( ((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->art & MEM_PIC_WINDOW)
      wprint(window_window,6,6+zaehler*18,"M");
      if ( ((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->art & PCX_WINDOW)
       wprint(window_window,6,6+zaehler*18,"P");

    if ( ((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->art & UNBEWEGBAR)
     wprint(window_window,-6,6+zaehler*18,"U");
    else
     wprint(window_window,-6,6+zaehler*18,"B");

    if ((((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->hide)||(((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->dhide))
     wprint(window_window,-6,6+zaehler*18,"H");
    else
     wprint(window_window,-6,6+zaehler*18,"S");

    if ( ((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->art & FRONT_WINDOW)
     wprint(window_window,-6,6+zaehler*18,"F");
    else
     if ( ((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->art & BACK_WINDOW)
      wprint(window_window,-6,6+zaehler*18,"B");
     else
      wprint(window_window,-6,6+zaehler*18," ");

    if ( ((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->art & RETURNING)
     wprint(window_window,-6,6+zaehler*18,"R");
    else
     wprint(window_window,-6,6+zaehler*18," ");

    wprinta1(window_window,-6,6+zaehler*18,"%3i",(((WINDOW_LISTEN_ELEMENT *)(window_liste->objekt))->id) );
    window_liste=window_liste->naechstes;
    zaehler++;
   }
   wprint(window_window, 6,6+zaehler*18,"            ");
   vesa_print_modus=old_print_modus;
   vesa_text=old_text;
   vesa_back_color=old_back_color;
   vesa_text_color=old_text_color;
//   vesa_mouse_zeige_cursor();
  }
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/******************************************************/

