// static T_BYTE vesa_dac_depth=6;
// DAC DEPTH internally at 6 BIT!!!

#include <malloc.h>
#include <i86.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifndef __MSDOS__
#define __MSDOS__
#include <vesavbe.h>
#include <svga.h>
#include <pmode.h>
#undef __MSDOS__
#else
#include <vesavbe.h>
#include <svga.h>
#include <pmode.h>
#endif

#include "error.h"
#include "dosmem.h"
#include "vesa.h"
#include "palette.h"
#include "pcx.h"

#ifdef VECTREX
#include "tprint.h"
// from vectrex: display.h
T_UWORD dividerx=0;
T_UWORD dividery=0;

T_INT mausxmin=0;
T_INT mausxmax=0;
T_INT mausymin=0;
T_INT mausymax=0;
#endif

#ifdef VECTREX
T_INT use_vectrex_mouse=T_FALSE;
volatile T_ULONG vmouse_y;
volatile T_ULONG vmouse_x;
#endif

#ifdef VECTREX
T_VOID vesa_mouse_schreiben_vban(T_VOID);
T_VOID vesa_mouse_schreiben_vlin(T_VOID);
#endif

#ifdef VECTREX
T_VOID vesa_mouse_hintergrund_schreiben_vban(T_VOID);
T_VOID vesa_mouse_hintergrund_schreiben_vlin(T_VOID);
#endif

#ifdef VECTREX
T_VOID vesa_mouse_hintergrund_sichern_vban(T_VOID);
T_VOID vesa_mouse_hintergrund_sichern_vlin(T_VOID);
#endif

/* Interrupts */
#define MAUS_INTERRUPT 0x33
#define VESA_INTERRUPT 0x4f
#define BIOS_INTERRUPT 0x10
#define VGA_BIOS   0x10

/* Maus Funktionen */
#define MAUS_RESET 0x0
#define MAUS_BEWEGE_ZEIGER 0x04
#define MAUS_HORIZONTALE_BEWEGUNG 0x07
#define MAUS_VERTIKALE_BEWEGUNG 0x08
#define MAUS_EVENT_HANDLER_SETZEN 0x0c
#define MAUS_ALTERNATIVEN_EVENT_HANDLER_SETZEN 0x18
#define MAUS_VERHAELTNIS_MICKEY_PUNKTE 0x0f

/* sonstige defines */
#define MAUS_EVENT_HANDLER_AKTIV_BITS (255)
#define MAUS_ALTERNATIVE_EVENT_HANDLER_AKTIV_BITS (1+2+4+8+16+32+64+128)
#define MAUS_TREIBER_TEST 0xffff
T_BYTE vesa_mauszeiger_default[MAUS_GROESSE_X_DEFAULT*MAUS_GROESSE_Y_DEFAULT]=
{
 2,2,2,2,2,2,2,2,2,2,2,2,2,2,
 2,1,1,1,1,1,1,1,1,1,2,0,0,0,
 2,1,1,1,1,1,1,1,2,2,0,0,0,0,
 2,1,1,1,1,1,1,2,0,0,0,0,0,0,
 2,1,1,1,1,1,2,0,0,0,0,0,0,0,
 2,1,1,1,1,1,2,0,0,0,0,0,0,0,
 2,1,1,1,1,1,1,2,0,0,0,0,0,0,
 2,1,1,1,1,1,1,1,2,0,0,0,0,0,
 2,1,1,2,1,1,1,1,1,2,0,0,0,0,
 2,1,2,0,2,1,1,1,1,1,2,0,0,0,
 2,1,2,0,0,2,1,1,1,1,1,2,0,0,
 2,2,0,0,0,0,2,1,1,1,1,1,2,0,
 2,2,0,0,0,0,0,2,1,1,1,1,1,2,
 2,0,0,0,0,0,0,0,2,1,1,1,1,2,
 2,0,0,0,0,0,0,0,0,2,1,1,1,2,
 0,0,0,0,0,0,0,0,0,0,2,2,2,0,
};
static T_INT vesa_return_video = -1;
static T_INT vesa_save_mouse_x=0;
static T_INT vesa_save_mouse_y=0;
static T_BYTE vesa_dac_save[768]; // R G B
//static T_BYTE vesa_dac_depth=6;


T_PUCHAR clip_memory=NULL;
T_INT use_clip=T_FALSE;
T_SWORD iSWTmp;
T_INT vesa_bytes_per_scanline=0;
T_INT vesa_mouse_verstecke=0;
T_INT vesa_mouse_x_old=0;
T_INT vesa_mouse_y_old=0;
T_INT vesa_mouse_jetzt_hg_schreiben=T_FALSE;
T_INT vesa_mouse_jetzt_hg_sichern=T_TRUE;
T_INT vesa_mouse_jetzt_schreiben=T_FALSE;
T_PBYTE vesa_mouse_zeiger_rettung=NULL;
MOUSE_POINTER vesa_mouse_zeiger_default={MAUS_GROESSE_X_DEFAULT,MAUS_GROESSE_Y_DEFAULT,vesa_mauszeiger_default,2,1,0};
MOUSE_POINTER *vesa_mouse_zeiger=&vesa_mouse_zeiger_default;
T_INT vesa_mouse_initialisiert=T_FALSE;
volatile T_INT vesa_mouse_interrupt=0;
volatile T_INT vesa_mouse_x=0;
volatile T_INT vesa_mouse_y=0;
volatile T_INT vesa_mouse_button=0;
volatile T_INT vesa_mouse_code=0;
volatile T_INT vesa_mouse_changed=T_FALSE;
static T_SINT mouse_x_work=0;
static T_SINT mouse_y_work=0;
T_INT vesa_modus_active=0;

T_VOID  (* vesa_draw_line) (T_SWORD ,T_SWORD, T_SWORD, T_SWORD, T_SWORD)=NULL;
T_VOID vesa_draw_line_ban(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour);
T_VOID vesa_draw_line_lin(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour);

T_VOID  (* vesa_draw_line_aa) (T_SWORD ,T_SWORD, T_SWORD, T_SWORD, T_SWORD, T_UWORD)=NULL;
T_VOID vesa_draw_line_aa_ban(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour, T_UWORD I);
T_VOID vesa_draw_line_aa_lin(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour, T_UWORD I);

T_VOID (* vesa_mouse_schreiben)(T_VOID)=NULL;
T_VOID vesa_mouse_schreiben_ban(T_VOID);
T_VOID vesa_mouse_schreiben_lin(T_VOID);

T_VOID (* vesa_mouse_hintergrund_schreiben)(T_VOID)=NULL;
T_VOID vesa_mouse_hintergrund_schreiben_ban(T_VOID);
T_VOID vesa_mouse_hintergrund_schreiben_lin(T_VOID);

T_VOID (* vesa_mouse_hintergrund_sichern)(T_VOID)=NULL;
T_VOID vesa_mouse_hintergrund_sichern_ban(T_VOID);
T_VOID vesa_mouse_hintergrund_sichern_lin(T_VOID);

T_VOID (* vesa_plot256)(T_UWORD, T_UWORD, T_UWORD)=NULL;
T_VOID (* vesa_plot256_oc)(T_UWORD, T_UWORD, T_UWORD)=NULL;
T_VOID vesa_plot256_ban(T_UWORD x, T_UWORD y,T_UWORD color);
T_VOID vesa_plot256_lin(T_UWORD x,T_UWORD y, T_UWORD color);
T_VOID vesa_plot256_oc_ban(T_UWORD x, T_UWORD y,T_UWORD color);
T_VOID vesa_plot256_oc_lin(T_UWORD x,T_UWORD y, T_UWORD color);

T_UCHAR (* vesa_get_pixel) (T_UWORD, T_UWORD)=NULL;
T_UCHAR (* vesa_get_pixel_oc) (T_UWORD, T_UWORD)=NULL;
T_UCHAR vesa_get_pixel_lin (T_UWORD x, T_UWORD y);
T_UCHAR vesa_get_pixel_ban (T_UWORD x, T_UWORD y);
T_UCHAR vesa_get_pixel_oc_lin (T_UWORD x, T_UWORD y);
T_UCHAR vesa_get_pixel_oc_ban (T_UWORD x, T_UWORD y);

T_INT (* vesa_print_string_max) (T_INT,T_INT, T_INT, T_INT, T_INT, T_INT, T_PCHAR )=NULL;
T_INT vesa_print_string_max_ban(T_INT offset_x,T_INT offset_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string);
T_INT vesa_print_string_max_lin(T_INT offset_x,T_INT offset_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string);

T_INT (* vesa_print_string_max_oc) (T_INT,T_INT, T_INT, T_INT, T_INT, T_INT, T_PCHAR )=NULL;
T_INT vesa_print_string_max_oc_ban(T_INT offset_x,T_INT offset_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string);
T_INT vesa_print_string_max_oc_lin(T_INT offset_x,T_INT offset_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string);

T_INT (* vesa_print_zeile256) (T_INT, T_INT, T_PBYTE , T_WORD)=NULL;
T_INT (* vesa_print_zeile256_oc) (T_INT, T_INT, T_PBYTE , T_WORD)=NULL;
T_VOID (* vesa_print_zeile256_oc_raw) (T_INT, T_INT, T_PBYTE , T_WORD)=NULL;
T_INT vesa_print_zeile256_ban(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge);
T_INT vesa_print_zeile256_lin(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge);
T_INT vesa_print_zeile256_oc_ban(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge);
T_VOID vesa_print_zeile256_oc_raw_ban(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge);
T_INT vesa_print_zeile256_oc_lin(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge);
T_VOID vesa_print_zeile256_oc_raw_lin(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge);

T_VOID (* vesa_get_zeile) (T_INT, T_INT, T_INT, T_PBYTE )=NULL;
T_VOID (* vesa_get_zeile_oc) (T_INT, T_INT, T_INT, T_PBYTE )=NULL;
T_VOID vesa_get_zeile_ban(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer);
T_VOID vesa_get_zeile_oc_ban(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer);
T_VOID vesa_get_zeile_lin(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer);
T_VOID vesa_get_zeile_oc_lin(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer);

T_INT _ch_vpsm3_(T_INT x,T_INT y,T_CHAR z) {return vesa_print_string_max(0,0,x,y,font_now->zeichen[(T_BYTE)z].breite,font_now->zeichen[(T_BYTE)z].hoehe,(&(z)));}
T_INT _chm_vpsm3_(T_INT x,T_INT y,T_INT len_x,T_INT len_y,T_CHAR z) {return vesa_print_string_max(0,0,x,y,len_x,len_y,(&(z)));}

T_INT vesa_x,vesa_y,vesa_y_m1;
T_INT vesa_force_bank=T_FALSE;

T_ULONG linestartpos[MAX_ZEILEN_LEN];

T_FONT default_font;
T_FONT *font_now=&default_font;
T_INT vesa_print_modus=PIC_FILLED;
T_INT vesa_back_color=0;
T_INT vesa_text=MULTI_COLOR;
T_INT vesa_text_color=1;
T_BYTE zeile[MAX_ZEILEN_LEN];
T_BYTE zeile_hilf[MAX_ZEILEN_LEN];

///////////////////// new
SV_devCtx *svdc=NULL;
T_INT framebuffer=FB_NONE;

T_INT iScreenXres = 0;
T_INT iScreenYres = 0;
T_INT iScreenZres = 0;

/********************/
/* global variables */
/********************/
T_UWORD vesa_offset_compare;
T_UWORD vesa_segment_of_window[2]={0,0};
T_UWORD vesa_address_of_window[2]={0,0};
T_ULONG vesa_write_seg;
T_ULONG vesa_read_seg;
T_UWORD vesa_read_window;
T_UWORD vesa_write_window;
T_UWORD vesa_granularity;
T_UWORD vesa_granularity_potenz;
T_UWORD vesa_and_x;
T_UWORD WinFuncSegment,WinFuncOffset;

T_UWORD offset_x;
T_ULONG offset;
T_UWORD new_win_address;
T_INT initialised=T_FALSE;

/******************************************************************/
/* function prototypes for banked framebuffer bankswitch routines */
/******************************************************************/
T_VOID (*vesa_set_write_window)(T_VOID)=NULL;
T_VOID (*vesa_set_read_window)(T_VOID)=NULL;
///////////////////// new off

/* BIOS Funktionen */
#define BIOS_DATEN_AUSLESEN 0x0f
#define PALETTEN_FUNKTIONEN 0x10
#define MEHRERE_DACS_SETZEN 0x12
#define EIN_DAC_LADEN 0x10
#define EIN_DAC_LESEN 0x15
#define MEHRERE_DACS_LESEN 0x17

/* VESA Funktionen */
#define VESA_FAEHIGKEITEN 0x0
#define VESA_KENNDATEN_MODUS 0x01
#define VESA_MODUS_SETZEN 0x02
#define VESA_GRAFIK_DATEN_FUNKTIONEN 0x04
#define VESA_FENSTER_SETZEN 0x05
#define VESA_SPEICHER_ABFRAGEN 0x0
#define VESA_SPEICHERN 0x01
#define VESA_LESEN 0x02

#define VESA_GRAFIK_SPEICHERN_BITS (1+2+4+8)
#define VESA_ERROR_TEST 0x004f
#define MODUS_ENDE 0xffff

/***************************************************************/
T_WORD vesa_error=T_OK;
T_INT vesa_da=VESA_NOT_INITIALIZED;

/**********************************************/
/* function to clear vesa mode variable stuff */
/**********************************************/
T_VOID vesa_clear_modus_infos(T_VOID)
{
 T_DEBUG_ENTRY("vesa_clear_modus_infos",25)
 vesa_read_window=-1;              // 0 or 1
 vesa_write_window=-1;             // 0 or 1
 vesa_segment_of_window[0]=0;      // probably 0xa000
 vesa_segment_of_window[1]=0;      // probably 0xa000
 vesa_address_of_window[0]=0;      // window position on VESA-Card (read or write)
 vesa_address_of_window[1]=0;      // window position on VESA-Card (read or write)
 vesa_read_seg=0;                  // probably 0xa000
 vesa_write_seg=0;                 // probably 0xa000
 vesa_granularity=-1;              // usually 64, but sometime 4
 vesa_granularity_potenz=0;        // well...
 vesa_and_x=1023;
 vesa_offset_compare=0;
 WinFuncOffset=0;                  // realmode bankswitch function offset
 WinFuncSegment=0;                 // realmode bankswitch function segment
 T_DEBUG_LEAVE
}

/***********************************************************/
/* banked framebuffer bank set function CALL, WRITE WINDOW */
/***********************************************************/
T_VOID set1(T_VOID)
{
 RMREGS wregs;
 RMSREGS wsregs;
 T_DEBUG_ENTRY("set1",25)
 wregs.x.bx=vesa_write_window;
 wregs.x.dx=vesa_address_of_window[vesa_write_window];
 PM_callRealMode(WinFuncSegment,WinFuncOffset,&wregs,&wsregs);
 T_DEBUG_LEAVE
}

/**********************************************************/
/* banked framebuffer bank set function INT, WRITE WINDOW */
/**********************************************************/
T_VOID set2(T_VOID)
{
 union REGS regs;
 T_DEBUG_ENTRY("set2",25)
 regs.w.ax = 0x4f05;
 regs.w.bx = vesa_write_window;
 regs.w.cx = 0;
 regs.w.dx = vesa_address_of_window[vesa_write_window];
 int386(0x10,&regs,&regs);
 T_DEBUG_LEAVE
}

/**********************************************************/
/* banked framebuffer bank set function CALL, READ WINDOW */
/**********************************************************/
T_VOID set3(T_VOID)
{
 RMREGS rregs;
 RMSREGS rsregs;
 T_DEBUG_ENTRY("set3",25)
 rregs.x.bx=vesa_read_window;
 rregs.x.dx=vesa_address_of_window[vesa_read_window];
 PM_callRealMode(WinFuncSegment,WinFuncOffset,&rregs,&rsregs);
 T_DEBUG_LEAVE
}

/*********************************************************/
/* banked framebuffer bank set function INT, READ WINDOW */
/*********************************************************/
T_VOID set4(T_VOID)
{
 union REGS regs;
 T_DEBUG_ENTRY("set4",25)
 regs.w.ax = 0x4f05;
 regs.w.bx = vesa_read_window;
 regs.w.cx = 0;
 regs.w.dx = vesa_address_of_window[vesa_read_window];
 int386(0x10,&regs,&regs);
 T_DEBUG_LEAVE
}

/***************************************/
/* initialize banked framebuffer modus */
/***************************************/
T_VOID vesa_init_modus_infos(T_UWORD mode)
{
 ModeInfoBlock far *modeInfo=NULL;
 REALPTR modeInfo_rp;
 union REGS regs;
 struct SREGS sregs;
 DOS4GW_RMREGS rmregs;
 T_DEBUG_ENTRY("vesa_init_modus_infos",25)
 /*****************************/
 /* get the mode information  */
 /*****************************/
 modeInfo = (ModeInfoBlock far *) fDOSmalloc(&modeInfo_rp,sizeof(ModeInfoBlock));
 if (modeInfo==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  tool_exit(VESA_NO_DOS_MEMORY);
 }
 memset(&rmregs,0,sizeof(rmregs));
 memset(&regs,0,sizeof(regs));
 memset(&sregs,0,sizeof(sregs));
 segread(&sregs);

 rmregs.eax = 0x4f01;
 rmregs.ecx = (T_INT) mode;
 rmregs.es = modeInfo_rp.Segment;
 rmregs.ds = modeInfo_rp.Segment;
 regs.x.eax = 0x300;
 regs.x.ebx = 0x10;
 regs.x.ecx = 0;
 sregs.es = FP_SEG(&rmregs);
 regs.x.edi = FP_OFF(&rmregs);
 int386x(0x31,&regs,&regs,&sregs);
 if ((rmregs.eax&0xffff) != 0x4f)
 {
  t_printf(E_VERBOSE_NONE,"vesa-init - Couldn't get VESA Info on Mode!");
 }
 /**********************************************************/
 /* ok VESA modus got, now initialize the needed variables */
 /**********************************************************/
 vesa_clear_modus_infos();
 /*******************************************/
 /* First locate the READ and WRITE windows */
 /*******************************************/
 if (modeInfo->WinAAttributes&1)
 {
  if (modeInfo->WinAAttributes&2)
  {
   /*************************************/
   /* First Window is a readable window */
   /*************************************/
   vesa_read_window=0;
   vesa_segment_of_window[vesa_read_window]=modeInfo->WinASegment;
  }
  if (modeInfo->WinAAttributes&4)
  {
   /**************************************/
   /* First Window is a writeable window */
   /**************************************/
   vesa_write_window=0;
   vesa_segment_of_window[vesa_write_window]=modeInfo->WinASegment;
  }
 }
 if (modeInfo->WinBAttributes&1)
 {
  if (modeInfo->WinBAttributes&2)
  {
   /***************************************/
   /* Second Window is a readeable window */
   /***************************************/
   vesa_read_window=1;
   vesa_segment_of_window[vesa_read_window]=modeInfo->WinBSegment;
  }
  if (modeInfo->WinBAttributes&4)
  {
   /***************************************/
   /* Second Window is a writeable window */
   /***************************************/
   vesa_write_window=1;
   vesa_segment_of_window[vesa_write_window]=modeInfo->WinBSegment;
  }
 }

 /********************************************************/
 /* Get granularity and calculate some stuff, so we only */
 /* use shifts and 'AND's to calculate pages             */
 /********************************************************/
 vesa_granularity=modeInfo->WinGranularity;
 while (vesa_granularity>1)
 {
  vesa_granularity=vesa_granularity>>1;
  vesa_granularity_potenz++;
  vesa_and_x=(vesa_and_x<<1)+1;
 }
 vesa_granularity_potenz+=10; /* 10 equals * 1024 (== 2^10) */
 vesa_granularity=modeInfo->WinGranularity;

 /*****************************************************/
 /* look if there is a realmode bank setting routine  */
 /* I'm to lazy to look for a protected mode routine, */
 /* I'm to lazy to look for a protected mode routine, */
 /* which is only available under VESA 2.0            */
 /*****************************************************/
 WinFuncSegment=modeInfo->WinFuncSegment;
 WinFuncOffset=modeInfo->WinFuncOffset;
 if (WinFuncOffset+WinFuncSegment==NULL)
 {
  /********************************************************/
  /* no function found, have to bankswitch via INT (yuk!) */
  /********************************************************/
  vesa_set_write_window=set2;
  vesa_set_read_window=set4;
 }
 else
 {
  /******************************************/
  /* yep, set bank via far call (real mode) */
  /******************************************/
  vesa_set_write_window=set1;
  vesa_set_read_window=set3;
 }
 /****************************************************************/
 /* just set the rest of the variables and initialize vesa-banks */
 /****************************************************************/
 vesa_offset_compare=vesa_granularity << 10;
 vesa_write_seg=vesa_segment_of_window[vesa_write_window]*16;
 vesa_read_seg=vesa_segment_of_window[vesa_read_window]*16;
 vesa_address_of_window[vesa_write_window]=0;
 vesa_set_write_window();
 vesa_address_of_window[vesa_read_window]=0;
 vesa_set_read_window();

 vesa_address_of_window[vesa_write_window]=-1;
 vesa_address_of_window[vesa_read_window]=-1;

 fDOSfree(&modeInfo_rp);
 T_DEBUG_LEAVE
}

/*********************************/
/* get vesa modus on modus datas */
/*********************************/
/*****************************************************************/
/* For VESA 2.0 compliance, the VESA modes are not fixed anymore */
/* we have to look for the required mode ourself                 */
/*****************************************************************/
T_UWORD get_mode_on_specs(T_WORD x_res, T_WORD y_res, T_WORD color_bits, T_WORD special_flags)
{
 T_WORD i=0;
 SV_modeInfo modeInfo;
 T_DEBUG_ENTRY("get_mode_on_specs",25)
 while (svdc->modeList[i]!=(T_UWORD)-1)      /* Pointer to supported modes       */
 {
  if (SV_getModeInfo(svdc->modeList[i],&modeInfo)==T_FALSE)
  {
   /***************************/
   /* only dummy mode go here */
   /***************************/
   t_printf(E_VERBOSE_STANDARD,"\nMode:$%04hx not available!", svdc->modeList[i]);
  }
  else
  {
   /*********************************************/
   /* just check the things which were required */
   /* pretty straight forward                   */
   /*********************************************/
   if ((modeInfo.XResolution==x_res)
     &&(modeInfo.YResolution==y_res)
     &&(modeInfo.BitsPerPixel==color_bits)
     &&((modeInfo.Attributes&special_flags)==special_flags))
   {
    t_printf(E_VERBOSE_LOW,"\nMode:$%04hx, X:%4hi, Y:%4hi, BITS:%2hi, Attrib:%04X",
            svdc->modeList[i],
            modeInfo.XResolution,
            modeInfo.YResolution,
            modeInfo.BitsPerPixel,
            modeInfo.Attributes);


    vesa_x=iScreenXres = modeInfo.XResolution;
    vesa_y=iScreenYres = modeInfo.YResolution;
    vesa_y_m1=vesa_y-1;
    vesa_bytes_per_scanline = modeInfo.BytesPerScanLine;
    iScreenZres = 1<<modeInfo.BitsPerPixel;

    T_DEBUG_FUNCTION_POSITION(5)
    T_DEBUG_LEAVE
    return svdc->modeList[i];
   }
  }
  i++;
 }
 T_DEBUG_LEAVE
 return 0;
}

T_INT vesa_karte_da(T_VOID) /* rueckgabe=T_OK, dann alles OK */
{
 T_DEBUG_ENTRY("vesa_karte_da",25)
 if (vesa_da==VESA_NOT_INITIALIZED) /* wenn schonmal aufgerufen, dann berspringen */
 {
  /****************/
  /* INIT SVGALIB */
  /****************/
  svdc=SV_init(T_TRUE);
  if (svdc==NULL)
  {
   t_printf(E_VERBOSE_NONE,"\nNo Vesa found (SVGALIB)!");
   t_printf(E_VERBOSE_NONE,"\nSV_INIT initialization failed!!!\n");
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return T_NOT_OK;
  }
  else
  {
   t_printf(E_VERBOSE_LOW,"\nVBE Version %i.%i found!",svdc->VBEVersion/256,svdc->VBEVersion-(svdc->VBEVersion/256)*256);
   vesa_da=T_OK;
  }
 }
 T_DEBUG_LEAVE
 return vesa_error=vesa_da;
}

/***************************************************************/

T_INT vesa_gebe_datenspeicher_zurueck(T_VOID)   /* NICHTS_FREIGEGEBEN, VESA_DATEN_FREIGEGEBEN, VESA_MODUS_DATEN_FREIGEGEBEN, VESA_MODUS_UND_DATEN_FREIGEGEBEN */
{
 T_INT was_gemacht=VESA_NOTHING_DONE;
 T_DEBUG_ENTRY("vesa_gebe_datenspeicher_zurueck",25)
 vesa_error=1;
 T_DEBUG_LEAVE
 return was_gemacht;
}

/***************************************************************/
/* taken from VBE from scitechs lib ... */
char *copyStrToLocal(char *p,char *realPtr)
{
 uint    sel,off;
 uchar   v;

 PM_mapRealPointer(&sel,&off,(uint)((ulong)realPtr >> 16),(uint)((ulong)realPtr & 0xFFFF));
 while ((v = PM_getByte(sel,off)) != 0)
 {
  *p++ = v;
  off++;
 }
 *p++ = 0;
 return p;
}

T_INT vesa_anzeige_daten(T_VOID)    /* Rueckgabe siehe ist_vesa_karte_da() */
{
 T_INT modus_zaehler=0;
 T_INT nebeneinander_zaehler=0;
 T_UINT sel,off,r_seg,r_off;
 T_CHAR t[100];
 VBE_vgaInfo vgaInfo;
 T_DEBUG_ENTRY("vesa_anzeige_daten",25)
 /*****************************/
 /* get the mode informations */
 /*****************************/
 PM_allocRealSeg(1024,&sel,&off,&r_seg,&r_off);
 VBE_init(1024,sel,off,r_seg,r_off);
 VBE_detect(&vgaInfo);
 t_printf(E_VERBOSE_NONE,"\n\nVESA information");
 t_printf(E_VERBOSE_NONE,"\n----------------");

 t_printf(E_VERBOSE_NONE,"\nSignature      : %c%c%c%c\n",vgaInfo.VESASignature[0],vgaInfo.VESASignature[1],vgaInfo.VESASignature[2],vgaInfo.VESASignature[3]);
 t_printf(E_VERBOSE_NONE,"Versionnumber  : %i.%i\n",vgaInfo.VESAVersion/256,vgaInfo.VESAVersion-((vgaInfo.VESAVersion/256)*256));
 t_printf(E_VERBOSE_NONE,"OEMString      : %s\n",vgaInfo.OemStringPtr);
 t_printf(E_VERBOSE_NONE,"Capabilities   : %x\n",vgaInfo.Capabilities);
 t_printf(E_VERBOSE_NONE,"that means     :\n");
 if (vgaInfo.Capabilities&vbe8BitDAC)
  t_printf(E_VERBOSE_NONE,"                 DAC width is switchable to 8 bit\n");
 else
  t_printf(E_VERBOSE_NONE,"                 DAC width is not switchable to 8 bit\n");
 if (vgaInfo.Capabilities&vbeNonVGA)
  t_printf(E_VERBOSE_NONE,"                 Controller is non-VGA\n");
 else
  t_printf(E_VERBOSE_NONE,"                 Controller is VGA\n");
 if (vgaInfo.Capabilities&vbeBlankRAMDAC)
  t_printf(E_VERBOSE_NONE,"                 Programmed DAC with blank bit\n");
 else
  t_printf(E_VERBOSE_NONE,"                 NOT!: Programmed DAC with blank bit (whatever that means)\n");
 t_printf(E_VERBOSE_NONE,"Memory         : %i\n",vgaInfo.TotalMemory*64);
 t_printf(E_VERBOSE_NONE,"Modes          :");
 t_printf(E_VERBOSE_NONE," %x",vgaInfo.VideoModePtr[modus_zaehler++]);
 while (vgaInfo.VideoModePtr[modus_zaehler]!=MODUS_ENDE)
 {
  if (nebeneinander_zaehler==9)
  {
   t_printf(E_VERBOSE_NONE,"\n                ");
   t_printf(E_VERBOSE_NONE," %x",vgaInfo.VideoModePtr[modus_zaehler++]);
  }
  else
  {
   t_printf(E_VERBOSE_NONE,", %x",vgaInfo.VideoModePtr[modus_zaehler++]);
  }
  nebeneinander_zaehler=(nebeneinander_zaehler+1)%10;
 }
 if (vgaInfo.VESAVersion/256>=2)
 {
  t_printf(E_VERBOSE_NONE,"\n\nVESA 2.0 extension Information");
  t_printf(E_VERBOSE_NONE,"\n------------------------------");
  t_printf(E_VERBOSE_NONE,"\nSoftware rev.  : %i.%i",vgaInfo.OemSoftwareRev/256,vgaInfo.OemSoftwareRev-((vgaInfo.OemSoftwareRev/256)*256));
  // don't ask me why this is neccessary, it should have been done in VBE_detect...
  copyStrToLocal(t,vgaInfo.OemVendorNamePtr);
  t_printf(E_VERBOSE_NONE,"\nVendor Name    : %s",t);
  copyStrToLocal(t,vgaInfo.OemProductNamePtr);
  t_printf(E_VERBOSE_NONE,"\nProduct Name   : %s",t);
  copyStrToLocal(t,vgaInfo.OemProductRevPtr);
  t_printf(E_VERBOSE_NONE,"\nProduct rev.   : %s",t);
 }
 t_printf(E_VERBOSE_NONE,"\n");
 PM_freeRealSeg(sel,off);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/
/* VESA MODI defined in vesa.h */
T_INT vesa_existiert_modus(T_INT modus)
{
 T_INT mode=0;
 T_INT e_verbose_save=e_verbose;
 e_verbose=E_VERBOSE_NONE;
 T_DEBUG_ENTRY("vesa_existiert_modus",25)
 if (svdc)
 {
  if ((svdc->VBEVersion/256>=2)&&(vesa_force_bank==T_FALSE))
  {
   switch (modus)
   {
    case SVGA320X200:
    {
     mode=get_mode_on_specs(320,200,8,svHaveLinearBuffer);
     break;
    }
    case SVGA640X480:
    {
     mode=get_mode_on_specs(640,480,8,svHaveLinearBuffer);
     break;
    }
    case SVGA800X600:
    {
     mode=get_mode_on_specs(800,600,8,svHaveLinearBuffer);
     break;
    }
    case SVGA1024X768:
    {
     mode=get_mode_on_specs(1024,768,8,svHaveLinearBuffer);
     break;
    }
    case SVGA1280X1024:
    {
     mode=get_mode_on_specs(1280,1024,8,svHaveLinearBuffer);
     break;
    }
    case SVGA1600X1200:
    {
     mode=get_mode_on_specs(1600,1200,8,svHaveLinearBuffer);
     break;
    }
   }
  }
  /*********************************************/
  /* check for Banked Framebuffer (VBE >= 1.0) */
  /*********************************************/
  if (mode==0) /* only if no mode found yet */
  {
   switch (modus)
   {
    case SVGA320X200:
    {
     mode=get_mode_on_specs(320,200,8,0);
     break;
    }
    case SVGA640X480:
    {
     mode=get_mode_on_specs(640,480,8,0);
     break;
    }
    case SVGA800X600:
    {
     mode=get_mode_on_specs(800,600,8,0);
     break;
    }
    case SVGA1024X768:
    {
     mode=get_mode_on_specs(1024,768,8,0);
     break;
    }
    case SVGA1280X1024:
    {
     mode=get_mode_on_specs(1280,1024,8,0);
     break;
    }
    case SVGA1600X1200:
    {
     mode=get_mode_on_specs(1600,1200,8,0);
     break;
    }
   }
  }
 }
 e_verbose=e_verbose_save;
 if (mode==0)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_DRIVER_ERROR)
  T_DEBUG_LEAVE
  return vesa_error=VESA_DRIVER_ERROR;
 }
/*
 {
  // slow as fucking hell...
  T_INT i;
  union REGS regs;
  struct SREGS sregs;
  segread(&sregs);
  for (i=0;i<256;i++)
  {
   regs.h.ah=PALETTEN_FUNKTIONEN;
   regs.h.al=EIN_DAC_LESEN;
   regs.w.bx=i;
   int386x(BIOS_INTERRUPT,&regs,&regs,&sregs);
   vesa_dac_save[i*3]=regs.h.dh;
   vesa_dac_save[i*3+1]=regs.h.ch;
   vesa_dac_save[i*3+2]=regs.h.cl;
  }
 }
*/
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

/***************************************************************/

T_INT vesa_lese_modus_daten(T_INT modus)
{
 T_DEBUG_ENTRY("vesa_lese_modus_daten",25)
 /*
 union REGS regs;
 struct SREGS sregs;
 if (vesa_karte_da()==T_OK)
 {
  if (vesa_existiert_modus(modus)==T_OK)
  {
   sregs.es=FP_SEG(vesa_modus_daten);
   regs.x.di=FP_OFF(vesa_modus_daten);
   regs.x.cx=modus;
   regs.h.ah=VESA_INTERRUPT;
   regs.h.al=VESA_KENNDATEN_MODUS;
   int86x(BIOS_INTERRUPT,&regs,&regs,&sregs);
  }
  else
   return vesa_error=VESA_MODE_NOT_FOUND;
 }
 */
 T_DEBUG_LEAVE
 return vesa_error=vesa_da;
}

/***************************************************************/

T_INT vesa_anzeige_modus_daten(T_INT modus)
{
 T_INT fehler=T_OK;
 SV_modeInfo modeInfo;
 ModeInfoBlock far *VmodeInfo=NULL;
 REALPTR VmodeInfo_rp;
 union REGS regs;
 struct SREGS sregs;
 DOS4GW_RMREGS rmregs;
 T_DEBUG_ENTRY("vesa_anzeige_modus_daten",25)
 /*****************************/
 /* get the mode information  */
 /*****************************/
 VmodeInfo = (ModeInfoBlock far *) fDOSmalloc(&VmodeInfo_rp,sizeof(ModeInfoBlock));
 if (VmodeInfo==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  tool_exit(VESA_NO_DOS_MEMORY);
 }
 memset(&rmregs,0,sizeof(rmregs));
 memset(&regs,0,sizeof(regs));
 memset(&sregs,0,sizeof(sregs));
 segread(&sregs);

 rmregs.eax = 0x4f01;
 rmregs.ecx = (T_INT) modus;
 rmregs.es = VmodeInfo_rp.Segment;
 rmregs.ds = VmodeInfo_rp.Segment;
 regs.x.eax = 0x300;
 regs.x.ebx = 0x10;
 regs.x.ecx = 0;
 sregs.es = FP_SEG(&rmregs);
 regs.x.edi = FP_OFF(&rmregs);
 int386x(0x31,&regs,&regs,&sregs);
 if((rmregs.eax&0xffff) != 0x4f)
 {
  t_printf(E_VERBOSE_NONE,"vesa-init - Couldn't get VESA Info on Mode!");
 }
 else
 {
  t_printf(E_VERBOSE_NONE,"\nVESA Information for Mode $%x",modus);
  t_printf(E_VERBOSE_NONE,"\n------------------------------");
  if (VmodeInfo->ModeAttributes&1)
   t_printf(E_VERBOSE_NONE,"\n   Mode is OK for monitor");
  else
   t_printf(E_VERBOSE_NONE,"\n   Modus is not OK for monitor");
  if (VmodeInfo->ModeAttributes&2)
   t_printf(E_VERBOSE_NONE,"\n   No optional information available");
  else
   t_printf(E_VERBOSE_NONE,"\n   Optional information are available");
  if (VmodeInfo->ModeAttributes&4)
   t_printf(E_VERBOSE_NONE,"\n   BIOS textfunctions are supported");
  else
   t_printf(E_VERBOSE_NONE,"\n   BIOS textfunctions are not supported");
  if (VmodeInfo->ModeAttributes&8)
   t_printf(E_VERBOSE_NONE,"\n   Is a color mode");
  else
   t_printf(E_VERBOSE_NONE,"\n   Is a monochrome mode");
  if (VmodeInfo->ModeAttributes&16)
   t_printf(E_VERBOSE_NONE,"\n   Is a graphical mode");
  else
   t_printf(E_VERBOSE_NONE,"\n   Is text mode");
  if (VmodeInfo->WinAAttributes&1)
   t_printf(E_VERBOSE_NONE,"\n   Window 1 is available");
  else
   t_printf(E_VERBOSE_NONE,"\n   Window 1 is not available");
  if (VmodeInfo->WinAAttributes&2)
   t_printf(E_VERBOSE_NONE,"\n   Read is possible on window 1");
  else
   t_printf(E_VERBOSE_NONE,"\n   Read is not possible on window 1");
  if (VmodeInfo->WinAAttributes&4)
   t_printf(E_VERBOSE_NONE,"\n   Write is possible on window 1");
  else
   t_printf(E_VERBOSE_NONE,"\n   Write is not possible on window 1");
  if (VmodeInfo->WinBAttributes&1)
   t_printf(E_VERBOSE_NONE,"\n   Window 2 is available");
  else
   t_printf(E_VERBOSE_NONE,"\n   Window 2 is not available");
  if (VmodeInfo->WinBAttributes&2)
   t_printf(E_VERBOSE_NONE,"\n   Read is possible on window 2");
  else
   t_printf(E_VERBOSE_NONE,"\n   Read is not possible on window 2");
  if (VmodeInfo->WinBAttributes&4)
   t_printf(E_VERBOSE_NONE,"\n   Write is possible on window 2");
  else
   t_printf(E_VERBOSE_NONE,"\n   Write is not possible on window 2");
  if (VmodeInfo->WinFuncOffset+VmodeInfo->WinFuncSegment!=NULL)
   t_printf(E_VERBOSE_NONE,"\n   Window function available");
  else
   t_printf(E_VERBOSE_NONE,"\n   Window function not available");
  t_printf(E_VERBOSE_NONE,"\n   Window granularity in k.........: %i",VmodeInfo->WinGranularity);
  t_printf(E_VERBOSE_NONE,"\n   Window size in k................: %i",VmodeInfo->WinSize);
  t_printf(E_VERBOSE_NONE,"\n   Window 1 segment................: %X",VmodeInfo->WinASegment);
  t_printf(E_VERBOSE_NONE,"\n   Window 2 segment................: %X",VmodeInfo->WinBSegment);
  t_printf(E_VERBOSE_NONE,"\n   Bytes per scanline..............: %i",VmodeInfo->BytesPerScanLine);
  t_printf(E_VERBOSE_NONE,"\n   Horizontal resolution...........: %i",VmodeInfo->XResolution);
  t_printf(E_VERBOSE_NONE,"\n   Vertical resolution.............: %i",VmodeInfo->YResolution);
  t_printf(E_VERBOSE_NONE,"\n   Character cell width............: %i",VmodeInfo->XCharSize);
  t_printf(E_VERBOSE_NONE,"\n   Character cell height...........: %i",VmodeInfo->YCharSize);
  t_printf(E_VERBOSE_NONE,"\n   Number of memory planes.........: %i",VmodeInfo->NumberOfPlanes);
  t_printf(E_VERBOSE_NONE,"\n   Bits per pixel..................: %i",VmodeInfo->BitsPerPixel);
  t_printf(E_VERBOSE_NONE,"\n   Number of CGA style banks.......: %i",VmodeInfo->NumberOfBanks);
  t_printf(E_VERBOSE_NONE,"\n   Memory model type...............: ");
  switch (VmodeInfo->MemoryModel)
  {
   case 0x0:
   {
    t_printf(E_VERBOSE_NONE,"Textmode");
    break;
   }
   case 0x1:
   {
    t_printf(E_VERBOSE_NONE,"CGA-format");
    break;
   }
   case 0x2:
   {
    t_printf(E_VERBOSE_NONE,"Hercules-Format");
    break;
   }
   case 0x3:
   {
    t_printf(E_VERBOSE_NONE,"EGA/VGA format for 16 colors");
    break;
   }
   case 0x4:
   {
    t_printf(E_VERBOSE_NONE,"packed format with 2 pixels, 4 bit per byte");
    break;
   }
   case 0x5:
   {
    t_printf(E_VERBOSE_NONE,"EGA/VGA format for 256 colors");
    break;
   }
   default:
   {
    t_printf(E_VERBOSE_NONE,"unkown format");
    break;
   }
  }
  t_printf(E_VERBOSE_NONE,"\n   Size of CGA style banks.........: %i",VmodeInfo->BankSize);
  t_printf(E_VERBOSE_NONE,"\n   Number of images pages..........: %i",VmodeInfo->NumberOfImagePages);
  t_printf(E_VERBOSE_NONE,"\n   Size of direct color red mask...: %i",VmodeInfo->RedMaskSize);
  t_printf(E_VERBOSE_NONE,"\n   Bit posn of lsb of red mask.....: %i",VmodeInfo->RedFieldPosition);
  t_printf(E_VERBOSE_NONE,"\n   Size of direct color green mask.: %i",VmodeInfo->GreenMaskSize);
  t_printf(E_VERBOSE_NONE,"\n   Bit posn of lsb of green mask...: %i",VmodeInfo->GreenFieldPosition);
  t_printf(E_VERBOSE_NONE,"\n   Size of direct color blue mask..: %i",VmodeInfo->BlueMaskSize);
  t_printf(E_VERBOSE_NONE,"\n   Bit posn of lsb of blue mask....: %i",VmodeInfo->BlueFieldPosition);
  t_printf(E_VERBOSE_NONE,"\n   Direct color mode attributes....: %X",VmodeInfo->DirectColorModeInfo);
  if (svdc->VBEVersion/256>=2)
  {
   t_printf(E_VERBOSE_NONE,"\n\nVESA 2.0 extension Information for Mode $%x",modus);
   t_printf(E_VERBOSE_NONE,  "\n--------------------------------------------",modus);
   t_printf(E_VERBOSE_NONE,"\n   Physical address linear buffer..: %lX",VmodeInfo->PhysBasePtr);
   t_printf(E_VERBOSE_NONE,"\n   Pointer to start offscreen mem..: %lX",VmodeInfo->OffScreenMemOffset);
   t_printf(E_VERBOSE_NONE,"\n   Offscreen memory in 1K's........: %i",VmodeInfo->OffScreenMemSize);
  }
 }
 fDOSfree(&VmodeInfo_rp);
 if (true==SV_getModeInfo(modus,&modeInfo))
 {
  t_printf(E_VERBOSE_NONE,"\n\nSVGALIB Information for Mode $%x (VBE:$%x)",modus,modeInfo.Mode);
  t_printf(E_VERBOSE_NONE,  "\n--------------------------------------------",modus,modeInfo.Mode);
  if (modeInfo.Attributes&1)
   t_printf(E_VERBOSE_NONE,"\n   Mode supports multi buffering");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not support multi buffering");
  if (modeInfo.Attributes&2)
   t_printf(E_VERBOSE_NONE,"\n   Mode supports virtual scrolling");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not support virtual scrolling");
  if (modeInfo.Attributes&4)
   t_printf(E_VERBOSE_NONE,"\n   Mode supports banked framebuffer");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not support banked framebuffer");
  if (modeInfo.Attributes&8)
   t_printf(E_VERBOSE_NONE,"\n   Mode supports linear framebuffer");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not support linear framebuffer");
  if (modeInfo.Attributes&16)
   t_printf(E_VERBOSE_NONE,"\n   Mode supports 2D acceleration");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not support 2D acceleration");
  if (modeInfo.Attributes&32)
   t_printf(E_VERBOSE_NONE,"\n   Mode uses dual buffers");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not use dual buffers");
  if (modeInfo.Attributes&64)
   t_printf(E_VERBOSE_NONE,"\n   Mode supports a hardware cursor");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not support a hardware cursor");
  if (modeInfo.Attributes&128)
   t_printf(E_VERBOSE_NONE,"\n   Mode uses an 8 bit palette DAC");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode does not use an 8 bit palette DAC");
  if (modeInfo.Attributes&256)
   t_printf(E_VERBOSE_NONE,"\n   Mode is a NonVGA mode");
  else
   t_printf(E_VERBOSE_NONE,"\n   Mode is a VGA mode");
  if (modeInfo.Attributes&(8*4096))
   t_printf(E_VERBOSE_NONE,"\n   Flags info is for a VBE mode");
  else
   t_printf(E_VERBOSE_NONE,"\n   Flags info is not for a VBE mode");
  t_printf(E_VERBOSE_NONE,"\n   Bytes per horizontal scan line..: %i",modeInfo.BytesPerScanLine);
  t_printf(E_VERBOSE_NONE,"\n   Horizontal resolution in pixels.: %i",modeInfo.XResolution);
  t_printf(E_VERBOSE_NONE,"\n   Vertical resolution in pixels...: %i",modeInfo.YResolution);
  t_printf(E_VERBOSE_NONE,"\n   Bits per pixel..................: %i",modeInfo.BitsPerPixel);
  t_printf(E_VERBOSE_NONE,"\n   Total number of available pages.: %i",modeInfo.NumberOfPages);
  t_printf(E_VERBOSE_NONE,"\n   Size of direct color red mask...: %i",modeInfo.RedMaskSize);
  t_printf(E_VERBOSE_NONE,"\n   Bit posn of lsb of red mask.....: %i",modeInfo.RedFieldPosition);
  t_printf(E_VERBOSE_NONE,"\n   Size of direct color green mask.: %i",modeInfo.GreenMaskSize);
  t_printf(E_VERBOSE_NONE,"\n   Bit posn of lsb of green mask...: %i",modeInfo.GreenFieldPosition);
  t_printf(E_VERBOSE_NONE,"\n   Size of direct color blue mask..: %i",modeInfo.BlueMaskSize);
  t_printf(E_VERBOSE_NONE,"\n   Bit posn of lsb of blue mask....: %i",modeInfo.BlueFieldPosition);
 }
 T_DEBUG_LEAVE
 return vesa_error=fehler;
}

/***************************************************************/

T_INT vesa_alten_modus_speichern(T_VOID)
{
/* VESA Sicherung funktionier bei mir nicht !!! */
/* int wieviel_sicherungsspeicher; */
// initialised=T_TRUE;
 T_DEBUG_ENTRY("vesa_alten_modus_speichern",25)
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT vesa_alten_modus_setzen(T_VOID)
{
 T_DEBUG_ENTRY("vesa_alten_modus_setzen",25)
 if (initialised==T_TRUE)
 {
  vesa_mouse_deinit(); // knows if initialized by itself
  SV_restoreMode(); //works shitty

//  union _REGS regs;
//  regs.h.ah = 0x00;          // Set mode
//  regs.h.al = vesa_return_video;  // Mode
//  int386(VGA_BIOS, &regs, &regs);
//  vesa_return_video = -1;

  if (clip_memory)
  {
   free(clip_memory);
   clip_memory=NULL;
  }
 }
 initialised=T_FALSE;
 T_DEBUG_LEAVE
 vesa_modus_active=0;
 return T_OK;
}

/***************************************************************/

T_INT vesa_alten_modus_freigeben(T_VOID)
{
 T_DEBUG_ENTRY("vesa_alten_modus_freigeben",25)
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/
/* VESA MODI defined in vesa.h */
/* wie get info */
/* int vesa_existiert_modus(int modus) */
T_INT vesa_setze_modus(T_INT modus)
{
 union _REGS regs;
 T_UWORD mode=0;
 T_INT loop;
 T_DEBUG_ENTRY("vesa_setze_modus",25)
/****************/
/* INIT SVGALIB */
/****************/
 if (vesa_karte_da()!= T_OK)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_NO_SVGALIB)
  T_DEBUG_LEAVE
  return VESA_NO_SVGALIB;
 }
 if (vesa_return_video==-1)
 {
  regs.h.ah = 0x0f;
  int386(VGA_BIOS, &regs, &regs);
  vesa_return_video=regs.h.al;
 }
 /*******************************/
 /* Look for suitable Vesa Mode */
 /*******************************/
 /***************************************************/
 /* first check for Linear Framebuffer (VBE >= 2.0) */
 /***************************************************/
 if ((svdc->VBEVersion/256>=2)&&(vesa_force_bank==T_FALSE))
 {
  switch (modus)
  {
   case SVGA320X200:
   {
    mode=get_mode_on_specs(320,200,8,svHaveLinearBuffer);
    framebuffer=FB_LINEAR;
    break;
   }
   case SVGA640X480:
   {
    mode=get_mode_on_specs(640,480,8,svHaveLinearBuffer);
    framebuffer=FB_LINEAR;
    break;
   }
   case SVGA800X600:
   {
    mode=get_mode_on_specs(800,600,8,svHaveLinearBuffer);
    framebuffer=FB_LINEAR;
    break;
   }
   case SVGA1024X768:
   {
    mode=get_mode_on_specs(1024,768,8,svHaveLinearBuffer);
    framebuffer=FB_LINEAR;
    break;
   }
   case SVGA1280X1024:
   {
    mode=get_mode_on_specs(1280,1024,8,svHaveLinearBuffer);
    framebuffer=FB_LINEAR;
    break;
   }
   case SVGA1600X1200:
   {
    mode=get_mode_on_specs(1600,1200,8,svHaveLinearBuffer);
    framebuffer=FB_LINEAR;
    break;
   }
  }
 }
 if (mode==0)
 {
  if (vesa_force_bank==T_TRUE)
  {
   t_printf(E_VERBOSE_NONE,"\nForcing banked Framebuffer!");
  }
  else
   t_printf(E_VERBOSE_NONE,"\nNo Linear Framebuffer found, trying banked Framebuffer!");
 }
 else
 {
  t_printf(E_VERBOSE_LOW,"\nLinear Framebuffer Video Mode found: %04hx!\n",mode);
  if (SV_setMode(mode|svLinearBuffer,T_FALSE,T_FALSE,0)==T_FALSE)
  {
   t_printf(E_VERBOSE_LOW,"\nCouldn't set Linear Framebuffer Video Mode (%04hx), trying banked now!\n",mode);
   framebuffer=FB_NONE;
   mode=0;
  }
 }
 /*********************************************/
 /* check for Banked Framebuffer (VBE >= 1.0) */
 /*********************************************/
 if (mode==0) /* only if no mode found yet */
 {
  switch (modus)
  {
   case SVGA320X200:
   {
    mode=get_mode_on_specs(320,200,8,0);
    framebuffer=FB_BANKED;
    break;
   }
   case SVGA640X480:
   {
    mode=get_mode_on_specs(640,480,8,0);
    framebuffer=FB_BANKED;
    break;
   }
   case SVGA800X600:
   {
    mode=get_mode_on_specs(800,600,8,0);
    framebuffer=FB_BANKED;
    break;
   }
   case SVGA1024X768:
   {
    mode=get_mode_on_specs(1024,768,8,0);
    framebuffer=FB_BANKED;
    break;
   }
   case SVGA1280X1024:
   {
    mode=get_mode_on_specs(1280,1024,8,0);
    framebuffer=FB_BANKED;
    break;
   }
   case SVGA1600X1200:
   {
    mode=get_mode_on_specs(1600,1200,8,0);
    framebuffer=FB_BANKED;
    break;
   }
  }
 }
 if (mode==0)
 {
  vesa_return_video=-1;
  t_printf(E_VERBOSE_NONE,"\nvesa-set - corresponding VESA mode not found!!!");
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_NO_VESA_MODE_FOUND)
  T_DEBUG_LEAVE
  return VESA_NO_VESA_MODE_FOUND;
 }
 else if (framebuffer==FB_BANKED)
 {
  t_printf(E_VERBOSE_LOW,"\nBanked Framebuffer Video Mode found: %04hx!\n",mode);
  if (SV_setMode(mode,T_FALSE,T_FALSE,0)==T_FALSE)
  {
   vesa_return_video=-1;
   t_printf(E_VERBOSE_NONE,"\nvesa-set - Failed to set VESA Banked Framebuffer Video mode %03x",mode);
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_FAILED_SET_BANKED)
   T_DEBUG_LEAVE
   return VESA_FAILED_SET_BANKED;
  }
 }
 if (framebuffer==FB_BANKED)
 {
  /*
  funktionen init
  */
  vesa_init_modus_infos(mode);

  vesa_plot256=vesa_plot256_ban;
  vesa_plot256_oc=vesa_plot256_oc_ban;

  vesa_get_pixel=vesa_get_pixel_ban;
  vesa_get_pixel_oc=vesa_get_pixel_oc_ban;

  vesa_print_zeile256=vesa_print_zeile256_ban;
  vesa_print_zeile256_oc=vesa_print_zeile256_oc_ban;
  vesa_print_zeile256_oc_raw=vesa_print_zeile256_oc_raw_ban;

  vesa_get_zeile=vesa_get_zeile_ban;
  vesa_get_zeile_oc=vesa_get_zeile_oc_ban;
  vesa_print_string_max=vesa_print_string_max_ban;
  vesa_print_string_max_oc=vesa_print_string_max_oc_ban;
  vesa_mouse_schreiben=vesa_mouse_schreiben_ban;
  vesa_mouse_hintergrund_schreiben=vesa_mouse_hintergrund_schreiben_ban;
  vesa_mouse_hintergrund_sichern=vesa_mouse_hintergrund_sichern_ban;
  vesa_draw_line=vesa_draw_line_ban;
  vesa_draw_line_aa=vesa_draw_line_aa_ban;
 }
 else if (framebuffer==FB_LINEAR)
 {
  /*
  funktionen init
  */
  vesa_plot256=vesa_plot256_lin;
  vesa_plot256_oc=vesa_plot256_oc_lin;
  vesa_get_pixel=vesa_get_pixel_lin;
  vesa_get_pixel_oc=vesa_get_pixel_oc_lin;
  vesa_print_zeile256=vesa_print_zeile256_lin;
  vesa_print_zeile256_oc=vesa_print_zeile256_oc_lin;
  vesa_print_zeile256_oc_raw=vesa_print_zeile256_oc_raw_lin;
  vesa_get_zeile=vesa_get_zeile_lin;
  vesa_get_zeile_oc=vesa_get_zeile_oc_lin;
  vesa_print_string_max=vesa_print_string_max_lin;
  vesa_print_string_max_oc=vesa_print_string_max_oc_lin;
  vesa_mouse_schreiben=vesa_mouse_schreiben_lin;
  vesa_mouse_hintergrund_schreiben=vesa_mouse_hintergrund_schreiben_lin;
  vesa_mouse_hintergrund_sichern=vesa_mouse_hintergrund_sichern_lin;
  vesa_draw_line=vesa_draw_line_lin;
  vesa_draw_line_aa=vesa_draw_line_aa_lin;
 }
 else
 {
  vesa_return_video=-1;
  t_printf(E_VERBOSE_NONE,"\nvesa-set - Unkown VESA initialization ERROR!");
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_UNKNOWN_VESA_ERROR)
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return VESA_UNKNOWN_VESA_ERROR;
 }
/*

// Function 08h       - Set/Get DAC Palette Format This required function
//                      manipulates the operating mode or format of the DAC palette.
//                      Some DACs are configurable to provide 6 bits, 8 bits, or more of
// Input:   AX= 4F08h - VBE Set/Get Palette Format
//          BL = 00h  - Set DAC Palette Format
//               01h  - Get DAC Palette Format
//          BH = ??h  - Desired bits of color per primary
//                      (Set DAC Palette Format only)
// Output:  AX =      - VBE Return Status (AH == 00h:Function call successful)
//          BH =      - Current number of bits of color per primary

    regs.w.ax = 0x4f08;
    regs.w.bx = 0x0001; // get dac bits
    regs.w.cx = 0;
    int386(0x10,&regs,&regs);
    if ((regs.w.ax&0x00ff) != 0x4f)
    {
     t_printf(E_VERBOSE_NONE,"\nGet VESA function 8 not, available using 6 bit dac...");
     vesa_dac_depth=6;
    }
    else
    {
     if (((regs.w.bx&0xff00)>>8)==8)
     {
      t_printf(E_VERBOSE_NONE,"\nVESA function 08 called, dac is set to 8 bit");
     }
     else if (((regs.w.bx&0xff00)>>8)==6)
     {
      t_printf(E_VERBOSE_NONE,"\nVESA function 08 called, dac is set to 6 bit");
     }
     else
     {
      t_printf(E_VERBOSE_NONE,"\nNot supported DAC depth, %i",((regs.w.bx&0xff00)>>8));
     }
     regs.w.ax = 0x4f08;
     regs.w.bx = 0x0600; // set 6 bit
     regs.w.cx = 0;
     int386(0x10,&regs,&regs);
t_printf(E_VERBOSE_NONE,"\nVESA function 08 available");
     if ((regs.w.ax&0xffff) != 0x4f)
     {
      t_printf(E_VERBOSE_NONE,"\nSet VESA DAC depth failed...");
      T_DEBUG_FUNCTION_POSITION(3)
      T_DEBUG_LEAVE
      tool_exit(0);
     }
t_printf(E_VERBOSE_NONE,"\nVESA function 08 called, dac set to 6 bit");
     regs.w.ax = 0x4f08;
     regs.w.bx = 0x0001; // get 6 bit
     regs.w.cx = 0;
     int386(0x10,&regs,&regs);
     if (((regs.w.bx&0xff00)>>8)==8)
     {
t_printf(E_VERBOSE_NONE,"\nVESA function 08 called, dac is set to 8 bit");
      vesa_dac_depth=8;
     }
     else if (((regs.w.bx&0xff00)>>8)==6)
     {
t_printf(E_VERBOSE_NONE,"\nVESA function 08 called, dac is set to 6 bit");
      vesa_dac_depth=6;
     }
     else
     {
      t_printf(E_VERBOSE_NONE,"\nNot supported DAC depth, %i",((regs.w.bx&0xff00)>>8));
      T_DEBUG_FUNCTION_POSITION(4)
      T_DEBUG_LEAVE
      tool_exit(0);
     }
    }

*/

/*******************************************/
/* Setup the array of line start positions */
/* 65536, since a negative line positions  */
/* possible (slight speedup)               */
/*******************************************/
 for (loop=0;loop<MAX_ZEILEN_LEN;loop++)
 {
  linestartpos[(T_UWORD)loop]=loop*vesa_bytes_per_scanline;//vesa_x;
 }
 if ((clip_memory=malloc(vesa_bytes_per_scanline*vesa_y))==NULL)
 {
  vesa_return_video=-1;
  t_printf(E_VERBOSE_NONE,"\nNo memory for clipping area!");
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_UNKNOWN_VESA_ERROR)
  T_DEBUG_FUNCTION_POSITION(5)
  T_DEBUG_LEAVE
  return VESA_UNKNOWN_VESA_ERROR;
 }
 memset(clip_memory,1,vesa_bytes_per_scanline*vesa_y); /* clip all */
 initialised=T_TRUE;
 vesa_modus_active=mode;
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_VOID vesa_plot256_oc_lin(T_UWORD x,T_UWORD y, T_UWORD color)
{
 /*******************************************/
 /* Calulate byte position + Write the byte */
 /*******************************************/
 T_DEBUG_ENTRY("vesa_plot256_oc_lin",25)
 *(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x)=(T_UCHAR)color;
 T_DEBUG_LEAVE
}

T_VOID vesa_plot256_lin(T_UWORD x,T_UWORD y, T_UWORD color)
{
 /*******************************************/
 /* Calulate byte position + Write the byte */
 /*******************************************/
 T_DEBUG_ENTRY("vesa_plot256_lin",25)
// MOUSE_VERSTECKE
 vesa_mouse_verstecke_cursor(x,y,x+1,y+1);
 *(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x)=(T_UCHAR)color;
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x,y,x+1,y+1);
 T_DEBUG_LEAVE
}

T_VOID vesa_plot256_ban(T_UWORD x,T_UWORD y,T_UWORD color)
{
 T_DEBUG_ENTRY("vesa_plot256_ban",25)
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_UWORD)(offset&vesa_and_x);
// MOUSE_VERSTECKE
 vesa_mouse_verstecke_cursor(x,y,x+1,y+1);
 if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=new_win_address;
  vesa_set_write_window();
 }
 *((T_UCHAR*)(vesa_write_seg+offset_x))=(T_UCHAR)color;
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x,y,x+1,y+1);
 T_DEBUG_LEAVE
}

T_VOID vesa_plot256_oc_ban(T_UWORD x,T_UWORD y,T_UWORD color)
{
 T_DEBUG_ENTRY("vesa_plot256_oc_ban",25)
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_UWORD)(offset&vesa_and_x);
 if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=new_win_address;
  vesa_set_write_window();
 }
 *((T_UCHAR*)(vesa_write_seg+offset_x))=(T_UCHAR)color;
 T_DEBUG_LEAVE
}

T_UCHAR vesa_get_pixel_oc_lin(T_UWORD x,T_UWORD y)
{
 /*******************************************/
 /* Calulate byte position + Read the byte */
 /*******************************************/
 T_DEBUG_ENTRY("vesa_get_pixel_oc_lin",25)
 T_DEBUG_LEAVE
 return (*(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x));
}
T_UCHAR vesa_get_pixel_lin(T_UWORD x,T_UWORD y)
{
 /*******************************************/
 /* Calulate byte position + Read the byte */
 /*******************************************/
 T_UCHAR h;
 T_DEBUG_ENTRY("vesa_get_pixel_lin",25)
 T_DEBUG_LEAVE
// MOUSE_VERSTECKE
 vesa_mouse_verstecke_cursor(x,y,x+1,y+1);
 h=(*(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x));
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x,y,x+1,y+1);
 return h;
}

T_UCHAR vesa_get_pixel_oc_ban(T_UWORD x, T_UWORD y)
{
 /*******************************************/
 /* Calulate byte position + Read the byte */
 /*******************************************/
 T_DEBUG_ENTRY("vesa_get_pixel_oc_ban",25)
 offset=((T_ULONG)x)+linestartpos[(T_UWORD )y];
 offset_x=(T_UWORD )(offset&vesa_and_x);
 if (vesa_address_of_window[vesa_read_window]!=(new_win_address=(T_UWORD )(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_read_window]=new_win_address;
  vesa_set_read_window();
 }
 T_DEBUG_LEAVE
 return (*((T_PUCHAR )(vesa_read_seg+offset_x)));
}

T_UCHAR vesa_get_pixel_ban(T_UWORD x, T_UWORD y)
{
 /*******************************************/
 /* Calulate byte position + Read the byte */
 /*******************************************/
 T_UCHAR h;
 T_DEBUG_ENTRY("vesa_get_pixel_ban",25)
 offset=((T_ULONG)x)+linestartpos[(T_UWORD )y];
 offset_x=(T_UWORD )(offset&vesa_and_x);
// MOUSE_VERSTECKE

 vesa_mouse_verstecke_cursor(x,y,x+1,y+1);
 if (vesa_address_of_window[vesa_read_window]!=(new_win_address=(T_UWORD )(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_read_window]=new_win_address;
  vesa_set_read_window();
 }
 h=(*((T_PUCHAR )(vesa_read_seg+offset_x)));
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x,y,x+1,y+1);
 T_DEBUG_LEAVE
 return h;
}

T_INT vesa_load_font(T_PCHAR dateiname,T_FONT *ein_font)
{
 FILE *handle=NULL;
 T_INT i;
 T_INT zaehler;
 T_PUCHAR zeiger=NULL;
 T_INT x,y;
 T_DEBUG_ENTRY("vesa_load_font",25)
 if ((handle = fopen(dateiname,"rb")) == NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return FILE_OPEN_ERROR;
 }
 fread(&ein_font->hintergrundfarbe,sizeof(T_WORD),1,handle);
 for (i=0;i<256;i++)
 {
  fread(&ein_font->zeichen[i].breite,sizeof(T_WORD),1,handle);
  fread(&ein_font->zeichen[i].hoehe,sizeof(T_WORD),1,handle);
  fread(&ein_font->zeichen[i].null,sizeof(T_WORD),1,handle);
  if (ein_font->zeichen[i].breite)
  {
   if ((zeiger=(T_PUCHAR )malloc(ein_font->zeichen[i].breite*ein_font->zeichen[i].hoehe))==NULL)
   {
    fclose(handle);
    for (i=0;i<256;i++)
    {
     if (ein_font->zeichen[i].zeiger!=NULL)
      free (ein_font->zeichen[i].zeiger);
    }
    T_DEBUG_FUNCTION_POSITION(2)
    T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
    T_DEBUG_LEAVE
    return GENERIC_MEMORY_NOT_AVAILABLE;
   }
   zaehler=0;
   for (y=0;y<ein_font->zeichen[i].hoehe;y++)
   {
     for (x=0;x<ein_font->zeichen[i].breite;x++)
     {
      fread((zeiger+zaehler),1,sizeof(T_BYTE),handle);
      zaehler++;
     }
    }
  }
  else
  {
   zeiger=NULL;
   ein_font->zeichen[i].breite=0;
   ein_font->zeichen[i].hoehe=0;
   ein_font->zeichen[i].null=0;
  }
  ein_font->zeichen[i].zeiger=zeiger;
 }
 fclose(handle);
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT vesa_free_font(T_FONT *ein_font)
{
 T_INT i;
 T_DEBUG_ENTRY("vesa_free_font",25)
 for (i=0;i<256;i++)
 {
  if (ein_font->zeichen[i].breite)
  {
   if (ein_font->zeichen[i].zeiger)
   {
    free(ein_font->zeichen[i].zeiger);
    ein_font->zeichen[i].zeiger=NULL;
   }
  }
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT vesa_print_int(T_INT x, T_INT y, T_LONG zahl)
{
 T_INT i=0;
 T_CHAR string[80];
 T_DEBUG_ENTRY("vesa_print_int",25)
 ltoa(zahl,string,10);
 while (string[i]!=0)
 {
  vesa_print_char(x,y,string[i]);
  x+=font_now->zeichen[string[i++]].breite;
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT vesa_get_text_len(T_PCHAR text, T_INT *len_x, T_INT *len_y)
{
 static T_INT zaehler=0;
 static EIN_ZEICHEN *z;
 register T_BYTE _char;
 T_DEBUG_ENTRY("vesa_get_text_len",25)
 *len_x=0;
 *len_y=0;
 z=&(font_now->zeichen[_char=text[zaehler=0]]);
 while ((T_BYTE)_char!=(T_BYTE)0)
 {
  *len_x += z->breite;
  if (z->hoehe > *len_y)
   *len_y = z->hoehe;
  z=&font_now->zeichen[(_char=(T_BYTE)text[++zaehler])];
 }
 T_DEBUG_LEAVE
 return zaehler;
}

T_INT vesa_print_string_max_ban(T_INT o_x, T_INT o_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string)
{
// zeilen von anfang an fuellen, entweder mit back werten oder mit einer
// kompletten zeile aus
// dem video ram, geht dann insgesamt vielleicht noch schhneller
 T_ULONG offset;
 T_ULONG offset_neu;
 T_UINT offset_x;
 T_INT i=0;
 T_INT breite,hoehe;
 T_INT zeilen_zaehler=o_y;
 T_INT neue_seg_adresse;
 T_INT adder;
 T_PUCHAR zeiger_source;
 T_PUCHAR zeiger_dest;
 T_UCHAR zeichen;
 T_DEBUG_ENTRY("vesa_print_string_max_ban",25)
 if (len_x<0)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 MOUSE_VERSTECKE
 vesa_mouse_interrupt++;
 if (o_x)
 {
  T_INT lenny=_MIN_(font_now->zeichen[*string].hoehe,len_y);
  while ((o_x-font_now->zeichen[*string].breite>=0)&&(*string))
  {
   o_x-=font_now->zeichen[*string].breite;
   string++;
  }
  if (o_x)
  {
/////////////////////////////////////////

 adder=(vesa_bytes_per_scanline-(font_now->zeichen[*string].breite-o_x));

/*** Erstmal auf jeden Fall die Startadresse setzen ***/
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_INT)(offset&vesa_and_x);
 if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
  vesa_set_write_window();
 }
 if (vesa_text==SINGLE_COLOR)
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+(font_now->zeichen[*string].breite-o_x);
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;

     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
       {
        *zeiger_dest++ = vesa_text_color;
       }
       else
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
//1

   else // also nicht alles in einem Rutsch
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+(font_now->zeichen[*string].breite-o_x);
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      T_INT copy_breite=0;
      // aber diese Zeile in einem Rutsch
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;

       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       } // zeichen breite (clipped)
      } // existiert font zeiger
      zeilen_zaehler++;
//      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } // zeile in einem Rutsch
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      T_INT copy_breite=0;
      y-=o_y;
      // diese Zeile nher untersuchen auf offset umbruch
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_text_color);
        }
        else
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_back_color);
        }
       } // zeichen breite (clipped)
      } // existiert font zeieger
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } // <else> <end> zeile in einem Rutsch
    } // hoehen schleife
   } // alles in einem Rutsch <else> <end>

  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+font_now->zeichen[*string].breite-o_x;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        *zeiger_dest++ = vesa_text_color;
       else
        zeiger_dest++;
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+font_now->zeichen[*string].breite-o_x;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      T_INT copy_breite=0;
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
         zeiger_dest++;
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      T_INT copy_breite=0;
      y-=o_y;
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
       {
        zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_text_color);
         }
        } /* zeichen breite (clipped) */
       } /* ist aktuelle hoehe korrekt */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
 }
 else // also multicolor
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+font_now->zeichen[*string].breite-o_x;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
       {
        *zeiger_dest++ = *(zeiger_source+i);
       }
       else
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+font_now->zeichen[*string].breite-o_x;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      T_INT copy_breite=0;
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      T_INT copy_breite=0;
      y-=o_y;
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,*(zeiger_source+i));
        }
        else
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_back_color);
        }
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+font_now->zeichen[*string].breite-o_x;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        *zeiger_dest++ = *(zeiger_source+i);
       else
        zeiger_dest++;
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+font_now->zeichen[*string].breite-o_x;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      T_INT copy_breite=0;
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
         zeiger_dest++;
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      T_INT copy_breite=0;
      y-=o_y;
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
       {
        zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          vesa_plot256_oc(x+i,y+zeilen_zaehler,*(zeiger_source+i));
         }
        } /* zeichen breite (clipped) */
       } /* ist aktuelle hoehe korrekt */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  }
 }
/////////////////////////////////////////
   zeilen_zaehler=o_y;
   x+=font_now->zeichen[*string].breite-o_x;
   len_x-=(font_now->zeichen[*string].breite-o_x);
   string++;
  } //if (o_x)
  if (*string==(T_CHAR)0)
  {
   vesa_mouse_interrupt--;
   MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return 0;
  }
 } // if (o_x)
 vesa_get_text_len(string, &breite, &hoehe);
 if (breite>len_x)
  breite=len_x;
 if (hoehe>len_y)
  hoehe=len_y;
 adder=(vesa_bytes_per_scanline-breite); //(vesa_x-breite);

/*** Erstmal auf jeden Fall die Startadresse setzen ***/
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_INT)(offset&vesa_and_x);
 if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
  vesa_set_write_window();
 }
 if (vesa_text==SINGLE_COLOR)
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        for (i=0;i<copy_breite;i++)
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          *zeiger_dest++ = vesa_text_color;
         }
         else
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
       }
      }
      else
      {
      ;//     zeiger_dest;
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
//1
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = vesa_text_color;
          }
          else
          {
           *zeiger_dest++ = vesa_back_color;
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_text_color);
          }
          else
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      y+=o_y;
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        zeiger_dest += copy_breite;
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          *zeiger_dest++ = vesa_text_color;
         else
          zeiger_dest++;
        }
       }
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         zeiger_dest+=copy_breite;
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = vesa_text_color;
          }
          else
           zeiger_dest++;
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_text_color);
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
 }
 else // also multicolor
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        for (i=0;i<copy_breite;i++)
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          *zeiger_dest++ = *(zeiger_source+i);
         }
         else
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
       }
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = *(zeiger_source+i);
          }
          else
          {
           *zeiger_dest++ = vesa_back_color;
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,*(zeiger_source+i));
          }
          else
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        zeiger_dest += copy_breite;
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          *zeiger_dest++ = *(zeiger_source+i);
         else
          zeiger_dest++;
        }
       }
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         zeiger_dest+=copy_breite;
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = *(zeiger_source+i);
          }
          else
           zeiger_dest++;
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,*(zeiger_source+i));
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  }
 }
 vesa_mouse_interrupt--;
 MOUSE_ZEIGE
 T_DEBUG_LEAVE
 return T_OK;
}
// breite zahelt nur fuer den auszugebenden Teil des strings
// hoehe zaehlt MIT dem versteckten Teil
T_INT vesa_print_string_max_lin(T_INT o_x, T_INT o_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string)
{
 T_INT i=0;
 T_INT breite,hoehe;
 T_INT zeilen_zaehler=o_y;
 T_INT adder;
 T_PUCHAR zeiger_source;
 T_PUCHAR zeiger_dest;
 T_UCHAR zeichen;
 T_DEBUG_ENTRY("vesa_print_string_max_lin",25)

 // bis auf ein zeichen antasten, dann offset im ersten zeichen.
 if (len_x<0)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 if (o_y-font_now->zeichen[*string].hoehe>=0)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return 0;
 }
MOUSE_VERSTECKE
 vesa_mouse_interrupt++;

 if (o_x)
 {
  T_INT lenny=_MIN_(font_now->zeichen[*string].hoehe,len_y);
  while ((o_x-font_now->zeichen[*string].breite>=0)&&(*string))
  {
   o_x-=font_now->zeichen[*string].breite;
   string++;
  }
  if (o_x)
  {
   adder=(vesa_bytes_per_scanline-(font_now->zeichen[*string].breite-o_x));
   if (vesa_text==SINGLE_COLOR)
   {
    if (vesa_print_modus==PIC_FILLED)
    {
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    } /* vesa print modus */
    else
    {  /* also jetzt in PIC ON BACK */
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = vesa_text_color;
        else
         zeiger_dest++;
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    } /* vesa print modus */
   }
   else // also multicolor
   {
    if (vesa_print_modus==PIC_FILLED)
    {
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    } /* vesa print modus */
    else
    {  /* also jetzt in PIC ON BACK */
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = *(zeiger_source+i);
        else
         zeiger_dest++;
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    }
   } // else if (vesa_text==SINGLE_COLOR)

   zeilen_zaehler=o_y;
   x+=font_now->zeichen[*string].breite-o_x;
   len_x-=font_now->zeichen[*string].breite-o_x;
   string++;
  } //if (o_x)
  if (*string==(T_CHAR)0)
  {
   vesa_mouse_interrupt--;
   MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return 0;
  }
 } // if (o_x)



 vesa_get_text_len(string, &breite, &hoehe);
 if (breite>len_x)
  breite=len_x;
 if (hoehe>len_y)
  hoehe=len_y;

 adder=(vesa_bytes_per_scanline-breite);//(vesa_x-breite);
 if (vesa_text==SINGLE_COLOR)
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   /* alles in einem Rutsch, den ganzen STRING !!! */
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       for (i=0;i<copy_breite;i++)
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       zeiger_dest += copy_breite;
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = vesa_text_color;
        else
         zeiger_dest++;
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  } /* vesa print modus */
 }
 else // also multicolor
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       for (i=0;i<copy_breite;i++)
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       zeiger_dest += copy_breite;
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = *(zeiger_source+i);
        else
         zeiger_dest++;
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  }
 } //if (vesa_text==SINGLE_COLOR)
 vesa_mouse_interrupt--;
 MOUSE_ZEIGE
 T_DEBUG_LEAVE
 return 0;
}

T_INT vesa_print_string_max_oc_ban(T_INT o_x, T_INT o_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string)
{
// zeilen von anfang an fuellen, entweder mit back werten oder mit einer kompletten zeile aus
// dem video ram, geht dann insgesamt vielleicht noch schhneller
 T_ULONG offset;
 T_ULONG offset_neu;
 T_UINT offset_x;
 T_INT i=0;
 T_INT breite,hoehe;
 T_INT zeilen_zaehler=o_y;
 T_INT neue_seg_adresse;
 T_INT adder;
 T_PUCHAR zeiger_source;
 T_PUCHAR zeiger_dest;
 T_UCHAR zeichen;
 T_DEBUG_ENTRY("vesa_print_string_max_oc_ban",25)
 if (len_x<0)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 if (o_x)
 {
  T_INT lenny=_MIN_(font_now->zeichen[*string].hoehe,len_y);
  while ((o_x-font_now->zeichen[*string].breite>=0)&&(*string))
  {
   o_x-=font_now->zeichen[*string].breite;
   string++;
  }
  if (o_x)
  {
/////////////////////////////////////////

 adder=(vesa_bytes_per_scanline-(font_now->zeichen[*string].breite-o_x));

/*** Erstmal auf jeden Fall die Startadresse setzen ***/
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_INT)(offset&vesa_and_x);
 if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
  vesa_set_write_window();
 }
 if (vesa_text==SINGLE_COLOR)
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+(font_now->zeichen[*string].breite-o_x);
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;

     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
       {
        *zeiger_dest++ = vesa_text_color;
       }
       else
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
//1
   else // also nicht alles in einem Rutsch
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+(font_now->zeichen[*string].breite-o_x);
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      T_INT copy_breite=0;
      // aber diese Zeile in einem Rutsch
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;

       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       } // zeichen breite (clipped)
      } // existiert font zeiger
      zeilen_zaehler++;
//      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } // zeile in einem Rutsch
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      T_INT copy_breite=0;
      y-=o_y;
      // diese Zeile nher untersuchen auf offset umbruch
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_text_color);
        }
        else
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_back_color);
        }
       } // zeichen breite (clipped)
      } // existiert font zeieger
      zeilen_zaehler++;
//      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } // <else> <end> zeile in einem Rutsch
    } // hoehen schleife
   } // alles in einem Rutsch <else> <end>

  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+font_now->zeichen[*string].breite-o_x;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        *zeiger_dest++ = vesa_text_color;
       else
        zeiger_dest++;
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+font_now->zeichen[*string].breite-o_x;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      T_INT copy_breite=0;
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
         zeiger_dest++;
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      T_INT copy_breite=0;
      y-=o_y;
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
       {
        zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_text_color);
         }
        } /* zeichen breite (clipped) */
       } /* ist aktuelle hoehe korrekt */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
 }
 else // also multicolor
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+font_now->zeichen[*string].breite-o_x;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
       {
        *zeiger_dest++ = *(zeiger_source+i);
       }
       else
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+font_now->zeichen[*string].breite-o_x;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      T_INT copy_breite=0;
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      T_INT copy_breite=0;
      y-=o_y;
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,*(zeiger_source+i));
        }
        else
        {
         vesa_plot256_oc(x+i,y+zeilen_zaehler,vesa_back_color);
        }
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+font_now->zeichen[*string].hoehe)*vesa_bytes_per_scanline+font_now->zeichen[*string].breite-o_x;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     T_INT copy_breite=0;
     zeichen=(T_UCHAR)*string;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      zeichen_breite=font_now->zeichen[zeichen].breite;
      copy_breite=zeichen_breite-o_x;
      zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
      for (i=0;i<copy_breite;i++)
      {
       if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        *zeiger_dest++ = *(zeiger_source+i);
       else
        zeiger_dest++;
      }
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<lenny)
    {
     T_INT zeichen_breite;
     offset_neu=offset+font_now->zeichen[*string].breite-o_x;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      T_INT copy_breite=0;
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
         zeiger_dest++;
       } /* zeichen breite (clipped) */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      T_INT copy_breite=0;
      y-=o_y;
      zeichen=(T_UCHAR)*string;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
       {
        zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          vesa_plot256_oc(x+i,y+zeilen_zaehler,*(zeiger_source+i));
         }
        } /* zeichen breite (clipped) */
       } /* ist aktuelle hoehe korrekt */
      } /* existiert font zeieger */
      zeilen_zaehler++;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  }
 }
/////////////////////////////////////////
   zeilen_zaehler=o_y;
   x+=font_now->zeichen[*string].breite-o_x;
   len_x-=(font_now->zeichen[*string].breite-o_x);
   string++;
  } //if (o_x)
  if (*string==(T_CHAR)0)
  {
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return 0;
  }
 } // if (o_x)
 vesa_get_text_len(string, &breite, &hoehe);
 if (breite>len_x)
  breite=len_x;
 if (hoehe>len_y)
  hoehe=len_y;
 adder=(vesa_bytes_per_scanline-breite); //(vesa_x-breite);
/*** Erstmal auf jeden Fall die Startadresse setzen ***/
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_INT)(offset&vesa_and_x);
 if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
  vesa_set_write_window();
 }
 if (vesa_text==SINGLE_COLOR)
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        for (i=0;i<copy_breite;i++)
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          *zeiger_dest++ = vesa_text_color;
         }
         else
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
       }
      }
      else
      {
      ;//     zeiger_dest;
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
//1
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = vesa_text_color;
          }
          else
          {
           *zeiger_dest++ = vesa_back_color;
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeiger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_text_color);
          }
          else
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        zeiger_dest += copy_breite;
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          *zeiger_dest++ = vesa_text_color;
         else
          zeiger_dest++;
        }
       }
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         zeiger_dest+=copy_breite;
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = vesa_text_color;
          }
          else
           zeiger_dest++;
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_text_color);
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
 }
 else // also multicolor
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        for (i=0;i<copy_breite;i++)
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         {
          *zeiger_dest++ = *(zeiger_source+i);
         }
         else
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
       }
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          *zeiger_dest++ = vesa_back_color;
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = *(zeiger_source+i);
          }
          else
          {
           *zeiger_dest++ = vesa_back_color;
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         for (i=0;i<copy_breite;i++)
         {
          vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
         }
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,*(zeiger_source+i));
          }
          else
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,vesa_back_color);
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   offset_neu=x+(T_LONG)(y+hoehe)*vesa_bytes_per_scanline+breite;//vesa_x+breite;
   if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
   {
    /* alles in einem Rutsch, den ganzen STRING !!! */
    offset_x=(T_INT)(offset&vesa_and_x);
    zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_INT position=0;
     T_INT zeichen_breite;
     while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
     {
      T_INT copy_breite=0;
      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
       if ((position+zeichen_breite)>breite)
        copy_breite=breite-position;
       else
        copy_breite=zeichen_breite;
       if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
       {
        zeiger_dest += copy_breite;
       }
       else
       {
        zeiger_source += zeilen_zaehler * zeichen_breite;
        for (i=0;i<copy_breite;i++)
        {
         if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          *zeiger_dest++ = *(zeiger_source+i);
         else
          zeiger_dest++;
        }
       }
      }
      position+=copy_breite;
      buchstabe++;
     }
     zeilen_zaehler++;
     zeiger_dest+=adder;
    }
   }
   else /* also nicht alles in einem Rutsch */
   {
    while (zeilen_zaehler<hoehe)
    {
     T_INT buchstabe=0;
     T_UINT position=0;
     T_INT zeichen_breite;
     offset_neu=offset+breite;
     if (vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
     {
      /* aber diese Zeile in einem Rutsch */
      offset_x=(T_INT)(offset&vesa_and_x);
      zeiger_dest=(T_PUCHAR )(vesa_write_seg+offset_x);
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
        {
         zeiger_dest+=copy_breite;
        }
        else
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           *zeiger_dest++ = *(zeiger_source+i);
          }
          else
           zeiger_dest++;
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
     } /* zeile in einem Rutsch */
     else //(vesa_address_of_window[vesa_write_window]==(offset_neu>>vesa_granularity_potenz))
//2 end
     {
      /* diese Zeile nher untersuchen auf offset umbruch */
      y-=o_y;
      while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
      {
       T_INT copy_breite=0;
       if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
       {
        copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
        if ((position+zeichen_breite)>breite)
         copy_breite=breite-position;
        else
         copy_breite=zeichen_breite;
        if (!(zeilen_zaehler>font_now->zeichen[zeichen].hoehe))
        {
         zeiger_source += zeilen_zaehler * zeichen_breite;
         for (i=0;i<copy_breite;i++)
         {
          if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
          {
           vesa_plot256_oc(x+position+i,y+zeilen_zaehler,*(zeiger_source+i));
          }
         } /* zeichen breite (clipped) */
        } /* ist aktuelle hoehe korrekt */
       } /* existiert font zeieger */
       position+=copy_breite;
       buchstabe++;
      } /* zeilen breiten schleife */
      zeilen_zaehler++;
      zeiger_dest+=adder;
      offset+=vesa_bytes_per_scanline;//vesa_x;
      y+=o_y;
     } /* <else> <end> zeile in einem Rutsch */
    } /* hoehen schleife */
   } /* alles in einem Rutsch <else> <end> */
  }
 }
 T_DEBUG_LEAVE
 return T_OK;
}
// breite zahelt nur fuer den auszugebenden Teil des strings
// hoehe zaehlt MIT dem versteckten Teil
T_INT vesa_print_string_max_oc_lin(T_INT o_x, T_INT o_y, T_INT x, T_INT y,T_INT len_x, T_INT len_y, T_PCHAR string)
{
 T_INT i=0;
 T_INT breite,hoehe;
 T_INT zeilen_zaehler=o_y;
 T_INT adder;
 T_PUCHAR zeiger_source;
 T_PUCHAR zeiger_dest;
 T_UCHAR zeichen;
 T_DEBUG_ENTRY("vesa_print_string_max_oc_lin",25)

 // bis auf ein zeichen antasten, dann offset im ersten zeichen.
 if (len_x<0)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 0;
 }
 if (o_y-font_now->zeichen[*string].hoehe>=0)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return 0;
 }
 if (o_x)
 {
  T_INT lenny=_MIN_(font_now->zeichen[*string].hoehe,len_y);
  while ((o_x-font_now->zeichen[*string].breite>=0)&&(*string))
  {
   o_x-=font_now->zeichen[*string].breite;
   string++;
  }
  if (o_x)
  {
   adder=(vesa_bytes_per_scanline-(font_now->zeichen[*string].breite-o_x));
   if (vesa_text==SINGLE_COLOR)
   {
    if (vesa_print_modus==PIC_FILLED)
    {
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    } /* vesa print modus */
    else
    {  /* also jetzt in PIC ON BACK */
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = vesa_text_color;
        else
         zeiger_dest++;
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    } /* vesa print modus */
   }
   else // also multicolor
   {
    if (vesa_print_modus==PIC_FILLED)
    {
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    } /* vesa print modus */
    else
    {  /* also jetzt in PIC ON BACK */
     zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
     while (zeilen_zaehler<lenny)
     {
      T_INT zeichen_breite;
      T_INT copy_breite=0;
      zeichen=(T_UCHAR)*string;

      if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
      {
       zeichen_breite=font_now->zeichen[zeichen].breite;
       copy_breite=zeichen_breite-o_x;
       zeiger_source += zeilen_zaehler * zeichen_breite+o_x;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = *(zeiger_source+i);
        else
         zeiger_dest++;
       }
      }
      zeilen_zaehler++;
      zeiger_dest+=adder;
     }
    }
   } // else if (vesa_text==SINGLE_COLOR)

   zeilen_zaehler=o_y;
   x+=font_now->zeichen[*string].breite-o_x;
   len_x-=font_now->zeichen[*string].breite-o_x;
   string++;
  } //if (o_x)
  if (*string==(T_CHAR)0)
  {
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return 0;
  }
 } // if (o_x)
 vesa_get_text_len(string, &breite, &hoehe);
 if (breite>len_x)
  breite=len_x;
 if (hoehe>len_y)
  hoehe=len_y;

 adder=(vesa_bytes_per_scanline-breite);//(vesa_x-breite);
 if (vesa_text==SINGLE_COLOR)
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   /* alles in einem Rutsch, den ganzen STRING !!! */
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       for (i=0;i<copy_breite;i++)
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = vesa_text_color;
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       zeiger_dest += copy_breite;
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = vesa_text_color;
        else
         zeiger_dest++;
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  } /* vesa print modus */
 }
 else // also multicolor
 {
  if (vesa_print_modus==PIC_FILLED)
  {
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       for (i=0;i<copy_breite;i++)
       {
        *zeiger_dest++ = vesa_back_color;
       }
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
        {
         *zeiger_dest++ = *(zeiger_source+i);
        }
        else
        {
         *zeiger_dest++ = vesa_back_color;
        }
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  } /* vesa print modus */
  else
  {  /* also jetzt in PIC ON BACK */
   zeiger_dest=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
   while (zeilen_zaehler<hoehe)
   {
    T_INT buchstabe=0;
    T_INT position=0;
    T_INT zeichen_breite;
    while (((zeichen=(T_UCHAR)string[buchstabe])!=0)&&(position<breite))
    {
     T_INT copy_breite=0;
     if ((zeiger_source=font_now->zeichen[zeichen].zeiger)!=NULL)
     {
      copy_breite= (zeichen_breite=font_now->zeichen[zeichen].breite);
      if ((position+zeichen_breite)>breite)
       copy_breite=breite-position;
      else
       copy_breite=zeichen_breite;
      if (zeilen_zaehler>font_now->zeichen[zeichen].hoehe)
      {
       zeiger_dest += copy_breite;
      }
      else
      {
       zeiger_source += zeilen_zaehler * zeichen_breite;
       for (i=0;i<copy_breite;i++)
       {
        if ((T_WORD)*zeiger_source++!=font_now->hintergrundfarbe)
         *zeiger_dest++ = *(zeiger_source+i);
        else
         zeiger_dest++;
       }
      }
     }
     position+=copy_breite;
     buchstabe++;
    }
    zeilen_zaehler++;
    zeiger_dest+=adder;
   }
  }
 } //if (vesa_text==SINGLE_COLOR)
 T_DEBUG_LEAVE
 return 0;
}

T_INT vesa_print_zeile256_ban(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge)
{
 register T_INT i;
 T_WORD offset_x;
 T_INT neue_seg_adresse;
 T_LONG offset;
 T_PBYTE video;
 T_PBYTE zeiger;
 T_DEBUG_ENTRY("vesa_print_zeile256_ban",25)
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_INT)(offset&vesa_and_x);
 vesa_mouse_interrupt++;
// MOUSE_VERSTECKE

 vesa_mouse_verstecke_cursor(x,y,x+zeilen_laenge,y+1);
 if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
  vesa_set_write_window();
 }
 if (vesa_print_modus==PIC_FILLED)
 {
  if (offset_x>(T_WORD)(vesa_offset_compare-zeilen_laenge))
  {
   for (i=0;i<zeilen_laenge;i++)
   {
    *(T_PUCHAR )(vesa_write_seg+offset_x++)=zeile[i];
    if (offset_x==vesa_offset_compare)
    {
     offset_x=0;
     vesa_address_of_window[vesa_write_window]++;
     vesa_set_write_window();
    }
   }
  }
  else
  {
   zeiger=zeile;
   video=(T_PBYTE )(vesa_write_seg+offset_x);
   for (i=0;i<zeilen_laenge;i++)
    *(T_PUCHAR )(video++)=*zeiger++;
  }
 }
 else
 {
  zeiger=zeile;
  if (offset_x>(T_WORD)(vesa_offset_compare-zeilen_laenge))
  {
   for (i=0;i<zeilen_laenge;i++)
   {
    if (*zeiger!=vesa_back_color)
     vesa_plot256_oc(x+i,y,*zeiger);
    zeiger++;
   }
  }
  else /* in einem Rutsch */
  {
   video=(T_PBYTE )vesa_write_seg+offset_x;
   for (i=0;i<zeilen_laenge;i++)
   {
    if (*zeiger!=vesa_back_color)
     *video=*zeiger;
    video++;
    zeiger++;
   }
  }
 }
 vesa_mouse_interrupt--;
 vesa_mouse_zeige_cursor(x,y,x+zeilen_laenge,y+1);
// MOUSE_ZEIGE
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}
T_INT vesa_print_zeile256_oc_ban(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge)
{
 register T_INT i;
 T_WORD offset_x;
 T_INT neue_seg_adresse;
 T_LONG offset;
 T_PBYTE video;
 T_PBYTE zeiger;
 T_DEBUG_ENTRY("vesa_print_zeile256_oc_ban",25)
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_INT)(offset&vesa_and_x);
 vesa_mouse_interrupt++;
 if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
  vesa_set_write_window();
 }
 if (vesa_print_modus==PIC_FILLED)
 {
  if (offset_x>(T_WORD)(vesa_offset_compare-zeilen_laenge))
  {
   for (i=0;i<zeilen_laenge;i++)
   {
    *(T_PUCHAR )(vesa_write_seg+offset_x++)=zeile[i];
    if (offset_x==vesa_offset_compare)
    {
     offset_x=0;
     vesa_address_of_window[vesa_write_window]++;
     vesa_set_write_window();
    }
   }
  }
  else
  {
   zeiger=zeile;
   video=(T_PBYTE )(vesa_write_seg+offset_x);
   for (i=0;i<zeilen_laenge;i++)
    *(T_PUCHAR )(video++)=*zeiger++;
  }
 }
 else
 {
  zeiger=zeile;
  if (offset_x>(T_WORD)(vesa_offset_compare-zeilen_laenge))
  {
   for (i=0;i<zeilen_laenge;i++)
   {
    if (*zeiger!=vesa_back_color)
     vesa_plot256_oc(x+i,y,*zeiger);
    zeiger++;
   }
  }
  else /* in einem Rutsch */
  {
   video=(T_PBYTE )vesa_write_seg+offset_x;
   for (i=0;i<zeilen_laenge;i++)
   {
    if (*zeiger!=vesa_back_color)
     *video=*zeiger;
    video++;
    zeiger++;
   }
  }
 }
 vesa_mouse_interrupt--;
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

T_VOID vesa_print_zeile256_oc_raw_ban(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge)
{
 register T_INT i;
 T_WORD offset_x;
 T_INT neue_seg_adresse;
 T_LONG offset;
 T_PBYTE video;
 T_PBYTE zeiger;
 T_DEBUG_ENTRY("vesa_print_zeile256_oc_raw_ban",25)
 offset=((T_ULONG)x)+linestartpos[(T_UWORD)y];
 offset_x=(T_INT)(offset&vesa_and_x);
 vesa_mouse_interrupt++;
 if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
  vesa_set_write_window();
 }
 if (offset_x>(T_WORD)(vesa_offset_compare-zeilen_laenge))
 {
  for (i=0;i<zeilen_laenge;i++)
  {
   *(T_PUCHAR )(vesa_write_seg+offset_x++)=zeile[i];
   if (offset_x==vesa_offset_compare)
   {
    offset_x=0;
    vesa_address_of_window[vesa_write_window]++;
    vesa_set_write_window();
   }
  }
 }
 else
 {
  zeiger=zeile;
  video=(T_PBYTE )(vesa_write_seg+offset_x);
  for (i=0;i<zeilen_laenge;i++)
   *(T_PUCHAR )(video++)=*zeiger++;
 }
 vesa_mouse_interrupt--;
 T_DEBUG_LEAVE
// return vesa_error=T_OK;
}

T_INT vesa_print_zeile256_lin(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge)
{
 register T_INT i;
 T_PBYTE video=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
 T_PBYTE zeiger=zeile;
 T_DEBUG_ENTRY("vesa_print_zeile256_lin",25)
 vesa_mouse_interrupt++;
/*
 if (x<0)
 {
  video+=(-x);
  zeile+=(-x);
 }
 if (x+zeilen_laenge>vesa_x)
  zeilen_laenge=vesa_x-x;
 if (y>vesa_y)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return vesa_error=T_OK;
 }
 if (y<0)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return vesa_error=T_OK;
 }
*/
// MOUSE_VERSTECKE
 vesa_mouse_verstecke_cursor(x,y,x+zeilen_laenge,y+1);
 if (vesa_print_modus==PIC_FILLED)
 {
  for (i=0;i<zeilen_laenge;i++)
   *(T_PUCHAR )(video++)=*zeiger++;
 }
 else
 {
  for (i=0;i<zeilen_laenge;i++)
  {
   if (*zeiger!=vesa_back_color)
    *video=*zeiger;
   video++;
   zeiger++;
  }
 }
 vesa_mouse_interrupt--;
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x,y,x+zeilen_laenge,y+1);
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

T_VOID vesa_print_zeile256_oc_raw_lin(T_INT x1, T_INT y1, T_PBYTE zeilen_buffer, T_INT len)
{
// T_PBYTE video=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y1]+(T_ULONG)x1);
 T_DEBUG_ENTRY("vesa_print_zeile256_oc_raw_lin",25)
// memmove(video,zeilen_buffer,len);
 memmove((T_PBYTE)(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y1]+(T_ULONG)x1),zeilen_buffer,len);
 T_DEBUG_LEAVE
// return T_OK;
}

T_INT vesa_print_zeile256_oc_lin(T_INT x,T_INT y,T_PBYTE zeile, T_WORD zeilen_laenge)
{
 register T_INT i;
 T_PBYTE video=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y]+(T_ULONG)x);
 T_PBYTE zeiger=zeile;
 T_DEBUG_ENTRY("vesa_print_zeile256_oc_lin",25)
 vesa_mouse_interrupt++;
/*
 if (x<0)
 {
  video+=(-x);
  zeile+=(-x);
 }
 if (x+zeilen_laenge>vesa_x)
  zeilen_laenge=vesa_x-x;
 if (y>vesa_y)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return vesa_error=T_OK;
 }
 if (y<0)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return vesa_error=T_OK;
 }
*/
 if (vesa_print_modus==PIC_FILLED)
 {
  memmove(video,zeiger,zeilen_laenge);
//  for (i=0;i<zeilen_laenge;i++)
//   *(T_PUCHAR )(video++)=*zeiger++;
 }
 else
 {
  for (i=0;i<zeilen_laenge;i++)
  {
   if (*zeiger!=vesa_back_color)
    *video=*zeiger;
   video++;
   zeiger++;
  }
 }
 vesa_mouse_interrupt--;
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

T_VOID vesa_get_zeile_ban(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer)
{
 T_INT i;
 T_INT neue_seg_adresse;
 T_LONG offset;
 T_WORD offset_x;
 T_PUCHAR zeiger_source;
 T_DEBUG_ENTRY("vesa_get_zeile_ban",25)
 offset=((T_ULONG)x1)+linestartpos[(T_UWORD)y1];
 offset_x=(T_INT)(offset&vesa_and_x);      /* x-koordinate */
 vesa_mouse_interrupt++;
// MOUSE_VERSTECKE

 vesa_mouse_verstecke_cursor(x1,y1,x1+len,y1+1);
 if (vesa_address_of_window[vesa_read_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_read_window]=neue_seg_adresse;
  vesa_set_read_window();
 }
 for (i=0;i<len;i++)
 {
  zeiger_source=(T_PUCHAR )(vesa_read_seg+offset_x);
  zeilen_buffer[i]=*(zeiger_source);
  offset_x++;
  if (offset_x==vesa_offset_compare)
  {
   offset_x=0;
   vesa_address_of_window[vesa_read_window]++;
   vesa_set_read_window();
  }
 }
 vesa_mouse_interrupt--;
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x1,y1,x1+len,y1+1);
 T_DEBUG_LEAVE
// return T_OK;
}
T_VOID vesa_get_zeile_oc_ban(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer)
{
 T_INT i;
 T_INT neue_seg_adresse;
 T_LONG offset;
 T_WORD offset_x;
 T_PUCHAR zeiger_source;
 T_DEBUG_ENTRY("vesa_get_zeile_oc_ban",25)
 offset=((T_ULONG)x1)+linestartpos[(T_UWORD)y1];
 offset_x=(T_INT)(offset&vesa_and_x);      /* x-koordinate */
 vesa_mouse_interrupt++;
 if (vesa_address_of_window[vesa_read_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
 {
  vesa_address_of_window[vesa_read_window]=neue_seg_adresse;
  vesa_set_read_window();
 }
 for (i=0;i<len;i++)
 {
  zeiger_source=(T_PUCHAR )(vesa_read_seg+offset_x);
  zeilen_buffer[i]=*(zeiger_source);
  offset_x++;
  if (offset_x==vesa_offset_compare)
  {
   offset_x=0;
   vesa_address_of_window[vesa_read_window]++;
   vesa_set_read_window();
  }
 }
 vesa_mouse_interrupt--;
 T_DEBUG_LEAVE
// return T_OK;
}

T_VOID vesa_get_zeile_lin(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer)
{
 T_PBYTE video=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y1]+(T_ULONG)x1);
 T_DEBUG_ENTRY("vesa_get_zeile_lin",25)
 vesa_mouse_interrupt++;
 MOUSE_VERSTECKE
 memmove(zeilen_buffer,video,len);
 vesa_mouse_interrupt--;
 MOUSE_ZEIGE
 T_DEBUG_LEAVE
// return T_OK;
}

T_VOID vesa_get_zeile_oc_lin(T_INT x1, T_INT y1, T_INT len, T_PBYTE zeilen_buffer)
{
// T_PBYTE video=(((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y1]+(T_ULONG)x1);
 T_DEBUG_ENTRY("vesa_get_zeile_oc_lin",25)
 memmove(zeilen_buffer,(T_PBYTE) (((T_UCHAR*)svdc->videoMem)+linestartpos[(T_UWORD)y1]+(T_ULONG)x1),len);
 T_DEBUG_LEAVE
// return T_OK;
}

/***************************************************************/

#pragma off (check_stack)
T_VOID _loadds far vesa_mouse_get_mouse(T_ULONG max, T_ULONG mcx, T_ULONG mdx, T_ULONG mbx)
{
#pragma aux vesa_mouse_get_mouse parm [EAX] [ECX] [EDX] [EBX]
 _disable();
 vesa_mouse_x=mcx;
 vesa_mouse_y=mdx;
 vesa_mouse_button=mbx;
 vesa_mouse_code=max;
 vesa_mouse_changed=T_TRUE;
#ifdef VECTREX
 vmouse_x=(mcx-mausxmin-((mausxmax-mausxmin)/2))*dividerx;
 vmouse_y=-(mdx-mausymin-((mausymax-mausymin)/2))*dividery;
#endif
 _enable();
}
#pragma on (check_stack)

T_INT vesa_mouse_init(T_VOID)
{
 struct SREGS sregs;
 union REGS inregs, outregs;
 T_INT x_max=vesa_x;//-1-vesa_mouse_zeiger->groesse_x;
 T_INT y_max=vesa_y;//-1-vesa_mouse_zeiger->groesse_y;
 T_DEBUG_ENTRY("vesa_mouse_init",25)
 if (initialised!=T_TRUE)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_NOT_INITIALIZED)
  T_DEBUG_LEAVE
  return vesa_error=VESA_NOT_INITIALIZED;
 }
 segread(&sregs);
 vesa_mouse_deinit();
 if (vesa_mouse_zeiger_rettung)
 {
  free(vesa_mouse_zeiger_rettung);
  vesa_mouse_zeiger_rettung=NULL;
 }
 vesa_mouse_zeiger_rettung=(T_PBYTE )malloc(vesa_mouse_zeiger->groesse_x*vesa_mouse_zeiger->groesse_y);
 if (vesa_mouse_zeiger_rettung==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return vesa_error=GENERIC_MEMORY_NOT_AVAILABLE;
 }
 /**************************/
 /* check for mouse driver */
 /**************************/
 inregs.w.ax = MAUS_RESET;
 int386(MAUS_INTERRUPT, &inregs, &outregs);
 if (!(outregs.w.ax == 0xffff))
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  tool_exit(VESA_NO_MOUSEDRIVER_FOUND);
 }
 /*****************************/
 /* install vesa_mouse_update */
 /*****************************/
 inregs.w.ax = 0xC;
 inregs.w.cx = 1+2+4+8+16; /* move, right/left press and release */
 inregs.x.edx = FP_OFF(vesa_mouse_get_mouse);
 sregs.es     = FP_SEG(vesa_mouse_get_mouse);
 int386x(MAUS_INTERRUPT, &inregs, &outregs, &sregs);

 inregs.x.eax=MAUS_VERHAELTNIS_MICKEY_PUNKTE;
 inregs.x.ecx=8;
 inregs.x.edx=8;
 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);

 inregs.x.eax=MAUS_BEWEGE_ZEIGER;
 inregs.x.edx=vesa_save_mouse_y;
 inregs.x.ecx=vesa_save_mouse_x;

 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);

 inregs.x.eax=MAUS_HORIZONTALE_BEWEGUNG;
 inregs.x.ecx=0;
 inregs.x.edx=x_max;
 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);

 inregs.x.eax=MAUS_VERTIKALE_BEWEGUNG;
 inregs.x.ecx=0;
 inregs.x.edx=y_max;
 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);

 vesa_mouse_initialisiert=T_TRUE;
 vesa_mouse_interrupt=0;
 vesa_mouse_jetzt_schreiben=T_TRUE;
 vesa_mouse_jetzt_hg_schreiben=T_FALSE;
 vesa_mouse_jetzt_hg_sichern=T_TRUE;
#ifdef VECTREX
 if ((use_vectrex_mouse==T_FALSE)||(back_pic==NULL))
 {
  if (framebuffer==FB_BANKED)
  {
//   vesa_mouse_schreiben=vesa_mouse_schreiben_ban;
   vesa_mouse_hintergrund_schreiben=vesa_mouse_hintergrund_schreiben_ban;
//   vesa_mouse_hintergrund_sichern=vesa_mouse_hintergrund_sichern_ban;
  }
  else if (framebuffer==FB_LINEAR)
  {
//   vesa_mouse_schreiben=vesa_mouse_schreiben_lin;
   vesa_mouse_hintergrund_schreiben=vesa_mouse_hintergrund_schreiben_lin;
//   vesa_mouse_hintergrund_sichern=vesa_mouse_hintergrund_sichern_lin;
  }
 }
 else
 {
  if (framebuffer==FB_BANKED)
  {
//   vesa_mouse_schreiben=vesa_mouse_schreiben_vban;
   vesa_mouse_hintergrund_schreiben=vesa_mouse_hintergrund_schreiben_vban;
//   vesa_mouse_hintergrund_sichern=vesa_mouse_hintergrund_sichern_vban;
  }
  else if (framebuffer==FB_LINEAR)
  {
//   vesa_mouse_schreiben=vesa_mouse_schreiben_vlin;
   vesa_mouse_hintergrund_schreiben=vesa_mouse_hintergrund_schreiben_vlin;
//   vesa_mouse_hintergrund_sichern=vesa_mouse_hintergrund_sichern_vlin;
  }
 }
#endif
 vesa_mouse_force_update();
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

/***************************************************************/

T_INT vesa_mouse_deinit(T_VOID)
{
 union REGS regs;
 struct SREGS sregs;
 T_DEBUG_ENTRY("vesa_mouse_deinit",25)
 segread(&sregs);
 vesa_mouse_interrupt=-1;
 if (vesa_mouse_initialisiert==T_TRUE)
 {
  vesa_mouse_save_pos();
  if (vesa_mouse_jetzt_hg_schreiben==T_TRUE)
  {
   vesa_mouse_hintergrund_schreiben();
  }
  if (vesa_mouse_zeiger_rettung)
  {
   free(vesa_mouse_zeiger_rettung);
   vesa_mouse_zeiger_rettung=NULL;
  }
  vesa_mouse_initialisiert=T_FALSE;
  regs.w.ax=MAUS_RESET;
  int386x(MAUS_INTERRUPT,&regs,&regs,&sregs);
 }
 else
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_NO_MOUSE_INSTALLED)
  T_DEBUG_LEAVE
  return vesa_error=VESA_NO_MOUSE_INSTALLED;
 }
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

T_INT vesa_mouse_get_irq(T_VOID)
{
 /*
 union REGS regs;
 struct SREGS sregs;
 regs.x.ax=0x24;
 segread(&sregs);
 int86x(MAUS_INTERRUPT,&regs,&regs,&sregs);
 if (regs.w.ax==(T_UINT)-1)
  return 0;
 return regs.h.cl;
 */
 T_DEBUG_ENTRY("vesa_mouse_get_irq",25)
 T_DEBUG_LEAVE
 return 0;
}

/***************************************************************/

T_VOID vesa_mouse_update(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_update",25)
 if (vesa_mouse_changed==T_TRUE)
 {
  vesa_mouse_changed=T_FALSE;
  mouse_x_work=vesa_mouse_x;
  mouse_y_work=vesa_mouse_y;
  if (vesa_mouse_jetzt_hg_schreiben==T_TRUE)
  {
   vesa_mouse_hintergrund_schreiben();
  }
  if (vesa_mouse_jetzt_hg_sichern==T_TRUE)
  {
   vesa_mouse_hintergrund_sichern();
   vesa_mouse_jetzt_hg_schreiben=T_TRUE;
  }
  if (vesa_mouse_jetzt_schreiben==T_TRUE)
  {
   vesa_mouse_schreiben();
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_force_update(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_force_update",25)
 vesa_mouse_changed=T_FALSE;
 mouse_x_work=vesa_mouse_x;
 mouse_y_work=vesa_mouse_y;
 if (vesa_mouse_jetzt_hg_schreiben==T_TRUE)
 {
  vesa_mouse_hintergrund_schreiben();
 }
 if (vesa_mouse_jetzt_hg_sichern==T_TRUE)
 {
  vesa_mouse_hintergrund_sichern();
  vesa_mouse_jetzt_hg_schreiben=T_TRUE;
 }
 if (vesa_mouse_jetzt_schreiben==T_TRUE)
 {
  vesa_mouse_schreiben();
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_hintergrund_sichern_ban(T_VOID)
{
 static T_INT i;
 static T_INT p;
 static T_INT neue_seg_adresse;
 static T_LONG offset;
 static T_PBYTE zeiger_auf_pointer;
 static T_WORD offset_x;
 static T_WORD zeilen_laenge;
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_sichern_ban",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeiger_auf_pointer=vesa_mouse_zeiger_rettung;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (mouse_y_work+p<vesa_y)
  {
   offset=((T_ULONG)mouse_x_work)+linestartpos[(T_UWORD)mouse_y_work+p];
   offset_x=(T_INT)(offset&vesa_and_x);      /* x-koordinate */
   if (vesa_address_of_window[vesa_read_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
   {
    vesa_address_of_window[vesa_read_window]=neue_seg_adresse;
    vesa_set_read_window();
   }
   for (i=0;i<zeilen_laenge;i++)
   {
    if (mouse_x_work+i<vesa_x)
    {
     *zeiger_auf_pointer++=*((T_PUCHAR )(vesa_read_seg+offset_x++));
     if (offset_x==vesa_offset_compare)
     {
      offset_x=0;
      vesa_address_of_window[vesa_read_window]++;
      vesa_set_read_window();
     }
    }
    else
    {
     zeiger_auf_pointer++;
     offset_x++;
     if (offset_x==vesa_offset_compare)
     {
      offset_x=0;
      vesa_address_of_window[vesa_read_window]++;
      vesa_set_read_window();
     }
    }
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_hintergrund_schreiben_ban(T_VOID)
{
 static T_INT i;
 static T_INT p;
 static T_INT neue_seg_adresse;
 static T_LONG offset;
 static T_PBYTE zeiger_auf_pointer;
 static T_WORD offset_x;
 static T_WORD zeilen_laenge;
 static T_PBYTE zeiger;
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_schreiben_ban",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeiger_auf_pointer=vesa_mouse_zeiger_rettung;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   offset=((T_ULONG)vesa_mouse_x_old)+linestartpos[(T_UWORD)vesa_mouse_y_old+p];
   offset_x=(T_INT)(offset&vesa_and_x);
   if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
   {
    vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
    vesa_set_write_window();
   }
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
    {
     *(T_PUCHAR )(vesa_write_seg+offset_x++)=*zeiger_auf_pointer++;
     if (offset_x==vesa_offset_compare)
     {
      offset_x=0;
      vesa_address_of_window[vesa_write_window]++;
      vesa_set_write_window();
     }
    }
    else
    {
     offset_x++;
     zeiger_auf_pointer++;
     if (offset_x==vesa_offset_compare)
     {
      offset_x=0;
      vesa_address_of_window[vesa_write_window]++;
      vesa_set_write_window();
     }
    }
   }
  }
 }
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((clip_memory)+linestartpos[(T_UWORD)vesa_mouse_y_old+p]+(T_ULONG)vesa_mouse_x_old));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
     (*zeiger)-=2;
    zeiger++;
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_schreiben_ban(T_VOID)
{
 static T_SINT i;
 static T_SINT p;
 static T_INT neue_seg_adresse;
 static T_LONG offset;
 static T_PBYTE zeiger_auf_pointer;
 static T_PBYTE zeiger;
 static T_WORD offset_x;
 static T_SWORD zeilen_laenge;
 static T_SWORD zeilen_hoehe;
 T_DEBUG_ENTRY("vesa_mouse_schreiben_ban",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeilen_hoehe=vesa_mouse_zeiger->groesse_y;
 zeiger_auf_pointer=vesa_mouse_zeiger->maus_zeiger;
 if (mouse_y_work+zeilen_hoehe>vesa_y)
  zeilen_hoehe=vesa_y-mouse_y_work;
 for (p=0;p<zeilen_hoehe;p++)
 {
  offset=((T_ULONG)mouse_x_work)+linestartpos[(T_UWORD)mouse_y_work+p];
  offset_x=(T_INT)(offset&vesa_and_x);
  if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
  {
   vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
   vesa_set_write_window();
  }
  zeiger_auf_pointer=vesa_mouse_zeiger->maus_zeiger+p*vesa_mouse_zeiger->groesse_x;
  if (mouse_x_work+zeilen_laenge>vesa_x)
   zeilen_laenge=vesa_x-mouse_x_work;
  for (i=0;i<zeilen_laenge;i++)
  {
   if (*zeiger_auf_pointer!=vesa_mouse_zeiger->back)
    *(T_PUCHAR )(vesa_write_seg+offset_x)=*zeiger_auf_pointer;
   zeiger_auf_pointer++;
   offset_x++;
   if (offset_x==vesa_offset_compare)
   {
    offset_x=0;
    vesa_address_of_window[vesa_write_window]++;
    vesa_set_write_window();
   }
  }
 }
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (mouse_y_work+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((clip_memory)+linestartpos[(T_UWORD)mouse_y_work+p]+(T_ULONG)mouse_x_work));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (mouse_x_work+i<vesa_x)
     (*zeiger)+=2;
     zeiger++;
   }
  }
 }
 vesa_mouse_x_old=mouse_x_work;
 vesa_mouse_y_old=mouse_y_work;
 T_DEBUG_LEAVE
}

/***************************************************************/

T_INT vesa_mouse_setze_cursor(T_INT x, T_INT y)
{
 struct SREGS sregs;
 union REGS inregs, outregs;
 T_INT x_max=vesa_x-1/*-vesa_mouse_zeiger->groesse_x*/;  // changed 15.03.98
 T_INT y_max=vesa_y-1/*-vesa_mouse_zeiger->groesse_y*/;  // wegen veccy
 T_DEBUG_ENTRY("vesa_mouse_setze_cursor",25)
 if ((x<0)||(x>x_max)||(y<0)||(y>y_max))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_MOUSE_POSITION_OUT_OF_SCREEN)
  T_DEBUG_LEAVE
  return vesa_error=VESA_MOUSE_POSITION_OUT_OF_SCREEN;
 }
 segread(&sregs);
 inregs.x.eax=MAUS_BEWEGE_ZEIGER;
 inregs.x.edx=y;
 inregs.x.ecx=x;
 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);
 vesa_mouse_x=x;
 vesa_mouse_y=y;
 vesa_mouse_force_update();
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

/***************************************************************/

static T_INT vesa_mouse_x_hid=-1;
static T_INT vesa_mouse_y_hid=-1;



T_VOID vesa_mouse_verstecke_cursor(T_INT x1, T_INT y1, T_INT x2, T_INT y2)
{
 T_DEBUG_ENTRY("vesa_mouse_verstecke_cursor",25)

 if (vesa_mouse_verstecke==0)
 {
  if (  (   ((mouse_x_work>=x1) && (mouse_x_work<=x2))
         || ((mouse_x_work<=x1) && (mouse_x_work+vesa_mouse_zeiger->groesse_x>=x1)) )
      &&(   ((mouse_y_work>=y1) && (mouse_y_work<=y2))
         || ((mouse_y_work<=y1) && (mouse_y_work+vesa_mouse_zeiger->groesse_y>=y1)) ) )
//  if (  (   ((vesa_mouse_x>=x1) && (vesa_mouse_x<=x2))
//         || ((vesa_mouse_x<=x1) && (vesa_mouse_x+vesa_mouse_zeiger->groesse_x>=x1)) )
//      &&(   ((vesa_mouse_y>=y1) && (vesa_mouse_y<=y2))
//         || ((vesa_mouse_y<=y1) && (vesa_mouse_y+vesa_mouse_zeiger->groesse_y>=y1)) ) )
  {
   vesa_mouse_verstecke++;
   if (vesa_mouse_verstecke==1)
   {
    vesa_mouse_x_hid=mouse_x_work;
    vesa_mouse_y_hid=mouse_y_work;
//    vesa_mouse_x_hid=vesa_mouse_x;
//    vesa_mouse_y_hid=vesa_mouse_y;
    if (vesa_mouse_initialisiert==T_TRUE)
    {
     _disable();
     vesa_mouse_jetzt_hg_schreiben=T_TRUE;
     vesa_mouse_jetzt_hg_sichern=T_FALSE;
     vesa_mouse_jetzt_schreiben=T_FALSE;
     vesa_mouse_force_update();
     vesa_mouse_interrupt++;
     vesa_mouse_jetzt_hg_schreiben=T_FALSE;
     _enable();
    }
   }
  }
 }
 else
 {
  vesa_mouse_verstecke++;
 }
 T_DEBUG_LEAVE
}

T_VOID vesa_mouse_verstecke_cursor_all(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_verstecke_cursor_all",25)
 {
  vesa_mouse_verstecke++;
  if (vesa_mouse_verstecke==1)
  {
   if (vesa_mouse_initialisiert==T_TRUE)
   {
    _disable();
    vesa_mouse_jetzt_hg_schreiben=T_TRUE;
    vesa_mouse_jetzt_hg_sichern=T_FALSE;
    vesa_mouse_jetzt_schreiben=T_FALSE;
    vesa_mouse_force_update();
    vesa_mouse_interrupt++;
    vesa_mouse_jetzt_hg_schreiben=T_FALSE;
    _enable();
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_zeige_cursor(T_INT x1, T_INT y1, T_INT x2, T_INT y2)
{
 T_DEBUG_ENTRY("vesa_mouse_zeige_cursor",25)

 if (vesa_mouse_verstecke==1)
 {
  if (  (   ((vesa_mouse_x_hid>=x1) && (vesa_mouse_x_hid<=x2))
         || ((vesa_mouse_x_hid<=x1) && (vesa_mouse_x_hid+vesa_mouse_zeiger->groesse_x>=x1)) )
      &&(   ((vesa_mouse_y_hid>=y1) && (vesa_mouse_y_hid<=y2))
         || ((vesa_mouse_y_hid<=y1) && (vesa_mouse_y_hid+vesa_mouse_zeiger->groesse_y>=y1)) ) )
  {
   if (vesa_mouse_verstecke>0)
   {
    vesa_mouse_verstecke--;
    if (vesa_mouse_verstecke<=0)
    {
//     vesa_mouse_x_hid=-1;
//     vesa_mouse_y_hid=-1;
     if (vesa_mouse_initialisiert==T_TRUE)
     {
      _disable();
      vesa_mouse_jetzt_hg_schreiben=T_FALSE;
      vesa_mouse_jetzt_hg_sichern=T_TRUE;
      vesa_mouse_jetzt_schreiben=T_TRUE;
      vesa_mouse_interrupt--;
      vesa_mouse_force_update();
      vesa_mouse_jetzt_hg_schreiben=T_TRUE;
      _enable();
     }
    }
   }
  }
 }
 else
 {
  if (vesa_mouse_verstecke>0)
   vesa_mouse_verstecke--;
 }
 T_DEBUG_LEAVE
}

T_VOID vesa_mouse_zeige_cursor_all(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_zeige_cursor_all",25)
 {
  if (vesa_mouse_verstecke>0)
  {
   vesa_mouse_verstecke--;
   if (vesa_mouse_verstecke<=0)
   {
    if (vesa_mouse_initialisiert==T_TRUE)
    {
     _disable();
     vesa_mouse_jetzt_hg_schreiben=T_FALSE;
     vesa_mouse_jetzt_hg_sichern=T_TRUE;
     vesa_mouse_jetzt_schreiben=T_TRUE;
     vesa_mouse_interrupt--;
     vesa_mouse_force_update();
     vesa_mouse_jetzt_hg_schreiben=T_TRUE;
     _enable();
    }
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/
T_INT vesa_mouse_setze_rect(T_INT x_min, T_INT y_min,T_INT x_max, T_INT y_max)
{
 struct SREGS sregs;
 union REGS inregs, outregs;
 T_INT x_maxi=vesa_x-1-vesa_mouse_zeiger->groesse_x;
 T_INT y_maxi=vesa_y-1-vesa_mouse_zeiger->groesse_y;
 T_DEBUG_ENTRY("vesa_mouse_setze_rect",25)
 segread(&sregs);
 if ((x_min<0)||(x_max>x_maxi)||(y_min<0)||(y_max>y_maxi))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_MOUSE_POSITION_OUT_OF_SCREEN)
  T_DEBUG_LEAVE
  return vesa_error=VESA_MOUSE_POSITION_OUT_OF_SCREEN;
 }
 inregs.x.eax=MAUS_HORIZONTALE_BEWEGUNG;
 inregs.x.ecx=x_min;
 inregs.x.edx=x_max;
 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);
 inregs.x.eax=MAUS_VERTIKALE_BEWEGUNG;
 inregs.x.ecx=y_min;
 inregs.x.edx=y_max;
 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);
 vesa_mouse_setze_cursor(x_min+(x_max-x_min)/2,y_min+(y_max-y_min)/2 );
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

/***************************************************************/

T_VOID vesa_mouse_mickey_pro_8punkte(T_INT mickey_x, T_INT mickey_y)
{
 struct SREGS sregs;
 union REGS inregs, outregs;
 T_DEBUG_ENTRY("vesa_mouse_mickey_pro_8punkte",25)
 segread(&sregs);
 inregs.x.eax=MAUS_VERHAELTNIS_MICKEY_PUNKTE;
 inregs.x.ecx=mickey_x;
 inregs.x.edx=mickey_y;
 int386x(MAUS_INTERRUPT,&inregs,&outregs,&sregs);
 T_DEBUG_LEAVE
}

/***************************************************************/
T_VOID vesa_mouse_hintergrund_sichern_lin(T_VOID)
{
 static T_INT i;
 static T_INT p;
 static T_PBYTE zeiger_auf_pointer;
 static T_PBYTE zeiger;
 static T_WORD zeilen_laenge;
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_sichern_lin",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeiger_auf_pointer=vesa_mouse_zeiger_rettung;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (mouse_y_work+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((T_PUCHAR )(svdc->videoMem)+linestartpos[(T_UWORD)mouse_y_work+p]+(T_ULONG)mouse_x_work));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (mouse_x_work+i<vesa_x)
     *zeiger_auf_pointer++=*zeiger++;
    else
    {
     zeiger_auf_pointer++;
     zeiger++;
    }
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_hintergrund_schreiben_lin(T_VOID)
{
 static T_INT i;
 static T_INT p;
 static T_PBYTE zeiger_auf_pointer;
 static T_PBYTE zeiger;
 static T_WORD zeilen_laenge;
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_schreiben_lin",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeiger_auf_pointer=vesa_mouse_zeiger_rettung;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((T_PUCHAR )(svdc->videoMem)+linestartpos[(T_UWORD)vesa_mouse_y_old+p]+(T_ULONG)vesa_mouse_x_old));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
     *zeiger++=*zeiger_auf_pointer++;
    else
    {
     zeiger++;
     zeiger_auf_pointer++;
    }
   }
  }
 }
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((clip_memory)+linestartpos[(T_UWORD)vesa_mouse_y_old+p]+(T_ULONG)vesa_mouse_x_old));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
     (*zeiger)-=2;
    zeiger++;
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_schreiben_lin(T_VOID)
{
 static T_SINT i;
 static T_SINT p;
 static T_PBYTE zeiger_auf_pointer;
 static T_PBYTE zeiger;
 static T_SWORD zeilen_laenge;
 static T_SWORD zeilen_hoehe;
 T_DEBUG_ENTRY("vesa_mouse_schreiben_lin",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeiger_auf_pointer=vesa_mouse_zeiger->maus_zeiger;
 zeilen_hoehe=vesa_mouse_zeiger->groesse_y;
 if (mouse_y_work+zeilen_hoehe>vesa_y)
  zeilen_hoehe=vesa_y-mouse_y_work;
 for (p=0;p<zeilen_hoehe;p++)
 {
  zeiger=((T_PUCHAR )((T_PUCHAR )(svdc->videoMem)+linestartpos[(T_UWORD)(mouse_y_work+p)]+(T_ULONG)mouse_x_work));
  zeiger_auf_pointer=vesa_mouse_zeiger->maus_zeiger+p*vesa_mouse_zeiger->groesse_x;
  if (mouse_x_work+zeilen_laenge>vesa_x)
   zeilen_laenge=vesa_x-mouse_x_work;
  for (i=0;i<zeilen_laenge;i++)
  {
   if (*zeiger_auf_pointer!=vesa_mouse_zeiger->back)
    *zeiger=*zeiger_auf_pointer;
   zeiger++;
   zeiger_auf_pointer++;
  }
 }
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (mouse_y_work+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((clip_memory)+linestartpos[(T_UWORD)mouse_y_work+p]+(T_ULONG)mouse_x_work));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (mouse_x_work+i<vesa_x)
     (*zeiger)+=2;
     zeiger++;
   }
  }
 }
 vesa_mouse_x_old=mouse_x_work;
 vesa_mouse_y_old=mouse_y_work;
 T_DEBUG_LEAVE
}

T_VOID vesa_line_h(T_INT x,T_INT y,T_INT len, T_BYTE color)
{
 T_INT i;
 T_PBYTE zeilenpointer=zeile;
// T_INT old_print_modus=vesa_print_modus;
 T_DEBUG_ENTRY("vesa_line_h",25)
// vesa_print_modus=PIC_FILLED;
// for (i=0;i<len;i++)
//  *(zeilenpointer++)=color;
// vesa_print_zeile256(x,y,zeile,len);
// vesa_print_modus=old_print_modus;

 memset(zeilenpointer,color,len);
 for (i=0;i<len;i++)
  vesa_print_zeile256_oc_raw(x,y,zeile,len);

 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_line_v(T_INT x,T_INT y,T_INT len, T_BYTE color)
{
 T_INT i;
 T_INT t=y+len;
 T_DEBUG_ENTRY("vesa_line_v",25)
// MOUSE_VERSTECKE
 vesa_mouse_verstecke_cursor(x,y,x+len,y+1);
 for (i=y;i<=t;i++)
  vesa_plot256_oc(x,i,color);
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x,y,x+len,y+1);
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_rect(T_INT x,T_INT y,T_INT len_x, T_INT len_y, T_BYTE color)
{
 T_DEBUG_ENTRY("vesa_rect",25)
 vesa_line_h(x,y,len_x,color);
 vesa_line_h(x,y+len_y,len_x,color);
 vesa_line_v(x,y,len_y,color);
 vesa_line_v(x+len_x,y,len_y,color);
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_rect_fill(T_INT x,T_INT y,T_INT len_x, T_INT len_y,T_BYTE color)
{
 T_INT i;
 T_PBYTE zeilenpointer=zeile;
// T_INT old_print_modus=vesa_print_modus;
 T_DEBUG_ENTRY("vesa_rect_fill",25)
// vesa_print_modus=PIC_FILLED;
// MOUSE_VERSTECKE

 vesa_mouse_verstecke_cursor(x,y,x+len_x,y+len_y);
// for (i=0;i<len_x;i++)
//  *(zeilenpointer++)=color;
 memset(zeilenpointer,color,len_x);
 for (i=y;i<y+len_y;i++)
  vesa_print_zeile256_oc_raw(x,i,zeile,len_x);
// vesa_print_modus=old_print_modus;
// MOUSE_ZEIGE
 vesa_mouse_zeige_cursor(x,y,x+len_x,y+len_y);
 T_DEBUG_LEAVE
}

T_VOID vesa_rect_fill_oc(T_INT x,T_INT y,T_INT len_x, T_INT len_y,T_BYTE color)
{
 T_INT i;
 T_PBYTE zeilenpointer=zeile;
 T_DEBUG_ENTRY("vesa_rect_fill",25)
 memset(zeilenpointer,color,len_x);
 for (i=y;i<y+len_y;i++)
  vesa_print_zeile256_oc_raw(x,i,zeile,len_x);
 T_DEBUG_LEAVE
}

/***************************************************************/

T_INT vesa_set_default_mouse_color(T_BYTE outline,T_BYTE fill)
{
 T_INT i;
 T_BYTE back=vesa_mouse_zeiger->back;
 T_DEBUG_ENTRY("vesa_set_default_mouse_color",25)
 if (back==outline)
 {
  back=(back+1)%256;
  if (back==fill)
   back=(back+1)%256;
 }
 if (back==fill)
 {
  back=(back+1)%256;
  if (back==outline)
   back=(back+1)%256;
 }
 for (i=0;i<vesa_mouse_zeiger->groesse_y*vesa_mouse_zeiger->groesse_x;i++)
 {
  if (vesa_mouse_zeiger->maus_zeiger[i]==vesa_mouse_zeiger->back)
   vesa_mouse_zeiger->maus_zeiger[i]=back;
  else
   if (vesa_mouse_zeiger->maus_zeiger[i]==vesa_mouse_zeiger->outline)
    vesa_mouse_zeiger->maus_zeiger[i]=outline;
   else
    if (vesa_mouse_zeiger->maus_zeiger[i]==vesa_mouse_zeiger->fill)
     vesa_mouse_zeiger->maus_zeiger[i]=fill;
 }
 vesa_mouse_zeiger->outline=outline;
 vesa_mouse_zeiger->fill=fill;
 vesa_mouse_zeiger->back=back;
 if ( vesa_mouse_initialisiert==T_TRUE)
  vesa_mouse_force_update();
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_VOID clear_screen(T_VOID)
{
 T_DEBUG_ENTRY("clear_screen",25)
 vesa_rect_fill(0,0,vesa_x,vesa_y,0);
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_draw_shaded_rectangle(T_INT x, T_INT y, T_INT b, T_INT h,T_BYTE col1, T_BYTE col2, T_INT thick)
{
 T_INT i;
 T_DEBUG_ENTRY("vesa_draw_shaded_rectangle",25)
 for (i=0;i<thick;i++)
 {
  vesa_line_h(x,y+i,b-1-i,col1);
  vesa_line_h(x+i,y+h-1-i,b-1-i,col2);
  vesa_line_v(x+i,y,h-1-i,col1);
  vesa_line_v(x+b-1-i,y+i,h-1-i,col2);
 }
 T_DEBUG_LEAVE
}

RECTANGLE_SAVE *vesa_rect_save(T_INT x,T_INT y,T_INT len_x, T_INT len_y, T_BYTE color)
{
 T_INT i;
 T_INT zaehler=0;
 RECTANGLE_SAVE *this_rectangle;
 T_PBYTE buffer;
 T_DEBUG_ENTRY("vesa_rect_save",25)
 this_rectangle=(RECTANGLE_SAVE *)malloc(sizeof(RECTANGLE_SAVE));
 if (this_rectangle==NULL)
 {
  vesa_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 buffer=(T_PBYTE )malloc(2*(len_x+1)+2*(len_y+1)+2);
 if (buffer==NULL)
 {
  free(this_rectangle);
  vesa_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_LEAVE
  return NULL;
 }
 MOUSE_VERSTECKE
 vesa_get_zeile_oc(x,y,len_x,&buffer[zaehler]);
 zaehler+=len_x;
 vesa_get_zeile_oc(x,y+len_y,len_x,&buffer[zaehler]);
 zaehler+=len_x;

 for (i=y;i<y+len_y;i++)
  buffer[zaehler++]=(T_BYTE) vesa_get_pixel_oc(x,i);
 for (i=y;i<=y+len_y;i++)
  buffer[zaehler++]=(T_BYTE) vesa_get_pixel_oc(x+len_x,i);
 vesa_rect(x,y,len_x,len_y,color);
 MOUSE_ZEIGE

 this_rectangle->buffer=buffer;
 this_rectangle->x=x;
 this_rectangle->len_x=len_x;
 this_rectangle->y=y;
 this_rectangle->len_y=len_y;
 T_DEBUG_LEAVE
 return this_rectangle;
}

/***************************************************************/

T_INT vesa_remove_rectangle(RECTANGLE_SAVE *rectangle)
{
 T_INT x,len_x,y,len_y,i,zaehler=0;
 T_INT old_print_modus=vesa_print_modus;
 T_DEBUG_ENTRY("vesa_remove_rectangle",25)
 vesa_print_modus=PIC_FILLED;
 if (rectangle!=NULL)
 {
 MOUSE_VERSTECKE
  x=rectangle->x;
  len_x=rectangle->len_x;
  y=rectangle->y;
  len_y=rectangle->len_y;
  vesa_print_zeile256_oc(x,y,&rectangle->buffer[zaehler],len_x);
  zaehler+=len_x;
  vesa_print_zeile256_oc(x,y+len_y,&rectangle->buffer[zaehler],len_x);
  zaehler+=len_x;
  for (i=y;i<y+len_y;i++)
   vesa_plot256_oc(x,i,rectangle->buffer[zaehler++]);
  for (i=y;i<=y+len_y;i++)
   vesa_plot256_oc(x+len_x,i,rectangle->buffer[zaehler++]);
  free(rectangle->buffer);
  free(rectangle);
  vesa_print_modus=old_print_modus;
  MOUSE_ZEIGE
 }
 else
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(VESA_NO_RECTANGLE)
  T_DEBUG_LEAVE
  return VESA_NO_RECTANGLE;
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT vesa_save_mehrere_dac(T_INT start, T_UWORD anzahl, T_PCHAR dateiname)
{
 FILE *handle;
 T_INT i;
 T_CHAR r,g,b;
 T_PCHAR kennung="col";
 T_DEBUG_ENTRY("vesa_save_mehrere_dac",25)
 if ((handle=fopen(dateiname,"wb"))==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return vesa_error=FILE_OPEN_ERROR;
 }
 fwrite(kennung,3, 1, handle);
 fwrite(&anzahl,sizeof(T_UWORD), 1, handle);
 for (i=start;i<start+anzahl;i++)
 {
  vesa_get_dac_register(i,&r, &g,&b);
  fwrite(&r,sizeof(T_CHAR), 1, handle);
  fwrite(&g,sizeof(T_CHAR), 1, handle);
  fwrite(&b,sizeof(T_CHAR), 1, handle);
 }
 fclose(handle);
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

/***************************************************************/

T_INT vesa_load_mehrere_dac(T_INT start, T_PCHAR dateiname)
{
 FILE *handle;
 T_INT i;
// char r,g,b;
 T_CHAR test[4];
 T_UWORD anzahl_der_dacs;
 static T_BYTE dac[768];
 T_PBYTE dacp;
 T_DEBUG_ENTRY("vesa_load_mehrere_dac",25)
 dacp=dac;
 test[3]=0;
 if ((handle=fopen(dateiname,"rb"))==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return vesa_error=FILE_OPEN_ERROR;
 }
 fread(test,3,1,handle);
 if (strcmp(test,"col")!=0)
 {
  fclose(handle);
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_SET_THIS_FUNCTION_ERROR(FILE_OPEN_ERROR)
  T_DEBUG_LEAVE
  return vesa_error=FILE_OPEN_ERROR;
 }
 fread(&anzahl_der_dacs,sizeof(T_UWORD), 1, handle);
 if (start+anzahl_der_dacs>768)
 {
  fclose(handle);
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  tool_exit(0);
  return vesa_error=T_NOT_OK;
 }
 for (i=start;i<start+anzahl_der_dacs;i++)
 {
  fread(dacp++,sizeof(T_CHAR), 1, handle);
  fread(dacp++,sizeof(T_CHAR), 1, handle);
  fread(dacp++,sizeof(T_CHAR), 1, handle);
 }
 fclose(handle);
 vesa_set_mehrere_dac(start,anzahl_der_dacs, dac);
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

T_VOID sync_display(T_VOID)
{
 T_DEBUG_ENTRY("sync_display",25)

 while (inp(0x3da)&8);
 while (!(inp(0x3da)&8));

 T_DEBUG_LEAVE
 return;
}

/***************************************************************/

T_VOID vesa_set_dac_register(T_INT color_nummer,T_BYTE r, T_BYTE g, T_BYTE b)
{
 T_DEBUG_ENTRY("vesa_set_dac_register",25)
/*
 outp(0x3c8,color_nummer); // start at zero
 if (vesa_dac_depth==6)
 {
  outp(0x3c9,r);
  outp(0x3c9,g);
  outp(0x3c9,b);
 }
 else
 {
  outp(0x3c9,r<<2);
  outp(0x3c9,g<<2);
  outp(0x3c9,b<<2);
 }
*/
 vesa_dac_save[color_nummer*3]=r;
 vesa_dac_save[color_nummer*3+1]=g;
 vesa_dac_save[color_nummer*3+2]=b;
 palette[color_nummer][2]=vesa_dac_save[color_nummer*3+0]<<2;
 palette[color_nummer][1]=vesa_dac_save[color_nummer*3+1]<<2;
 palette[color_nummer][0]=vesa_dac_save[color_nummer*3+2]<<2;
 SV_setPalette(0,256,(SV_palette *)&palette[0][0],-1);
 T_DEBUG_LEAVE
}

/***************************************************************/

T_INT vesa_get_dac_register(T_INT color_nummer,T_PBYTE r, T_PBYTE g, T_PBYTE b)
{
 T_DEBUG_ENTRY("vesa_get_dac_register",25)
 *r=vesa_dac_save[color_nummer*3];
 *g=vesa_dac_save[color_nummer*3+1];
 *b=vesa_dac_save[color_nummer*3+2];
 T_DEBUG_LEAVE
 /*
 union REGS regs;
 struct SREGS sregs;
 segread(&sregs);
 regs.h.ah=PALETTEN_FUNKTIONEN;
 regs.h.al=EIN_DAC_LESEN;
 regs.w.bx=color_nummer;
 int386x(BIOS_INTERRUPT,&regs,&regs,&sregs);
 *r=regs.h.dh;
 *g=regs.h.ch;
 *b=regs.h.cl;
 T_DEBUG_LEAVE
 */
 return vesa_error=T_OK;
}

/***************************************************************/

T_INT vesa_set_mehrere_dac(T_INT start,T_INT anzahl, T_PBYTE buffer) /* 768 T_BYTE */
{
 T_INT i;
 T_DEBUG_ENTRY("vesa_set_mehrere_dac",25)
/*
 outp(0x3c8,start); // start at zero
 if (vesa_dac_depth==6)
 {
  for (i=start;i<start+anzahl;i++)
  {
   outp(0x3c9,(vesa_dac_save[i*3]  =(*buffer++) ));
   outp(0x3c9,(vesa_dac_save[i*3+1]=(*buffer++) ));
   outp(0x3c9,(vesa_dac_save[i*3+2]=(*buffer++) ));
  }
 }
 else
 {
  for (i=start;i<start+anzahl;i++)
  {
   outp(0x3c9,((vesa_dac_save[i*3]  =(*buffer++))<<2) );
   outp(0x3c9,((vesa_dac_save[i*3+1]=(*buffer++))<<2) );
   outp(0x3c9,((vesa_dac_save[i*3+2]=(*buffer++))<<2) );
  }
 }
*/
 for (i=start;i<start+anzahl;i++)
 {
  vesa_dac_save[i*3]  =(*buffer++);
  vesa_dac_save[i*3+1]=(*buffer++);
  vesa_dac_save[i*3+2]=(*buffer++);
 }
 for (i=0;i<256;i++)
 {
  palette[i][2]=vesa_dac_save[i*3+0]<<2;
  palette[i][1]=vesa_dac_save[i*3+1]<<2;
  palette[i][0]=vesa_dac_save[i*3+2]<<2;
 }
 SV_setPalette(0,256,(SV_palette *)&palette[0][0],-1);

 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

/***************************************************************/

T_INT vesa_get_mehrere_dac(T_INT start, T_INT anzahl, T_PBYTE buffer) /* 768 T_BYTE */
{
 T_INT i;
 T_PBYTE zeiger=buffer;
 T_DEBUG_ENTRY("vesa_get_mehrere_dac",25)
 if (buffer!=NULL)
 {
  for (i=start;i<start+anzahl;i++)
  {
   *zeiger++=vesa_dac_save[i*3];
   *zeiger++=vesa_dac_save[i*3+1];
   *zeiger++=vesa_dac_save[i*3+2];
  }
 }
 T_DEBUG_LEAVE
 return vesa_error=T_OK;
}

// palette is 8 bit, saved to 6 bit vesa_dac_save
T_VOID vesa_save_SVpalette_to_dac(T_CHAR palette[256][4])
{
 T_INT i;
 T_DEBUG_ENTRY("vesa_save_SVpalette_to_dac",25)
 for (i=0;i<256;i++)
 {
  vesa_dac_save[i*3+0]=(palette[i][2]>>2);
  vesa_dac_save[i*3+1]=(palette[i][1]>>2);
  vesa_dac_save[i*3+2]=(palette[i][0]>>2);
 }
 T_DEBUG_LEAVE
}
/* 8 bit entry */
T_VOID vesa_set_palette(T_CHAR palette[256][4])
{
 T_DEBUG_ENTRY("vesa_set_palette",25)
 T_INT i;
 for (i=0;i<256;i++)
 {
  vesa_dac_save[i*3+0]=(palette[i][2]>>2);
  vesa_dac_save[i*3+1]=(palette[i][1]>>2);
  vesa_dac_save[i*3+2]=(palette[i][0]>>2);
 }
// vesa_set_mehrere_dac(0,256,vesa_dac_save);
 SV_setPalette(0,256,(SV_palette *)&palette[0][0],-1);
 T_DEBUG_LEAVE
 return;
}

T_UCHAR vesa_get_nearest_used_color(T_INT r, T_INT g, T_INT b)
{
 /* to use as a FARB_TABELLE_256 color table is not strictly correct, */
 /* since no information about pixels is given, but should be ok...   */
 FARB_TABELLE_256 *t;
 t=((FARB_TABELLE_256 *) ((T_PVOID)vesa_dac_save));
 return get_nearest_color(r,g,b,*t,0,255,1);
}

T_VOID vesa_draw_line_lin(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour)
{
 T_PUBYTE dest=(T_PUBYTE )svdc->videoMem;
 T_SWORD dx=0,dy=0,err=0,inc=0;
 MOUSE_VERSTECKE
/**************************/
/* Do straight line cases */
/**************************/
 if(iX1==iX2)
 {
  if(iY1>iY2)
  {
   fSwap(&iY1,&iY2);
  }
  do
  {
   /******************************************************************************************/
   /* not to be put out of loop, offset can get to high... (high iY1 are pointing to maxline)*/
   /******************************************************************************************/
   offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
   *(dest+offset)=iColour;
  }
  while(iY1++!=iY2);
 }
 else if(iY1==iY2)
 {
  if(iX1>iX2)
  {
   fSwap(&iX1,&iX2);
  }
  offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
  do
  {
   *(dest+offset)=iColour;
   offset++;
  }
  while(iX1++!=iX2);
 }
 else
 {
  /*************/
  /* X Variant */
  /*************/
  dx=iX2-iX1;
  dy=iY2-iY1;
  if(abs(dx)>=abs(dy))
  {
   if(iX1>iX2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   err=-(dx>>1);
   if(dy>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dy=-dy;
   }
   do
   {
    /**************************/
    /* Calulate byte position */
    /**************************/
    offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     *(dest+offset)=iColour;
    /**********************/
    /* Check error status */
    /**********************/
    err+=dy;
    if(err>0)
    {
     err-=dx;
     iY1+=inc;
    }
   }
   while(iX1++!=iX2);
  }
  else
  {
   if(iY1>iY2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   err=-(dy>>1);
   if(dx>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dx=-dx;
   }
   do
   {
    /**************************/
    /* Calulate byte position */
    /**************************/
    offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
    *(dest+offset)=iColour;
    /**********************/
    /* Check error status */
    /**********************/
    err+=dx;
    if(err>=0)
    {
     err-=dy;
     iX1+=inc;
    }
   }
   while(iY1++!=iY2);
  }
 }
 MOUSE_ZEIGE
}

T_VOID vesa_draw_line_ban(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour)
{
 T_SWORD   dx=0,dy=0,err=0,inc=0;
 T_UWORD offset_x;
 T_INT offset;
 MOUSE_VERSTECKE
 /**************************/
 /* Do straight line cases */
 /**************************/
 if(iX1==iX2)
 {
  if(iY1>iY2)
  {
   fSwap(&iY1,&iY2);
  }
  do
  {
   /******************************************************************************************/
   /* not to be put out of loop, offset can get to high... (high iY1 are pointung to maxline)*/
   /******************************************************************************************/
   offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
   offset_x=(T_UWORD)(offset&vesa_and_x);
   if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
   {
    vesa_address_of_window[vesa_write_window]=new_win_address;
    vesa_set_write_window();
   }
   *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour;
  }
  while(iY1++!=iY2);
 }
 else if(iY1==iY2)
 {
  if(iX1>iX2)
  {
   fSwap(&iX1,&iX2);
  }
  offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
  do
  {
   offset_x=(T_UWORD)(offset&vesa_and_x);
   if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
   {
    vesa_address_of_window[vesa_write_window]=new_win_address;
    vesa_set_write_window();
   }
   *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour;
   offset++;
  }
  while(iX1++!=iX2);
 }
 else
 {
  /*************/
  /* X Variant */
  /*************/
  dx=iX2-iX1;
  dy=iY2-iY1;
  if(abs(dx)>=abs(dy))
  {
   if(iX1>iX2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   err=-(dx>>1);
   if(dy>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dy=-dy;
   }
   do
   {
    /**************************/
    /* Calulate byte position */
    /**************************/
    offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
    offset_x=(T_UWORD)(offset&vesa_and_x);
    if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
    {
     vesa_address_of_window[vesa_write_window]=new_win_address;
     vesa_set_write_window();
    }
    *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour;
    /**********************/
    /* Check error status */
    /**********************/
    err+=dy;
    if(err>0)
    {
     err-=dx;
     iY1+=inc;
    }
   }
   while(iX1++!=iX2);
  }
  else
  {
   if(iY1>iY2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   err=-(dy>>1);
   if(dx>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dx=-dx;
   }
   do
   {
    /**************************/
    /* Calulate byte position */
    /**************************/
    offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
    offset_x=(T_UWORD)(offset&vesa_and_x);
    if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
    {
     vesa_address_of_window[vesa_write_window]=new_win_address;
     vesa_set_write_window();
    }
    *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour;
    /**********************/
    /* Check error status */
    /**********************/
    err+=dx;
    if(err>=0)
    {
     err-=dy;
     iX1+=inc;
    }
   }
   while(iY1++!=iY2);
  }
 }
 MOUSE_ZEIGE
}

T_VOID vesa_draw_line_aa_lin(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour, T_UWORD I)
{
 static T_PUBYTE dest;
 static T_SWORD dx=0,dy=0,err=0,inc=0;
 static T_SWORD m;
 static T_SWORD w;
 static T_SWORD max_col;
 dest=(T_PUBYTE )svdc->videoMem;
 max_col=I+iColour;
 MOUSE_VERSTECKE
/**************************/
/* Do straight line cases */
/**************************/
 if(iX1==iX2)
 {
  if(iY1>iY2)
  {
   fSwap(&iY1,&iY2);
  }
  do
  {
   /******************************************************************************************/
   /* not to be put out of loop, offset can get to high... (high iY1 are pointing to maxline)*/
   /******************************************************************************************/
   offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
   *(dest+offset)=max_col;
  }
  while(iY1++!=iY2);
 }
 else if(iY1==iY2)
 {
  if(iX1>iX2)
  {
   fSwap(&iX1,&iX2);
  }
  offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
  do
  {
   *(dest+offset)=max_col;
   offset++;
  }
  while(iX1++!=iX2);
 }
 else
 {
  dx=iX2-iX1;
  dy=iY2-iY1;
  /*************/
  /* X Variant */
  /*************/
  if (abs(dx)>=abs(dy))
  {
   if (iY1==0)
    iY1++;
   if (iY2==0)
    iY2++;
   if(iX1>iX2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   if (dy>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dy=-dy;
   }
   m=(I*dy)/dx;
   if (m)
   {
    m=((I)*dy)/dx;
    w=(I)-m;
    err=(I>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     *(dest+offset)=iColour+err;
     *(dest+offset-vesa_bytes_per_scanline)=iColour+I-err;
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iY1+=inc;
      err=err-w;
     }
    }
    while(iX1++!=iX2);
   }
   else
   { // a small I or dy can result in m = 0
     // scale everything up, this should work up to
     // 1 pixel and 1 Color Intervall on a resolution of 2048 pixels...
    m=((I<<11)*dy)/dx;
    w=(I<<11)-m;
    err=((I<<11)>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     *(dest+offset)=iColour+(err>>11);
     *(dest+offset-vesa_bytes_per_scanline)=iColour+I-(err>>11);
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iY1+=inc;
      err=err-w;
     }
    }
    while(iX1++!=iX2);
   }
  }
  else
  {
   if (iX1==0)
    iX1++;
   if (iX2==0)
    iX2++;
   if (iY1>iY2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   if (dx>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dx=-dx;
   }
   m=(I*dx)/dy;
   if (m)
   {
    w=I-m;
    err=(I>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     *(dest+offset)=iColour+err;
     *(dest+offset-1)=iColour+I-err;
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iX1+=inc;
      err=err-w;
     }
    }
    while(iY1++!=iY2);
   }
   else
   {
    // see x...
    m=((I<<11)*dx)/dy;
    w=(I<<11)-m;
    err=((I<<11)>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     *(dest+offset)=iColour+(err>>11);
     *(dest+offset-1)=iColour+I-(err>>11);
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iX1+=inc;
      err=err-w;
     }
    }
    while(iY1++!=iY2);
   }
  }
 }
 MOUSE_ZEIGE
}

T_VOID vesa_draw_line_aa_ban(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour, T_UWORD I)
{
 static T_UWORD offset_x;
 static T_INT offset;
 static T_PUBYTE dest;
 static T_SWORD dx=0,dy=0,err=0,inc=0;
 static T_SWORD m;
 static T_SWORD w;
 static T_SWORD max_col;
 dest=(T_PUBYTE )svdc->videoMem;
 max_col=I+iColour;
 MOUSE_VERSTECKE
/**************************/
/* Do straight line cases */
/**************************/
 if(iX1==iX2)
 {
  if(iY1>iY2)
  {
   fSwap(&iY1,&iY2);
  }
  do
  {
   /******************************************************************************************/
   /* not to be put out of loop, offset can get to high... (high iY1 are pointing to maxline)*/
   /******************************************************************************************/
   offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
   offset_x=(T_UWORD)(offset&vesa_and_x);
   if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
   {
    vesa_address_of_window[vesa_write_window]=new_win_address;
    vesa_set_write_window();
   }
   *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)max_col;
  }
  while(iY1++!=iY2);
 }
 else if(iY1==iY2)
 {
  if(iX1>iX2)
  {
   fSwap(&iX1,&iX2);
  }
  offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
  do
  {
   offset_x=(T_UWORD)(offset&vesa_and_x);
   if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
   {
    vesa_address_of_window[vesa_write_window]=new_win_address;
    vesa_set_write_window();
   }
   *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)max_col;
   offset++;
  }
  while(iX1++!=iX2);
 }
 else
 {
  dx=iX2-iX1;
  dy=iY2-iY1;
  /*************/
  /* X Variant */
  /*************/
  if (abs(dx)>=abs(dy))
  {
   if (iY1==0)
    iY1++;
   if (iY2==0)
    iY2++;
   if(iX1>iX2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   if(dy>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dy=-dy;
   }
   m=(I*dy)/dx;
   if (m)
   {
    m=((I)*dy)/dx;
    w=(I)-m;
    err=(I>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+err;
     offset=linestartpos[(T_UWORD)iY1-1]+(T_ULONG)iX1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+I-err;
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iY1+=inc;
      err=err-w;
     }
    }
    while(iX1++!=iX2);
   }
   else
   { // a small I or dy can result in m = 0
     // scale everything up, this should work up to
     // 1 pixel and 1 Color Intervall on a resolution of 2048 pixels...
    m=((I<<11)*dy)/dx;
    w=(I<<11)-m;
    err=((I<<11)>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+(err>>11);
     offset=linestartpos[(T_UWORD)iY1-1]+(T_ULONG)iX1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+I-(err>>11);
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iY1+=inc;
      err=err-w;
     }
    }
    while(iX1++!=iX2);
   }
  }
  else
  {
   if (iX1==0)
    iX1++;
   if (iX2==0)
    iX2++;
   if (iY1>iY2)
   {
    fSwap(&iX1,&iX2);
    fSwap(&iY1,&iY2);
   }
   dx=iX2-iX1;
   dy=iY2-iY1;
   if (dx>0)
   {
    inc=1;
   }
   else
   {
    inc=-1;
    dx=-dx;
   }
   m=(I*dx)/dy;
   if (m)
   {
    w=I-m;
    err=(I>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+err;
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1-1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+I-err;
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iX1+=inc;
      err=err-w;
     }
    }
    while(iY1++!=iY2);
   }
   else
   {
    // see x...
    m=((I<<11)*dx)/dy;
    w=(I<<11)-m;
    err=((I<<11)>>1);
    do
    {
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+(err>>11);
     offset=linestartpos[(T_UWORD)iY1]+(T_ULONG)iX1-1;
     offset_x=(T_UWORD)(offset&vesa_and_x);
     if (vesa_address_of_window[vesa_write_window]!=(new_win_address=(T_UWORD)(offset>>vesa_granularity_potenz)))
     {
      vesa_address_of_window[vesa_write_window]=new_win_address;
      vesa_set_write_window();
     }
     *((T_PUBYTE )(vesa_write_seg+offset_x))=(T_UBYTE)iColour+I-(err>>11);
     if (err<w)
     {
      err+=m;
     }
     else
     {
      iX1+=inc;
      err=err-w;
     }
    }
    while(iY1++!=iY2);
   }
  }
 }
 MOUSE_ZEIGE
}
T_VOID vesa_mouse_save_pos(T_VOID)
{
 vesa_save_mouse_x=vesa_mouse_x;
 vesa_save_mouse_y=vesa_mouse_y;
}
T_VOID vesa_mouse_load_pos(T_VOID)
{
 vesa_mouse_setze_cursor(vesa_save_mouse_x, vesa_save_mouse_y);
}

static T_INT my_cos_[(1<<16)+1];
static T_INT my_sin_[(1<<16)+1];
static T_INT cinit=T_FALSE;
#define PI          3.141592654

T_VOID _cinit(T_VOID)
{
 T_INT c=0;
 double i;
 cinit=T_TRUE;
 for (i=0;i<2*PI;i+=(2*PI/(1<<16)) )
 {
  my_cos_[c]=(T_INT)(cos(i)*(1<<16));
  my_sin_[c]=(T_INT)(sin(i)*(1<<16));
  c++;
 }
 my_cos_[0]=(1<<16);
 my_sin_[0]=0;
}

T_INT vesa_circle( T_INT x, T_INT y, T_INT r, T_UWORD color )
{
 T_INT i;
 T_INT x1, y1;
 T_INT dots=2*r*4;//PI;
 if (cinit==T_FALSE)
 {
  // generate SIN/COS datas
  _cinit();
 }
 MOUSE_VERSTECKE
 for( i = 0; i < (1<<16); i+=((1<<16)/dots) )
 {
  x1 = (my_cos_[i]*r)>>16;
  y1 = (my_sin_[i]*r)>>16;
  vesa_plot256_oc(x1+x,y1+y,color);
 }
 MOUSE_ZEIGE
 return T_OK;
}
void deinit_mouse_error(void)
{
 static union REGS regs;
 static struct SREGS sregs;
 segread(&sregs);
 regs.w.ax=MAUS_RESET;
 int386x(MAUS_INTERRUPT,&regs,&regs,&sregs);
}

#ifdef VECTREX

T_VOID vesa_mouse_hintergrund_sichern_vban(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_sichern_vban",25)
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_hintergrund_schreiben_vban(T_VOID)
{
 static T_INT i;
 static T_INT p;
 static T_INT neue_seg_adresse;
 static T_LONG offset;
 static T_PBYTE zeiger_auf_pointer;
 static T_WORD offset_x;
 static T_WORD zeilen_laenge;
 static T_PBYTE zeiger;
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_schreiben_vban",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeiger_auf_pointer=vesa_mouse_zeiger_rettung;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   offset=((T_ULONG)vesa_mouse_x_old)+linestartpos[(T_UWORD)vesa_mouse_y_old+p];
   offset_x=(T_INT)(offset&vesa_and_x);
   if (vesa_address_of_window[vesa_write_window]!=(neue_seg_adresse=(T_INT)(offset>>vesa_granularity_potenz)))
   {
    vesa_address_of_window[vesa_write_window]=neue_seg_adresse;
    vesa_set_write_window();
   }
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
    {
     if ((*zeiger_auf_pointer>=224)||(*zeiger_auf_pointer<16))
      *(T_PUCHAR )(vesa_write_seg+offset_x++)=*zeiger_auf_pointer++;
     else
       *(T_PUCHAR )(vesa_write_seg+offset_x++)=((*zeiger_auf_pointer++)>>4);
     if (offset_x==vesa_offset_compare)
     {
      offset_x=0;
      vesa_address_of_window[vesa_write_window]++;
      vesa_set_write_window();
     }
    }
    else
    {
     offset_x++;
     zeiger_auf_pointer++;
     if (offset_x==vesa_offset_compare)
     {
      offset_x=0;
      vesa_address_of_window[vesa_write_window]++;
      vesa_set_write_window();
     }
    }
   }
  }
 }
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((clip_memory)+linestartpos[(T_UWORD)vesa_mouse_y_old+p]+(T_ULONG)vesa_mouse_x_old));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
     (*zeiger)-=2;
    zeiger++;
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_schreiben_vban(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_schreiben_vban",25)
 T_DEBUG_LEAVE
}

T_VOID vesa_mouse_hintergrund_sichern_vlin(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_sichern_vlin",25)
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_hintergrund_schreiben_vlin(T_VOID)
{
 static T_INT i;
 static T_INT p;
 static T_PBYTE zeiger_auf_pointer;
 static T_PBYTE zeiger;
 static T_WORD zeilen_laenge;
 T_DEBUG_ENTRY("vesa_mouse_hintergrund_schreiben_vlin",25)
 zeilen_laenge=vesa_mouse_zeiger->groesse_x;
 zeiger_auf_pointer=vesa_mouse_zeiger_rettung;
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((T_PUCHAR )(svdc->videoMem)+linestartpos[(T_UWORD)vesa_mouse_y_old+p]+(T_ULONG)vesa_mouse_x_old));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
    {
     if ((*zeiger_auf_pointer>=224)||(*zeiger_auf_pointer<16))
      *zeiger++=*zeiger_auf_pointer++;
     else
      *zeiger++=((*zeiger_auf_pointer++)>>4);
    }
    else
    {
     zeiger++;
     zeiger_auf_pointer++;
    }
   }
  }
 }
 for (p=0;p<vesa_mouse_zeiger->groesse_y;p++)
 {
  if (vesa_mouse_y_old+p<vesa_y)
  {
   zeiger=((T_PUCHAR )((clip_memory)+linestartpos[(T_UWORD)vesa_mouse_y_old+p]+(T_ULONG)vesa_mouse_x_old));
   for (i=0;i<zeilen_laenge;i++)
   {
    if (vesa_mouse_x_old+i<vesa_x)
     (*zeiger)-=2;
     zeiger++;
   }
  }
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID vesa_mouse_schreiben_vlin(T_VOID)
{
 T_DEBUG_ENTRY("vesa_mouse_schreiben_vlin",25)
 T_DEBUG_LEAVE
}
#endif // VECTREX

