#include <stdlib.h>

#include <string.h>
#include "button.h"
#include "error.h"
#include "vesa.h"
#include "bild.h"
#include "tool.h"
#include "file.h"
#include "keyboard.h"
#include "parser.h"
#include "tprint.h"

#include "win_raw.h"
#ifdef VECTREX
#include "..\vectrex\source\vdebug.h"
#endif
/* Module Defines */

/* fenster drueber oder drunter */
#define LOWER 0
#define HIGHER 1

#define CLOSE_SEPERATOR 10

 typedef struct
 {
  T_INT x;
  T_INT y;
  T_INT b;
  T_INT h;
  WINDOW_LISTEN_ELEMENT *window;
 } GEBIET;
 /* Modul globale Variablen */
T_LISTE *freies_gebiet_first=NULL;
T_LISTE *freies_gebiet_last=NULL;

/* globale Variablen initialisieren */
T_INT win_raw_error=T_OK;
T_LISTE *window_first=NULL;
T_LISTE *window_last=NULL;
MEM_BILD *back_pic=NULL;
#ifdef VECTREX
T_INT update_function(T_INT status, T_PVOID vwindow);
#endif
T_INT windows_open=0;
T_INT windows_shown=0;
T_INT win_bewegungsart=GANZ;
T_INT button_raw=T_FALSE;

T_INT (*back_tasten_funktion)(PARAMETER *parameter)=NULL;
T_INT (*back_area_funktion)(PARAMETER *parameter)=NULL;

/* Modul globale Funktionen */
T_LISTE *window_overlap_werte(T_LISTE *window_liste,T_INT x,T_INT y,T_INT b,T_INT h,T_PINT ret_x,T_PINT ret_y,
                              T_PINT ret_b, T_PINT ret_h,T_PINT ret_off_x,T_PINT ret_off_y,T_INT flag);
T_INT process_gebiets_liste(T_LISTE *window_liste, T_INT flag, WINDOW_LISTEN_ELEMENT *this_window);
T_INT get_aktiv_high(T_VOID);

/***************************************************************/

/* diese funktion ermittelt fuer ein gegebenes gebiet */
/* und einem gegebenen anfangsfenster das naechste fenster, das */
/* dieses gebiet ueberlappt, das entsprechende fenster und */
/* die werte der 'uberlappung' werden zurueckgegeben */
T_LISTE *window_overlap_werte(T_LISTE *liste,T_INT x,T_INT y,T_INT b,T_INT h,T_PINT ret_x,T_PINT ret_y,
                              T_PINT ret_b, T_PINT ret_h,T_PINT ret_off_x,T_PINT ret_off_y,T_INT flag)
{
 WINDOW_LISTEN_ELEMENT *window;
 T_LISTE *window_liste;
 T_LISTE *ret=NULL;
 T_DEBUG_ENTRY("window_overlap_werte",40)
 if (liste==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return NULL;
 }
 if (flag==LOWER)
  window_liste=liste->naechstes;
 if (flag==HIGHER)
  window_liste=liste->letztes;
 while ((window_liste!=NULL)&&(ret==NULL))
 {
  window=(WINDOW_LISTEN_ELEMENT *)window_liste->objekt;
  if ((!window->hide)&&(!window->dhide))
  {
   if (window->x<=x)
   {
    if (window->y<=y)
    {
     if ((x-window->x<=window->b)&&(y-window->y<=window->h))
     {
      *ret_x=x;
      if (x+b>=window->x+window->b)
       *ret_b=window->x+window->b-x;
      else
       *ret_b=b;
      *ret_y=y;
      if (y+h>=window->y+window->h)
       *ret_h=window->y+window->h-y;
      else
       *ret_h=h;
      ret=window_liste;
      *ret_off_x=abs(*ret_x-window->x);
      *ret_off_y=abs(*ret_y-window->y);
     }
    }
    else
    {
     if ((x-window->x<=window->b)&&(window->y-y<=h))
     {
      *ret_x=x;
      if (x+b>=window->x+window->b)
       *ret_b=window->x+window->b-x;
      else
       *ret_b=b;
      *ret_y=window->y;
      if (y+h>=window->y+window->h)
       *ret_h=window->h;
      else
       *ret_h=y+h-window->y;
      ret=window_liste;
      *ret_off_x=abs(*ret_x-window->x);
      *ret_off_y=abs(*ret_y-window->y);
     }
    }
   }
   else
   {
    if (window->y<=y)
    {
     if ((window->x-x<=b)&&(y-window->y<=window->h))
     {
      *ret_x=window->x;
      if (x+b>=window->x+window->b)
       *ret_b=window->b;
      else
       *ret_b=x+b-window->x;
      if (y+h>=window->y+window->h)
       *ret_h=window->y+window->h-y;
      else
       *ret_h=h;
      *ret_y=y;
      ret=window_liste;
      *ret_off_x=abs(*ret_x-window->x);
      *ret_off_y=abs(*ret_y-window->y);
     }
    }
    else
    {
     if ((window->x-x<=b)&&(window->y-y<=h))
     {
      *ret_x=window->x;
      if (x+b>=window->x+window->b)
       *ret_b=window->b;
      else
       *ret_b=x+b-window->x;
      if (y+h>=window->y+window->h)
       *ret_h=window->h;
      else
       *ret_h=y+h-window->y;
      *ret_y=window->y;
      ret=window_liste;
      *ret_off_x=abs(*ret_x-window->x);
      *ret_off_y=abs(*ret_y-window->y);
     }
    }
   }
  }
  if (flag==LOWER)
   window_liste=window_liste->naechstes;
  if (flag==HIGHER)
   window_liste=window_liste->letztes;
 }
 T_DEBUG_LEAVE
 return ret;
}

/***************************************************************/

T_INT insert(T_INT x,T_INT y,T_INT b,T_INT h,WINDOW_LISTEN_ELEMENT *this_window)
{
 GEBIET *gebiet;
 T_DEBUG_ENTRY("insert",40)
 gebiet=(GEBIET *)malloc(sizeof(GEBIET));
 if (gebiet==NULL)
 {
  win_raw_error=WINDOW_NO_AREA_MEMORY;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(WINDOW_NO_AREA_MEMORY)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return 1;
 }
 gebiet->x=x;
 gebiet->y=y;
 gebiet->b=b;
 gebiet->h=h;
 gebiet->window=this_window;
 d_fuege_in_liste_ein( gebiet, &freies_gebiet_first, &freies_gebiet_last, DL_HINTEN);
 T_DEBUG_LEAVE
 return 0;
}

/***************************************************************/

T_VOID free_gebiete(T_VOID)
{
 GEBIET *gebiet;
 T_DEBUG_ENTRY("free_gebiete",40)
 while (freies_gebiet_first)
 {
  gebiet=(GEBIET *)freies_gebiet_first->objekt;
  d_entferne_aus_liste(gebiet, &freies_gebiet_first, &freies_gebiet_last,DL_CLEAN_UP);
  if (gebiet!=NULL)
   free(gebiet);
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

#define REPAIR_TEST_EXIT                                                                      \
   if (fehler>0)                                                                              \
   {                                                                                          \
    if (flag==UPDATE_VISIBLE_BACK_RECT)                                                       \
    {                                                                                         \
     d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);              \
    }                                                                                         \
    free_gebiete();                                                                           \
    T_DEBUG_FUNCTION_POSITION(100)                                                            \
    T_DEBUG_LEAVE                                                                             \
    return fehler;                                                                            \
   }

/* bringt fenster nach vorne oder loescht ein fenster */
/* es wird nicht alles neu aufgebaut, sondern nur */
/* wenn ein fenster geloescht wird, dann muessen die fenster die repariert werden sollen */
/* auch Unter dem fenster sein, notfalls muss es erst aktiviert werden */
/* die teile, die bisher verdeckt wahren */
/* (es sei denn flag=FORCED) */
/* bei fehler wird noch nichts befreit !!! */

T_INT repair_screen(WINDOW_LISTEN_ELEMENT *this_window, T_INT flag,T_INT border_x,T_INT border_y,
                  T_INT len_x, T_INT len_y)
{
 T_LISTE *window_liste = d_get_list_pos(this_window,window_first);
 /*listen element, das this_window als objekt hat */
 WINDOW_LISTEN_ELEMENT dummy_window;
 T_INT fehler=T_OK;
 T_DEBUG_ENTRY("repair_screen",40)
 free_gebiete();
 if ((this_window==NULL)&&(flag!=UPDATE_VISIBLE_BACK_RECT))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 switch (flag)
 {
  case REPAIR_BORDER:
  {
   T_INT breite=0;
   T_INT hoehe=0;
   T_INT x=0,y=0;
   if ((abs(border_x-this_window->x)>this_window->b)||(abs(border_y-this_window->y)>this_window->h))
   {
    window_liste=window_first;
    dummy_window.x=this_window->x;
    dummy_window.y=this_window->y;
    dummy_window.b=this_window->b;
    dummy_window.h=this_window->h;
    d_fuege_in_liste_ein(&dummy_window,&window_first,&window_last,DL_VORNE);
    window_liste=window_first;
    fehler+=insert(this_window->x,this_window->y,this_window->b,this_window->h,this_window);
    REPAIR_TEST_EXIT
    process_gebiets_liste(window_liste,REPAIR,this_window);
    d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
    T_DEBUG_FUNCTION_POSITION(2)
    T_DEBUG_LEAVE
    return fehler;
   }
   else
   {
    window_liste=window_first;
    dummy_window.x=this_window->x+(border_x-this_window->x);
    dummy_window.y=this_window->y+(border_y-this_window->y);
    dummy_window.b=this_window->b+abs(this_window->x-border_x);
    dummy_window.h=this_window->h+abs(this_window->y-border_y);
    d_fuege_in_liste_ein(&dummy_window,&window_first,&window_last,DL_VORNE);
    window_liste=window_first;
    if (border_x==this_window->x)
    {
     if (border_y==this_window->y)
     {
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(3)
      T_DEBUG_LEAVE
      return fehler;
     }
     if (border_y>this_window->y)
     {
      x=this_window->x;
      y=this_window->y;
      breite=this_window->b;
      hoehe=border_y-this_window->y;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(4)
      T_DEBUG_LEAVE
      return fehler;
     }
     if (border_y<this_window->y)
     {
      x=this_window->x;
      y=border_y+this_window->h;
      breite=this_window->b;
      hoehe=this_window->y-border_y;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(5)
      T_DEBUG_LEAVE
      return fehler;
     }
    }
    if (border_x>this_window->x)
    {
     if (border_y==this_window->y)
     {
      x=this_window->x;
      y=this_window->y;
      breite=border_x-this_window->x;
      hoehe=this_window->h;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(6)
      T_DEBUG_LEAVE
      return fehler;
     }
     if (border_y>this_window->y)
     {
      x=this_window->x;
      y=this_window->y;
      breite=this_window->b;
      hoehe=border_y-this_window->y;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      x=this_window->x;
      y=this_window->y+hoehe;
      breite=border_x-this_window->x;
      hoehe=this_window->h-(border_y-this_window->y);
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(7)
      T_DEBUG_LEAVE
      return fehler;
     }
     if (border_y<this_window->y)
     {
      x=this_window->x;
      y=this_window->y;
      breite=border_x-this_window->x;
      hoehe=this_window->h;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      x=border_x;
      y=border_y+this_window->h;
      breite=this_window->b-(border_x-this_window->x);
      hoehe=this_window->y-border_y;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(8)
      T_DEBUG_LEAVE
      return fehler;
     }
    }
    if (border_x<this_window->x)
    {
     if (border_y==this_window->y)
     {
      x=border_x+this_window->b;
      y=this_window->y;
      breite=this_window->x-border_x;
      hoehe=this_window->h;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(9)
      T_DEBUG_LEAVE
      return fehler;
     }
     if (border_y>this_window->y)
     {
      x=this_window->x;
      y=this_window->y;
      breite=this_window->b;
      hoehe=border_y-this_window->y;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      x=border_x+this_window->b;
      y=border_y;
      breite=this_window->x-border_x;
      hoehe=this_window->h-(border_y-this_window->y);
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(10)
      T_DEBUG_LEAVE
      return fehler;
     }
     if (border_y<this_window->y)
     {
      x=border_x+this_window->b;
      y=this_window->y;
      breite=this_window->x-border_x;
      hoehe=this_window->h;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      x=this_window->x;
      y=border_y+this_window->h;
      breite=this_window->b-(this_window->x-border_x); // this_window->b-breite
      hoehe=this_window->y-border_y;
      fehler+=insert(x,y,breite,hoehe,this_window);
      REPAIR_TEST_EXIT
      process_gebiets_liste(window_liste,flag,this_window);
      d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
      T_DEBUG_FUNCTION_POSITION(11)
      T_DEBUG_LEAVE
      return fehler;
     }
    }
   }
   T_DEBUG_FUNCTION_POSITION(12)
   T_DEBUG_LEAVE
   return fehler;
  }
  case LOWER_WINDOW:
  case REPAIR:
  case REDRAW_WINDOW:
  case LOWER_TILL_BACKDROP:
  case HIDE_WINDOW:
  {
   window_liste=window_first;
   dummy_window.x=this_window->x;
   dummy_window.y=this_window->y;
   dummy_window.b=this_window->b;
   dummy_window.h=this_window->h;
   d_fuege_in_liste_ein(&dummy_window,&window_first,&window_last,DL_VORNE);
   window_liste=window_first;
   fehler+=insert(this_window->x,this_window->y,this_window->b,this_window->h,this_window);
   REPAIR_TEST_EXIT
   process_gebiets_liste(window_liste,flag,this_window);
   d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
   T_DEBUG_FUNCTION_POSITION(13)
   T_DEBUG_LEAVE
   return fehler;
  }
  case UPDATE_VISIBLE_WINDOW_RECT:
  {
   fehler=insert(border_x,border_y,len_x,len_y,this_window);
   REPAIR_TEST_EXIT
   process_gebiets_liste(window_liste,flag,this_window);
   break;
  }
  case UPDATE_VISIBLE_BACK_RECT:
  {
   dummy_window.x=border_x;
   dummy_window.y=border_y;
   dummy_window.b=len_x;
   dummy_window.h=len_y;
   d_fuege_in_liste_ein(&dummy_window,&window_first,&window_last,DL_VORNE);
   window_liste=window_first;
   this_window=(WINDOW_LISTEN_ELEMENT *)window_first->objekt;
   fehler+=insert(border_x,border_y,len_x,len_y,this_window);
   REPAIR_TEST_EXIT
   process_gebiets_liste(window_liste,flag,this_window);
   d_entferne_aus_liste(&dummy_window,&window_first,&window_last,DL_CLEAN_UP);
   T_DEBUG_FUNCTION_POSITION(14)
   T_DEBUG_LEAVE
   return fehler;
  }
  case ACTIVATE:
  {
   fehler+=insert(this_window->x,this_window->y,this_window->b,this_window->h,this_window);
   REPAIR_TEST_EXIT
   process_gebiets_liste(window_liste,flag,this_window);
   break;
  }
  case FORCED:
  {
   is_upper=T_TRUE;
   print_mem_bild(this_window->window_pic,this_window->x,this_window->y);
   is_upper=T_FALSE;
   T_DEBUG_FUNCTION_POSITION(14)
   T_DEBUG_LEAVE
   return T_OK;
  }
 }
 T_DEBUG_LEAVE
 return fehler;
}

/***************************************************************/

T_INT touching_windows(T_INT x,T_INT y,T_INT b,T_INT h, WINDOW_LISTEN_ELEMENT *window)
{
 T_LISTE *window_liste=window_first;
/* fuer back button print unter fenster weggemacht 5.2.96
 if (window==NULL)
  return T_FALSE;
*/
 T_DEBUG_ENTRY("touching_windows",40)
 if ((window->hide)||(window->dhide))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_TRUE;
 }
 while (window_liste!=NULL)
 {
  if ((window==NULL) || ( ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)!=window) )
  {
   if ((((( (WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x>=x)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x+b))
       ||((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->b>=x)))
       &&(((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y>=y)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y+h))
       ||((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->h>=y))))
/*
if (((( (WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x>=x)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x+b)
       ||(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->b>=x))
       &&((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y>=y)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y+h)
       ||(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y)
       &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->h>=y)))
*/
   {
    if ((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide==0)&&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->dhide==0))
    {
     T_DEBUG_FUNCTION_POSITION(2)
     T_DEBUG_LEAVE
     return T_TRUE;
    }
   }
  }
  window_liste=window_liste->naechstes;
 }
 T_DEBUG_LEAVE
 return T_FALSE;
}

T_INT touching_upper_windows(T_INT x,T_INT y,T_INT b,T_INT h, WINDOW_LISTEN_ELEMENT *window)
{
 T_LISTE *window_liste=d_get_list_pos(window,window_first)->letztes;
 T_DEBUG_ENTRY("touching_upper_windows",40)
 if (window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 if ((window->hide)||(window->dhide))
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return T_TRUE;
 }
 if (window==window_first->objekt)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 while (window_liste!=NULL)
 {
  if (((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x>=x)
  &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x+b)
  ||(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x)
  &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->b>=x))
  &&((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y>=y)
      &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y+h)
      ||(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y)
      &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y
      +((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->h>=y))   )
    if ((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide==0)&&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->dhide==0))
    {
     T_DEBUG_FUNCTION_POSITION(4)
     T_DEBUG_LEAVE
     return T_TRUE;
    }
  window_liste=window_liste->letztes;
 }
 T_DEBUG_LEAVE
 return T_FALSE;
}

T_INT touching_lower_windows(T_INT x,T_INT y,T_INT b,T_INT h, WINDOW_LISTEN_ELEMENT *window)
{
 T_LISTE *window_liste=d_get_list_pos(window,window_first)->naechstes;
 T_DEBUG_ENTRY("touching_lower_windows",40)
 if (window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 if ((window->hide)||(window->dhide))
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return T_TRUE;
 }
 if (window==window_last->objekt)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 while (window_liste!=NULL)
 {
  if (((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x>=x)
  &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x+b)
  ||(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x<=x)
  &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->b>=x))
  &&((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y>=y)
  &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y+h)
  ||(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y<=y)
  &&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->h>=y)) )
    if ((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide==0)&&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->dhide==0))
    {
     T_DEBUG_FUNCTION_POSITION(4)
     T_DEBUG_LEAVE
     return T_TRUE;
    }
  window_liste=window_liste->naechstes;
 }
 T_DEBUG_LEAVE
 return T_FALSE;
}

/***************************************************************/

T_VOID redraw_all_windows(T_VOID)
{
 T_LISTE *window_liste=window_last;
 T_DEBUG_ENTRY("redraw_all_windows",40)
 if (window_first!=NULL)
  if ((((WINDOW_LISTEN_ELEMENT *)window_first->objekt)->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW)
   update_whole_window((WINDOW_LISTEN_ELEMENT *)window_first->objekt);
 while (window_liste!=NULL)
 {
  if ((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide==0)&&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->dhide==0))
   repair_screen(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt),FORCED,0,0,0,0);
  window_liste=window_liste->letztes;
 }
 T_DEBUG_LEAVE
 return;
}

/***************************************************************/

/* schliesst alle geoeffneten (auch versteckte) fenster */
T_VOID close_all_windows(T_VOID)
{
 T_DEBUG_ENTRY("close_all_windows",40)
 while (window_last!=NULL)
 {
  close_window((WINDOW_LISTEN_ELEMENT *)window_last->objekt,CLOSE_SHUTDOWN);
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

/* liefert wahrheitswert, ob ein fenster schon existiert */
T_INT window_exist(T_INT window_id)
{
 T_LISTE *window_liste=window_first;
 T_DEBUG_ENTRY("window_exist",40)
 while (window_liste!=NULL)
 {
  if (((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->id==window_id)
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return T_TRUE;
  }
  window_liste=window_liste->naechstes;
 }
 T_DEBUG_LEAVE
 return T_FALSE;
}

/***************************************************************/

/* aktiviert fenster, d.h. es wird nach oben geholt */
T_INT aktivate_window_id(T_INT window_id)
{
 T_LISTE *window_liste=window_first;
 T_DEBUG_ENTRY("aktivate_window_id",40)
 while (window_liste!=NULL)
 {
  if (((WINDOW_LISTEN_ELEMENT*)window_liste->objekt)->id==window_id)
  {
   aktivate_window((WINDOW_LISTEN_ELEMENT*)window_liste->objekt);
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return T_OK;
  }
  window_liste=window_liste->naechstes;
 }
 T_DEBUG_LEAVE
 return WINDOW_NOT_AVAILABLE;
}

/***************************************************************/

/* speichert den gesamten inhalt eines fensters neu ab */
T_INT update_whole_window(WINDOW_LISTEN_ELEMENT *this_window)
{
 T_DEBUG_ENTRY("update_whole_window",40)
 if ((this_window!=NULL)&&(this_window->hide==0)&&(this_window->dhide==0))
 {
  if (this_window->window_pic!=NULL)
   free_mem_bild(this_window->window_pic);
  this_window->window_pic=lade_vga_nach_mem(this_window->x,this_window->y,this_window->b,this_window->h,0);
  if (this_window->window_pic==NULL)
  {
   T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   tool_exit(GENERIC_MEMORY_NOT_AVAILABLE);
//   return GENERIC_MEMORY_NOT_AVAILABLE;
  }
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_OK;
 }
 T_DEBUG_LEAVE
 return WINDOW_NOT_AVAILABLE;
}

/***************************************************************/

T_VOID aktivate_window(WINDOW_LISTEN_ELEMENT *this_window)
{
 T_LISTE *window_liste=window_first;
 T_DEBUG_ENTRY("aktivate_window",40)
 if (this_window==(WINDOW_LISTEN_ELEMENT *)window_first->objekt)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 if ((this_window==NULL)||(this_window->art & BACK_WINDOW))
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return;
 }
 if ((this_window->hide!=0)||(this_window->dhide!=0))
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return;
 }
 if (window_first!=NULL)
 {
  if (window_first->objekt!=NULL)
  {
   if (((((WINDOW_LISTEN_ELEMENT *)window_first->objekt)->art)&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW)
   {
    update_whole_window((WINDOW_LISTEN_ELEMENT *)window_first->objekt);
   }
  }
 }
 if ((this_window->art&VIRTUAL_FRONT_WINDOW)!=VIRTUAL_FRONT_WINDOW)
 {
  while ((window_liste!=NULL) &&( ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->art & FRONT_WINDOW) )
   window_liste=window_liste->naechstes;
  if (window_liste->objekt==(T_PVOID )this_window)
  {
   T_DEBUG_FUNCTION_POSITION(4)
   T_DEBUG_LEAVE
   return;
  }
  window_liste = d_get_list_pos(this_window,window_first);
  do
  {
   window_liste=window_liste->letztes;
   if ((window_liste!=NULL)&&( (((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->art & FRONT_WINDOW) == 0))
     d_vertausche_runter(window_liste->objekt,window_first);
  }
  while (window_liste!=NULL);
 } //if ((this_window&VIRTUAL_FRONT_WINDOW)!=VIRTUAL_FRONT_WINDOW)
 else
 {
  window_liste = d_get_list_pos(this_window,window_first);
  do
  {
   window_liste=window_liste->letztes;
   if (window_liste!=NULL)
    d_vertausche_runter(window_liste->objekt,window_first);
  }
  while (window_liste!=NULL);
 }
 repair_screen(this_window,REDRAW_WINDOW,0,0,0,0);
 T_DEBUG_LEAVE
}

/***************************************************************/

T_VOID lower_window(WINDOW_LISTEN_ELEMENT *this_window)
{
 T_LISTE *window_liste = window_last;
 T_DEBUG_ENTRY("lower_window",40)
 if ((window_last==NULL)||(this_window==NULL)||(this_window->art & FRONT_WINDOW))
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 if (window_last->objekt==(T_PVOID)this_window)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return;
 }
 if (window_first!=NULL)
  if (this_window==((WINDOW_LISTEN_ELEMENT *)window_first->objekt)&& ((((WINDOW_LISTEN_ELEMENT *)window_first->objekt)->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW))
   update_whole_window((WINDOW_LISTEN_ELEMENT *)window_first->objekt);
 while ((window_liste!=NULL) &&( ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->art & BACK_WINDOW) )
  window_liste=window_liste->letztes;
 if (window_liste==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return;
 }
 if (window_liste->objekt==(T_PVOID )this_window)
 {
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return;
 }
 window_liste = d_get_list_pos(this_window,window_first);
 repair_screen(this_window,LOWER_TILL_BACKDROP,0,0,0,0);
 do
 {
  window_liste=window_liste->naechstes;
  if ((window_liste!=NULL)&&( (((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->art & BACK_WINDOW) == 0))
   d_vertausche_hoch(window_liste->objekt,window_first);
 }
 while (window_liste!=NULL);
//  repair_screen(this_window,REDRAW_WINDOW,0,0,0,0);

/*
 if ((WINDOW_LISTEN_ELEMENT *)window_last->objekt!=this_window)
 {
  repair_screen(this_window,LOWER_WINDOW,0,0,0,0);
  d_entferne_aus_liste(this_window,&window_first, &window_last,DL_CLEAN_UP);
  d_fuege_in_liste_ein(this_window,&window_first, &window_last,DL_HINTEN);
 }
*/
 T_DEBUG_LEAVE
}

/***************************************************************/

WINDOW_LISTEN_ELEMENT *get_window(T_INT window_id)
{
 T_LISTE *window_liste=window_first;
 T_DEBUG_ENTRY("get_window",40)
 while (window_liste!=NULL)
 {
  if (((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->id==window_id)
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return (WINDOW_LISTEN_ELEMENT *)window_liste->objekt;
  }
  window_liste=window_liste->naechstes;
 }
 T_DEBUG_LEAVE
 return NULL;
}

/***************************************************************/

T_INT hide_raw_window(WINDOW_LISTEN_ELEMENT *this_window)
{
 T_DEBUG_ENTRY("hide_raw_window",40)
 if (this_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((this_window->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW)
 {
  aktivate_window(this_window);
  update_whole_window(this_window);
 }
 else
 {
  if ((this_window==((WINDOW_LISTEN_ELEMENT *)window_first->objekt)) && ((((WINDOW_LISTEN_ELEMENT *)window_first->objekt)->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW))
   update_whole_window((WINDOW_LISTEN_ELEMENT *)window_first->objekt);
 }
 this_window->hide++;
 if ((this_window->hide==1)&&(this_window->dhide==0))
 {
  windows_shown--;
  repair_screen(this_window,HIDE_WINDOW,0,0,0,0);
  if (this_window->update_funktion!=NULL)
   this_window->update_funktion(UPDATE_AFTER_HIDE,(T_PVOID)this_window);
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_INT show_raw_window(WINDOW_LISTEN_ELEMENT *this_window)
{
 T_DEBUG_ENTRY("show_raw_window",40)
 if (this_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 this_window->hide--;
 if ((this_window->hide==0)&&(this_window->dhide==0))
 {
  windows_shown++;
  if (window_first!=NULL)
   if (((WINDOW_LISTEN_ELEMENT *)window_first->objekt!=this_window)&&
      ((((WINDOW_LISTEN_ELEMENT *)window_first->objekt)->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW))
   {
    update_whole_window((WINDOW_LISTEN_ELEMENT *)window_first->objekt);
   }
  if ((this_window->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW)
  {
   aktivate_window(this_window);
  }
  if ((this_window==(WINDOW_LISTEN_ELEMENT *)window_first->objekt)
  ||(touching_upper_windows(this_window->x,this_window->y,this_window->b,this_window->h,this_window)
  ==T_FALSE))
   repair_screen(this_window,FORCED,0,0,0,0);
  else
   repair_screen(this_window,REDRAW_WINDOW,0,0,0,0);
  if (this_window->update_funktion!=NULL)
   this_window->update_funktion(UPDATE_AFTER_SHOW,(T_PVOID)this_window);
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

T_VOID hide_all_windows(T_VOID)
{
 T_LISTE *window_liste=window_first;
 T_LISTE *naechstes;
 WINDOW_LISTEN_ELEMENT *window;
 T_DEBUG_ENTRY("hide_all_windows",40)
 if (window_liste==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return;
 }
 window=((WINDOW_LISTEN_ELEMENT *)window_liste->objekt);
 if ((window->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW)
 {
  update_whole_window(window);
 }
 while (window_liste!=NULL)
 {
  window=((WINDOW_LISTEN_ELEMENT *)window_liste->objekt);
  naechstes=window_liste->naechstes;
  if ((window->hide==0)&&(window->dhide==0))
  {
   windows_shown--;
   repair_screen(window,REPAIR,0,0,0,0);
   if (window->update_funktion!=NULL)
    window->update_funktion(UPDATE_AFTER_HIDE,(T_PVOID)(window));
  }
  window->hide++;
  window_liste=naechstes;
 }
 T_DEBUG_LEAVE
}

/***************************************************************/
#define ALLREADY_DONE (-1)
T_VOID show_all_windows(T_VOID)
{
 T_LISTE *window_liste=window_last;
 T_LISTE *naechstes;
 T_DEBUG_ENTRY("show_all_windows",40)
 while (window_liste!=NULL)
 {
  WINDOW_LISTEN_ELEMENT *window= (WINDOW_LISTEN_ELEMENT *)window_liste->objekt;
  naechstes=window_liste->letztes;
  if (window->hide==ALLREADY_DONE)
  {
   window->hide=0;
  }
  else
  {
   if (window->hide>0)
   {
    window->hide--;
    if ((window->hide==0)&&(window->dhide==0))
    {
     windows_shown++;
/*
     if (( window->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW )
     {

      aktivate_window(window);
      repair_screen(window,FORCED,0,0,0,0);
      if (window->update_funktion!=NULL)
       window->update_funktion(UPDATE_AFTER_SHOW,(T_PVOID)(window));
      if (naechstes!=NULL)
      {
       window->hide=ALLREADY_DONE;
       naechstes=window_liste; // weil dieses nach vorne kam, ist das naechste zu berabeitende
                               // Fenster eins nach hinten gerutscht, ist also jetzt auf dem
                               // Platz von diesem... (tricky)
      }
     }
     else
*/
     {
      repair_screen(window,FORCED,0,0,0,0);
      if (window->update_funktion!=NULL)
       window->update_funktion(UPDATE_AFTER_SHOW,(T_PVOID)(window));
     }
    }
   }
  }
  window_liste=naechstes;
 }
 T_DEBUG_LEAVE
}

/***************************************************************/

/* liefert einen wahrheitswert, ob sich die maus auf dem angegebenen fenster */
/* befinden */
T_INT is_mouse_on_this_window(WINDOW_LISTEN_ELEMENT *this_window)
{
 T_INT m_x=vesa_mouse_x,m_y=vesa_mouse_y;
 T_DEBUG_ENTRY("is_mouse_on_this_window",40)
 if (this_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 if ((this_window->hide>0)||(this_window->dhide>0))
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_FALSE;
 }
 if ( ((m_x>this_window->x)&&(m_x<this_window->x+this_window->b))&&((m_y>this_window->y)
 &&(m_y<this_window->y+this_window->h)))
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return T_TRUE;
 }
 T_DEBUG_LEAVE
 return T_FALSE;
}

/***************************************************************/

/* gibt das fenster zurueck, auf dem die maus sich befindet */
/* oder NULL */
WINDOW_LISTEN_ELEMENT *is_mouse_on_window(T_VOID)
{
 T_INT m_x=vesa_mouse_x,m_y=vesa_mouse_y;
 T_LISTE *window_liste=window_first;
 T_DEBUG_ENTRY("is_mouse_on_window",40)
 while (window_liste!=NULL)
 {
  if ((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide==0)&&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->dhide==0))
  {
   if ( ((m_x>((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x)
   &&(m_x<((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->b))
   &&((m_y>((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y)
   &&(m_y<((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y+((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->h)))
   {
    T_DEBUG_FUNCTION_POSITION(1)
    T_DEBUG_LEAVE
    return ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt);
   }
  }
  window_liste=window_liste->naechstes;
 }
 T_DEBUG_LEAVE
 return NULL;
}


/***************************************************************/
static T_INT win_pos_x;
static T_INT win_pos_y;
static PARSER_WORD parse_hilfe[]=
{
 {PARSER_TYPE_SINT,"WIN_POS_X",&win_pos_x,0},
 {PARSER_TYPE_SINT,"WIN_POS_Y",&win_pos_y,0},
 {PARSER_TYPE_END,NULL,NULL}
};

WINDOW_LISTEN_ELEMENT *open_window(OPEN_WIN *w)
{
 static T_INT id=1;
 WINDOW_LISTEN_ELEMENT *this_window=NULL;
 T_INT len_x,len_y;
 T_INT name_size=0, button_size=0, name_sizex=0;
 T_INT name_offset=0,button_offset=0;
 T_INT next_button_x_pos;
 T_INT next_button_y_pos;
 T_DEBUG_ENTRY("open_window",40)
 if (vesa_modus_active==0)
 {
  win_raw_error=WINDOW_NO_GRAPHICS_MODE_ACTIVE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(WINDOW_NO_GRAPHICS_MODE_ACTIVE)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return NULL;
 }
 if (w->id==WIN_OPEN_CHOOSES_ID)
  id=1;
 if (back_save(NOT_FORCED_SAVE)!=T_OK)
 {
  win_raw_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return NULL;
 }
 if (w->id!=0)
 {
  if (window_exist(w->id)==T_TRUE)
  {
   win_raw_error=WINDOW_DOUBLE_ID;
   T_DEBUG_SET_THIS_FUNCTION_ERROR(WINDOW_DOUBLE_ID)
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return NULL;
  }
  id=w->id;
 }
 while (window_exist(id))
 {
  id++;
  if (id==WIN_OPEN_CHOOSES_ID)
   id=1;
 }
 if ((w->art & RETURNING)&&(w->destructor==NULL))
 {
  show_message("Return Window ohne Destructor (NOT created)!");
  T_DEBUG_FUNCTION_POSITION(4)
  T_DEBUG_LEAVE
  return NULL;
 }
 if ((w->art & RETURNING)&&(w->variablen==NULL))
 {
  show_message("Return Window ohne Ebenen Information (NOT created)!");
  T_DEBUG_FUNCTION_POSITION(5)
  T_DEBUG_LEAVE
  return NULL;
 }
 if ((this_window=(WINDOW_LISTEN_ELEMENT *)malloc(sizeof(WINDOW_LISTEN_ELEMENT)))==NULL)
 {
  win_raw_error=GENERIC_MEMORY_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(6)
  T_DEBUG_LEAVE
  return NULL;
 }
 if (w->name!=NULL)
 {
  if (w->name[0]!='!')
  {
   vesa_get_text_len(w->name,&len_x,&len_y);
   name_size=len_y;
   name_sizex=len_x;
  }
 }
 else
  len_y=-5;
 if( ((w->art&WITH_CLOSE_BUTTON)==WITH_CLOSE_BUTTON) ||
     ((w->art&WITH_DRAG_BUTTON)==WITH_DRAG_BUTTON)   ||
     ((w->art&WITH_HIDE_BUTTON)==WITH_HIDE_BUTTON)
   )
 {
  if ((default_button_size+1)>len_y)
   len_y=(default_button_size+1);
  if (name_size>(default_button_size+1))
   button_offset=(name_size-(default_button_size+1))/2;
  if (name_size<(default_button_size+1))
   name_offset=((default_button_size+1)-name_size)/2;
  button_size=default_button_size;
 }
 if (w->x_pos<0)
  w->x_pos=(vesa_x+w->x_pos)-(2*w->border+w->breite);
 if (w->y_pos<0)
  w->y_pos=(vesa_y+w->y_pos)-(2*w->border+w->hoehe);

 // totally fucked coordinates
 if (w->x_pos<0)
  w->x_pos=0;
 if (w->y_pos<0)
  w->y_pos=0;
 if (w->x_pos>vesa_x-2)
  w->x_pos=0;
 if (w->y_pos>vesa_y-2)
  w->y_pos=0;

 if (w->y_pos+w->hoehe+2*2*w->border+len_y+5>=vesa_y)
 {
  w->hoehe=vesa_y-2*w->border-(len_y+5)-w->y_pos;
 }
 if (w->x_pos+w->breite+2*w->border>=vesa_x)
 {
  w->breite=vesa_x-2*w->border-w->x_pos;
 }
 // * default font, now 8, 16 fixed for editing
 if (w->art&EDIT_TRUE)
 {
  w->hoehe=((w->hoehe)/font_now->zeichen[' '].hoehe)*font_now->zeichen[' '].hoehe;
  w->breite=((w->breite)/font_now->zeichen[' '].breite)*font_now->zeichen[' '].breite;
 }
 this_window->id=id;
 this_window->update_funktion=NULL;
 this_window->color=w->color;
 this_window->bcolor=w->bcolor;
 this_window->x_org=this_window->x=w->x_pos;
 this_window->y_org=this_window->y=w->y_pos;
 this_window->border_o=w->border;
 this_window->border_u=w->border;
 this_window->border_l=w->border;
 this_window->border_r=w->border;
 this_window->hide=0;
 this_window->dhide=0; // for dispatcher hiding only!!!
 this_window->art=w->art;
 this_window->variablen=w->variablen;
 if (w->name!=NULL)
 {
  this_window->name=strdup(w->name);
 }
 else
  this_window->name=NULL;
 this_window->x_0=this_window->border_l;
 this_window->y_0=this_window->border_o+len_y+5;
 this_window->button_first=NULL;
 this_window->button_last=NULL;
 this_window->destructor=w->destructor;
 this_window->parameter=NULL;
 this_window->area_funktion=w->area_funktion;
 this_window->tasten_funktion=w->tasten_funktion;

 this_window->b=w->breite + this_window->border_r + this_window->border_l;
 this_window->h=w->hoehe + this_window->border_o + this_window->border_u+len_y+5;
 this_window->b_open=w->breite;
 this_window->h_open=w->hoehe;


 if (this_window->art&REMEMBER)
 {
  T_CHAR filename[8+1+3+1];
  T_UINT i=0;
  T_INT c=0;
  T_PCHAR current_path=NULL;
  T_DEBUG_PROTOCOLL(("open_window(), reading window stuff, name:%s",this_window->name))
  filename[0]=0;
  if (this_window->name!=NULL)
  {
   while (*(this_window->name+c)!=(T_CHAR)0)
   {
    i+=(T_UINT)*(this_window->name+c);
    c++;
   }
  }
  i+=this_window->x_org
    +this_window->y_org
    +this_window->b
    +this_window->h
    +this_window->b_open
    +this_window->h_open
    -this_window->x_0
    -this_window->y_0
    +this_window->art
    -this_window->border_o
    -this_window->border_u
    -this_window->border_l
    -this_window->border_r
    +vesa_x
    +vesa_y;
  while (i>999999) i=i/2;
  itoa(i,filename,10);
  while (strlen(filename)<8)
   strcat(filename,"_");
  strcat(filename,".win");
  T_DEBUG_PROTOCOLL(("open_window(), reading window stuff, name:%s, filename:%s",this_window->name, filename))
  current_path=get_current_path();
  if (tool_pfad!=NULL)
   change_directory(tool_pfad);
  if (f_file_exist(filename)==T_TRUE)
  {
   T_DEBUG_PROTOCOLL(("open_window(), reading window stuff, name:%s, filename:%s FOUND !!!",this_window->name, filename))
   p_parse_init();
   win_pos_x=-1;
   win_pos_y=-1;
   if (p_parse(filename,parse_hilfe)!=T_OK)
   {
    t_printf(E_VERBOSE_NONE,"%i\n",parse_error);
    t_printf(E_VERBOSE_NONE,"Something wrong in internal Window save file!!!\n");
   }
   if ((win_pos_x!=-1)&&(win_pos_y!=-1))
   {
    this_window->x=win_pos_x;
    this_window->y=win_pos_y;
   }
  }
  else
  {
   T_DEBUG_PROTOCOLL(("open_window(), reading window stuff, name:%s, filename:%s NOT FOUND !!!",this_window->name, filename))
  }
  if (current_path!=NULL)
  {
   change_directory(current_path);
   free(current_path);
   current_path=NULL;
  }
 }
 MOUSE_VERSTECKE
 if (window_first!=NULL)
 {
  if ((((WINDOW_LISTEN_ELEMENT *)window_first->objekt)->art&VIRTUAL_FRONT_WINDOW)==VIRTUAL_FRONT_WINDOW)
  {
   update_whole_window((WINDOW_LISTEN_ELEMENT *)window_first->objekt);
  }
 }
 switch ( (w->art) & (RAW_WINDOW|MEM_PIC_WINDOW|PCX_WINDOW) )
 {
  case RAW_WINDOW:
  {
   if ((w->x_pos+w->breite+2*w->border>vesa_x)||(w->y_pos+w->hoehe+2*w->border+len_y+5>vesa_y))
   {
    show_message("Window doesn't fit on Screen (NOT created)!");
    MOUSE_ZEIGE
    T_DEBUG_FUNCTION_POSITION(7)
    T_DEBUG_LEAVE
    return NULL;
   }

   /* for a backdrop the following is prob wrong!!! */
   vesa_rect_fill(this_window->x,this_window->y,this_window->b,this_window->h,w->bcolor);
   if (len_y!=-5)
    vesa_line_h(this_window->x+this_window->border_r,this_window->y+2+2+len_y+this_window->border_o,w->breite,w->color);

   if ((w->name!=NULL)&&(w->name[0]!='!'))
   {
    T_INT old_print_modus;
    T_INT old_text;
    T_INT old_back_color;
    T_INT old_text_color;

    T_INT px=this_window->x+2+this_window->border_r;
    T_INT py=this_window->y+2+this_window->border_o+name_offset;
    old_print_modus=vesa_print_modus;
    old_text=vesa_text;
    old_back_color=vesa_back_color;
    old_text_color=vesa_text_color;

    vesa_print_modus=PIC_FILLED;
    vesa_text=SINGLE_COLOR;
    vesa_back_color=this_window->bcolor;
    vesa_text_color=this_window->color;
    vesa_print_string_max(0,0,px,py,this_window->b-this_window->border_r-this_window->border_l-2-2,this_window->h-this_window->border_o-this_window->border_u-2-2,this_window->name);
    vesa_print_modus=old_print_modus;
    vesa_text=old_text;
    vesa_back_color=old_back_color;
    vesa_text_color=old_text_color;
   }
   this_window->window_pic=lade_vga_nach_mem(this_window->x,this_window->y,this_window->b,this_window->h,ALL_MEM_OK);
   if (this_window->window_pic==NULL)
   {
    MOUSE_ZEIGE
    free(this_window);
    win_raw_error=GENERIC_MEMORY_NOT_AVAILABLE;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
    T_DEBUG_FUNCTION_POSITION(8)
    T_DEBUG_LEAVE
    return NULL;
   }
#ifdef VECTREX
   {
    T_INT x,y;
    this_window->update_funktion=update_function;
    this_window->last_x=this_window->x;
    this_window->last_y=this_window->y;
    if (clip_memory!=NULL)
    {
     for (y=this_window->y;y<this_window->y+this_window->h;y++)
     {
      for (x=this_window->x;x<this_window->x+this_window->b;x++)
      {
       *(clip_memory+(vesa_bytes_per_scanline*y)+x)+=2;
      }
     }
    }
   }
#endif
   d_fuege_in_liste_ein(this_window,&window_first, &window_last,DL_VORNE);

   if (this_window->art&BACK_WINDOW)
    lower_window(this_window);
   else
    aktivate_window(this_window);

//   wprint_frect(this_window,0+this_window->border_r,0+this_window->border_o,w->breite,w->hoehe+len_y+5,w->bcolor);
   next_button_x_pos=(this_window->b)-this_window->border_r-2;
   next_button_y_pos=(0)+this_window->border_o+2+button_offset;
   break;
  }

// bei anderen arten noch auf BACKDROP und FRONTWINDOW ausrichten
/*

noch keine Titel gemachT !!!

  case MEM_PIC_WINDOW:
  {
   if (w->mem_bild==NULL)
   {
    show_message("Kein MEM_BILD bei MEM_BILD Window!");
    MOUSE_ZEIGE
    T_DEBUG_FUNCTION_POSITION(9)
    T_DEBUG_LEAVE
    return NULL;
   }
   if ((w->x_pos+w->mem_bild->x_size+2*w->border>vesa_x)
   ||(w->y_pos+w->mem_bild->y_size+2*w->border>vesa_y))
   {
    show_message("Window doesn't fit on Screen (NOT created)!");
    MOUSE_ZEIGE
    T_DEBUG_FUNCTION_POSITION(10)
    T_DEBUG_LEAVE
    return NULL;
   }
   this_window->b=w->mem_bild->x_size + this_window->border_r+ this_window->border_l;
   this_window->h=w->mem_bild->y_size + this_window->border_o+ this_window->border_u;
   vesa_draw_shaded_rectangle(this_window->x,this_window->y,this_window->b,this_window->h,w->bcolor,w->bcolor,w->border);
   print_mem_bild(w->mem_bild,this_window->x+w->border,this_window->y+w->border);
   this_window->window_pic=lade_vga_nach_mem(this_window->x,this_window->y,this_window->b,this_window->h,ALL_MEM_OK);
   if (this_window->window_pic==NULL)
   {
    free(this_window);
    MOUSE_ZEIGE
    win_raw_error=GENERIC_MEMORY_NOT_AVAILABLE;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
    T_DEBUG_FUNCTION_POSITION(11)
    T_DEBUG_LEAVE
    return NULL;
   }
   d_fuege_in_liste_ein(this_window,&window_first, &window_last,DL_HINTEN);
   aktivate_window(this_window);
   break;
  }
  case PCX_WINDOW:
  {
   MEM_BILD *window_pic;
   window_pic=lade_pcx_nach_mem(w->pcx_bild,ALL_MEM_OK);
   if (window_pic==NULL)
   {
    show_message("Konnte PCX-Datei nicht laden (NOT created)");
    MOUSE_ZEIGE
    T_DEBUG_FUNCTION_POSITION(12)
    T_DEBUG_LEAVE
    return NULL;
   }
   if ((w->x_pos+window_pic->x_size+2*w->border>vesa_x)||(w->y_pos+window_pic->y_size+2*w->border>vesa_y))
   {
    show_message("Window doesn't fit on Screen (NOT created)!");
    MOUSE_ZEIGE
    T_DEBUG_FUNCTION_POSITION(13)
    T_DEBUG_LEAVE
    return NULL;
   }
   this_window->b=window_pic->x_size + this_window->border_r+ this_window->border_l;
   this_window->h=window_pic->y_size + this_window->border_o+ this_window->border_u;
   vesa_draw_shaded_rectangle(this_window->x,this_window->y,this_window->b,this_window->h,w->bcolor,w->bcolor,w->border);
   print_mem_bild(window_pic,this_window->x+w->border,this_window->y+w->border);
   free_mem_bild(window_pic);
   this_window->window_pic=lade_vga_nach_mem(this_window->x,this_window->y,this_window->b,this_window->h,ALL_MEM_OK);
   if (this_window->window_pic==NULL)
   {
    MOUSE_ZEIGE
    free(this_window);
    win_raw_error=GENERIC_MEMORY_NOT_AVAILABLE;
    T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
    T_DEBUG_FUNCTION_POSITION(14)
    T_DEBUG_LEAVE
    return NULL;
   }
   d_fuege_in_liste_ein(this_window,&window_first, &window_last,DL_HINTEN);
   aktivate_window(this_window);
   break;
  }
*/
  default:
  {
   show_message("Unbekannte Window Art (NOT created)!");
   MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(15)
   T_DEBUG_LEAVE
   return NULL;
  }
 }
 windows_open++;
 windows_shown++;
 /* line width... */
 next_button_y_pos-=2;
 if ((w->art&WITH_CLOSE_BUTTON)==WITH_CLOSE_BUTTON)
 {
  BUTTON *button=NULL;
  T_PCHAR current_path=NULL;
  current_path=get_current_path();
  if (tool_pfad!=NULL)
   change_directory(tool_pfad);
  button = make_mem_bild_button(close_pic,default_back_pixel,
  button_color3, button_color4,button_color5,button_color6,2,KEY_ESCAPE,SWITCH_ON_RELEASED);
  if (current_path!=NULL)
  {
   change_directory(current_path);
   free(current_path);
  }
  if (button==NULL)
  {
   MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(16)
   T_DEBUG_LEAVE
   return this_window;
  }
  button_raw=T_TRUE;
  // line width...
  next_button_x_pos-=((2*2+default_button_size+2));
  if (next_button_x_pos<(this_window->border_r+this_window->x_0))
   next_button_x_pos=(this_window->border_r+this_window->x_0);
  is_upper=T_TRUE;
  add_wbutton(this_window,button,next_button_x_pos,next_button_y_pos,0);
  next_button_x_pos-=CLOSE_SEPERATOR;
  is_upper=T_FALSE;
  button_raw=T_FALSE;
  button->button_funktion=execute_close_button;
 }
 if ((w->art&WITH_HIDE_BUTTON)==WITH_HIDE_BUTTON)
 {
  BUTTON *button=NULL;
  T_PCHAR current_path=NULL;
  current_path=get_current_path();
  if (tool_pfad!=NULL)
   change_directory(tool_pfad);
  button = make_mem_bild_button(hide_pic,default_back_pixel,
  button_color3, button_color4,button_color5,button_color6,2,KEY_H,SWITCH_ON_RELEASED);
  if (current_path!=NULL)
  {
   change_directory(current_path);
   free(current_path);
  }
  if (button==NULL)
  {
   MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(17)
   T_DEBUG_LEAVE
   return this_window;
  }
  button_raw=T_TRUE;
  // line width...
  next_button_x_pos-=(2*2+default_button_size+2);
  if (next_button_x_pos<(this_window->border_r+this_window->x_0))
   next_button_x_pos=(this_window->border_r+this_window->x_0);
  is_upper=T_TRUE;
  add_wbutton(this_window,button,next_button_x_pos,next_button_y_pos,0);
  is_upper=T_FALSE;
  button_raw=T_FALSE;
  button->button_funktion=execute_hide_button;
 }
 if ((w->art&WITH_DRAG_BUTTON)==WITH_DRAG_BUTTON)
 {
  BUTTON *button=NULL;
  T_PCHAR current_path=NULL;
  current_path=get_current_path();
  if (tool_pfad!=NULL)
   change_directory(tool_pfad);
  button = make_mem_bild_button(move_pic,default_back_pixel,
  button_color3, button_color4,button_color5,button_color6,2,0,SWITCH_ON_PRESSED);
  if (current_path!=NULL)
  {
   change_directory(current_path);
   free(current_path);
  }
  if (button==NULL)
  {
   MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(18)
   T_DEBUG_LEAVE
   return this_window;
  }
  button_raw=T_TRUE;
  // line width...
  next_button_x_pos-=(2*2+default_button_size+2);
  if (next_button_x_pos<(this_window->border_r+this_window->x_0))
   next_button_x_pos=(this_window->border_r+this_window->x_0);
  is_upper=T_TRUE;
  add_wbutton(this_window,button,next_button_x_pos,next_button_y_pos,0);
  is_upper=T_FALSE;
  button_raw=T_FALSE;
  button->button_funktion=execute_drag_button;
 }
 if (this_window!=window_first->objekt)
 {
  T_LISTE *window_liste=window_first;
  while (this_window!=window_liste->objekt)
  {
   if ((((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide==0)&&(((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->dhide==0))
   {
    repair_screen((WINDOW_LISTEN_ELEMENT *)window_liste->objekt,REDRAW_WINDOW,
    ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->x,
    ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->y,
    ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->b,
    ((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->h);
   }
   window_liste=window_liste->naechstes;
  }
 }
 MOUSE_ZEIGE
 T_DEBUG_LEAVE
 return this_window;
}

/***************************************************************/

T_INT close_window(WINDOW_LISTEN_ELEMENT *this_window,T_INT flag)
{
 BUTTON_LISTEN_ELEMENT *button=NULL;
 PARAMETER dummy;
 T_DEBUG_ENTRY("close_window",40)
 if ((this_window==NULL)||(!(window_exist(this_window->id))&&(flag!=FORCED)))
 {
  win_raw_error=WINDOW_NOT_AVAILABLE;
  T_DEBUG_SET_THIS_FUNCTION_ERROR(WINDOW_NOT_AVAILABLE)
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return WINDOW_NOT_AVAILABLE;
 }
 if (this_window->art&REMEMBER)
 {
  T_CHAR filename[8+1+3+1];
  FILE *handle;
  T_UINT i=0;
  T_INT c=0;
  T_PCHAR current_path=NULL;
  T_DEBUG_PROTOCOLL(("close_window(), saving window stuff, name:%s",this_window->name))
  filename[0]=0;
  if (this_window->name!=NULL)
  {
   while (*(this_window->name+c)!=(T_CHAR)0)
   {
    i+=(T_UINT)*(this_window->name+c);
    c++;
   }
  }
  i+=this_window->x_org
    +this_window->y_org
    +this_window->b
    +this_window->h
    +this_window->b_open
    +this_window->h_open
    -this_window->x_0
    -this_window->y_0
    +this_window->art
    -this_window->border_o
    -this_window->border_u
    -this_window->border_l
    -this_window->border_r
    +vesa_x
    +vesa_y;
  while (i>999999) i=i/2;
  itoa(i,filename,10);
  while (strlen(filename)<8)
   strcat(filename,"_");
  strcat(filename,".win");
  T_DEBUG_PROTOCOLL(("close_window(), winname:%s, saving to %s",this_window->name, filename))
  current_path=get_current_path();
  if (tool_pfad!=NULL)
   change_directory(tool_pfad);
  handle=fopen(filename,"wt");
  if (current_path!=NULL)
  {
   change_directory(current_path);
   free(current_path);
   current_path=NULL;
  }
  if (handle!=NULL)
  {
   fprintf(handle,  "# Automatic Window save file, do NOT edit or rename!!!");
   fprintf(handle,"\n# File for a window with following static attributes:");
   fprintf(handle,"\n#   NAME           : \"%s\"",this_window->name);
   fprintf(handle,"\n#   X ORIGINAL     : %i",this_window->x_org);
   fprintf(handle,"\n#   Y ORIGINAL     : %i",this_window->y_org);
   fprintf(handle,"\n#   WIDTH          : %i",this_window->b);
   fprintf(handle,"\n#   HIGHT          : %i",this_window->h);
   fprintf(handle,"\n#   OPEN WIDTH     : %i",this_window->b_open);
   fprintf(handle,"\n#   OPEN HIGHT     : %i",this_window->h_open);
   fprintf(handle,"\n#   INNER X OFFSET : %i",this_window->x_0);
   fprintf(handle,"\n#   INNER Y OFFSET : %i",this_window->y_0);
   fprintf(handle,"\n#   KIND           : %i",this_window->art);
   fprintf(handle,"\n#   UPPER BORDER   : %i",this_window->border_o);
   fprintf(handle,"\n#   LOWER BORDER   : %i",this_window->border_u);
   fprintf(handle,"\n#   LEFT BORDER    : %i",this_window->border_l);
   fprintf(handle,"\n#   RIGHT BORDER   : %i",this_window->border_r);

   fprintf(handle,"\n#");
   fprintf(handle,"\n# Position remembered last:");
   fprintf(handle,"\n#");
   fprintf(handle,"\nWIN_POS_X  : %i",this_window->x);
   fprintf(handle,"\nWIN_POS_Y  : %i",this_window->y);
   fprintf(handle,"\n#");
   fprintf(handle,"\n# EOF");
   fclose(handle);
  }
  else
  {
   T_DEBUG_PROTOCOLL(("close_window(), winname:%s, saving to %s, fileopen error! nothing done",this_window->name, filename))
  }
 }
 if (this_window->destructor!=NULL)
 {
  T_SINT ebene;
  T_SINT return_ebene;
  T_INT my_id;
  my_id=this_window->id;
  T_DEBUG_PROTOCOLL(("close_window(), destructor found (pre), name:%s",this_window->name))
  if (this_window->variablen!=NULL)
  {
   T_DEBUG_PROTOCOLL(("close_window(), Variablen != NULL (pre), name:%s",this_window->name))
   ebene=this_window->variablen->ebene;
  } // if (this_window->variablen!=NULL)
  else
  {
   T_DEBUG_PROTOCOLL(("close_window(), Variablen == NULL (pre), name:%s",this_window->name))
   ebene=-1;
  }
  if (this_window->parameter==NULL)
  {
   // this is for not returning windows,
   // which need a destructor nonetheless
   // (help windows for example, to free the button link information)
   //
   /* new in 1998, not sure about it, since parameter is getting weirder */
   /* by the minute this is a patch for close_all since in that case */
   /* parameter is not set at all (or so it seems), the window gets */
   /* deleted two times, which bothers memory management... */
   T_DEBUG_PROTOCOLL(("close_window(), Parameter == NULL (pre), name:%s",this_window->name))
   dummy.window_element=this_window;
   dummy.ebene=ebene;
   this_window->parameter=&dummy;
  }
  else
  {
   T_DEBUG_PROTOCOLL(("close_window(), Parameter != NULL (pre), name:%s",this_window->name))
   if (this_window->parameter->window_element==NULL)
   {
    t_printf(E_VERBOSE_NONE,"WARNING!!! parameter should probably be NULL!!! (close_window())");
    T_DEBUG_PROTOCOLL(("WARNING !!!"))
    this_window->parameter->window_element=this_window;
   }
//   this_window->parameter->button_element=NULL;
  }
  if ((!(flag&CLOSE_FORCED))&&(this_window->art&RETURNING))
   show_message("Close_raw_window destruction !!!");
  /* Quasi rekursiv */
  return_ebene=this_window->destructor(this_window->parameter);
  if ((get_window(my_id)!=this_window)&&(!((return_ebene==ebene)&&(ebene!=-1))) )
  {
   T_DEBUG_PROTOCOLL(("close_window(), destructor lost my window!!!"))
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_OK; // fenster geschlossen per destructor
  }
  if ((return_ebene!=ebene)&&(ebene!=-1))
  {
   /* regulaere RETURN window in falscher ebene */
   if (!(flag&CLOSE_FORCED))
   { // wenn nicht gezwungener Massen, dann nicht geschlossen!
    T_DEBUG_PROTOCOLL(("close_window(), Return window with destructor, error not processesed (past), name:%s",this_window->name))
    if ((flag&CLOSE_SHUTDOWN) != CLOSE_SHUTDOWN)
     show_message("DESTRUCTION FORBIDDEN !!!");
    T_DEBUG_FUNCTION_POSITION(3)
    T_DEBUG_LEAVE
    return T_NOT_OK;
   }
   if ((flag&CLOSE_SHUTDOWN) != CLOSE_SHUTDOWN)
   {
    T_DEBUG_PROTOCOLL(("close_window(), Return window with destructor, error but deleting anyway... (past), name:%s",this_window->name))
    // wenn doch gezwungen, dann weiter bei *!!!*
    show_message("DESTRUCTION FORBIDDEN !!! (DELETING ANYWAY)");
   }
  } // if ((this_window->destructor(this_window->parameter)!=ebene)&&(ebene!=-1))
  else
  {
   if (ebene==-1)
   {
    // NICHT return windows mit destructor!
    T_DEBUG_PROTOCOLL(("close_window(), Non return window with destructor (past)(processing close_window now...), name:%s",this_window->name))
    if (!(flag&CLOSE_NO_REDRAW))
    {
     if ((this_window->hide==0)&&(this_window->dhide==0))
      repair_screen(this_window,REPAIR,0,0,0,0);
    }
    free_mem_bild(this_window->window_pic);
    while (this_window->button_first!=NULL)
    {
     button=(BUTTON_LISTEN_ELEMENT *)(this_window->button_first->objekt);
     d_entferne_aus_liste(button,&(this_window->button_first),&(this_window->button_last),DL_CLEAN_UP);
     free_button(button->button);
     free(button);
    }
    if (this_window->name!=NULL)
    {
     free(this_window->name);
     this_window->name=NULL;
    }
    d_entferne_aus_liste(this_window,&window_first,&window_last,DL_CLEAN_UP);
    #ifdef VECTREX
    if (clip_memory!=NULL) // on leaving, clip mem is not longer available
    {
     if ((this_window->hide==0)&&((this_window->dhide==0)))
     {
      T_INT x,y;
      for (y=this_window->y;y<this_window->y+this_window->h;y++)
      {
       for (x=this_window->x;x<this_window->x+this_window->b;x++)
       {
        *(clip_memory+(vesa_bytes_per_scanline*y)+x)-=2;
       }
      }
     }
    }
    #endif
    this_window->id=-1;
    free(this_window);
    windows_open--;
    windows_shown--;
    T_DEBUG_FUNCTION_POSITION(4)
    T_DEBUG_LEAVE
    return T_OK;
   }
   else
   {
    // regulaere return windows, mit rueckgabewert == ebene, also ok,
    // geschlossen von destructor (moeglicherweise durch rekursiven
    // aufruf von close_win
    T_DEBUG_PROTOCOLL(("close_window(), Return window with destructor (past)(not processing close_window, since allready done...), name: \"can't remember\""))
    T_DEBUG_FUNCTION_POSITION(5)
    T_DEBUG_LEAVE
    return T_OK; // fenster geschlossen per destructor
   }
  } // else if ((this_window->destructor(this_window->parameter)!=ebene)&&(ebene!=-1))
 } // if (this_window->destructor!=NULL)
/* *!!!* */
 T_DEBUG_PROTOCOLL(("close_window(), processing close_window, none destructor part- name:%s",this_window->name))
 if (!(flag&CLOSE_NO_REDRAW))
 {
  if ((this_window->hide==0)&&(this_window->dhide==0))
   repair_screen(this_window,REPAIR,0,0,0,0);
 }
 free_mem_bild(this_window->window_pic);
 while (this_window->button_first!=NULL)
 {
  button=(BUTTON_LISTEN_ELEMENT *)(this_window->button_first->objekt);
  d_entferne_aus_liste(button,&(this_window->button_first),&(this_window->button_last),DL_CLEAN_UP);
  free_button(button->button);
  free(button);
 }
 if (this_window->name!=NULL)
 {
  free(this_window->name);
  this_window->name=NULL;
 }
 d_entferne_aus_liste(this_window,&window_first,&window_last,DL_CLEAN_UP);
 #ifdef VECTREX
 if (clip_memory!=NULL) // on leaving, clip mem is not longer available
 {
  if ((this_window->hide==0)&&(this_window->dhide==0))
  {
   T_INT x,y;
   for (y=this_window->y;y<this_window->y+this_window->h;y++)
   {
    for (x=this_window->x;x<this_window->x+this_window->b;x++)
    {
     *(clip_memory+(vesa_bytes_per_scanline*y)+x)-=2;
    }
   }
  }
 }
 #endif
 this_window->id=-1;
 free(this_window);
 windows_open--;
 windows_shown--;
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

/* zeichnet ein fenster auf einer gegeben position neu */
/* (auf der alten position wird es natuerlich geloescht) */
T_INT move_raw_window(T_WORD x,T_WORD y,WINDOW_LISTEN_ELEMENT *this_window)
{
 T_DEBUG_ENTRY("move_raw_window",40)
 if (this_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((this_window->art&UNBEWEGBAR)==UNBEWEGBAR)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((x+this_window->b>vesa_x)||(y+this_window->h>vesa_y))
 {
  T_DEBUG_FUNCTION_POSITION(3)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((this_window->hide==0)&&(this_window->dhide==0))
 {
  repair_screen(this_window,REPAIR_BORDER,x,y,0,0);
  this_window->x=x;
  this_window->y=y;
  repair_screen(this_window,REDRAW_WINDOW,0,0,0,0);
///* if aktivated */print_mem_bild(this_window->window_pic,this_window->x,this_window->y);
 }
 T_DEBUG_LEAVE
 return T_OK;
}
/***************************************************************/

/* window laesst sich bei rechter gedrueckter maustaste */
/* auf dem bildschirm verschieben (der rahmen) */
T_INT move_window(WINDOW_LISTEN_ELEMENT *this_window)
{
 T_INT old_maus_x=vesa_mouse_x;
 T_INT old_maus_y=vesa_mouse_y;
 T_INT off_x=0;
 T_INT off_y=0;
 T_INT old_box_x=0,old_box_y=0;
 RECTANGLE_SAVE *box=NULL;
 T_DEBUG_ENTRY("move_window",40)
 if (this_window==NULL)
 {
  T_DEBUG_FUNCTION_POSITION(1)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((this_window->art&UNBEWEGBAR)==UNBEWEGBAR)
 {
  T_DEBUG_FUNCTION_POSITION(2)
  T_DEBUG_LEAVE
  return T_NOT_OK;
 }
 if ((this_window->art)&VIRTUAL_FRONT_WINDOW)
 {
  aktivate_window(this_window);
  update_whole_window(this_window);
 }
 if (win_bewegungsart!=GANZ)
 {
  box=vesa_rect_save(this_window->x+off_x,this_window->y+off_y,this_window->b-1,this_window->h,weiss);
  if (box==NULL)
  {
   T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return GENERIC_MEMORY_NOT_AVAILABLE;
  }
  while (vesa_mouse_button==2)
  {
   off_x=vesa_mouse_x-old_maus_x;
   off_y=vesa_mouse_y-old_maus_y;
   if (this_window->x+off_x<0)
    off_x=-this_window->x;
   if (off_x+this_window->x+this_window->b+1>=vesa_x)
    off_x=vesa_x-(this_window->x+this_window->b+1);
   if (this_window->y+off_y<0)
    off_y=-this_window->y;
   if (off_y+this_window->y+this_window->h+1>=vesa_y)
    off_y=vesa_y-(this_window->y+this_window->h+1);
   if ((old_box_x!=this_window->x+off_x)||(old_box_y!=this_window->y+off_y))
   {
    old_box_x=this_window->x+off_x;
    old_box_y=this_window->y+off_y;
    vesa_remove_rectangle(box);
    box=NULL;
    box=vesa_rect_save(old_box_x,old_box_y,this_window->b-1,this_window->h,weiss);
    sync_display();
    if (box==NULL)
    {
     T_DEBUG_SET_THIS_FUNCTION_ERROR(GENERIC_MEMORY_NOT_AVAILABLE)
     T_DEBUG_FUNCTION_POSITION(4)
     T_DEBUG_LEAVE
     return GENERIC_MEMORY_NOT_AVAILABLE;
    }
   }
  }
  vesa_remove_rectangle(box);
  if (off_x+off_y!=0)
   move_raw_window(this_window->x+off_x,this_window->y+off_y,this_window);
 }
 else
 {
  T_INT akt_mouse_x=vesa_mouse_x;
  T_INT akt_mouse_y=vesa_mouse_y;
  T_INT maus_win_offset_x=akt_mouse_x-this_window->x;
  T_INT maus_win_offset_y=akt_mouse_y-this_window->y;
  old_maus_x=akt_mouse_x;
  old_maus_y=akt_mouse_y;
  while (vesa_mouse_button==2)
  {
   akt_mouse_x=vesa_mouse_x;
   akt_mouse_y=vesa_mouse_y;
   off_x=akt_mouse_x-old_maus_x;
   off_y=akt_mouse_y-old_maus_y;
   if (this_window->x+off_x<0)
    off_x=-this_window->x;
   if (off_x+this_window->x+this_window->b>vesa_x)
    off_x=vesa_x-(this_window->x+this_window->b);
   if (this_window->y+off_y<0)
    off_y=-this_window->y;
   if (off_y+this_window->y+this_window->h>vesa_y)
    off_y=vesa_y-(this_window->y+this_window->h);
   if ((off_x != 0) || (off_y != 0))
   {
    vesa_mouse_update();
    repair_screen(this_window,REPAIR_BORDER,this_window->x+off_x,this_window->y+off_y,0,0);
    this_window->x+=off_x;
    this_window->y+=off_y;
    repair_screen(this_window,REDRAW_WINDOW,0,0,0,0);
    akt_mouse_x=this_window->x+maus_win_offset_x;
    akt_mouse_y=this_window->y+maus_win_offset_y;
    old_maus_x=akt_mouse_x;
    old_maus_y=akt_mouse_y;
    vesa_mouse_setze_cursor(akt_mouse_x,akt_mouse_y);
    sync_display();
   }
   else
   {
    if ((abs(akt_mouse_x-old_maus_x)>10)||(abs(akt_mouse_y-old_maus_y)>10))
     vesa_mouse_setze_cursor(this_window->x+maus_win_offset_x,this_window->y+maus_win_offset_y);
   }
  }
  if (this_window->update_funktion!=NULL)
  this_window->update_funktion(UPDATE_AFTER_MOVE,(T_PVOID)this_window);
 }
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/

#define REPAIR_TEST_EXIT_GEBIET                                                               \
   if (fehler>0)                                                                              \
   {                                                                                          \
    free_gebiete();                                                                           \
    vesa_print_modus=old_vesa_print_modus;                                                    \
    vesa_text=old_vesa_text;                                                                  \
    T_DEBUG_FUNCTION_POSITION(100)                                                            \
    T_DEBUG_LEAVE                                                                             \
    return fehler;                                                                            \
   }
T_INT process_gebiets_liste(T_LISTE *window_liste, T_INT flag, WINDOW_LISTEN_ELEMENT *this_window)
{
 WINDOW_LISTEN_ELEMENT *window;
 GEBIET *gebiet;
 T_LISTE *gebiet_liste;
 T_LISTE *end_of_scan;
 T_INT ret_x,ret_y,ret_h,ret_b;
 T_INT ret_off_x,ret_off_y;
 T_INT fehler=T_OK;
 T_INT old_vesa_print_modus=vesa_print_modus;
 T_INT old_vesa_text=vesa_text;
 T_DEBUG_ENTRY("process_gebiets_liste",40)
 gebiet_liste=freies_gebiet_first;
 vesa_print_modus=PIC_FILLED;
 vesa_text=MULTI_COLOR;
 if (flag==REDRAW_WINDOW)
 {
  end_of_scan=d_get_list_pos(this_window,window_first)->naechstes;
 }
 else
 {
  end_of_scan=NULL;
 }
// MOUSE_VERSTECKE

 while ((window_liste!=NULL)&&(gebiet_liste!=NULL))
 {
  if (window_liste==end_of_scan) break;
  do
  {
   if ((window_liste==NULL)&&(gebiet_liste!=NULL))
   {
    gebiet_liste=gebiet_liste->naechstes;
    if (gebiet_liste!=NULL)
     window_liste=d_get_list_pos(((GEBIET *)gebiet_liste->objekt)->window,window_first);
   }
   gebiet=(GEBIET *)gebiet_liste->objekt;
   if (window_liste!=NULL)
   {
    switch (flag)
    {
     case REDRAW_WINDOW:
     case REPAIR_BORDER:
     case HIDE_WINDOW:
     case LOWER_WINDOW:
     case LOWER_TILL_BACKDROP:
     case REPAIR:
     case UPDATE_VISIBLE_BACK_RECT:
     {
      window_liste=window_overlap_werte(window_liste,gebiet->x,gebiet->y,gebiet->b,gebiet->h,&ret_x,&ret_y,&ret_b,&ret_h,&ret_off_x,&ret_off_y,LOWER);
      break;
     }
     case ACTIVATE:
     case UPDATE_VISIBLE_WINDOW_RECT:
     {
      window_liste=window_overlap_werte(window_liste,gebiet->x,gebiet->y,gebiet->b,gebiet->h,&ret_x, &ret_y,&ret_b,&ret_h,&ret_off_x,&ret_off_y,HIGHER);
      break;
     }
    }
   }
  }
  while ((window_liste==NULL)&&(gebiet_liste!=NULL));
  if ((window_liste==NULL)&&(gebiet_liste==NULL))
   break;
  window=(WINDOW_LISTEN_ELEMENT *)(window_liste->objekt);
  if (window!=this_window)
  {
   if (ret_x<=gebiet->x)
   {
    if (ret_y<=gebiet->y)
    {
     if (ret_x+ret_b>=gebiet->x+gebiet->b)
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       ;/* 0 gebiete */
      }
      else
      {
       /* 1 gebiet (a) */
       fehler+=insert(ret_x,ret_y+ret_h,ret_b,gebiet->h-ret_h,window);
      }
     }
     else
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       /* 1 gebiet (c) */
       fehler+=insert(ret_x+ret_b,ret_y,gebiet->b-ret_b,ret_h,window);
      }
      else
      {
       /* 2 gebiete (b) */
       fehler+=insert(gebiet->x,gebiet->y+ret_h,gebiet->b,gebiet->h-ret_h,window);
       fehler+=insert(gebiet->x+ret_b,gebiet->y,gebiet->b-ret_b,ret_h,window);
      }
     }
    }
    else
    {
     if (ret_x+ret_b>=gebiet->x+gebiet->b)
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       /* 1 gebiet (b) */
       fehler+=insert(ret_x,gebiet->y,ret_b,gebiet->h-ret_h,window);
      }
      else
      {
       /* 2 gebiete (f) */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b,ret_y-gebiet->y,window);
       fehler+=insert(gebiet->x,ret_y+ret_h,gebiet->b,gebiet->y+gebiet->h-(ret_y+ret_h),window);
      }
     }
     else
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       /* 2 gebiete (c) */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b,gebiet->h-ret_h,window);
       fehler+=insert(gebiet->x+ret_b,ret_y,gebiet->b-ret_b,ret_h,window);
      }
      else
      {
       /* 3 gebiete (c) */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b,ret_y-gebiet->y,window);
       fehler+=insert(ret_x+ret_b,ret_y,gebiet->b-ret_b,ret_h,window);
       fehler+=insert(gebiet->x,ret_y+ret_h,gebiet->b,gebiet->y+gebiet->h-(ret_y+ret_h),window);
      }
     }
    }
   }
   else
   {
    if (ret_y<=gebiet->y)
    {
     if (ret_x+ret_b>=gebiet->x+gebiet->b)
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       /* 1 gebiet (d) */
       fehler+=insert(gebiet->x,ret_y,gebiet->b-ret_b,ret_h,window);
      }
      else
      {
       /* 2 gebiete (a) */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b-ret_b,gebiet->h,window);
       fehler+=insert(ret_x,ret_y+ret_h,ret_b,gebiet->h-ret_h,window);
      }
     }
     else
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       /* 2 gebiete (e) */
       fehler+=insert(gebiet->x,gebiet->y,ret_x-gebiet->x,gebiet->h,window);
       fehler+=insert(ret_x+ret_b,gebiet->y,gebiet->x+gebiet->b-(ret_x+ret_b),gebiet->h,window);
      }
      else
      {
       /* 3 gebiete (d) */
       fehler+=insert(gebiet->x,gebiet->y,ret_x-gebiet->x,gebiet->h,window);
       fehler+=insert(ret_x,ret_y+ret_h,ret_b,gebiet->h-ret_h,window);
       fehler+=insert(ret_x+ret_b,ret_y,gebiet->x+gebiet->b-(ret_x+ret_b),gebiet->h,window);
      }
     }
    }
    else
    {
     if (ret_x+ret_b>=gebiet->x+gebiet->b)
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       /* 2 gebiete (c) */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b,gebiet->h-ret_h,window);
       fehler+=insert(gebiet->x,ret_y,gebiet->b-ret_b,ret_h,window);
      }
      else
      {
       /* 3 gebiete (a) */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b,ret_y-gebiet->y,window);
       fehler+=insert(gebiet->x,ret_y,gebiet->b-ret_b,ret_h,window);
       fehler+=insert(gebiet->x,ret_y+ret_h,gebiet->b,gebiet->y+gebiet->h-(ret_y+ret_h),window);
      }
     }
     else
     {
      if (ret_y+ret_h>=gebiet->y+gebiet->h)
      {
       /* 3 gebiete (b) */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b,ret_y-gebiet->y,window);
       fehler+=insert(gebiet->x,ret_y,ret_x-gebiet->x,ret_h,window);
       fehler+=insert(ret_x+ret_b,ret_y,gebiet->x+gebiet->b-(ret_x+ret_b),ret_h,window);
      }
      else
      {
       /* 4 gebiete */
       fehler+=insert(gebiet->x,gebiet->y,gebiet->b,ret_y-gebiet->y,window);
       fehler+=insert(gebiet->x,ret_y+ret_h,gebiet->b,gebiet->y+gebiet->h-(ret_y+ret_h),window);
       fehler+=insert(gebiet->x,ret_y,ret_x-gebiet->x,ret_h,window);
       fehler+=insert(ret_x+ret_b,ret_y,gebiet->x+gebiet->b-(ret_x+ret_b),ret_h,window);
      }
     }
    }
   }
   REPAIR_TEST_EXIT_GEBIET
   switch (flag)
   {
    case ACTIVATE:
    {
     print_mem_teilbild(this_window->window_pic,ret_x,ret_y,(window->x+ret_off_x)-this_window->x,
     (window->y+ret_off_y)-this_window->y,ret_b,ret_h);
     break;
    }
    case LOWER_TILL_BACKDROP:
    {
     if ((d_vergleich(this_window,window,window_first)==1)&&((window->art & BACK_WINDOW)==0))
      print_mem_teilbild(window->window_pic,ret_x,ret_y,ret_off_x,ret_off_y,ret_b,ret_h);
     break;
    }
    case REDRAW_WINDOW:
    {
     if (d_vergleich(this_window,window,window_first)==1)
      print_mem_teilbild(this_window->window_pic,ret_x,ret_y,(window->x+ret_off_x)-this_window->x,
      (window->y+ret_off_y)-this_window->y,ret_b,ret_h);
     break;
    }
    case LOWER_WINDOW:
    case REPAIR:
    case REPAIR_BORDER:
    case HIDE_WINDOW:
    {
     if (d_vergleich(this_window,window,window_first)==1)
      print_mem_teilbild(window->window_pic,ret_x,ret_y,ret_off_x,ret_off_y,ret_b,ret_h);
     break;
    }
   }
   gebiet=(GEBIET *)gebiet_liste->objekt;
   gebiet_liste=gebiet_liste->naechstes;
   d_entferne_aus_liste(gebiet,&freies_gebiet_first,&freies_gebiet_last,DL_CLEAN_UP);
   free(gebiet);
   if (gebiet_liste!=NULL)
    window_liste=d_get_list_pos(((GEBIET *)gebiet_liste->objekt)->window,window_first);
   else
    window_liste=NULL;
  }
 }
 while (freies_gebiet_first!=NULL)
 {
  gebiet=(GEBIET *)freies_gebiet_first->objekt;
  switch (flag)
  {
   case REPAIR_BORDER:
   case REPAIR:
   case UPDATE_VISIBLE_BACK_RECT:
   case HIDE_WINDOW:
   {
// MOUSE_VERSTECKE
// t_printf(0,"\nx:%i, y:%i, b:%i, h:%i",gebiet->x,gebiet->y,gebiet->b,gebiet->h);
// x:0, y:3, b:756, h:26
    print_mem_teilbild(back_pic,gebiet->x,gebiet->y,gebiet->x,gebiet->y,gebiet->b,gebiet->h);
// MOUSE_ZEIGE
    break;
   }
   case REDRAW_WINDOW:
   case UPDATE_VISIBLE_WINDOW_RECT:
   {
    print_mem_teilbild(this_window->window_pic,gebiet->x,gebiet->y,gebiet->x-this_window->x,
    gebiet->y-this_window->y,gebiet->b,gebiet->h);
    break;
   }
  }
  d_entferne_aus_liste(gebiet,&freies_gebiet_first,&freies_gebiet_last,DL_CLEAN_UP);
  free(gebiet);
 }







// MOUSE_ZEIGE








 free_gebiete();
 vesa_print_modus=old_vesa_print_modus;
 vesa_text=old_vesa_text;
 T_DEBUG_LEAVE
 return T_OK;
}

/***************************************************************/
T_INT get_hidden_anzahl(T_VOID)
{
 T_LISTE *window_liste=window_last;
 T_INT hidden=0;
 T_DEBUG_ENTRY("get_hidden_anzahl",40)
 while (window_liste!=NULL)
 {
  if (((WINDOW_LISTEN_ELEMENT *)window_liste->objekt)->hide>0)
   hidden++;
  window_liste=window_liste->letztes;
 }
 T_DEBUG_LEAVE
 return hidden;
}

#ifdef VECTREX
T_INT update_function(T_INT status, T_PVOID vwindow)
{
/* UPDATE AFTER DESTROY is done in close_window() */
 T_INT x;
 T_INT y;
 WINDOW_LISTEN_ELEMENT *window=(WINDOW_LISTEN_ELEMENT *)vwindow;
 T_DEBUG_ENTRY("update_function",40)
 switch (status) // we do not want a dispatcher response
 {
  case 0:
  {
   T_DEBUG_FUNCTION_POSITION(1)
   T_DEBUG_LEAVE
   return T_OK;
  }
  case UPDATE_AFTER_MOVE:
  {
//   MOUSE_VERSTECKE
   for (y=window->last_y;y<window->last_y+window->h;y++)
   {
    for (x=window->last_x;x<window->last_x+window->b;x++)
    {
     *(clip_memory+(vesa_bytes_per_scanline*y)+x)-=2;
    }
   }
   for (y=window->y;y<window->y+window->h;y++)
   {
    for (x=window->x;x<window->x+window->b;x++)
    {
     *(clip_memory+(vesa_bytes_per_scanline*y)+x)+=2;
    }
   }
//   MOUSE_ZEIGE
   window->last_x = window->x;
   window->last_y = window->y;
   T_DEBUG_FUNCTION_POSITION(2)
   T_DEBUG_LEAVE
   return T_OK;
  }
  case UPDATE_AFTER_HIDE:
  {
//   MOUSE_ZEIGE
//MOUSE_VERSTECKE
   for (y=window->y;y<window->y+window->h;y++)
   {
    for (x=window->x;x<window->x+window->b;x++)
    {
     *(clip_memory+(vesa_bytes_per_scanline*y)+x)-=2;
    }
   }
//MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(3)
   T_DEBUG_LEAVE
   return T_OK;
  }
  case UPDATE_AFTER_SHOW:
  {
//MOUSE_VERSTECKE
   for (y=window->y;y<window->y+window->h;y++)
   {
    for (x=window->x;x<window->x+window->b;x++)
    {
     *(clip_memory+(vesa_bytes_per_scanline*y)+x)+=2;
    }
   }
//MOUSE_ZEIGE
   T_DEBUG_FUNCTION_POSITION(4)
   T_DEBUG_LEAVE
   return T_OK;
  }
  default:
  {
   T_DEBUG_LEAVE
   return T_OK;
  }
 }
}
#endif