 if MY_MAKROS_I != 1

MY_MAKROS_I equ 1
;
; following are some 'private' makro definitions
;

;***************************************************************************
; this makro is supposed to 'reset' the sound hardware,
; it doesn't seem to work correctly though, frog jumps sometimes
; sound differently, what kind of 'bug' is that?
MY_QUIT         macro
                CLR     Vec_Music_Flag     ; no music is playing ->0
                JSR     Clear_Sound        ; clear all sound and shadow regs
                JSR     Init_Music_Buf     ; clear music buffer
                endm                       ; end of macro
;***************************************************************************
; this makro should be called every round a music is to be played
; this does not play the sound, it initializes it only, but also every round!
;
; leaves with DP set to C8
; expects music to be initialized
; and pointer in music_active
DO_MY_SOUND     macro                      ; name of macro
                _DP_TO_C8                  ; (MAKRO) the 'Init_Music_chk' expects this
                LDU     music_active       ; get active music
                JSR     Init_Music_chk     ; and init new notes
                endm                       ; end of macro
;***************************************************************************
; this makro initializes a new piece of music
; the above 'function' must be called every round in order for the music
; actually to be played
PLAY_SOUND      macro piece_of_music       ; name of macro, and variable name, can also be accessed with \1
                ; the next instructions initialize a new sound
                ; load #1
                ; set this as marker for music start
                CLR     Vec_Music_Flag     ; doesn'T destroy a register
                INC     Vec_Music_Flag     ; to do it that way
                LDU     #\1                ; load a music structure (piece_of_music)
                STU     music_active       ; and store it to my own music active pointer
                                           ; next a do_my_sound and than do sound must be called
                endm                       ; end of macro
;***************************************************************************
; this makro is sort of the startup for every display round
; does all sound stuff and recalibration, leaves with
; DP set to D0
; destroyes pretty much every register...
ROUND_STARTUP   macro                      ; name of macro
                DO_MY_SOUND                ; (MAKRO) see above
                JSR     Wait_Recal         ; sets dp to d0, and pos at 0, 0
                direct  $D0                ; just for assembler optimization...
                JSR     Do_Sound           ; ROM function that does the sound playing
                endm                       ; end of macro
;***************************************************************************
; the following makros are for intensity setting
; to set a intensity the bios does use some (many) cycles, here a
; test really saves some cycles, if intensity is set many times per round
; (like differently shaded sprites)
;
; intensity set to value found in register A
; is compared/stored to 'current_brightness'
; if not equal the new brightness is set!
MY_INTENSITY_A  macro                      ; name of macro, and variable name, can also be accessed with
                CMPA    current_brightness ; compare to last known value
                BEQ     no_brightness_change\? ; if the same, than jump
                STA     current_brightness ; otherwise store new value
                _INTENSITY_A               ; and than set the intensity
no_brightness_change\?:
                endm                       ; end of macro
;***************************************************************************
; same as above, only the brightness is passed as makro parameter
MY_INTENSITY   macro brightness            ; name of macro, and variable name, can also be accessed with \1
                LDA     #\1                ; load brightness to register A
                MY_INTENSITY_A             ; 'call' the other makro
                endm                       ; end of macro
;***************************************************************************
; same as above, but allways sets the new brightness
; good for startup of new round, since intensity MUST be set at that point
; or after other functions which destroy brighness (print_str...)
MY_INTENSITY_FORCE  macro brightness           ; name of macro, and variable name, can also be accessed with \1
                LDA     #\1                    ; load brightness to A
                STA     current_brightness     ; store it
                _INTENSITY_A                   ; and change the brightness
                endm                           ; end of macro
;***************************************************************************
; the following two makros ...
; they search for a better (faster) scale/DAC relation and use
; the scaling thus found, it should be somewhat faster that way...
; per round we save approxematly: ? cycles
; both destroy X and D
; SCALE factor is changed
;
; forget it !!!
;***************************************************************************
MY_GAME_SCALE   macro
                LDA #SCALE_FACTOR_GAME
                _SCALE_A
                endm
MY_MOVE_TO_D    macro
; what should be done:
; s = $ff / max(abs(a),abs(b))
; a = a * s
; b = b * s
; scaling = scaling / s
;
; that would give the most efficient positioning
; bother it takes more time to calculate the above,
; than it saves
; with every positioning via this routine now,
; it takes SCALE_FACTOR_GAME + const (of another 100+) cycles
; to do one simple positioning!!!
; that is probably about 300 cycles per positioning
; this is done about 30-40 times per round
; alone the positioning takes thus about over 10000 cycles
; and we haven't drawn a single line yet!!!
                 _MOVE_TO_D
                endm
MY__MOVE_TO_D    macro
; what should be done:
; s = $ff / max(abs(a),abs(b))
; a = a * s
; b = b * s
; scaling = scaling / s
;
; that would give the most efficient positioning
; bother it takes more time to calculate the above,
; than it saves
; with every positioning via this routine now,
; it takes SCALE_FACTOR_GAME + const (of another 100+) cycles
; to do one simple positioning!!!
; that is probably about 300 cycles per positioning
; this is done about 30-40 times per round
; alone the positioning takes thus about over 10000 cycles
; and we haven't drawn a single line yet!!!
; X can be trashed
; in D yx now
; in -2,U yx also
;                 _MOVE_TO_D
                 local   LF345
                 local   LF33B
                 local   LF33D
                 local   LF341
                 local   leave_here
                 BPL     x_pos_is_positive\? ; last operation was STB
                                            ; this effects NZ flags
                                            ; hence we can ask if x is zero or
                                            ; not
                 NEGB                       ; x below zero, lets get the absolut...
x_pos_is_positive\?:
                  STA     <VIA_port_a     ;Store Y in D/A register
;                TSTA
                 BPL     y_pos_is_positive\? ; last operation was STA
                 NEGA                       ; x below zero, lets get the absolut...
y_pos_is_positive\?:
                     ; to here allready 12 cycles!!!
                 ASLA

                 ASLB
;........

;                 STA     <VIA_port_a     ;Store Y in D/A register
                 CLR     <VIA_port_b     ;Enable mux
                 PSHS    D               ;Save D-register on stack
                 LDA     #$CE            ;Blank low, zero high?
                 STA     <VIA_cntl       ;
                 CLR     <VIA_shift_reg  ;Clear shift regigster
                 INC     <VIA_port_b     ;Disable mux
                 STB     <VIA_port_a     ;Store X in D/A register
                 CLR     <VIA_t1_cnt_hi  ;timer 1 count high
                 PULS    D               ;Get back D-reg


                 _ABS_A_B                ;
                 STB     -1,S            ;
                 ORA     -1,S            ;
                 LDB     #$40            ;
                 CMPA    #$40            ;
                 BLS     LF345           ;
                 CMPA    #$64            ;
                 BLS     LF33B           ;
                 LDA     #$08            ;
                 BRA     LF33D           ;

LF33B:           LDA     #$04            ;Wait for timer 1
LF33D:           BITB    <VIA_int_flags  ;
                 BEQ     LF33D           ;
LF341:           DECA                    ;Delay a moment
                 BNE     LF341           ;
                 BRA     leave_here      ;
                                         ;
LF345:           BITB    <VIA_int_flags  ;Wait for timer 1
                 BEQ     LF345
leave_here:
                endm

MY_MOVE_TO      macro
                LDA #\2
                LDB #\1
                MY_MOVE_TO_D
                endm
;***************************************************************************
; signed multiplication of A, B to D
; uses mul_tmp1, (old mul_tmp2)
; destroys A, B
;
; can probably be optimized like hell
; perhaps look if higher than a power of two and use
; some initial ASLs...
;
; or look if the two are of different sign and use MUL and NEG
; this last is done here...
MY_MUL_A_B_D    macro
                TSTA                     ; test A
                BPL  mul_Ap\?            ; if positive, jump to MUL A positive
                NEGA                     ; otherwise make A positive
mul_An\?:                                ; here A was negative
                TSTB                     ; now test B
                BPL  mul_An_Bp\?         ; if B positive, than jump to MUL A negative, B positive
mul_An_Bn\?:                             ; here A and B negative
                NEGB                     ; make B positive
                BRA  mul_Ap_Bp\?         ; and do the same as A and B positive
mul_Ap\?:                                ; here A positive
                TSTB                     ; now test B
                BPL  mul_Ap_Bp\?         ; if B positive jump to MUL A positive and B positive
                NEGB                     ; otherwise make B positive
mul_An_Bp\?:                             ; here A negative and B positive
mul_Ap_Bn\?:                             ; here A positive and B negative
                MUL                      ; do a simple MUL
                STD mul_tmp1             ; isn't that sick ?
                CLRA                     ; this crap
                CLRB                     ; is in fact
                SUBD mul_tmp1            ; a NEGD !!!
                BRA mul_end\?            ; and go to exit
mul_Ap_Bp\?:                             ; here both A, B are positive
                MUL                      ; than a simple MUL is enough
mul_end\?:                               ; and done
                endm
;***************************************************************************
; quite a bit slower than the above...
; this is just a history lesson on how a MUL can be
; implemented using adds...
; not used anywhere :-)
old_MY_MUL_A_B_D    macro
                TSTB                     ; Test B
                BEQ  mul_zero\?          ; if zero, than do MUL zero
                TSTA                     ; Test A
                BEQ  mul_zero\?          ; if zero, than do MUL zero
                BPL  no_minus_a\?        ; jump if A positive
                NEGA                     ; A should be positiv, since it is our 'counter'
                NEGB                     ; invert both, so the sign is still the same
no_minus_a\?:                            ; A was positive from start
                STA  mul_tmp2            ; remember A
                CLRA                     ; clear A
                SEX                      ; make B sign extended
                STD  mul_tmp1            ; rememer extened B as well
                CLRA                     ; clear A
                CLRB                     ; clear B (D=0)
mul_on\?:                                ; now loop, D is our working area
                ADDD mul_tmp1            ; add 'sign extened B' to D
                DEC mul_tmp2             ; decrement 'counter A'
                BNE mul_on\?             ; if 'counter' not zero, go on
                BRA mul_end\?            ; otherwise finnish it
mul_zero\?:
                CLRA                     ; mul zero, clears D
                CLRB
mul_end\?:                               ; and done
                endm
;***************************************************************************
; only positive for now
; multiply two 16 bit values to another 16 bit value
; multiplies D and tmp1 to D
; result should be also 16 bit able, otherwise high bit is lost
;
;***ERROR*** It is not tested for signedness, should test
; at startup, if our counter us negative, like the last mul above
; but I don't need it now, it would be just a waste of time
; for my needs!!!
MY_MUL_D_tmp1_D    macro
                STD mul_tmp1             ; remember D
                BEQ  mul_zero\?          ; was it a mul zero? than go there
                LDD tmp1                 ; get the other 16 bit value to D
                BEQ  mul_zero\?          ; was that one a zero? than go there
                BRA  mul_on2\?           ; otherwise start multiplying
mul_on\?:                                ; here we loop after the first step
                LDD mul_tmp2             ; load our last intermediate multiply value
                ADDD tmp1                ; add tmp1 once
mul_on2\?:                               ; here we go with our first mul step
                STD mul_tmp2             ; store the intermediate mul value to mul_tmp2
                LDD mul_tmp1             ; load 'counter' (was D)
                SUBD #1                  ; decrement counter ***ERROR***,
                STD mul_tmp1             ; and store counter back
                BNE mul_on\?             ; if counter not zero, repeat multi...
                LDD mul_tmp2             ; otherwise load the result to D register
                BRA mul_end\?            ; and goto end
mul_zero\?:                              ; here we come if a zero mul was made
                CLRA                     ; result (D) is than zero
                CLRB
mul_end\?:                               ; and done...
                endm
;***************************************************************************
; divides B (0-127) by A (0-127)
; makro which divides the number in B by A, return in A
; B lost, A return val, tmp1 trashed...
; returns A(=0) on divide by 0, than nothing is lost at all
; uses divide_tmp as storage
MY_DIV          macro
                TSTA                     ; divide by zero is allways bad
                BEQ     divide_by_zero\? ; goto exit if that happened
                STA     divide_tmp       ; otherwise remember A
                LDA     #-1              ; and put -1 to A (incremented on loop entry)
divide_next\?:
                INCA                     ; increment one
                SUBB    divide_tmp       ; subtract B
                BPL     divide_next\?    ; and if still positive, loop again
divide_by_zero\?:
                endm                     ; end, result in A
;***************************************************************************
; there are many 16 bit operands missing, so is
; a LSRD
; this macro does a 16 bit LSR on register D
MY_LSR_D              macro
                      LSRB               ; LSR B
                      LSRA               ; LSR A
                      BCC no_carry\?     ; if no carry, than exit
                      ORB #128           ; otherwise underflow from A to 7bit of B
no_carry\?:
                      endm               ; done
;***************************************************************************
; fast (?) DIV D by 8
MY_DIV_D_8            macro
                      STD divide_tmp     ; isn't that sick ?
                      BPL D_positive\?   ; if positive, than jump
                      CLRA               ; this crap
                      CLRB               ; is in fact
                      SUBD divide_tmp    ; a NEGD !!!
                      MY_LSR_D           ; right shift is div 2
                      MY_LSR_D           ; 2 right shifts is div 4
                      MY_LSR_D           ; 3 right shifts is div 8
                      NEGB               ; it was negative, neg the result
                      BRA div_end\?      ; and exit
D_positive\?:
                      MY_LSR_D           ; right shift is div 2
                      MY_LSR_D           ; 2 right shifts is div 4
                      MY_LSR_D           ; 3 right shifts is div 8
div_end\?:
                      endm
;***************************************************************************
; fast (?) DIV D by 16
MY_DIV_D_16           macro
                      TSTA               ; 2 cycles
                      BPL D_positive\?   ; if positive, than jump
                      STD divide_tmp     ; isn't that sick ? 6 cycles
                      CLRA               ; this crap
                      CLRB               ; is in fact
                      SUBD divide_tmp    ; a NEGD !!!
                      LSLA               ; left shift A 4 times
                      LSLA
                      LSLA
                      LSLA
                      LSRB               ; right shift B 4 times
                      LSRB
                      LSRB
                      LSRB
                      STA divide_tmp     ; there is no such thing as ORB A (!)
                      ORB divide_tmp     ; or the result
                      NEGB               ; here we are negative
                      BRA div_end\?      ; jump to done
D_positive\?:
                      LSLA               ; left shift A 4 times
                      LSLA
                      LSLA
                      LSLA
                      LSRB               ; right shift B 4 times
                      LSRB
                      LSRB
                      LSRB
                      STA divide_tmp     ; there is no such thing as ORB A (!)
                      ORB divide_tmp     ; or the result
div_end\?:
                      endm               ; done
;***************************************************************************
MY_DIV_D_32           macro
                      STD divide_tmp ; isn't that sick ?
                      BPL D_positive\?
                      CLRA           ; this crap
                      CLRB           ; is in fact
                      SUBD divide_tmp; a NEGD !!!

                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      NEGB
                      BRA div_end\?
D_positive\?:
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
div_end\?:
                      endm
;***************************************************************************
MY_DIV_D_64           macro
                      STD divide_tmp ; isn't that sick ?
                      BPL D_positive\?
                      CLRA           ; this crap
                      CLRB           ; is in fact
                      SUBD divide_tmp; a NEGD !!!

                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      NEGB
                      BRA div_end\?
D_positive\?:
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
div_end\?:
                      endm
;***************************************************************************
; divides D by tmp1, result in B
; uses divide_tmp as storage
; only 8 bit in tmp1, but must be manually poked to tmp1 + 1
; sign is correctly handled
;
; can probably be optimized like hell
; perhaps only nearing the result
; using 2 shifts and a plus
; might be worth a try,
; see vectrex emulator for algorithm...
; could be implemented with a tabel, which in turn
; could be caclulated on the fly... (upon startup)
;
; this makro divides exact, but slow
MY_DIV_D_BY_TMP1_TO_B macro
                CLR     divide_tmp
                TST     tmp1+1
                BEQ     divide_by_zero\?
                DEC     divide_tmp
                CMPD    #0
                BPL     divide_next\?
divide_next1\?:
                INC     divide_tmp
                ADDD    tmp1
                BMI     divide_next1\?
divide_by_zero1\?:
                LDB     divide_tmp
                NEGB
                BRA     divide_end\?
divide_next\?:
                INC     divide_tmp
                SUBD    tmp1
                BPL     divide_next\?
divide_by_zero\?:
                LDB     divide_tmp
divide_end\?:
                endm
;***************************************************************************
MY_DIV_D_8_UNSIGNED   macro
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      endm
;***************************************************************************
MY_DIV_D_16_UNSIGNED macro
                      LSLA
                      LSLA
                      LSLA
                      LSLA
                      LSRB
                      LSRB
                      LSRB
                      LSRB
                      STA divide_tmp
                      ORB divide_tmp
                      endm
;***************************************************************************
MY_DIV_D_32_UNSIGNED  macro
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      endm
;***************************************************************************
MY_DIV_D_64_UNSIGNED  macro
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      MY_LSR_D
                      endm
;***************************************************************************
; divides D by tmp1, result in B
; uses divide_tmp as storage
; only 8 bit in tmp1, but must be manually poked to tmp1 + 1
; sign is correctly handled
;
; can probably be optimized like hell
; perhaps only nearing the result
; using 2 shifts and a plus
; might be worth a try,
; see vectrex emulator for algorithm...
; could be implemented with a tabel, which in turn
; could be caclulated on the fly... (upon startup)
;
; this makro divides exact, but slow
MY_DIV_D_BY_TMP1_TO_B_UNSIGNED macro
                CLR     divide_tmp
                TST     tmp1+1
                BEQ     divide_by_zero\?
                DEC     divide_tmp
                CMPD    #0
                BPL     divide_next\?
divide_next1\?:
                INC     divide_tmp
                ADDD    tmp1
                BMI     divide_next1\?
divide_by_zero1\?:
                LDB     divide_tmp
                NEGB
                BRA     divide_end\?
divide_next\?:
                INC     divide_tmp
                SUBD    tmp1
                BPL     divide_next\?
divide_by_zero\?:
                LDB     divide_tmp
divide_end\?:
                endm
;***************************************************************************

 endif
