; this game was written in April 1998 by Christopher Salomon
; it is public domain
;
; comments and vectrex talk are welcome
; my email: chrissalo@aol.com
;
;
; following command line was used to assemble:
;
; C:>as09.exe -w200 -h0 -l -mcti test.asm >error
;
; I used the 6809 assembler:
; as09 [1.11].
; Copyright 1990-1994, Frank A. Vorstenbosch, Kingswood Software.
; Available at:
; http://www.falstaff.demon.co.uk/cross.html
;
; some OS functions
Wait_Recal      EQU     $F192                  ;
Dot_here        EQU     $F2C5                  ;
Intensity_a     EQU     $F2AB                  ;
Moveto_d        EQU     $F312                  ;
music7          EQU     $FEC6                  ;
Vec_Dot_Dwell   EQU     $C828   ;Dot dwell time?

; VIA registers...
VIA_t1_cnt_lo   EQU     $D004                  ;VIA timer 1 count register lo (scale factor)
;***************************************************************************
                ORG     0
; start of vectrex memory with cartridge name...
                DB      "g GCE 1998", $80      ; 'g' is copyright sign
                DW      music7                 ; music from the rom
                DB      $F8, $50, $20, -$46    ; hight, width, rel y, rel x (from 0,0)
                DB      "VECTREX TEST", $80    ; some game information, ending with $80
                DB      $F8, $50, $5, -$20     ; hight, width, rel y, rel x (from 0,0)
                DB      "CHRIS", $80           ; some game information, ending with $80
                DB      0                      ; end of game header
;***************************************************************************
; here the cartridge program starts off
entry_point:
                 LDD #$b898                    ; this is $98b8 which is 39096 cycles
                 STD $C83D                     ; setting the refresh timer, appr. 26Hz
                 LDA #$ff                      ; scale of $ff
                 STA VIA_t1_cnt_lo             ; set to the scaling 'poke'
                 LDA #$7f                      ; load maximum brighness
                 JSR Intensity_a               ; and set it
                 LDB #10;
                 STB Vec_Dot_Dwell   ;Get dot dwell (brightness)

round_entry:
                 JSR Wait_Recal                ; first of, allways do a recall
                 JSR Dot_here                  ; no a supposed dot to 0, 0
;                 LDD #$0000                    ; CLR D
;                 JSR Moveto_d                  ; now move another 0, 0
;                 JSR Dot_here                  ; print another dot
 ;                LDB #10                       ; wait for 10*255 'delays'
 ;                JSR wait_256_B                ; quite a few cycles... (10000? 20000? dunno)
 ;                JSR Dot_here                  ; and another dot
                 BRA round_entry               ; restart everything!
;***************************************************************************
; a small nothing destroying (apart from flags)
; wait routine
wait_256_1:
                 PSHS    A                     ; save A
                 LDA     #255                  ; loop 255
wait_256_1_loop:
                 DECA                          ; decrement 1
                 BNE     wait_256_1_loop       ; if not zero... go on
                 PULS    A                     ; restore A
                 RTS                           ; and go back
;***************************************************************************
; a small nothing destroying (apart from flags)
; wait routine, b times the above smaller wait...
wait_256_B:
                 PSHS    B                     ; save B
wait_256_B_loop:
                 JSR     wait_256_1            ; do one 255 waiter
                 DECB                          ; decrement counter
                 BNE     wait_256_B_loop       ; if not 0 do another loop
                 PULS    B                     ; restore B
                 RTS                           ; and go back
;***************************************************************************
                END entry_point
;***************************************************************************
