/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : AY-3-8192 Sound Chip emulation module header file          */
/*                                                                           */
/*   File Name  : SOUNDEMU.H                                                 */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the function prototypes and definitions */
/*                for the AY-3-8192 sound chip emulation module.             */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#ifndef ADLIBSND_H
#define ADLIBSND_H

#include <standard.h>

/* Sound blaster stuff */

// PORT ADDRESSES
#define MIXER_ADDRESS           (sb_port+0x04)
#define MIXER_DATA              (sb_port+0x05)
#define DSP_RESET               (sb_port+0x06)
#define DSP_READ_DATA           (sb_port+0x0a)
#define DSP_WRITE_DATA          (sb_port+0x0c)
#define DSP_WRITE_STATUS        (sb_port+0x0c)
#define DSP_DATA_AVAIL          (sb_port+0x0e)

// DSP COMMANDS
#define SPEAKER_ON       (0xd1)
#define SPEAKER_OFF      (0xd3)
#define DIRECT_DAC       (0x10)

// DO A DSP COMMAND
#define writedac(x)                        \
{                                          \
 while(inp(DSP_WRITE_STATUS) & 0x80);      \
 outp(DSP_WRITE_DATA,(x));                 \
}

/* Function prototypes */

extern T_INT       (* fadlibSoundInit)(T_VOID);
extern T_VOID      (* fadlibSoundReset)(T_VOID);
extern T_VOID      (* fadlibSoundRestore)(T_VOID);
extern T_VOID      (* fadlibSoundTick)(T_VOID);
extern T_VOID      (* fadlibSoundMute)(T_VOID);
extern T_VOID      (* fadlibSoundResume)(T_VOID);
extern T_VOID      (* adlibInitTimerHandler)(T_VOID);
extern T_VOID      (* adlibDoneTimerHandler)(T_VOID);

T_VOID set_adlib_functions(T_INT type);
extern T_UWORD PSG_Reg[15];
extern T_SCHAR digidata;
extern T_UWORD sb_port;          // sb base port

#endif

/* End of ADLIBSND.H */
