/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : VECTREX HP3000 Analog CRT X,Y,Z & Compare Emulation Module */
/*                                                                           */
/*   File Name  : ANALOG.H                                                   */
/*                                                                           */
/*   Author     : Keith Wilkins / C.S.                                       */
/*                                                                           */
/*   Version    : 1.20                                                       */
/*                                                                           */
/*   Desciption : The file contains the definitions and function prototypes  */
/*                for the analog emulation module of the vectrex emulator    */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    13/03/93  K.W  Creation                                        */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*    1.20    20/10/96  C.S  DVE V1.20                                       */
/*                                                                           */
/*****************************************************************************/

#if !defined ANALOG_H
    #define ANALOG_H

#include "analog1.h"
#include "analog2.h"

extern T_VOID      (* fAnalogTick)(T_VOID);
extern T_VOID      (* fAnalogJoystickUpdate)(T_VOID);
extern T_VOID      (* adlibDoneTimerHandler)(T_VOID);
extern T_INT       (* fAnalogInit)(T_VOID);
extern T_VOID      (* fAnalogReset)(T_VOID);
extern T_VOID      (* fAnalogJoystickUpdateAnalog)(T_VOID);
extern T_VOID      (* fAnalogJoystickUpdateDigital)(T_VOID);
extern T_VOID      (* fAnalogJoystickUpdatePCJoystickAnalog)(T_VOID);
extern T_VOID      (* fAnalogJoystickUpdatePCJoystickDigital)(T_VOID);

T_VOID set_analog_functions(T_INT type);

extern T_SCHAR tIntegratorOffset;
extern T_SCHAR lXSampleHold;
extern T_SCHAR lYSampleHold;
extern T_UCHAR tZSampleHold;

extern T_SLONG lSIGDEF_XOUTPUT;
extern T_SLONG lSIGDEF_YOUTPUT;
extern T_UCHAR tSIGDEF_ZOUTPUT;

extern T_SLONG DAC_lookup[256];

extern T_ULONG lwTickMark;
extern T_UCHAR tLastRamp;
extern T_UCHAR tBright;

extern T_SLONG lX1,lY1;

extern T_UCHAR tOldBlank;
extern T_UCHAR tOldRamp;
extern T_UCHAR tOldZero;
extern T_UCHAR tOldSel;
extern T_UCHAR tOldShold;

extern T_SLONG lOldXSH;
extern T_SLONG lOldYSH;
extern T_UCHAR tOldZSH;

extern T_SLONG lOldSigX;
extern T_SLONG lOldSigY;
extern T_UCHAR tOldSigZ;

extern T_SCHAR tOldIntegratorOffset;
extern T_UCHAR tOldLastRamp;

extern T_SCHAR dac_offset;
extern T_SWORD integrator_offset_y;
extern T_SWORD integrator_offset_x;
#endif