/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : VECTREX HP3000 Analog CRT X,Y,Z & Compare Emulation Module */
/*                                                                           */
/*   File Name  : ANALOG.C                                                   */
/*                                                                           */
/*   Author     : Keith Wilkins / small changes by C.S.                      */
/*                                                                           */
/*   Version    : 1.20                                                       */
/*                                                                           */
/*   Desciption : The functions is this module are designed to emulate the   */
/*                analog portion of the Vectrex that generates the CRT X,Y   */
/*                and Z signals and the COMPARE signal that is used to       */
/*                perform the AtoD function for the Controller Pads.         */
/*                                                                           */
/*                The main fAnalogTick() function in this block emulates     */
/*                the analog functions for N ticks where a tick is the       */
/*                smallest unit of activity in the alanog block. It is the   */
/*                responsibility of the Sequencer to call this function at   */
/*                the appropriate time with an appropriate value for N       */
/*                                                                           */
/*   Functions  : fAnalogInit() - Initialise the Analog block                */
/*                fAnalogTick() - Simulate N time units                      */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    13/03/93  K.W  Creation                                        */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*    1.20    20/10/96  C.S  Public release of DVE V1.2                      */
/*                                                                           */
/*****************************************************************************/

#ifdef _NO_DEBUG_INFORMATION_

#include <stdlib.h>
#include <math.h>

#include <tools.h>
#include <standard.h>

//#include "font.h"
#include "display.h"
#include "emu6522.h"
#include "emu6809.h"
#include "keyboard.h"
#include "joystick.h"
#include "vdebug.h"
#include "verror.h"
#include "vectrex.h"
#include "sound.h"
#include "analog.h"
#include "analog2.h"

#endif //#ifdef _NO_DEBUG_INFORMATION_

#ifndef _NO_DEBUG_INFORMATION_

/*****************************************************************************/
/*                                                                           */
/*   Function    : fAnalogTick()                                             */
/*                                                                           */
/*   Author      : K.W                                                       */
/*                                                                           */
/*   Description : This function emulates the analog functions of the        */
/*                 vectrex. These functions produce the X,Y,Z deflection     */
/*                 signals for the CRT and the COMPARE signal for the        */
/*                 jostick AtoD system. The registers and values it needs    */
/*                 are taken from the 6522A Port A and B registers. The      */
/*                 value on port A is used as the DAC value an port B        */
/*                 is used for a number of the control lines that drive      */
/*                 the block such as SW,SEL0,SEL1,RAMP,BLANK.                */
/*                                                                           */
/*                -This function is sometimes inline in sequencer (6809...)  */
/*                -This function exists now 8 times, depending on            */
/*                 startup information the required is chosen at runtime     */
/*                                                                           */
/*                                                                           */
/*   Accepts     :                                                           */
/*                                                                           */
/*   Returns     : nothing                                                   */
/*                                                                           */
/*****************************************************************************/
#define ANTI_ALIASING

T_VOID fAnalogTick_linear_shift_aa(T_VOID)
#ifdef TRYING
{return ;}
#endif
#ifndef TRYING
#define ANALOG_TICK_LINEAR_SHIFT
#include "anatick.cc"
#undef ANALOG_TICK_LINEAR_SHIFT
#endif

T_VOID fAnalogTick_linear_div_aa(T_VOID)
#define ANALOG_TICK_LINEAR_DIV
#include "anatick.cc"
#undef ANALOG_TICK_LINEAR_DIV

T_VOID fAnalogTick_bank_shift_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_BANKED_SHIFT
#include "anatick.cc"
#undef ANALOG_TICK_BANKED_SHIFT
#endif

T_VOID fAnalogTick_bank_div_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_BANKED_DIV
#include "anatick.cc"
#undef ANALOG_TICK_BANKED_DIV
#endif

#define LIGHTPEN
T_VOID fAnalogTick_linear_shift_lightpen_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_LINEAR_SHIFT
#include "anatick.cc"
#undef ANALOG_TICK_LINEAR_SHIFT
#endif

T_VOID fAnalogTick_linear_div_lightpen_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_LINEAR_DIV
#include "anatick.cc"
#undef ANALOG_TICK_LINEAR_DIV
#endif

T_VOID fAnalogTick_bank_shift_lightpen_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_BANKED_SHIFT
#include "anatick.cc"
#undef ANALOG_TICK_BANKED_SHIFT
#endif

T_VOID fAnalogTick_bank_div_lightpen_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_BANKED_DIV
#include "anatick.cc"
#undef ANALOG_TICK_BANKED_DIV
#undef LIGHTPEN
#endif

#define ANALOG_IMAGER
T_VOID fAnalogTick_linear_shift_imager_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_IMAGER
#define ANALOG_TICK_LINEAR_SHIFT
#include "anatick.cc"
#undef ANALOG_TICK_LINEAR_SHIFT
#endif

T_VOID fAnalogTick_linear_div_imager_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_LINEAR_DIV
#include "anatick.cc"
#undef ANALOG_TICK_LINEAR_DIV
#endif

T_VOID fAnalogTick_bank_shift_imager_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_BANKED_SHIFT
#include "anatick.cc"
#undef ANALOG_TICK_BANKED_SHIFT
#endif

T_VOID fAnalogTick_bank_div_imager_aa(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define ANALOG_TICK_BANKED_DIV
#include "anatick.cc"
#undef ANALOG_TICK_BANKED_DIV
#endif

#undef ANALOG_IMAGER

#undef ANTI_ALIASING
#endif //#ifndef _NO_DEBUG_INFORMATION_


