/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex Cartridge ROM Emulation header file                */
/*                                                                           */
/*   File Name  : CART_ROM.H                                                 */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the function prototypes and definitions */
/*                for the functions that emulate the cartridge ROM           */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined CART_ROM_H
    #define CART_ROM_H

/* Define some base definitions */

#define CART_ROM_SIZE           0x8000

#define CART_ROM_ADDRESS_MASK   0x7FFF

#define CART_ROM_BASE           0x0000
#define CART_ROM_TOP            0x7FFF

#define CART_ROM_FILL_VALUE     0x0b     // Should cause an exception

/* Define function prototypes */
extern T_INT      (* fCartridgeROMLoad)(T_PUCHAR);
extern T_INT      (* fCartridgeROMSave)(T_PUCHAR);
extern T_UCHAR    (* fCartridgeROMRead)(T_UWORD);
extern T_UCHAR    (* fCartridgeROMWrite)(T_UWORD, T_UCHAR);

T_VOID set_cart_rom_functions(T_INT type);
#endif

/* End of CART_ROM.H */





























