/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : 6809 Emulator cycle count table                            */
/*                                                                           */
/*   File Name  : CNT6809.C                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains all of the cycle counts for all instrc. */
/*                these are the minimum count value, the code stubs can      */
/*                extend their own cycle counts.                             */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    02/06/95  K.W  Creation of empty stub file, description only   */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

// Define cycle counts, note that by default an instruction costs
// two cycles (Fetch+Decode), this table gives the number of additional
// cycles required, thus value given is the 6809 actual cycle count -2
// All CYCLESxNN values are in hexadecimal

#define    CYCLESx2    0
#define    CYCLESx3    1
#define    CYCLESx4    2
#define    CYCLESx5    3
#define    CYCLESx6    4
#define    CYCLESx7    5
#define    CYCLESx8    6
#define    CYCLESx9    7
#define    CYCLESxB    9
#define    CYCLESx13   17
#define    CYCLESx14   18


T_SWORD cycle_count[0x10000];


const T_SWORD packed_cycle_count[0x300]=
{

   // 0x00

   CYCLESx6,    // NEG
   -1,          // *
   -1,          // *
   CYCLESx6,    // COM
   CYCLESx6,    // LSR
   -1,          // *
   CYCLESx6,    // ROR
   CYCLESx6,    // ASR
   CYCLESx6,    // ASL,LSL
   CYCLESx6,    // DEC
   CYCLESx6,    // ROL
   -1,          // *
   CYCLESx6,    // INC
   CYCLESx6,    // TST
   CYCLESx3,    // JMP
   CYCLESx6,    // CLR

   // 0x10

   -1,          // Page 2 opcode
   -1,          // Page 3 opcode
   CYCLESx2,    // NOP
   CYCLESx4,    // SYNC
   -1,          // *
   -1,          // *
   CYCLESx5,    // LBRA
   CYCLESx9,    // LBSR
   -1,          // *
   CYCLESx2,    // DAA
   CYCLESx3,    // ORCC
   -1,          // *
   CYCLESx3,    // ANDCC
   CYCLESx2,    // SEX
   CYCLESx8,    // EXG
   CYCLESx6,    // TFR

   // 0x20

   CYCLESx3,    // BRA
   CYCLESx3,    // BRN
   CYCLESx3,    // BHI
   CYCLESx3,    // BLS
   CYCLESx3,    // BHS,BCC
   CYCLESx3,    // BLO,BCS
   CYCLESx3,    // BNE
   CYCLESx3,    // BEQ
   CYCLESx3,    // BVC
   CYCLESx3,    // BVS
   CYCLESx3,    // BPL
   CYCLESx3,    // BMI
   CYCLESx3,    // BGE
   CYCLESx3,    // BLT
   CYCLESx3,    // BGT
   CYCLESx3,    // BLE

   // 0x30

   CYCLESx4,    // LEAX
   CYCLESx4,    // LEAY
   CYCLESx4,    // LEAS
   CYCLESx4,    // LEAU
   CYCLESx5,    // PSHS
   CYCLESx5,    // PULS
   CYCLESx5,    // PSHU
   CYCLESx5,    // PULU
   -1,          // *
   CYCLESx5,    // RTS
   CYCLESx3,    // ABX
   CYCLESx6,    // RTI
   CYCLESx14,   // CWAI
   CYCLESxB,    // MUL
   -1,          // *
   CYCLESx13,    // SWI

   // 0x40

   CYCLESx2,    // NEGA
   -1,          // *
   -1,          // *
   CYCLESx2,    // COMA
   CYCLESx2,    // LSRA
   -1,          // *
   CYCLESx2,    // RORA
   CYCLESx2,    // ASRA
   CYCLESx2,    // ASLA,LSLA
   CYCLESx2,    // ROLA
   CYCLESx2,    // DECA
   -1,          // *
   CYCLESx2,    // INCA
   CYCLESx2,    // TSTA
   -1,          // *
   CYCLESx2,    // CLRA

   // 0x50

   CYCLESx2,    // NEGB
   -1,          // *
   -1,          // *
   CYCLESx2,    // COMB
   CYCLESx2,    // LSRB
   -1,          // *
   CYCLESx2,    // RORB
   CYCLESx2,    // ASRB
   CYCLESx2,    // ASLB,LSLB
   CYCLESx2,    // ROLB
   CYCLESx2,    // DECB
   -1,          // *
   CYCLESx2,    // INCB
   CYCLESx2,    // TSTB
   -1,          // *
   CYCLESx2,    // CLRB

   // 0x60

   CYCLESx6,    // NEG
   -1,          // *
   -1,          // *
   CYCLESx6,    // COM
   CYCLESx6,    // LSR
   -1,          // *
   CYCLESx6,    // ROR
   CYCLESx6,    // ASR
   CYCLESx6,    // ASL,LSL
   CYCLESx6,    // ROL
   CYCLESx6,    // DEC
   -1,          // *
   CYCLESx6,    // INC
   CYCLESx6,    // TST
   CYCLESx3,    // JMP
   CYCLESx6,    // CLR

   // 0x70

   CYCLESx7,    // NEG
   -1,          // *
   -1,          // *
   CYCLESx7,    // COM
   CYCLESx7,    // LSR
   -1,          // *
   CYCLESx7,    // ROR
   CYCLESx7,    // ASR
   CYCLESx7,    // ASL,LSL
   CYCLESx7,    // ROL
   CYCLESx7,    // DEC
   -1,          // *
   CYCLESx7,    // INC
   CYCLESx7,    // TST
   CYCLESx4,    // JMP
   CYCLESx7,    // CLR

   // 0x80

   CYCLESx2,    // SUBA
   CYCLESx2,    // CMPA
   CYCLESx2,    // SBCA
   CYCLESx4,    // SUBD
   CYCLESx2,    // ANDA
   CYCLESx2,    // BITA
   CYCLESx2,    // LDA
   -1,          // *
   CYCLESx2,    // EORA
   CYCLESx2,    // ADCA
   CYCLESx2,    // ORA
   CYCLESx2,    // ADDA
   CYCLESx4,    // CMPX
   CYCLESx7,    // BSR
   CYCLESx3,    // LDX
   -1,          // *

   // 0x90

   CYCLESx4,    // SUBA
   CYCLESx4,    // CMPA
   CYCLESx4,    // SBCA
   CYCLESx6,    // SUBD
   CYCLESx4,    // ANDA
   CYCLESx4,    // BITA
   CYCLESx4,    // LDA
   CYCLESx4,    // STA
   CYCLESx4,    // EORA
   CYCLESx4,    // ADCA
   CYCLESx4,    // ORA
   CYCLESx4,    // ADDA
   CYCLESx6,    // CMPX
   CYCLESx7,    // JSR
   CYCLESx5,    // LDX
   CYCLESx5,    // STX

   // 0xA0

   CYCLESx4,    // SUBA
   CYCLESx4,    // CMPA
   CYCLESx4,    // SBCA
   CYCLESx6,    // SUBD
   CYCLESx4,    // ANDA
   CYCLESx4,    // BITA
   CYCLESx4,    // LDA
   CYCLESx4,    // STA
   CYCLESx4,    // EORA
   CYCLESx4,    // ADCA
   CYCLESx4,    // ORA
   CYCLESx4,    // ADDA
   CYCLESx6,    // CMPX
   CYCLESx7,    // JSR
   CYCLESx5,    // LDX
   CYCLESx5,    // STX

   // 0xB0

   CYCLESx5,    // SUBA
   CYCLESx5,    // CMPA
   CYCLESx5,    // SBCA
   CYCLESx7,    // SUBD
   CYCLESx5,    // ANDA
   CYCLESx5,    // BITA
   CYCLESx5,    // LDA
   CYCLESx5,    // STA
   CYCLESx5,    // EORA
   CYCLESx5,    // ADCA
   CYCLESx5,    // ORA
   CYCLESx5,    // ADDA
   CYCLESx7,    // CMPX
   CYCLESx8,    // JSR
   CYCLESx6,    // LDX
   CYCLESx6,    // STX

   // 0xC0

   CYCLESx2,    // SUBB
   CYCLESx2,    // CMPB
   CYCLESx2,    // SBCB
   CYCLESx4,    // ADDD
   CYCLESx2,    // ANDB
   CYCLESx2,    // BITB
   CYCLESx2,    // LDB
   -1,          // *
   CYCLESx2,    // EORB
   CYCLESx2,    // ADCB
   CYCLESx2,    // ORB
   CYCLESx2,    // ADDB
   CYCLESx3,    // LDD
   -1,          // *
   CYCLESx3,    // LDU
   -1,          // *

   // 0xD0

   CYCLESx4,    // SUBB
   CYCLESx4,    // CMPB
   CYCLESx4,    // SBCB
   CYCLESx6,    // ADDD
   CYCLESx4,    // ANDB
   CYCLESx4,    // BITB
   CYCLESx4,    // LDB
   CYCLESx4,    // STB
   CYCLESx4,    // EORB
   CYCLESx4,    // ADCB
   CYCLESx4,    // ORB
   CYCLESx4,    // ADDB
   CYCLESx5,    // LDD
   CYCLESx5,    // STD
   CYCLESx5,    // LDU
   CYCLESx5,    // STU

   // 0xE0

   CYCLESx4,    // SUBB
   CYCLESx4,    // CMPB
   CYCLESx4,    // SBCB
   CYCLESx6,    // ADDD
   CYCLESx4,    // ANDB
   CYCLESx4,    // BITB
   CYCLESx4,    // LDB
   CYCLESx4,    // STB
   CYCLESx4,    // EORB
   CYCLESx4,    // ADCB
   CYCLESx4,    // ORB
   CYCLESx4,    // ADDB
   CYCLESx5,    // LDD
   CYCLESx5,    // STD
   CYCLESx5,    // LDU
   CYCLESx5,    // STU

   // 0xF0

   CYCLESx5,    // SUBB
   CYCLESx5,    // CMPB
   CYCLESx5,    // SBCB
   CYCLESx7,    // ADDD
   CYCLESx5,    // ANDB
   CYCLESx5,    // BITB
   CYCLESx5,    // LDB
   CYCLESx5,    // STB
   CYCLESx5,    // EORB
   CYCLESx5,    // ADCB
   CYCLESx5,    // ORB
   CYCLESx5,    // ADDB
   CYCLESx6,    // LDD
   CYCLESx6,    // STD
   CYCLESx6,    // LDU
   CYCLESx6,    // STU

//
// PAGE 2 OPCODES
//


   // 0x100

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x110

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x120

   -1,
   CYCLESx4,    // LBRN
   CYCLESx5,    // LBHI
   CYCLESx5,    // LBLS
   CYCLESx5,    // LBHS,LBCC
   CYCLESx5,    // LBCS,LBLO
   CYCLESx5,    // LBNE
   CYCLESx5,    // LBEQ
   CYCLESx5,    // LBVC
   CYCLESx5,    // LBVS
   CYCLESx5,    // LBPL
   CYCLESx5,    // LBMI
   CYCLESx5,    // LBGE
   CYCLESx5,    // LBLT
   CYCLESx5,    // LBGT
   CYCLESx5,    // LBLE

   // 0x130

   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx14,   // SWI2

   // 0x140

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x150

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x160

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x170

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x180

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx5,    // CMPD
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx5,    // CMPY
   -1,          // *
   CYCLESx4,    // LDY
   -1,          // *

   // 0x190

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPD
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPY
   -1,          // *
   CYCLESx6,    // LDY
   CYCLESx6,    // STY

   // 0x1A0

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPD
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPY
   -1,          // *
   CYCLESx6,    // LDY
   CYCLESx6,    // STY

   // 0x1B0

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx8,    // CMPD
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx8,    // CMPY
   -1,          // *
   CYCLESx7,    // LDY
   CYCLESx7,    // STY

   // 0x1C0

   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx4,    // LDS
   -1,          // *

   // 0x1D0

   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx6,    // LDS
   CYCLESx6,    // STS

   // 0x1E0

   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx6,    // LDS
   CYCLESx6,    // STS

   // 0x1F0

   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // LDS
   CYCLESx7,    // STS

//
// PAGE 3 OPCODES
//


   // 0x200

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x210

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x220

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x230

   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx14,    // SWI3


   // 0x240

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x250

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x260

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x270

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x280

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx5,    // CMPU
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx5,    // CMPS
   -1,          // *
   -1,          // *
   -1,          // *

   // 0x290

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPU
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPS
   -1,          // *
   -1,          // *
   -1,          // *

   // 0x2A0

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPU
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx7,    // CMPS
   -1,          // *
   -1,          // *
   -1,          // *


   // 0x2B0

   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx8,    // CMPU
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   -1,          // *
   CYCLESx8,    // CMPS
   -1,          // *
   -1,          // *
   -1,          // *


   // 0x2C0

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x2D0

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x2E0

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,

   // 0x2F0

   -1,-1,-1,-1,-1,-1,-1,-1,
   -1,-1,-1,-1,-1,-1,-1,-1,
};

/* END OF FILE */


