;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator code functions per instruction               *
;*                                                                           *
;*   File Name  : COD6809.ASM                                                *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the function code to execute any given  *
;*                processor instruction.                                     *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    18/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    06/08/96  K.W  Public release of DVE 1.0                       *
;*                                                                           *
;*****************************************************************************

extern _f6809AddressRead:near
extern _f6809AddressWrite:near
extern pshs6809_FF_:near
extern pshs6809_81_:near
extern puls6809_FF_:near
extern puls6809_81_:near
extern _atSystemImage:near
extern _apfWriteHandlers:near
extern _apfReadHandlers:near
extern _apfExecuteInstruction:near


extern _Idx6809JumpTable:near
extern _Tfr6809JumpTable:near
extern _Exg6809JumpTable:near
extern _Pshs6809JumpTable:near
extern _Puls6809JumpTable:near
extern _Pshu6809JumpTable:near
extern _Pulu6809JumpTable:near


include "reg6809.h"
include "mac6809.h"


_COD6809_TEXT segment dword public 'CODE'
              assume  CS:_COD6809_TEXT


;=========================
; SAVE CC FOR KERNAL
;=========================

           PUBLIC  f6809Init8086CC_

f6809Init8086CC_  PROC    near

           m_entry
           m_putcc
           m_exit

f6809Init8086CC_  ENDP



;=========================
; Fetch CC into DL
;=========================

               PUBLIC  f6809cctodl_

f6809cctodl_   PROC    near
;
; BX must be preserved
;

               mov dl,[R6809_CC]
               and dl,0xd0         ; Knock of all of the old crap

               mov     cx,[R6809_8086CC]

               sar     cx,1        ; Test carry bit
               jnc     cctodl_00
               or      dl,0x01     ; Set carry flag
cctodl_00:
               sar     cx,4        ; Test aux carry
               jnc     cctodl_01
               or      dl,0x20     ; Set aux carry
cctodl_01:
               sar     cx,2        ; Test zero bit
               jnc     cctodl_02
               or      dl,0x04     ; Set zero
cctodl_02:
               sar     cx,1        ; Test negative bit
               jnc     cctodl_03
               or      dl,0x08     ; Set negative
cctodl_03:
               sar     cx,4        ; Test overflow
               jnc     cctodl_04
               or      dl,0x02     ; Set overflow
cctodl_04:
               mov     [R6809_CC],dl

               ret

f6809cctodl_   ENDP



;=========================
; Convert DL into CC
;=========================

               PUBLIC  f6809dltocc_

f6809dltocc_   PROC    near
;
; BX must be preserved
;

               mov     cx,[R6809_8086CC]
               and     cx,0xf72e   ; Remove old crap

               ; Copy over complete to 6809_CC
               ; as flags will always be updated before use

               mov     [R6809_CC],dl

               ; Test each bit of the Mask and set/clear on that basis in CX

               sar     dl,1        ; Test carry bit
               jnc     dltocc_00
               or      cx,0x0001   ; Set carry
dltocc_00:
               sar     dl,1        ; Test overflow bit
               jnc     dltocc_01
               or      cx,0x0800   ; Set overflow
dltocc_01:
               sar     dl,1        ; Test zero bit
               jnc     dltocc_02
               or      cx,0x0040   ; Set zero
dltocc_02:
               sar     dl,1        ; Test negative bit
               jnc     dltocc_03
               or      cx,0x0080   ; Set negative
dltocc_03:
               sar     dl,2        ; Test Half carry
               jnc     dltocc_04
               or      cx,0x0010   ; Set half carry
dltocc_04:
               mov     [R6809_8086CC],cx

               ret

f6809dltocc_   ENDP





;=========================
; FIRQ - inherent
;=========================

               PUBLIC  f6809FIRQ_

f6809FIRQ_     PROC    near

               m_entry

               mov     bl,[R6809_CC]
               and     bl,0x7f
               mov     [R6809_CC],bl

               call    pshs6809_81_

               mov     bl,[R6809_CC]
               or      bl,0x50
               mov     [R6809_CC],bl

               m_exit

f6809FIRQ_     ENDP



;=========================
; IRQ - inherent
;=========================

               PUBLIC  f6809IRQ_

f6809IRQ_      PROC    near

               m_entry

               mov     bl,[R6809_CC]
               or      bl,0x80
               mov     [R6809_CC],bl

               call    pshs6809_FF_

               mov     bl,[R6809_CC]
               or      bl,0x10
               mov     [R6809_CC],bl

               m_exit

f6809IRQ_      ENDP








;**********************************
;                                 *
; Base code emulation is beyond   *
;                                 *
; this point                      *
;                                 *
;**********************************
;
; Register usage
;
;  AX = Temporary
;  BX = Address
;  DX = Data
;  CX = Temporary **** Dont forget m_getcc corrupts cx ****
;
; Return value (Number of additional cycles)
; is pushed to stack by ALL memory access macros
; the EXIT_M pops it into AX before return
;
; All memory access macros give address in BX
;
; m_fetch08 & m_store08 use DL for data, AX for address





;=========================
; NEGate - direct
;=========================

               PUBLIC  f6809_P1_00_

f6809_P1_00_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_neg
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_00_   ENDP




;=========================
; COM - direct page
;=========================

               PUBLIC  f6809_P1_03_

f6809_P1_03_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_com
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_03_   ENDP




;=========================
; LSR - Direct page
;=========================

               PUBLIC  f6809_P1_04_

f6809_P1_04_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_lsr
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_04_   ENDP




;=========================
; ROR - direct page
;=========================

               PUBLIC  f6809_P1_06_

f6809_P1_06_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_ror
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_06_   ENDP




;=========================
; ASR - direct page
;=========================

               PUBLIC  f6809_P1_07_

f6809_P1_07_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_asr
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_07_   ENDP




;=========================
; ASL - direct page
;=========================

               PUBLIC  f6809_P1_08_

f6809_P1_08_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_asl
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_08_   ENDP




;=========================
; ROL - direct page
;=========================

               PUBLIC  f6809_P1_09_

f6809_P1_09_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_rol
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_09_   ENDP




;=========================
; DEC - direct page
;=========================

               PUBLIC  f6809_P1_0A_

f6809_P1_0A_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_dec
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_0A_   ENDP





;=========================
; INC - direct page
;=========================

               PUBLIC  f6809_P1_0C_

f6809_P1_0C_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_inc
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_0C_   ENDP




;=========================
; TST - direct page
;=========================

               PUBLIC  f6809_P1_0D_

f6809_P1_0D_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_tst08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_0D_   ENDP




;=========================
; JMP - direct page
;=========================

               PUBLIC  f6809_P1_0E_

f6809_P1_0E_   PROC    near

               m_entry

               m_drect
               m_jmp
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_0E_   ENDP



;=========================
; CLR - direct page
;=========================

               PUBLIC  f6809_P1_0F_

f6809_P1_0F_   PROC    near

               m_entry

               m_drect
               m_clr
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_0F_   ENDP




;=========================
; PAGE1 - Non standard
;=========================

               PUBLIC  f6809_P1_10_

f6809_P1_10_   PROC    near

               m_entry

               xor     ebx,ebx
               xor     eax,eax
               m_imm08
               add     ebx,0x100
               jmp     dword ptr _apfExecuteInstruction[ebx*4];

f6809_P1_10_   ENDP




;=========================
; PAGE2 - Non standard
;=========================

               PUBLIC  f6809_P1_11_

f6809_P1_11_   PROC    near

               m_entry

               xor     ebx,ebx
               xor     eax,eax
               m_imm08
               add     ebx,0x200
               jmp     dword ptr _apfExecuteInstruction[ebx*4];

f6809_P1_11_   ENDP




;=========================
; NOP - inherent
;=========================

               PUBLIC  f6809_P1_12_

f6809_P1_12_   PROC    near

               m_entry
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_12_   ENDP




;=========================
; SYNC - inherent
;=========================

               PUBLIC  f6809_P1_13_

f6809_P1_13_   PROC    near

               m_entry
               mov     ax,CPU_SYNC
               m_exit

f6809_P1_13_   ENDP




;=========================
; LBRA - Relative
;=========================

               PUBLIC  f6809_P1_16_

f6809_P1_16_   PROC    near

               m_entry

               m_lrl16
               m_jmp
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_16_   ENDP




;=========================
; LBSR - relative
;=========================

               PUBLIC  f6809_P1_17_

f6809_P1_17_   PROC    near

               m_entry

               m_lrl16
               m_jsr
               mov    ax,CPU_FETCH

               m_exit

f6809_P1_17_   ENDP





;=========================
; DAA - inherent
;=========================

               PUBLIC  f6809_P1_19_

f6809_P1_19_   PROC    near

               m_entry

               mov     al,[R6809_A]
               m_getcc
               daa
               m_putcc
               mov     [R6809_A],al

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_19_   ENDP




;=========================
; ORCC - immediate
;=========================

               PUBLIC  f6809_P1_1A_

f6809_P1_1A_   PROC    near

               m_entry
               m_imm08         ; Mask in bl

               or      [R6809_CC],bl   ; Fix the unused flags correctly

               mov     cx,[R6809_8086CC]

               ; Test each bit of the Mask and set/clear on that basis in CX

               sar     bl,1        ; Test carry bit
               jnc     P1_1A_00
               or      cx,0x0001   ; Set carry
P1_1A_00:
               sar     bl,1        ; Test overflow bit
               jnc     P1_1A_01
               or      cx,0x0800   ; Set overflow
P1_1A_01:
               sar     bl,1        ; Test zero bit
               jnc     P1_1A_02
               or      cx,0x0040   ; Set zero
P1_1A_02:
               sar     bl,1        ; Test negative bit
               jnc     P1_1A_03
               or      cx,0x0080   ; Set negative
P1_1A_03:
               sar     bl,2        ; Test Half carry
               jnc     P1_1A_04
               or      cx,0x0010   ; Set half carry
P1_1A_04:
               mov     [R6809_8086CC],cx

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_1A_   ENDP



;=========================
; ANDCC - immediate
;=========================

               PUBLIC  f6809_P1_1C_

f6809_P1_1C_   PROC    near

               m_entry
               m_imm08         ; Mask in bl

               and     [R6809_CC],bl   ; Fix the unused flags correctly

               mov     cx,[R6809_8086CC]

               ; Test each bit of the Mask and set/clear on that basis in CX

               sar     bl,1        ; Test carry bit
               jc      P1_1C_00
               and     cx,0xfffe   ; Clear carry
P1_1C_00:
               sar     bl,1        ; Test overflow bit
               jc      P1_1C_01
               and     cx,0xf7ff   ; Clear overflow
P1_1C_01:
               sar     bl,1        ; Test zero bit
               jc      P1_1C_02
               and     cx,0xffbf   ; Clear zero
P1_1C_02:
               sar     bl,1        ; Test negative bit
               jc      P1_1C_03
               and     cx,0xff7f   ; Clear negative
P1_1C_03:
               sar     bl,2        ; Test Half carry
               jc      P1_1C_04
               and     cx,0xffef   ; Clear half carry
P1_1C_04:
               mov     [R6809_8086CC],cx

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_1C_   ENDP



;=========================
; SEX - inherent
;=========================

               PUBLIC  f6809_P1_1D_

f6809_P1_1D_   PROC    near

               m_entry

               mov     dl,[R6809_B]
               m_getcc
               movsx   bx,dl
               m_putcc
               mov     [R6809_D],bx

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_1D_   ENDP




;=========================
; EXG - immediate
;=========================

               PUBLIC  f6809_P1_1E_

f6809_P1_1E_   PROC    near

               m_entry
               xor     ebx,ebx
               m_imm08

               call    dword ptr _Exg6809JumpTable[ebx*4]

               m_exit

f6809_P1_1E_   ENDP




;=========================
; TFR - immediate
;=========================

               PUBLIC  f6809_P1_1F_

f6809_P1_1F_   PROC    near

               m_entry
               xor     ebx,ebx
               m_imm08

               call    dword ptr _Tfr6809JumpTable[ebx*4]

               m_exit

f6809_P1_1F_   ENDP




;=========================
; BRA - Relative
;=========================

               PUBLIC  f6809_P1_20_

f6809_P1_20_   PROC    near

               m_entry
               m_rel16

               mov     [R6809_PC],bx

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_20_   ENDP



;=========================
; BRN - Relative
;=========================

               PUBLIC  f6809_P1_21_

f6809_P1_21_   PROC    near

               m_entry
               m_rel16
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_21_   ENDP




;=========================
; BHI - Relative
;=========================

               PUBLIC  f6809_P1_22_

f6809_P1_22_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jbe     P1_22_00
               mov     [R6809_PC],bx
P1_22_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_22_   ENDP




;=========================
; BLS - Relative
;=========================

               PUBLIC  f6809_P1_23_

f6809_P1_23_   PROC    near

               m_entry
               m_rel16
               m_getcc

               ja      P1_23_00
               mov     [R6809_PC],bx
P1_23_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_23_   ENDP




;=========================
; BHS/BCC - Relative
;=========================

               PUBLIC  f6809_P1_24_

f6809_P1_24_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jc      P1_24_00
               mov     [R6809_PC],bx
P1_24_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_24_   ENDP




;=========================
; BLO/BCS - Relative
;=========================

               PUBLIC  f6809_P1_25_

f6809_P1_25_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jnc     P1_25_00
               mov     [R6809_PC],bx
P1_25_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_25_   ENDP




;=========================
; BNE - Relative
;=========================

               PUBLIC  f6809_P1_26_

f6809_P1_26_   PROC    near

               m_entry
               m_rel16
               m_getcc

               je      P1_26_00
               mov     [R6809_PC],bx
P1_26_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_26_   ENDP




;=========================
; BEQ - Relative
;=========================

               PUBLIC  f6809_P1_27_

f6809_P1_27_   PROC    near

               m_entry
               m_getcc

               jne     P1_27_00

               m_rel16
               mov     [R6809_PC],bx
               mov     ax,CPU_FETCH
               m_exit
P1_27_00:
               inc     WORD [R6809_PC]
               mov     ax,CPU_FETCH
               m_exit

;               m_entry
;               m_rel16
;               m_getcc
;
;               jne     P1_27_00
;               mov     [R6809_PC],bx
;P1_27_00:
;               mov     ax,CPU_FETCH
;               m_exit


f6809_P1_27_   ENDP




;=========================
; BVC - Relative
;=========================

               PUBLIC  f6809_P1_28_

f6809_P1_28_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jo      P1_28_00
               mov     [R6809_PC],bx
P1_28_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_28_   ENDP




;=========================
; BVS - Relative
;=========================

               PUBLIC  f6809_P1_29_

f6809_P1_29_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jno     P1_29_00
               mov     [R6809_PC],bx
P1_29_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_29_   ENDP




;=========================
; BPL - Relative
;=========================

               PUBLIC  f6809_P1_2A_

f6809_P1_2A_   PROC    near

               m_entry
               m_rel16
               m_getcc

               js      P1_2A_00
               mov     [R6809_PC],bx
P1_2A_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_2A_   ENDP




;=========================
; BMI - Relative
;=========================

               PUBLIC  f6809_P1_2B_

f6809_P1_2B_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jns     P1_2B_00
               mov     [R6809_PC],bx
P1_2B_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_2B_   ENDP




;=========================
; BGE - Relative
;=========================

               PUBLIC  f6809_P1_2C_

f6809_P1_2C_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jl      P1_2C_00
               mov     [R6809_PC],bx
P1_2C_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_2C_   ENDP




;=========================
; BLT - Relative
;=========================

               PUBLIC  f6809_P1_2D_

f6809_P1_2D_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jge     P1_2D_00
               mov     [R6809_PC],bx
P1_2D_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_2D_   ENDP




;=========================
; BGT - Relative
;=========================

               PUBLIC  f6809_P1_2E_

f6809_P1_2E_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jle     P1_2E_00
               mov     [R6809_PC],bx
P1_2E_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_2E_   ENDP




;=========================
; BLE - Relative
;=========================

               PUBLIC  f6809_P1_2F_

f6809_P1_2F_   PROC    near

               m_entry
               m_rel16
               m_getcc

               jg      P1_2F_00
               mov     [R6809_PC],bx
P1_2F_00:
               mov     ax,CPU_FETCH
               m_exit

f6809_P1_2F_   ENDP




;=========================
; LEAX - Indexed
;=========================

               PUBLIC  f6809_P1_30_

f6809_P1_30_   PROC    near

               m_entry
               m_index
               push    ax

               mov     [R6809_X],bx
               and     WORD [R6809_8086CC],0xffbf
               cmp     bx,0
               jne     P1_30_00
               or      WORD [R6809_8086CC],0x0040
P1_30_00:
               pop     ax
               m_exit

f6809_P1_30_   ENDP




;=========================
; LEAY - Indexed
;=========================

               PUBLIC  f6809_P1_31_

f6809_P1_31_   PROC    near

               m_entry
               m_index
               push    ax

               mov     [R6809_Y],bx
               and     WORD [R6809_8086CC],0xffbf
               cmp     bx,0
               jne     P1_31_00
               or      WORD [R6809_8086CC],0x0040
P1_31_00:
               pop     ax
               m_exit

f6809_P1_31_   ENDP




;=========================
; LEAS - Indexed
;=========================

               PUBLIC  f6809_P1_32_

f6809_P1_32_   PROC    near

               m_entry
               m_index
               push    ax

               mov     [R6809_HSP],bx
               and     WORD [R6809_8086CC],0xffbf
               cmp     bx,0
               jne     P1_32_00
               or      WORD [R6809_8086CC],0x0040
P1_32_00:
               pop     ax
               m_exit

f6809_P1_32_   ENDP




;=========================
; LEAU - Indexed
;=========================

               PUBLIC  f6809_P1_33_

f6809_P1_33_   PROC    near

               m_entry
               m_index
               push    ax

               mov     [R6809_USP],bx
               and     WORD [R6809_8086CC],0xffbf
               cmp     bx,0
               jne     P1_30_00
               or      WORD [R6809_8086CC],0x0040
P1_33_00:
               pop     ax
               m_exit

f6809_P1_33_   ENDP




;=========================
; PSHS - immediate
;=========================

               PUBLIC  f6809_P1_34_

f6809_P1_34_   PROC    near

               m_entry
               xor     ebx,ebx
               m_imm08

               call    dword ptr _Pshs6809JumpTable[ebx*4]

               m_exit

f6809_P1_34_   ENDP




;=========================
; PULS - immediate
;=========================

               PUBLIC  f6809_P1_35_

f6809_P1_35_   PROC    near

               m_entry
               xor     ebx,ebx
               m_imm08

               call    dword ptr _Puls6809JumpTable[ebx*4]

               m_exit

f6809_P1_35_   ENDP




;=========================
; PSHU - immediate
;=========================

               PUBLIC  f6809_P1_36_

f6809_P1_36_   PROC    near

               m_entry
               xor     ebx,ebx
               m_imm08

               call    dword ptr _Pshu6809JumpTable[ebx*4]

               m_exit

f6809_P1_36_   ENDP




;=========================
; PULU - immediate
;=========================

               PUBLIC  f6809_P1_37_

f6809_P1_37_   PROC    near

               m_entry
               xor     ebx,ebx
               m_imm08

               call    dword ptr _Pulu6809JumpTable[ebx*4]

               m_exit

f6809_P1_37_   ENDP




;=========================
; RTS
;=========================

               PUBLIC  f6809_P1_39_

f6809_P1_39_   PROC    near

               m_entry

               m_rts

               m_exit

f6809_P1_39_   ENDP




;=========================
; ABX - Inherent
;=========================

               PUBLIC  f6809_P1_3A_

f6809_P1_3A_   PROC    near

               m_entry

               xor     ebx,ebx
               mov     bl,[R6809_B]
               add     [R6809_X],bx

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_3A_   ENDP




;=========================
; RTI - Inherent
;=========================

               PUBLIC  f6809_P1_3B_

f6809_P1_3B_   PROC    near

               m_entry

               mov     al,[R6809_CC]
               and     al,0x80
               cmp     al,0x80
               je      P1_3B_00
               call    puls6809_81_
               jmp     P1_3B_01
P1_3B_00:
               call    puls6809_FF_
P1_3B_01:
               m_exit

f6809_P1_3B_   ENDP




;=========================
; CWAI - Immediate 08
;=========================

               PUBLIC  f6809_P1_3C_

f6809_P1_3C_   PROC    near

               m_entry
               m_imm08

               mov     al,[R6809_CC]
               or      al,0x80             ; Set FULL flag
               and     al,bl
               mov     [R6809_CC],al

               call    pshs6809_FF_

               mov     ax,CPU_CWAI
               m_exit

f6809_P1_3C_   ENDP




;=========================
; MUL - Inherent
;=========================

               PUBLIC  f6809_P1_3D_

f6809_P1_3D_   PROC    near

               m_entry

               mov     dl,[R6809_A]
               mov     al,[R6809_B]
               m_getcc
               mul     dl
               m_putcc
               mov     [R6809_D],ax

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_3D_   ENDP




;=========================
; SWI -Inherent
;=========================

               PUBLIC  f6809_P1_3F_

f6809_P1_3F_   PROC    near

               m_entry

               mov     al,[R6809_CC]
               or      al,0x80             ; Set FULL flag
               mov     [R6809_CC],al

               call    pshs6809_FF_        ; Save context

               mov     al,[R6809_CC]       ; Disable interrupts
               or      al,0x50
               mov     [R6809_CC],al

               mov     bx,0xfffa           ; Fetch int vector
               m_fetch16
               mov     [R6809_PC],dx

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_3F_   ENDP




;=========================
; NEGA - Inherent
;=========================

               PUBLIC  f6809_P1_40_

f6809_P1_40_   PROC    near

               m_entry

               m_fetch_a
               m_neg
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_40_   ENDP




;=========================
; COMA - Inherent
;=========================

               PUBLIC  f6809_P1_43_

f6809_P1_43_   PROC    near

               m_entry

               m_fetch_a
               m_com
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_43_   ENDP




;=========================
; LSRA - Inherent
;=========================

               PUBLIC  f6809_P1_44_

f6809_P1_44_   PROC    near

               m_entry

               m_fetch_a
               m_lsr
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_44_   ENDP




;=========================
; RORA - Inherent
;=========================

               PUBLIC  f6809_P1_46_

f6809_P1_46_   PROC    near

               m_entry

               m_fetch_a
               m_ror
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_46_   ENDP




;=========================
; ASRA - Inherent
;=========================

               PUBLIC  f6809_P1_47_

f6809_P1_47_   PROC    near

               m_entry

               m_fetch_a
               m_asr
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_47_   ENDP




;=========================
; ASLA - Inherent
;=========================

               PUBLIC  f6809_P1_48_

f6809_P1_48_   PROC    near

               m_entry

               m_fetch_a
               m_asl
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_48_   ENDP




;=========================
; ROLA - Inherent
;=========================

               PUBLIC  f6809_P1_49_

f6809_P1_49_   PROC    near

               m_entry

               m_fetch_a
               m_rol
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_49_   ENDP




;=========================
; DECA - Inherent
;=========================

               PUBLIC  f6809_P1_4A_

f6809_P1_4A_   PROC    near

               m_entry

               m_fetch_a
               m_dec
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_4A_   ENDP




;=========================
; INCA - Inherent
;=========================

               PUBLIC  f6809_P1_4C_

f6809_P1_4C_   PROC    near

               m_entry

               m_fetch_a
               m_inc
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_4C_   ENDP




;=========================
; TSTA - Inherent
;=========================

               PUBLIC  f6809_P1_4D_

f6809_P1_4D_   PROC    near

               m_entry

               m_fetch_a
               m_tst08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_4D_   ENDP




;=========================
; CLRA - Inherent
;=========================

               PUBLIC  f6809_P1_4F_

f6809_P1_4F_   PROC    near

               m_entry

               m_clr
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_4F_   ENDP




;=========================
; NEGB - Inherent
;=========================

               PUBLIC  f6809_P1_50_

f6809_P1_50_   PROC    near

               m_entry

               m_fetch_b
               m_neg
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_50_   ENDP




;=========================
; COMB - Inherent
;=========================

               PUBLIC  f6809_P1_53_

f6809_P1_53_   PROC    near

               m_entry

               m_fetch_b
               m_com
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_53_   ENDP




;=========================
; LSRB - Inherent
;=========================

               PUBLIC  f6809_P1_54_

f6809_P1_54_   PROC    near

               m_entry

               m_fetch_b
               m_lsr
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_54_   ENDP




;=========================
; RORB - Inherent
;=========================

               PUBLIC  f6809_P1_56_

f6809_P1_56_   PROC    near

               m_entry

               m_fetch_b
               m_ror
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_56_   ENDP




;=========================
; ASRB - Inherent
;=========================

               PUBLIC  f6809_P1_57_

f6809_P1_57_   PROC    near

               m_entry

               m_fetch_b
               m_asr
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_57_   ENDP




;=========================
; ASLB - Inherent
;=========================

               PUBLIC  f6809_P1_58_

f6809_P1_58_   PROC    near

               m_entry

               m_fetch_b
               m_asl
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_58_   ENDP




;=========================
; ROLB - Inherent
;=========================

               PUBLIC  f6809_P1_59_

f6809_P1_59_   PROC    near

               m_entry

               m_fetch_b
               m_rol
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_59_   ENDP




;=========================
; DECB - Inherent
;=========================

               PUBLIC  f6809_P1_5A_

f6809_P1_5A_   PROC    near

               m_entry

               m_fetch_b
               m_dec
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_5A_   ENDP




;=========================
; INCB - Inherent
;=========================

               PUBLIC  f6809_P1_5C_

f6809_P1_5C_   PROC    near

               m_entry

               m_fetch_b
               m_inc
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_5C_   ENDP




;=========================
; TSTB - Inherent
;=========================

               PUBLIC  f6809_P1_5D_

f6809_P1_5D_   PROC    near

               m_entry

               m_fetch_b
               m_tst08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_5D_   ENDP





;=========================
; CLRB - Inherent
;=========================

               PUBLIC  f6809_P1_5F_

f6809_P1_5F_   PROC    near

               m_entry

               m_clr
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_5F_   ENDP




;=========================
; NEGate - indexed
;=========================

               PUBLIC  f6809_P1_60_

f6809_P1_60_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_neg
               m_store08
               pop     ax

               m_exit

f6809_P1_60_   ENDP




;=========================
; COM - indexed
;=========================

               PUBLIC  f6809_P1_63_

f6809_P1_63_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_com
               m_store08
               pop     ax

               m_exit

f6809_P1_63_   ENDP




;=========================
; LSR - Indexed
;=========================

               PUBLIC  f6809_P1_64_

f6809_P1_64_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_lsr
               m_store08
               pop     ax

               m_exit

f6809_P1_64_   ENDP




;=========================
; ROR - indexed
;=========================

               PUBLIC  f6809_P1_66_

f6809_P1_66_   PROC    near

               m_entry
               m_index
               push    ax

               m_fetch08
               m_ror
               m_store08

               pop     ax
               m_exit

f6809_P1_66_   ENDP




;=========================
; ASR - indexed
;=========================

               PUBLIC  f6809_P1_67_

f6809_P1_67_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_asr
               m_store08
               pop     ax

               m_exit

f6809_P1_67_   ENDP




;=========================
; ASL - indexed
;=========================

               PUBLIC  f6809_P1_68_

f6809_P1_68_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_asl
               m_store08
               pop     ax

               m_exit

f6809_P1_68_   ENDP




;=========================
; ROL - indexed
;=========================

               PUBLIC  f6809_P1_69_

f6809_P1_69_   PROC    near

               m_entry
               m_index
               push    ax

               m_fetch08
               m_rol
               m_store08

               pop     ax
               m_exit

f6809_P1_69_   ENDP




;=========================
; DEC - indexed
;=========================

               PUBLIC  f6809_P1_6A_

f6809_P1_6A_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_dec
               m_store08
               pop     ax

               m_exit

f6809_P1_6A_   ENDP





;=========================
; INC - indexed
;=========================

               PUBLIC  f6809_P1_6C_

f6809_P1_6C_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_inc
               m_store08
               pop     ax

               m_exit

f6809_P1_6C_   ENDP




;=========================
; TST - Indexed
;=========================

               PUBLIC  f6809_P1_6D_

f6809_P1_6D_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_tst08
               pop     ax

               m_exit

f6809_P1_6D_   ENDP





;=========================
; JMP - Indexed
;=========================

               PUBLIC  f6809_P1_6E_

f6809_P1_6E_   PROC    near

               m_entry

               m_index
               push    ax
               m_jmp
               pop     ax
               m_exit

f6809_P1_6E_   ENDP



;=========================
; CLR - Indexed
;=========================

               PUBLIC  f6809_P1_6F_

f6809_P1_6F_   PROC    near

               m_entry

               m_index
               push    ax
               m_clr
               m_store08
               pop     ax

               m_exit

f6809_P1_6F_   ENDP




;=========================
; NEGate - Extended
;=========================

               PUBLIC  f6809_P1_70_

f6809_P1_70_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_neg
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_70_   ENDP




;=========================
; COM - extended
;=========================

               PUBLIC  f6809_P1_73_

f6809_P1_73_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_com
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_73_   ENDP




;=========================
; LSR - extended
;=========================

               PUBLIC  f6809_P1_74_

f6809_P1_74_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_lsr
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_74_   ENDP




;=========================
; ROR - extended
;=========================

               PUBLIC  f6809_P1_76_

f6809_P1_76_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_ror
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_76_   ENDP




;=========================
; ASR - extended
;=========================

               PUBLIC  f6809_P1_77_

f6809_P1_77_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_asr
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_77_   ENDP




;=========================
; ASL - extended
;=========================

               PUBLIC  f6809_P1_78_

f6809_P1_78_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_asl
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_78_   ENDP




;=========================
; ROL - extended
;=========================

               PUBLIC  f6809_P1_79_

f6809_P1_79_   PROC    near

               m_entry
               m_imm16

               m_fetch08
               m_rol
               m_store08

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_79_   ENDP




;=========================
; DEC - Extended
;=========================

               PUBLIC  f6809_P1_7A_

f6809_P1_7A_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_dec
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_7A_   ENDP




;=========================
; INC - Extended
;=========================

               PUBLIC  f6809_P1_7C_

f6809_P1_7C_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_inc
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_7C_   ENDP




;=========================
; TST - extended
;=========================

               PUBLIC  f6809_P1_7D_

f6809_P1_7D_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_tst08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_7D_   ENDP




;=========================
; JMP - Immediate
;=========================

               PUBLIC  f6809_P1_7E_

f6809_P1_7E_   PROC    near

               m_entry

               m_imm16
               m_jmp
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_7E_   ENDP




;=========================
; CLR - extended
;=========================

               PUBLIC  f6809_P1_7F_

f6809_P1_7F_   PROC    near

               m_entry

               m_imm16
               m_clr
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_7F_   ENDP




;=========================
; SUBA - immediate 08
;=========================

               PUBLIC  f6809_P1_80_

f6809_P1_80_   PROC    near

               m_entry

               m_imm08
               m_getcc
               sub     [R6809_A],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_80_   ENDP




;=========================
; CMPA - Immediate
;=========================

               PUBLIC  f6809_P1_81_

f6809_P1_81_   PROC    near

               m_entry

               m_imm08
               mov     dx,bx
               m_cmp_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_81_   ENDP




;=========================
; SBCA - immediate 08
;=========================

               PUBLIC  f6809_P1_82_

f6809_P1_82_   PROC    near

               m_entry

               m_imm08
               m_getcc
               sbb     [R6809_A],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_82_   ENDP



;=========================
; SUBD - immediate
;=========================

               PUBLIC  f6809_P1_83_

f6809_P1_83_   PROC    near

               m_entry

               m_imm16
               mov     ax,[R6809_D]
               m_getcc
               sub     ax,bx
               m_putcc
               mov     [R6809_D],ax
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_83_   ENDP




;=========================
; ANDA - immediate
;=========================

               PUBLIC  f6809_P1_84_

f6809_P1_84_   PROC    near

               m_entry

               m_imm08
               m_getcc
               and     bl,[R6809_A]
               m_putcc
               mov     [R6809_A],bl
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_84_   ENDP




;=========================
; BITA - immediate
;=========================

               PUBLIC  f6809_P1_85_

f6809_P1_85_   PROC    near

               m_entry

               m_imm08
               mov     dl,[R6809_A]
               m_getcc
               and     dl,bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_85_   ENDP




;=========================
; LDA - immediate
;=========================

               PUBLIC  f6809_P1_86_

f6809_P1_86_   PROC    near

               m_entry

               m_imm08
               mov     dx,bx
               m_tst08
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_86_   ENDP




;=========================
; EORA - immediate 08
;=========================

               PUBLIC  f6809_P1_88_

f6809_P1_88_   PROC    near

               m_entry

               m_imm08
               m_getcc
               xor     [R6809_A],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_88_   ENDP




;=========================
; ADCA - immediate 08
;=========================

               PUBLIC  f6809_P1_89_

f6809_P1_89_   PROC    near

               m_entry

               m_imm08
               m_getcc
               adc     [R6809_A],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_89_   ENDP



;=========================
; ORA - immediate 08
;=========================

               PUBLIC  f6809_P1_8A_

f6809_P1_8A_   PROC    near

               m_entry

               m_imm08
               m_getcc
               or      [R6809_A],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_8A_   ENDP




;=========================
; ADDA - immediate 08
;=========================

               PUBLIC  f6809_P1_8B_

f6809_P1_8B_   PROC    near

               m_entry

               m_imm08
               m_getcc
               add     [R6809_A],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_8B_   ENDP



;=========================
; CMPX - immediate 16
;=========================

               PUBLIC  f6809_P1_8C_

f6809_P1_8C_   PROC    near

               m_entry

               m_imm16
               m_getcc
               cmp     [R6809_X],bx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_8C_   ENDP



;=========================
; BSR - relative
;=========================

               PUBLIC  f6809_P1_8D_

f6809_P1_8D_   PROC    near

               m_entry

               m_rel16
               m_jsr
               mov    ax,CPU_FETCH

               m_exit

f6809_P1_8D_   ENDP





;=========================
; LDX - immediate 16
;=========================

               PUBLIC  f6809_P1_8E_

f6809_P1_8E_   PROC    near

               m_entry

               m_imm16
               mov     dx,bx
               m_tst16
               m_store_x
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_8E_   ENDP





;=========================
; SUBA - direct page
;=========================

               PUBLIC  f6809_P1_90_

f6809_P1_90_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               sub     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_90_   ENDP




;=========================
; CMPA - direct page
;=========================

               PUBLIC  f6809_P1_91_

f6809_P1_91_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_cmp_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_91_   ENDP




;=========================
; SBCA - direct page
;=========================

               PUBLIC  f6809_P1_92_

f6809_P1_92_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               sbb     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_92_   ENDP




;=========================
; SUBD - direct page
;=========================

               PUBLIC  f6809_P1_93_

f6809_P1_93_   PROC    near

               m_entry

               m_drect
               m_fetch16
               m_getcc
               sub     [R6809_D],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_93_   ENDP




;=========================
; ANDA - direct page
;=========================

               PUBLIC  f6809_P1_94_

f6809_P1_94_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               and     dl,[R6809_A]
               m_putcc
               mov     [R6809_A],dl
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_94_   ENDP




;=========================
; BITA - direct page
;=========================

               PUBLIC  f6809_P1_95_

f6809_P1_95_   PROC    near

               m_entry

               m_drect
               m_fetch08
               mov     bl,[R6809_A]
               m_getcc
               and     dl,bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_95_   ENDP




;=========================
; LDA - direct page
;=========================

               PUBLIC  f6809_P1_96_

f6809_P1_96_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_tst08
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_96_   ENDP




;=========================
; STA - direct
;=========================

               PUBLIC  f6809_P1_97_

f6809_P1_97_   PROC    near

               m_entry

               m_drect
               m_fetch_a
               m_tst08
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_97_   ENDP




;=========================
; EORA - direct page
;=========================

               PUBLIC  f6809_P1_98_

f6809_P1_98_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               xor     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_98_   ENDP




;=========================
; ADCA - direct page
;=========================

               PUBLIC  f6809_P1_99_

f6809_P1_99_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               adc     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_99_   ENDP



;=========================
; ORA - direct
;=========================

               PUBLIC  f6809_P1_9A_

f6809_P1_9A_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               or      [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_9A_   ENDP




;=========================
; ADDA - direct
;=========================

               PUBLIC  f6809_P1_9B_

f6809_P1_9B_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               add     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_9B_   ENDP




;=========================
; CMPX - direct page
;=========================

               PUBLIC  f6809_P1_9C_

f6809_P1_9C_   PROC    near

               m_entry

               m_drect
               m_fetch16
               m_getcc
               cmp     [R6809_X],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_9C_   ENDP




;=========================
; JSR - direct page
;=========================

               PUBLIC  f6809_P1_9D_

f6809_P1_9D_   PROC    near

               m_entry

               m_drect
               m_jsr
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_9D_   ENDP




;=========================
; LDX - direct
;=========================

               PUBLIC  f6809_P1_9E_

f6809_P1_9E_   PROC    near

               m_entry

               m_drect
               m_fetch16
               m_tst16
               m_store_x
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_9E_   ENDP




;=========================
; STX - direct
;=========================

               PUBLIC  f6809_P1_9F_

f6809_P1_9F_   PROC    near

               m_entry

               m_drect
               m_fetch_x
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_9F_   ENDP





;=========================
; SUBA - indexed
;=========================

               PUBLIC  f6809_P1_A0_

f6809_P1_A0_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               sub     [R6809_A],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_A0_   ENDP




;=========================
; CMPA - indexed
;=========================

               PUBLIC  f6809_P1_A1_

f6809_P1_A1_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_cmp_a
               pop     ax

               m_exit

f6809_P1_A1_   ENDP




;=========================
; SBCA - indexed
;=========================

               PUBLIC  f6809_P1_A2_

f6809_P1_A2_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               sbb     [R6809_A],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_A2_   ENDP




;=========================
; SUBD - indexed
;=========================

               PUBLIC  f6809_P1_A3_

f6809_P1_A3_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch16
               m_getcc
               sub     [R6809_D],dx
               m_putcc
               pop     ax

               m_exit

f6809_P1_A3_   ENDP




;=========================
; ANDA - indexed
;=========================

               PUBLIC  f6809_P1_A4_

f6809_P1_A4_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               and     dl,[R6809_A]
               m_putcc
               mov     [R6809_A],dl
               pop     ax

               m_exit

f6809_P1_A4_   ENDP




;=========================
; BITA - indexed
;=========================

               PUBLIC  f6809_P1_A5_

f6809_P1_A5_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               mov     bl,[R6809_A]
               m_getcc
               and     dl,bl
               m_putcc
               pop     ax

               m_exit

f6809_P1_A5_   ENDP




;=========================
; LDA - indexed
;=========================

               PUBLIC  f6809_P1_A6_

f6809_P1_A6_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_tst08
               m_store_a
               pop     ax

               m_exit

f6809_P1_A6_   ENDP




;=========================
; STA - indexed
;=========================

               PUBLIC  f6809_P1_A7_

f6809_P1_A7_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch_a
               m_tst08
               m_store08
               pop     ax

               m_exit

f6809_P1_A7_   ENDP




;=========================
; EORA - indexed
;=========================

               PUBLIC  f6809_P1_A8_

f6809_P1_A8_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               xor     [R6809_A],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_A8_   ENDP




;=========================
; ADCA - indexed
;=========================

               PUBLIC  f6809_P1_A9_

f6809_P1_A9_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               adc     [R6809_A],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_A9_   ENDP



;=========================
; ORA - indexed
;=========================

               PUBLIC  f6809_P1_AA_

f6809_P1_AA_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               or      [R6809_A],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_AA_   ENDP




;=========================
; ADDA - indexed
;=========================

               PUBLIC  f6809_P1_AB_

f6809_P1_AB_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               add     [R6809_A],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_AB_   ENDP




;=========================
; CMPX - indexed
;=========================

               PUBLIC  f6809_P1_AC_

f6809_P1_AC_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch16
               m_getcc
               cmp     [R6809_X],dx
               m_putcc
               pop     ax

               m_exit

f6809_P1_AC_   ENDP




;=========================
; JSR - indexed
;=========================

               PUBLIC  f6809_P1_AD_

f6809_P1_AD_   PROC    near

               m_entry

               m_index
               push    ax
               m_jsr
               pop     ax

               m_exit

f6809_P1_AD_   ENDP




;=========================
; LDX - indexed
;=========================

               PUBLIC  f6809_P1_AE_

f6809_P1_AE_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch16
               m_tst16
               m_store_x
               pop     ax

               m_exit

f6809_P1_AE_   ENDP




;=========================
; STX - indexed
;=========================

               PUBLIC  f6809_P1_AF_

f6809_P1_AF_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch_x
               m_tst16
               m_store16
               pop     ax

               m_exit

f6809_P1_AF_   ENDP





;=========================
; SUBA - extended
;=========================

               PUBLIC  f6809_P1_B0_

f6809_P1_B0_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               sub     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B0_   ENDP




;=========================
; CMPA - extended
;=========================

               PUBLIC  f6809_P1_B1_

f6809_P1_B1_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_cmp_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B1_   ENDP




;=========================
; SBCA - extended
;=========================

               PUBLIC  f6809_P1_B2_

f6809_P1_B2_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               sbb     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B2_   ENDP




;=========================
; SUBD - extended
;=========================

               PUBLIC  f6809_P1_B3_

f6809_P1_B3_   PROC    near

               m_entry

               m_imm16
               m_fetch16
               m_getcc
               sub     [R6809_D],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B3_   ENDP




;=========================
; ANDA - extended
;=========================

               PUBLIC  f6809_P1_B4_

f6809_P1_B4_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               and     dl,[R6809_A]
               m_putcc
               mov     [R6809_A],dl
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B4_   ENDP




;=========================
; BITA - extended
;=========================

               PUBLIC  f6809_P1_B5_

f6809_P1_B5_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               mov     bl,[R6809_A]
               m_getcc
               and     dl,bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B5_   ENDP




;=========================
; LDA - extended
;=========================

               PUBLIC  f6809_P1_B6_

f6809_P1_B6_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_tst08
               m_store_a
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B6_   ENDP




;=========================
; STA - extended
;=========================

               PUBLIC  f6809_P1_B7_

f6809_P1_B7_   PROC    near

               m_entry

               m_imm16
               m_fetch_a
               m_tst08
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B7_   ENDP




;=========================
; EORA - extended
;=========================

               PUBLIC  f6809_P1_B8_

f6809_P1_B8_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               xor     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B8_   ENDP




;=========================
; ADCA - extended
;=========================

               PUBLIC  f6809_P1_B9_

f6809_P1_B9_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               adc     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_B9_   ENDP



;=========================
; ORA - extended
;=========================

               PUBLIC  f6809_P1_BA_

f6809_P1_BA_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               or      [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_BA_   ENDP




;=========================
; ADDA - extended
;=========================

               PUBLIC  f6809_P1_BB_

f6809_P1_BB_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               add     [R6809_A],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_BB_   ENDP




;=========================
; CMPX - extended
;=========================

               PUBLIC  f6809_P1_BC_

f6809_P1_BC_   PROC    near

               m_entry

               m_imm16
               m_fetch16
               m_getcc
               cmp     [R6809_X],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_BC_   ENDP




;=========================
; JSR - immediate 16
;=========================

               PUBLIC  f6809_P1_BD_

f6809_P1_BD_   PROC    near

               m_entry

               m_imm16
               m_jsr
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_BD_   ENDP




;=========================
; LDX - extended
;=========================

               PUBLIC  f6809_P1_BE_

f6809_P1_BE_   PROC    near

               m_entry

               m_imm16
               m_fetch16
               m_tst16
               m_store_x
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_BE_   ENDP




;=========================
; STX - extended
;=========================

               PUBLIC  f6809_P1_BF_

f6809_P1_BF_   PROC    near

               m_entry

               m_imm16
               m_fetch_x
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_BF_   ENDP




;=========================
; SUBB - immediate 08
;=========================

               PUBLIC  f6809_P1_C0_

f6809_P1_C0_   PROC    near

               m_entry

               m_imm08
               m_getcc
               sub     [R6809_B],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C0_   ENDP




;=========================
; CMPB - Immediate
;=========================

               PUBLIC  f6809_P1_C1_

f6809_P1_C1_   PROC    near

               m_entry

               m_imm08
               mov     dx,bx
               m_cmp_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C1_   ENDP




;=========================
; SBCB - immediate 08
;=========================

               PUBLIC  f6809_P1_C2_

f6809_P1_C2_   PROC    near

               m_entry

               m_imm08
               m_getcc
               sbb     [R6809_B],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C2_   ENDP




;=========================
; ADDD - immediate
;=========================

               PUBLIC  f6809_P1_C3_

f6809_P1_C3_   PROC    near

               m_entry

               m_imm16
               m_getcc
               add     [R6809_D],bx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C3_   ENDP




;=========================
; ANDB - immediate 08
;=========================

               PUBLIC  f6809_P1_C4_

f6809_P1_C4_   PROC    near

               m_entry

               m_imm08
               m_getcc
               and     [R6809_B],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C4_   ENDP



;=========================
; BITB - immediate 08
;=========================

               PUBLIC  f6809_P1_C5_

f6809_P1_C5_   PROC    near

               m_entry

               m_imm08
               m_getcc
               and     bl,[R6809_B]
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C5_   ENDP



;=========================
; LDB - immediate 8
;=========================

               PUBLIC  f6809_P1_C6_

f6809_P1_C6_   PROC    near

               m_entry

               m_imm08
               mov     dx,bx
               m_tst08
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C6_   ENDP




;=========================
; EORB - immediate 08
;=========================

               PUBLIC  f6809_P1_C8_

f6809_P1_C8_   PROC    near

               m_entry

               m_imm08
               m_getcc
               xor     [R6809_B],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C8_   ENDP




;=========================
; ADCB - immediate 08
;=========================

               PUBLIC  f6809_P1_C9_

f6809_P1_C9_   PROC    near

               m_entry

               m_imm08
               m_getcc
               adc     [R6809_B],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_C9_   ENDP




;=========================
; ORB - immediate 08
;=========================

               PUBLIC  f6809_P1_CA_

f6809_P1_CA_   PROC    near

               m_entry

               m_imm08
               m_getcc
               or      [R6809_B],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_CA_   ENDP




;=========================
; ADDB - immediate 08
;=========================

               PUBLIC  f6809_P1_CB_

f6809_P1_CB_   PROC    near

               m_entry

               m_imm08
               m_getcc
               add     [R6809_B],bl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_CB_   ENDP



;=========================
; LDD - immediate 16
;=========================

               PUBLIC  f6809_P1_CC_

f6809_P1_CC_   PROC    near

               m_entry

               m_imm16
               mov     dx,bx
               m_tst16
               m_store_d
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_CC_   ENDP




;==========================
; LDU - immediate 16
;==========================

               PUBLIC  f6809_P1_CE_

f6809_P1_CE_   PROC    near

               m_entry
               m_imm16
               mov     dx,bx
               m_tst16
               m_store_usp
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_CE_   ENDP




;=========================
; SUBB - direct page
;=========================

               PUBLIC  f6809_P1_D0_

f6809_P1_D0_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               sub     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D0_   ENDP




;=========================
; CMPB - direct page
;=========================

               PUBLIC  f6809_P1_D1_

f6809_P1_D1_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_cmp_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D1_   ENDP




;=========================
; SBCB - direct page
;=========================

               PUBLIC  f6809_P1_D2_

f6809_P1_D2_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               sbb     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D2_   ENDP




;=========================
; ADDD - direct
;=========================

               PUBLIC  f6809_P1_D3_

f6809_P1_D3_   PROC    near

               m_entry

               m_drect
               m_fetch16
               m_getcc
               add     [R6809_D],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D3_   ENDP




;=========================
; ANDB - direct page
;=========================

               PUBLIC  f6809_P1_D4_

f6809_P1_D4_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               and     dl,[R6809_B]
               m_putcc
               mov     [R6809_B],dl
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D4_   ENDP




;=========================
; BITB - direct page
;=========================

               PUBLIC  f6809_P1_D5_

f6809_P1_D5_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               and     dl,[R6809_B]
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D5_   ENDP




;=========================
; LDB - direct page
;=========================

               PUBLIC  f6809_P1_D6_

f6809_P1_D6_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_tst08
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D6_   ENDP




;=========================
; STB - Direct
;=========================

               PUBLIC  f6809_P1_D7_

f6809_P1_D7_   PROC    near

               m_entry

               m_drect
               m_fetch_b
               m_tst08
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D7_   ENDP




;=========================
; EORB - direct page
;=========================

               PUBLIC  f6809_P1_D8_

f6809_P1_D8_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               xor     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D8_   ENDP




;=========================
; ADCB - direct page
;=========================

               PUBLIC  f6809_P1_D9_

f6809_P1_D9_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               adc     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_D9_   ENDP




;=========================
; ORB - direct page
;=========================

               PUBLIC  f6809_P1_DA_

f6809_P1_DA_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               or      [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_DA_   ENDP




;=========================
; ADDB - direct
;=========================

               PUBLIC  f6809_P1_DB_

f6809_P1_DB_   PROC    near

               m_entry

               m_drect
               m_fetch08
               m_getcc
               add     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_DB_   ENDP




;=========================
; LDD - Direct page
;=========================

               PUBLIC  f6809_P1_DC_

f6809_P1_DC_   PROC    near

               m_entry

               m_drect
               m_fetch16
               m_tst16
               m_store_d
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_DC_   ENDP




;=========================
; STD - Direct Page
;=========================

               PUBLIC  f6809_P1_DD_

f6809_P1_DD_   PROC    near

               m_entry

               m_drect
               m_fetch_d
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_DD_   ENDP




;=========================
; LDU - direct
;=========================

               PUBLIC  f6809_P1_DE_

f6809_P1_DE_   PROC    near

               m_entry

               m_drect
               m_fetch16
               m_tst16
               m_store_usp
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_DE_   ENDP




;=========================
; STU - Direct page
;=========================

               PUBLIC  f6809_P1_DF_

f6809_P1_DF_   PROC    near

               m_entry

               m_drect
               m_fetch_usp
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_DF_   ENDP





;=========================
; SUBB - indexed
;=========================

               PUBLIC  f6809_P1_E0_

f6809_P1_E0_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               sub     [R6809_B],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_E0_   ENDP




;=========================
; CMPB - indexed
;=========================

               PUBLIC  f6809_P1_E1_

f6809_P1_E1_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_cmp_b
               pop     ax

               m_exit

f6809_P1_E1_   ENDP




;=========================
; SBCB - indexed
;=========================

               PUBLIC  f6809_P1_E2_

f6809_P1_E2_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               sbb     [R6809_B],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_E2_   ENDP




;=========================
; ADDD - inndexed
;=========================

               PUBLIC  f6809_P1_E3_

f6809_P1_E3_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch16
               m_getcc
               add     [R6809_D],dx
               m_putcc
               pop     ax

               m_exit

f6809_P1_E3_   ENDP




;=========================
; ANDB - indexed
;=========================

               PUBLIC  f6809_P1_E4_

f6809_P1_E4_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               and     dl,[R6809_B]
               m_putcc
               mov     [R6809_B],dl
               pop     ax

               m_exit

f6809_P1_E4_   ENDP




;=========================
; BITB - indexed
;=========================

               PUBLIC  f6809_P1_E5_

f6809_P1_E5_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               and     dl,[R6809_B]
               m_putcc
               pop     ax

               m_exit

f6809_P1_E5_   ENDP




;=========================
; LDB - indexed
;=========================

               PUBLIC  f6809_P1_E6_

f6809_P1_E6_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_tst08
               m_store_b
               pop     ax

               m_exit

f6809_P1_E6_   ENDP




;=========================
; STB - indexed
;=========================

               PUBLIC  f6809_P1_E7_

f6809_P1_E7_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch_b
               m_tst08
               m_store08
               pop     ax

               m_exit

f6809_P1_E7_   ENDP




;=========================
; EORB - indexed
;=========================

               PUBLIC  f6809_P1_E8_

f6809_P1_E8_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               xor     [R6809_B],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_E8_   ENDP




;=========================
; ADCB - indexed
;=========================

               PUBLIC  f6809_P1_E9_

f6809_P1_E9_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               adc     [R6809_B],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_E9_   ENDP




;=========================
; ORB - indexed
;=========================

               PUBLIC  f6809_P1_EA_

f6809_P1_EA_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               or      [R6809_B],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_EA_   ENDP




;=========================
; ADDB - indexed
;=========================

               PUBLIC  f6809_P1_EB_

f6809_P1_EB_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch08
               m_getcc
               add     [R6809_B],dl
               m_putcc
               pop     ax

               m_exit

f6809_P1_EB_   ENDP




;=========================
; LDD - indexed
;=========================

               PUBLIC  f6809_P1_EC_

f6809_P1_EC_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch16
               m_tst16
               m_store_d
               pop     ax

               m_exit

f6809_P1_EC_   ENDP




;=========================
; STD - indexed
;=========================

               PUBLIC  f6809_P1_ED_

f6809_P1_ED_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch_d
               m_tst16
               m_store16
               pop     ax

               m_exit

f6809_P1_ED_   ENDP




;=========================
; LDU - indexed
;=========================

               PUBLIC  f6809_P1_EE_

f6809_P1_EE_   PROC    near

               m_entry

               m_index
               push    ax
               m_fetch16
               m_tst16
               m_store_usp
               pop     ax

               m_exit

f6809_P1_EE_   ENDP




;=========================
; STU - indexed
;=========================

               PUBLIC  f6809_P1_EF_

f6809_P1_EF_   PROC    near

               m_entry
               m_index
               push    ax
               m_fetch_usp
               m_tst16
               m_store16
               pop     ax

               m_exit

f6809_P1_EF_   ENDP





;=========================
; SUBB - extended
;=========================

               PUBLIC  f6809_P1_F0_

f6809_P1_F0_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               sub     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F0_   ENDP




;=========================
; CMPB - extended
;=========================

               PUBLIC  f6809_P1_F1_

f6809_P1_F1_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_cmp_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F1_   ENDP




;=========================
; SBCB - extended
;=========================

               PUBLIC  f6809_P1_F2_

f6809_P1_F2_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               sbb     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F2_   ENDP




;=========================
; ADDD - extended
;=========================

               PUBLIC  f6809_P1_F3_

f6809_P1_F3_   PROC    near

               m_entry

               m_imm16
               m_fetch16
               m_getcc
               add     [R6809_D],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F3_   ENDP




;=========================
; ANDB - extended
;=========================

               PUBLIC  f6809_P1_F4_

f6809_P1_F4_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               and     dl,[R6809_B]
               m_putcc
               mov     [R6809_B],dl
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F4_   ENDP




;=========================
; BITB - extended
;=========================

               PUBLIC  f6809_P1_F5_

f6809_P1_F5_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               and     dl,[R6809_B]
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F5_   ENDP




;=========================
; LDB - extended
;=========================

               PUBLIC  f6809_P1_F6_

f6809_P1_F6_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_tst08
               m_store_b
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F6_   ENDP




;=========================
; STB - extended
;=========================

               PUBLIC  f6809_P1_F7_

f6809_P1_F7_   PROC    near

               m_entry

               m_imm16
               m_fetch_b
               m_tst08
               m_store08
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F7_   ENDP




;=========================
; EORB - extended
;=========================

               PUBLIC  f6809_P1_F8_

f6809_P1_F8_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               xor     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F8_   ENDP




;=========================
; ADCB - extended
;=========================

               PUBLIC  f6809_P1_F9_

f6809_P1_F9_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               adc     [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_F9_   ENDP




;=========================
; ORB - extended
;=========================

               PUBLIC  f6809_P1_FA_

f6809_P1_FA_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               or      [R6809_B],dl
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_FA_   ENDP




;=========================
; ADDB - extended
;=========================

               PUBLIC  f6809_P1_FB_

f6809_P1_FB_   PROC    near

               m_entry

               m_imm16
               m_fetch08
               m_getcc
               add     [R6809_B],dl
               m_putcc

               mov     ax,CPU_FETCH
               m_exit

f6809_P1_FB_   ENDP




;=========================
; LDD - extended
;=========================

               PUBLIC  f6809_P1_FC_

f6809_P1_FC_   PROC    near

               m_entry

               m_imm16
               m_fetch16
               m_tst16
               m_store_d
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_FC_   ENDP




;=========================
; STD - extended
;=========================

               PUBLIC  f6809_P1_FD_

f6809_P1_FD_   PROC    near

               m_entry

               m_imm16
               m_fetch_d
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_FD_   ENDP




;=========================
; LDU - extended
;=========================

               PUBLIC  f6809_P1_FE_

f6809_P1_FE_   PROC    near

               m_entry

               m_imm16
               m_fetch16
               m_tst16
               m_store_usp
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_FE_   ENDP




;=========================
; STU - extended
;=========================

               PUBLIC  f6809_P1_FF_

f6809_P1_FF_   PROC    near

               m_entry

               m_imm16
               m_fetch_usp
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P1_FF_   ENDP




;
;
;
;
;    ALL PAGE2 & PAGE3 INSTRUCTIONS ARE SPECIAL CASE EXECUTIONS
;    AS THEY ARE EXECUTED BY f6809_P1_10 & f6809_P1_11 WHICH
;    ALREADY CALL M_ENTRY SO ALL WE NEED TO DO IS M_EXIT
;
;
;
;






;=========================
; LBRN - Relative
;=========================

               PUBLIC  f6809_P2_21_

f6809_P2_21_   PROC    near

               m_lrl16
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_21_   ENDP




;=========================
; LBHI - Relative
;=========================

               PUBLIC  f6809_P2_22_

f6809_P2_22_   PROC    near

               m_lrl16
               m_getcc
               jbe     P2_22_00
               mov     [R6809_PC],bx
P2_22_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_22_   ENDP




;=========================
; LBLS - Relative
;=========================

               PUBLIC  f6809_P2_23_

f6809_P2_23_   PROC    near

               m_lrl16
               m_getcc
               ja      P2_23_00
               mov     [R6809_PC],bx
P2_23_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_23_   ENDP




;=========================
; LBHS/LBCC - Relative
;=========================

               PUBLIC  f6809_P2_24_

f6809_P2_24_   PROC    near

               m_lrl16
               m_getcc
               jc      P2_24_00
               mov     [R6809_PC],bx
P2_24_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_24_   ENDP




;=========================
; LBLO/LBCS - Relative
;=========================

               PUBLIC  f6809_P2_25_

f6809_P2_25_   PROC    near

               m_lrl16
               m_getcc
               jnc     P2_25_00
               mov     [R6809_PC],bx
P2_25_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_25_   ENDP




;=========================
; LBNE - relative 16
;=========================

               PUBLIC  f6809_P2_26_

f6809_P2_26_   PROC    near

               m_lrl16
               m_getcc
               je      P2_26_00
               mov     [R6809_PC],bx
P2_26_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_26_   ENDP




;=========================
; LBEQ - Relative
;=========================

               PUBLIC  f6809_P2_27_

f6809_P2_27_   PROC    near

               m_lrl16
               m_getcc
               jne     P2_27_00
               mov     [R6809_PC],bx
P2_27_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_27_   ENDP




;=========================
; LBVC - Relative
;=========================

               PUBLIC  f6809_P2_28_

f6809_P2_28_   PROC    near

               m_lrl16
               m_getcc
               jo      P2_28_00
               mov     [R6809_PC],bx
P2_28_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_28_   ENDP




;=========================
; LBVS - Relative
;=========================

               PUBLIC  f6809_P2_29_

f6809_P2_29_   PROC    near

               m_lrl16
               m_getcc
               jno     P2_29_00
               mov     [R6809_PC],bx
P2_29_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_29_   ENDP




;=========================
; LBPL - Relative
;=========================

               PUBLIC  f6809_P2_2A_

f6809_P2_2A_   PROC    near

               m_lrl16
               m_getcc
               js      P2_2A_00
               mov     [R6809_PC],bx
P2_2A_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_2A_   ENDP




;=========================
; LBMI - Relative
;=========================

               PUBLIC  f6809_P2_2B_

f6809_P2_2B_   PROC    near

               m_lrl16
               m_getcc
               jns     P2_2B_00
               mov     [R6809_PC],bx
P2_2B_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_2B_   ENDP




;=========================
; BGE - Relative
;=========================

               PUBLIC  f6809_P2_2C_

f6809_P2_2C_   PROC    near

               m_lrl16
               m_getcc
               jl      P2_2C_00
               mov     [R6809_PC],bx
P2_2C_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_2C_   ENDP




;=========================
; LBLT - Relative
;=========================

               PUBLIC  f6809_P2_2D_

f6809_P2_2D_   PROC    near

               m_lrl16
               m_getcc
               jge     P2_2D_00
               mov     [R6809_PC],bx
P2_2D_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_2D_   ENDP




;=========================
; LBGT - Relative
;=========================

               PUBLIC  f6809_P2_2E_

f6809_P2_2E_   PROC    near

               m_lrl16
               m_getcc
               jle     P2_2E_00
               mov     [R6809_PC],bx
P2_2E_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_2E_   ENDP




;=========================
; LBLE - Relative
;=========================

               PUBLIC  f6809_P2_2F_

f6809_P2_2F_   PROC    near

               m_lrl16
               m_getcc
               jg      P2_2F_00
               mov     [R6809_PC],bx
P2_2F_00:
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_2F_   ENDP




;=========================
; SWI2 -Inherent
;=========================

               PUBLIC  f6809_P2_3F_

f6809_P2_3F_   PROC    near

               mov     al,[R6809_CC]
               or      al,0x80             ; Set FULL flag
               mov     [R6809_CC],al

               call    pshs6809_FF_        ; Save context

               mov     bx,0xfff4           ; Fetch int vector
               m_fetch16
               mov     [R6809_PC],dx

               mov     ax,CPU_FETCH
               m_exit

f6809_P2_3F_   ENDP




;=========================
; CMPD - immediate 16
;=========================

               PUBLIC  f6809_P2_83_

f6809_P2_83_   PROC    near

               m_imm16
               m_getcc
               cmp     [R6809_D],bx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_83_   ENDP




;=========================
; CMPY - immediate 16
;=========================

               PUBLIC  f6809_P2_8C_

f6809_P2_8C_   PROC    near

               m_imm16
               m_getcc
               cmp     [R6809_Y],bx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_8C_   ENDP



;=========================
; LDY - immediate 16
;=========================

               PUBLIC  f6809_P2_8E_

f6809_P2_8E_   PROC    near

               m_imm16
               mov     dx,bx
               m_tst16
               m_store_y
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_8E_   ENDP





;=========================
; CMPD - direct page
;=========================

               PUBLIC  f6809_P2_93_

f6809_P2_93_   PROC    near

               m_drect
               m_fetch16
               m_getcc
               cmp     [R6809_D],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_93_   ENDP




;=========================
; CMPY - direct page
;=========================

               PUBLIC  f6809_P2_9C_

f6809_P2_9C_   PROC    near

               m_drect
               m_fetch16
               m_getcc
               cmp     [R6809_Y],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_9C_   ENDP




;=========================
; LDY - direct page
;=========================

               PUBLIC  f6809_P2_9E_

f6809_P2_9E_   PROC    near

               m_drect
               m_fetch16
               m_tst16
               m_store_y
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_9E_   ENDP




;=========================
; STY - direct page
;=========================

               PUBLIC  f6809_P2_9F_

f6809_P2_9F_   PROC    near

               m_drect
               m_fetch_y
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_9F_   ENDP




;=========================
; CMPD - indexed
;=========================

               PUBLIC  f6809_P2_A3_

f6809_P2_A3_   PROC    near

               m_index
               push    ax
               m_fetch16
               m_getcc
               cmp     [R6809_D],dx
               m_putcc
               pop     ax

               m_exit

f6809_P2_A3_   ENDP




;=========================
; CMPY - indexed
;=========================

               PUBLIC  f6809_P2_AC_

f6809_P2_AC_   PROC    near

               m_index
               push    ax
               m_fetch16
               m_getcc
               cmp     [R6809_Y],dx
               m_putcc
               pop     ax

               m_exit

f6809_P2_AC_   ENDP




;=========================
; LDY - indexed
;=========================

               PUBLIC  f6809_P2_AE_

f6809_P2_AE_   PROC    near

               m_index
               push    ax
               m_fetch16
               m_tst16
               m_store_y
               pop     ax

               m_exit

f6809_P2_AE_   ENDP




;=========================
; STY - indexed
;=========================

               PUBLIC  f6809_P2_AF_

f6809_P2_AF_   PROC    near

               m_index
               push    ax
               m_fetch_y
               m_tst16
               m_store16
               pop     ax

               m_exit

f6809_P2_AF_   ENDP




;=========================
; CMPD - extended
;=========================

               PUBLIC  f6809_P2_B3_

f6809_P2_B3_   PROC    near

               m_imm16
               m_fetch16
               m_getcc
               cmp     [R6809_D],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_B3_   ENDP




;=========================
; CMPY - extended
;=========================

               PUBLIC  f6809_P2_BC_

f6809_P2_BC_   PROC    near

               m_imm16
               m_fetch16
               m_getcc
               cmp     [R6809_Y],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_BC_   ENDP




;=========================
; LDY - extended
;=========================

               PUBLIC  f6809_P2_BE_

f6809_P2_BE_   PROC    near

               m_imm16
               m_fetch16
               m_tst16
               m_store_y
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_BE_   ENDP




;=========================
; STY - extended
;=========================

               PUBLIC  f6809_P2_BF_

f6809_P2_BF_   PROC    near

               m_imm16
               m_fetch_y
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_BF_   ENDP




;=========================
; LDS - immediate 16
;=========================

               PUBLIC  f6809_P2_CE_

f6809_P2_CE_   PROC    near

               m_imm16
               mov     dx,bx
               m_tst16
               m_store_hsp
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_CE_   ENDP




;=========================
; LDS - direct page
;=========================

               PUBLIC  f6809_P2_DE_

f6809_P2_DE_   PROC    near

               m_drect
               m_fetch16
               m_tst16
               m_store_hsp
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_DE_   ENDP




;=========================
; STS - direct page
;=========================

               PUBLIC  f6809_P2_DF_

f6809_P2_DF_   PROC    near

               m_drect
               m_fetch_hsp
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_DF_   ENDP




;=========================
; LDS - indexed
;=========================

               PUBLIC  f6809_P2_EE_

f6809_P2_EE_   PROC    near

               m_index
               push    ax
               m_fetch16
               m_tst16
               m_store_hsp
               pop     ax

               m_exit

f6809_P2_EE_   ENDP




;=========================
; STS - indexed
;=========================

               PUBLIC  f6809_P2_EF_

f6809_P2_EF_   PROC    near

               m_index
               push    ax
               m_fetch_hsp
               m_tst16
               m_store16
               pop     ax

               m_exit

f6809_P2_EF_   ENDP




;=========================
; LDS - extended
;=========================

               PUBLIC  f6809_P2_FE_

f6809_P2_FE_   PROC    near

               m_imm16
               m_fetch16
               m_tst16
               m_store_hsp
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_FE_   ENDP




;=========================
; STS - extended
;=========================

               PUBLIC  f6809_P2_FF_

f6809_P2_FF_   PROC    near

               m_imm16
               m_fetch_hsp
               m_tst16
               m_store16
               mov     ax,CPU_FETCH

               m_exit

f6809_P2_FF_   ENDP




;=========================
; SWI3 -Inherent
;=========================

               PUBLIC  f6809_P3_3F_

f6809_P3_3F_   PROC    near

               mov     al,[R6809_CC]
               or      al,0x80             ; Set FULL flag
               mov     [R6809_CC],al

               call    pshs6809_FF_        ; Save context

               mov     bx,0xfff2           ; Fetch int vector
               m_fetch16
               mov     [R6809_PC],dx

               mov     ax,CPU_FETCH
               m_exit

f6809_P3_3F_   ENDP




;=========================
; CMPU - immediate 16
;=========================

               PUBLIC  f6809_P3_83_

f6809_P3_83_   PROC    near

               m_imm16

               m_getcc
               cmp     [R6809_USP],bx
               m_putcc

               mov     ax,CPU_FETCH
               m_exit

f6809_P3_83_   ENDP




;=========================
; CMPS - immediate 16
;=========================

               PUBLIC  f6809_P3_8C_

f6809_P3_8C_   PROC    near

               m_imm16

               m_getcc
               cmp     [R6809_HSP],bx
               m_putcc

               mov     ax,CPU_FETCH
               m_exit

f6809_P3_8C_   ENDP




;=========================
; CMPU - direct page
;=========================

               PUBLIC  f6809_P3_93_

f6809_P3_93_   PROC    near

               m_drect
               m_fetch16
               m_getcc
               cmp     [R6809_USP],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P3_93_   ENDP




;=========================
; CMPS - direct page
;=========================

               PUBLIC  f6809_P3_9C_

f6809_P3_9C_   PROC    near

               m_drect
               m_fetch16
               m_getcc
               cmp     [R6809_HSP],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P3_9C_   ENDP




;=========================
; CMPU - indexed
;=========================

               PUBLIC  f6809_P3_A3_

f6809_P3_A3_   PROC    near

               m_index
               push    ax
               m_fetch16
               m_getcc
               cmp     [R6809_USP],bx
               m_putcc
               pop     ax

               m_exit

f6809_P3_A3_   ENDP




;=========================
; CMPS - indexed
;=========================

               PUBLIC  f6809_P3_AC_

f6809_P3_AC_   PROC    near

               m_index
               push    ax
               m_fetch16
               m_getcc
               cmp     [R6809_HSP],bx
               m_putcc
               pop     ax

               m_exit

f6809_P3_AC_   ENDP




;=========================
; CMPU - extended
;=========================

               PUBLIC  f6809_P3_B3_

f6809_P3_B3_   PROC    near

               m_imm16
               m_fetch16
               m_getcc
               cmp     [R6809_USP],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P3_B3_   ENDP




;=========================
; CMPS - extended
;=========================

               PUBLIC  f6809_P3_BC_

f6809_P3_BC_   PROC    near

               m_imm16
               m_fetch16
               m_getcc
               cmp     [R6809_HSP],dx
               m_putcc
               mov     ax,CPU_FETCH

               m_exit

f6809_P3_BC_   ENDP









_COD6809_TEXT  ends

end
