/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : 6809 Emulator code functions per instruction               */
/*                                                                           */
/*   File Name  : COD6809.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the function code to execute any given  */
/*                processor instruction.                                     */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    02/07/95  K.W  Creation of empty stub file, description only   */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

//
// REGISTER MACROS
//
#define PC     (tsCPURegisters.tPC)
#define DP     (tsCPURegisters.tDP)
#define X      (tsCPURegisters.tX)
#define Y      (tsCPURegisters.tY)
#define D      (tsCPURegisters.uABD.tD)
#define A      (tsCPURegisters.uABD.sAB.tA)
#define B      (tsCPURegisters.uABD.sAB.tB)
#define S      (tsCPURegisters.tHSP)
#define U      (tsCPURegisters.tUSP)
#define CC     (tsCPURegisters.uCC.tCC)
#define CC_C   (tsCPURegisters.uCC.sCC.bC)
#define CC_V   (tsCPURegisters.uCC.sCC.bV)
#define CC_Z   (tsCPURegisters.uCC.sCC.bZ)
#define CC_N   (tsCPURegisters.uCC.sCC.bN)
#define CC_I   (tsCPURegisters.uCC.sCC.bI)
#define CC_H   (tsCPURegisters.uCC.sCC.bH)
#define CC_F   (tsCPURegisters.uCC.sCC.bF)
#define CC_E   (tsCPURegisters.uCC.sCC.bE)


// Interrupt function prototypes

T_UWORD  f6809_FIRQ(T_VOID);
T_UWORD  f6809_IRQ(T_VOID);


// Register definitions for the above
//
// [DL] f6809AddressRead [AX]
//
// [DL] f6809AddressWrite [AX] [DL]


T_UWORD  f6809_P1_00(T_VOID);

T_UWORD  f6809_P1_03(T_VOID);
T_UWORD  f6809_P1_04(T_VOID);

T_UWORD  f6809_P1_06(T_VOID);
T_UWORD  f6809_P1_07(T_VOID);
T_UWORD  f6809_P1_08(T_VOID);
T_UWORD  f6809_P1_09(T_VOID);
T_UWORD  f6809_P1_0A(T_VOID);

T_UWORD  f6809_P1_0C(T_VOID);
T_UWORD  f6809_P1_0D(T_VOID);
T_UWORD  f6809_P1_0E(T_VOID);
T_UWORD  f6809_P1_0F(T_VOID);

T_UWORD  f6809_P1_10(T_VOID);
T_UWORD  f6809_P1_11(T_VOID);

T_UWORD  f6809_P1_12(T_VOID);
T_UWORD  f6809_P1_13(T_VOID);

T_UWORD  f6809_P1_16(T_VOID);
T_UWORD  f6809_P1_17(T_VOID);

T_UWORD  f6809_P1_19(T_VOID);

T_UWORD  f6809_P1_1A(T_VOID);

T_UWORD  f6809_P1_1C(T_VOID);
T_UWORD  f6809_P1_1D(T_VOID);
T_UWORD  f6809_P1_1E(T_VOID);
T_UWORD  f6809_P1_1F(T_VOID);

T_UWORD  f6809_P1_20(T_VOID);
T_UWORD  f6809_P1_21(T_VOID);
T_UWORD  f6809_P1_22(T_VOID);
T_UWORD  f6809_P1_23(T_VOID);
T_UWORD  f6809_P1_24(T_VOID);
T_UWORD  f6809_P1_25(T_VOID);
T_UWORD  f6809_P1_26(T_VOID);
T_UWORD  f6809_P1_27(T_VOID);
T_UWORD  f6809_P1_28(T_VOID);
T_UWORD  f6809_P1_29(T_VOID);
T_UWORD  f6809_P1_2A(T_VOID);
T_UWORD  f6809_P1_2B(T_VOID);
T_UWORD  f6809_P1_2C(T_VOID);
T_UWORD  f6809_P1_2D(T_VOID);
T_UWORD  f6809_P1_2E(T_VOID);
T_UWORD  f6809_P1_2F(T_VOID);

T_UWORD  f6809_P1_30(T_VOID);
T_UWORD  f6809_P1_31(T_VOID);
T_UWORD  f6809_P1_32(T_VOID);
T_UWORD  f6809_P1_33(T_VOID);
T_UWORD  f6809_P1_34(T_VOID);
T_UWORD  f6809_P1_35(T_VOID);
T_UWORD  f6809_P1_36(T_VOID);
T_UWORD  f6809_P1_37(T_VOID);

T_UWORD  f6809_P1_39(T_VOID);
T_UWORD  f6809_P1_3A(T_VOID);
T_UWORD  f6809_P1_3B(T_VOID);
T_UWORD  f6809_P1_3C(T_VOID);
T_UWORD  f6809_P1_3D(T_VOID);

T_UWORD  f6809_P1_3F(T_VOID);

T_UWORD  f6809_P1_40(T_VOID);

T_UWORD  f6809_P1_43(T_VOID);
T_UWORD  f6809_P1_44(T_VOID);

T_UWORD  f6809_P1_46(T_VOID);
T_UWORD  f6809_P1_47(T_VOID);
T_UWORD  f6809_P1_48(T_VOID);
T_UWORD  f6809_P1_49(T_VOID);
T_UWORD  f6809_P1_4A(T_VOID);

T_UWORD  f6809_P1_4C(T_VOID);
T_UWORD  f6809_P1_4D(T_VOID);

T_UWORD  f6809_P1_4F(T_VOID);

T_UWORD  f6809_P1_50(T_VOID);

T_UWORD  f6809_P1_53(T_VOID);
T_UWORD  f6809_P1_54(T_VOID);

T_UWORD  f6809_P1_56(T_VOID);
T_UWORD  f6809_P1_57(T_VOID);
T_UWORD  f6809_P1_58(T_VOID);
T_UWORD  f6809_P1_59(T_VOID);

T_UWORD  f6809_P1_5A(T_VOID);

T_UWORD  f6809_P1_5C(T_VOID);
T_UWORD  f6809_P1_5D(T_VOID);

T_UWORD  f6809_P1_5F(T_VOID);

T_UWORD  f6809_P1_60(T_VOID);

T_UWORD  f6809_P1_63(T_VOID);
T_UWORD  f6809_P1_64(T_VOID);

T_UWORD  f6809_P1_66(T_VOID);
T_UWORD  f6809_P1_67(T_VOID);
T_UWORD  f6809_P1_68(T_VOID);
T_UWORD  f6809_P1_69(T_VOID);
T_UWORD  f6809_P1_6A(T_VOID);

T_UWORD  f6809_P1_6C(T_VOID);
T_UWORD  f6809_P1_6D(T_VOID);
T_UWORD  f6809_P1_6E(T_VOID);
T_UWORD  f6809_P1_6F(T_VOID);

T_UWORD  f6809_P1_70(T_VOID);

T_UWORD  f6809_P1_73(T_VOID);
T_UWORD  f6809_P1_74(T_VOID);

T_UWORD  f6809_P1_76(T_VOID);
T_UWORD  f6809_P1_77(T_VOID);
T_UWORD  f6809_P1_78(T_VOID);
T_UWORD  f6809_P1_79(T_VOID);
T_UWORD  f6809_P1_7A(T_VOID);

T_UWORD  f6809_P1_7C(T_VOID);
T_UWORD  f6809_P1_7D(T_VOID);

T_UWORD  f6809_P1_7E(T_VOID);
T_UWORD  f6809_P1_7F(T_VOID);

T_UWORD  f6809_P1_80(T_VOID);
T_UWORD  f6809_P1_81(T_VOID);
T_UWORD  f6809_P1_82(T_VOID);
T_UWORD  f6809_P1_83(T_VOID);
T_UWORD  f6809_P1_84(T_VOID);
T_UWORD  f6809_P1_85(T_VOID);
T_UWORD  f6809_P1_86(T_VOID);

T_UWORD  f6809_P1_88(T_VOID);
T_UWORD  f6809_P1_89(T_VOID);
T_UWORD  f6809_P1_8A(T_VOID);
T_UWORD  f6809_P1_8B(T_VOID);
T_UWORD  f6809_P1_8C(T_VOID);
T_UWORD  f6809_P1_8D(T_VOID);
T_UWORD  f6809_P1_8E(T_VOID);

T_UWORD  f6809_P1_90(T_VOID);
T_UWORD  f6809_P1_91(T_VOID);
T_UWORD  f6809_P1_92(T_VOID);
T_UWORD  f6809_P1_93(T_VOID);
T_UWORD  f6809_P1_94(T_VOID);
T_UWORD  f6809_P1_95(T_VOID);
T_UWORD  f6809_P1_96(T_VOID);
T_UWORD  f6809_P1_97(T_VOID);
T_UWORD  f6809_P1_98(T_VOID);
T_UWORD  f6809_P1_99(T_VOID);
T_UWORD  f6809_P1_9A(T_VOID);
T_UWORD  f6809_P1_9B(T_VOID);
T_UWORD  f6809_P1_9C(T_VOID);
T_UWORD  f6809_P1_9D(T_VOID);
T_UWORD  f6809_P1_9E(T_VOID);
T_UWORD  f6809_P1_9F(T_VOID);

T_UWORD  f6809_P1_A0(T_VOID);
T_UWORD  f6809_P1_A1(T_VOID);
T_UWORD  f6809_P1_A2(T_VOID);
T_UWORD  f6809_P1_A3(T_VOID);
T_UWORD  f6809_P1_A4(T_VOID);
T_UWORD  f6809_P1_A5(T_VOID);
T_UWORD  f6809_P1_A6(T_VOID);
T_UWORD  f6809_P1_A7(T_VOID);
T_UWORD  f6809_P1_A8(T_VOID);
T_UWORD  f6809_P1_A9(T_VOID);
T_UWORD  f6809_P1_AA(T_VOID);
T_UWORD  f6809_P1_AB(T_VOID);
T_UWORD  f6809_P1_AC(T_VOID);
T_UWORD  f6809_P1_AD(T_VOID);

T_UWORD  f6809_P1_AE(T_VOID);
T_UWORD  f6809_P1_AF(T_VOID);

T_UWORD  f6809_P1_B0(T_VOID);
T_UWORD  f6809_P1_B1(T_VOID);
T_UWORD  f6809_P1_B2(T_VOID);
T_UWORD  f6809_P1_B3(T_VOID);
T_UWORD  f6809_P1_B4(T_VOID);
T_UWORD  f6809_P1_B5(T_VOID);
T_UWORD  f6809_P1_B6(T_VOID);
T_UWORD  f6809_P1_B7(T_VOID);
T_UWORD  f6809_P1_B8(T_VOID);
T_UWORD  f6809_P1_B9(T_VOID);
T_UWORD  f6809_P1_BA(T_VOID);
T_UWORD  f6809_P1_BB(T_VOID);
T_UWORD  f6809_P1_BC(T_VOID);
T_UWORD  f6809_P1_BD(T_VOID);
T_UWORD  f6809_P1_BE(T_VOID);
T_UWORD  f6809_P1_BF(T_VOID);

T_UWORD  f6809_P1_C0(T_VOID);
T_UWORD  f6809_P1_C1(T_VOID);
T_UWORD  f6809_P1_C2(T_VOID);
T_UWORD  f6809_P1_C3(T_VOID);
T_UWORD  f6809_P1_C4(T_VOID);
T_UWORD  f6809_P1_C5(T_VOID);
T_UWORD  f6809_P1_C6(T_VOID);

T_UWORD  f6809_P1_C8(T_VOID);
T_UWORD  f6809_P1_C9(T_VOID);
T_UWORD  f6809_P1_CA(T_VOID);
T_UWORD  f6809_P1_CB(T_VOID);
T_UWORD  f6809_P1_CC(T_VOID);

T_UWORD  f6809_P1_CE(T_VOID);

T_UWORD  f6809_P1_D0(T_VOID);
T_UWORD  f6809_P1_D1(T_VOID);
T_UWORD  f6809_P1_D2(T_VOID);
T_UWORD  f6809_P1_D3(T_VOID);
T_UWORD  f6809_P1_D4(T_VOID);
T_UWORD  f6809_P1_D5(T_VOID);
T_UWORD  f6809_P1_D6(T_VOID);
T_UWORD  f6809_P1_D7(T_VOID);
T_UWORD  f6809_P1_D8(T_VOID);
T_UWORD  f6809_P1_D9(T_VOID);
T_UWORD  f6809_P1_DA(T_VOID);
T_UWORD  f6809_P1_DB(T_VOID);
T_UWORD  f6809_P1_DC(T_VOID);
T_UWORD  f6809_P1_DD(T_VOID);
T_UWORD  f6809_P1_DE(T_VOID);
T_UWORD  f6809_P1_DF(T_VOID);

T_UWORD  f6809_P1_E0(T_VOID);
T_UWORD  f6809_P1_E1(T_VOID);
T_UWORD  f6809_P1_E2(T_VOID);
T_UWORD  f6809_P1_E3(T_VOID);
T_UWORD  f6809_P1_E4(T_VOID);
T_UWORD  f6809_P1_E5(T_VOID);
T_UWORD  f6809_P1_E6(T_VOID);
T_UWORD  f6809_P1_E7(T_VOID);
T_UWORD  f6809_P1_E8(T_VOID);
T_UWORD  f6809_P1_E9(T_VOID);
T_UWORD  f6809_P1_EA(T_VOID);
T_UWORD  f6809_P1_EB(T_VOID);
T_UWORD  f6809_P1_EC(T_VOID);
T_UWORD  f6809_P1_ED(T_VOID);
T_UWORD  f6809_P1_EE(T_VOID);
T_UWORD  f6809_P1_EF(T_VOID);

T_UWORD  f6809_P1_F0(T_VOID);
T_UWORD  f6809_P1_F1(T_VOID);
T_UWORD  f6809_P1_F2(T_VOID);
T_UWORD  f6809_P1_F3(T_VOID);
T_UWORD  f6809_P1_F4(T_VOID);
T_UWORD  f6809_P1_F5(T_VOID);
T_UWORD  f6809_P1_F6(T_VOID);
T_UWORD  f6809_P1_F7(T_VOID);
T_UWORD  f6809_P1_F8(T_VOID);
T_UWORD  f6809_P1_F9(T_VOID);
T_UWORD  f6809_P1_FA(T_VOID);
T_UWORD  f6809_P1_FB(T_VOID);
T_UWORD  f6809_P1_FC(T_VOID);
T_UWORD  f6809_P1_FD(T_VOID);
T_UWORD  f6809_P1_FE(T_VOID);
T_UWORD  f6809_P1_FF(T_VOID);

T_UWORD  f6809_P2_21(T_VOID);
T_UWORD  f6809_P2_22(T_VOID);
T_UWORD  f6809_P2_23(T_VOID);
T_UWORD  f6809_P2_24(T_VOID);
T_UWORD  f6809_P2_25(T_VOID);
T_UWORD  f6809_P2_26(T_VOID);
T_UWORD  f6809_P2_27(T_VOID);
T_UWORD  f6809_P2_28(T_VOID);
T_UWORD  f6809_P2_29(T_VOID);
T_UWORD  f6809_P2_2A(T_VOID);
T_UWORD  f6809_P2_2B(T_VOID);
T_UWORD  f6809_P2_2C(T_VOID);
T_UWORD  f6809_P2_2D(T_VOID);
T_UWORD  f6809_P2_2E(T_VOID);
T_UWORD  f6809_P2_2F(T_VOID);

T_UWORD  f6809_P2_3F(T_VOID);

T_UWORD  f6809_P2_83(T_VOID);

T_UWORD  f6809_P2_8C(T_VOID);

T_UWORD  f6809_P2_8E(T_VOID);

T_UWORD  f6809_P2_93(T_VOID);

T_UWORD  f6809_P2_9C(T_VOID);

T_UWORD  f6809_P2_9E(T_VOID);
T_UWORD  f6809_P2_9F(T_VOID);

T_UWORD  f6809_P2_A3(T_VOID);

T_UWORD  f6809_P2_AC(T_VOID);

T_UWORD  f6809_P2_AE(T_VOID);
T_UWORD  f6809_P2_AF(T_VOID);

T_UWORD  f6809_P2_B3(T_VOID);

T_UWORD  f6809_P2_BC(T_VOID);

T_UWORD  f6809_P2_BE(T_VOID);
T_UWORD  f6809_P2_BF(T_VOID);

T_UWORD  f6809_P2_CE(T_VOID);

T_UWORD  f6809_P2_DE(T_VOID);
T_UWORD  f6809_P2_DF(T_VOID);

T_UWORD  f6809_P2_EE(T_VOID);
T_UWORD  f6809_P2_EF(T_VOID);

T_UWORD  f6809_P2_FE(T_VOID);
T_UWORD  f6809_P2_FF(T_VOID);

T_UWORD  f6809_P3_3F(T_VOID);

T_UWORD  f6809_P3_83(T_VOID);

T_UWORD  f6809_P3_8C(T_VOID);

T_UWORD  f6809_P3_93(T_VOID);

T_UWORD  f6809_P3_9C(T_VOID);

T_UWORD  f6809_P3_A3(T_VOID);

T_UWORD  f6809_P3_AC(T_VOID);

T_UWORD  f6809_P3_B3(T_VOID);

T_UWORD  f6809_P3_BC(T_VOID);


/* END OF FILE */

