/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : This file contains function prototypes for the 6809        */
/*                dissasembler module.                                       */
/*                                                                           */
/*   File Name  : DIS6809.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : The 6809 disassembler function prototypes                  */
/*                and necessary definitions                                  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    11/04/94  K.W  Creation                                        */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined DIS6809_H
    #define DIS6809_H

/* Defines for this module */

#define ILLEGAL             0
#define PAGE2               1
#define PAGE3               2
#define DIRECT              3
#define EXTENDED            4
#define INHERENT            5
#define RELATIVE8           6
#define RELATIVE16          7
#define IMMEDIATE8          8
#define IMMEDIATE16         9
#define INDEXED             10
#define REGISTER1           11
#define REGISTER2           12

typedef struct sMNEMONIC
{
        T_UCHAR   acInstruction[6];
        T_UCHAR   bAddressMode;

}tsMNEMONIC,*ptsMNEMONIC;

#define NO_OF_6809_OPCODES  768

// defines for memory map
#define D_MEM_SIZE 65536

#define D_MEM_NOT_INIT     128
#define D_MEM_CODE           1
#define D_MEM_DATA_BIN       2
#define D_MEM_DATA_ASCII     4
#define D_MEM_START          8
#define D_MEM_HAS_INFO      16

// defines for address information
#define D_INFO_LABEL        1
#define D_INFO_COMMENT      2
#define D_INFO_COMMENT_LINE 3
#define D_INFO_EQU          4

typedef struct
{
 T_INT   kind_of_info;
 T_INT   address;
 T_PCHAR string;
} D_ADDRESS_INFO;

// defines for parser reading
#define D_LABEL           1
#define D_COMMENT_LINE    2
#define D_COMMENT         3
#define D_CODE            4
#define D_DATA_BIN        5
#define D_DATA_ASCII      6
#define D_RANGE           7
#define D_EQU             8

/* Function prototypes */
T_UWORD  f6809Disassemble(T_UWORD wAddr,T_PUCHAR mempnt);
T_UCHAR  f6809CycleCount(T_UWORD wAddr);

T_VOID init_dis(T_VOID);
T_VOID deinit_dis(T_VOID);

extern tsMNEMONIC as6809Dis[];
extern T_UCHAR  ac6809Modes[][20];
extern T_CHAR dis_mem_map[D_MEM_SIZE];
extern T_LISTE *info_liste_first;
extern T_LISTE *info_liste_last;
extern T_INT dis_init_state;


#endif

