/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vector display driver module header file                   */
/*                                                                           */
/*   File Name  : DISPLAY.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the functions definitions & prototypes  */
/*                for the vector display driver software module.             */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined DISPLAY_H
    #define DISPLAY_H

#include <standard.h>

#include "io.h"
typedef struct sDline
{
   T_SWORD   iX1;
   T_SWORD   iY1;
   T_SWORD   iX2;
   T_SWORD   iY2;
   T_SWORD   is_dot;
   T_SWORD   brightness;
   T_SWORD   imager_color;
   T_SWORD   age;
   T_SWORD   next_vector;
   T_SWORD   hash_index;
}SDLINE;

typedef struct sHash
{
   T_SWORD   line_index;
   T_SWORD   next_hash;
   T_SWORD   prev_hash;
   T_SWORD   hash_code;
}SHASH;

typedef struct displayinfo
{
   T_UWORD iDivShiftA;
   T_UWORD iDivShiftB;
}DISPLAYINFO;

#define LINE_REFRESH_LIMIT  16  // Number of refreshes for a line before it can be selected
#define REFRESH_PERIOD_ADJ  500
#define LINESTORE_DEPTH     4000
#define HASH_TABLE_SIZE     1511
#define HASH_MASK           0x03ff

/***********************/
/* Overlay definitions */
/***********************/
#define OVERLAY_LINE_COUNT 1600
#define DUFF_VALUE         -99999999
#define MAX_ARGS           16

/* Define function prototypes */

T_VOID fDisplayClear(T_VOID);
T_INT  fDisplayLoadVOL(T_VOID);
T_INT  fDisplayInit(T_VOID);
T_VOID fDisplayReset(T_VOID);
T_VOID vector_refresh(T_VOID);
T_VOID vector_undraw(T_VOID);

extern T_VOID (* fDisplayTick)(T_VOID);
extern T_VOID (* fDisplayLineDraw)(T_SLONG,T_SLONG,T_SLONG,T_SLONG,T_UCHAR);

extern DISPLAYINFO    display_infox[RESOLUTION_COUNT];
extern T_UWORD        divider_x[RESOLUTION_COUNT];
extern DISPLAYINFO    display_infoy[RESOLUTION_COUNT];
extern T_UWORD        divider_y[RESOLUTION_COUNT];
extern DISPLAYINFO    display_infox_reset[RESOLUTION_COUNT];
extern T_UWORD        divider_x_reset[RESOLUTION_COUNT];
extern DISPLAYINFO    display_infoy_reset[RESOLUTION_COUNT];
extern T_UWORD        divider_y_reset[RESOLUTION_COUNT];

/*******************************************/
/* Decoded copies of all configs for speed */
/*******************************************/
extern T_UWORD iDivShiftAx;
extern T_UWORD iDivShiftBx;
extern T_UWORD iDivShiftAy;
extern T_UWORD iDivShiftBy;

extern T_SWORD iXOffset;
extern T_SWORD iYOffset;

extern T_SWORD iX1clip;
extern T_SWORD iY1clip;
extern T_SWORD iX2clip;
extern T_SWORD iY2clip;

/*****************************************/
/* Variables for refresh timing & adjust */
/*****************************************/
extern T_SWORD iLineSelected;
extern T_SWORD iLineSelector;
extern T_ULONG lwRefreshMarker;

/**************************/
/* Line store definitions */
/**************************/
extern SDLINE line_store[LINESTORE_DEPTH];

/*****************************/
/* Hashing table definitions */
/*****************************/
extern T_SWORD    line_freelist;
extern T_SWORD    line_rootnode;

extern T_SWORD hash_rootnodes[HASH_TABLE_SIZE];
extern T_SWORD hash_freelist;
extern SHASH hash_store[LINESTORE_DEPTH];

extern T_SWORD diX1;
extern T_SWORD diY1;
extern T_SWORD diX2;
extern T_SWORD diY2;

extern T_SWORD hash_code;
extern T_SWORD hash;
extern T_SWORD line;
extern T_INT display_init_back;
extern T_INT fDNoPicload;

extern T_PUCHAR overlay_line_starts[OVERLAY_LINE_COUNT];

#endif



