#pragma message ( "including dtick.cc" );
/*****************************************************************************/
/*                                                                           */
/*   Function    : fDisplayTick()                                            */
/*                                                                           */
/*   Author      : K.W / C.S.                                                */
/*                                                                           */
/*   Description : This is the function that is called by the scheduler to   */
/*                 emulate persistance and flush screen when required        */
/*                                                                           */
/*   Accepts     : nothing                                                   */
/*                                                                           */
/*   Returns     : nothing                                                   */
/*                                                                           */
/*****************************************************************************/
//void fDisplayTick(void)
{
 T_SWORD iTmp,next_vector,iPrevious=-1;
 T_SWORD iFlag=0;
 T_SWORD hash;

#ifdef DISPLAY_TICK_IMAGER
   T_INT imager_color_save=ImagerColorNow;
#endif
/***************************************************************/
/* Scan the Active list decrementing all ages if line age == 0 */
/* then erase the line                                         */
/***************************************************************/
 iTmp=line_rootnode;

 while (iTmp!=-1)
 {
  /**************************************************/
  /* If the line exists at age 0 then it is deleted */
  /**************************************************/
  if (!line_store[iTmp].age)
  {
   /**********************************************************/
   /* Check if this is the reference line used for display   */
   /* refresh timing, if so then increase the lost reference */
   /* count and clear the line reference, after we've lost   */
   /* iAdjustCount references we will change the line period */
   /**********************************************************/
   if (bGblDisplayAutoRefresh && iTmp==iLineSelected)
   {
    iLineSelected=-1;
    lwGblDisplayTickReload+=(lwGblDisplayTickReload>>3);
    if (lwGblDisplayTickReload>lwGblDisplayTickMax)
     lwGblDisplayTickReload=lwGblDisplayTickMax;
    fDebug(MED,("fDisplayTick() - Error correct: Age(%d) Reload(%ld)",wGblDisplayLinePeriod,lwGblDisplayTickReload));
   }
   /**************/
   /* Erase line */
   /**************/
//   fIODrawLine(line_store[iTmp].iX1,line_store[iTmp].iY1,line_store[iTmp].iX2,line_store[iTmp].iY2,0);

   {
    static T_SWORD iX1;
    static T_SWORD iY1;
    static T_SWORD iX2;
    static T_SWORD iY2;
    #ifdef ANTI_ALIASING
    static T_SWORD iColour;
    static T_SWORD is_dot;
    #endif
    iX1=line_store[iTmp].iX1;
    iY1=line_store[iTmp].iY1;
    iX2=line_store[iTmp].iX2;
    iY2=line_store[iTmp].iY2;


    #ifdef ANTI_ALIASING
    is_dot=line_store[iTmp].is_dot;
    iColour=line_store[iTmp].brightness;
    #ifdef DISPLAY_TICK_LINEAR
    #include "line_aa.cc"
    #endif
    #ifdef DISPLAY_TICK_BANKED
    #define BANKED
    #include "line_aa.cc"
    #undef BANKED
    #endif
    #else
    #ifdef DISPLAY_TICK_LINEAR
    #include "line.cc"
    #endif
    #ifdef DISPLAY_TICK_BANKED
    #define BANKED
    #include "line.cc"
    #undef BANKED
    #endif
    #endif
   }

   /*******************************************************/
   /* Unlink node from Active list of relevant hash table */
   /*******************************************************/
   hash=line_store[iTmp].hash_index;
   if (hash_store[hash].prev_hash==-1)
   {
    hash_rootnodes[hash_store[hash].hash_code]=hash_store[hash].next_hash;
    if (hash_store[hash].next_hash!=-1)
     hash_store[hash_store[hash].next_hash].prev_hash=-1;
   }
   else
   {
    hash_store[hash_store[hash].prev_hash].next_hash=hash_store[hash].next_hash;
    if (hash_store[hash].next_hash!=-1)
     hash_store[hash_store[hash].next_hash].prev_hash=hash_store[hash].prev_hash;
   }

   /***************************************/
   /* Place node back on vector free list */
   /***************************************/
   hash_store[hash].next_hash=hash_freelist;
   hash_freelist=hash;

   /************************************************/
   /* Unlink node from Active list of Vector table */
   /************************************************/
   if (iPrevious==-1)
   {
    line_rootnode=line_store[iTmp].next_vector;
   }
   else
   {
    line_store[iPrevious].next_vector=line_store[iTmp].next_vector;
   }

   /***************************************/
   /* Place node back on vector free list */
   /***************************************/
   next_vector=line_store[iTmp].next_vector;
   line_store[iTmp].next_vector=line_freelist;
   line_freelist=iTmp;

   /***********************/
   /* Setup the next node */
   /***********************/
   iTmp=next_vector;

   /***********************************************/
   /* Set the flag to say that redraw is required */
   /***********************************************/
   iFlag=1;
  }
  else
  {
   line_store[iTmp].age--;
   iPrevious=iTmp;
   iTmp=line_store[iTmp].next_vector;
  }
 }

 /******************************************************************/
 /* Repaint the entire screen in case erasures have damaged things */
 /******************************************************************/
 if ((iFlag && bGblDisplayEnhance)||(bGblDisplayFullRefresh==T_TRUE))
 {
#ifdef DEBUG_MSG
//  if (bGblDisplayFullRefresh==T_TRUE)
//   fDebug(HIGH,("Display Full Refresh!!!"));
#endif

  iTmp=line_rootnode;
  while(iTmp!=-1)
  {
   static T_SWORD iX1;
   static T_SWORD iY1;
   static T_SWORD iX2;
   static T_SWORD iY2;
   static T_SWORD iColour;
   #ifdef ANTI_ALIASING
   static T_SWORD is_dot;
   #endif
   iX1=line_store[iTmp].iX1;
   iY1=line_store[iTmp].iY1;
   iX2=line_store[iTmp].iX2;
   iY2=line_store[iTmp].iY2;
   iColour=line_store[iTmp].brightness;
#ifdef DISPLAY_TICK_IMAGER
   ImagerColorNow=line_store[iTmp].imager_color;
#endif




   #ifdef ANTI_ALIASING
   is_dot=line_store[iTmp].is_dot;
   if (bGblOverlayEnable)
//    fIODrawMaskLine(line_store[iTmp].iX1,line_store[iTmp].iY1,line_store[iTmp].iX2,line_store[iTmp].iY2,line_store[iTmp].brightness);
   {
    #ifdef DISPLAY_TICK_LINEAR
    #include "mline_aa.cc"
    #endif
    #ifdef DISPLAY_TICK_BANKED
     #define BANKED
     #include "mline_aa.cc"
     #undef BANKED
    #endif
   }
   else
//    fIODrawLine(line_store[iTmp].iX1,line_store[iTmp].iY1,line_store[iTmp].iX2,line_store[iTmp].iY2,line_store[iTmp].brightness);
   {
    #define LINE_WITH_COLOR
    #ifdef DISPLAY_TICK_LINEAR
    #include "line_aa.cc"
    #endif
    #ifdef DISPLAY_TICK_BANKED
    #define BANKED
    #include "line_aa.cc"
    #undef BANKED
    #endif
    #undef LINE_WITH_COLOR
   }
   #else
   if (bGblOverlayEnable)
//    fIODrawMaskLine(line_store[iTmp].iX1,line_store[iTmp].iY1,line_store[iTmp].iX2,line_store[iTmp].iY2,line_store[iTmp].brightness);
   {
    #ifdef DISPLAY_TICK_LINEAR
    #include "mline.cc"
    #endif
    #ifdef DISPLAY_TICK_BANKED
     #define BANKED
     #include "mline.cc"
     #undef BANKED
    #endif
   }
   else
//    fIODrawLine(line_store[iTmp].iX1,line_store[iTmp].iY1,line_store[iTmp].iX2,line_store[iTmp].iY2,line_store[iTmp].brightness);
   {
    #define LINE_WITH_COLOR
    #ifdef DISPLAY_TICK_LINEAR
    #include "line.cc"
    #endif
    #ifdef DISPLAY_TICK_BANKED
    #define BANKED
    #include "line.cc"
    #undef BANKED
    #endif
    #undef LINE_WITH_COLOR
   }
   #endif

   iTmp=line_store[iTmp].next_vector;
  }
 }
#ifdef DISPLAY_TICK_IMAGER
 ImagerColorNow=imager_color_save;
#endif
}
