/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : 6522A Emulation module header file                         */
/*                                                                           */
/*   File Name  : EMU6522.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins / C.S.                                       */
/*                                                                           */
/*   Version    : 1.20                                                       */
/*                                                                           */
/*   Desciption : This file contains the function prototypes and definitions */
/*                for the functions that emulates the 6522 PIA Chip          */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*    1.20    20/10/96  C.S  DVE V1.20                                       */
/*                                                                           */
/*****************************************************************************/

#if !defined EMU6522_H
# define EMU6522_H

// Typedefs

typedef struct
{
 union
 {
  T_UWORD   tW;
  struct
  {
   T_UCHAR   tL;
   T_UCHAR   tH;
  }sW;
 }uLatch;
 union
 {
  T_UWORD   tW;
  struct
  {
   T_UCHAR   tL;
   T_UCHAR   tH;
  }sW;
 }uCount;
}TIMER;

#ifndef EMU6522_C


//extern T_UWORD tpatch_counter;
//extern T_UWORD tpatch_set;
#ifdef ANALOG_CYCLE_PATCH

extern T_UWORD patch_must_be_applied;

#define MAX_RAMP_QUEUE_DEPTH 5
//#define RAMP_REACT_OFFSET_CYCLES 1//12
extern T_UWORD RAMP_REACT_OFFSET_CYCLES;
#define RAMP_TEST_BIT 1
extern T_UWORD ramp_patch;
extern T_UWORD ramp_patch_queue_depth;
extern T_UWORD ramp_patch_cycle_countdown[MAX_RAMP_QUEUE_DEPTH];
extern T_UWORD ramp_set_to[MAX_RAMP_QUEUE_DEPTH];

#define MAX_BLANK_QUEUE_DEPTH 5
//#define BLANK_REACT_OFFSET_CYCLES 1//12
extern T_UWORD BLANK_REACT_OFFSET_CYCLES;
#define BLANK_TEST_BIT 2
extern T_UWORD blank_patch;
extern T_UWORD blank_patch_queue_depth;
extern T_UWORD blank_patch_cycle_countdown[MAX_BLANK_QUEUE_DEPTH];
extern T_UWORD blank_set_to[MAX_BLANK_QUEUE_DEPTH];

#define MAX_ZERO_QUEUE_DEPTH 5
//#define ZERO_REACT_OFFSET_CYCLES 1//12
extern T_UWORD ZERO_REACT_OFFSET_CYCLES;
#define ZERO_TEST_BIT 4
extern T_UWORD zero_patch;
extern T_UWORD zero_patch_queue_depth;
extern T_UWORD zero_patch_cycle_countdown[MAX_ZERO_QUEUE_DEPTH];
extern T_UWORD zero_set_to[MAX_ZERO_QUEUE_DEPTH];

#define MAX_DAC_QUEUE_DEPTH 5
//#define DAC_REACT_OFFSET_CYCLES 1//12
extern T_UWORD DAC_REACT_OFFSET_CYCLES;
#define DAC_TEST_BIT 8
extern T_UWORD dac_patch;
extern T_UWORD dac_patch_queue_depth;
extern T_UWORD dac_patch_cycle_countdown[MAX_DAC_QUEUE_DEPTH];
extern T_SCHAR dac_set_to[MAX_DAC_QUEUE_DEPTH];

#define MAX_SAMPLE_HOLD_QUEUE_DEPTH 5
//#define SAMPLE_HOLD_REACT_OFFSET_CYCLES 1//12
extern T_UWORD SAMPLE_HOLD_REACT_OFFSET_CYCLES;
#define SAMPLE_HOLD_TEST_BIT 16
extern T_UWORD sample_hold_patch;
extern T_UWORD sample_hold_patch_queue_depth;
extern T_UWORD sample_hold_patch_cycle_countdown[MAX_SAMPLE_HOLD_QUEUE_DEPTH];
extern T_UWORD sample_hold_set_to[MAX_SAMPLE_HOLD_QUEUE_DEPTH];
extern T_UWORD mux_select_set_to[MAX_SAMPLE_HOLD_QUEUE_DEPTH];
#endif









// Define externals for other functions

extern T_UCHAR      t6522ORB_0;  // Output register B - Bit 0 - Sample/Hold
extern T_UCHAR      t6522IRB_0;  // Input  register B - Bit 0 - Sample/Hold
extern T_UCHAR      t6522IRB_0L;  // Input  register B - Bit 0 - Sample/Hold

extern T_UCHAR      t6522ORB_1;  // Output register B - Bit 1/2 - Analog mux select bit 0
extern T_UCHAR      t6522IRB_1;  // Input  register B - Bit 1/2 - Analog mux select
extern T_UCHAR      t6522IRB_1L;  // Input  register B - Bit 1/2 - Analog mux select

extern T_UCHAR      t6522ORB_2;  // Output register B - Bit 1/2 - Analog mux select bit 1
extern T_UCHAR      t6522IRB_2;  // Input  register B - Bit 1/2 - Analog mux select
extern T_UCHAR      t6522IRB_2L;  // Input  register B - Bit 1/2 - Analog mux select

extern T_UCHAR      t6522ORB_3;  // Output register B - Bit 3 - Sound Chip BC1
extern T_UCHAR      t6522IRB_3;  // Input  register B - Bit 3 - Sound Chip BC1
extern T_UCHAR      t6522IRB_3L;  // Input  register B - Bit 3 - Sound Chip BC1

extern T_UCHAR      t6522ORB_4;  // Output register B - Bit 4 - Sound Chip BDIR
extern T_UCHAR      t6522IRB_4;  // Input  register B - Bit 4 - Sound Chip BDIR
extern T_UCHAR      t6522IRB_4L;  // Input  register B - Bit 4 - Sound Chip BDIR

extern T_UCHAR      t6522ORB_5;  // Output register B - Bit 5 - Compare
extern T_UCHAR      t6522IRB_5;  // Input  register B - Bit 5 - Compare
extern T_UCHAR      t6522IRB_5L;  // Input  register B - Bit 5 - Compare

extern T_UCHAR      t6522ORB_6;  // Output register B - Bit 6 - Cartridge
extern T_UCHAR      t6522IRB_6;  // Input  register B - Bit 6 - Cartridge
extern T_UCHAR      t6522IRB_6L;  // Input  register B - Bit 6 - Cartridge

extern T_UCHAR      t6522ORB_7REG;  // Output register B - Bit 6 - Ramp
extern T_UCHAR      t6522ORB_7;  // Output register B - Bit 6 - Ramp
extern T_UCHAR      t6522IRB_7;  // Input  register B - Bit 6 - Ramp
extern T_UCHAR      t6522IRB_7L;  // Input  register B - Bit 6 - Ramp

extern T_UCHAR      t6522ORA;    // Output register A
extern T_UCHAR      t6522IRA;    // Input register A
extern T_UCHAR      t6522IRAL;            // Input register A latch

extern T_UCHAR      t6522DDRB;            // Data Direction reg B     0x00
extern T_UCHAR      t6522DDRA;            // Data Direction reg A     0x01


extern T_UCHAR      t6522CA1;    // CA1 Pin
extern T_UCHAR      t6522CA2;    // CA2 Pin
extern T_UCHAR      t6522CB1;    // CB1 Pin
extern T_UCHAR      t6522CB2;    // CB2 Pin

extern TIMER      u6522Timer1;            // Timer structures
extern TIMER      u6522Timer2;
extern T_INT       bTimer2OneShot;

extern T_UCHAR      t6522AUX_T1CTRL;
extern T_UCHAR      t6522AUX_T2CTRL;
extern T_UCHAR      t6522AUX_SHFTCTRL;
extern T_UCHAR      t6522AUX_PA_LE;       // Aux register port A latch enable
extern T_UCHAR      t6522AUX_PB_LE;       // Aux register port B latch enable

extern T_UCHAR      t6522PCR_CB2CTRL;     // Peripheral ctrl reg CB2
extern T_UCHAR      t6522PCR_CB1CTRL;     // Peripheral ctrl reg CB1
extern T_UCHAR      t6522PCR_CA2CTRL;     // Peripheral ctrl reg CA2
extern T_UCHAR      t6522PCR_CA1CTRL;     // Peripheral ctrl reg CA1

extern T_UCHAR      t6522IFLG;
extern T_UCHAR      t6522IER;

extern T_UCHAR      t6522SHFTREG;
extern T_UCHAR      t6522SHFTREGACT;
extern T_SWORD iToggle;
extern T_LONG tcount;
extern T_INT t1T_INT;

#endif


// Required vectrex hardware signals from the 6522

#define    E6522IFLG_CA2    0x01
#define    E6522IFLG_CA1    0x02
#define    E6522IFLG_SHFT   0x04
#define    E6522IFLG_CB2    0x08
#define    E6522IFLG_CB1    0x10
#define    E6522IFLG_TIMER2 0x20
#define    E6522IFLG_TIMER1 0x40

#ifdef ANALOG_CYCLE_PATCH
extern T_SCHAR tSIGDEF_DACBUS;
#else
#define    tSIGDEF_DACBUS      t6522ORA
#endif

#ifdef ANALOG_CYCLE_PATCH
extern T_UCHAR tSIGDEF_SAMPHOLD;
#else
#define    tSIGDEF_SAMPHOLD    t6522ORB_0
#endif

#ifdef ANALOG_CYCLE_PATCH
extern T_UCHAR tSIGDEF_AMUXSEL;
#else
#define    tSIGDEF_AMUXSEL     (t6522ORB_1 |t6522ORB_2)
#endif

#ifdef ANALOG_CYCLE_PATCH
extern T_UCHAR tSIGDEF_ZEROB;
#else
#define    tSIGDEF_ZEROB       t6522CA2
#endif

#ifdef ANALOG_CYCLE_PATCH
extern T_UCHAR tSIGDEF_RAMPB;
#else
#define    tSIGDEF_RAMPB       t6522ORB_7
#endif

#define    tSIGDEF_COMPARE     t6522IRB_5

#ifdef ANALOG_CYCLE_PATCH
extern T_UCHAR tSIGDEF_BLANKB;
#else
#define    tSIGDEF_BLANKB      t6522CB2
#endif

#define    tSIGDEF_AY3BDIR     t6522ORB_4
#define    tSIGDEF_AY3BC1      t6522ORB_3
#define    tSIGDEF_SW7         t6522CA1
#define    tSIGDEF_CARTRIDGE   t6522IRB_6

#define    PIA6522_ADDR00  0xd000
#define    PIA6522_ADDR01  0xd001
#define    PIA6522_ADDR02  0xd002
#define    PIA6522_ADDR03  0xd003
#define    PIA6522_ADDR04  0xd004
#define    PIA6522_ADDR05  0xd005
#define    PIA6522_ADDR06  0xd006
#define    PIA6522_ADDR07  0xd007
#define    PIA6522_ADDR08  0xd008
#define    PIA6522_ADDR09  0xd009
#define    PIA6522_ADDR0A  0xd00a
#define    PIA6522_ADDR0B  0xd00b
#define    PIA6522_ADDR0C  0xd00c
#define    PIA6522_ADDR0D  0xd00d
#define    PIA6522_ADDR0E  0xd00e
#define    PIA6522_ADDR0F  0xd00f

#define    MASK_RB_0           0xfe
#define    TMPL_RB_0           0x01

#define    MASK_RB_1           0xfd
#define    TMPL_RB_1           0x02

#define    MASK_RB_2           0xfb
#define    TMPL_RB_2           0x04

#define    MASK_RB_3           0xf7
#define    TMPL_RB_3           0x08

#define    MASK_RB_4           0xef
#define    TMPL_RB_4           0x10

#define    MASK_RB_5           0xdf
#define    TMPL_RB_5           0x20

#define    MASK_RB_6           0xbf
#define    TMPL_RB_6           0x40

#define    MASK_RB_7           0x7f
#define    TMPL_RB_7           0x80



/* Declare the public functions for emu6522.c */

T_INT        f6522Init(T_VOID);
T_VOID       f6522Reset(T_VOID);

extern T_UCHAR      (* f6522Addr0DRead)(T_UWORD);

extern T_VOID       (* f6522Tick)(T_VOID);
extern T_UCHAR      (* f6522Addr00Read)(T_UWORD);
extern T_UCHAR      (* f6522Addr00Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr01Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr01Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr02Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr02Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr03Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr03Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr04Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr04Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr05Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr05Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr06Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr06Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr07Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr07Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr08Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr08Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr09Read )(T_UWORD);
extern T_UCHAR      (* f6522Addr09Write)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr0ARead )(T_UWORD);
extern T_UCHAR      (* f6522Addr0AWrite)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr0BRead )(T_UWORD);
extern T_UCHAR      (* f6522Addr0BWrite)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr0CRead )(T_UWORD);
extern T_UCHAR      (* f6522Addr0CWrite)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr0DReadNoLightpen)(T_UWORD);
extern T_UCHAR      (* f6522Addr0DReadLightpen)(T_UWORD);
extern T_UCHAR      (* f6522Addr0DWrite)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr0ERead)(T_UWORD);
extern T_UCHAR      (* f6522Addr0EWrite)(T_UWORD,T_UCHAR);
extern T_UCHAR      (* f6522Addr0FRead)(T_UWORD);
extern T_UCHAR      (* f6522Addr0FWrite)(T_UWORD,T_UCHAR);

T_VOID set_emu6522_functions(T_INT type);

extern T_INT t1int;


#ifdef PATCH_OFFSET
 extern T_INT wait_ramp;
 #define PATCH_DELAY 12 // in cycles
 #define T_WAIT_NOT 0
 #define T_WAIT_SHIFTING 1
 #define T_WAIT_RAMP_ACCESS 2
 #define T_WAIT_WAS_PATCHED 3
#endif

#endif

/* End of EMU6522.H */
