;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator code TFR instruction code                    *
;*                                                                           *
;*   File Name  : TFR6809.ASM                                                *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the code to emulate the tfr instruction *
;*                a jump table is used to decode the register combinations   *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    22/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    06/08/96  K.W  Public release of DVE 1.0                       *
;*                                                                           *
;*****************************************************************************

extern _f6809AddressRead:near
extern _f6809AddressWrite:near
extern _Idx6809JumpTable:near
extern f6809cctodl_:near
extern f6809dltocc_:near

include "reg6809.h"
include "mac6809.h"


_EXG6809_TEXT segment dword public 'CODE'
              assume  CS:_EXG6809_TEXT

;
; CPU Exception
;
exg6809_EX    PROC    near

              add     sp,4               ; Remove return address
              mov     ax,CPU_EXCEPTION
              m_exit
              ret

exg6809_EX    ENDP



;
; 00 - D,D
;
exg6809_00     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_00     ENDP



;
; 01 - D,X
;
exg6809_01     PROC    near

               mov     dx,[R6809_D]
               mov     cx,[R6809_X]
               mov     [R6809_D],cx
               mov     [R6809_X],dx
               mov     ax,CPU_FETCH
               ret

exg6809_01     ENDP



;
; 02 - D,Y
;
exg6809_02     PROC    near

               mov     dx,[R6809_D]
               mov     cx,[R6809_Y]
               mov     [R6809_D],cx
               mov     [R6809_Y],dx
               mov     ax,CPU_FETCH
               ret

exg6809_02     ENDP



;
; 03 - D,U
;
exg6809_03     PROC    near

               mov     dx,[R6809_D]
               mov     cx,[R6809_USP]
               mov     [R6809_D],cx
               mov     [R6809_USP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_03     ENDP



;
; 04 - D,S
;
exg6809_04     PROC    near

               mov     dx,[R6809_D]
               mov     cx,[R6809_HSP]
               mov     [R6809_D],cx
               mov     [R6809_HSP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_04     ENDP



;
; 05 - D,PC
;
exg6809_05     PROC    near

               mov     dx,[R6809_D]
               mov     cx,[R6809_PC]
               mov     [R6809_D],cx
               mov     [R6809_PC],dx
               mov     ax,CPU_FETCH
               ret

exg6809_05     ENDP



;
; 10 - X,D
;
exg6809_10     PROC    near

               mov     dx,[R6809_X]
               mov     cx,[R6809_D]
               mov     [R6809_X],cx
               mov     [R6809_D],dx
               mov     ax,CPU_FETCH
               ret

exg6809_10     ENDP



;
; 11 - X,X
;
exg6809_11     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_11     ENDP



;
; 12 - X,Y
;
exg6809_12     PROC    near

               mov     dx,[R6809_X]
               mov     cx,[R6809_Y]
               mov     [R6809_X],cx
               mov     [R6809_Y],dx
               mov     ax,CPU_FETCH
               ret

exg6809_12     ENDP



;
; 13 - X,U
;
exg6809_13     PROC    near

               mov     dx,[R6809_X]
               mov     cx,[R6809_USP]
               mov     [R6809_X],cx
               mov     [R6809_USP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_13     ENDP



;
; 14 - X,S
;
exg6809_14     PROC    near

               mov     dx,[R6809_X]
               mov     cx,[R6809_HSP]
               mov     [R6809_X],cx
               mov     [R6809_HSP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_14     ENDP



;
; 15 - X,PC
;
exg6809_15     PROC    near

               mov     dx,[R6809_X]
               mov     cx,[R6809_PC]
               mov     [R6809_X],cx
               mov     [R6809_PC],dx
               mov     ax,CPU_FETCH
               ret

exg6809_15     ENDP



;
; 20 - Y,D
;
exg6809_20     PROC    near

               mov     dx,[R6809_D]
               mov     cx,[R6809_Y]
               mov     [R6809_D],cx
               mov     [R6809_Y],dx
               mov     ax,CPU_FETCH
               ret

exg6809_20     ENDP



;
; 21 - Y,X
;
exg6809_21     PROC    near

               mov     dx,[R6809_Y]
               mov     cx,[R6809_X]
               mov     [R6809_Y],cx
               mov     [R6809_X],dx
               mov     ax,CPU_FETCH
               ret

exg6809_21     ENDP



;
; 22 - Y,Y
;
exg6809_22     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_22     ENDP



;
; 23 - Y,U
;
exg6809_23     PROC    near

               mov     dx,[R6809_Y]
               mov     cx,[R6809_USP]
               mov     [R6809_Y],cx
               mov     [R6809_USP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_23     ENDP



;
; 24 - Y,S
;
exg6809_24     PROC    near

               mov     dx,[R6809_Y]
               mov     cx,[R6809_HSP]
               mov     [R6809_Y],cx
               mov     [R6809_HSP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_24     ENDP



;
; 25 - Y,PC
;
exg6809_25     PROC    near

               mov     dx,[R6809_Y]
               mov     cx,[R6809_PC]
               mov     [R6809_Y],cx
               mov     [R6809_PC],dx
               mov     ax,CPU_FETCH
               ret

exg6809_25     ENDP



;
; 30 - U,D
;
exg6809_30     PROC    near

               mov     dx,[R6809_USP]
               mov     cx,[R6809_D]
               mov     [R6809_USP],cx
               mov     [R6809_D],dx
               mov     ax,CPU_FETCH
               ret

exg6809_30     ENDP



;
; 31 - U,X
;
exg6809_31     PROC    near

               mov     dx,[R6809_USP]
               mov     cx,[R6809_X]
               mov     [R6809_USP],cx
               mov     [R6809_X],dx
               mov     ax,CPU_FETCH
               ret

exg6809_31     ENDP



;
; 32 - U,Y
;
exg6809_32     PROC    near

               mov     dx,[R6809_USP]
               mov     cx,[R6809_Y]
               mov     [R6809_USP],cx
               mov     [R6809_Y],dx
               mov     ax,CPU_FETCH
               ret

exg6809_32     ENDP



;
; 33 - U,U
;
exg6809_33     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_33     ENDP



;
; 34 - U,S
;
exg6809_34     PROC    near

               mov     dx,[R6809_USP]
               mov     cx,[R6809_HSP]
               mov     [R6809_USP],cx
               mov     [R6809_HSP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_34     ENDP



;
; 35 - U,PC
;
exg6809_35     PROC    near

               mov     dx,[R6809_USP]
               mov     cx,[R6809_PC]
               mov     [R6809_USP],cx
               mov     [R6809_PC],dx
               mov     ax,CPU_FETCH
               ret

exg6809_35     ENDP



;
; 40 - S,D
;
exg6809_40     PROC    near

               mov     dx,[R6809_HSP]
               mov     cx,[R6809_D]
               mov     [R6809_HSP],cx
               mov     [R6809_D],dx
               mov     ax,CPU_FETCH
               ret

exg6809_40     ENDP



;
; 41 - S,X
;
exg6809_41     PROC    near

               mov     dx,[R6809_HSP]
               mov     cx,[R6809_X]
               mov     [R6809_HSP],cx
               mov     [R6809_X],dx
               mov     ax,CPU_FETCH
               ret

exg6809_41     ENDP



;
; 42 - S,Y
;
exg6809_42     PROC    near

               mov     dx,[R6809_HSP]
               mov     cx,[R6809_Y]
               mov     [R6809_HSP],cx
               mov     [R6809_Y],dx
               mov     ax,CPU_FETCH
               ret

exg6809_42     ENDP



;
; 43 - S,U
;
exg6809_43     PROC    near

               mov     dx,[R6809_HSP]
               mov     cx,[R6809_USP]
               mov     [R6809_HSP],cx
               mov     [R6809_USP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_43     ENDP



;
; 44 - S,S
;
exg6809_44     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_44     ENDP



;
; 45 - S,PC
;
exg6809_45     PROC    near

               mov     dx,[R6809_HSP]
               mov     cx,[R6809_PC]
               mov     [R6809_HSP],cx
               mov     [R6809_PC],dx
               mov     ax,CPU_FETCH
               ret

exg6809_45     ENDP



;
; 50 - PC,D
;
exg6809_50     PROC    near

               mov     dx,[R6809_PC]
               mov     cx,[R6809_D]
               mov     [R6809_PC],cx
               mov     [R6809_D],dx
               mov     ax,CPU_FETCH
               ret

exg6809_50     ENDP



;
; 51 - PC,X
;
exg6809_51     PROC    near

               mov     dx,[R6809_PC]
               mov     cx,[R6809_X]
               mov     [R6809_PC],cx
               mov     [R6809_X],dx
               mov     ax,CPU_FETCH
               ret

exg6809_51     ENDP



;
; 52 - PC,Y
;
exg6809_52     PROC    near

               mov     dx,[R6809_PC]
               mov     cx,[R6809_Y]
               mov     [R6809_PC],cx
               mov     [R6809_Y],dx
               mov     ax,CPU_FETCH
               ret

exg6809_52     ENDP



;
; 53 - PC,U
;
exg6809_53     PROC    near

               mov     dx,[R6809_PC]
               mov     cx,[R6809_USP]
               mov     [R6809_PC],cx
               mov     [R6809_USP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_53     ENDP



;
; 54 - PC,S
;
exg6809_54     PROC    near

               mov     dx,[R6809_PC]
               mov     cx,[R6809_HSP]
               mov     [R6809_PC],cx
               mov     [R6809_HSP],dx
               mov     ax,CPU_FETCH
               ret

exg6809_54     ENDP



;
; 55 - PC,PC
;
exg6809_55     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_55     ENDP



;
; 88 - A,A
;
exg6809_88     PROC    near

               mov     dl,[R6809_A]
               mov     cl,[R6809_A]
               mov     [R6809_A],cl
               mov     [R6809_A],dl
               mov     ax,CPU_FETCH
               ret

exg6809_88     ENDP



;
; 89 - A,B
;
exg6809_89     PROC    near

               mov     dl,[R6809_A]
               mov     cl,[R6809_B]
               mov     [R6809_A],cl
               mov     [R6809_B],dl
               mov     ax,CPU_FETCH
               ret

exg6809_89     ENDP



;
; 8A - A,CC
;
exg6809_8A     PROC    near

               mov     cl,[R6809_A]
               call    f6809cctodl_
               mov     bl,cl
               mov     cl,dl
               mov     dl,bl
               call    f6809dltocc_
               mov     [R6809_A],cl
               mov     ax,CPU_FETCH
               ret

exg6809_8A     ENDP



;
; 8B - A,DP
;
exg6809_8B     PROC    near

               mov     dl,[R6809_A]
               mov     cl,[R6809_DP]
               mov     [R6809_A],cl
               mov     [R6809_DP],dl
               mov     ax,CPU_FETCH
               ret

exg6809_8B     ENDP




;
; 98 - B,A
;
exg6809_98     PROC    near

               mov     dl,[R6809_B]
               mov     cl,[R6809_A]
               mov     [R6809_B],cl
               mov     [R6809_A],dl
               mov     ax,CPU_FETCH
               ret

exg6809_98     ENDP



;
; 99 - A,B
;
exg6809_99     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_99     ENDP



;
; 9A - B,CC
;
exg6809_9A     PROC    near

               mov     cl,[R6809_B]
               call    f6809cctodl_
               mov     bl,cl
               mov     cl,dl
               mov     dl,bl
               call    f6809dltocc_
               mov     [R6809_B],cl
               mov     ax,CPU_FETCH
               ret

exg6809_9A     ENDP



;
; 9B - B,DP
;
exg6809_9B     PROC    near

               mov     dl,[R6809_B]
               mov     cl,[R6809_DP]
               mov     [R6809_B],cl
               mov     [R6809_DP],dl
               mov     ax,CPU_FETCH
               ret

exg6809_9B     ENDP




;
; A8 - CC,A
;
exg6809_A8     PROC    near

               mov     cl,[R6809_A]
               call    f6809cctodl_
               mov     bl,cl
               mov     cl,dl
               mov     dl,bl
               call    f6809dltocc_
               mov     [R6809_A],cl
               mov     ax,CPU_FETCH
               ret

exg6809_A8     ENDP



;
; A9 - CC,B
;
exg6809_A9     PROC    near

               mov     cl,[R6809_B]
               call    f6809cctodl_
               mov     bl,cl
               mov     cl,dl
               mov     dl,bl
               call    f6809dltocc_
               mov     [R6809_B],cl
               mov     ax,CPU_FETCH
               ret

exg6809_A9     ENDP



;
; AA - CC,CC
;
exg6809_AA     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_AA     ENDP



;
; AB - CC,DP
;
exg6809_AB     PROC    near

               mov     cl,[R6809_DP]
               call    f6809cctodl_
               mov     bl,cl
               mov     cl,dl
               mov     dl,bl
               call    f6809dltocc_
               mov     [R6809_DP],cl
               mov     ax,CPU_FETCH
               ret

exg6809_AB     ENDP




;
; B8 - DP,A
;
exg6809_B8     PROC    near

               mov     dl,[R6809_DP]
               mov     cl,[R6809_A]
               mov     [R6809_DP],cl
               mov     [R6809_A],dl
               mov     ax,CPU_FETCH
               ret

exg6809_B8     ENDP



;
; B9 - DP,B
;
exg6809_B9     PROC    near

               mov     dl,[R6809_DP]
               mov     cl,[R6809_B]
               mov     [R6809_DP],cl
               mov     [R6809_B],dl
               mov     ax,CPU_FETCH
               ret

exg6809_B9     ENDP



;
; BA - DP,CC
;
exg6809_BA     PROC    near

               mov     cl,[R6809_DP]
               call    f6809cctodl_
               mov     bl,cl
               mov     cl,dl
               mov     dl,bl
               call    f6809dltocc_
               mov     [R6809_DP],cl
               mov     ax,CPU_FETCH
               ret

exg6809_BA     ENDP



;
; BB - DP,DP
;
exg6809_BB     PROC    near

               mov     ax,CPU_FETCH
               ret

exg6809_BB     ENDP




_EXG6809_TEXT ends


_EXG6809_DATA segment byte public 'DATA'
              assume  DS:_EXG6809_DATA

_Exg6809JumpTable dd  exg6809_00
                  dd  exg6809_01
                  dd  exg6809_02
                  dd  exg6809_03
                  dd  exg6809_04
                  dd  exg6809_05
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;10
                  dd  exg6809_10
                  dd  exg6809_11
                  dd  exg6809_12
                  dd  exg6809_13
                  dd  exg6809_14
                  dd  exg6809_15
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;20
                  dd  exg6809_20
                  dd  exg6809_21
                  dd  exg6809_22
                  dd  exg6809_23
                  dd  exg6809_24
                  dd  exg6809_25
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;30
                  dd  exg6809_30
                  dd  exg6809_31
                  dd  exg6809_32
                  dd  exg6809_33
                  dd  exg6809_34
                  dd  exg6809_35
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;40
                  dd  exg6809_40
                  dd  exg6809_41
                  dd  exg6809_42
                  dd  exg6809_43
                  dd  exg6809_44
                  dd  exg6809_45
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;50
                  dd  exg6809_50
                  dd  exg6809_51
                  dd  exg6809_52
                  dd  exg6809_53
                  dd  exg6809_54
                  dd  exg6809_55
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;60
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;70
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;80
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_88
                  dd  exg6809_89
                  dd  exg6809_8A
                  dd  exg6809_8B
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;90
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_98
                  dd  exg6809_99
                  dd  exg6809_9A
                  dd  exg6809_9B
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;A0
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_A8
                  dd  exg6809_A9
                  dd  exg6809_AA
                  dd  exg6809_AB
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;B0
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_B8
                  dd  exg6809_B9
                  dd  exg6809_BA
                  dd  exg6809_BB
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;C0
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;D0
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;E0
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
;F0
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX
                  dd  exg6809_EX

public _Exg6809JumpTable



_EXG6809_DATA ends



end

