;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator code INDEX instruction macro base            *
;*                                                                           *
;*   File Name  : IDX6809.ASM                                                *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the function code to execute the fetch  *
;*                of the effective address based on the jump table calls     *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    22/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    06/08/96  K.W  Public release of DVE 1.0                       *
;*                                                                           *
;*****************************************************************************


extern _f6809AddressRead:near
extern _f6809AddressWrite:near
extern _atSystemImage:near
extern _apfWriteHandlers:near
extern _apfReadHandlers:near

include "reg6809.h"
include "mac6809.h"


;
; Define indirection macro
;
m_indir MACRO
  m_fetch16
  mov     bx,dx
ENDM




_IDX6809_TEXT segment dword public 'CODE'
              assume  CS:_IDX6809_TEXT

;
; CPU Exception
;
idx6809_EX     PROC    near

               add     sp,4               ; Remove return address
               mov     ax,CPU_EXCEPTION
               m_exit
               ret

idx6809_EX     ENDP


;
; $00,X
;
idx6809_00     PROC    near
               mov     bx,[R6809_X]
               mov     ax,1            ;Additional cycles
               ret

idx6809_00     ENDP



;
; $01,X
;
idx6809_01     PROC    near
               mov     bx,[R6809_X]
               inc     bx
               mov     ax,1            ;Additional cycles
               ret

idx6809_01     ENDP



;
; $02,X
;
idx6809_02     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_02     ENDP



;
; $03,X
;
idx6809_03     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_03     ENDP



;
; $04,X
;
idx6809_04     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_04     ENDP



;
; $05,X
;
idx6809_05     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x05
               mov     ax,1            ;Additional cycles
               ret

idx6809_05     ENDP



;
; $06,X
;
idx6809_06     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_06     ENDP



;
; $07,X
;
idx6809_07     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_07     ENDP



;
; $08,X
;
idx6809_08     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_08     ENDP



;
; $09,X
;
idx6809_09     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_09     ENDP



;
; $0A,X
;
idx6809_0A     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_0A     ENDP



;
; $0b,X
;
idx6809_0B     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_0B     ENDP



;
; $0c,X
;
idx6809_0C     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_0C     ENDP



;
; $0d,X
;
idx6809_0D     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_0D     ENDP



;
; $0e,X
;
idx6809_0E     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_0E     ENDP



;
; $0f,X
;
idx6809_0F     PROC    near
               mov     bx,[R6809_X]
               add     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_0F     ENDP



;
; ,$-10,X
;
idx6809_10     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x10
               mov     ax,1            ;Additional cycles
               ret

idx6809_10     ENDP



;
; ,$-0f,X
;
idx6809_11     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_11     ENDP



;
; ,$-0e,X
;
idx6809_12     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_12     ENDP



;
; ,$-0d,X
;
idx6809_13     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_13     ENDP



;
; ,$-0c,X
;
idx6809_14     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_14     ENDP



;
; ,$-0b,X
;
idx6809_15     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_15     ENDP



;
; ,$-0a,X
;
idx6809_16     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_16     ENDP



;
; ,$-09,X
;
idx6809_17     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_17     ENDP



;
; ,$-08,X
;
idx6809_18     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_18     ENDP



;
; ,$-07,X
;
idx6809_19     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_19     ENDP



;
; ,$-06,X
;
idx6809_1A     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_1A     ENDP



;
; ,$-05,X
;
idx6809_1B     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x05
               mov     ax,1            ;Additional cycles
               ret

idx6809_1B     ENDP



;
; ,$-04,X
;
idx6809_1C     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_1C     ENDP



;
; ,$-03,X
;
idx6809_1D     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_1D     ENDP



;
; ,$-02,X
;
idx6809_1E     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_1E     ENDP




;
; ,$-01,X
;
idx6809_1F     PROC    near
               mov     bx,[R6809_X]
               sub     bx,0x01
               mov     ax,1            ;Additional cycles
               ret

idx6809_1F     ENDP




;
; $00,Y
;
idx6809_20     PROC    near
               mov     bx,[R6809_Y]
               mov     ax,1            ;Additional cycles
               ret

idx6809_20     ENDP



;
; $01,Y
;
idx6809_21     PROC    near
               mov     bx,[R6809_Y]
               inc     bx
               mov     ax,1            ;Additional cycles
               ret

idx6809_21     ENDP



;
; $02,Y
;
idx6809_22     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_22     ENDP



;
; $03,Y
;
idx6809_23     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_23     ENDP



;
; $04,Y
;
idx6809_24     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_24     ENDP



;
; $05,Y
;
idx6809_25     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x05
               mov     ax,1            ;Additional cycles
               ret

idx6809_25     ENDP



;
; $06,Y
;
idx6809_26     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_26     ENDP



;
; $07,Y
;
idx6809_27     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_27     ENDP



;
; $08,Y
;
idx6809_28     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_28     ENDP



;
; $09,Y
;
idx6809_29     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_29     ENDP



;
; $0a,Y
;
idx6809_2A     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_2A     ENDP



;
; $0b,Y
;
idx6809_2B     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_2B     ENDP



;
; $0c,Y
;
idx6809_2C     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_2C     ENDP



;
; $0d,Y
;
idx6809_2D     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_2D     ENDP



;
; $0e,Y
;
idx6809_2E     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_2E     ENDP



;
; $0f,Y
;
idx6809_2F     PROC    near
               mov     bx,[R6809_Y]
               add     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_2F     ENDP



;
; ,$-10,Y
;
idx6809_30     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x10
               mov     ax,1            ;Additional cycles
               ret

idx6809_30     ENDP



;
; ,$-0f,Y
;
idx6809_31     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_31     ENDP



;
; ,$-0e,Y
;
idx6809_32     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_32     ENDP



;
; ,$-0d,Y
;
idx6809_33     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_33     ENDP



;
; ,$-0c,Y
;
idx6809_34     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_34     ENDP



;
; ,$-0b,Y
;
idx6809_35     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_35     ENDP



;
; ,$-0a,Y
;
idx6809_36     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_36     ENDP



;
; ,$-09,Y
;
idx6809_37     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_37     ENDP



;
; ,$-08,Y
;
idx6809_38     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_38     ENDP



;
; ,$-07,Y
;
idx6809_39     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_39     ENDP



;
; ,$-06,Y
;
idx6809_3A     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_3A     ENDP



;
; ,$-05,Y
;
idx6809_3B     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,05
               mov     ax,1            ;Additional cycles
               ret

idx6809_3B     ENDP



;
; ,$-04,Y
;
idx6809_3C     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_3C     ENDP



;
; ,$-03,Y
;
idx6809_3D     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_3D     ENDP



;
; ,$-02,Y
;
idx6809_3E     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_3E     ENDP




;
; ,$-01,Y
;
idx6809_3F     PROC    near
               mov     bx,[R6809_Y]
               sub     bx,0x01
               mov     ax,1            ;Additional cycles
               ret

idx6809_3F     ENDP




;
; ,$00,U
;
idx6809_40     PROC    near
               mov     bx,[R6809_USP]
               mov     ax,1            ;Additional cycles
               ret

idx6809_40     ENDP



;
; ,$01,U
;
idx6809_41     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x01
               mov     ax,1            ;Additional cycles
               ret

idx6809_41     ENDP



;
; ,$02,U
;
idx6809_42     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_42     ENDP



;
; ,$03,U
;
idx6809_43     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_43     ENDP



;
; ,$04,U
;
idx6809_44     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_44     ENDP




;
; ,$05,U
;
idx6809_45     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x05
               mov     ax,1            ;Additional cycles
               ret

idx6809_45     ENDP




;
; ,$06,U
;
idx6809_46     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_46     ENDP




;
; ,$07,U
;
idx6809_47     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_47     ENDP




;
; ,$08,U
;
idx6809_48     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_48     ENDP




;
; ,$09,U
;
idx6809_49     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_49     ENDP




;
; ,$0A,U
;
idx6809_4A     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_4A     ENDP




;
; ,$0B,U
;
idx6809_4B     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_4B     ENDP




;
; ,$0c,U
;
idx6809_4C     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_4C     ENDP



;
; ,$0d,U
;
idx6809_4D     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_4D     ENDP



;
; ,$0e,U
;
idx6809_4E     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_4E     ENDP



;
; ,$0f,U
;
idx6809_4F     PROC    near
               mov     bx,[R6809_USP]
               add     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_4F     ENDP



;
; ,$-10,U
;
idx6809_50     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x10
               mov     ax,1            ;Additional cycles
               ret

idx6809_50     ENDP



;
; ,$-0f,U
;
idx6809_51     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_51     ENDP



;
; ,$-0e,U
;
idx6809_52     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_52     ENDP



;
; ,$-0d,U
;
idx6809_53     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_53     ENDP



;
; ,$-0c,U
;
idx6809_54     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_54     ENDP



;
; ,$-0b,U
;
idx6809_55     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_55     ENDP



;
; ,$-0a,U
;
idx6809_56     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_56     ENDP



;
; ,$-09,U
;
idx6809_57     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_57     ENDP



;
; ,$-08,U
;
idx6809_58     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_58     ENDP



;
; ,$-07,U
;
idx6809_59     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_59     ENDP



;
; ,$-06,U
;
idx6809_5A     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_5A     ENDP



;
; ,$-05,U
;
idx6809_5B     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x05
               mov     ax,1            ;Additional cycles
               ret

idx6809_5B     ENDP



;
; ,$-04,U
;
idx6809_5C     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_5C     ENDP



;
; ,$-03,U
;
idx6809_5D     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_5D     ENDP



;
; ,$-02,U
;
idx6809_5E     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_5E     ENDP




;
; ,$-01,U
;
idx6809_5F     PROC    near
               mov     bx,[R6809_USP]
               sub     bx,0x01
               mov     ax,1            ;Additional cycles
               ret

idx6809_5F     ENDP




;
; ,$0,S
;
idx6809_60     PROC    near
               mov     bx,[R6809_HSP]
               mov     ax,1            ;Additional cycles
               ret

idx6809_60     ENDP



;
; ,$01,S
;
idx6809_61     PROC    near
               mov     bx,[R6809_HSP]
               inc     bx
               mov     ax,1            ;Additional cycles
               ret

idx6809_61     ENDP



;
; ,$02,S
;
idx6809_62     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_62     ENDP



;
; ,$03,S
;
idx6809_63     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_63     ENDP



;
; ,$04,S
;
idx6809_64     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_64     ENDP



;
; ,$05,S
;
idx6809_65     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x05
               mov     ax,1            ;Additional cycles
               ret

idx6809_65     ENDP



;
; ,$06,S
;
idx6809_66     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_66     ENDP



;
; ,$07,S
;
idx6809_67     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_67     ENDP



;
; ,$08,S
;
idx6809_68     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_68     ENDP



;
; ,$09,S
;
idx6809_69     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_69     ENDP



;
; ,$0A,S
;
idx6809_6A     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_6A     ENDP



;
; ,$0b,S
;
idx6809_6B     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_6B     ENDP



;
; ,$0c,S
;
idx6809_6C     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_6C     ENDP



;
; ,$0d,S
;
idx6809_6D     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_6D     ENDP



;
; ,$0e,S
;
idx6809_6E     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_6E     ENDP



;
; ,$0f,S
;
idx6809_6F     PROC    near
               mov     bx,[R6809_HSP]
               add     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_6F     ENDP



;
; ,$-10,S
;
idx6809_70     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x10
               mov     ax,1            ;Additional cycles
               ret

idx6809_70     ENDP



;
; ,$-0f,S
;
idx6809_71     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x0f
               mov     ax,1            ;Additional cycles
               ret

idx6809_71     ENDP



;
; ,$-0e,S
;
idx6809_72     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x0e
               mov     ax,1            ;Additional cycles
               ret

idx6809_72     ENDP



;
; ,$-0d,S
;
idx6809_73     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x0d
               mov     ax,1            ;Additional cycles
               ret

idx6809_73     ENDP



;
; ,$-0c,S
;
idx6809_74     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x0c
               mov     ax,1            ;Additional cycles
               ret

idx6809_74     ENDP



;
; ,$-0b,S
;
idx6809_75     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x0b
               mov     ax,1            ;Additional cycles
               ret

idx6809_75     ENDP



;
; ,$-0a,S
;
idx6809_76     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x0a
               mov     ax,1            ;Additional cycles
               ret

idx6809_76     ENDP



;
; ,$-09,S
;
idx6809_77     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x09
               mov     ax,1            ;Additional cycles
               ret

idx6809_77     ENDP



;
; ,$-08,S
;
idx6809_78     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x08
               mov     ax,1            ;Additional cycles
               ret

idx6809_78     ENDP



;
; ,$-07,S
;
idx6809_79     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x07
               mov     ax,1            ;Additional cycles
               ret

idx6809_79     ENDP



;
; ,$-06,S
;
idx6809_7A     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x06
               mov     ax,1            ;Additional cycles
               ret

idx6809_7A     ENDP



;
; ,$-05,S
;
idx6809_7B     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x05
               mov     ax,1            ;Additional cycles
               ret

idx6809_7B     ENDP



;
; ,$-04,S
;
idx6809_7C     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x04
               mov     ax,1            ;Additional cycles
               ret

idx6809_7C     ENDP



;
; ,$-03,S
;
idx6809_7D     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x03
               mov     ax,1            ;Additional cycles
               ret

idx6809_7D     ENDP



;
; ,$-02,S
;
idx6809_7E     PROC    near
               mov     bx,[R6809_HSP]
               sub     bx,0x02
               mov     ax,1            ;Additional cycles
               ret

idx6809_7E     ENDP



;
; ,-01,S
;
idx6809_7F     PROC    near
               mov     bx,[R6809_HSP]
               dec     bx
               mov     ax,1            ;Additional cycles
               ret

idx6809_7F     ENDP



;
; ,X+
;
idx6809_80     PROC    near

               mov     bx,[R6809_X]
               add     WORD [R6809_X],1
               mov     ax,2            ;Additional cycles
               ret

idx6809_80     ENDP



;
; ,X++
;
idx6809_81     PROC    near

               mov     bx,[R6809_X]
               add     WORD [R6809_X],2
               mov     ax,3            ;Additional cycles
               ret

idx6809_81     ENDP



;
; ,-X
;
idx6809_82     PROC    near

               sub     WORD [R6809_X],1
               mov     bx,[R6809_X]
               mov     ax,2            ;Additional cycles
               ret

idx6809_82     ENDP



;
; ,--X
;
idx6809_83     PROC    near

               sub     WORD [R6809_X],2
               mov     bx,[R6809_X]
               mov     ax,3            ;Additional cycles
               ret

idx6809_83     ENDP



;
; ,X
;
idx6809_84     PROC    near

               mov     bx,[R6809_X]
               mov     ax,0            ;Additional cycles
               ret

idx6809_84     ENDP




;
; B,X
;
idx6809_85     PROC    near

               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_X]
               mov     ax,1            ;Additional cycles
               ret

idx6809_85     ENDP




;
; A,X
;
idx6809_86     PROC    near

               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_X]
               mov     ax,1            ;Additional cycles
               ret

idx6809_86     ENDP




;
; $??,X (8bit offset)
;
idx6809_88     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_X]
               mov     ax,1
               ret

idx6809_88     ENDP



;
; $????,X (16bit offset)
;
idx6809_89     PROC    near

               m_imm16
               add     bx,[R6809_X]
               mov     ax,4
               ret

idx6809_89     ENDP



;
; D,X
;
idx6809_8B     PROC    near

               mov     bx,[R6809_X]
               add     bx,[R6809_D]
               mov     ax,4            ;Additional cycles
               ret

idx6809_8B     ENDP



;
; $??,PC (8bit signed offset)
;
idx6809_8C     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               mov     ax,1
               ret

idx6809_8C     ENDP



;
; $????,PC (16bit signed offset)
;
idx6809_8D     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               mov     ax,4
               ret

idx6809_8D     ENDP



;
; [,X++]
;
idx6809_91     PROC    near

               mov     bx,[R6809_X]
               add     WORD [R6809_X],2
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_91     ENDP



;
; [,--X]
;
idx6809_93     PROC    near

               sub     WORD [R6809_X],2
               mov     bx,[R6809_X]
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_93     ENDP



;
; [,X]
;
idx6809_94     PROC    near

               mov     bx,[R6809_X]
               m_indir
               mov     ax,3            ;Additional cycles
               ret

idx6809_94     ENDP




;
; [B,X]
;
idx6809_95     PROC    near

               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_X]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_95     ENDP




;
; [A,X]
;
idx6809_96     PROC    near

               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_X]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_96     ENDP




;
; [$??,X] (8bit offset)
;
idx6809_98     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_X]
               m_indir
               mov     ax,4
               ret

idx6809_98     ENDP



;
; [$????,X] (16bit offset)
;
idx6809_99     PROC    near

               m_imm16
               add     bx,[R6809_X]
               m_indir
               mov     ax,7
               ret

idx6809_99     ENDP



;
; [D,X]
;
idx6809_9B     PROC    near

               mov     bx,[R6809_X]
               add     bx,[R6809_D]
               m_indir
               mov     ax,7            ;Additional cycles
               ret

idx6809_9B     ENDP



;
; [$??,PC] (8bit signed offset)
;
idx6809_9C     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               m_indir
               mov     ax,4
               ret

idx6809_9C     ENDP



;
; [$????,PC] (16bit signed offset)
;
idx6809_9D     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               m_indir
               mov     ax,8
               ret

idx6809_9D     ENDP



;
; [$NNNN]
;
idx6809_9F     PROC    near

               mov     bx,[R6809_PC]       ; Fetch PC
               add     word [R6809_PC],2
               m_fetch16
               mov     bx,dx
               m_indir

               mov     ax,5
               ret

idx6809_9F     ENDP



;
; ,Y+
;
idx6809_A0     PROC    near

               mov     bx,[R6809_Y]
               add     WORD [R6809_Y],1
               mov     ax,2
               ret

idx6809_A0     ENDP



;
; ,Y++
;
idx6809_A1     PROC    near

               mov     bx,[R6809_Y]
               add     WORD [R6809_Y],2
               mov     ax,3
               ret

idx6809_A1     ENDP



;
; ,-Y
;
idx6809_A2     PROC    near

               sub     WORD [R6809_Y],1
               mov     bx,[R6809_Y]
               mov     ax,2            ;Additional cycles
               ret

idx6809_A2     ENDP



;
; ,--Y
;
idx6809_A3     PROC    near

               sub     WORD [R6809_Y],2
               mov     bx,[R6809_Y]
               mov     ax,3            ;Additional cycles
               ret

idx6809_A3     ENDP



;
; ,Y
;
idx6809_A4     PROC    near
               mov     bx,[R6809_Y]
               mov     ax,1            ;Additional cycles
               ret

idx6809_A4     ENDP



;
; B,Y
;
idx6809_A5     PROC    near
               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_Y]
               mov     ax,1            ;Additional cycles
               ret

idx6809_A5     ENDP



;
; A,Y
;
idx6809_A6     PROC    near
               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_Y]
               mov     ax,1            ;Additional cycles
               ret

idx6809_A6     ENDP



;
; $??,Y (8bit offset)
;
idx6809_A8     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_Y]
               mov     ax,1
               ret

idx6809_A8     ENDP



;
; $????,Y (16bit offset)
;
idx6809_A9     PROC    near

               m_imm16
               add     bx,[R6809_Y]
               mov     ax,4
               ret

idx6809_A9     ENDP



;
; D,Y
;
idx6809_AB     PROC    near

               mov     bx,[R6809_Y]
               add     bx,[R6809_D]
               mov     ax,4            ;Additional cycles
               ret

idx6809_AB     ENDP



;
; $??,PC (8bit signed offset)
;
idx6809_AC     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               mov     ax,1
               ret

idx6809_AC     ENDP



;
; $????,PC (16bit signed offset)
;
idx6809_AD     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               mov     ax,4
               ret

idx6809_AD     ENDP



;
; [,Y++]
;
idx6809_B1     PROC    near

               mov     bx,[R6809_Y]
               add     WORD [R6809_Y],2
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_B1     ENDP



;
; [,--Y]
;
idx6809_B3     PROC    near

               sub     WORD [R6809_Y],2
               mov     bx,[R6809_Y]
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_B3     ENDP



;
; [,Y]
;
idx6809_B4     PROC    near

               mov     bx,[R6809_Y]
               m_indir
               mov     ax,3            ;Additional cycles
               ret

idx6809_B4     ENDP




;
; [B,Y]
;
idx6809_B5     PROC    near

               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_Y]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_B5     ENDP




;
; [A,Y]
;
idx6809_B6     PROC    near

               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_Y]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_B6     ENDP




;
; [$??,Y] (8bit offset)
;
idx6809_B8     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_Y]
               m_indir
               mov     ax,4
               ret

idx6809_B8     ENDP



;
; [$????,Y] (16bit offset)
;
idx6809_B9     PROC    near

               m_imm16
               add     bx,[R6809_Y]
               m_indir
               mov     ax,7
               ret

idx6809_B9     ENDP



;
; [D,Y]
;
idx6809_BB     PROC    near

               mov     bx,[R6809_Y]
               add     bx,[R6809_D]
               m_indir
               mov     ax,7            ;Additional cycles
               ret

idx6809_BB     ENDP



;
; [$??,PC] (8bit signed offset)
;
idx6809_BC     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               m_indir
               mov     ax,4
               ret

idx6809_BC     ENDP



;
; [$????,PC] (16bit signed offset)
;
idx6809_BD     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               m_indir
               mov     ax,8
               ret

idx6809_BD     ENDP



;
; ,U+
;
idx6809_C0     PROC    near

               mov     bx,[R6809_USP]
               inc     WORD [R6809_USP]
               mov     ax,2
               ret

idx6809_C0     ENDP



;
; ,U++
;
idx6809_C1     PROC    near

               mov     bx,[R6809_USP]
               add     WORD [R6809_USP],2
               mov     ax,3
               ret

idx6809_C1     ENDP



;
; ,-U
;
idx6809_C2     PROC    near

               sub     WORD [R6809_USP],1
               mov     bx,[R6809_USP]
               mov     ax,2            ;Additional cycles
               ret

idx6809_C2     ENDP



;
; ,--U
;
idx6809_C3     PROC    near

               sub     WORD [R6809_USP],2
               mov     bx,[R6809_USP]
               mov     ax,3
               ret

idx6809_C3     ENDP



;
; ,U
;
idx6809_C4     PROC    near

               mov     bx,[R6809_USP]
               mov     ax,2
               ret

idx6809_C4     ENDP



;
; B,U
;
idx6809_C5     PROC    near

               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_USP]
               mov     ax,1            ;Additional cycles
               ret

idx6809_C5     ENDP



;
; A,U
;
idx6809_C6     PROC    near

               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_USP]
               mov     ax,1            ;Additional cycles
               ret

idx6809_C6     ENDP



;
; $??,U (8bit offset)
;
idx6809_C8     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_USP]
               mov     ax,1
               ret

idx6809_C8     ENDP



;
; $????,U (16bit offset)
;
idx6809_C9     PROC    near

               m_imm16
               add     bx,[R6809_USP]
               mov     ax,4
               ret

idx6809_C9     ENDP



;
; D,U
;
idx6809_CB     PROC    near

               mov     bx,[R6809_USP]
               add     bx,[R6809_D]
               mov     ax,4            ;Additional cycles
               ret

idx6809_CB     ENDP



;
; $??,PC (8bit signed offset)
;
idx6809_CC     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               mov     ax,1
               ret

idx6809_CC     ENDP



;
; $????,PC (16bit signed offset)
;
idx6809_CD     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               mov     ax,4
               ret

idx6809_CD     ENDP



;
; [,U++]
;
idx6809_D1     PROC    near

               mov     bx,[R6809_USP]
               add     WORD [R6809_USP],2
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_D1     ENDP



;
; [,--U]
;
idx6809_D3     PROC    near

               sub     WORD [R6809_USP],2
               mov     bx,[R6809_USP]
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_D3     ENDP



;
; [,U]
;
idx6809_D4     PROC    near

               mov     bx,[R6809_USP]
               m_indir
               mov     ax,3            ;Additional cycles
               ret

idx6809_D4     ENDP




;
; [B,U]
;
idx6809_D5     PROC    near

               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_USP]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_D5     ENDP




;
; [A,U]
;
idx6809_D6     PROC    near

               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_USP]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_D6     ENDP




;
; [$??,U] (8bit offset)
;
idx6809_D8     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_USP]
               m_indir
               mov     ax,4
               ret

idx6809_D8     ENDP



;
; [$????,U] (16bit offset)
;
idx6809_D9     PROC    near

               m_imm16
               add     bx,[R6809_USP]
               m_indir
               mov     ax,7
               ret

idx6809_D9     ENDP



;
; [D,U]
;
idx6809_DB     PROC    near

               mov     bx,[R6809_USP]
               add     bx,[R6809_D]
               m_indir
               mov     ax,7            ;Additional cycles
               ret

idx6809_DB     ENDP



;
; [$??,PC] (8bit signed offset)
;
idx6809_DC     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               m_indir
               mov     ax,4
               ret

idx6809_DC     ENDP



;
; [$????,PC] (16bit signed offset)
;
idx6809_DD     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               m_indir
               mov     ax,8
               ret

idx6809_DD     ENDP



;
; ,S+
;
idx6809_E0     PROC    near

               mov     bx,[R6809_HSP]
               add     WORD [R6809_HSP],1
               mov     ax,2            ;Additional cycles
               ret

idx6809_E0     ENDP



;
; ,S++
;
idx6809_E1     PROC    near

               mov     bx,[R6809_HSP]
               add     WORD [R6809_HSP],2
               mov     ax,3
               ret

idx6809_E1     ENDP



;
; ,-S
;
idx6809_E2     PROC    near

               sub     WORD [R6809_HSP],1
               mov     bx,[R6809_HSP]
               mov     ax,2            ;Additional cycles
               ret

idx6809_E2     ENDP



;
; ,--S
;
idx6809_E3     PROC    near

               sub     WORD [R6809_HSP],2
               mov     bx,[R6809_HSP]
               mov     ax,3
               ret

idx6809_E3     ENDP



;
; ,S
;
idx6809_E4     PROC    near

               mov     bx,[R6809_HSP]
               mov     ax,2
               ret

idx6809_E4     ENDP



;
; B,S
;
idx6809_E5     PROC    near

               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_HSP]
               mov     ax,1            ;Additional cycles
               ret

idx6809_E5     ENDP



;
; A,S
;
idx6809_E6     PROC    near

               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_HSP]
               mov     ax,1            ;Additional cycles
               ret

idx6809_E6     ENDP



;
; $??,S (8bit offset)
;
idx6809_E8     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_HSP]
               mov     ax,1
               ret

idx6809_E8     ENDP



;
; $????,S (16bit offset)
;
idx6809_E9     PROC    near

               m_imm16
               add     bx,[R6809_HSP]
               mov     ax,4
               ret

idx6809_E9     ENDP



;
; D,S
;
idx6809_EB     PROC    near

               mov     bx,[R6809_HSP]
               add     bx,[R6809_D]
               mov     ax,4            ;Additional cycles
               ret

idx6809_EB     ENDP



;
; $??,PC (8bit signed offset)
;
idx6809_EC     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               mov     ax,1
               ret

idx6809_EC     ENDP



;
; $????,PC (16bit signed offset)
;
idx6809_ED     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               mov     ax,4
               ret

idx6809_ED     ENDP




;
; [,S++]
;
idx6809_F1     PROC    near

               mov     bx,[R6809_HSP]
               add     WORD [R6809_HSP],2
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_F1     ENDP



;
; [,--S]
;
idx6809_F3     PROC    near

               sub     WORD [R6809_HSP],2
               mov     bx,[R6809_HSP]
               m_indir
               mov     ax,6            ;Additional cycles
               ret

idx6809_F3     ENDP



;
; [,S]
;
idx6809_F4     PROC    near

               mov     bx,[R6809_HSP]
               m_indir
               mov     ax,3            ;Additional cycles
               ret

idx6809_F4     ENDP




;
; [B,S]
;
idx6809_F5     PROC    near

               mov     bl,[R6809_B]
               movsx   bx,bl
               add     bx,[R6809_HSP]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_F5     ENDP




;
; [A,S]
;
idx6809_F6     PROC    near

               mov     bl,[R6809_A]
               movsx   bx,bl
               add     bx,[R6809_HSP]
               m_indir
               mov     ax,4            ;Additional cycles
               ret

idx6809_F6     ENDP




;
; [$??,S] (8bit offset)
;
idx6809_F8     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_HSP]
               m_indir
               mov     ax,4
               ret

idx6809_F8     ENDP



;
; [$????,S] (16bit offset)
;
idx6809_F9     PROC    near

               m_imm16
               add     bx,[R6809_HSP]
               m_indir
               mov     ax,7
               ret

idx6809_F9     ENDP



;
; [D,S]
;
idx6809_FB     PROC    near

               mov     bx,[R6809_HSP]
               add     bx,[R6809_D]
               m_indir
               mov     ax,7            ;Additional cycles
               ret

idx6809_FB     ENDP



;
; [$??,PC] (8bit signed offset)
;
idx6809_FC     PROC    near

               m_imm08
               movsx   bx,bl
               add     bx,[R6809_PC]
               m_indir
               mov     ax,4
               ret

idx6809_FC     ENDP



;
; [$????,PC] (16bit signed offset)
;
idx6809_FD     PROC    near

               m_imm16
               add     bx,[R6809_PC]
               m_indir
               mov     ax,8
               ret

idx6809_FD     ENDP







_IDX6809_TEXT  ends


_IDX6809_DATA  segment byte public 'DATA'
               assume  DS:_IDX6809_DATA

_Idx6809JumpTable dd  idx6809_00
                  dd  idx6809_01
                  dd  idx6809_02
                  dd  idx6809_03
                  dd  idx6809_04
                  dd  idx6809_05
                  dd  idx6809_06
                  dd  idx6809_07
                  dd  idx6809_08
                  dd  idx6809_09
                  dd  idx6809_0A
                  dd  idx6809_0B
                  dd  idx6809_0C
                  dd  idx6809_0D
                  dd  idx6809_0E
                  dd  idx6809_0F
;10
                  dd  idx6809_10
                  dd  idx6809_11
                  dd  idx6809_12
                  dd  idx6809_13
                  dd  idx6809_14
                  dd  idx6809_15
                  dd  idx6809_16
                  dd  idx6809_17
                  dd  idx6809_18
                  dd  idx6809_19
                  dd  idx6809_1A
                  dd  idx6809_1B
                  dd  idx6809_1C
                  dd  idx6809_1D
                  dd  idx6809_1E
                  dd  idx6809_1F
;20
                  dd  idx6809_20
                  dd  idx6809_21
                  dd  idx6809_22
                  dd  idx6809_23
                  dd  idx6809_24
                  dd  idx6809_25
                  dd  idx6809_26
                  dd  idx6809_27
                  dd  idx6809_28
                  dd  idx6809_29
                  dd  idx6809_2A
                  dd  idx6809_2B
                  dd  idx6809_2C
                  dd  idx6809_2D
                  dd  idx6809_2E
                  dd  idx6809_2F
;30
                  dd  idx6809_30
                  dd  idx6809_31
                  dd  idx6809_32
                  dd  idx6809_33
                  dd  idx6809_34
                  dd  idx6809_35
                  dd  idx6809_36
                  dd  idx6809_37
                  dd  idx6809_38
                  dd  idx6809_39
                  dd  idx6809_3A
                  dd  idx6809_3B
                  dd  idx6809_3C
                  dd  idx6809_3D
                  dd  idx6809_3E
                  dd  idx6809_3F
;40
                  dd  idx6809_40
                  dd  idx6809_41
                  dd  idx6809_42
                  dd  idx6809_43
                  dd  idx6809_44
                  dd  idx6809_45
                  dd  idx6809_46
                  dd  idx6809_47
                  dd  idx6809_48
                  dd  idx6809_49
                  dd  idx6809_4A
                  dd  idx6809_4B
                  dd  idx6809_4C
                  dd  idx6809_4D
                  dd  idx6809_4E
                  dd  idx6809_4F
;50
                  dd  idx6809_50
                  dd  idx6809_51
                  dd  idx6809_52
                  dd  idx6809_53
                  dd  idx6809_54
                  dd  idx6809_55
                  dd  idx6809_56
                  dd  idx6809_57
                  dd  idx6809_58
                  dd  idx6809_59
                  dd  idx6809_5A
                  dd  idx6809_5B
                  dd  idx6809_5C
                  dd  idx6809_5D
                  dd  idx6809_5E
                  dd  idx6809_5F
;60
                  dd  idx6809_60
                  dd  idx6809_61
                  dd  idx6809_62
                  dd  idx6809_63
                  dd  idx6809_64
                  dd  idx6809_65
                  dd  idx6809_66
                  dd  idx6809_67
                  dd  idx6809_68
                  dd  idx6809_69
                  dd  idx6809_6A
                  dd  idx6809_6B
                  dd  idx6809_6C
                  dd  idx6809_6D
                  dd  idx6809_6E
                  dd  idx6809_6F
;70
                  dd  idx6809_70
                  dd  idx6809_71
                  dd  idx6809_72
                  dd  idx6809_73
                  dd  idx6809_74
                  dd  idx6809_75
                  dd  idx6809_76
                  dd  idx6809_77
                  dd  idx6809_78
                  dd  idx6809_79
                  dd  idx6809_7A
                  dd  idx6809_7B
                  dd  idx6809_7C
                  dd  idx6809_7D
                  dd  idx6809_7E
                  dd  idx6809_7F
;80
                  dd  idx6809_80
                  dd  idx6809_81
                  dd  idx6809_82
                  dd  idx6809_83
                  dd  idx6809_84
                  dd  idx6809_85
                  dd  idx6809_86
                  dd  idx6809_EX
                  dd  idx6809_88
                  dd  idx6809_89
                  dd  idx6809_EX
                  dd  idx6809_8B
                  dd  idx6809_8C
                  dd  idx6809_8D
                  dd  idx6809_EX
                  dd  idx6809_EX
;90
                  dd  idx6809_EX
                  dd  idx6809_91
                  dd  idx6809_EX
                  dd  idx6809_93
                  dd  idx6809_94
                  dd  idx6809_95
                  dd  idx6809_96
                  dd  idx6809_EX
                  dd  idx6809_98
                  dd  idx6809_99
                  dd  idx6809_EX
                  dd  idx6809_9B
                  dd  idx6809_9C
                  dd  idx6809_9D
                  dd  idx6809_EX
                  dd  idx6809_9F
;A0
                  dd  idx6809_A0
                  dd  idx6809_A1
                  dd  idx6809_A2
                  dd  idx6809_A3
                  dd  idx6809_A4
                  dd  idx6809_A5
                  dd  idx6809_A6
                  dd  idx6809_EX
                  dd  idx6809_A8
                  dd  idx6809_A9
                  dd  idx6809_EX
                  dd  idx6809_AB
                  dd  idx6809_AC
                  dd  idx6809_AD
                  dd  idx6809_EX
                  dd  idx6809_EX
;B0
                  dd  idx6809_EX
                  dd  idx6809_B1
                  dd  idx6809_EX
                  dd  idx6809_B3
                  dd  idx6809_B4
                  dd  idx6809_B5
                  dd  idx6809_B6
                  dd  idx6809_EX
                  dd  idx6809_B8
                  dd  idx6809_B9
                  dd  idx6809_EX
                  dd  idx6809_BB
                  dd  idx6809_BC
                  dd  idx6809_BD
                  dd  idx6809_EX
                  dd  idx6809_EX
;C0
                  dd  idx6809_C0
                  dd  idx6809_C1
                  dd  idx6809_C2
                  dd  idx6809_C3
                  dd  idx6809_C4
                  dd  idx6809_C5
                  dd  idx6809_C6
                  dd  idx6809_EX
                  dd  idx6809_C8
                  dd  idx6809_C9
                  dd  idx6809_EX
                  dd  idx6809_CB
                  dd  idx6809_CC
                  dd  idx6809_CD
                  dd  idx6809_EX
                  dd  idx6809_EX
;D0
                  dd  idx6809_EX
                  dd  idx6809_D1
                  dd  idx6809_EX
                  dd  idx6809_D3
                  dd  idx6809_D4
                  dd  idx6809_D5
                  dd  idx6809_D6
                  dd  idx6809_EX
                  dd  idx6809_D8
                  dd  idx6809_D9
                  dd  idx6809_EX
                  dd  idx6809_DB
                  dd  idx6809_DC
                  dd  idx6809_DD
                  dd  idx6809_EX
                  dd  idx6809_EX
;E0
                  dd  idx6809_E0
                  dd  idx6809_E1
                  dd  idx6809_E2
                  dd  idx6809_E3
                  dd  idx6809_E4
                  dd  idx6809_E5
                  dd  idx6809_E6
                  dd  idx6809_EX
                  dd  idx6809_E8
                  dd  idx6809_E9
                  dd  idx6809_EX
                  dd  idx6809_EB
                  dd  idx6809_EC
                  dd  idx6809_ED
                  dd  idx6809_EX
                  dd  idx6809_EX
;F0
                  dd  idx6809_EX
                  dd  idx6809_F1
                  dd  idx6809_EX
                  dd  idx6809_F3
                  dd  idx6809_F4
                  dd  idx6809_F5
                  dd  idx6809_F6
                  dd  idx6809_EX
                  dd  idx6809_F8
                  dd  idx6809_F9
                  dd  idx6809_EX
                  dd  idx6809_FB
                  dd  idx6809_FC
                  dd  idx6809_FD
                  dd  idx6809_EX
                  dd  idx6809_EX

public _Idx6809JumpTable



_IDX6809_DATA ends



end


