/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : 6809 Emulator code table of emulation functions            */
/*                                                                           */
/*   File Name  : INS6809.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the table of functions called during 9  */
/*                emulation of the 6809.                                     */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    02/07/95  K.W  Creation of empty stub file, description only   */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/
T_UWORD fIllegalInstruction(T_VOID)
{
 fDebug(VERROR,("f6809Tick() - Illegal instruction decode, should have been caught by count"));
 return(CPU_EXCEPTION);
}

const T_UWORD(*apfExecuteInstruction[0x300])(T_VOID)=
{
   f6809_P1_00,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P1_03,
   f6809_P1_04,
   fIllegalInstruction,
   f6809_P1_06,
   f6809_P1_07,
   f6809_P1_08,
   f6809_P1_09,
   f6809_P1_0A,
   fIllegalInstruction,
   f6809_P1_0C,
   f6809_P1_0D,
   f6809_P1_0E,
   f6809_P1_0F,

   f6809_P1_10,
   f6809_P1_11,
   f6809_P1_12,
   f6809_P1_13,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P1_16,
   f6809_P1_17,
   fIllegalInstruction,
   f6809_P1_19,
   f6809_P1_1A,
   fIllegalInstruction,
   f6809_P1_1C,
   f6809_P1_1D,
   f6809_P1_1E,
   f6809_P1_1F,

   f6809_P1_20,
   f6809_P1_21,
   f6809_P1_22,
   f6809_P1_23,
   f6809_P1_24,
   f6809_P1_25,
   f6809_P1_26,
   f6809_P1_27,
   f6809_P1_28,
   f6809_P1_29,
   f6809_P1_2A,
   f6809_P1_2B,
   f6809_P1_2C,
   f6809_P1_2D,
   f6809_P1_2E,
   f6809_P1_2F,

   f6809_P1_30,
   f6809_P1_31,
   f6809_P1_32,
   f6809_P1_33,
   f6809_P1_34,
   f6809_P1_35,
   f6809_P1_36,
   f6809_P1_37,
   fIllegalInstruction,
   f6809_P1_39,
   f6809_P1_3A,
   f6809_P1_3B,
   f6809_P1_3C,
   f6809_P1_3D,
   fIllegalInstruction,
   f6809_P1_3F,

   f6809_P1_40,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P1_43,
   f6809_P1_44,
   fIllegalInstruction,
   f6809_P1_46,
   f6809_P1_47,
   f6809_P1_48,
   f6809_P1_49,
   f6809_P1_4A,
   fIllegalInstruction,
   f6809_P1_4C,
   f6809_P1_4D,
   fIllegalInstruction,
   f6809_P1_4F,

   f6809_P1_50,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P1_53,
   f6809_P1_54,
   fIllegalInstruction,
   f6809_P1_56,
   f6809_P1_57,
   f6809_P1_58,
   f6809_P1_59,
   f6809_P1_5A,
   fIllegalInstruction,
   f6809_P1_5C,
   f6809_P1_5D,
   fIllegalInstruction,
   f6809_P1_5F,

   f6809_P1_60,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P1_63,
   f6809_P1_64,
   fIllegalInstruction,
   f6809_P1_66,
   f6809_P1_67,
   f6809_P1_68,
   f6809_P1_69,
   f6809_P1_6A,
   fIllegalInstruction,
   f6809_P1_6C,
   f6809_P1_6D,
   f6809_P1_6E,
   f6809_P1_6F,

   f6809_P1_70,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P1_73,
   f6809_P1_74,
   fIllegalInstruction,
   f6809_P1_76,
   f6809_P1_77,
   f6809_P1_78,
   f6809_P1_79,
   f6809_P1_7A,
   fIllegalInstruction,
   f6809_P1_7C,
   f6809_P1_7D,
   f6809_P1_7E,
   f6809_P1_7F,

   f6809_P1_80,
   f6809_P1_81,
   f6809_P1_82,
   f6809_P1_83,
   f6809_P1_84,
   f6809_P1_85,
   f6809_P1_86,
   fIllegalInstruction,
   f6809_P1_88,
   f6809_P1_89,
   f6809_P1_8A,
   f6809_P1_8B,
   f6809_P1_8C,
   f6809_P1_8D,
   f6809_P1_8E,
   fIllegalInstruction,

   f6809_P1_90,
   f6809_P1_91,
   f6809_P1_92,
   f6809_P1_93,
   f6809_P1_94,
   f6809_P1_95,
   f6809_P1_96,
   f6809_P1_97,
   f6809_P1_98,
   f6809_P1_99,
   f6809_P1_9A,
   f6809_P1_9B,
   f6809_P1_9C,
   f6809_P1_9D,
   f6809_P1_9E,
   f6809_P1_9F,

   f6809_P1_A0,
   f6809_P1_A1,
   f6809_P1_A2,
   f6809_P1_A3,
   f6809_P1_A4,
   f6809_P1_A5,
   f6809_P1_A6,
   f6809_P1_A7,
   f6809_P1_A8,
   f6809_P1_A9,
   f6809_P1_AA,
   f6809_P1_AB,
   f6809_P1_AC,
   f6809_P1_AD,
   f6809_P1_AE,
   f6809_P1_AF,

   f6809_P1_B0,
   f6809_P1_B1,
   f6809_P1_B2,
   f6809_P1_B3,
   f6809_P1_B4,
   f6809_P1_B5,
   f6809_P1_B6,
   f6809_P1_B7,
   f6809_P1_B8,
   f6809_P1_B9,
   f6809_P1_BA,
   f6809_P1_BB,
   f6809_P1_BC,
   f6809_P1_BD,
   f6809_P1_BE,
   f6809_P1_BF,

   f6809_P1_C0,
   f6809_P1_C1,
   f6809_P1_C2,
   f6809_P1_C3,
   f6809_P1_C4,
   f6809_P1_C5,
   f6809_P1_C6,
   fIllegalInstruction,
   f6809_P1_C8,
   f6809_P1_C9,
   f6809_P1_CA,
   f6809_P1_CB,
   f6809_P1_CC,
   fIllegalInstruction,
   f6809_P1_CE,
   fIllegalInstruction,

   f6809_P1_D0,
   f6809_P1_D1,
   f6809_P1_D2,
   f6809_P1_D3,
   f6809_P1_D4,
   f6809_P1_D5,
   f6809_P1_D6,
   f6809_P1_D7,
   f6809_P1_D8,
   f6809_P1_D9,
   f6809_P1_DA,
   f6809_P1_DB,
   f6809_P1_DC,
   f6809_P1_DD,
   f6809_P1_DE,
   f6809_P1_DF,

   f6809_P1_E0,
   f6809_P1_E1,
   f6809_P1_E2,
   f6809_P1_E3,
   f6809_P1_E4,
   f6809_P1_E5,
   f6809_P1_E6,
   f6809_P1_E7,
   f6809_P1_E8,
   f6809_P1_E9,
   f6809_P1_EA,
   f6809_P1_EB,
   f6809_P1_EC,
   f6809_P1_ED,
   f6809_P1_EE,
   f6809_P1_EF,

   f6809_P1_F0,
   f6809_P1_F1,
   f6809_P1_F2,
   f6809_P1_F3,
   f6809_P1_F4,
   f6809_P1_F5,
   f6809_P1_F6,
   f6809_P1_F7,
   f6809_P1_F8,
   f6809_P1_F9,
   f6809_P1_FA,
   f6809_P1_FB,
   f6809_P1_FC,
   f6809_P1_FD,
   f6809_P1_FE,
   f6809_P1_FF,

//
// PAGE 2
//

   // 0x00

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x10

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x20

   fIllegalInstruction,
   f6809_P2_21,
   f6809_P2_22,
   f6809_P2_23,
   f6809_P2_24,
   f6809_P2_25,
   f6809_P2_26,
   f6809_P2_27,
   f6809_P2_28,
   f6809_P2_29,
   f6809_P2_2A,
   f6809_P2_2B,
   f6809_P2_2C,
   f6809_P2_2D,
   f6809_P2_2E,
   f6809_P2_2F,

   // 0x30

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_3F,

   // 0x40

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x50

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x60

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x70

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x80

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_83,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_8C,
   fIllegalInstruction,
   f6809_P2_8E,
   fIllegalInstruction,

   // 0x90

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_93,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_9C,
   fIllegalInstruction,
   f6809_P2_9E,
   f6809_P2_9F,

   // 0xA0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_A3,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_AC,
   fIllegalInstruction,
   f6809_P2_AE,
   f6809_P2_AF,

   // 0xB0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_B3,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_BC,
   fIllegalInstruction,
   f6809_P2_BE,
   f6809_P2_BF,

   // 0xC0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_CE,
   fIllegalInstruction,

   // 0xD0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_DE,
   f6809_P2_DF,

   // 0xE0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_EE,
   f6809_P2_EF,

   // 0xF0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P2_FE,
   f6809_P2_FF,


//
// PAGE 3
//

   // 0x00

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x10

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x20

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x30

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_3F,

   // 0x40

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x50

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x60

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x70

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x80

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_83,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_8C,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0x90

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_93,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_9C,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0xA0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_A3,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_AC,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0xB0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_B3,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   f6809_P3_BC,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0xC0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0xD0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0xE0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,

   // 0xF0

   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
   fIllegalInstruction,
};


