/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex emulator text/graphics I/O functions header file   */
/*                                                                           */
/*   File Name  : IO.C                                                       */
/*                                                                           */
/*   Author     : Keith Wilkins & Christopher Salomon                        */
/*                                                                           */
/*   Version    : 1.20                                                       */
/*                                                                           */
/*   Desciption : This file contains the function prototypes and definitions */
/*                for the vectrex input/output system.                       */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    20/03/93  K.W  Creation                                        */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*    1.20    03/10/96  C.S  Some changes, look at io.c                      */
/*                                                                           */
/*****************************************************************************/

#if !defined IO_H
    #define IO_H

/**************************************************************************/
/* needed for scitech svgalib, otherwise windows.h included, bad for T_INT */
/**************************************************************************/
#ifndef __MSDOS__
#define __MSDOS__
#include <svga.h>
#include <pmode.h>
#undef __MSDOS__
#else
#include <svga.h>
#include <pmode.h>
#endif

#include "util.h"
#include "tools.h" // for mouse pointer und clip mem

/**********************************/
/* Define screen resolution stuff */
/**********************************/
#define RESOLUTION_COUNT   6

#define BOX_FILLED  T_TRUE
#define BOX_OUTLINE T_FALSE

#define BRIGHT0     0
#define BRIGHT1     1
#define BRIGHT2     2
#define BRIGHT3     3
#define BRIGHT4     4
#define BRIGHT5     5
#define BRIGHT6     6
#define BRIGHT7     7
#define BRIGHT8     8
#define BRIGHT9     9
#define BRIGHT10    10
#define BRIGHT11    11
#define BRIGHT12    12
#define BRIGHT13    13
#define BRIGHT14    14
#define BRIGHT15    15

#define WHITE_BASE  0
#define RED_BASE    0x10
#define GREEN_BASE  0x20
#define BLUE_BASE   0x30

#define   IO_PRINT_BUF     1600

/******************************************************/
/* wrap around for negativ offsets (memory enough...) */
/******************************************************/
#define   MAX_SCREEN_LINES 65536

/****************************/
/* Used by VESA mode setups */
/****************************/
typedef struct PIXEL
{
   T_INT  iXpos;
   T_INT  iYpos;
   T_INT  iColour;
}PIXEL;

typedef struct BITBLOCK
{
   T_ULONG   tBitblockMagicNumber1;  /* Only for check bloc validity */
   T_ULONG   tBitblockMagicNumber2;
   T_SWORD   width;
   T_SWORD   height;
   T_PUCHAR  tBlockData;
}BITBLOCK,*BITBLOCKPTR;

/**************************/
/* Stuff for PCX handling */
/**************************/

#define LOAD_BUFFER_SIZE 5000
#define FROM_FILE_END 2
#define FROM_FILE_HERE 1
#define FROM_FILE_START 0

/******************************/
/* Define function prototypes */
/******************************/
T_INT       fIOInit(T_VOID);
T_INT       fIORestore(T_VOID);

PIXEL      fIOOutText(T_SWORD iXpos,T_SWORD iYpos,T_SWORD iColour,T_SWORD iBackground,T_SWORD FontSize,T_PCHAR pcTextBuf);
PIXEL      fIOPrintf(T_SWORD iXpos,T_SWORD iYpos,T_SWORD iColour,T_SWORD iBackground,T_SWORD FontSize,T_PCHAR pcTextFormat,...);
PIXEL      fIOGetLine(T_SWORD iXpos,T_SWORD iYpos,T_SWORD iColour,T_SWORD iBackground,T_SWORD iFontSize,T_PCHAR pcTextBuf,T_UCHAR tMaxLength);
T_VOID     fIOSetClipping(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2);
PIXEL      fIOSetCursorPos(T_SWORD iXpos,T_SWORD iYpos,T_SWORD iColour);
PIXEL      fIOGetScreenRes(T_VOID);
PIXEL      fIOGetCursorPos(T_VOID);
T_PUCHAR   fIOGetOverlayBuffer(T_VOID);
T_PUCHAR   fIOGetClipBuffer(T_VOID);
T_VOID     fIODrawBox(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iColour,T_INT tSolid);
T_INT      fIOAreaMove(T_SWORD iXsrc1,T_SWORD iYsrc1,T_SWORD iXsrc2,T_SWORD iYsrc2,T_SWORD iXdest,T_SWORD iYdest);
T_INT      fIOAreaScroll(T_SWORD iXsrc1,T_SWORD iYsrc1,T_SWORD iXsrc2,T_SWORD iYsrc2,T_SWORD iXdest,T_SWORD iYdest,T_SWORD iBackgroundColour);
T_VOID     fIOAreaClear(T_SWORD iX1,T_SWORD iY1,T_SWORD iX2,T_SWORD iY2,T_SWORD iBackgroundColour);
T_VOID     fIOBitBlockRelease(BITBLOCKPTR tBlock);
T_VOID     fIOsetink(T_UWORD iInk,T_UCHAR ubRed,T_UCHAR ubGreen,T_UCHAR ubBlue);
T_VOID     fIOsetpalette(T_VOID);

T_VOID     fIOUnSetClipBox(T_INT iXpos,T_INT iYpos,T_INT iXsize,T_INT iYsize);
T_VOID     fIOSetClipBox(T_INT iXpos,T_INT iYpos,T_INT iXsize,T_INT iYsize);

T_UWORD    fIOload_pcx_overlay(T_PCHAR filename);
T_UWORD    fIOpcx_write_256pic(T_VOID);


/*****************************************************************/
/* Chris: Had to 'globalize' some Variables since I do 'sort of' */
/*        inline linedrawing...                                  */
/*****************************************************************/
extern T_UWORD rectengle_clipping_enable;
extern T_PUCHAR overlay_memory;
extern T_ULONG vlinestartpos[MAX_SCREEN_LINES];
extern T_INT vio_initialised;
extern T_BYTE mousepointer_vectrex[8*8];
extern MOUSE_POINTER vectrex_mousepointer;

extern T_VOID (*vesa_set_write_window)(T_VOID);
extern T_VOID (*vesa_set_read_window)(T_VOID);

extern SV_devCtx *svdc;



#define fSwap(a,b)                 \
    {iSWTmp=*(a);                  \
    *(a)=*(b);                     \
    *(b)=iSWTmp;}

#define fSwapWord fSwap


extern T_VOID      (* fIOPlotPixel)(T_SWORD ,T_SWORD ,T_SWORD);
extern T_VOID      (* fIODrawMaskLine)(T_SWORD,T_SWORD,T_SWORD,T_SWORD,T_SWORD);
extern T_VOID      (* fIODrawLine)(T_SWORD,T_SWORD,T_SWORD,T_SWORD,T_SWORD);
extern T_VOID      (* fIOcopyvesascreen)(T_PUCHAR ,T_SLONG,T_SLONG,T_SLONG);
extern T_INT       (* fIOAreaLoad)(T_SWORD,T_SWORD,BITBLOCK *);
extern BITBLOCK*   (* fIOAreaSave)(T_SWORD,T_SWORD,T_SWORD,T_SWORD);

//PIXEL      fIOOutChar(T_SWORD iXpos,T_SWORD iYpos,T_SWORD iColour,T_SWORD iBackground,T_SWORD FontSize,T_CHAR  cData);

#define fIOOutChar(iXpos,iYpos,iColour,iBackground,iFontSize,cData) \
{                                                                   \
 T_INT old_print_modus;                                             \
 T_INT old_text;                                                    \
 T_INT old_back_color;                                              \
 T_INT old_text_color;                                              \
 old_print_modus=vesa_print_modus;                                  \
 old_text=vesa_text;                                                \
 old_back_color=vesa_back_color;                                    \
 old_text_color=vesa_text_color;                                    \
 vesa_print_modus=PIC_FILLED;                                       \
 vesa_text=SINGLE_COLOR;                                            \
 vesa_back_color=iBackground;                                       \
 vesa_text_color=iColour;                                           \
 vesa_print_char(iXpos,iYpos,cData);                                \
 vesa_print_modus=old_print_modus;                                  \
 vesa_text=old_text;                                                \
 vesa_back_color=iBackground;                                       \
 vesa_text_color=iColour;                                           \
}


#endif



