;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator code macro functions                         *
;*                                                                           *
;*   File Name  : MAC6809.H                                                  *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the macros for the 6809 kernal function *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    18/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    05/08/96  K.W  Public release of DVE V1.0                      *
;*                                                                           *
;*****************************************************************************


;**********************************
;                                 *
; ENTRY & EXIT MACROS             *
;                                 *
;**********************************

;=========================
   m_entry MACRO
;=========================

   xor     eax,eax
   push    bx
   ENDM


;=========================
   m_exit MACRO
;=========================

   pop     bx
   ret
   ENDM


;**********************************
;                                 *
; MEMORY READ/WRITE MACROS        *
;                                 *
;     bx - address                *
;     dl - data                   *
;                                 *
; Address ALWAYS copied from      *
;        BX to AX                 *
;                                 *
;**********************************

;=========================
   m_store08 MACRO
;=========================

; Not required as all macros clear eax anyways

   mov     ax,bx
   and     eax,0000ffffH
   and     edx,000000ffH
   call    dword ptr _apfWriteHandlers[eax*4]

   ENDM



;=========================
   m_store16 MACRO
;=========================

; Not required as all macros clear eax anyways

   xchg    dl,dh           ; Swap byte order as High saves first
   push    dx              ; Save upper byte
   mov     ax,bx
   and     eax,0000ffffH
   and     edx,000000ffH
   call    dword ptr _apfWriteHandlers[eax*4]

   pop     dx
   xchg    dl,dh
   inc     bx
   mov     ax,bx
   and     eax,0000ffffH   ; Gotta leave this in as handlers corrupt eax
   and     edx,000000ffH
   call    dword ptr _apfWriteHandlers[eax*4]

   ENDM



;=========================
   m_fetch08 MACRO
;=========================

; Not required as all macros clear eax anyways

   mov     ax,bx
   and     eax,0000ffffH
   call    dword ptr _apfReadHandlers[eax*4]
   mov     dl,al

   ENDM



;=========================
   m_fetch16 MACRO
;=========================

; Not required as all macros clear eax anyways

   mov     ax,bx
   and     eax,0000ffffH
   call    dword ptr _apfReadHandlers[eax*4]
   mov     dh,al
   push    dx

   inc     bx
   mov     ax,bx
   and     eax,0000ffffH   ; Gotta leave this in as the handlers corrupt eax
   call    dword ptr _apfReadHandlers[eax*4]

   pop     dx
   mov     dl,al

   ENDM






;=========================
   m_fft08 MACRO
;=========================
; The super fast fetch
;-------------------------

   xor     ebx,ebx
 ; movzx   eax,ax
   mov     bl,[eax+_atSystemImage]

   ENDM


;=========================
   m_fft16 MACRO
;=========================
; The super fast fetch
;-------------------------

   xor     ebx,ebx
 ; movzx   eax,ax
   mov     bx,[eax+_atSystemImage]
   xchg    bl,bh

   ENDM




;**********************************
;                                 *
; RESTORE/SAVE CODE CONDITION REG *
;                                 *
;**********************************


;=========================
   m_getcc MACRO
;=========================

   push    dword [R6809_8086CC]
   popfd
   ENDM


;=========================
   m_putcc MACRO
;=========================

   pushfd
   pop     dword [R6809_8086CC]
   ENDM




;**********************************
;                                 *
; MEMORY MODE ACCESS MACROS       *
;                                 *
; eg  DIRECT, INDIRECT ....       *
;                                 *
;**********************************


;=========================
   m_drect MACRO
;=========================
;
; Construct BX from direct page
;
   m_imm08
   mov     bh,[R6809_DP]

   ENDM



;=========================
   m_imm16 MACRO
;=========================
;
; Construct BX from immediate 16
;

;  xor     eax,eax
   mov     ax,[R6809_PC]   ; Fetch PC
   mov     bx,[eax+_atSystemImage]
   xchg    bl,bh
   add     ax,2
   mov     [R6809_PC],ax


   ENDM




;=========================
   m_imm08 MACRO
;=========================
;
; Construct BX immediate 8
;

;  xor     eax,eax
   mov     ax,[R6809_PC]   ; Fetch PC
   mov     bl,[eax+_atSystemImage]
   inc     ax
   mov     [R6809_PC],ax

   ENDM




;=========================
   m_rel16 MACRO
;=========================
;
; Construct BX from PC & relative 8 bit
;

;  xor     eax,eax
   mov     ax,[R6809_PC]   ; Fetch PC
   mov     bl,[eax+_atSystemImage]
   movsx   bx,bl
   inc     ax
   add     bx,ax
   mov     [R6809_PC],ax

   ENDM



;=========================
   m_lrl16 MACRO
;=========================
;
; Construct BX from PC & relative 16 bit
;

   m_imm16                 ; Fetch Offset in BX
   add     bx,[R6809_PC]   ; Add PC offset

   ENDM



;=========================
  m_index MACRO
;=========================
;
; Construct BX by using jump table
;

   xor     ebx,ebx
;  xor     eax,eax
   mov     ax,[R6809_PC]   ; Fetch postbyte and convert to jump tbl
   mov     bl,[eax+_atSystemImage]
   inc     ax
   mov     [R6809_PC],ax
   call    dword ptr _Idx6809JumpTable[ebx*4]

   ENDM





;
;
;
; Register fetch macros
;
;
;
;
;


;=========================
  m_fetch_hsp MACRO
;=========================
   mov dx,[R6809_HSP]
   ENDM

;=========================
  m_fetch_usp MACRO
;=========================
   mov dx,[R6809_USP]
   ENDM

;=========================
  m_fetch_x MACRO
;=========================
   mov dx,[R6809_X]
   ENDM

;=========================
  m_fetch_y MACRO
;=========================
   mov dx,[R6809_Y]
   ENDM

;=========================
  m_fetch_d MACRO
;=========================
   mov dx,[R6809_D]
   ENDM

;=========================
  m_fetch_a MACRO
;=========================
   mov dl,[R6809_A]
   ENDM

;=========================
  m_fetch_b MACRO
;=========================
   mov dl,[R6809_B]
   ENDM

;=========================
  m_fetch_cc MACRO
;=========================
   call f6809cctodl_
   ENDM





;=========================
  m_store_hsp MACRO
;=========================
   mov [R6809_HSP],dx
   ENDM

;=========================
  m_store_usp MACRO
;=========================
   mov [R6809_USP],dx
   ENDM

;=========================
  m_store_x MACRO
;=========================
   mov [R6809_X],dx
   ENDM

;=========================
  m_store_y MACRO
;=========================
   mov [R6809_Y],dx
   ENDM

;=========================
  m_store_d MACRO
;=========================
   mov [R6809_D],dx
   ENDM

;=========================
  m_store_a MACRO
;=========================
   mov [R6809_A],dl
   ENDM

;=========================
  m_store_b MACRO
;=========================
   mov [R6809_B],dl
   ENDM

;=========================
  m_store_cc MACRO
;=========================
   call f6809dltocc_
   ENDM















;
;
;
;  OPCODE MACROS
;
;
; Data passed and returned in edx/dx/dl
;
; Assume eax & ecx are corrupted
;



;=========================
  m_jsr MACRO
;=========================

   push    bx
   mov     dl,[R6809_PC]   ; Get current PC to push
   mov     bx,[R6809_HSP]  ; Get stack pointer
   dec     bx
   mov     ax,bx
   m_store08               ; Push PCL to stack
   dec     bx
   mov     ax,bx
   mov     [R6809_HSP],bx  ; Save stack pointer
   mov     dl,[R6809_PC+1]
   m_store08               ; Push PCH to stack
   pop     bx
   mov     [R6809_PC],bx   ; Set PC

   ENDM




;=========================
  m_rts MACRO
;=========================

   mov     bx,[R6809_HSP]
   m_fetch08
   inc     bx
   mov     [R6809_PC+1],dl
   m_fetch08
   inc     bx
   mov     [R6809_HSP],bx
   mov     [R6809_PC],dl
   mov     ax,CPU_FETCH

   ENDM




;=========================
  m_jmp MACRO
;=========================

   mov     [R6809_PC],bx

   ENDM




;=========================
  m_ror MACRO
;=========================

   push    edx             ; Save a copy of the data
   m_getcc
   rcr     dl,1
   test    dl,dl           ; Set zero & neg flags correctly
   lahf                    ; carry & overflow are destroyed
   and     ax,0xc000       ; Only preserve z & n
   mov     cx,ax           ; Save for later

   pop     edx             ; Restore the copy
   m_getcc
   rcr     dl,1            ; Set carry & overflow
   lahf                    ; Move flags out
   and     ax,0x0100       ; Only save carry
   or      ax,cx           ; Mask on z & n
   sahf                    ; Restore munged flags

   m_putcc                 ; Finished with flags

   ENDM




;=========================
  m_rol MACRO
;=========================

   push    edx             ; Save a copy of the data
   m_getcc
   rcl     dl,1
   test    dl,dl           ; Set zero & neg flags correctly
   lahf                    ; carry & overflow are destroyed
   and     ax,0xc000       ; Only preserve z & n
   mov     cx,ax           ; Save for later

   pop     edx             ; Restore the copy
   m_getcc
   rcl     dl,1            ; Set carry & overflow
   lahf                    ; Move flags out
   and     ax,0x0100       ; Only save carry
   or      ax,cx           ; Mask on z & n
   sahf                    ; Restore munged flags

   m_putcc                 ; Finished with flags

   ENDM




;=========================
  m_neg MACRO
;=========================

   m_getcc
   neg dl
   m_putcc

   ENDM



;=========================
  m_com MACRO
;=========================

   not     dl
   m_getcc
   test    dl,dl
   m_putcc

   ENDM




;=========================
  m_lsr MACRO
;=========================

   m_getcc
   shr     dl,1
   m_putcc

   ENDM



;=========================
  m_asr MACRO
;=========================

   m_getcc
   sar     dl,1
   m_putcc

   ENDM



;=========================
  m_asl MACRO
;=========================

   m_getcc
   sal     dl,1
   m_putcc

   ENDM



;=========================
  m_dec MACRO
;=========================

   m_getcc
   dec     dl
   m_putcc

   ENDM



;=========================
  m_inc MACRO
;=========================

   m_getcc
   inc     dl
   m_putcc

   ENDM



;=========================
  m_tst08 MACRO
;=========================
;
; The tst instruction preserves
; the carry flag, bummer, there
; goes the easy option

   mov     ecx,[R6809_8086CC]
   push    ecx
   and     ecx,0x01                 ; Preserve carry
   popfd

   test    dl,dl

   pushfd
   pop     dword [R6809_8086CC]
   or      [R6809_8086CC],ecx       ; Or on the old carry

   ENDM



;=========================
  m_tst16 MACRO
;=========================
;
; The tst instruction preserves
; the carry flag, bummer, there
; goes the easy option


   mov     ecx,[R6809_8086CC]
   push    ecx
   and     ecx,0x01                 ; Preserve carry
   popfd

   test    dx,dx

   pushfd
   pop     dword [R6809_8086CC]
   or      [R6809_8086CC],ecx       ; Or on the old carry


   ENDM



;=========================
  m_clr MACRO
;=========================

   mov     dl,0
   m_getcc
   test    dl,dl
   m_putcc

   ENDM



;=========================
  m_cmp_a MACRO
;=========================

   m_getcc
   cmp     [R6809_A],dl
   m_putcc

   ENDM

;=========================
  m_cmp_b MACRO
;=========================

   m_getcc
   cmp     [R6809_B],dl
   m_putcc

   ENDM
