/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex debug monitor function header file                 */
/*                                                                           */
/*   File Name  : MONITOR.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains header file information for the         */
/*                vectrex debugging functions.                               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    15/04/94  K.W  Creation from debug.h after file split          */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined MONITOR_H
#define MONITOR_H

#include <standard.h>

/* Define the command-line definition array */
typedef struct tsCOMMAND
{
    T_UCHAR (*pfCommandFunc)(T_SWORD,T_PUCHAR*,T_PUCHAR*);
    T_UCHAR *pcCommandName;
    T_UCHAR *pcCommandHelp;
}tsCOMMAND;

typedef struct
{
 T_INT   len; // byte, word, int
 T_INT   kind;
 T_INT   start;
 T_INT   compare;
 T_PVOID pointer;
 T_PCHAR name;
} VARIABLE_BREAKPOINT;

typedef struct
{
 T_INT   len; // byte, word, int
 T_PVOID pointer;
 T_UCHAR old_value;
 T_INT   window_id;
 T_PCHAR name;
} VARIABLE_WATCH;

typedef struct
{
 T_PCHAR name;
 T_PVOID pointer;
 T_INT   len; // byte, word, int
} VARIABLE_LIST;

#define T_KIND_MEM             1
#define T_KIND_REG             2
#define T_KIND_BREAK_ON_CHANGE 4
#define T_KIND_BREAK_ON_VALUE  8
#define T_KIND_LABEL          16

#define T_BYTE_LEN 1
#define T_WORD_LEN 2
#define T_INT_LEN  4

/* Define function prototyoes */

T_INT  open_monitor_window(T_VOID);
T_VOID close_monitor_window(T_VOID);
T_VOID set_monitor_functions(T_INT type);

extern UPDATE_FUNCTION *monitor_update;
extern WININFO asMonWin[RESOLUTION_COUNT];
extern tsCOMMAND asCommandList[];
extern T_INT emulator_update_frequency;
extern T_INT pause_on_monitor_entry;
extern T_INT MonitorWinId;
extern T_INT RegWinId;
extern T_LISTE *bliste_first;
extern T_LISTE *bliste_last;
extern T_LISTE *wliste_first;
extern T_LISTE *wliste_last;
extern VARIABLE_LIST vlist[];

#endif



