/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : This file contains function prototypes for debug commands  */
/*                                                                           */
/*   File Name  : MON_CMDS.H                                                 */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : The Vectrex debug monitor command function prototypes      */
/*                and necessary definitions                                  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    20/03/93  K.W  Creation                                        */
/*    0.02    15/03/93  K.W  File name change from commands.h and new        */
/*                           commands added to the prototype list            */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined MON_CMDS_H
    #define MON_CMDS_H

/* Defined for various commands */

#define DUMP_LINE_WIDTH                 16      /* Number of dump bytes on a line */
#define DUMP_DEFAULT_LENGTH             (64-1)  /* Default number of bytes to dump */
#define DISAS_DEFAULT_LENGTH    24              /* Number of bytes to disassemble as a default */
#define DISAS_MAX_STRING                STRING_LENGTH      /* Length of string array passed to disassembler */
#define DISAS_BYTE_MAX                  4       /* Max number of bytes printed in disassembly output */
#define FIND_MAX_LENGTH         12      /* Maximum search string length in bytes */

/* Define debug return Values */

#define  DBG_ERROR      0
#define  DBG_QUIT       1
#define  DBG_OK         2
#define  DBG_SEQUENCE   3
#define  DBG_STEPRUN    4
#define  DBG_STEP       5
#define  DBG_RUN        6
T_UCHAR fMonCmdBreakSet(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdBreakClear(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdBreakShow(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdDebug(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdDump(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdRegDump(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdDissemble(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdReset(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdExit(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdFind(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdHelp(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdRun(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdStepRun(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdSequence(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdStep(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdTicks(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fMonCmdQuit(T_SWORD,T_UCHAR**,T_UCHAR**);
T_UCHAR fBset(T_SWORD,T_UCHAR**,T_UCHAR**);

extern T_ULONG steps;

#endif
