#pragma message ( "including msnglcpu.cc" );
/*****************************************************************************/
/*                                                                           */
/*   Function    : f6809Tick()                                               */
/*                                                                           */
/*   Author      : K.W / C.S.                                                */
/*                                                                           */
/*   Description : This function runs one cycle of CPU time emulation.       */
/*                                                                           */
/*   Accepts     : nothing                                                   */
/*                                                                           */
/*   Returns     : nothing                                                   */
/*                                                                           */
/*****************************************************************************/

#define PIA_TIMER1
#define PIA_TIMER2
#define PIA_SHIFT
/***************************************/
/*         MULTI TICK START            */
/***************************************/
{
 static int i;
#if defined SEQUENCER_LIGHTPEN || defined CLAY_ONLY
 if (!iCount)
 {
#endif
  /*****************************************/
  /* Switch on the status of the processor */
  /*****************************************/
  switch (i6809status)
  {
   case CPU_FETCH:
   {
    register T_SWORD ticks_at_once;
    /**********************************************/
    /* Print Instruction disassembly within debug */
    /**********************************************/
#ifdef DEBUG_MSG
    if (tGblDebugLevel==LOW)
    {
     T_UWORD   wUBYTECount,wAddress,wLoop;
     T_CHAR    acTmp[STRING_LENGTH];
     T_CHAR    acDisString[STRING_LENGTH];
     T_CHAR    acLine[STRING_LENGTH];
     fDebug(LOW,(""));
     fDebug(LOW,("f6809msnglmulti() - x   0x%04x    y   0x%04x    d   0x%04x (a=0x%02x  b=0x%02x)",tsCPURegisters.tX,tsCPURegisters.tY,tsCPURegisters.uABD.tD,tsCPURegisters.uABD.sAB.tA,tsCPURegisters.uABD.sAB.tB));
     fDebug(LOW,("f6809msnglmulti() - usp 0x%04x    hsp 0x%04x    dp  0x%02x",tsCPURegisters.tUSP,tsCPURegisters.tHSP,tsCPURegisters.tDP));
     fDebug(LOW,("f6809msnglmulti() - pc  0x%04x    cc  0x%02x (c=%d v=%d z=%d n=%d)",tsCPURegisters.tPC,tsCPURegisters.uCC.tCC,tsCPURegisters.uCC.sCC.bC,tsCPURegisters.uCC.sCC.bV,tsCPURegisters.uCC.sCC.bZ,tsCPURegisters.uCC.sCC.bN));
     fDebug(LOW,("f6809msnglmulti()"));

     wAddress=f6809Disassemble(tsCPURegisters.tPC,acDisString);
     wUBYTECount=wAddress-tsCPURegisters.tPC;
     sprintf(acLine,"%04x  ",tsCPURegisters.tPC);

     for (wLoop=0;wLoop<wUBYTECount;wLoop++)
     {
      sprintf(acTmp,"%02x ",f6809AddressRead(tsCPURegisters.tPC+wLoop));
      strcat(acLine,acTmp);
     }
     for(wLoop=wUBYTECount;wLoop<4;wLoop++)
     {
      strcat(acLine,"   ");
     }
     strcat(acLine,"  ");
     strcat(acLine,acDisString);
     fDebug(LOW,("f6809msnglmulti() - %s",acLine));
     fDebug(LOW,("f6809msnglmulti()"));
    }
#endif
    /***********************************************************/
    /* iBPTriggered is used as a state toggle, breakpoints     */
    /* are only enabled if they haven't been triggered         */
    /* on the next trip thru after trigger, the BPTrigger will */
    /* be cleared and we'll go into CPU_DECODE                 */
    /***********************************************************/
#ifdef DEBUG_MON
    if (iBreakpointEnable && iBreakpoint==tsCPURegisters.tPC && !iBPTriggered)
    {
     if (iSkipCount>0)
     {
      iSkipCount--;
     }
     else
     {
//      bGblDebugMonitorEnable=T_TRUE;
      bGblPauseMode=T_TRUE;
      vector_undraw();
      vector_refresh();
      vectrex_update->frequency=1;
      if (bGblDebugMonitorEnable!=T_TRUE)
      if (open_monitor_window()==T_TRUE)
      {
       bGblDebugMonitorEnable=T_TRUE;
       if (bGblGUIEnable==T_FALSE)
       {
        WINDOW_LISTEN_ELEMENT *MonitorWin=get_window(MonitorWinId);
        hide_raw_window(MonitorWin);
        back_save(FORCED_SAVE);
        show_all_windows();
       }
       bGblGUIEnable=T_TRUE;
       set_functions();
       reset_state=T_FALSE;
       wGblQuitFlag=EMU_RESTART;
      }
      iBPTriggered=T_TRUE;
      break;
     }
    }
    else
    {
     iBPTriggered=T_FALSE;
    }
    iLastAddress=tsCPURegisters.tPC;
#endif
    /**********************************************************/
    /* ...   interrupt status ignore NMI as it is unconnected */
    /* Interrupt can't happen in multi tick (supposedly)      */
    /**********************************************************/
    #include "pia.cc"
    if (tsCPURegisters.tIRQFlag && !tsCPURegisters.uCC.sCC.bI)
    {
     t1int=T_FALSE;
     fDebug(HIGH,("f6809msnglmulti() - IRQ Detected <PC=%04x>",tsCPURegisters.tPC));
     tsCPURegisters.tIRQFlag=0;
     ticks_at_once=f6809IRQ();
     tsCPURegisters.tPC=(f6809FastAddressRead(0xfff8)<<8)+f6809FastAddressRead(0xfff9);
     lwGblSystemTickTotal++;
     for (i=0;i<ticks_at_once;i++)
     {
      #include "pia.cc"
      lwGblSystemTickTotal++;
     }
     break;
    }
    else if (tsCPURegisters.tFIRQFlag && !tsCPURegisters.uCC.sCC.bF)
    {
     fDebug(HIGH,("f6809msnglmulti() - FIRQ Detected <PC=%04x>",tsCPURegisters.tPC));
     tsCPURegisters.tFIRQFlag=0;
     ticks_at_once=f6809FIRQ();
     tsCPURegisters.tPC=(f6809FastAddressRead(0xfff6)<<8)+f6809FastAddressRead(0xfff7);
     lwGblSystemTickTotal++;
     for (i=0;i<ticks_at_once;i++)
     {
      #include "pia.cc"
      lwGblSystemTickTotal++;
     }
     break;
    }
    else
    {
     T_PUWORD hpoint;
#ifndef DEBUG_MSG
     ticks_at_once=cycle_count[*(hpoint=(T_PUWORD)(atSystemImage+(tsCPURegisters.tPC++)))];
#endif
#ifdef DEBUG_MSG
     if ((ticks_at_once=cycle_count[*(hpoint=(T_PUWORD)(atSystemImage+(tsCPURegisters.tPC++)))])==-1)
     {
      fDebug(VERROR,("f6809msnglmulti() - Bad instruction decoded #$%02x",iInstruction));
      i6809status=CPU_EXCEPTION;
      lwGblSystemTickTotal++;
      break;
     }
     else
     {
      fDebug(LOW,("f6809msnglmulti() - FETCH CYCLE - Addr $%04x,  OpCode #$%02x, %d cycles before decode",iLastAddress,iInstruction,iCount));
     }
#endif
     lwGblSystemTickTotal++;
     for (i=0;i<ticks_at_once;i++)
     {
      #include "pia.cc"
      lwGblSystemTickTotal++;
     }
     #include "pia.cc"
     i6809status=(apfExecuteInstruction[*((T_PUCHAR)hpoint)])();
     fDebug(LOW,("f6809msnglmulti() - FETCH & DECODE CYCLE- Ret  #$%02x",i6809status));
     lwGblSystemTickTotal++;
     break;
    }
    break;
   }
   case CPU_DECODE:
   {
     fFatal("f6809Decode() - CPU NOTHING SHOULD EVER BE HERE!!!!");
    /****************************************/
    /* multi CPU_FETCH should not come here */
    /****************************************/
    /*********************************************************************/
    /* here it is important to reduce timers BEFORE CALLING PIA_SHIFT!!! */
    /*********************************************************************/
    f6522Tick();
    i6809status=(apfExecuteInstruction[iInstruction])();
    fDebug(LOW,("f6809msnglmulti() - DECODE CYCLE- Ret  #$%02x",i6809status));
    lwGblSystemTickTotal++;
    break;
   }
   case CPU_HALT:
   {
    f6522Tick();
    f6809Reset();
    i6809status=CPU_WAIT;
    lwGblSystemTickTotal++;
    break;
   }
   case CPU_EXCEPTION:
   {
    f6522Tick();
    fDebug(VERROR,("f6809msnglmulti() - Exception generated by instruction #$%02x at address $%04x",iInstruction,iLastAddress));
    i6809status=CPU_WAIT;
#ifdef DEBUG_MON
//    bGblDebugMonitorEnable=T_TRUE;
      bGblPauseMode=T_TRUE;
      vector_undraw();
      vector_refresh();
      vectrex_update->frequency=1;
      if (bGblDebugMonitorEnable!=T_TRUE)
      if (open_monitor_window()==T_TRUE)
      {
       bGblDebugMonitorEnable=T_TRUE;
       if (bGblGUIEnable==T_FALSE)
       {
        WINDOW_LISTEN_ELEMENT *MonitorWin=get_window(MonitorWinId);
        hide_raw_window(MonitorWin);
        back_save(FORCED_SAVE);
        show_all_windows();
       }
       bGblGUIEnable=T_TRUE;
       set_functions();
       reset_state=T_FALSE;
       wGblQuitFlag=EMU_RESTART;
      }
#endif
    lwGblSystemTickTotal++;
    break;
   }
   case CPU_CWAI:
   {
    /********************************************************/
    /* CWAI is handled differently as the stack has already */
    /* been pushed                                          */
    /********************************************************/
    f6522Tick();
    if (tsCPURegisters.tIRQFlag && !tsCPURegisters.uCC.sCC.bI)
    {
     tsCPURegisters.tIRQFlag=T_FALSE;
     tsCPURegisters.uCC.sCC.bI=1;
     tsCPURegisters.uCC.sCC.bF=1;
     tsCPURegisters.tPC=(f6809FastAddressRead(0xfff8)<<8)+f6809FastAddressRead(0xfff9);
     i6809status=CPU_FETCH;
     fDebug(HIGH,("f6809msnglmulti() - IRQ Detected, cwai released to addr %04x",tsCPURegisters.tPC));
    }
    else if (tsCPURegisters.tFIRQFlag && !tsCPURegisters.uCC.sCC.bF)
    {
     tsCPURegisters.tFIRQFlag=T_FALSE;
     tsCPURegisters.uCC.sCC.bI=1;
     tsCPURegisters.uCC.sCC.bF=1;
     tsCPURegisters.tPC=(f6809FastAddressRead(0xfff6)<<8)+f6809FastAddressRead(0xfff7);
     i6809status=CPU_FETCH;
     fDebug(HIGH,("f6809msnglmulti() - FIRQ Detected, cwai released to addr %04x",tsCPURegisters.tPC));
    }
    else if (tsCPURegisters.uCC.sCC.bI & tsCPURegisters.uCC.sCC.bI)
    {
     fopen_monitor_debug_pause();
#define _fDebug(level,body) ((bGblDebugEnable==T_TRUE && level>=tGblDebugLevel)?(tGblDebugMsgLevel=level),(fDebugXX body):0)
     _fDebug(HIGH,("f6809msnglmulti() CWAI - CPU permanently halted wait for NMI at addr $%04x",tsCPURegisters.tPC));
#undef _fDebug
    }
    lwGblSystemTickTotal++;
    break;
   }
   case CPU_SYNC:
   {
    f6522Tick();
    /******************************************************************/
    /* Leave the interrupt handler in CPU_FETCH to handle the IRQ now */
    /******************************************************************/
    /**********************************************************/
    /* Chris: Interrupts should not occur while in Multitick  */
    /**********************************************************/
    if (tsCPURegisters.tIRQFlag)
    {
     fDebug(HIGH,("f6809msnglmulti() - IRQ Detected, sync released to addr %04x",tsCPURegisters.tPC));
     i6809status=CPU_FETCH;
    }
    if (tsCPURegisters.tFIRQFlag)
    {
     fDebug(HIGH,("f6809msnglmulti() - FIRQ Detected, sync released to addr %04x",tsCPURegisters.tPC));
     i6809status=CPU_FETCH;
    }
    lwGblSystemTickTotal++;
    break;
   }
   case CPU_WAIT:
   {
    f6522Tick();
#ifdef DEBUG_MSG
//    fAlertBox(RED_BASE+BRIGHT14,"\n f6809msnglmulti() WAIT CPU ERROR - Exception generated, emulator will now reset \n");
    show_message("\n f6809msnglmulti() WAIT CPU ERROR - Exception generated, emulator will now reset \n");
#else
    fopen_monitor_debug_pause();
#define _fDebug(level,body) ((bGblDebugEnable==T_TRUE && level>=tGblDebugLevel)?(tGblDebugMsgLevel=level),(fDebugXX body):0)
    _fDebug(HIGH,("f6809msnglmulti() WAIT CPU ERROR - Exception generated, emulator will now reset"));
#undef _fDebug
#endif
    bGblStatsValid=T_FALSE;
    fSequencerReboot(0);
    lwGblSystemTickTotal++;
    break;
   }
   default:
   {
    /****************************************************/
    /* Default case is used to add further delay cycles */
    /* 00 = Fetch, all other codes are 0xf8 onwards     */
    /****************************************************/
    if (i6809status>=limit)
    {
     i6809status-=limit;
     {
      for (i=0;i<limit;i++)
      {
       #include "pia.cc"
       lwGblSystemTickTotal++;
      }
     }
     break;
    }
    else
    {
     {
      for (i=0;i<i6809status;i++)
      {
       #include "pia.cc"
       lwGblSystemTickTotal++;
      }
     }
     i6809status=0;
     break;
    }
   }
  }
#if defined SEQUENCER_LIGHTPEN || defined CLAY_ONLY
 }
 else
 {
  {
   for (i=0;i<iCount;i++)
   {
    #include "pia.cc"
    lwGblSystemTickTotal++;
   }
  }
  iCount=0;
 }
#endif
}
/***************************************/
/*          MULTI TICK END             */
/***************************************/

#undef PIA_TIMER1
#undef PIA_TIMER2
#undef PIA_SHIFT
