
#ifdef _NO_DEBUG_INFORMATION_

#include <dos.h>
#include <conio.h>

#include <standard.h>
#include <tools.h>

#include "keyboard.h"
#include "joystick.h"
#include "emu6809.h"
#include "emu6522.h"
#include "verror.h"
#include "vdebug.h"
#include "vectrex.h"
#include "sound.h"

static T_INT none_timer=0;
static T_VOID __far __interrupt fTimerTick(T_VOID)
{
 timer_tick++;
//   (dos_timer_handler)();      // Chain the DOS timer tick
}

#endif //#ifdef _NO_DEBUG_INFORMATION_

#ifndef _NO_DEBUG_INFORMATION_

T_INT fnoneSoundInit(T_VOID)
{
 if (bGblDisplayVerbose==T_TRUE)
 t_printf(E_VERBOSE_NONE,"\nNo Sound init!");
 return T_TRUE;
}
T_VOID fnoneSoundReset(T_VOID){return;}
T_VOID fnoneSoundRestore(T_VOID){return;}
T_VOID fnoneSoundMute(T_VOID){return;}
T_VOID fnoneSoundResume(T_VOID){return;}

T_VOID noneInitTimerHandler(T_VOID)
{
 if (none_timer==0)
 {
  none_timer=1;
  dos_timer_handler = _dos_getvect(DOS_TIMER_IRQ);
  _dos_setvect(DOS_TIMER_IRQ, fTimerTick);
  outp(0x43, 0x34);
  outp(0x40, T_LOW_BYTE(TIMER_RATE));
  outp(0x40, T_HIGH_BYTE(TIMER_RATE));
 }
}

T_VOID noneDoneTimerHandler(T_VOID)
{
 if (none_timer==1)
 {
  none_timer=0;
  outp(0x43, 0x34);
  outp(0x40, 0x00);
  outp(0x40, 0x00);
  _dos_setvect(DOS_TIMER_IRQ, dos_timer_handler);
 }
}

T_VOID fnoneSoundTick(T_VOID)
{
 T_UCHAR tTmp;
 if (tOLD_BC1!=tSIGDEF_AY3BC1 || tOLD_BDIR!=tSIGDEF_AY3BDIR)
 {
  tTmp=tOLD_BDIR|tOLD_BC1;
  fDebug(MED,("fSoundTick() - %02x",tTmp));
  switch(tTmp)
  {
   case 0x08:   // Read from AY-3-8192
   {
    switch(tAddr)
    {
     case 0x0e:
     {
      // Build the key char
      tKeyWord =(fKBDisdown(wGblPly2Button4))?0:1<<7;
      tKeyWord|=(fKBDisdown(wGblPly2Button3))?0:1<<6;
      tKeyWord|=(fKBDisdown(wGblPly2Button2))?0:1<<5;
      tKeyWord|=(fKBDisdown(wGblPly2Button1))?0:1<<4;
      tKeyWord|=(fKBDisdown(wGblPly1Button4))?0:1<<3;
      tKeyWord|=(fKBDisdown(wGblPly1Button3))?0:1<<2;
      tKeyWord|=(fKBDisdown(wGblPly1Button2))?0:1<<1;
      tKeyWord|=(fKBDisdown(wGblPly1Button1))?0:1<<0;
      if (wGblPCJoystick)
      {
       if (button1a)
        tKeyWord&=255-0x08;
       if (button1b)
        tKeyWord&=255-0x04;
       if (button2a)
        tKeyWord&=255-0x80;
       if (button2b)
        tKeyWord&=255-0x40;
      }
      if (!tKeyWord&0x80)
      {
       t6522CA1=1; // muesste hier gesetzt werden und im 6522 abgefragt werden!
       t6522IFLG|=E6522IFLG_CA1;
//       t6522AUX_PA_LE=1;
       if (t6522IER&E6522IFLG_CA1)
        tsCPURegisters.tIRQFlag=T_TRUE; /* CA1 -> keyboard 2 normaler IRQ ??? */
      }
      else
      {
       t6522CA1=0;
       t6522IFLG&=(255-E6522IFLG_CA1);
//       t6522AUX_PA_LE=0;
      }
      if (!tKeyWord&0x08)
      {
       tsCPURegisters.tFIRQFlag=T_TRUE;
      }
      fDebug(MED,("fSoundTick() - Joypad button returned %02x",tKeyWord));
      t6522IRA=tKeyWord;
      break;
     }
     default:
     {
      fDebug(MED,("fSoundTick() - Bad register select"));
      break;
     }
    }
    break;
   }
   case 0x10:   // Write to AY-3-8192
   {
    if (tAddr==14) // only needed for goggle support ?
    {
     static T_ULONG last=0;
     if ((tKeyOut&(255-128)))
     {
      if (t6522ORA!=255)
      {
       imager_pulse_ticks=lwGblSystemTickTotal-last;
      }
     }
     last=lwGblSystemTickTotal;
     tKeyOut=t6522ORA;
    }
    break;
   }
   case 0x18:   // Latch address to AY-3-8192
   {
    fDebug(MED,("fSoundTick() - Latch Address"));
    tAddr=t6522ORA&0x0f;
    break;
   }
   default:
   {
    break;
   }
  }
 }
 tOLD_BC1=tSIGDEF_AY3BC1;
 tOLD_BDIR=tSIGDEF_AY3BDIR;
}

#endif //#ifndef _NO_DEBUG_INFORMATION_
