#pragma message ( "including pia.cc" );
/*****************************************************************************/
/*                                                                           */
/*   Function    : f6522Tick()                                               */
/*                                                                           */
/*   Author      : K.W / C.S.                                                */
/*                                                                           */
/*   Description : Perform a single tick of the 6522 counters                */
/*                 Sometimes inline...                                       */
/*                                                                           */
/*   Accepts     : nothing                                                   */
/*                                                                           */
/*   Returns     : nothing                                                   */
/*                                                                           */
/*****************************************************************************/
{
#ifdef PIA_TIMER1
 /*********************/
 /* TIMER 1 EMULATION */
 /*********************/
 if ((u6522Timer1.uCount.tW--)==0xffff)
 {
#ifdef DEBUG_MSG
  tcount++;
  fDebug(MID,("f6522Tick() - Timer 1 = %04x (%i)",u6522Timer1.uCount.tW,tcount));
#endif
//  u6522Timer1.uCount.tW=u6522Timer1.uLatch.tW; // moved to switch clause
  t6522IFLG|=E6522IFLG_TIMER1;
  if ((t6522IER&E6522IFLG_TIMER1) && !tsCPURegisters.uCC.sCC.bI)
  {
   /**********************************************************************/
   /* The only rom I know of which actually does a T1 interrupt is SPIKE */
   /**********************************************************************/
   fDebug(HIGH,("<T1<--  f6522Tick() - IRQ asserted by 6522 Timer 1 at PC=<%04x>",tsCPURegisters.tPC));
   fDebug(HIGH,("u6522Timer1.uLatch.tW:%04x",u6522Timer1.uLatch.tW));
   fDebug(HIGH,("IRQ lwGblSystemTickTotal:%i -->T1>",(T_ULONG)lwGblSystemTickTotal));
   tsCPURegisters.tIRQFlag=T_TRUE;
   t1int=T_TRUE; /* YUK! */
  }
  /************************/
  /* Switch on timer mode */
  /************************/
  switch (t6522AUX_T1CTRL)
  {
   case 2: // ONE SHOT MODE ON PB7
    fDebug(LOW,("f6522Tick() - Timer 1 expiry (PB7 was ==%d) PB7=1",(t6522ORB_7)?1:0));
    t6522ORB_7=TMPL_RB_7;
#ifdef ANALOG_CYCLE_PATCH
#define INTERNAL_ANALOG_CYCLE_PATCH
   patch_must_be_applied|=RAMP_TEST_BIT;
   ramp_patch_cycle_countdown[ramp_patch_queue_depth]=RAMP_REACT_OFFSET_CYCLES;
   ramp_set_to[ramp_patch_queue_depth]=t6522ORB_7;
   ramp_patch_queue_depth++;
#else
    fAnalogTick();
#endif
    break;
   case 3: // FREE RUN MODE
    u6522Timer1.uCount.tW=u6522Timer1.uLatch.tW;
    fDebug(LOW,("f6522Tick() - Timer 1 expiry PB7 Toggle"));
    t6522ORB_7^=TMPL_RB_7;
#ifdef ANALOG_CYCLE_PATCH
#define INTERNAL_ANALOG_CYCLE_PATCH
   patch_must_be_applied|=RAMP_TEST_BIT;
   ramp_patch_cycle_countdown[ramp_patch_queue_depth]=RAMP_REACT_OFFSET_CYCLES;
   ramp_set_to[ramp_patch_queue_depth]=t6522ORB_7;
   ramp_patch_queue_depth++;
#else
    fAnalogTick();
#endif
    break;
   case 0:
   case 1:
    break;
   default:
    fDebug(VERROR,("f6522Tick() Illegal TIMER1 mode (%d)",t6522AUX_T2CTRL));
    break;
  }
 }
#endif
#ifdef PIA_TIMER2
 /*********************/
 /* TIMER 2 EMULATION */
 /*********************/
 if (!u6522Timer2.uCount.tW--)
 {
  if (bTimer2OneShot)
  {
   fDebug(MED,("f6522Tick() - 6522 Timer 2 at PC=<%04x>",tsCPURegisters.tPC));
   bTimer2OneShot=T_FALSE;
   t6522IFLG|=E6522IFLG_TIMER2;
   if ((t6522IER&E6522IFLG_TIMER2) && !tsCPURegisters.uCC.sCC.bI )
   {
    fDebug(HIGH,("f6522Tick() - IRQ asserted by 6522 Timer 2 at PC=<%04x>",tsCPURegisters.tPC));
    tsCPURegisters.tIRQFlag=T_TRUE;
   }
  }
  else
  {
   fDebug(HIGH,("f6522Tick() - Timer 2 expired, no IRQ"));
  }
 }
#endif
#ifdef PIA_SHIFT
 /***************************/
 /* SHIFT REGISTER EMULATON */
 /***************************/
 /******************************/
 /* CB1 emulation not required */
 /******************************/
 if (t6522SHFTREGACT)
 {
  fDebug(MED,("f6522Tick() - Shifting %02x -> Out %02x",t6522SHFTREG,t6522CB2));
  if (iToggle)
  {
   switch(t6522AUX_SHFTCTRL)
   {
    case 6: // Shift out using main clk
     t6522CB2=t6522SHFTREG&0x80;
     fDebug(MED,("f6522Tick() - Shifting %02x -> Out %02x",t6522SHFTREG,t6522CB2));
     t6522SHFTREG=t6522SHFTREG<<1;
     t6522SHFTREGACT--;
#ifdef ANALOG_CYCLE_PATCH
#define INTERNAL_ANALOG_CYCLE_PATCH
   patch_must_be_applied|=BLANK_TEST_BIT;
   blank_patch_cycle_countdown[blank_patch_queue_depth]=BLANK_REACT_OFFSET_CYCLES;
   blank_set_to[blank_patch_queue_depth]=t6522CB2;
   blank_patch_queue_depth++;
#endif
     fAnalogTick();
     break;
    default:
     fDebug(VERROR,("f6522Tick() - Shift register mode not supported"));
   if (bGblDisplayVerbose==T_TRUE)
     t_printf(E_VERBOSE_NONE,"\nf6522Tick() - Shift register mode not supported (%i) (PC=%04X)",t6522AUX_SHFTCTRL,tsCPURegisters.tPC);
     break;
   }
   if (!t6522SHFTREGACT)
   {
    t6522IFLG|=E6522IFLG_SHFT;
    if (t6522IER&0x04)
    {
     fDebug(HIGH,("f6522Tick() - IRQ asserted by 6522 Shift Reg at PC=<%04x>",tsCPURegisters.tPC));
     tsCPURegisters.tIRQFlag=T_TRUE;
    }
   }
   iToggle=0;
  }
  else
  {
   iToggle=1;
  }
 }
#endif
}
{
#ifdef ANALOG_CYCLE_PATCH

 #if defined SEQUENCER_ANALOG_CYCLE_PATCH || defined INTERNAL_ANALOG_CYCLE_PATCH

 #ifdef INTERNAL_ANALOG_CYCLE_PATCH

 #undef INTERNAL_ANALOG_CYCLE_PATCH

 #endif

 static T_UWORD cc,c1,anatick,psgtick;
 if (patch_must_be_applied!=0)
 {
  anatick=0;
  psgtick=0;
  if (ramp_patch_queue_depth!=0)
  {
   for (cc=0;cc<ramp_patch_queue_depth;cc++)
   {
    if (--ramp_patch_cycle_countdown[cc]==0)
    {
     tSIGDEF_RAMPB=ramp_set_to[cc];
     anatick=1;
     for (c1=cc;c1<ramp_patch_queue_depth;c1++)
     {
      ramp_patch_cycle_countdown[c1]=ramp_patch_cycle_countdown[c1+1];
      ramp_set_to[c1]=ramp_set_to[c1+1];
     }
     ramp_patch_queue_depth--;
     if (ramp_patch_queue_depth==0)
     {
      patch_must_be_applied-=RAMP_TEST_BIT;
     }
     if (cc<ramp_patch_queue_depth)
      cc--;
    } // if (--ramp_patch_cycle_countdown[cc]==0)
   } // for (cc=0;cc<ramp_patch_queue_depth;cc++)
  } // if (ramp_patch_queue_depth!=0)
  if (blank_patch_queue_depth!=0)
  {
   for (cc=0;cc<blank_patch_queue_depth;cc++)
   {
    if (--blank_patch_cycle_countdown[cc]==0)
    {
     tSIGDEF_BLANKB=blank_set_to[cc];
     anatick=1;
     for (c1=cc;c1<blank_patch_queue_depth;c1++)
     {
      blank_patch_cycle_countdown[c1]=blank_patch_cycle_countdown[c1+1];
      blank_set_to[c1]=blank_set_to[c1+1];
     }
     blank_patch_queue_depth--;
     if (blank_patch_queue_depth==0)
     {
      patch_must_be_applied-=BLANK_TEST_BIT;
     }
     if (cc<blank_patch_queue_depth)
      cc--;
    } // if (--blank_patch_cycle_countdown[cc]==0)
   } // for (cc=0;cc<blank_patch_queue_depth;cc++)
  }
  if (sample_hold_patch_queue_depth!=0)
  {
   for (cc=0;cc<sample_hold_patch_queue_depth;cc++)
   {
    if (--sample_hold_patch_cycle_countdown[cc]==0)
    {
     tSIGDEF_SAMPHOLD=sample_hold_set_to[cc];
     tSIGDEF_AMUXSEL=mux_select_set_to[cc];
     anatick=1;
     psgtick=1;
     for (c1=cc;c1<sample_hold_patch_queue_depth;c1++)
     {
      sample_hold_patch_cycle_countdown[c1]=sample_hold_patch_cycle_countdown[c1+1];
      sample_hold_set_to[c1]=sample_hold_set_to[c1+1];
      mux_select_set_to[c1]=mux_select_set_to[c1+1];
     }
     sample_hold_patch_queue_depth--;
     if (sample_hold_patch_queue_depth==0)
     {
      patch_must_be_applied-=SAMPLE_HOLD_TEST_BIT;
     }
     if (cc<sample_hold_patch_queue_depth)
      cc--;
    } // if (--sample_hold_patch_cycle_countdown[cc]==0)
   } // for (cc=0;cc<sample_hold_patch_queue_depth;cc++)
  }
  if (dac_patch_queue_depth!=0)
  {
   for (cc=0;cc<dac_patch_queue_depth;cc++)
   {
    if (--dac_patch_cycle_countdown[cc]==0)
    {
     anatick=1;
     psgtick=1;
     tSIGDEF_DACBUS=dac_set_to[cc];
     for (c1=cc;c1<dac_patch_queue_depth;c1++)
     {
      dac_patch_cycle_countdown[c1]=dac_patch_cycle_countdown[c1+1];
      dac_set_to[c1]=dac_set_to[c1+1];
     }
     dac_patch_queue_depth--;
     if (dac_patch_queue_depth==0)
     {
      patch_must_be_applied-=DAC_TEST_BIT;
     }
     if (cc<dac_patch_queue_depth)
      cc--;
    } // if (--dac_patch_cycle_countdown[cc]==0)
   } // for (cc=0;cc<dac_patch_queue_depth;cc++)
  }
  if (zero_patch_queue_depth!=0)
  {
   for (cc=0;cc<zero_patch_queue_depth;cc++)
   {
    if (--zero_patch_cycle_countdown[cc]==0)
    {
     anatick=1;
     tSIGDEF_ZEROB=zero_set_to[cc];
     for (c1=cc;c1<zero_patch_queue_depth;c1++)
     {
      zero_patch_cycle_countdown[c1]=zero_patch_cycle_countdown[c1+1];
      zero_set_to[c1]=zero_set_to[c1+1];
     }
     zero_patch_queue_depth--;
     if (zero_patch_queue_depth==0)
     {
      patch_must_be_applied-=ZERO_TEST_BIT;
     }
     if (cc<zero_patch_queue_depth)
      cc--;
    } // if (--zero_patch_cycle_countdown[cc]==0)
   } // for (cc=0;cc<zero_patch_queue_depth;cc++)
  }
//NOT DONE YET
//#define    tSIGDEF_COMPARE     t6522IRB_5
//#define    tSIGDEF_AY3BDIR     t6522ORB_4
//#define    tSIGDEF_AY3BC1      t6522ORB_3
//#define    tSIGDEF_SW7         t6522CA1
//#define    tSIGDEF_CARTRIDGE   t6522IRB_6
  if (anatick!=0)
   fAnalogTick();
  if (psgtick!=0)
   fSoundTick();
 }
 #endif

#endif

}