;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator code PSHS instruction code                   *
;*                                                                           *
;*   File Name  : PSHS6809.ASM                                               *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the code to emulate the pshs instruction*
;*                a jump table is used to decode the register combinations   *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    22/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    06/08/96  K.W  Public release of DVE 1.0                       *
;*                                                                           *
;*****************************************************************************

extern _f6809AddressRead:near
extern _f6809AddressWrite:near
extern _apfWriteHandlers:near
extern _apfReadHandlers:near
extern _Idx6809JumpTable:near
extern f6809cctodl_:near
extern f6809dltocc_:near

include "reg6809.h"
include "mac6809.h"

_PSHU6809_TEXT segment dword public 'CODE'
               assume  CS:_PSHU6809_TEXT


;
; Define local PUSH macros
;
mpush_a MACRO
  dec     bx              ; Pre-decrement PC
  mov     dl,[R6809_A]
  m_store08
ENDM

mpush_b MACRO
  dec     bx
  mov     dl,[R6809_B]
  m_store08
ENDM

mpush_cc MACRO
   dec     bx
   call    f6809cctodl_
   mov     dl,[R6809_CC]
   m_store08
ENDM

mpush_dp MACRO
  dec     bx
  mov     dl,[R6809_DP]
  m_store08
ENDM

mpush_x MACRO
  dec     bx
  mov     dl,[R6809_X]
  m_store08

  dec     bx
  mov     dl,[R6809_X+1]
  m_store08
ENDM

mpush_y MACRO
  dec     bx
  mov     dl,[R6809_Y]
  m_store08

  dec     bx
  mov     dl,[R6809_Y+1]
  m_store08
ENDM

mpush_s MACRO
  dec     bx
  mov     dl,[R6809_HSP]
  m_store08

  dec     bx
  mov     dl,[R6809_HSP+1]
  m_store08
ENDM

mpush_pc MACRO
  dec     bx
  mov     dl,[R6809_PC]
  m_store08

  dec     bx
  mov     dl,[R6809_PC+1]
  m_store08
ENDM







; Template
;
; PC,U,Y,X,DP,B,A,CC
;
;pshu6809_xx    PROC    near
;               mov     bx,[R6809_USP]
;               mpush_pc
;               mpush_s
;               mpush_y
;               mpush_x
;               mpush_dp
;               mpush_b
;               mpush_a
;               mpush_cc
;               mov     [R6809_USP],bx
;               mov     ax,0x0ZZ
;               ret
;pshu6809_xx    ENDP







;
; CPU Exception
;
pshu6809_EX    PROC    near

               add     sp,4               ; Remove return address
               mov     ax,CPU_EXCEPTION
               m_exit
               ret

pshu6809_EX    ENDP



;
;
; START OF CODE
;
; Note AX always returns number of cycles.
;



;*************************************
;
;             0x00
;
;*************************************

;
; Nowt
;
pshu6809_00    PROC    near
               mov     ax,0x00
               ret
pshu6809_00    ENDP



;
; CC
;
pshu6809_01    PROC    near
               mov     bx,[R6809_USP]
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pshu6809_01    ENDP



;
; A
;
pshu6809_02    PROC    near
               mov     bx,[R6809_USP]
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pshu6809_02    ENDP



;
; CC,A
;
pshu6809_03    PROC    near
               mov     bx,[R6809_USP]
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_03    ENDP



;
; B
;
pshu6809_04    PROC    near
               mov     bx,[R6809_USP]
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pshu6809_04    ENDP



;
; CC,B
;
pshu6809_05    PROC    near
               mov     bx,[R6809_USP]
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_05    ENDP



;
; B,A
;
pshu6809_06    PROC    near
               mov     bx,[R6809_USP]
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_06    ENDP



;
; B,A,CC
;
pshu6809_07    PROC    near
               mov     bx,[R6809_USP]
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_07    ENDP



;
; DP
;
pshu6809_08    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pshu6809_08    ENDP



;
; DP,CC
;
pshu6809_09    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_09    ENDP



;
; DP,A
;
pshu6809_0A    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_0A    ENDP



;
; DP,A,CC
;
pshu6809_0B    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_0B    ENDP



;
; DP,B
;
pshu6809_0C    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_0C    ENDP



;
; DP,B,CC
;
pshu6809_0D    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_0D    ENDP



;
; DP,B,A
;
pshu6809_0E    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_0E    ENDP



;
; DP,B,A,CC
;
pshu6809_0F    PROC    near
               mov     bx,[R6809_USP]
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_0F    ENDP






;*************************************
;
;             0x10
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_10    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_10    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_11    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_11    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_12    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_12    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_13    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_13    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_14    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_14    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_15    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_15    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_16    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_16    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_17    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_17    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_18    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_18    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_19    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_19    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_1A    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_1A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_1B    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_1B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_1C    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_1C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_1D    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_1D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_1E    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_1E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_1F    PROC    near
               mov     bx,[R6809_USP]
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_1F    ENDP






;*************************************
;
;             0x20
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_20    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_20    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_21    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_21    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_22    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_22    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_23    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_23    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_24    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_24    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_25    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_25    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_26    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_26    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_27    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_27    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_28    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_28    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_29    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_29    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_2A    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_2A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_2B    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_2B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_2C    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_2C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_2D    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_2D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_2E    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_2E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_2F    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_2F    ENDP






;*************************************
;
;             0x30
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_30    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_30    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_31    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_31    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_32    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_32    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_33    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_33    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_34    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_34    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_35    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_35    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_36    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_36    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_37    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_37    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_38    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_38    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_39    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_39    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_3A    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_3A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_3B    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_3B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_3C    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_3C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_3D    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_3D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_3E    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_3E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_3F    PROC    near
               mov     bx,[R6809_USP]
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_3F    ENDP






;*************************************
;
;             0x40
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_40    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_40    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_41    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_41    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_42    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_42    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_43    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_43    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_44    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_44    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_45    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_45    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_46    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_46    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_47    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_47    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_48    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_48    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_49    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_49    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_4A    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_4A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_4B    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_4B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_4C    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_4C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_4D    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_4D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_4E    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_4E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_4F    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_4F    ENDP






;*************************************
;
;             0x50
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_50    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_50    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_51    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_51    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_52    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_52    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_53    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_53    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_54    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_54    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_55    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_55    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_56    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_56    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_57    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_57    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_58    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_58    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_59    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_59    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_5A    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_5A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_5B    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_5B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_5C    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_5C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_5D    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_5D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_5E    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_5E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_5F    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_5F    ENDP






;*************************************
;
;             0x60
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_60    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_60    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_61    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_61    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_62    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_62    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_63    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_63    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_64    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_64    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_65    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_65    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_66    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_66    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_67    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_67    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_68    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_68    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_69    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_69    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_6A    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_6A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_6B    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_6B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_6C    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_6C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_6D    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_6D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_6E    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_6E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_6F    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_6F    ENDP






;*************************************
;
;             0x70
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_70    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_70    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_71    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_71    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_72    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_72    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_73    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_73    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_74    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_74    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_75    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_75    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_76    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_76    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_77    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_77    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_78    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_78    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_79    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_79    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_7A    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_7A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_7B    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_7B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_7C    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_7C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_7D    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_7D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_7E    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_7E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_7F    PROC    near
               mov     bx,[R6809_USP]
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_7F    ENDP






;*************************************
;
;             0x80
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_80    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pshu6809_80    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_81    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_81    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_82    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_82    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_83    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_83    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_84    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_84    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_85    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_85    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_86    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_86    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_87    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_87    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_88    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pshu6809_88    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_89    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_89    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_8A    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_8A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_8B    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_8B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_8C    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_8C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_8D    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_8D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_8E    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_8E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_8F    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_8F    ENDP






;*************************************
;
;             0x90
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_90    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_90    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_91    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_91    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_92    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_92    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_93    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_93    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_94    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_94    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_95    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_95    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_96    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_96    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_97    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_97    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_98    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_98    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_99    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_99    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_9A    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_9A    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_9B    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_9B    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_9C    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_9C    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_9D    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_9D    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_9E    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_9E    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_9F    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_9F    ENDP





;*************************************
;
;             0xA0
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A0    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_A0    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A1    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_A1    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A2    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_A2    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A3    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_A3    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A4    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_A4    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A5    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_A5    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A6    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_A6    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A7    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_A7    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A8    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_A8    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_A9    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_A9    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_AA    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_AA    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_AB    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_AB    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_AC    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_AC    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_AD    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_AD    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_AE    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_AE    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_AF    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_AF    ENDP






;*************************************
;
;             0xB0
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B0    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_B0    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B1    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_B1    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B2    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_B2    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B3    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_B3    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B4    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_B4    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B5    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_B5    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B6    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_B6    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B7    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_B7    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B8    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_B8    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_B9    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_B9    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_BA    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_BA    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_BB    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_BB    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_BC    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_BC    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_BD    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_BD    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_BE    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_BE    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_BF    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_BF    ENDP






;*************************************
;
;             0xC0
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C0    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pshu6809_C0    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C1    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_C1    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C2    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_C2    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C3    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_C3    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C4    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_C4    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C5    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_C5    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C6    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_C6    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C7    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_C7    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C8    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pshu6809_C8    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_C9    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_C9    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_CA    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_CA    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_CB    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_CB    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_CC    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_CC    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_CD    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_CD    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_CE    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_CE    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_CF    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_CF    ENDP






;*************************************
;
;             0xD0
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D0    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_D0    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D1    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_D1    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D2    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_D2    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D3    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_D3    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D4    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_D4    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D5    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_D5    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D6    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_D6    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D7    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_D7    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D8    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_D8    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_D9    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_D9    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_DA    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_DA    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_DB    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_DB    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_DC    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_DC    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_DD    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_DD    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_DE    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_DE    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_DF    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_DF    ENDP






;*************************************
;
;             0xE0
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E0    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pshu6809_E0    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E1    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_E1    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E2    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_E2    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E3    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_E3    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E4    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_E4    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E5    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_E5    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E6    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_E6    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E7    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_E7    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E8    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pshu6809_E8    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_E9    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_E9    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_EA    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_EA    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_EB    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_EB    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_EC    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_EC    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_ED    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_ED    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_EE    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_EE    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_EF    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_EF    ENDP






;*************************************
;
;             0xF0
;
;*************************************

;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F0    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pshu6809_F0    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F1    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_F1    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F2    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_F2    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F3    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_F3    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F4    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_F4    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F5    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_F5    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F6    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_F6    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F7    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pshu6809_F7    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F8    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pshu6809_F8    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_F9    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_F9    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_FA    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_FA    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_FB    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pshu6809_FB    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_FC    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pshu6809_FC    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_FD    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pshu6809_FD    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_FE    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pshu6809_FE    ENDP



;
; PC,U,Y,X,DP,B,A,CC
;
pshu6809_FF    PROC    near
               mov     bx,[R6809_USP]
               mpush_pc
               mpush_s
               mpush_y
               mpush_x
               mpush_dp
               mpush_b
               mpush_a
               mpush_cc
               mov     [R6809_USP],bx
               mov     ax,0x0c
               ret
pshu6809_FF    ENDP



_PSHU6809_TEXT ends






_PSHU6809_DATA segment byte public 'DATA'
               assume  DS:_PSHU6809_DATA

_Pshu6809JumpTable dd  pshu6809_00
                   dd  pshu6809_01
                   dd  pshu6809_02
                   dd  pshu6809_03
                   dd  pshu6809_04
                   dd  pshu6809_05
                   dd  pshu6809_06
                   dd  pshu6809_07
                   dd  pshu6809_08
                   dd  pshu6809_09
                   dd  pshu6809_0A
                   dd  pshu6809_0B
                   dd  pshu6809_0C
                   dd  pshu6809_0D
                   dd  pshu6809_0E
                   dd  pshu6809_0F
;10
                   dd  pshu6809_10
                   dd  pshu6809_11
                   dd  pshu6809_12
                   dd  pshu6809_13
                   dd  pshu6809_14
                   dd  pshu6809_15
                   dd  pshu6809_16
                   dd  pshu6809_17
                   dd  pshu6809_18
                   dd  pshu6809_19
                   dd  pshu6809_1A
                   dd  pshu6809_1B
                   dd  pshu6809_1C
                   dd  pshu6809_1D
                   dd  pshu6809_1E
                   dd  pshu6809_1F
;20
                   dd  pshu6809_20
                   dd  pshu6809_21
                   dd  pshu6809_22
                   dd  pshu6809_23
                   dd  pshu6809_24
                   dd  pshu6809_25
                   dd  pshu6809_26
                   dd  pshu6809_27
                   dd  pshu6809_28
                   dd  pshu6809_29
                   dd  pshu6809_2A
                   dd  pshu6809_2B
                   dd  pshu6809_2C
                   dd  pshu6809_2D
                   dd  pshu6809_2E
                   dd  pshu6809_2F
;30
                   dd  pshu6809_30
                   dd  pshu6809_31
                   dd  pshu6809_32
                   dd  pshu6809_33
                   dd  pshu6809_34
                   dd  pshu6809_35
                   dd  pshu6809_36
                   dd  pshu6809_37
                   dd  pshu6809_38
                   dd  pshu6809_39
                   dd  pshu6809_3A
                   dd  pshu6809_3B
                   dd  pshu6809_3C
                   dd  pshu6809_3D
                   dd  pshu6809_3E
                   dd  pshu6809_3F
;40
                   dd  pshu6809_40
                   dd  pshu6809_41
                   dd  pshu6809_42
                   dd  pshu6809_43
                   dd  pshu6809_44
                   dd  pshu6809_45
                   dd  pshu6809_46
                   dd  pshu6809_47
                   dd  pshu6809_48
                   dd  pshu6809_49
                   dd  pshu6809_4A
                   dd  pshu6809_4B
                   dd  pshu6809_4C
                   dd  pshu6809_4D
                   dd  pshu6809_4E
                   dd  pshu6809_4F
;50
                   dd  pshu6809_50
                   dd  pshu6809_51
                   dd  pshu6809_52
                   dd  pshu6809_53
                   dd  pshu6809_54
                   dd  pshu6809_55
                   dd  pshu6809_56
                   dd  pshu6809_57
                   dd  pshu6809_58
                   dd  pshu6809_59
                   dd  pshu6809_5A
                   dd  pshu6809_5B
                   dd  pshu6809_5C
                   dd  pshu6809_5D
                   dd  pshu6809_5E
                   dd  pshu6809_5F
;60
                   dd  pshu6809_60
                   dd  pshu6809_61
                   dd  pshu6809_62
                   dd  pshu6809_63
                   dd  pshu6809_64
                   dd  pshu6809_65
                   dd  pshu6809_66
                   dd  pshu6809_67
                   dd  pshu6809_68
                   dd  pshu6809_69
                   dd  pshu6809_6A
                   dd  pshu6809_6B
                   dd  pshu6809_6C
                   dd  pshu6809_6D
                   dd  pshu6809_6E
                   dd  pshu6809_6F
;70
                   dd  pshu6809_70
                   dd  pshu6809_71
                   dd  pshu6809_72
                   dd  pshu6809_73
                   dd  pshu6809_74
                   dd  pshu6809_75
                   dd  pshu6809_76
                   dd  pshu6809_77
                   dd  pshu6809_78
                   dd  pshu6809_79
                   dd  pshu6809_7A
                   dd  pshu6809_7B
                   dd  pshu6809_7C
                   dd  pshu6809_7D
                   dd  pshu6809_7E
                   dd  pshu6809_7F
;80
                   dd  pshu6809_80
                   dd  pshu6809_81
                   dd  pshu6809_82
                   dd  pshu6809_83
                   dd  pshu6809_84
                   dd  pshu6809_85
                   dd  pshu6809_86
                   dd  pshu6809_87
                   dd  pshu6809_88
                   dd  pshu6809_89
                   dd  pshu6809_8A
                   dd  pshu6809_8B
                   dd  pshu6809_8C
                   dd  pshu6809_8D
                   dd  pshu6809_8E
                   dd  pshu6809_8F
;90
                   dd  pshu6809_90
                   dd  pshu6809_91
                   dd  pshu6809_92
                   dd  pshu6809_93
                   dd  pshu6809_94
                   dd  pshu6809_95
                   dd  pshu6809_96
                   dd  pshu6809_97
                   dd  pshu6809_98
                   dd  pshu6809_99
                   dd  pshu6809_9A
                   dd  pshu6809_9B
                   dd  pshu6809_9C
                   dd  pshu6809_9D
                   dd  pshu6809_9E
                   dd  pshu6809_9F
;A0
                   dd  pshu6809_A0
                   dd  pshu6809_A1
                   dd  pshu6809_A2
                   dd  pshu6809_A3
                   dd  pshu6809_A4
                   dd  pshu6809_A5
                   dd  pshu6809_A6
                   dd  pshu6809_A7
                   dd  pshu6809_A8
                   dd  pshu6809_A9
                   dd  pshu6809_AA
                   dd  pshu6809_AB
                   dd  pshu6809_AC
                   dd  pshu6809_AD
                   dd  pshu6809_AE
                   dd  pshu6809_AF
;B0
                   dd  pshu6809_B0
                   dd  pshu6809_B1
                   dd  pshu6809_B2
                   dd  pshu6809_B3
                   dd  pshu6809_B4
                   dd  pshu6809_B5
                   dd  pshu6809_B6
                   dd  pshu6809_B7
                   dd  pshu6809_B8
                   dd  pshu6809_B9
                   dd  pshu6809_BA
                   dd  pshu6809_BB
                   dd  pshu6809_BC
                   dd  pshu6809_BD
                   dd  pshu6809_BE
                   dd  pshu6809_BF
;C0
                   dd  pshu6809_C0
                   dd  pshu6809_C1
                   dd  pshu6809_C2
                   dd  pshu6809_C3
                   dd  pshu6809_C4
                   dd  pshu6809_C5
                   dd  pshu6809_C6
                   dd  pshu6809_C7
                   dd  pshu6809_C8
                   dd  pshu6809_C9
                   dd  pshu6809_CA
                   dd  pshu6809_CB
                   dd  pshu6809_CC
                   dd  pshu6809_CD
                   dd  pshu6809_CE
                   dd  pshu6809_CF
;D0
                   dd  pshu6809_D0
                   dd  pshu6809_D1
                   dd  pshu6809_D2
                   dd  pshu6809_D3
                   dd  pshu6809_D4
                   dd  pshu6809_D5
                   dd  pshu6809_D6
                   dd  pshu6809_D7
                   dd  pshu6809_D8
                   dd  pshu6809_D9
                   dd  pshu6809_DA
                   dd  pshu6809_DB
                   dd  pshu6809_DC
                   dd  pshu6809_DD
                   dd  pshu6809_DE
                   dd  pshu6809_DF
;E0
                   dd  pshu6809_E0
                   dd  pshu6809_E1
                   dd  pshu6809_E2
                   dd  pshu6809_E3
                   dd  pshu6809_E4
                   dd  pshu6809_E5
                   dd  pshu6809_E6
                   dd  pshu6809_E7
                   dd  pshu6809_E8
                   dd  pshu6809_E9
                   dd  pshu6809_EA
                   dd  pshu6809_EB
                   dd  pshu6809_EC
                   dd  pshu6809_ED
                   dd  pshu6809_EE
                   dd  pshu6809_EF
;F0
                   dd  pshu6809_F0
                   dd  pshu6809_F1
                   dd  pshu6809_F2
                   dd  pshu6809_F3
                   dd  pshu6809_F4
                   dd  pshu6809_F5
                   dd  pshu6809_F6
                   dd  pshu6809_F7
                   dd  pshu6809_F8
                   dd  pshu6809_F9
                   dd  pshu6809_FA
                   dd  pshu6809_FB
                   dd  pshu6809_FC
                   dd  pshu6809_FD
                   dd  pshu6809_FE
                   dd  pshu6809_FF

public _Pshu6809JumpTable



_PSHU6809_DATA ends



end

