;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator code PULS instruction code                   *
;*                                                                           *
;*   File Name  : PULS6809.ASM                                               *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the code to emulate the PULS instruction*
;*                a jump table is used to decode the register combinations   *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    22/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    06/08/96  K.W  Public release of DVE 1.0                       *
;*                                                                           *
;*****************************************************************************

extern _f6809AddressRead:near
extern _f6809AddressWrite:near
extern _apfWriteHandlers:near
extern _apfReadHandlers:near
extern _Idx6809JumpTable:near
extern f6809cctodl_:near
extern f6809dltocc_:near

include "reg6809.h"
include "mac6809.h"

_PULS6809_TEXT segment dword public 'CODE'
               assume  CS:_PULS6809_TEXT



;
; Define local PULL macros
;
mpull_cc MACRO
   m_fetch08
   inc     bx
   call    f6809dltocc_
ENDM

mpull_a MACRO
  m_fetch08
  inc     bx
  mov     [R6809_A],dl
ENDM

mpull_b MACRO
  m_fetch08
  inc     bx
  mov     [R6809_B],dl
ENDM

mpull_dp MACRO
  m_fetch08
  inc     bx
  mov     [R6809_DP],dl
ENDM

mpull_x MACRO
  m_fetch08
  inc     bx
  mov     [R6809_X+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_X],dl
ENDM

mpull_y MACRO
  m_fetch08
  inc     bx
  mov     [R6809_Y+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_Y],dl
ENDM

mpull_u MACRO
  m_fetch08
  inc     bx
  mov     [R6809_USP+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_USP],dl
ENDM

mpull_pc MACRO
  m_fetch08
  inc     bx
  mov     [R6809_PC+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_PC],dl
ENDM




; Template
;
; CC,A,B,DP,X,Y,U,PC
;
;puls6809_xx    PROC    near
;               mov     bx,[R6809_HSP]
;               mpull_cc
;               mpull_a
;               mpull_b
;               mpull_dp
;               mpull_x
;               mpull_y
;               mpull_u
;               mpull_pc
;               mov     [R6809_HSP],bx
;               mov     ax,0x0ZZ
;               ret
;puls6809_xx    ENDP






;
; CPU Exception
;
puls6809_EX    PROC    near

               add     sp,4               ; Remove return address
               mov     ax,CPU_EXCEPTION
               m_exit
               ret

puls6809_EX    ENDP








;
;
; START OF CODE
;
; Note AX always returns number of cycles.
;



;*************************************
;
;             0x00
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_00    PROC    near
               mov     ax,0x00
               ret
puls6809_00    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_01    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mov     [R6809_HSP],bx
               mov     ax,0x01
               ret
puls6809_01    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_02    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mov     [R6809_HSP],bx
               mov     ax,0x01
               ret
puls6809_02    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_03    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_03    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_04    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mov     [R6809_HSP],bx
               mov     ax,0x01
               ret
puls6809_04    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_05    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_05    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_06    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_06    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_07    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_07    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_08    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x01
               ret
puls6809_08    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_09    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_09    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_0A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_0A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_0B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_0B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_0C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_0C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_0D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_0D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_0E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_0E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_0F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_0F    ENDP







;*************************************
;
;             0x10
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_10    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_10    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_11    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_11    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_12    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_12    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_13    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_13    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_14    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_14    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_15    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_15    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_16    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_16    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_17    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_17    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_18    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_18    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_19    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_19    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_1A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_1A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_1B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_1B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_1C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_1C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_1D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_1D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_1E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_1E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_1F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_1F    ENDP








;*************************************
;
;             0x20
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_20    PROC    near
               mov     bx,[R6809_HSP]
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_20    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_21    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_21    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_22    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_22    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_23    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_23    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_24    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_24    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_25    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_25    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_26    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_26    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_27    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_27    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_28    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_28    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_29    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_29    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_2A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_2A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_2B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_2B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_2C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_2C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_2D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_2D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_2E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_2E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_2F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_2F    ENDP








;*************************************
;
;             0x30
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_30    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_30    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_31    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_31    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_32    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_32    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_33    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_33    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_34    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_34    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_35    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_35    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_36    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_36    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_37    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_37    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_38    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_38    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_39    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_39    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_3A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_3A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_3B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_3B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_3C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_3C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_3D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_3D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_3E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_3E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_3F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_3F    ENDP








;*************************************
;
;             0x40
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_40    PROC    near
               mov     bx,[R6809_HSP]
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_40    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_41    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_41    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_42    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_42    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_43    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_43    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_44    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_44    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_45    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_45    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_46    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_46    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_47    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_47    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_48    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_48    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_49    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_49    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_4A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_4A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_4B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_4B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_4C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_4C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_4D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_4D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_4E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_4E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_4F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_4F    ENDP








;*************************************
;
;             0x50
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_50    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_50    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_51    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_51    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_52    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_52    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_53    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_53    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_54    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_54    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_55    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_55    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_56    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_56    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_57    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_57    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_58    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_58    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_59    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_59    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_5A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_5A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_5B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_5B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_5C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_5C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_5D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_5D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_5E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_5E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_5F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_5F    ENDP








;*************************************
;
;             0x60
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_60    PROC    near
               mov     bx,[R6809_HSP]
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_60    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_61    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_61    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_62    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_62    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_63    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_63    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_64    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_64    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_65    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_65    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_66    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_66    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_67    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_67    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_68    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_68    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_69    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_69    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_6A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_6A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_6B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_6B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_6C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_6C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_6D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_6D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_6E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_6E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_6F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_6F    ENDP








;*************************************
;
;             0x70
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_70    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_70    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_71    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_71    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_72    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_72    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_73    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_73    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_74    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_74    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_75    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_75    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_76    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_76    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_77    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_77    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_78    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_78    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_79    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_79    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_7A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_7A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_7B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_7B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_7C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_7C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_7D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_7D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_7E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_7E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_7F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mov     [R6809_HSP],bx
               mov     ax,0x0A
               ret
puls6809_7F    ENDP








;*************************************
;
;             0x80
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_80    PROC    near
               mov     bx,[R6809_HSP]
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x02
               ret
puls6809_80    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
               PUBLIC  puls6809_81_

puls6809_81_   PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_81_   ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_82    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_82    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_83    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_83    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_84    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_84    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_85    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_85    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_86    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_86    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_87    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_87    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_88    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x03
               ret
puls6809_88    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_89    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_89    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_8A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_8A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_8B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_8B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_8C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_8C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_8D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_8D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_8E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_8E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_8F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_8F    ENDP








;*************************************
;
;             0x90
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_90    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_90    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_91    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_91    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_92    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_92    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_93    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_93    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_94    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_94    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_95    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_95    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_96    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_96    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_97    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_97    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_98    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_98    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_99    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_99    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_9A    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_9A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_9B    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_9B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_9C    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_9C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_9D    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_9D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_9E    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_9E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_9F    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_9F    ENDP








;*************************************
;
;             0xA0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A0    PROC    near
               mov     bx,[R6809_HSP]
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_A0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A1    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_A1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A2    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_A2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A3    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_A3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A4    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_A4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A5    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_A5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A6    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_A6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A7    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_A7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A8    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_A8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_A9    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_A9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_AA    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_AA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_AB    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_AB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_AC    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_AC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_AD    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_AD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_AE    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_AE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_AF    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_AF    ENDP








;*************************************
;
;             0xB0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B0    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_B0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B1    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_B1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B2    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_B2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B3    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_B3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B4    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_B4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B5    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_B5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B6    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_B6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B7    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_B7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B8    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_B8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_B9    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_B9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_BA    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_BA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_BB    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_BB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_BC    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_BC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_BD    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_BD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_BE    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_BE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_BF    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_BF    ENDP








;*************************************
;
;             0xC0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C0    PROC    near
               mov     bx,[R6809_HSP]
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x04
               ret
puls6809_C0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C1    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_C1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C2    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_C2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C3    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_C3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C4    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_C4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C5    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_C5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C6    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_C6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C7    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_C7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C8    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x05
               ret
puls6809_C8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_C9    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_C9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_CA    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_CA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_CB    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_CB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_CC    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_CC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_CD    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_CD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_CE    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_CE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_CF    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_CF    ENDP








;*************************************
;
;             0xD0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D0    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_D0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D1    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_D1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D2    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_D2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D3    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_D3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D4    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_D4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D5    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_D5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D6    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_D6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D7    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_D7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D8    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_D8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_D9    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_D9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_DA    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_DA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_DB    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_DB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_DC    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_DC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_DD    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_DD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_DE    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_DE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_DF    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_DF    ENDP








;*************************************
;
;             0xE0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E0    PROC    near
               mov     bx,[R6809_HSP]
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x06
               ret
puls6809_E0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E1    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_E1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E2    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_E2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E3    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_E3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E4    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_E4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E5    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_E5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E6    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_E6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E7    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_E7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E8    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x07
               ret
puls6809_E8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_E9    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_E9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_EA    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_EA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_EB    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_EB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_EC    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_EC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_ED    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_ED    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_EE    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_EE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_EF    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_EF    ENDP







;*************************************
;
;             0xF0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F0    PROC    near
               mov     bx,[R6809_HSP]
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x08
               ret
puls6809_F0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F1    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_F1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F2    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_F2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F3    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_F3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F4    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_F4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F5    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_F5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F6    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_F6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F7    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0b
               ret
puls6809_F7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F8    PROC    near
               mov     bx,[R6809_HSP]
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x09
               ret
puls6809_F8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_F9    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_F9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_FA    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_FA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_FB    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0b
               ret
puls6809_FB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_FC    PROC    near
               mov     bx,[R6809_HSP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0a
               ret
puls6809_FC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_FD    PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0b
               ret
puls6809_FD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
puls6809_FE    PROC    near
               mov     bx,[R6809_HSP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0b
               ret
puls6809_FE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
               PUBLIC  puls6809_FF_

puls6809_FF_   PROC    near
               mov     bx,[R6809_HSP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_u
               mpull_pc
               mov     [R6809_HSP],bx
               mov     ax,0x0c
               ret
puls6809_FF_   ENDP







_PULS6809_TEXT ends






_PULS6809_DATA segment byte public 'DATA'
               assume  DS:_PULS6809_DATA

_Puls6809JumpTable dd  puls6809_00
                   dd  puls6809_01
                   dd  puls6809_02
                   dd  puls6809_03
                   dd  puls6809_04
                   dd  puls6809_05
                   dd  puls6809_06
                   dd  puls6809_07
                   dd  puls6809_08
                   dd  puls6809_09
                   dd  puls6809_0A
                   dd  puls6809_0B
                   dd  puls6809_0C
                   dd  puls6809_0D
                   dd  puls6809_0E
                   dd  puls6809_0F
;10
                   dd  puls6809_10
                   dd  puls6809_11
                   dd  puls6809_12
                   dd  puls6809_13
                   dd  puls6809_14
                   dd  puls6809_15
                   dd  puls6809_16
                   dd  puls6809_17
                   dd  puls6809_18
                   dd  puls6809_19
                   dd  puls6809_1A
                   dd  puls6809_1B
                   dd  puls6809_1C
                   dd  puls6809_1D
                   dd  puls6809_1E
                   dd  puls6809_1F
;20
                   dd  puls6809_20
                   dd  puls6809_21
                   dd  puls6809_22
                   dd  puls6809_23
                   dd  puls6809_24
                   dd  puls6809_25
                   dd  puls6809_26
                   dd  puls6809_27
                   dd  puls6809_28
                   dd  puls6809_29
                   dd  puls6809_2A
                   dd  puls6809_2B
                   dd  puls6809_2C
                   dd  puls6809_2D
                   dd  puls6809_2E
                   dd  puls6809_2F
;30
                   dd  puls6809_30
                   dd  puls6809_31
                   dd  puls6809_32
                   dd  puls6809_33
                   dd  puls6809_34
                   dd  puls6809_35
                   dd  puls6809_36
                   dd  puls6809_37
                   dd  puls6809_38
                   dd  puls6809_39
                   dd  puls6809_3A
                   dd  puls6809_3B
                   dd  puls6809_3C
                   dd  puls6809_3D
                   dd  puls6809_3E
                   dd  puls6809_3F
;40
                   dd  puls6809_40
                   dd  puls6809_41
                   dd  puls6809_42
                   dd  puls6809_43
                   dd  puls6809_44
                   dd  puls6809_45
                   dd  puls6809_46
                   dd  puls6809_47
                   dd  puls6809_48
                   dd  puls6809_49
                   dd  puls6809_4A
                   dd  puls6809_4B
                   dd  puls6809_4C
                   dd  puls6809_4D
                   dd  puls6809_4E
                   dd  puls6809_4F
;50
                   dd  puls6809_50
                   dd  puls6809_51
                   dd  puls6809_52
                   dd  puls6809_53
                   dd  puls6809_54
                   dd  puls6809_55
                   dd  puls6809_56
                   dd  puls6809_57
                   dd  puls6809_58
                   dd  puls6809_59
                   dd  puls6809_5A
                   dd  puls6809_5B
                   dd  puls6809_5C
                   dd  puls6809_5D
                   dd  puls6809_5E
                   dd  puls6809_5F
;60
                   dd  puls6809_60
                   dd  puls6809_61
                   dd  puls6809_62
                   dd  puls6809_63
                   dd  puls6809_64
                   dd  puls6809_65
                   dd  puls6809_66
                   dd  puls6809_67
                   dd  puls6809_68
                   dd  puls6809_69
                   dd  puls6809_6A
                   dd  puls6809_6B
                   dd  puls6809_6C
                   dd  puls6809_6D
                   dd  puls6809_6E
                   dd  puls6809_6F
;70
                   dd  puls6809_70
                   dd  puls6809_71
                   dd  puls6809_72
                   dd  puls6809_73
                   dd  puls6809_74
                   dd  puls6809_75
                   dd  puls6809_76
                   dd  puls6809_77
                   dd  puls6809_78
                   dd  puls6809_79
                   dd  puls6809_7A
                   dd  puls6809_7B
                   dd  puls6809_7C
                   dd  puls6809_7D
                   dd  puls6809_7E
                   dd  puls6809_7F
;80
                   dd  puls6809_80
                   dd  puls6809_81_
                   dd  puls6809_82
                   dd  puls6809_83
                   dd  puls6809_84
                   dd  puls6809_85
                   dd  puls6809_86
                   dd  puls6809_87
                   dd  puls6809_88
                   dd  puls6809_89
                   dd  puls6809_8A
                   dd  puls6809_8B
                   dd  puls6809_8C
                   dd  puls6809_8D
                   dd  puls6809_8E
                   dd  puls6809_8F
;90
                   dd  puls6809_90
                   dd  puls6809_91
                   dd  puls6809_92
                   dd  puls6809_93
                   dd  puls6809_94
                   dd  puls6809_95
                   dd  puls6809_96
                   dd  puls6809_97
                   dd  puls6809_98
                   dd  puls6809_99
                   dd  puls6809_9A
                   dd  puls6809_9B
                   dd  puls6809_9C
                   dd  puls6809_9D
                   dd  puls6809_9E
                   dd  puls6809_9F
;A0
                   dd  puls6809_A0
                   dd  puls6809_A1
                   dd  puls6809_A2
                   dd  puls6809_A3
                   dd  puls6809_A4
                   dd  puls6809_A5
                   dd  puls6809_A6
                   dd  puls6809_A7
                   dd  puls6809_A8
                   dd  puls6809_A9
                   dd  puls6809_AA
                   dd  puls6809_AB
                   dd  puls6809_AC
                   dd  puls6809_AD
                   dd  puls6809_AE
                   dd  puls6809_AF
;B0
                   dd  puls6809_B0
                   dd  puls6809_B1
                   dd  puls6809_B2
                   dd  puls6809_B3
                   dd  puls6809_B4
                   dd  puls6809_B5
                   dd  puls6809_B6
                   dd  puls6809_B7
                   dd  puls6809_B8
                   dd  puls6809_B9
                   dd  puls6809_BA
                   dd  puls6809_BB
                   dd  puls6809_BC
                   dd  puls6809_BD
                   dd  puls6809_BE
                   dd  puls6809_BF
;C0
                   dd  puls6809_C0
                   dd  puls6809_C1
                   dd  puls6809_C2
                   dd  puls6809_C3
                   dd  puls6809_C4
                   dd  puls6809_C5
                   dd  puls6809_C6
                   dd  puls6809_C7
                   dd  puls6809_C8
                   dd  puls6809_C9
                   dd  puls6809_CA
                   dd  puls6809_CB
                   dd  puls6809_CC
                   dd  puls6809_CD
                   dd  puls6809_CE
                   dd  puls6809_CF
;D0
                   dd  puls6809_D0
                   dd  puls6809_D1
                   dd  puls6809_D2
                   dd  puls6809_D3
                   dd  puls6809_D4
                   dd  puls6809_D5
                   dd  puls6809_D6
                   dd  puls6809_D7
                   dd  puls6809_D8
                   dd  puls6809_D9
                   dd  puls6809_DA
                   dd  puls6809_DB
                   dd  puls6809_DC
                   dd  puls6809_DD
                   dd  puls6809_DE
                   dd  puls6809_DF
;E0
                   dd  puls6809_E0
                   dd  puls6809_E1
                   dd  puls6809_E2
                   dd  puls6809_E3
                   dd  puls6809_E4
                   dd  puls6809_E5
                   dd  puls6809_E6
                   dd  puls6809_E7
                   dd  puls6809_E8
                   dd  puls6809_E9
                   dd  puls6809_EA
                   dd  puls6809_EB
                   dd  puls6809_EC
                   dd  puls6809_ED
                   dd  puls6809_EE
                   dd  puls6809_EF
;F0
                   dd  puls6809_F0
                   dd  puls6809_F1
                   dd  puls6809_F2
                   dd  puls6809_F3
                   dd  puls6809_F4
                   dd  puls6809_F5
                   dd  puls6809_F6
                   dd  puls6809_F7
                   dd  puls6809_F8
                   dd  puls6809_F9
                   dd  puls6809_FA
                   dd  puls6809_FB
                   dd  puls6809_FC
                   dd  puls6809_FD
                   dd  puls6809_FE
                   dd  puls6809_FF_

public _Puls6809JumpTable



_PULS6809_DATA ends



end

